/*
 * Decompiled with CFR 0.152.
 */
package com.simba.googlebigquery.dsi.core.utilities.impl.future;

import com.simba.googlebigquery.dsi.core.utilities.future.NonTrivialJDBCConversions;
import com.simba.googlebigquery.dsi.core.utilities.impl.future.NumericJDBCDataSource;
import com.simba.googlebigquery.dsi.exceptions.ConversionFailed;
import com.simba.googlebigquery.dsi.exceptions.IncorrectTypeException;
import com.simba.googlebigquery.support.IWarningListener;
import com.simba.googlebigquery.support.exceptions.ErrorException;
import java.math.BigDecimal;
import java.sql.SQLException;

public abstract class FloatJDBCDataSource
extends NumericJDBCDataSource {
    public FloatJDBCDataSource(IWarningListener iWarningListener) {
        super(iWarningListener);
    }

    protected final void handleConversionResult(float f, String string) throws ConversionFailed {
        switch (this.getListener().getStatus()) {
            case SUCCESS: {
                break;
            }
            case FRACTIONAL_TRUNCATION: {
                this.onFractionalTruncation(Float.valueOf(f), 0, string);
                break;
            }
            case OVERFLOW: {
                this.onOverflow(Float.valueOf(f), string);
            }
        }
    }

    @Override
    public Float get() throws ErrorException {
        try {
            float f = this.getFloat();
            if (f == 0.0f && this.wasNull()) {
                return null;
            }
            return Float.valueOf(f);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public String getString() throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
        float f = this.getFloat();
        if (f == 0.0f && this.wasNull()) {
            return null;
        }
        return Float.toString(f);
    }

    @Override
    public boolean getBoolean() throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
        return this.getFloat() != 0.0f;
    }

    @Override
    public byte getByte() throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
        float f = this.getFloat();
        byte by = NonTrivialJDBCConversions.DoubleConverter.toByte(f, this.getAndClearListener());
        this.handleConversionResult(f, "getByte");
        return by;
    }

    @Override
    public short getShort() throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
        float f = this.getFloat();
        short s = NonTrivialJDBCConversions.DoubleConverter.toShort(f, this.getAndClearListener());
        this.handleConversionResult(f, "getShort");
        return s;
    }

    @Override
    public int getInt() throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
        float f = this.getFloat();
        int n = NonTrivialJDBCConversions.DoubleConverter.toInt(f, this.getAndClearListener());
        this.handleConversionResult(f, "getInt");
        return n;
    }

    @Override
    public long getLong() throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
        float f = this.getFloat();
        long l = NonTrivialJDBCConversions.DoubleConverter.toLong(f, this.getAndClearListener());
        this.handleConversionResult(f, "getLong");
        return l;
    }

    @Override
    public abstract float getFloat() throws ErrorException, SQLException;

    @Override
    public double getDouble() throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
        return this.getFloat();
    }

    @Override
    public BigDecimal getBigDecimal() throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
        float f = this.getFloat();
        if (f == 0.0f && this.wasNull()) {
            return null;
        }
        return BigDecimal.valueOf(f);
    }
}

