/*
 * Decompiled with CFR 0.152.
 */
package com.simba.googlebigquery.dsi.core.utilities.future;

import com.simba.googlebigquery.dsi.core.utilities.future.IntervalConverter;
import com.simba.googlebigquery.dsi.dataengine.utilities.DSIMonthSpan;
import com.simba.googlebigquery.dsi.dataengine.utilities.DSITimeSpan;
import com.simba.googlebigquery.dsi.dataengine.utilities.TimeTz;
import com.simba.googlebigquery.dsi.dataengine.utilities.TimestampTz;
import com.simba.googlebigquery.dsi.exceptions.ConversionFailed;
import com.simba.googlebigquery.dsi.exceptions.IncorrectTypeException;
import com.simba.googlebigquery.dsi.utilities.StringConverter;
import com.simba.googlebigquery.support.IWarningListener;
import com.simba.googlebigquery.support.exceptions.ErrorException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.UUID;

public final class NonTrivialJDBCConversions {
    private static final char[] HEX_ARRAY = "0123456789ABCDEF".toCharArray();
    private static final char[] s_dateStringTemplate = "------0000-00-00".toCharArray();
    private static final char[] s_timeStringTemplate = "00:00:00.000".toCharArray();
    private static final char[] s_timestampStringTemplate = "------0000-00-00 00:00:00.000000000".toCharArray();
    private static Map<String, String> s_doubleNormalizationMap = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
    private static final int MILLIS_PER_NANO = 1000000;

    public static void bytesToHexChars(byte[] byArray, int n, char[] cArray, int n2) {
        assert (n >= 0);
        assert (n <= byArray.length);
        assert (cArray.length - n2 >= n * 2);
        for (int i = 0; i < n; ++i) {
            int n3 = byArray[i] & 0xFF;
            cArray[n2 + i * 2] = HEX_ARRAY[n3 >>> 4];
            cArray[n2 + (i * 2 + 1)] = HEX_ARRAY[n3 & 0xF];
        }
    }

    public static String bytesToHex(byte[] byArray) {
        char[] cArray = new char[byArray.length * 2];
        NonTrivialJDBCConversions.bytesToHexChars(byArray, byArray.length, cArray, 0);
        return new String(cArray);
    }

    public static String dateToString(Date date) {
        return NonTrivialJDBCConversions.dateToString(date, null);
    }

    public static String dateToString(Date date, Calendar calendar) {
        assert (date != null);
        if (calendar == null) {
            calendar = Calendar.getInstance();
        }
        boolean bl = date.getTime() < NonTrivialJDBCConversions.getZeroTimeAD(calendar);
        calendar.setTime(date);
        char[] cArray = (char[])s_dateStringTemplate.clone();
        int n = NonTrivialJDBCConversions.writeDateToCharArray(cArray, 1, calendar.get(1), calendar.get(2) + 1, calendar.get(5));
        if (bl) {
            --n;
        }
        return new String(cArray, n, cArray.length - n);
    }

    public static Timestamp dateToTimestamp(Date date, Calendar calendar) {
        assert (date != null);
        if (calendar == null) {
            calendar = Calendar.getInstance();
        }
        calendar.setTimeInMillis(date.getTime());
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return new Timestamp(calendar.getTimeInMillis());
    }

    public static String timeToString(Time time, Calendar calendar, int n) {
        assert (time != null);
        assert (n >= 0);
        n = Math.min(n, 3);
        if (time instanceof TimeTz) {
            time = ((TimeTz)time).getAdjustedTime();
        }
        if (calendar == null) {
            calendar = Calendar.getInstance();
        }
        calendar.clear();
        calendar.setTimeInMillis(time.getTime());
        calendar.set(1970, 0, 1);
        char[] cArray = (char[])s_timeStringTemplate.clone();
        NonTrivialJDBCConversions.writeTimeToCharArray(cArray, 0, calendar.get(11), calendar.get(12), calendar.get(13));
        if (n > 0) {
            int n2 = calendar.get(14);
            switch (n) {
                case 3: {
                    cArray[11] = NonTrivialJDBCConversions.digitToChar(n2 % 10);
                }
                case 2: {
                    cArray[10] = NonTrivialJDBCConversions.digitToChar(n2 / 10 % 10);
                }
                case 1: {
                    cArray[9] = NonTrivialJDBCConversions.digitToChar(n2 / 100);
                }
            }
            return new String(cArray, 0, 9 + n);
        }
        return new String(cArray, 0, 8);
    }

    private static int writeTimeToCharArray(char[] cArray, int n, int n2, int n3, int n4) {
        assert (n2 >= 0 && n2 <= 24);
        assert (n3 >= 0 && n3 <= 59);
        assert (n4 >= 0 && n4 <= 60);
        n = NonTrivialJDBCConversions.writeTwoDigitNumberToCharArray(n2, cArray, n);
        ++n;
        n = NonTrivialJDBCConversions.writeTwoDigitNumberToCharArray(n3, cArray, n);
        return NonTrivialJDBCConversions.writeTwoDigitNumberToCharArray(n4, cArray, ++n);
    }

    public static String timeToString(Time time) {
        return NonTrivialJDBCConversions.timeToString(time, null, 3);
    }

    public static Timestamp timeToTimestamp(Time time, int n, Calendar calendar, Listener listener) {
        assert (time != null);
        assert (n >= 0 && n <= 9);
        if (time instanceof TimeTz) {
            time = ((TimeTz)time).getAdjustedTime();
        }
        if (calendar == null) {
            calendar = Calendar.getInstance();
        }
        calendar.setTimeInMillis(time.getTime());
        calendar.set(1, 1970);
        calendar.set(2, 0);
        calendar.set(5, 1);
        int n2 = calendar.get(14);
        calendar.set(14, 0);
        Timestamp timestamp = new Timestamp(time.getTime());
        boolean bl = false;
        if (n > 0) {
            int n3 = n2 * 1000000;
            int n4 = n == 2 ? n3 - n3 % 10000000 : (n == 1 ? n3 - n3 % 100000000 : n3);
            bl = n4 != n3;
            timestamp.setNanos(n4);
        }
        listener.notifyConversionResult(bl ? ConversionStatus.FRACTIONAL_TRUNCATION : ConversionStatus.SUCCESS);
        return timestamp;
    }

    public static String timestampToString(Timestamp timestamp) {
        return NonTrivialJDBCConversions.timestampToString(timestamp, null, 9);
    }

    public static String timestampToString(Timestamp timestamp, Calendar calendar, int n) {
        assert (timestamp != null);
        assert (n >= 0);
        assert (n <= 9);
        if (timestamp instanceof TimestampTz) {
            timestamp = ((TimestampTz)timestamp).getAdjustedTimestamp();
        }
        if (calendar == null) {
            calendar = Calendar.getInstance();
        }
        boolean bl = timestamp.getTime() < NonTrivialJDBCConversions.getZeroTimeAD(calendar);
        calendar.clear();
        calendar.setTimeInMillis(timestamp.getTime());
        char[] cArray = (char[])s_timestampStringTemplate.clone();
        int n2 = NonTrivialJDBCConversions.writeDateToCharArray(cArray, 1, calendar.get(1), calendar.get(2) + 1, calendar.get(5));
        if (bl) {
            --n2;
        }
        NonTrivialJDBCConversions.writeTimeToCharArray(cArray, 17, calendar.get(11), calendar.get(12), calendar.get(13));
        int n3 = 25;
        if (n > 0) {
            int n4 = timestamp.getNanos();
            switch (n) {
                case 9: {
                    cArray[34] = NonTrivialJDBCConversions.digitToChar(n4 % 10);
                }
                case 8: {
                    cArray[33] = NonTrivialJDBCConversions.digitToChar(n4 / 10 % 10);
                }
                case 7: {
                    cArray[32] = NonTrivialJDBCConversions.digitToChar(n4 / 100 % 10);
                }
                case 6: {
                    cArray[31] = NonTrivialJDBCConversions.digitToChar(n4 / 1000 % 10);
                }
                case 5: {
                    cArray[30] = NonTrivialJDBCConversions.digitToChar(n4 / 10000 % 10);
                }
                case 4: {
                    cArray[29] = NonTrivialJDBCConversions.digitToChar(n4 / 100000 % 10);
                }
                case 3: {
                    cArray[28] = NonTrivialJDBCConversions.digitToChar(n4 / 1000000 % 10);
                }
                case 2: {
                    cArray[27] = NonTrivialJDBCConversions.digitToChar(n4 / 10000000 % 10);
                }
                case 1: {
                    cArray[26] = NonTrivialJDBCConversions.digitToChar(n4 / 100000000);
                }
            }
            n3 = 26 + n;
        }
        return new String(cArray, n2, n3 - n2);
    }

    public static byte stringToByte(String string, Listener listener) throws ConversionFailed {
        assert (string != null);
        return DecimalConverter.toByte(NonTrivialJDBCConversions.stringToBigDecimal(string), listener);
    }

    public static BigDecimal stringToBigDecimal(String string) throws ConversionFailed {
        try {
            return new BigDecimal(string.trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw new ConversionFailed(numberFormatException);
        }
    }

    public static short stringToShort(String string, Listener listener) throws ConversionFailed {
        assert (string != null);
        return DecimalConverter.toShort(NonTrivialJDBCConversions.stringToBigDecimal(string), listener);
    }

    private static boolean isInteger(double d) {
        return Math.rint(d) == d;
    }

    public static byte objectToByte(Object object, Listener listener) throws IncorrectTypeException, ConversionFailed {
        assert (object != null);
        if (object instanceof Number) {
            Number number = (Number)object;
            double d = number.doubleValue();
            if (d < -128.0 || d > 127.0 || !NonTrivialJDBCConversions.isInteger(d)) {
                return DoubleConverter.toByte(d, listener);
            }
            listener.notifyConversionResult(ConversionStatus.SUCCESS);
            return number.byteValue();
        }
        if (object instanceof String) {
            return NonTrivialJDBCConversions.stringToByte((String)object, listener);
        }
        if (object instanceof Boolean) {
            listener.notifyConversionResult(ConversionStatus.SUCCESS);
            return (byte)((Boolean)object != false ? 1 : 0);
        }
        throw new IncorrectTypeException();
    }

    public static short objectToShort(Object object, Listener listener) throws IncorrectTypeException, ConversionFailed {
        assert (object != null);
        if (object instanceof Number) {
            Number number = (Number)object;
            double d = number.doubleValue();
            if (d < -32768.0 || d > 32767.0 || !NonTrivialJDBCConversions.isInteger(d)) {
                return DoubleConverter.toShort(d, listener);
            }
            listener.notifyConversionResult(ConversionStatus.SUCCESS);
            return number.shortValue();
        }
        if (object instanceof String) {
            return NonTrivialJDBCConversions.stringToShort((String)object, listener);
        }
        if (object instanceof Boolean) {
            listener.notifyConversionResult(ConversionStatus.SUCCESS);
            return (short)((Boolean)object != false ? 1 : 0);
        }
        throw new IncorrectTypeException();
    }

    public static int stringToInt(String string, Listener listener) throws ConversionFailed {
        BigDecimal bigDecimal;
        assert (string != null);
        try {
            bigDecimal = new BigDecimal(string.trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw new ConversionFailed(numberFormatException);
        }
        return DecimalConverter.toInt(bigDecimal, listener);
    }

    public static int objectToInt(Object object, Listener listener) throws IncorrectTypeException, ConversionFailed {
        assert (object != null);
        if (object instanceof Number) {
            Number number = (Number)object;
            double d = number.doubleValue();
            if (d < -2.147483648E9 || d > 2.147483647E9 || !NonTrivialJDBCConversions.isInteger(d)) {
                return DoubleConverter.toInt(d, listener);
            }
            listener.notifyConversionResult(ConversionStatus.SUCCESS);
            return number.intValue();
        }
        if (object instanceof String) {
            return NonTrivialJDBCConversions.stringToInt((String)object, listener);
        }
        if (object instanceof Boolean) {
            listener.notifyConversionResult(ConversionStatus.SUCCESS);
            return (Boolean)object != false ? 1 : 0;
        }
        throw new IncorrectTypeException();
    }

    public static long stringToLong(String string, Listener listener) throws ConversionFailed {
        assert (string != null);
        return DecimalConverter.toLong(NonTrivialJDBCConversions.stringToBigDecimal(string), listener);
    }

    public static long objectToLong(Object object, Listener listener) throws IncorrectTypeException, ConversionFailed {
        assert (object != null);
        if (object instanceof Number) {
            Number number = (Number)object;
            double d = number.doubleValue();
            if (d < -9.223372036854776E18 || d > 9.223372036854776E18 || !NonTrivialJDBCConversions.isInteger(d)) {
                return DoubleConverter.toLong(d, listener);
            }
            listener.notifyConversionResult(ConversionStatus.SUCCESS);
            return number.longValue();
        }
        if (object instanceof String) {
            return NonTrivialJDBCConversions.stringToLong((String)object, listener);
        }
        if (object instanceof Boolean) {
            listener.notifyConversionResult(ConversionStatus.SUCCESS);
            return (Boolean)object != false ? 1L : 0L;
        }
        throw new IncorrectTypeException();
    }

    public static Number objectToBigInt(Object object, Listener listener) throws IncorrectTypeException {
        assert (object != null);
        if (object instanceof BigInteger) {
            listener.notifyConversionResult(ConversionStatus.SUCCESS);
            return (BigInteger)object;
        }
        if (object instanceof BigDecimal) {
            return DecimalConverter.toBigInt((BigDecimal)object, listener);
        }
        if (object instanceof Number) {
            Number number = (Number)object;
            double d = number.doubleValue();
            if (d < -9.223372036854776E18 || d > 9.223372036854776E18 || !NonTrivialJDBCConversions.isInteger(d)) {
                return DoubleConverter.toBigInt(d, listener);
            }
            listener.notifyConversionResult(ConversionStatus.SUCCESS);
            return number.longValue();
        }
        if (object instanceof String) {
            return DecimalConverter.toBigInt(new BigDecimal(((String)object).trim()), listener);
        }
        if (object instanceof Boolean) {
            listener.notifyConversionResult(ConversionStatus.SUCCESS);
            return (Boolean)object != false ? BigInteger.ONE : BigInteger.ZERO;
        }
        throw new IncorrectTypeException();
    }

    public static boolean stringToBoolean(String string) {
        assert (string != null);
        return !(string = string.trim()).equalsIgnoreCase("false") && !string.equals("0") && !string.equals("0.0") && !string.equalsIgnoreCase("f");
    }

    public static boolean objectToBoolean(Object object) throws IncorrectTypeException {
        assert (object != null);
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof Number) {
            return ((Number)object).doubleValue() != 0.0;
        }
        if (object instanceof String) {
            return NonTrivialJDBCConversions.stringToBoolean((String)object);
        }
        throw new IncorrectTypeException();
    }

    public static double stringToDouble(String string) throws ConversionFailed {
        assert (string != null);
        String string2 = NonTrivialJDBCConversions.normalizeStringForDoubleConversion(string);
        try {
            return Double.parseDouble(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return NonTrivialJDBCConversions.stringToBigDecimal(string2).doubleValue();
        }
    }

    private static BigDecimal rescaleBigDecimal(BigDecimal bigDecimal, int n, Listener listener) {
        assert (bigDecimal != null);
        if (n == bigDecimal.scale()) {
            listener.notifyConversionResult(ConversionStatus.SUCCESS);
            return bigDecimal;
        }
        BigDecimal bigDecimal2 = bigDecimal.setScale(n, 1);
        if (0 != bigDecimal.compareTo(bigDecimal2)) {
            listener.notifyConversionResult(ConversionStatus.FRACTIONAL_TRUNCATION);
        } else {
            listener.notifyConversionResult(ConversionStatus.SUCCESS);
        }
        return bigDecimal2;
    }

    public static BigDecimal objectToBigDecimal(Object object, Integer n, Listener listener) throws IncorrectTypeException, ConversionFailed {
        assert (object != null);
        if (object instanceof Number) {
            if (object instanceof BigDecimal) {
                BigDecimal bigDecimal = (BigDecimal)object;
                if (n == null) {
                    listener.notifyConversionResult(ConversionStatus.SUCCESS);
                    return bigDecimal;
                }
                return NonTrivialJDBCConversions.rescaleBigDecimal(bigDecimal, n, listener);
            }
            if (object instanceof BigInteger) {
                listener.notifyConversionResult(ConversionStatus.SUCCESS);
                if (n == null) {
                    return new BigDecimal((BigInteger)object);
                }
                return new BigDecimal((BigInteger)object, n);
            }
            if (object instanceof Double || object instanceof Float) {
                if (n == null) {
                    listener.notifyConversionResult(ConversionStatus.SUCCESS);
                    return BigDecimal.valueOf(((Number)object).doubleValue());
                }
                listener.notifyConversionResult(ConversionStatus.FRACTIONAL_TRUNCATION);
                return NonTrivialJDBCConversions.rescaleBigDecimal(BigDecimal.valueOf(((Number)object).doubleValue()), n, listener);
            }
            BigDecimal bigDecimal = BigDecimal.valueOf(((Number)object).longValue());
            return n == null ? bigDecimal : bigDecimal.setScale(n);
        }
        if (object instanceof String) {
            BigDecimal bigDecimal = NonTrivialJDBCConversions.stringToBigDecimal((String)object);
            if (n == null) {
                listener.notifyConversionResult(ConversionStatus.SUCCESS);
                return bigDecimal;
            }
            return NonTrivialJDBCConversions.rescaleBigDecimal(bigDecimal, n, listener);
        }
        throw new IncorrectTypeException();
    }

    public static BigDecimal checkPrecisionAndLimitScale(BigDecimal bigDecimal, short s, short s2, Listener listener) throws ErrorException {
        assert (bigDecimal != null);
        assert (listener != null);
        boolean bl = false;
        if (s <= 0) {
            throw new IllegalArgumentException("Invalid precision");
        }
        if (s2 < 0 || s2 > s) {
            throw new IllegalArgumentException("Invalid scale");
        }
        if (NonTrivialJDBCConversions.getWholeDigits(bigDecimal) > s) {
            listener.notifyConversionResult(ConversionStatus.OVERFLOW);
            bl = true;
        }
        BigDecimal bigDecimal2 = bigDecimal.setScale((int)s2, RoundingMode.DOWN);
        if (!bl && 0 != bigDecimal2.compareTo(bigDecimal)) {
            listener.notifyConversionResult(ConversionStatus.FRACTIONAL_TRUNCATION);
        } else {
            listener.notifyConversionResult(ConversionStatus.SUCCESS);
        }
        return bigDecimal2;
    }

    private static int getWholeDigits(BigDecimal bigDecimal) {
        if (bigDecimal.signum() == 0) {
            return 0;
        }
        if (bigDecimal.scale() >= bigDecimal.precision()) {
            return 0;
        }
        return bigDecimal.precision() - bigDecimal.scale();
    }

    public static Date stringToDate(String string) throws ConversionFailed {
        return NonTrivialJDBCConversions.stringToDate(string, null);
    }

    public static Date stringToDate(String string, GregorianCalendar gregorianCalendar) throws ConversionFailed {
        assert (string != null);
        string = string.trim();
        if (gregorianCalendar == null) {
            gregorianCalendar = new GregorianCalendar();
        }
        try {
            if (-1 != string.indexOf(58)) {
                Timestamp timestamp = StringConverter.parseTimestamp(string, gregorianCalendar);
                if (null == timestamp) {
                    throw new IllegalArgumentException();
                }
                gregorianCalendar.clear();
                gregorianCalendar.setTimeInMillis(timestamp.getTime());
                return NonTrivialJDBCConversions.dateFromCalendar(gregorianCalendar);
            }
            Date date = StringConverter.parseDate(string, gregorianCalendar);
            if (date == null) {
                throw new IllegalArgumentException();
            }
            return date;
        }
        catch (Exception exception) {
            throw new ConversionFailed(exception);
        }
    }

    private static Date dateFromCalendar(Calendar calendar) {
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return new Date(calendar.getTimeInMillis());
    }

    public static Date timestampToDate(Timestamp timestamp) {
        return NonTrivialJDBCConversions.timestampToDate(timestamp, null);
    }

    public static Date timestampToDate(Timestamp timestamp, Calendar calendar) {
        assert (timestamp != null);
        if (timestamp instanceof TimestampTz) {
            timestamp = ((TimestampTz)timestamp).getAdjustedTimestamp();
        }
        if (calendar == null) {
            calendar = Calendar.getInstance();
        }
        calendar.setTimeInMillis(timestamp.getTime());
        return NonTrivialJDBCConversions.dateFromCalendar(calendar);
    }

    public static Date objectToDate(Object object) throws IncorrectTypeException, ConversionFailed {
        assert (object != null);
        if (object instanceof Date) {
            return (Date)object;
        }
        if (object instanceof String) {
            return NonTrivialJDBCConversions.stringToDate((String)object);
        }
        if (object instanceof Timestamp) {
            return NonTrivialJDBCConversions.timestampToDate((Timestamp)object);
        }
        if (object instanceof Calendar) {
            return NonTrivialJDBCConversions.timestampToDate(NonTrivialJDBCConversions.calendarToTimestamp((Calendar)object, 9));
        }
        throw new IncorrectTypeException();
    }

    public static Time timestampToTime(Timestamp timestamp) {
        return NonTrivialJDBCConversions.timestampToTime(timestamp, 3, null);
    }

    public static Time timestampToTime(Timestamp timestamp, int n, Calendar calendar) {
        assert (timestamp != null);
        assert (n >= 0);
        n = Math.min(3, n);
        if (timestamp instanceof TimestampTz) {
            timestamp = ((TimestampTz)timestamp).getAdjustedTimestamp();
        }
        if (calendar == null) {
            calendar = Calendar.getInstance();
        }
        calendar.setTimeInMillis(timestamp.getTime());
        calendar.set(1, 1970);
        calendar.set(2, 0);
        calendar.set(5, 1);
        if (n == 0) {
            calendar.set(14, 0);
        } else {
            int n2 = timestamp.getNanos() / 1000000;
            assert (n2 >= 0);
            switch (n) {
                case 2: {
                    n2 -= n2 % 10;
                    break;
                }
                case 1: {
                    n2 -= n2 % 100;
                }
            }
            calendar.set(14, n2);
        }
        return new Time(calendar.getTimeInMillis());
    }

    public static Time stringToTime(String string) throws ConversionFailed {
        return NonTrivialJDBCConversions.stringToTime(string, 3, null);
    }

    public static Time stringToTime(String string, int n, GregorianCalendar gregorianCalendar) throws ConversionFailed {
        assert (n >= 0 && n <= 3);
        assert (string != null);
        string = string.trim();
        try {
            int n2 = string.length();
            int n3 = string.indexOf(46);
            int n4 = string.indexOf(32);
            if (n4 == -1 && -1 == (n4 = string.indexOf(43))) {
                n4 = string.indexOf(45);
            }
            if (n4 != -1) {
                gregorianCalendar = NonTrivialJDBCConversions.getCalendarForTimeZone(string.substring(n4, n2));
            } else if (gregorianCalendar == null) {
                gregorianCalendar = new GregorianCalendar();
            }
            int n5 = string.indexOf(32);
            if (n5 != -1 && StringConverter.parseDate(string.substring(0, n5), gregorianCalendar) != null) {
                string = string.substring(n5 + 1);
            }
            int n6 = n3 == -1 ? (n4 == -1 ? n2 : n4) : n3;
            Time time = StringConverter.parseTime(string.substring(0, n6), gregorianCalendar);
            if (n3 != -1) {
                int n7;
                int n8 = n4 > 0 ? n4 : n2;
                for (n7 = n3 + 1; n7 < n8; ++n7) {
                    if (NonTrivialJDBCConversions.isDigit(string.charAt(n7))) continue;
                    throw new IllegalArgumentException("Expected fractional seconds, found non-digit.");
                }
                if (n > 0) {
                    int n9;
                    n7 = Math.min(n, 3);
                    int n10 = Math.min(n7, n9 = n8 - n3 - 2);
                    if (n10 == 0) {
                        throw new IllegalArgumentException("Empty fractional seconds field");
                    }
                    int n11 = StringConverter.parseInt(string, n3 + 1, n3 + n10 + 1);
                    while (n10++ < 3) {
                        n11 *= 10;
                    }
                    gregorianCalendar.clear();
                    gregorianCalendar.setTimeInMillis(time.getTime());
                    gregorianCalendar.set(14, n11);
                    time.setTime(gregorianCalendar.getTimeInMillis());
                }
            }
            return time;
        }
        catch (Exception exception) {
            throw new ConversionFailed(exception);
        }
    }

    private static GregorianCalendar getCalendarForTimeZone(String string) {
        return new GregorianCalendar(NonTrivialJDBCConversions.parseTimeZone(string));
    }

    private static TimeZone parseTimeZone(String string) {
        if (!Character.isLetter((string = string.trim()).charAt(0))) {
            if (Character.isDigit(string.charAt(0))) {
                string = "+" + string;
            }
            string = "GMT" + string;
        }
        return TimeZone.getTimeZone(string);
    }

    public static Time objectToTime(Object object) throws IncorrectTypeException, ConversionFailed {
        assert (object != null);
        if (object instanceof Time) {
            return (Time)object;
        }
        if (object instanceof String) {
            return NonTrivialJDBCConversions.stringToTime((String)object);
        }
        if (object instanceof Timestamp) {
            Timestamp timestamp = object instanceof TimestampTz ? ((TimestampTz)object).getAdjustedTimestamp() : (Timestamp)object;
            Calendar calendar = Calendar.getInstance();
            calendar.clear();
            calendar.setTimeInMillis(timestamp.getTime());
            calendar.set(1970, 0, 1);
            return new Time(calendar.getTimeInMillis());
        }
        if (object instanceof Calendar) {
            return NonTrivialJDBCConversions.timestampToTime(NonTrivialJDBCConversions.calendarToTimestamp((Calendar)object, 9));
        }
        throw new IncorrectTypeException();
    }

    public static Timestamp stringToTimestamp(String string) throws ConversionFailed {
        return NonTrivialJDBCConversions.stringToTimestamp(string, 9, null);
    }

    public static Timestamp stringToTimestamp(String string, int n, GregorianCalendar gregorianCalendar) throws ConversionFailed {
        assert (n >= 0 && n <= 9);
        assert (string != null);
        string = string.trim();
        try {
            if (gregorianCalendar == null) {
                gregorianCalendar = new GregorianCalendar();
            }
            boolean bl = string.contains("-");
            boolean bl2 = string.contains(":");
            if (bl && bl2) {
                Timestamp timestamp = StringConverter.parseTimestamp(string, gregorianCalendar);
                timestamp.setNanos(NonTrivialJDBCConversions.roundNanosecondsToPrecision(timestamp.getNanos(), n));
                return timestamp;
            }
            if (bl) {
                return new Timestamp(NonTrivialJDBCConversions.stringToDate(string, gregorianCalendar).getTime());
            }
            if (bl2) {
                int n2;
                Time time = NonTrivialJDBCConversions.stringToTime(string, 0, gregorianCalendar);
                gregorianCalendar.clear();
                gregorianCalendar.setTimeInMillis(time.getTime());
                assert (gregorianCalendar.get(14) == 0);
                Timestamp timestamp = new Timestamp(gregorianCalendar.getTimeInMillis());
                if (n > 0 && (n2 = string.indexOf(46)) != -1) {
                    int n3;
                    for (n3 = n2 + 1; n3 < string.length() && NonTrivialJDBCConversions.isDigit(string.charAt(n3)); ++n3) {
                    }
                    int n4 = Math.min(n, 9);
                    int n5 = Math.min(n3 - n2 - 1, n4);
                    int n6 = StringConverter.parseInt(string, n2 + 1, n3) * StringConverter.s_fractionalMultiplier[n5];
                    timestamp.setNanos(n6);
                }
                return timestamp;
            }
            throw new IllegalArgumentException("Source value couldn't be parsed as a Timestamp, Time, or Date");
        }
        catch (Exception exception) {
            throw new ConversionFailed(exception);
        }
    }

    public static int roundNanosecondsToPrecision(int n, int n2) {
        return n - NonTrivialJDBCConversions.getExcessFromRoundedValue(n, n2);
    }

    private static int getExcessFromRoundedValue(int n, int n2) {
        assert (n >= 0 && n <= 999999999);
        assert (n2 >= 1 && n2 <= 9);
        switch (n2) {
            case 1: {
                return n % 100000000;
            }
            case 2: {
                return n % 10000000;
            }
            case 3: {
                return n % 1000000;
            }
            case 4: {
                return n % 100000;
            }
            case 5: {
                return n % 10000;
            }
            case 6: {
                return n % 1000;
            }
            case 7: {
                return n % 100;
            }
            case 8: {
                return n % 10;
            }
            case 9: {
                return 0;
            }
        }
        throw new RuntimeException("precision = " + n2 + "???");
    }

    private static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    public static Timestamp objectToTimestamp(Object object) throws IncorrectTypeException, ConversionFailed {
        assert (object != null);
        if (object instanceof Timestamp) {
            if (object instanceof TimestampTz) {
                return ((TimestampTz)object).getAdjustedTimestamp();
            }
            return (Timestamp)object;
        }
        if (object instanceof String) {
            return NonTrivialJDBCConversions.stringToTimestamp((String)object);
        }
        if (object instanceof java.util.Date) {
            if (object instanceof TimeTz) {
                object = ((TimeTz)object).getAdjustedTime();
            }
            return new Timestamp(((java.util.Date)object).getTime());
        }
        if (object instanceof Calendar) {
            return NonTrivialJDBCConversions.calendarToTimestamp((Calendar)object, 9);
        }
        throw new IncorrectTypeException();
    }

    public static String monthSpanToString(DSIMonthSpan dSIMonthSpan, int n, IntervalConverter intervalConverter, int n2) {
        assert (dSIMonthSpan != null);
        assert (intervalConverter != null);
        switch (n) {
            case 102: {
                return intervalConverter.monthToString(dSIMonthSpan, n2);
            }
            case 101: {
                return intervalConverter.yearToString(dSIMonthSpan, n2);
            }
            case 107: {
                return intervalConverter.yearMonthToString(dSIMonthSpan, n2);
            }
        }
        throw new IllegalArgumentException("Unexpected SQL type " + n);
    }

    public static DSIMonthSpan stringToMonthSpan(String string, int n, IntervalConverter intervalConverter, int n2, IWarningListener iWarningListener, Listener listener) throws ConversionFailed {
        assert (string != null);
        assert (intervalConverter != null);
        assert (iWarningListener != null);
        try {
            switch (n) {
                case 102: {
                    return intervalConverter.stringToMonth(string, n2, iWarningListener, listener);
                }
                case 101: {
                    return intervalConverter.stringToYear(string, n2, iWarningListener, listener);
                }
                case 107: {
                    return intervalConverter.stringToYearMonth(string, n2, iWarningListener, listener);
                }
            }
            throw new IllegalArgumentException("Unexpected SQL type " + n);
        }
        catch (Exception exception) {
            throw new ConversionFailed(exception);
        }
    }

    public static DSIMonthSpan objectToMonthSpan(Object object, int n, IntervalConverter intervalConverter, IWarningListener iWarningListener, Listener listener) throws IncorrectTypeException, ConversionFailed {
        assert (object != null);
        if (object instanceof DSIMonthSpan) {
            return intervalConverter.normalize((DSIMonthSpan)object, n, 9, iWarningListener, listener);
        }
        if (object instanceof String) {
            return NonTrivialJDBCConversions.stringToMonthSpan((String)object, n, intervalConverter, 9, iWarningListener, listener);
        }
        throw new IncorrectTypeException();
    }

    public static String timeSpanToString(DSITimeSpan dSITimeSpan, int n, IntervalConverter intervalConverter, int n2, int n3) {
        assert (dSITimeSpan != null);
        switch (n) {
            case 103: {
                return intervalConverter.dayToString(dSITimeSpan, n2);
            }
            case 108: {
                return intervalConverter.dayHourToString(dSITimeSpan, n2);
            }
            case 109: {
                return intervalConverter.dayMinuteToString(dSITimeSpan, n2);
            }
            case 110: {
                return intervalConverter.daySecondToString(dSITimeSpan, n2, n3);
            }
            case 104: {
                return intervalConverter.hourToString(dSITimeSpan, n2);
            }
            case 111: {
                return intervalConverter.hourMinuteToString(dSITimeSpan, n2);
            }
            case 112: {
                return intervalConverter.hourSecondToString(dSITimeSpan, n2, n3);
            }
            case 105: {
                return intervalConverter.minuteToString(dSITimeSpan, n2);
            }
            case 113: {
                return intervalConverter.minuteSecondToString(dSITimeSpan, n2, n3);
            }
            case 106: {
                return intervalConverter.secondToString(dSITimeSpan, n2, n3);
            }
        }
        throw new IllegalArgumentException("Unexpected SQL type " + n);
    }

    public static DSITimeSpan stringToTimeSpan(String string, int n, IntervalConverter intervalConverter, int n2, int n3, IWarningListener iWarningListener, Listener listener) throws ConversionFailed {
        assert (string != null);
        try {
            switch (n) {
                case 103: {
                    return intervalConverter.stringToDay(string, n2, iWarningListener, listener);
                }
                case 108: {
                    return intervalConverter.stringToDayHour(string, n2, iWarningListener, listener);
                }
                case 109: {
                    return intervalConverter.stringToDayMinute(string, n2, iWarningListener, listener);
                }
                case 110: {
                    return intervalConverter.stringToDaySecond(string, n2, n3, iWarningListener, listener);
                }
                case 104: {
                    return intervalConverter.stringToHour(string, n2, iWarningListener, listener);
                }
                case 111: {
                    return intervalConverter.stringToHourMinute(string, n2, iWarningListener, listener);
                }
                case 112: {
                    return intervalConverter.stringToHourSecond(string, n2, n3, iWarningListener, listener);
                }
                case 105: {
                    return intervalConverter.stringToMinute(string, n2, iWarningListener, listener);
                }
                case 113: {
                    return intervalConverter.stringToMinuteSecond(string, n2, n3, iWarningListener, listener);
                }
                case 106: {
                    return intervalConverter.stringToSecond(string, n2, n3, iWarningListener, listener);
                }
            }
            throw new IllegalArgumentException("Unexpected SQL type " + n);
        }
        catch (Exception exception) {
            throw new ConversionFailed(exception);
        }
    }

    public static DSITimeSpan objectToTimeSpan(Object object, int n, IntervalConverter intervalConverter, IWarningListener iWarningListener, Listener listener) throws IncorrectTypeException, ConversionFailed {
        assert (object != null);
        if (object instanceof DSITimeSpan) {
            return intervalConverter.normalize((DSITimeSpan)object, n, 9, 9, iWarningListener, listener);
        }
        if (object instanceof String) {
            return NonTrivialJDBCConversions.stringToTimeSpan((String)object, n, intervalConverter, 9, 9, iWarningListener, listener);
        }
        throw new IncorrectTypeException();
    }

    public static double objectToDouble(Object object) throws IncorrectTypeException, ConversionFailed {
        assert (object != null);
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        if (object instanceof String) {
            return NonTrivialJDBCConversions.stringToDouble((String)object);
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? 1.0 : 0.0;
        }
        throw new IncorrectTypeException();
    }

    public static UUID objectToGUID(Object object) throws IncorrectTypeException {
        assert (object != null);
        if (object instanceof UUID) {
            return (UUID)object;
        }
        if (object instanceof String) {
            return UUID.fromString((String)object);
        }
        throw new IncorrectTypeException();
    }

    public static String objectToString(Object object, IntervalConverter intervalConverter) {
        assert (object != null);
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? "1" : "0";
        }
        if (object instanceof byte[]) {
            return NonTrivialJDBCConversions.bytesToHex((byte[])object);
        }
        if (object instanceof BigDecimal) {
            return ((BigDecimal)object).toPlainString();
        }
        if (object instanceof Date) {
            return NonTrivialJDBCConversions.dateToString((Date)object);
        }
        if (object instanceof Time) {
            return NonTrivialJDBCConversions.timeToString((Time)object);
        }
        if (object instanceof Timestamp) {
            return NonTrivialJDBCConversions.timestampToString((Timestamp)object);
        }
        if (object instanceof DSIMonthSpan) {
            return intervalConverter.yearMonthToString((DSIMonthSpan)object, 9);
        }
        if (object instanceof DSITimeSpan) {
            return intervalConverter.daySecondToString((DSITimeSpan)object, 9, 9);
        }
        return object.toString();
    }

    public static Timestamp calendarToTimestamp(Calendar calendar, int n) {
        assert (calendar != null);
        Timestamp timestamp = new Timestamp(calendar.getTimeInMillis());
        timestamp.setNanos(NonTrivialJDBCConversions.roundNanosecondsToPrecision(calendar.get(14) * 1000000, n));
        return timestamp;
    }

    private NonTrivialJDBCConversions() {
    }

    private static int numDigits(int n) {
        if (n == 0) {
            return 1;
        }
        assert (n > 0);
        return (int)Math.log10(n) + 1;
    }

    private static int writeDateToCharArray(char[] cArray, int n, int n2, int n3, int n4) {
        assert (cArray != null);
        assert (n >= 0);
        assert (n < cArray.length + 14);
        assert (n2 >= 0 && n2 <= 999999999);
        assert (n3 >= 1 && n3 <= 12);
        assert (n4 >= 1 && n4 <= 31);
        int n5 = Math.max(4, NonTrivialJDBCConversions.numDigits(n2));
        assert (n5 <= 9);
        int n6 = n;
        switch (n5) {
            default: {
                cArray[n] = NonTrivialJDBCConversions.digitToChar(n2 / 100000000 % 10);
            }
            case 8: {
                cArray[n + 1] = NonTrivialJDBCConversions.digitToChar(n2 / 10000000 % 10);
            }
            case 7: {
                cArray[n + 2] = NonTrivialJDBCConversions.digitToChar(n2 / 1000000 % 10);
            }
            case 6: {
                cArray[n + 3] = NonTrivialJDBCConversions.digitToChar(n2 / 100000 % 10);
            }
            case 5: {
                cArray[n + 4] = NonTrivialJDBCConversions.digitToChar(n2 / 10000 % 10);
            }
            case 4: 
        }
        n += 5;
        cArray[n++] = NonTrivialJDBCConversions.digitToChar(n2 / 1000 % 10);
        cArray[n++] = NonTrivialJDBCConversions.digitToChar(n2 / 100 % 10);
        cArray[n++] = NonTrivialJDBCConversions.digitToChar(n2 / 10 % 10);
        cArray[n++] = NonTrivialJDBCConversions.digitToChar(n2 % 10);
        ++n;
        n = NonTrivialJDBCConversions.writeTwoDigitNumberToCharArray(n3, cArray, n);
        NonTrivialJDBCConversions.writeTwoDigitNumberToCharArray(n4, cArray, ++n);
        return n6 + (9 - n5);
    }

    private static int writeTwoDigitNumberToCharArray(int n, char[] cArray, int n2) {
        assert (cArray != null);
        assert (n2 >= 0 && n2 < cArray.length + 1);
        assert (n >= 0 && n <= 99);
        cArray[n2++] = NonTrivialJDBCConversions.digitToChar(n / 10);
        cArray[n2++] = NonTrivialJDBCConversions.digitToChar(n % 10);
        return n2;
    }

    private static long getZeroTimeAD(Calendar calendar) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(null == calendar ? TimeZone.getDefault() : calendar.getTimeZone());
        gregorianCalendar.clear();
        gregorianCalendar.set(1, 0, 1, 0, 0, 0);
        return gregorianCalendar.getTimeInMillis();
    }

    private static char digitToChar(int n) {
        assert (n >= 0 && n <= 9);
        return (char)(48 + n);
    }

    private static String normalizeStringForDoubleConversion(String string) {
        String string2 = s_doubleNormalizationMap.get(string = string.trim());
        return string2 != null ? string2 : string;
    }

    public static String bytesToHex(ByteBuffer byteBuffer) {
        byte[] byArray = new byte[byteBuffer.remaining()];
        byteBuffer.duplicate().get(byArray);
        return NonTrivialJDBCConversions.bytesToHex(byArray);
    }

    static {
        s_doubleNormalizationMap.put("INF", "Infinity");
        s_doubleNormalizationMap.put("+INF", "+Infinity");
        s_doubleNormalizationMap.put("-INF", "-Infinity");
        s_doubleNormalizationMap.put("INFINITY", "Infinity");
        s_doubleNormalizationMap.put("+INFINITY", "+Infinity");
        s_doubleNormalizationMap.put("-INFINITY", "-Infinity");
        s_doubleNormalizationMap.put("NAN", "NaN");
        s_doubleNormalizationMap.put("+NAN", "NaN");
        s_doubleNormalizationMap.put("-NAN", "NaN");
    }

    public static final class DoubleConverter {
        private static final short s_2ToThePowerOf8 = 256;
        private static final int s_2ToThePowerOf16 = 65536;
        private static final long s_2ToThePowerOf32 = 0x100000000L;
        private static final BigInteger s_2ToThePowerOf64 = BigInteger.valueOf(2L).pow(64);
        private static final BigDecimal s_2ToThePowerOf64AsBD = new BigDecimal(s_2ToThePowerOf64);

        public static BigInteger toBigInt(double d, Listener listener) {
            if (Double.isInfinite(d)) {
                listener.notifyConversionResult(ConversionStatus.OVERFLOW);
                return BigInteger.ZERO;
            }
            if (Math.rint(d) != d) {
                listener.notifyConversionResult(ConversionStatus.FRACTIONAL_TRUNCATION);
                return BigDecimal.valueOf(d).toBigInteger();
            }
            listener.notifyConversionResult(ConversionStatus.SUCCESS);
            return BigDecimal.valueOf(d).toBigInteger();
        }

        public static byte toByte(double d, Listener listener) {
            boolean bl = false;
            if (d < -128.0 || d > 127.0) {
                listener.notifyConversionResult(ConversionStatus.OVERFLOW);
                bl = true;
            }
            byte by = (byte)d;
            if (!bl && (double)by != d) {
                listener.notifyConversionResult(ConversionStatus.FRACTIONAL_TRUNCATION);
            } else {
                listener.notifyConversionResult(ConversionStatus.SUCCESS);
            }
            return by;
        }

        public static short toUInt8(double d, Listener listener) {
            boolean bl = false;
            if (d < 0.0 || d >= 256.0) {
                listener.notifyConversionResult(ConversionStatus.OVERFLOW);
                d = (d % 256.0 + 256.0) % 256.0;
                bl = true;
            }
            short s = (short)d;
            if (!bl && (double)s != d) {
                listener.notifyConversionResult(ConversionStatus.FRACTIONAL_TRUNCATION);
                bl = true;
            } else {
                listener.notifyConversionResult(ConversionStatus.SUCCESS);
            }
            return s;
        }

        public static short toShort(double d, Listener listener) {
            boolean bl = false;
            if (d < -32768.0 || d > 32767.0) {
                listener.notifyConversionResult(ConversionStatus.OVERFLOW);
                bl = true;
            }
            short s = (short)d;
            if (!bl && (double)s != d) {
                listener.notifyConversionResult(ConversionStatus.FRACTIONAL_TRUNCATION);
            } else {
                listener.notifyConversionResult(ConversionStatus.SUCCESS);
            }
            return s;
        }

        public static int toUInt16(double d, Listener listener) {
            boolean bl = false;
            if (d < 0.0 || d >= 65536.0) {
                listener.notifyConversionResult(ConversionStatus.OVERFLOW);
                d = (d % 65536.0 + 65536.0) % 65536.0;
                bl = true;
            }
            int n = (int)d;
            if (!bl && (double)n != d) {
                listener.notifyConversionResult(ConversionStatus.FRACTIONAL_TRUNCATION);
            } else {
                listener.notifyConversionResult(ConversionStatus.SUCCESS);
            }
            return n;
        }

        public static int toInt(double d, Listener listener) {
            boolean bl = false;
            if (d < -2.147483648E9 || d > 2.147483647E9) {
                listener.notifyConversionResult(ConversionStatus.OVERFLOW);
                bl = true;
            }
            int n = (int)d;
            if (!bl && (double)n != d) {
                listener.notifyConversionResult(ConversionStatus.FRACTIONAL_TRUNCATION);
            } else {
                listener.notifyConversionResult(ConversionStatus.SUCCESS);
            }
            return n;
        }

        public static long toUInt32(double d, Listener listener) {
            boolean bl = false;
            if (d < 0.0 || d >= 4.294967296E9) {
                listener.notifyConversionResult(ConversionStatus.OVERFLOW);
                d = (d % 4.294967296E9 + 4.294967296E9) % 4.294967296E9;
                bl = true;
            }
            long l = (long)d;
            if (!bl && (double)l != d) {
                listener.notifyConversionResult(ConversionStatus.FRACTIONAL_TRUNCATION);
            } else {
                listener.notifyConversionResult(ConversionStatus.SUCCESS);
            }
            return l;
        }

        public static long toLong(double d, Listener listener) {
            boolean bl = false;
            if (d < -9.223372036854776E18 || d > 9.223372036854776E18) {
                listener.notifyConversionResult(ConversionStatus.OVERFLOW);
                bl = true;
            }
            long l = (long)d;
            if (!bl && (double)l != d) {
                listener.notifyConversionResult(ConversionStatus.FRACTIONAL_TRUNCATION);
            } else {
                listener.notifyConversionResult(ConversionStatus.SUCCESS);
            }
            return l;
        }

        public static BigInteger toUInt64(double d, Listener listener) {
            BigDecimal bigDecimal = BigDecimal.valueOf(d);
            if (bigDecimal.compareTo(BigDecimal.ZERO) < 0 || bigDecimal.compareTo(s_2ToThePowerOf64AsBD) >= 0) {
                listener.notifyConversionResult(ConversionStatus.OVERFLOW);
                return bigDecimal.toBigInteger().mod(s_2ToThePowerOf64);
            }
            try {
                BigInteger bigInteger = bigDecimal.toBigIntegerExact();
                listener.notifyConversionResult(ConversionStatus.SUCCESS);
                return bigInteger;
            }
            catch (ArithmeticException arithmeticException) {
                listener.notifyConversionResult(ConversionStatus.FRACTIONAL_TRUNCATION);
                return bigDecimal.toBigInteger();
            }
        }
    }

    public static final class LongConverter {
        private static final short s_2ToThePowerOf8 = 256;
        private static final int s_2ToThePowerOf16 = 65536;
        private static final long s_2ToThePowerOf32 = 0x100000000L;
        private static final BigInteger s_2ToThePowerOf64 = BigInteger.valueOf(2L).pow(64);

        public static byte toByte(long l, Listener listener) {
            if (l < -128L || l > 127L) {
                listener.notifyConversionResult(ConversionStatus.OVERFLOW);
            } else {
                listener.notifyConversionResult(ConversionStatus.SUCCESS);
            }
            return (byte)l;
        }

        public static short toUInt8(long l, Listener listener) {
            if (l < 0L || l >= 256L) {
                listener.notifyConversionResult(ConversionStatus.OVERFLOW);
                l = (l % 256L + 256L) % 256L;
            } else {
                listener.notifyConversionResult(ConversionStatus.SUCCESS);
            }
            return (short)l;
        }

        public static short toShort(long l, Listener listener) {
            if (l < -32768L || l > 32767L) {
                listener.notifyConversionResult(ConversionStatus.OVERFLOW);
            } else {
                listener.notifyConversionResult(ConversionStatus.SUCCESS);
            }
            return (short)l;
        }

        public static int toUInt16(long l, Listener listener) {
            if (l < 0L || l >= 65536L) {
                listener.notifyConversionResult(ConversionStatus.OVERFLOW);
                l = (l % 65536L + 65536L) % 65536L;
            } else {
                listener.notifyConversionResult(ConversionStatus.SUCCESS);
            }
            return (int)l;
        }

        public static int toInt(long l, Listener listener) {
            if (l < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
                listener.notifyConversionResult(ConversionStatus.OVERFLOW);
            } else {
                listener.notifyConversionResult(ConversionStatus.SUCCESS);
            }
            return (int)l;
        }

        public static long toUInt32(long l, Listener listener) {
            if (l < 0L || l >= 0x100000000L) {
                listener.notifyConversionResult(ConversionStatus.OVERFLOW);
                l = (l % 0x100000000L + 0x100000000L) % 0x100000000L;
            } else {
                listener.notifyConversionResult(ConversionStatus.SUCCESS);
            }
            return l;
        }

        public static BigInteger toUInt64(long l, Listener listener) {
            BigInteger bigInteger = BigInteger.valueOf(l);
            if (bigInteger.signum() < 0) {
                listener.notifyConversionResult(ConversionStatus.OVERFLOW);
                bigInteger = bigInteger.add(s_2ToThePowerOf64);
            } else {
                listener.notifyConversionResult(ConversionStatus.SUCCESS);
            }
            return bigInteger;
        }
    }

    public static final class BigIntConverter {
        private static final BigInteger s_minByte = BigInteger.valueOf(-128L);
        private static final BigInteger s_maxByte = BigInteger.valueOf(127L);
        private static final BigInteger s_2ToThePowerOf8 = BigInteger.valueOf(256L);
        private static final BigInteger s_minShort = BigInteger.valueOf(-32768L);
        private static final BigInteger s_maxShort = BigInteger.valueOf(32767L);
        private static final BigInteger s_2ToThePowerOf16 = BigInteger.valueOf(65536L);
        private static final BigInteger s_minInt = BigInteger.valueOf(Integer.MIN_VALUE);
        private static final BigInteger s_maxInt = BigInteger.valueOf(Integer.MAX_VALUE);
        private static final BigInteger s_2ToThePowerOf32 = BigInteger.valueOf(0x100000000L);
        private static final BigInteger s_minLong = BigInteger.valueOf(Long.MIN_VALUE);
        private static final BigInteger s_maxLong = BigInteger.valueOf(Long.MAX_VALUE);
        private static final BigInteger s_2ToThePowerOf64 = BigInteger.valueOf(2L).pow(64);

        public static byte toByte(BigInteger bigInteger, Listener listener) {
            assert (bigInteger != null);
            if (bigInteger.compareTo(s_minByte) < 0 || bigInteger.compareTo(s_maxByte) > 0) {
                listener.notifyConversionResult(ConversionStatus.OVERFLOW);
            } else {
                listener.notifyConversionResult(ConversionStatus.SUCCESS);
            }
            return bigInteger.byteValue();
        }

        public static short toUInt8(BigInteger bigInteger, Listener listener) {
            assert (bigInteger != null);
            if (bigInteger.compareTo(BigInteger.ZERO) < 0 || bigInteger.compareTo(s_2ToThePowerOf8) >= 0) {
                listener.notifyConversionResult(ConversionStatus.OVERFLOW);
                bigInteger = bigInteger.mod(s_2ToThePowerOf8);
            } else {
                listener.notifyConversionResult(ConversionStatus.SUCCESS);
            }
            return bigInteger.shortValue();
        }

        public static short toShort(BigInteger bigInteger, Listener listener) {
            assert (bigInteger != null);
            if (bigInteger.compareTo(s_minShort) < 0 || bigInteger.compareTo(s_maxShort) > 0) {
                listener.notifyConversionResult(ConversionStatus.OVERFLOW);
            } else {
                listener.notifyConversionResult(ConversionStatus.SUCCESS);
            }
            return bigInteger.shortValue();
        }

        public static int toUInt16(BigInteger bigInteger, Listener listener) {
            assert (bigInteger != null);
            if (bigInteger.compareTo(BigInteger.ZERO) < 0 || bigInteger.compareTo(s_2ToThePowerOf16) >= 0) {
                listener.notifyConversionResult(ConversionStatus.OVERFLOW);
                bigInteger = bigInteger.mod(s_2ToThePowerOf16);
            } else {
                listener.notifyConversionResult(ConversionStatus.SUCCESS);
            }
            return bigInteger.intValue();
        }

        public static int toInt(BigInteger bigInteger, Listener listener) {
            assert (bigInteger != null);
            if (bigInteger.compareTo(s_minInt) < 0 || bigInteger.compareTo(s_maxInt) > 0) {
                listener.notifyConversionResult(ConversionStatus.OVERFLOW);
            } else {
                listener.notifyConversionResult(ConversionStatus.SUCCESS);
            }
            return bigInteger.intValue();
        }

        public static long toUInt32(BigInteger bigInteger, Listener listener) {
            assert (bigInteger != null);
            if (bigInteger.compareTo(BigInteger.ZERO) < 0 || bigInteger.compareTo(s_2ToThePowerOf32) >= 0) {
                listener.notifyConversionResult(ConversionStatus.OVERFLOW);
                bigInteger = bigInteger.mod(s_2ToThePowerOf32);
            } else {
                listener.notifyConversionResult(ConversionStatus.SUCCESS);
            }
            return bigInteger.longValue();
        }

        public static long toLong(BigInteger bigInteger, Listener listener) {
            assert (bigInteger != null);
            if (bigInteger.compareTo(s_minLong) < 0 || bigInteger.compareTo(s_maxLong) > 0) {
                listener.notifyConversionResult(ConversionStatus.OVERFLOW);
            } else {
                listener.notifyConversionResult(ConversionStatus.SUCCESS);
            }
            return bigInteger.longValue();
        }

        public static BigInteger toUInt64(BigInteger bigInteger, Listener listener) {
            assert (bigInteger != null);
            if (bigInteger.compareTo(BigInteger.ZERO) < 0 || bigInteger.compareTo(s_2ToThePowerOf64) >= 0) {
                listener.notifyConversionResult(ConversionStatus.OVERFLOW);
                bigInteger = bigInteger.mod(s_2ToThePowerOf64);
            } else {
                listener.notifyConversionResult(ConversionStatus.SUCCESS);
            }
            return bigInteger;
        }
    }

    public static final class DecimalConverter {
        private static final BigDecimal s_minByte = BigDecimal.valueOf(-128L);
        private static final BigDecimal s_maxByte = BigDecimal.valueOf(127L);
        private static final BigInteger s_2ToThePowerOf8 = BigInteger.valueOf(256L);
        private static final BigDecimal s_minShort = BigDecimal.valueOf(-32768L);
        private static final BigDecimal s_maxShort = BigDecimal.valueOf(32767L);
        private static final BigInteger s_2ToThePowerOf16 = BigInteger.valueOf(65536L);
        private static final BigDecimal s_minInt = BigDecimal.valueOf(Integer.MIN_VALUE);
        private static final BigDecimal s_maxInt = BigDecimal.valueOf(Integer.MAX_VALUE);
        private static final BigInteger s_2ToThePowerOf32 = BigInteger.valueOf(0x100000000L);
        private static final BigDecimal s_minLong = BigDecimal.valueOf(Long.MIN_VALUE);
        private static final BigDecimal s_maxLong = BigDecimal.valueOf(Long.MAX_VALUE);
        private static final BigInteger s_2ToThePowerOf64 = BigInteger.valueOf(2L).pow(64);

        public static BigInteger toBigInt(BigDecimal bigDecimal, Listener listener) {
            assert (bigDecimal != null);
            try {
                BigInteger bigInteger = bigDecimal.toBigIntegerExact();
                listener.notifyConversionResult(ConversionStatus.SUCCESS);
                return bigInteger;
            }
            catch (ArithmeticException arithmeticException) {
                listener.notifyConversionResult(ConversionStatus.FRACTIONAL_TRUNCATION);
                return bigDecimal.toBigInteger();
            }
        }

        public static byte toByte(BigDecimal bigDecimal, Listener listener) {
            assert (bigDecimal != null);
            if (bigDecimal.compareTo(s_minByte) < 0 || bigDecimal.compareTo(s_maxByte) > 0) {
                listener.notifyConversionResult(ConversionStatus.OVERFLOW);
            } else {
                try {
                    byte by = bigDecimal.byteValueExact();
                    listener.notifyConversionResult(ConversionStatus.SUCCESS);
                    return by;
                }
                catch (ArithmeticException arithmeticException) {
                    listener.notifyConversionResult(ConversionStatus.FRACTIONAL_TRUNCATION);
                }
            }
            return bigDecimal.byteValue();
        }

        public static short toUInt8(BigDecimal bigDecimal, Listener listener) {
            BigInteger bigInteger;
            assert (bigDecimal != null);
            boolean bl = false;
            try {
                bigInteger = bigDecimal.toBigIntegerExact();
            }
            catch (ArithmeticException arithmeticException) {
                bl = true;
                bigInteger = bigDecimal.toBigInteger();
            }
            boolean bl2 = false;
            if (bigInteger.compareTo(BigInteger.ZERO) < 0 || bigInteger.compareTo(s_2ToThePowerOf8) >= 0) {
                listener.notifyConversionResult(ConversionStatus.OVERFLOW);
                bl2 = true;
                bigInteger = bigInteger.mod(s_2ToThePowerOf8);
            }
            if (!bl2) {
                if (bl) {
                    listener.notifyConversionResult(ConversionStatus.FRACTIONAL_TRUNCATION);
                } else {
                    listener.notifyConversionResult(ConversionStatus.SUCCESS);
                }
            }
            return bigInteger.shortValue();
        }

        public static short toShort(BigDecimal bigDecimal, Listener listener) {
            assert (bigDecimal != null);
            if (bigDecimal.compareTo(s_minShort) < 0 || bigDecimal.compareTo(s_maxShort) > 0) {
                listener.notifyConversionResult(ConversionStatus.OVERFLOW);
            } else {
                try {
                    short s = bigDecimal.shortValueExact();
                    listener.notifyConversionResult(ConversionStatus.SUCCESS);
                    return s;
                }
                catch (ArithmeticException arithmeticException) {
                    listener.notifyConversionResult(ConversionStatus.FRACTIONAL_TRUNCATION);
                }
            }
            return bigDecimal.shortValue();
        }

        public static int toUInt16(BigDecimal bigDecimal, Listener listener) {
            BigInteger bigInteger;
            assert (bigDecimal != null);
            boolean bl = false;
            try {
                bigInteger = bigDecimal.toBigIntegerExact();
            }
            catch (ArithmeticException arithmeticException) {
                bl = true;
                bigInteger = bigDecimal.toBigInteger();
            }
            boolean bl2 = false;
            if (bigInteger.compareTo(BigInteger.ZERO) < 0 || bigInteger.compareTo(s_2ToThePowerOf16) >= 0) {
                listener.notifyConversionResult(ConversionStatus.OVERFLOW);
                bl2 = true;
                bigInteger = bigInteger.mod(s_2ToThePowerOf16);
            }
            if (!bl2) {
                if (bl) {
                    listener.notifyConversionResult(ConversionStatus.FRACTIONAL_TRUNCATION);
                } else {
                    listener.notifyConversionResult(ConversionStatus.SUCCESS);
                }
            }
            return bigInteger.intValue();
        }

        public static int toInt(BigDecimal bigDecimal, Listener listener) {
            assert (bigDecimal != null);
            if (bigDecimal.compareTo(s_minInt) < 0 || bigDecimal.compareTo(s_maxInt) > 0) {
                listener.notifyConversionResult(ConversionStatus.OVERFLOW);
            } else {
                try {
                    int n = bigDecimal.intValueExact();
                    listener.notifyConversionResult(ConversionStatus.SUCCESS);
                    return n;
                }
                catch (ArithmeticException arithmeticException) {
                    listener.notifyConversionResult(ConversionStatus.FRACTIONAL_TRUNCATION);
                }
            }
            return bigDecimal.intValue();
        }

        public static long toUInt32(BigDecimal bigDecimal, Listener listener) {
            BigInteger bigInteger;
            assert (bigDecimal != null);
            boolean bl = false;
            try {
                bigInteger = bigDecimal.toBigIntegerExact();
            }
            catch (ArithmeticException arithmeticException) {
                bl = true;
                bigInteger = bigDecimal.toBigInteger();
            }
            boolean bl2 = false;
            if (bigInteger.compareTo(BigInteger.ZERO) < 0 || bigInteger.compareTo(s_2ToThePowerOf32) >= 0) {
                listener.notifyConversionResult(ConversionStatus.OVERFLOW);
                bl2 = true;
                bigInteger = bigInteger.mod(s_2ToThePowerOf32);
            }
            if (!bl2) {
                if (bl) {
                    listener.notifyConversionResult(ConversionStatus.FRACTIONAL_TRUNCATION);
                } else {
                    listener.notifyConversionResult(ConversionStatus.SUCCESS);
                }
            }
            return bigInteger.longValue();
        }

        public static long toLong(BigDecimal bigDecimal, Listener listener) {
            assert (bigDecimal != null);
            if (bigDecimal.compareTo(s_minLong) < 0 || bigDecimal.compareTo(s_maxLong) > 0) {
                listener.notifyConversionResult(ConversionStatus.OVERFLOW);
            } else {
                try {
                    long l = bigDecimal.longValueExact();
                    listener.notifyConversionResult(ConversionStatus.SUCCESS);
                    return l;
                }
                catch (ArithmeticException arithmeticException) {
                    listener.notifyConversionResult(ConversionStatus.FRACTIONAL_TRUNCATION);
                }
            }
            return bigDecimal.longValue();
        }

        public static BigInteger toUInt64(BigDecimal bigDecimal, Listener listener) {
            BigInteger bigInteger;
            assert (bigDecimal != null);
            boolean bl = false;
            try {
                bigInteger = bigDecimal.toBigIntegerExact();
            }
            catch (ArithmeticException arithmeticException) {
                bl = true;
                bigInteger = bigDecimal.toBigInteger();
            }
            boolean bl2 = false;
            if (bigInteger.compareTo(BigInteger.ZERO) < 0 || bigInteger.compareTo(s_2ToThePowerOf64) >= 0) {
                listener.notifyConversionResult(ConversionStatus.OVERFLOW);
                bl2 = true;
                bigInteger = bigInteger.mod(s_2ToThePowerOf64);
            }
            if (!bl2) {
                if (bl) {
                    listener.notifyConversionResult(ConversionStatus.FRACTIONAL_TRUNCATION);
                } else {
                    listener.notifyConversionResult(ConversionStatus.SUCCESS);
                }
            }
            return bigInteger;
        }
    }

    public static class SimpleListener
    implements Listener {
        private ConversionStatus m_status;

        @Override
        public void notifyConversionResult(ConversionStatus conversionStatus) {
            assert (conversionStatus != null);
            this.m_status = conversionStatus;
        }

        public ConversionStatus getStatus() {
            return this.m_status;
        }

        public void clearStatus() {
            this.m_status = null;
        }
    }

    public static interface Listener {
        public void notifyConversionResult(ConversionStatus var1);
    }

    public static enum ConversionStatus {
        SUCCESS,
        OVERFLOW,
        FRACTIONAL_TRUNCATION;

    }

    public static final class HexStringReader
    extends Reader {
        private byte[] m_buffer = new byte[1024];
        private InputStream m_inputStream;
        private final boolean m_closeWrapped;

        public HexStringReader(InputStream inputStream, boolean bl) {
            this.m_inputStream = inputStream;
            this.m_closeWrapped = bl;
        }

        @Override
        public int read(char[] cArray, int n, int n2) throws IOException {
            int n3;
            assert (cArray != null);
            assert (n < cArray.length);
            assert (cArray.length - n >= n2);
            if (n2 == 0) {
                return 0;
            }
            int n4 = 0;
            for (int i = n2 / 2; i > 0 && (n3 = this.m_inputStream.read(this.m_buffer, 0, Math.min(i, this.m_buffer.length))) > 0; i -= n3) {
                NonTrivialJDBCConversions.bytesToHexChars(this.m_buffer, n3, cArray, n + n4);
                n4 += n3 * 2;
            }
            return n4 > 0 ? n4 : -1;
        }

        @Override
        public long skip(long l) throws IOException {
            return 2L * this.m_inputStream.skip(l / 2L);
        }

        @Override
        public boolean markSupported() {
            return this.m_inputStream.markSupported();
        }

        @Override
        public void mark(int n) throws IOException {
            this.m_inputStream.mark(n / 2);
        }

        @Override
        public void reset() throws IOException {
            this.m_inputStream.reset();
        }

        @Override
        public void close() throws IOException {
            if (this.m_inputStream != null) {
                if (this.m_closeWrapped) {
                    this.m_inputStream.close();
                }
                this.m_inputStream = null;
                this.m_buffer = null;
            }
        }
    }
}

