/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.snowflake.sqlgenerator;

import liquibase.database.Database;
import liquibase.ext.snowflake.database.SnowflakeDatabase;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.DropDefaultValueGenerator;
import liquibase.statement.core.DropDefaultValueStatement;
import liquibase.structure.DatabaseObject;

public class SnowflakeDropDefaultValueGenerator
extends DropDefaultValueGenerator {
    public int getPriority() {
        return 5;
    }

    public boolean supports(DropDefaultValueStatement statement, Database database) {
        return database instanceof SnowflakeDatabase;
    }

    public Sql[] generateSql(DropDefaultValueStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        return new Sql[]{new UnparsedSql("ALTER TABLE " + database.escapeTableName(statement.getCatalogName(), statement.getSchemaName(), statement.getTableName()) + " ALTER COLUMN " + database.escapeColumnName(statement.getCatalogName(), statement.getSchemaName(), statement.getTableName(), statement.getColumnName()) + " DROP DEFAULT", new DatabaseObject[0])};
    }
}

