# Copyright (c) 2021 AccelByte Inc. All Rights Reserved.
# This is licensed software from AccelByte Inc, for limitations
# and restrictions contact your company contract manager.
#
# Code generated. DO NOT EDIT!

# template file: wrapper.j2

# pylint: disable=duplicate-code
# pylint: disable=line-too-long
# pylint: disable=missing-function-docstring
# pylint: disable=missing-function-docstring
# pylint: disable=missing-module-docstring
# pylint: disable=too-many-arguments
# pylint: disable=too-many-branches
# pylint: disable=too-many-instance-attributes
# pylint: disable=too-many-lines
# pylint: disable=too-many-locals
# pylint: disable=too-many-public-methods
# pylint: disable=too-many-return-statements
# pylint: disable=too-many-statements
# pylint: disable=unused-import

from typing import Any, Dict, List, Optional, Tuple, Union

from accelbyte_py_sdk.core import HeaderStr
from accelbyte_py_sdk.core import get_namespace as get_services_namespace
from accelbyte_py_sdk.core import run_request
from accelbyte_py_sdk.core import run_request_async
from accelbyte_py_sdk.core import same_doc_as

from ..models import ModelsDeleteBulkLeaderboardsReq
from ..models import ModelsDeleteBulkLeaderboardsResp
from ..models import ModelsGetAllLeaderboardConfigsPublicRespV3
from ..models import ModelsGetAllLeaderboardConfigsRespV3
from ..models import ModelsGetLeaderboardConfigPublicRespV3
from ..models import ModelsGetLeaderboardConfigRespV3
from ..models import ModelsLeaderboardConfigReqV3
from ..models import ModelsUpdateLeaderboardConfigReqV3
from ..models import ResponseErrorResponse

from ..operations.leaderboard_configuration_v3 import (
    CreateLeaderboardConfigurationAdminV3,
)
from ..operations.leaderboard_configuration_v3 import (
    DeleteBulkLeaderboardConfigurationAdminV3,
)
from ..operations.leaderboard_configuration_v3 import (
    DeleteLeaderboardConfigurationAdminV3,
)
from ..operations.leaderboard_configuration_v3 import GetLeaderboardConfigurationAdminV3
from ..operations.leaderboard_configuration_v3 import (
    GetLeaderboardConfigurationPublicV3,
)
from ..operations.leaderboard_configuration_v3 import (
    GetLeaderboardConfigurationsAdminV3,
)
from ..operations.leaderboard_configuration_v3 import (
    GetLeaderboardConfigurationsPublicV3,
)
from ..operations.leaderboard_configuration_v3 import HardDeleteLeaderboardAdminV3
from ..operations.leaderboard_configuration_v3 import (
    UpdateLeaderboardConfigurationAdminV3,
)


@same_doc_as(CreateLeaderboardConfigurationAdminV3)
def create_leaderboard_configuration_admin_v3(
    body: ModelsLeaderboardConfigReqV3,
    namespace: Optional[str] = None,
    x_additional_headers: Optional[Dict[str, str]] = None,
    **kwargs
):
    """create new leaderboard (createLeaderboardConfigurationAdminV3)

    Required permission 'ADMIN:NAMESPACE:{namespace}:LEADERBOARD [CREATE]'

     Fields :




      * leaderboardCode: unique leaderboard config code must be lowercase and maximum length is 48 characters. (required).


      * name: leaderboard name, maximum length for leaderboard name is 128 characters. (required).


      * description: leaderboard description, maximum length for leaderboard description is 2048 characters. (optional).


      * iconURL: leaderboard icon image url. (optional).


      * allTime: if true, all time leaderboard will be created. (required).


      * descending: leaderboard order. If true, the points will be sorted in descending order. (required).


      * statCode: Stat Code is related with statistic code in statistic service. (required).


      * cycleIds: Statistic cycle ids that will be tracked in the leaderboard. (required).

    Required Permission(s):
        - ADMIN:NAMESPACE:{namespace}:LEADERBOARD [CREATE]

    Properties:
        url: /leaderboard/v3/admin/namespaces/{namespace}/leaderboards

        method: POST

        tags: ["LeaderboardConfigurationV3"]

        consumes: ["application/json"]

        produces: ["application/json"]

        securities: [BEARER_AUTH]

        body: (body) REQUIRED ModelsLeaderboardConfigReqV3 in body

        namespace: (namespace) REQUIRED str in path

    Responses:
        201: Created - ModelsGetLeaderboardConfigRespV3 (Created)

        400: Bad Request - ResponseErrorResponse (Bad Request)

        401: Unauthorized - ResponseErrorResponse (Unauthorized)

        403: Forbidden - ResponseErrorResponse (Forbidden)

        409: Conflict - ResponseErrorResponse (Conflict)

        500: Internal Server Error - ResponseErrorResponse (Internal Server Error)
    """
    if namespace is None:
        namespace, error = get_services_namespace()
        if error:
            return None, error
    request = CreateLeaderboardConfigurationAdminV3.create(
        body=body,
        namespace=namespace,
    )
    return run_request(request, additional_headers=x_additional_headers, **kwargs)


@same_doc_as(CreateLeaderboardConfigurationAdminV3)
async def create_leaderboard_configuration_admin_v3_async(
    body: ModelsLeaderboardConfigReqV3,
    namespace: Optional[str] = None,
    x_additional_headers: Optional[Dict[str, str]] = None,
    **kwargs
):
    """create new leaderboard (createLeaderboardConfigurationAdminV3)

    Required permission 'ADMIN:NAMESPACE:{namespace}:LEADERBOARD [CREATE]'

     Fields :




      * leaderboardCode: unique leaderboard config code must be lowercase and maximum length is 48 characters. (required).


      * name: leaderboard name, maximum length for leaderboard name is 128 characters. (required).


      * description: leaderboard description, maximum length for leaderboard description is 2048 characters. (optional).


      * iconURL: leaderboard icon image url. (optional).


      * allTime: if true, all time leaderboard will be created. (required).


      * descending: leaderboard order. If true, the points will be sorted in descending order. (required).


      * statCode: Stat Code is related with statistic code in statistic service. (required).


      * cycleIds: Statistic cycle ids that will be tracked in the leaderboard. (required).

    Required Permission(s):
        - ADMIN:NAMESPACE:{namespace}:LEADERBOARD [CREATE]

    Properties:
        url: /leaderboard/v3/admin/namespaces/{namespace}/leaderboards

        method: POST

        tags: ["LeaderboardConfigurationV3"]

        consumes: ["application/json"]

        produces: ["application/json"]

        securities: [BEARER_AUTH]

        body: (body) REQUIRED ModelsLeaderboardConfigReqV3 in body

        namespace: (namespace) REQUIRED str in path

    Responses:
        201: Created - ModelsGetLeaderboardConfigRespV3 (Created)

        400: Bad Request - ResponseErrorResponse (Bad Request)

        401: Unauthorized - ResponseErrorResponse (Unauthorized)

        403: Forbidden - ResponseErrorResponse (Forbidden)

        409: Conflict - ResponseErrorResponse (Conflict)

        500: Internal Server Error - ResponseErrorResponse (Internal Server Error)
    """
    if namespace is None:
        namespace, error = get_services_namespace()
        if error:
            return None, error
    request = CreateLeaderboardConfigurationAdminV3.create(
        body=body,
        namespace=namespace,
    )
    return await run_request_async(
        request, additional_headers=x_additional_headers, **kwargs
    )


@same_doc_as(DeleteBulkLeaderboardConfigurationAdminV3)
def delete_bulk_leaderboard_configuration_admin_v3(
    body: ModelsDeleteBulkLeaderboardsReq,
    namespace: Optional[str] = None,
    x_additional_headers: Optional[Dict[str, str]] = None,
    **kwargs
):
    """delete bulk leaderboards. response body will contains failed leaderboard with the reason why it's failed to delete (deleteBulkLeaderboardConfigurationAdminV3)

    Required permission 'ADMIN:NAMESPACE:{namespace}:LEADERBOARD [DELETE]'




    This endpoint delete multiple leaderboards configuration in one request

    Required Permission(s):
        - ADMIN:NAMESPACE:{namespace}:LEADERBOARD [DELETE]

    Properties:
        url: /leaderboard/v3/admin/namespaces/{namespace}/leaderboards/delete

        method: POST

        tags: ["LeaderboardConfigurationV3"]

        consumes: ["application/json"]

        produces: ["application/json"]

        securities: [BEARER_AUTH]

        body: (body) REQUIRED ModelsDeleteBulkLeaderboardsReq in body

        namespace: (namespace) REQUIRED str in path

    Responses:
        200: OK - ModelsDeleteBulkLeaderboardsResp (OK)

        400: Bad Request - ResponseErrorResponse (Bad Request)

        401: Unauthorized - ResponseErrorResponse (Unauthorized)

        403: Forbidden - ResponseErrorResponse (Forbidden)

        500: Internal Server Error - ResponseErrorResponse (Internal Server Error)
    """
    if namespace is None:
        namespace, error = get_services_namespace()
        if error:
            return None, error
    request = DeleteBulkLeaderboardConfigurationAdminV3.create(
        body=body,
        namespace=namespace,
    )
    return run_request(request, additional_headers=x_additional_headers, **kwargs)


@same_doc_as(DeleteBulkLeaderboardConfigurationAdminV3)
async def delete_bulk_leaderboard_configuration_admin_v3_async(
    body: ModelsDeleteBulkLeaderboardsReq,
    namespace: Optional[str] = None,
    x_additional_headers: Optional[Dict[str, str]] = None,
    **kwargs
):
    """delete bulk leaderboards. response body will contains failed leaderboard with the reason why it's failed to delete (deleteBulkLeaderboardConfigurationAdminV3)

    Required permission 'ADMIN:NAMESPACE:{namespace}:LEADERBOARD [DELETE]'




    This endpoint delete multiple leaderboards configuration in one request

    Required Permission(s):
        - ADMIN:NAMESPACE:{namespace}:LEADERBOARD [DELETE]

    Properties:
        url: /leaderboard/v3/admin/namespaces/{namespace}/leaderboards/delete

        method: POST

        tags: ["LeaderboardConfigurationV3"]

        consumes: ["application/json"]

        produces: ["application/json"]

        securities: [BEARER_AUTH]

        body: (body) REQUIRED ModelsDeleteBulkLeaderboardsReq in body

        namespace: (namespace) REQUIRED str in path

    Responses:
        200: OK - ModelsDeleteBulkLeaderboardsResp (OK)

        400: Bad Request - ResponseErrorResponse (Bad Request)

        401: Unauthorized - ResponseErrorResponse (Unauthorized)

        403: Forbidden - ResponseErrorResponse (Forbidden)

        500: Internal Server Error - ResponseErrorResponse (Internal Server Error)
    """
    if namespace is None:
        namespace, error = get_services_namespace()
        if error:
            return None, error
    request = DeleteBulkLeaderboardConfigurationAdminV3.create(
        body=body,
        namespace=namespace,
    )
    return await run_request_async(
        request, additional_headers=x_additional_headers, **kwargs
    )


@same_doc_as(DeleteLeaderboardConfigurationAdminV3)
def delete_leaderboard_configuration_admin_v3(
    leaderboard_code: str,
    namespace: Optional[str] = None,
    x_additional_headers: Optional[Dict[str, str]] = None,
    **kwargs
):
    """delete leaderboard by leaderboardCode (deleteLeaderboardConfigurationAdminV3)

    Required permission 'ADMIN:NAMESPACE:{namespace}:LEADERBOARD [DELETE]'




    This endpoint delete a leaderboard configuration

    Required Permission(s):
        - ADMIN:NAMESPACE:{namespace}:LEADERBOARD [DELETE]

    Properties:
        url: /leaderboard/v3/admin/namespaces/{namespace}/leaderboards/{leaderboardCode}

        method: DELETE

        tags: ["LeaderboardConfigurationV3"]

        consumes: []

        produces: ["application/json"]

        securities: [BEARER_AUTH]

        leaderboard_code: (leaderboardCode) REQUIRED str in path

        namespace: (namespace) REQUIRED str in path

    Responses:
        204: No Content - (No Content)

        400: Bad Request - ResponseErrorResponse (Bad Request)

        401: Unauthorized - ResponseErrorResponse (Unauthorized)

        403: Forbidden - ResponseErrorResponse (Forbidden)

        404: Not Found - ResponseErrorResponse (Not Found)

        500: Internal Server Error - ResponseErrorResponse (Internal Server Error)
    """
    if namespace is None:
        namespace, error = get_services_namespace()
        if error:
            return None, error
    request = DeleteLeaderboardConfigurationAdminV3.create(
        leaderboard_code=leaderboard_code,
        namespace=namespace,
    )
    return run_request(request, additional_headers=x_additional_headers, **kwargs)


@same_doc_as(DeleteLeaderboardConfigurationAdminV3)
async def delete_leaderboard_configuration_admin_v3_async(
    leaderboard_code: str,
    namespace: Optional[str] = None,
    x_additional_headers: Optional[Dict[str, str]] = None,
    **kwargs
):
    """delete leaderboard by leaderboardCode (deleteLeaderboardConfigurationAdminV3)

    Required permission 'ADMIN:NAMESPACE:{namespace}:LEADERBOARD [DELETE]'




    This endpoint delete a leaderboard configuration

    Required Permission(s):
        - ADMIN:NAMESPACE:{namespace}:LEADERBOARD [DELETE]

    Properties:
        url: /leaderboard/v3/admin/namespaces/{namespace}/leaderboards/{leaderboardCode}

        method: DELETE

        tags: ["LeaderboardConfigurationV3"]

        consumes: []

        produces: ["application/json"]

        securities: [BEARER_AUTH]

        leaderboard_code: (leaderboardCode) REQUIRED str in path

        namespace: (namespace) REQUIRED str in path

    Responses:
        204: No Content - (No Content)

        400: Bad Request - ResponseErrorResponse (Bad Request)

        401: Unauthorized - ResponseErrorResponse (Unauthorized)

        403: Forbidden - ResponseErrorResponse (Forbidden)

        404: Not Found - ResponseErrorResponse (Not Found)

        500: Internal Server Error - ResponseErrorResponse (Internal Server Error)
    """
    if namespace is None:
        namespace, error = get_services_namespace()
        if error:
            return None, error
    request = DeleteLeaderboardConfigurationAdminV3.create(
        leaderboard_code=leaderboard_code,
        namespace=namespace,
    )
    return await run_request_async(
        request, additional_headers=x_additional_headers, **kwargs
    )


@same_doc_as(GetLeaderboardConfigurationAdminV3)
def get_leaderboard_configuration_admin_v3(
    leaderboard_code: str,
    namespace: Optional[str] = None,
    x_additional_headers: Optional[Dict[str, str]] = None,
    **kwargs
):
    """get leaderboard by leaderboardCode (getLeaderboardConfigurationAdminV3)

    Required permission 'ADMIN:NAMESPACE:{namespace}:LEADERBOARD [READ]'




    This endpoint returns a leaderboard configuration

    Required Permission(s):
        - ADMIN:NAMESPACE:{namespace}:LEADERBOARD [READ]

    Properties:
        url: /leaderboard/v3/admin/namespaces/{namespace}/leaderboards/{leaderboardCode}

        method: GET

        tags: ["LeaderboardConfigurationV3"]

        consumes: []

        produces: ["application/json"]

        securities: [BEARER_AUTH]

        leaderboard_code: (leaderboardCode) REQUIRED str in path

        namespace: (namespace) REQUIRED str in path

    Responses:
        200: OK - ModelsGetLeaderboardConfigRespV3 (OK)

        400: Bad Request - ResponseErrorResponse (Bad Request)

        401: Unauthorized - ResponseErrorResponse (Unauthorized)

        403: Forbidden - ResponseErrorResponse (Forbidden)

        404: Not Found - ResponseErrorResponse (Not Found)

        500: Internal Server Error - ResponseErrorResponse (Internal Server Error)
    """
    if namespace is None:
        namespace, error = get_services_namespace()
        if error:
            return None, error
    request = GetLeaderboardConfigurationAdminV3.create(
        leaderboard_code=leaderboard_code,
        namespace=namespace,
    )
    return run_request(request, additional_headers=x_additional_headers, **kwargs)


@same_doc_as(GetLeaderboardConfigurationAdminV3)
async def get_leaderboard_configuration_admin_v3_async(
    leaderboard_code: str,
    namespace: Optional[str] = None,
    x_additional_headers: Optional[Dict[str, str]] = None,
    **kwargs
):
    """get leaderboard by leaderboardCode (getLeaderboardConfigurationAdminV3)

    Required permission 'ADMIN:NAMESPACE:{namespace}:LEADERBOARD [READ]'




    This endpoint returns a leaderboard configuration

    Required Permission(s):
        - ADMIN:NAMESPACE:{namespace}:LEADERBOARD [READ]

    Properties:
        url: /leaderboard/v3/admin/namespaces/{namespace}/leaderboards/{leaderboardCode}

        method: GET

        tags: ["LeaderboardConfigurationV3"]

        consumes: []

        produces: ["application/json"]

        securities: [BEARER_AUTH]

        leaderboard_code: (leaderboardCode) REQUIRED str in path

        namespace: (namespace) REQUIRED str in path

    Responses:
        200: OK - ModelsGetLeaderboardConfigRespV3 (OK)

        400: Bad Request - ResponseErrorResponse (Bad Request)

        401: Unauthorized - ResponseErrorResponse (Unauthorized)

        403: Forbidden - ResponseErrorResponse (Forbidden)

        404: Not Found - ResponseErrorResponse (Not Found)

        500: Internal Server Error - ResponseErrorResponse (Internal Server Error)
    """
    if namespace is None:
        namespace, error = get_services_namespace()
        if error:
            return None, error
    request = GetLeaderboardConfigurationAdminV3.create(
        leaderboard_code=leaderboard_code,
        namespace=namespace,
    )
    return await run_request_async(
        request, additional_headers=x_additional_headers, **kwargs
    )


@same_doc_as(GetLeaderboardConfigurationPublicV3)
def get_leaderboard_configuration_public_v3(
    leaderboard_code: str,
    namespace: Optional[str] = None,
    x_additional_headers: Optional[Dict[str, str]] = None,
    **kwargs
):
    """get leaderboard by leaderboardCode (getLeaderboardConfigurationPublicV3)

    This endpoint returns a leaderboard configuration

    Properties:
        url: /leaderboard/v3/public/namespaces/{namespace}/leaderboards/{leaderboardCode}

        method: GET

        tags: ["LeaderboardConfigurationV3"]

        consumes: []

        produces: ["application/json"]

        securities: [BEARER_AUTH]

        leaderboard_code: (leaderboardCode) REQUIRED str in path

        namespace: (namespace) REQUIRED str in path

    Responses:
        200: OK - ModelsGetLeaderboardConfigPublicRespV3 (OK)

        400: Bad Request - ResponseErrorResponse (Bad Request)

        401: Unauthorized - ResponseErrorResponse (Unauthorized)

        403: Forbidden - ResponseErrorResponse (Forbidden)

        404: Not Found - ResponseErrorResponse (Not Found)

        500: Internal Server Error - ResponseErrorResponse (Internal Server Error)
    """
    if namespace is None:
        namespace, error = get_services_namespace()
        if error:
            return None, error
    request = GetLeaderboardConfigurationPublicV3.create(
        leaderboard_code=leaderboard_code,
        namespace=namespace,
    )
    return run_request(request, additional_headers=x_additional_headers, **kwargs)


@same_doc_as(GetLeaderboardConfigurationPublicV3)
async def get_leaderboard_configuration_public_v3_async(
    leaderboard_code: str,
    namespace: Optional[str] = None,
    x_additional_headers: Optional[Dict[str, str]] = None,
    **kwargs
):
    """get leaderboard by leaderboardCode (getLeaderboardConfigurationPublicV3)

    This endpoint returns a leaderboard configuration

    Properties:
        url: /leaderboard/v3/public/namespaces/{namespace}/leaderboards/{leaderboardCode}

        method: GET

        tags: ["LeaderboardConfigurationV3"]

        consumes: []

        produces: ["application/json"]

        securities: [BEARER_AUTH]

        leaderboard_code: (leaderboardCode) REQUIRED str in path

        namespace: (namespace) REQUIRED str in path

    Responses:
        200: OK - ModelsGetLeaderboardConfigPublicRespV3 (OK)

        400: Bad Request - ResponseErrorResponse (Bad Request)

        401: Unauthorized - ResponseErrorResponse (Unauthorized)

        403: Forbidden - ResponseErrorResponse (Forbidden)

        404: Not Found - ResponseErrorResponse (Not Found)

        500: Internal Server Error - ResponseErrorResponse (Internal Server Error)
    """
    if namespace is None:
        namespace, error = get_services_namespace()
        if error:
            return None, error
    request = GetLeaderboardConfigurationPublicV3.create(
        leaderboard_code=leaderboard_code,
        namespace=namespace,
    )
    return await run_request_async(
        request, additional_headers=x_additional_headers, **kwargs
    )


@same_doc_as(GetLeaderboardConfigurationsAdminV3)
def get_leaderboard_configurations_admin_v3(
    is_deleted: Optional[bool] = None,
    limit: Optional[int] = None,
    offset: Optional[int] = None,
    namespace: Optional[str] = None,
    x_additional_headers: Optional[Dict[str, str]] = None,
    **kwargs
):
    """list all leaderboards by given namespace (getLeaderboardConfigurationsAdminV3)

    Required permission 'ADMIN:NAMESPACE:{namespace}:LEADERBOARD [READ]'




    This endpoint return all leaderboard configurations

    Required Permission(s):
        - ADMIN:NAMESPACE:{namespace}:LEADERBOARD [READ]

    Properties:
        url: /leaderboard/v3/admin/namespaces/{namespace}/leaderboards

        method: GET

        tags: ["LeaderboardConfigurationV3"]

        consumes: []

        produces: ["application/json"]

        securities: [BEARER_AUTH]

        namespace: (namespace) REQUIRED str in path

        is_deleted: (isDeleted) OPTIONAL bool in query

        limit: (limit) OPTIONAL int in query

        offset: (offset) OPTIONAL int in query

    Responses:
        200: OK - ModelsGetAllLeaderboardConfigsRespV3 (OK)

        400: Bad Request - ResponseErrorResponse (Bad Request)

        401: Unauthorized - ResponseErrorResponse (Unauthorized)

        403: Forbidden - ResponseErrorResponse (Forbidden)

        500: Internal Server Error - ResponseErrorResponse (Internal Server Error)
    """
    if namespace is None:
        namespace, error = get_services_namespace()
        if error:
            return None, error
    request = GetLeaderboardConfigurationsAdminV3.create(
        is_deleted=is_deleted,
        limit=limit,
        offset=offset,
        namespace=namespace,
    )
    return run_request(request, additional_headers=x_additional_headers, **kwargs)


@same_doc_as(GetLeaderboardConfigurationsAdminV3)
async def get_leaderboard_configurations_admin_v3_async(
    is_deleted: Optional[bool] = None,
    limit: Optional[int] = None,
    offset: Optional[int] = None,
    namespace: Optional[str] = None,
    x_additional_headers: Optional[Dict[str, str]] = None,
    **kwargs
):
    """list all leaderboards by given namespace (getLeaderboardConfigurationsAdminV3)

    Required permission 'ADMIN:NAMESPACE:{namespace}:LEADERBOARD [READ]'




    This endpoint return all leaderboard configurations

    Required Permission(s):
        - ADMIN:NAMESPACE:{namespace}:LEADERBOARD [READ]

    Properties:
        url: /leaderboard/v3/admin/namespaces/{namespace}/leaderboards

        method: GET

        tags: ["LeaderboardConfigurationV3"]

        consumes: []

        produces: ["application/json"]

        securities: [BEARER_AUTH]

        namespace: (namespace) REQUIRED str in path

        is_deleted: (isDeleted) OPTIONAL bool in query

        limit: (limit) OPTIONAL int in query

        offset: (offset) OPTIONAL int in query

    Responses:
        200: OK - ModelsGetAllLeaderboardConfigsRespV3 (OK)

        400: Bad Request - ResponseErrorResponse (Bad Request)

        401: Unauthorized - ResponseErrorResponse (Unauthorized)

        403: Forbidden - ResponseErrorResponse (Forbidden)

        500: Internal Server Error - ResponseErrorResponse (Internal Server Error)
    """
    if namespace is None:
        namespace, error = get_services_namespace()
        if error:
            return None, error
    request = GetLeaderboardConfigurationsAdminV3.create(
        is_deleted=is_deleted,
        limit=limit,
        offset=offset,
        namespace=namespace,
    )
    return await run_request_async(
        request, additional_headers=x_additional_headers, **kwargs
    )


@same_doc_as(GetLeaderboardConfigurationsPublicV3)
def get_leaderboard_configurations_public_v3(
    is_deleted: Optional[bool] = None,
    limit: Optional[int] = None,
    offset: Optional[int] = None,
    namespace: Optional[str] = None,
    x_additional_headers: Optional[Dict[str, str]] = None,
    **kwargs
):
    """list all leaderboards by given namespace (getLeaderboardConfigurationsPublicV3)

    This endpoint return all leaderboard configurations

    Properties:
        url: /leaderboard/v3/public/namespaces/{namespace}/leaderboards

        method: GET

        tags: ["LeaderboardConfigurationV3"]

        consumes: []

        produces: ["application/json"]

        securities: [BEARER_AUTH]

        namespace: (namespace) REQUIRED str in path

        is_deleted: (isDeleted) OPTIONAL bool in query

        limit: (limit) OPTIONAL int in query

        offset: (offset) OPTIONAL int in query

    Responses:
        200: OK - ModelsGetAllLeaderboardConfigsPublicRespV3 (OK)

        400: Bad Request - ResponseErrorResponse (Bad Request)

        401: Unauthorized - ResponseErrorResponse (Unauthorized)

        403: Forbidden - ResponseErrorResponse (Forbidden)

        500: Internal Server Error - ResponseErrorResponse (Internal Server Error)
    """
    if namespace is None:
        namespace, error = get_services_namespace()
        if error:
            return None, error
    request = GetLeaderboardConfigurationsPublicV3.create(
        is_deleted=is_deleted,
        limit=limit,
        offset=offset,
        namespace=namespace,
    )
    return run_request(request, additional_headers=x_additional_headers, **kwargs)


@same_doc_as(GetLeaderboardConfigurationsPublicV3)
async def get_leaderboard_configurations_public_v3_async(
    is_deleted: Optional[bool] = None,
    limit: Optional[int] = None,
    offset: Optional[int] = None,
    namespace: Optional[str] = None,
    x_additional_headers: Optional[Dict[str, str]] = None,
    **kwargs
):
    """list all leaderboards by given namespace (getLeaderboardConfigurationsPublicV3)

    This endpoint return all leaderboard configurations

    Properties:
        url: /leaderboard/v3/public/namespaces/{namespace}/leaderboards

        method: GET

        tags: ["LeaderboardConfigurationV3"]

        consumes: []

        produces: ["application/json"]

        securities: [BEARER_AUTH]

        namespace: (namespace) REQUIRED str in path

        is_deleted: (isDeleted) OPTIONAL bool in query

        limit: (limit) OPTIONAL int in query

        offset: (offset) OPTIONAL int in query

    Responses:
        200: OK - ModelsGetAllLeaderboardConfigsPublicRespV3 (OK)

        400: Bad Request - ResponseErrorResponse (Bad Request)

        401: Unauthorized - ResponseErrorResponse (Unauthorized)

        403: Forbidden - ResponseErrorResponse (Forbidden)

        500: Internal Server Error - ResponseErrorResponse (Internal Server Error)
    """
    if namespace is None:
        namespace, error = get_services_namespace()
        if error:
            return None, error
    request = GetLeaderboardConfigurationsPublicV3.create(
        is_deleted=is_deleted,
        limit=limit,
        offset=offset,
        namespace=namespace,
    )
    return await run_request_async(
        request, additional_headers=x_additional_headers, **kwargs
    )


@same_doc_as(HardDeleteLeaderboardAdminV3)
def hard_delete_leaderboard_admin_v3(
    leaderboard_code: str,
    namespace: Optional[str] = None,
    x_additional_headers: Optional[Dict[str, str]] = None,
    **kwargs
):
    """hard delete leaderboard config and data by leaderboard code (hardDeleteLeaderboardAdminV3)

    [Test Facility Only]




    Required permission 'ADMIN:NAMESPACE:{namespace}:LEADERBOARD [DELETE]'




    This endpoint will delete leaderboard configuration and its data




    Note: this endpoint only works on development environment, you might want to use archive endpoint instead hard delete.

    Required Permission(s):
        - ADMIN:NAMESPACE:{namespace}:LEADERBOARD [DELETE]

    Properties:
        url: /leaderboard/v3/admin/namespaces/{namespace}/leaderboards/{leaderboardCode}/hard

        method: DELETE

        tags: ["LeaderboardConfigurationV3"]

        consumes: []

        produces: ["application/json"]

        securities: [BEARER_AUTH]

        leaderboard_code: (leaderboardCode) REQUIRED str in path

        namespace: (namespace) REQUIRED str in path

    Responses:
        204: No Content - (No Content)

        400: Bad Request - ResponseErrorResponse (Bad Request)

        401: Unauthorized - ResponseErrorResponse (Unauthorized)

        403: Forbidden - ResponseErrorResponse (Forbidden)

        404: Not Found - ResponseErrorResponse (Not Found)

        500: Internal Server Error - ResponseErrorResponse (Internal Server Error)
    """
    if namespace is None:
        namespace, error = get_services_namespace()
        if error:
            return None, error
    request = HardDeleteLeaderboardAdminV3.create(
        leaderboard_code=leaderboard_code,
        namespace=namespace,
    )
    return run_request(request, additional_headers=x_additional_headers, **kwargs)


@same_doc_as(HardDeleteLeaderboardAdminV3)
async def hard_delete_leaderboard_admin_v3_async(
    leaderboard_code: str,
    namespace: Optional[str] = None,
    x_additional_headers: Optional[Dict[str, str]] = None,
    **kwargs
):
    """hard delete leaderboard config and data by leaderboard code (hardDeleteLeaderboardAdminV3)

    [Test Facility Only]




    Required permission 'ADMIN:NAMESPACE:{namespace}:LEADERBOARD [DELETE]'




    This endpoint will delete leaderboard configuration and its data




    Note: this endpoint only works on development environment, you might want to use archive endpoint instead hard delete.

    Required Permission(s):
        - ADMIN:NAMESPACE:{namespace}:LEADERBOARD [DELETE]

    Properties:
        url: /leaderboard/v3/admin/namespaces/{namespace}/leaderboards/{leaderboardCode}/hard

        method: DELETE

        tags: ["LeaderboardConfigurationV3"]

        consumes: []

        produces: ["application/json"]

        securities: [BEARER_AUTH]

        leaderboard_code: (leaderboardCode) REQUIRED str in path

        namespace: (namespace) REQUIRED str in path

    Responses:
        204: No Content - (No Content)

        400: Bad Request - ResponseErrorResponse (Bad Request)

        401: Unauthorized - ResponseErrorResponse (Unauthorized)

        403: Forbidden - ResponseErrorResponse (Forbidden)

        404: Not Found - ResponseErrorResponse (Not Found)

        500: Internal Server Error - ResponseErrorResponse (Internal Server Error)
    """
    if namespace is None:
        namespace, error = get_services_namespace()
        if error:
            return None, error
    request = HardDeleteLeaderboardAdminV3.create(
        leaderboard_code=leaderboard_code,
        namespace=namespace,
    )
    return await run_request_async(
        request, additional_headers=x_additional_headers, **kwargs
    )


@same_doc_as(UpdateLeaderboardConfigurationAdminV3)
def update_leaderboard_configuration_admin_v3(
    body: ModelsUpdateLeaderboardConfigReqV3,
    leaderboard_code: str,
    namespace: Optional[str] = None,
    x_additional_headers: Optional[Dict[str, str]] = None,
    **kwargs
):
    """update leaderboard by leaderboardCode (updateLeaderboardConfigurationAdminV3)

    Required permission 'ADMIN:NAMESPACE:{namespace}:LEADERBOARD [UPDATE]'

     Fields :




      * leaderboardCode: unique leaderboard config code must be lowercase and maximum length is 48 characters. (required).


      * name: leaderboard name, maximum length for leaderboard name is 128 characters. (required).


      * description: leaderboard description, maximum length for leaderboard description is 2048 characters. (optional).


      * iconURL: leaderboard icon image url. (optional).


      * allTime: if true, all time leaderboard will be created. (required).


      * descending: leaderboard order. If true, the points will be sorted in descending order. (required).


      * statCode: Stat Code is related with statistic code in statistic service. (required).


      * cycleIds: Statistic cycle ids that will be tracked in the leaderboard. (required).

    Required Permission(s):
        - ADMIN:NAMESPACE:{namespace}:LEADERBOARD [UPDATE]

    Properties:
        url: /leaderboard/v3/admin/namespaces/{namespace}/leaderboards/{leaderboardCode}

        method: PUT

        tags: ["LeaderboardConfigurationV3"]

        consumes: ["application/json"]

        produces: ["application/json"]

        securities: [BEARER_AUTH]

        body: (body) REQUIRED ModelsUpdateLeaderboardConfigReqV3 in body

        leaderboard_code: (leaderboardCode) REQUIRED str in path

        namespace: (namespace) REQUIRED str in path

    Responses:
        200: OK - ModelsGetLeaderboardConfigRespV3 (OK)

        400: Bad Request - ResponseErrorResponse (Bad Request)

        401: Unauthorized - ResponseErrorResponse (Unauthorized)

        403: Forbidden - ResponseErrorResponse (Forbidden)

        404: Not Found - ResponseErrorResponse (Not Found)

        500: Internal Server Error - ResponseErrorResponse (Internal Server Error)
    """
    if namespace is None:
        namespace, error = get_services_namespace()
        if error:
            return None, error
    request = UpdateLeaderboardConfigurationAdminV3.create(
        body=body,
        leaderboard_code=leaderboard_code,
        namespace=namespace,
    )
    return run_request(request, additional_headers=x_additional_headers, **kwargs)


@same_doc_as(UpdateLeaderboardConfigurationAdminV3)
async def update_leaderboard_configuration_admin_v3_async(
    body: ModelsUpdateLeaderboardConfigReqV3,
    leaderboard_code: str,
    namespace: Optional[str] = None,
    x_additional_headers: Optional[Dict[str, str]] = None,
    **kwargs
):
    """update leaderboard by leaderboardCode (updateLeaderboardConfigurationAdminV3)

    Required permission 'ADMIN:NAMESPACE:{namespace}:LEADERBOARD [UPDATE]'

     Fields :




      * leaderboardCode: unique leaderboard config code must be lowercase and maximum length is 48 characters. (required).


      * name: leaderboard name, maximum length for leaderboard name is 128 characters. (required).


      * description: leaderboard description, maximum length for leaderboard description is 2048 characters. (optional).


      * iconURL: leaderboard icon image url. (optional).


      * allTime: if true, all time leaderboard will be created. (required).


      * descending: leaderboard order. If true, the points will be sorted in descending order. (required).


      * statCode: Stat Code is related with statistic code in statistic service. (required).


      * cycleIds: Statistic cycle ids that will be tracked in the leaderboard. (required).

    Required Permission(s):
        - ADMIN:NAMESPACE:{namespace}:LEADERBOARD [UPDATE]

    Properties:
        url: /leaderboard/v3/admin/namespaces/{namespace}/leaderboards/{leaderboardCode}

        method: PUT

        tags: ["LeaderboardConfigurationV3"]

        consumes: ["application/json"]

        produces: ["application/json"]

        securities: [BEARER_AUTH]

        body: (body) REQUIRED ModelsUpdateLeaderboardConfigReqV3 in body

        leaderboard_code: (leaderboardCode) REQUIRED str in path

        namespace: (namespace) REQUIRED str in path

    Responses:
        200: OK - ModelsGetLeaderboardConfigRespV3 (OK)

        400: Bad Request - ResponseErrorResponse (Bad Request)

        401: Unauthorized - ResponseErrorResponse (Unauthorized)

        403: Forbidden - ResponseErrorResponse (Forbidden)

        404: Not Found - ResponseErrorResponse (Not Found)

        500: Internal Server Error - ResponseErrorResponse (Internal Server Error)
    """
    if namespace is None:
        namespace, error = get_services_namespace()
        if error:
            return None, error
    request = UpdateLeaderboardConfigurationAdminV3.create(
        body=body,
        leaderboard_code=leaderboard_code,
        namespace=namespace,
    )
    return await run_request_async(
        request, additional_headers=x_additional_headers, **kwargs
    )
