# -*- coding: utf-8 -*-
# This file is auto-generated, don't edit it. Thanks.
from Tea.model import TeaModel
from typing import List, Dict


class OrderStepRestriction(TeaModel):
    def __init__(
        self,
        label: str = None,
        value: str = None,
    ):
        # 步骤标题
        self.label = label
        # 步骤名
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.label is not None:
            result['Label'] = self.label
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Label') is not None:
            self.label = m.get('Label')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class OrderStep(TeaModel):
    def __init__(
        self,
        display_method: str = None,
        gmt_create: str = None,
        gmt_modify: str = None,
        job_kwargs: str = None,
        job_message: str = None,
        job_return_status: str = None,
        job_return_values: str = None,
        job_system: str = None,
        order_id: str = None,
        order_step_id: str = None,
        real_next_step: str = None,
        restriction: List[OrderStepRestriction] = None,
        step_name: str = None,
        step_status: str = None,
        step_title: str = None,
        step_type: str = None,
    ):
        # 步骤展示方式
        self.display_method = display_method
        # 创建时间
        self.gmt_create = gmt_create
        # 修改时间
        self.gmt_modify = gmt_modify
        # 步骤任务参数
        self.job_kwargs = job_kwargs
        # 步骤标题
        self.job_message = job_message
        # 步骤标题
        self.job_return_status = job_return_status
        # 步骤任务返回
        self.job_return_values = job_return_values
        # 步骤任务系统
        self.job_system = job_system
        # 工单id
        self.order_id = order_id
        # 工单步骤id
        self.order_step_id = order_step_id
        # 下一步步骤名
        self.real_next_step = real_next_step
        # 下一步步骤可选列表
        self.restriction = restriction
        # 步骤名
        self.step_name = step_name
        # 步骤状态
        self.step_status = step_status
        # 步骤标题
        self.step_title = step_title
        # 步骤类型
        self.step_type = step_type

    def validate(self):
        if self.restriction:
            for k in self.restriction:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.display_method is not None:
            result['DisplayMethod'] = self.display_method
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modify is not None:
            result['GmtModify'] = self.gmt_modify
        if self.job_kwargs is not None:
            result['JobKwargs'] = self.job_kwargs
        if self.job_message is not None:
            result['JobMessage'] = self.job_message
        if self.job_return_status is not None:
            result['JobReturnStatus'] = self.job_return_status
        if self.job_return_values is not None:
            result['JobReturnValues'] = self.job_return_values
        if self.job_system is not None:
            result['JobSystem'] = self.job_system
        if self.order_id is not None:
            result['OrderId'] = self.order_id
        if self.order_step_id is not None:
            result['OrderStepId'] = self.order_step_id
        if self.real_next_step is not None:
            result['RealNextStep'] = self.real_next_step
        result['Restriction'] = []
        if self.restriction is not None:
            for k in self.restriction:
                result['Restriction'].append(k.to_map() if k else None)
        if self.step_name is not None:
            result['StepName'] = self.step_name
        if self.step_status is not None:
            result['StepStatus'] = self.step_status
        if self.step_title is not None:
            result['StepTitle'] = self.step_title
        if self.step_type is not None:
            result['StepType'] = self.step_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DisplayMethod') is not None:
            self.display_method = m.get('DisplayMethod')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModify') is not None:
            self.gmt_modify = m.get('GmtModify')
        if m.get('JobKwargs') is not None:
            self.job_kwargs = m.get('JobKwargs')
        if m.get('JobMessage') is not None:
            self.job_message = m.get('JobMessage')
        if m.get('JobReturnStatus') is not None:
            self.job_return_status = m.get('JobReturnStatus')
        if m.get('JobReturnValues') is not None:
            self.job_return_values = m.get('JobReturnValues')
        if m.get('JobSystem') is not None:
            self.job_system = m.get('JobSystem')
        if m.get('OrderId') is not None:
            self.order_id = m.get('OrderId')
        if m.get('OrderStepId') is not None:
            self.order_step_id = m.get('OrderStepId')
        if m.get('RealNextStep') is not None:
            self.real_next_step = m.get('RealNextStep')
        self.restriction = []
        if m.get('Restriction') is not None:
            for k in m.get('Restriction'):
                temp_model = OrderStepRestriction()
                self.restriction.append(temp_model.from_map(k))
        if m.get('StepName') is not None:
            self.step_name = m.get('StepName')
        if m.get('StepStatus') is not None:
            self.step_status = m.get('StepStatus')
        if m.get('StepTitle') is not None:
            self.step_title = m.get('StepTitle')
        if m.get('StepType') is not None:
            self.step_type = m.get('StepType')
        return self


class DeviceFormProperty(TeaModel):
    def __init__(
        self,
        content: str = None,
        keyword: str = None,
        placeholder: bool = None,
        required: bool = None,
        search_supported: bool = None,
        sequence: int = None,
        table_visible: bool = None,
        uniqueness: bool = None,
        value_reference: str = None,
        value_source: str = None,
        value_type: str = None,
    ):
        # 属性描述
        self.content = content
        # 属性关键词
        self.keyword = keyword
        # 前端界面控件占位符文字
        self.placeholder = placeholder
        # 属性是否必填
        self.required = required
        # 属性是否作为界面查询条件
        self.search_supported = search_supported
        # 属性展示的次序
        self.sequence = sequence
        # 前端界面是否展示为表格列
        self.table_visible = table_visible
        # 属性是否需要唯一检查
        self.uniqueness = uniqueness
        # 属性值来源具体的方式
        self.value_reference = value_reference
        # 属性值来源类型：枚举、接口等
        self.value_source = value_source
        # 属性类型，JSON或者分隔符
        self.value_type = value_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.keyword is not None:
            result['Keyword'] = self.keyword
        if self.placeholder is not None:
            result['Placeholder'] = self.placeholder
        if self.required is not None:
            result['Required'] = self.required
        if self.search_supported is not None:
            result['SearchSupported'] = self.search_supported
        if self.sequence is not None:
            result['Sequence'] = self.sequence
        if self.table_visible is not None:
            result['TableVisible'] = self.table_visible
        if self.uniqueness is not None:
            result['Uniqueness'] = self.uniqueness
        if self.value_reference is not None:
            result['ValueReference'] = self.value_reference
        if self.value_source is not None:
            result['ValueSource'] = self.value_source
        if self.value_type is not None:
            result['ValueType'] = self.value_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('Keyword') is not None:
            self.keyword = m.get('Keyword')
        if m.get('Placeholder') is not None:
            self.placeholder = m.get('Placeholder')
        if m.get('Required') is not None:
            self.required = m.get('Required')
        if m.get('SearchSupported') is not None:
            self.search_supported = m.get('SearchSupported')
        if m.get('Sequence') is not None:
            self.sequence = m.get('Sequence')
        if m.get('TableVisible') is not None:
            self.table_visible = m.get('TableVisible')
        if m.get('Uniqueness') is not None:
            self.uniqueness = m.get('Uniqueness')
        if m.get('ValueReference') is not None:
            self.value_reference = m.get('ValueReference')
        if m.get('ValueSource') is not None:
            self.value_source = m.get('ValueSource')
        if m.get('ValueType') is not None:
            self.value_type = m.get('ValueType')
        return self


class DeviceForm(TeaModel):
    def __init__(
        self,
        account_config: str = None,
        config_compare: str = None,
        form_id: str = None,
        form_name: str = None,
        properties_list: List[DeviceFormProperty] = None,
    ):
        # 是否需要配置账号信息
        self.account_config = account_config
        # 是否需要展示配置备份
        self.config_compare = config_compare
        # 设备形态ID
        self.form_id = form_id
        # 设备形态名称
        self.form_name = form_name
        # 设备形态属性列表
        self.properties_list = properties_list

    def validate(self):
        if self.properties_list:
            for k in self.properties_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_config is not None:
            result['AccountConfig'] = self.account_config
        if self.config_compare is not None:
            result['ConfigCompare'] = self.config_compare
        if self.form_id is not None:
            result['FormId'] = self.form_id
        if self.form_name is not None:
            result['FormName'] = self.form_name
        result['PropertiesList'] = []
        if self.properties_list is not None:
            for k in self.properties_list:
                result['PropertiesList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountConfig') is not None:
            self.account_config = m.get('AccountConfig')
        if m.get('ConfigCompare') is not None:
            self.config_compare = m.get('ConfigCompare')
        if m.get('FormId') is not None:
            self.form_id = m.get('FormId')
        if m.get('FormName') is not None:
            self.form_name = m.get('FormName')
        self.properties_list = []
        if m.get('PropertiesList') is not None:
            for k in m.get('PropertiesList'):
                temp_model = DeviceFormProperty()
                self.properties_list.append(temp_model.from_map(k))
        return self


class ScheduleType(TeaModel):
    def __init__(
        self,
        schedule_type_id: str = None,
        create_time: str = None,
        update_time: str = None,
        key: str = None,
        value: str = None,
        status: str = None,
        related_worker: List[str] = None,
    ):
        # 资源一级ID
        self.schedule_type_id = schedule_type_id
        # 创建时间
        self.create_time = create_time
        # 更新时间
        self.update_time = update_time
        # 值班类型key
        self.key = key
        # 值班类型value
        self.value = value
        # 值班类型状态
        self.status = status
        # relatedWorkerStr
        self.related_worker = related_worker

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.schedule_type_id is not None:
            result['ScheduleTypeId'] = self.schedule_type_id
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        if self.status is not None:
            result['Status'] = self.status
        if self.related_worker is not None:
            result['RelatedWorker'] = self.related_worker
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ScheduleTypeId') is not None:
            self.schedule_type_id = m.get('ScheduleTypeId')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('RelatedWorker') is not None:
            self.related_worker = m.get('RelatedWorker')
        return self


class Task(TeaModel):
    def __init__(
        self,
        category: str = None,
        gmt_create: str = None,
        gmt_modify: str = None,
        params: str = None,
        response_code: str = None,
        result: str = None,
        status: str = None,
        task_id: str = None,
        template_id: str = None,
        template_name: str = None,
    ):
        # 模板类别
        self.category = category
        # 创建时间
        self.gmt_create = gmt_create
        # 修改时间
        self.gmt_modify = gmt_modify
        # 任务参数
        self.params = params
        # 任务错误码
        self.response_code = response_code
        # 任务返回
        self.result = result
        # 任务状态
        self.status = status
        # 任务id
        self.task_id = task_id
        # 模板id
        self.template_id = template_id
        # 模板名称
        self.template_name = template_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category is not None:
            result['Category'] = self.category
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modify is not None:
            result['GmtModify'] = self.gmt_modify
        if self.params is not None:
            result['Params'] = self.params
        if self.response_code is not None:
            result['ResponseCode'] = self.response_code
        if self.result is not None:
            result['Result'] = self.result
        if self.status is not None:
            result['Status'] = self.status
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        if self.template_name is not None:
            result['TemplateName'] = self.template_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModify') is not None:
            self.gmt_modify = m.get('GmtModify')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('ResponseCode') is not None:
            self.response_code = m.get('ResponseCode')
        if m.get('Result') is not None:
            self.result = m.get('Result')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        if m.get('TemplateName') is not None:
            self.template_name = m.get('TemplateName')
        return self


class SchemeInput(TeaModel):
    def __init__(
        self,
        description: str = None,
        name: str = None,
        sample: str = None,
        type: str = None,
    ):
        # 参数说明
        self.description = description
        # 参数名称
        self.name = name
        # 参数示例
        self.sample = sample
        # 参数类型
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.name is not None:
            result['Name'] = self.name
        if self.sample is not None:
            result['Sample'] = self.sample
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Sample') is not None:
            self.sample = m.get('Sample')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class SchemeOutput(TeaModel):
    def __init__(
        self,
        description: str = None,
        name: str = None,
        sample: str = None,
        type: str = None,
    ):
        # 参数说明
        self.description = description
        # 参数名称
        self.name = name
        # 参数示例
        self.sample = sample
        # 参数类型
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.name is not None:
            result['Name'] = self.name
        if self.sample is not None:
            result['Sample'] = self.sample
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Sample') is not None:
            self.sample = m.get('Sample')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class Scheme(TeaModel):
    def __init__(
        self,
        category: str = None,
        content: str = None,
        description: str = None,
        gmt_create: str = None,
        gmt_modify: str = None,
        input: List[SchemeInput] = None,
        output: List[SchemeOutput] = None,
        scheme_id: str = None,
        scheme_name: str = None,
        status: str = None,
        view: str = None,
    ):
        # 方案类型
        self.category = category
        # 方案内容
        self.content = content
        # 方案说明
        self.description = description
        # 创建时间
        self.gmt_create = gmt_create
        # 修改时间
        self.gmt_modify = gmt_modify
        # 方案入参
        self.input = input
        # 方案出参
        self.output = output
        # 方案id
        self.scheme_id = scheme_id
        # 方案名称
        self.scheme_name = scheme_name
        # 方案状态
        self.status = status
        # 方案展示
        self.view = view

    def validate(self):
        if self.input:
            for k in self.input:
                if k:
                    k.validate()
        if self.output:
            for k in self.output:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category is not None:
            result['Category'] = self.category
        if self.content is not None:
            result['Content'] = self.content
        if self.description is not None:
            result['Description'] = self.description
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modify is not None:
            result['GmtModify'] = self.gmt_modify
        result['Input'] = []
        if self.input is not None:
            for k in self.input:
                result['Input'].append(k.to_map() if k else None)
        result['Output'] = []
        if self.output is not None:
            for k in self.output:
                result['Output'].append(k.to_map() if k else None)
        if self.scheme_id is not None:
            result['SchemeId'] = self.scheme_id
        if self.scheme_name is not None:
            result['SchemeName'] = self.scheme_name
        if self.status is not None:
            result['Status'] = self.status
        if self.view is not None:
            result['View'] = self.view
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModify') is not None:
            self.gmt_modify = m.get('GmtModify')
        self.input = []
        if m.get('Input') is not None:
            for k in m.get('Input'):
                temp_model = SchemeInput()
                self.input.append(temp_model.from_map(k))
        self.output = []
        if m.get('Output') is not None:
            for k in m.get('Output'):
                temp_model = SchemeOutput()
                self.output.append(temp_model.from_map(k))
        if m.get('SchemeId') is not None:
            self.scheme_id = m.get('SchemeId')
        if m.get('SchemeName') is not None:
            self.scheme_name = m.get('SchemeName')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('View') is not None:
            self.view = m.get('View')
        return self


class AggregateData(TeaModel):
    def __init__(
        self,
        gmt_create: str = None,
        gmt_modified: str = None,
        data_item: str = None,
        device_id_list: List[str] = None,
        aggregate_mode_list: List[str] = None,
        aggregate_data_name: str = None,
        aggregate_data_description: str = None,
        is_all_device: int = None,
        monitor_item_id: str = None,
        aggregate_data_id: str = None,
    ):
        # 创建时间
        self.gmt_create = gmt_create
        # 修改时间
        self.gmt_modified = gmt_modified
        # 数据项
        self.data_item = data_item
        # 聚合设备ID列表
        self.device_id_list = device_id_list
        # 聚合方式列表
        self.aggregate_mode_list = aggregate_mode_list
        # 聚合数据名称
        self.aggregate_data_name = aggregate_data_name
        # 描述
        self.aggregate_data_description = aggregate_data_description
        # 是否聚合全部设备
        self.is_all_device = is_all_device
        # 监控项ID
        self.monitor_item_id = monitor_item_id
        # 聚合数据ID
        self.aggregate_data_id = aggregate_data_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.data_item is not None:
            result['DataItem'] = self.data_item
        if self.device_id_list is not None:
            result['DeviceIdList'] = self.device_id_list
        if self.aggregate_mode_list is not None:
            result['AggregateModeList'] = self.aggregate_mode_list
        if self.aggregate_data_name is not None:
            result['AggregateDataName'] = self.aggregate_data_name
        if self.aggregate_data_description is not None:
            result['AggregateDataDescription'] = self.aggregate_data_description
        if self.is_all_device is not None:
            result['IsAllDevice'] = self.is_all_device
        if self.monitor_item_id is not None:
            result['MonitorItemId'] = self.monitor_item_id
        if self.aggregate_data_id is not None:
            result['AggregateDataId'] = self.aggregate_data_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('DataItem') is not None:
            self.data_item = m.get('DataItem')
        if m.get('DeviceIdList') is not None:
            self.device_id_list = m.get('DeviceIdList')
        if m.get('AggregateModeList') is not None:
            self.aggregate_mode_list = m.get('AggregateModeList')
        if m.get('AggregateDataName') is not None:
            self.aggregate_data_name = m.get('AggregateDataName')
        if m.get('AggregateDataDescription') is not None:
            self.aggregate_data_description = m.get('AggregateDataDescription')
        if m.get('IsAllDevice') is not None:
            self.is_all_device = m.get('IsAllDevice')
        if m.get('MonitorItemId') is not None:
            self.monitor_item_id = m.get('MonitorItemId')
        if m.get('AggregateDataId') is not None:
            self.aggregate_data_id = m.get('AggregateDataId')
        return self


class SpaceModelSort(TeaModel):
    def __init__(
        self,
        level_name: str = None,
        level: int = None,
    ):
        # 分层名称
        self.level_name = level_name
        # 层次
        self.level = level

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.level_name is not None:
            result['LevelName'] = self.level_name
        if self.level is not None:
            result['Level'] = self.level
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('LevelName') is not None:
            self.level_name = m.get('LevelName')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        return self


class SpaceModelSpaceModelSort(TeaModel):
    def __init__(
        self,
        level: int = None,
        levle_name: str = None,
    ):
        # 层级
        self.level = level
        # 层级名称
        self.levle_name = levle_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.level is not None:
            result['Level'] = self.level
        if self.levle_name is not None:
            result['LevleName'] = self.levle_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('LevleName') is not None:
            self.levle_name = m.get('LevleName')
        return self


class SpaceModelSpaceModel(TeaModel):
    def __init__(
        self,
        space_model_id: str = None,
        status: str = None,
        space_type: str = None,
        create_time: str = None,
        update_time: str = None,
        sort: SpaceModelSpaceModelSort = None,
    ):
        # 物理空间模型id
        self.space_model_id = space_model_id
        # 模型状态
        self.status = status
        # 物理空间类型
        self.space_type = space_type
        # 创建时间
        self.create_time = create_time
        # 更新时间
        self.update_time = update_time
        # 模型实例
        self.sort = sort

    def validate(self):
        if self.sort:
            self.sort.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.space_model_id is not None:
            result['SpaceModelId'] = self.space_model_id
        if self.status is not None:
            result['Status'] = self.status
        if self.space_type is not None:
            result['SpaceType'] = self.space_type
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        if self.sort is not None:
            result['Sort'] = self.sort.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SpaceModelId') is not None:
            self.space_model_id = m.get('SpaceModelId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('SpaceType') is not None:
            self.space_type = m.get('SpaceType')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        if m.get('Sort') is not None:
            temp_model = SpaceModelSpaceModelSort()
            self.sort = temp_model.from_map(m['Sort'])
        return self


class SpaceModel(TeaModel):
    def __init__(
        self,
        space_model_name: str = None,
        create_time: str = None,
        space_model_id: str = None,
        space_type: str = None,
        sort: SpaceModelSort = None,
        space_model: SpaceModelSpaceModel = None,
        space_id: str = None,
        instance: str = None,
        status: str = None,
        operate_type: str = None,
    ):
        # 资源名称
        self.space_model_name = space_model_name
        # 创建时间
        self.create_time = create_time
        # 资源一级ID
        self.space_model_id = space_model_id
        # 物理空间类型
        self.space_type = space_type
        # 层级
        self.sort = sort
        # 物理空间模型
        self.space_model = space_model
        # 物理空间id
        self.space_id = space_id
        # 物理空间实例
        self.instance = instance
        # 状态
        self.status = status
        # 操作类型
        self.operate_type = operate_type

    def validate(self):
        if self.sort:
            self.sort.validate()
        if self.space_model:
            self.space_model.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.space_model_name is not None:
            result['SpaceModelName'] = self.space_model_name
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.space_model_id is not None:
            result['SpaceModelId'] = self.space_model_id
        if self.space_type is not None:
            result['SpaceType'] = self.space_type
        if self.sort is not None:
            result['Sort'] = self.sort.to_map()
        if self.space_model is not None:
            result['SpaceModel'] = self.space_model.to_map()
        if self.space_id is not None:
            result['SpaceId'] = self.space_id
        if self.instance is not None:
            result['Instance'] = self.instance
        if self.status is not None:
            result['Status'] = self.status
        if self.operate_type is not None:
            result['OperateType'] = self.operate_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SpaceModelName') is not None:
            self.space_model_name = m.get('SpaceModelName')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('SpaceModelId') is not None:
            self.space_model_id = m.get('SpaceModelId')
        if m.get('SpaceType') is not None:
            self.space_type = m.get('SpaceType')
        if m.get('Sort') is not None:
            temp_model = SpaceModelSort()
            self.sort = temp_model.from_map(m['Sort'])
        if m.get('SpaceModel') is not None:
            temp_model = SpaceModelSpaceModel()
            self.space_model = temp_model.from_map(m['SpaceModel'])
        if m.get('SpaceId') is not None:
            self.space_id = m.get('SpaceId')
        if m.get('Instance') is not None:
            self.instance = m.get('Instance')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('OperateType') is not None:
            self.operate_type = m.get('OperateType')
        return self


class Port(TeaModel):
    def __init__(
        self,
        device_id: str = None,
        gmt_create: str = None,
        gmt_modified: str = None,
        port_collection_id: str = None,
        port_name: str = None,
    ):
        # 设备ID
        self.device_id = device_id
        # 创建时间
        self.gmt_create = gmt_create
        # 修改时间
        self.gmt_modified = gmt_modified
        # 端口集ID
        self.port_collection_id = port_collection_id
        # 端口名称
        self.port_name = port_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.port_collection_id is not None:
            result['PortCollectionId'] = self.port_collection_id
        if self.port_name is not None:
            result['PortName'] = self.port_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('PortCollectionId') is not None:
            self.port_collection_id = m.get('PortCollectionId')
        if m.get('PortName') is not None:
            self.port_name = m.get('PortName')
        return self


class BusinessType(TeaModel):
    def __init__(
        self,
        business_type_id: str = None,
        create_time: str = None,
        update_time: str = None,
        name: str = None,
        abbr: str = None,
        mask: str = None,
        gateway: int = None,
        sharing: str = None,
        direction: int = None,
        reserve_number: int = None,
        type: str = None,
        zone_type: str = None,
        lease_time: str = None,
        vlan: str = None,
        action_flag: str = None,
    ):
        # 配置规范对象
        self.business_type_id = business_type_id
        # 创建时间
        self.create_time = create_time
        # 更新时间
        self.update_time = update_time
        # 业务类型名称
        self.name = name
        # 业务类型缩写
        self.abbr = abbr
        # 掩码
        self.mask = mask
        # 网关地址位置，正数为正数序号，负数为倒数序号
        self.gateway = gateway
        # 是否复用 reuse/single
        self.sharing = sharing
        # 分配方向，0表示正向，1表示反向
        self.direction = direction
        # 保留地址数目
        self.reserve_number = reserve_number
        # 业务类型大类
        self.type = type
        # 绑定的园区类型
        self.zone_type = zone_type
        # 有效时间
        self.lease_time = lease_time
        # Vlan
        self.vlan = vlan
        # 业务类型地址申请完对应的动作，DHCP表示需要触发DHCP变更
        self.action_flag = action_flag

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.business_type_id is not None:
            result['BusinessTypeId'] = self.business_type_id
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        if self.name is not None:
            result['Name'] = self.name
        if self.abbr is not None:
            result['Abbr'] = self.abbr
        if self.mask is not None:
            result['Mask'] = self.mask
        if self.gateway is not None:
            result['Gateway'] = self.gateway
        if self.sharing is not None:
            result['Sharing'] = self.sharing
        if self.direction is not None:
            result['Direction'] = self.direction
        if self.reserve_number is not None:
            result['ReserveNumber'] = self.reserve_number
        if self.type is not None:
            result['Type'] = self.type
        if self.zone_type is not None:
            result['ZoneType'] = self.zone_type
        if self.lease_time is not None:
            result['LeaseTime'] = self.lease_time
        if self.vlan is not None:
            result['Vlan'] = self.vlan
        if self.action_flag is not None:
            result['ActionFlag'] = self.action_flag
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BusinessTypeId') is not None:
            self.business_type_id = m.get('BusinessTypeId')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Abbr') is not None:
            self.abbr = m.get('Abbr')
        if m.get('Mask') is not None:
            self.mask = m.get('Mask')
        if m.get('Gateway') is not None:
            self.gateway = m.get('Gateway')
        if m.get('Sharing') is not None:
            self.sharing = m.get('Sharing')
        if m.get('Direction') is not None:
            self.direction = m.get('Direction')
        if m.get('ReserveNumber') is not None:
            self.reserve_number = m.get('ReserveNumber')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('ZoneType') is not None:
            self.zone_type = m.get('ZoneType')
        if m.get('LeaseTime') is not None:
            self.lease_time = m.get('LeaseTime')
        if m.get('Vlan') is not None:
            self.vlan = m.get('Vlan')
        if m.get('ActionFlag') is not None:
            self.action_flag = m.get('ActionFlag')
        return self


class NotificationGroup(TeaModel):
    def __init__(
        self,
        gmt_create: str = None,
        gmt_modified: str = None,
        notification_group_description: str = None,
        notification_group_id: str = None,
        notification_group_name: str = None,
        notification_group_type: str = None,
        webhook: str = None,
    ):
        # 创建时间
        self.gmt_create = gmt_create
        # 修改时间
        self.gmt_modified = gmt_modified
        # 描述
        self.notification_group_description = notification_group_description
        # 通知组ID
        self.notification_group_id = notification_group_id
        # 通知组名称
        self.notification_group_name = notification_group_name
        # 通知组类型
        self.notification_group_type = notification_group_type
        # 钉钉群webhook
        self.webhook = webhook

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.notification_group_description is not None:
            result['NotificationGroupDescription'] = self.notification_group_description
        if self.notification_group_id is not None:
            result['NotificationGroupId'] = self.notification_group_id
        if self.notification_group_name is not None:
            result['NotificationGroupName'] = self.notification_group_name
        if self.notification_group_type is not None:
            result['NotificationGroupType'] = self.notification_group_type
        if self.webhook is not None:
            result['Webhook'] = self.webhook
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('NotificationGroupDescription') is not None:
            self.notification_group_description = m.get('NotificationGroupDescription')
        if m.get('NotificationGroupId') is not None:
            self.notification_group_id = m.get('NotificationGroupId')
        if m.get('NotificationGroupName') is not None:
            self.notification_group_name = m.get('NotificationGroupName')
        if m.get('NotificationGroupType') is not None:
            self.notification_group_type = m.get('NotificationGroupType')
        if m.get('Webhook') is not None:
            self.webhook = m.get('Webhook')
        return self


class TemplateInput(TeaModel):
    def __init__(
        self,
        description: str = None,
        name: str = None,
        sample: str = None,
        type: str = None,
    ):
        # 参数说明
        self.description = description
        # 参数名称
        self.name = name
        # 参数示例
        self.sample = sample
        # 参数类型
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.name is not None:
            result['Name'] = self.name
        if self.sample is not None:
            result['Sample'] = self.sample
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Sample') is not None:
            self.sample = m.get('Sample')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class TemplateOutput(TeaModel):
    def __init__(
        self,
        description: str = None,
        name: str = None,
        sample: str = None,
        type: str = None,
    ):
        # 参数说明
        self.description = description
        # 参数名称
        self.name = name
        # 参数示例
        self.sample = sample
        # 参数类型
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.name is not None:
            result['Name'] = self.name
        if self.sample is not None:
            result['Sample'] = self.sample
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Sample') is not None:
            self.sample = m.get('Sample')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class Template(TeaModel):
    def __init__(
        self,
        category: str = None,
        comment: str = None,
        gmt_create: str = None,
        gmt_modify: str = None,
        input: List[TemplateInput] = None,
        output: List[TemplateOutput] = None,
        template_name: str = None,
        template_type: str = None,
    ):
        # 模板类型
        self.category = category
        # 模板说明
        self.comment = comment
        # 创建时间
        self.gmt_create = gmt_create
        # 修改时间
        self.gmt_modify = gmt_modify
        # 模板入参
        self.input = input
        # 模板出参
        self.output = output
        # 模板名称
        self.template_name = template_name
        # 模板类型
        self.template_type = template_type

    def validate(self):
        if self.input:
            for k in self.input:
                if k:
                    k.validate()
        if self.output:
            for k in self.output:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category is not None:
            result['Category'] = self.category
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modify is not None:
            result['GmtModify'] = self.gmt_modify
        result['Input'] = []
        if self.input is not None:
            for k in self.input:
                result['Input'].append(k.to_map() if k else None)
        result['Output'] = []
        if self.output is not None:
            for k in self.output:
                result['Output'].append(k.to_map() if k else None)
        if self.template_name is not None:
            result['TemplateName'] = self.template_name
        if self.template_type is not None:
            result['TemplateType'] = self.template_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModify') is not None:
            self.gmt_modify = m.get('GmtModify')
        self.input = []
        if m.get('Input') is not None:
            for k in m.get('Input'):
                temp_model = TemplateInput()
                self.input.append(temp_model.from_map(k))
        self.output = []
        if m.get('Output') is not None:
            for k in m.get('Output'):
                temp_model = TemplateOutput()
                self.output.append(temp_model.from_map(k))
        if m.get('TemplateName') is not None:
            self.template_name = m.get('TemplateName')
        if m.get('TemplateType') is not None:
            self.template_type = m.get('TemplateType')
        return self


class DedicatedLine(TeaModel):
    def __init__(
        self,
        bandwidth: int = None,
        device_id: str = None,
        device_port: str = None,
        isp: str = None,
        line_gateway: str = None,
        line_id: str = None,
        line_ip: str = None,
        line_role: str = None,
    ):
        # 宽带（Mbps）
        self.bandwidth = bandwidth
        # 关联设备ID
        self.device_id = device_id
        # 关联设备端口
        self.device_port = device_port
        # 运营商
        self.isp = isp
        # 专线网关
        self.line_gateway = line_gateway
        # 物理空间专线ID
        self.line_id = line_id
        # 专线IP
        self.line_ip = line_ip
        # 专线角色
        self.line_role = line_role

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bandwidth is not None:
            result['Bandwidth'] = self.bandwidth
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.device_port is not None:
            result['DevicePort'] = self.device_port
        if self.isp is not None:
            result['Isp'] = self.isp
        if self.line_gateway is not None:
            result['LineGateway'] = self.line_gateway
        if self.line_id is not None:
            result['LineId'] = self.line_id
        if self.line_ip is not None:
            result['LineIp'] = self.line_ip
        if self.line_role is not None:
            result['LineRole'] = self.line_role
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bandwidth') is not None:
            self.bandwidth = m.get('Bandwidth')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('DevicePort') is not None:
            self.device_port = m.get('DevicePort')
        if m.get('Isp') is not None:
            self.isp = m.get('Isp')
        if m.get('LineGateway') is not None:
            self.line_gateway = m.get('LineGateway')
        if m.get('LineId') is not None:
            self.line_id = m.get('LineId')
        if m.get('LineIp') is not None:
            self.line_ip = m.get('LineIp')
        if m.get('LineRole') is not None:
            self.line_role = m.get('LineRole')
        return self


class DeviceResourceDeviceResource(TeaModel):
    def __init__(
        self,
        device_resource_id: str = None,
        setup_project_id: str = None,
        role: str = None,
        block_number: str = None,
        device_number: str = None,
        vendor: str = None,
        model: str = None,
        host_name: str = None,
        sn: str = None,
        location: str = None,
        manager_ip: str = None,
        delivery_ip: str = None,
        config_generate: bool = None,
        config_task_status: str = None,
        config: str = None,
        loopback: str = None,
        inter_connection: str = None,
        business: str = None,
        stack: bool = None,
    ):
        # 设备资源ID
        self.device_resource_id = device_resource_id
        # 建设项目id
        self.setup_project_id = setup_project_id
        # 角色
        self.role = role
        # 组号
        self.block_number = block_number
        # 设备号
        self.device_number = device_number
        # 厂商
        self.vendor = vendor
        # 模型
        self.model = model
        # 主机名
        self.host_name = host_name
        # 设备sn号
        self.sn = sn
        # 物理空间位置
        self.location = location
        # 带内管理地址
        self.manager_ip = manager_ip
        # 交付登录地址
        self.delivery_ip = delivery_ip
        # 配置生成
        self.config_generate = config_generate
        # 配置下发状态
        self.config_task_status = config_task_status
        # 设备配置
        self.config = config
        # loopback地址
        self.loopback = loopback
        # 设备互联地址
        self.inter_connection = inter_connection
        # 设备业务地址
        self.business = business
        # 堆叠状态
        self.stack = stack

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_resource_id is not None:
            result['DeviceResourceId'] = self.device_resource_id
        if self.setup_project_id is not None:
            result['SetupProjectId'] = self.setup_project_id
        if self.role is not None:
            result['Role'] = self.role
        if self.block_number is not None:
            result['BlockNumber'] = self.block_number
        if self.device_number is not None:
            result['DeviceNumber'] = self.device_number
        if self.vendor is not None:
            result['Vendor'] = self.vendor
        if self.model is not None:
            result['Model'] = self.model
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.sn is not None:
            result['Sn'] = self.sn
        if self.location is not None:
            result['Location'] = self.location
        if self.manager_ip is not None:
            result['ManagerIp'] = self.manager_ip
        if self.delivery_ip is not None:
            result['DeliveryIp'] = self.delivery_ip
        if self.config_generate is not None:
            result['ConfigGenerate'] = self.config_generate
        if self.config_task_status is not None:
            result['ConfigTaskStatus'] = self.config_task_status
        if self.config is not None:
            result['Config'] = self.config
        if self.loopback is not None:
            result['Loopback'] = self.loopback
        if self.inter_connection is not None:
            result['InterConnection'] = self.inter_connection
        if self.business is not None:
            result['Business'] = self.business
        if self.stack is not None:
            result['Stack'] = self.stack
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeviceResourceId') is not None:
            self.device_resource_id = m.get('DeviceResourceId')
        if m.get('SetupProjectId') is not None:
            self.setup_project_id = m.get('SetupProjectId')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        if m.get('BlockNumber') is not None:
            self.block_number = m.get('BlockNumber')
        if m.get('DeviceNumber') is not None:
            self.device_number = m.get('DeviceNumber')
        if m.get('Vendor') is not None:
            self.vendor = m.get('Vendor')
        if m.get('Model') is not None:
            self.model = m.get('Model')
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('Sn') is not None:
            self.sn = m.get('Sn')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('ManagerIp') is not None:
            self.manager_ip = m.get('ManagerIp')
        if m.get('DeliveryIp') is not None:
            self.delivery_ip = m.get('DeliveryIp')
        if m.get('ConfigGenerate') is not None:
            self.config_generate = m.get('ConfigGenerate')
        if m.get('ConfigTaskStatus') is not None:
            self.config_task_status = m.get('ConfigTaskStatus')
        if m.get('Config') is not None:
            self.config = m.get('Config')
        if m.get('Loopback') is not None:
            self.loopback = m.get('Loopback')
        if m.get('InterConnection') is not None:
            self.inter_connection = m.get('InterConnection')
        if m.get('Business') is not None:
            self.business = m.get('Business')
        if m.get('Stack') is not None:
            self.stack = m.get('Stack')
        return self


class DeviceResource(TeaModel):
    def __init__(
        self,
        create_time: str = None,
        device_resource_ids: List[str] = None,
        device_resource_id: str = None,
        setup_project_id: str = None,
        type: str = None,
        data: str = None,
        download_type: str = None,
        business_type: str = None,
        list_type: str = None,
        arch_id: str = None,
        device_resource: List[DeviceResourceDeviceResource] = None,
        ip_type: str = None,
        net_location: str = None,
        business_type_params: str = None,
        loopback_port: str = None,
        business_type_id: str = None,
    ):
        # 创建时间
        self.create_time = create_time
        # 资源一级ID
        self.device_resource_ids = device_resource_ids
        # 设备资源id
        self.device_resource_id = device_resource_id
        # 建设项目id
        self.setup_project_id = setup_project_id
        # 操作类型
        self.type = type
        # 更新数据
        self.data = data
        # 操作类型
        self.download_type = download_type
        # 业务类型
        self.business_type = business_type
        # list类型
        self.list_type = list_type
        # 架构资源ID
        self.arch_id = arch_id
        # 设备资源
        self.device_resource = device_resource
        # ip类型
        self.ip_type = ip_type
        # 位置
        self.net_location = net_location
        # 业务参数
        self.business_type_params = business_type_params
        # Loopback口
        self.loopback_port = loopback_port
        # 业务类型id
        self.business_type_id = business_type_id

    def validate(self):
        if self.device_resource:
            for k in self.device_resource:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.device_resource_ids is not None:
            result['DeviceResourceIds'] = self.device_resource_ids
        if self.device_resource_id is not None:
            result['DeviceResourceId'] = self.device_resource_id
        if self.setup_project_id is not None:
            result['SetupProjectId'] = self.setup_project_id
        if self.type is not None:
            result['Type'] = self.type
        if self.data is not None:
            result['Data'] = self.data
        if self.download_type is not None:
            result['DownloadType'] = self.download_type
        if self.business_type is not None:
            result['BusinessType'] = self.business_type
        if self.list_type is not None:
            result['ListType'] = self.list_type
        if self.arch_id is not None:
            result['ArchId'] = self.arch_id
        result['DeviceResource'] = []
        if self.device_resource is not None:
            for k in self.device_resource:
                result['DeviceResource'].append(k.to_map() if k else None)
        if self.ip_type is not None:
            result['IpType'] = self.ip_type
        if self.net_location is not None:
            result['NetLocation'] = self.net_location
        if self.business_type_params is not None:
            result['BusinessTypeParams'] = self.business_type_params
        if self.loopback_port is not None:
            result['LoopbackPort'] = self.loopback_port
        if self.business_type_id is not None:
            result['BusinessTypeId'] = self.business_type_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('DeviceResourceIds') is not None:
            self.device_resource_ids = m.get('DeviceResourceIds')
        if m.get('DeviceResourceId') is not None:
            self.device_resource_id = m.get('DeviceResourceId')
        if m.get('SetupProjectId') is not None:
            self.setup_project_id = m.get('SetupProjectId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('DownloadType') is not None:
            self.download_type = m.get('DownloadType')
        if m.get('BusinessType') is not None:
            self.business_type = m.get('BusinessType')
        if m.get('ListType') is not None:
            self.list_type = m.get('ListType')
        if m.get('ArchId') is not None:
            self.arch_id = m.get('ArchId')
        self.device_resource = []
        if m.get('DeviceResource') is not None:
            for k in m.get('DeviceResource'):
                temp_model = DeviceResourceDeviceResource()
                self.device_resource.append(temp_model.from_map(k))
        if m.get('IpType') is not None:
            self.ip_type = m.get('IpType')
        if m.get('NetLocation') is not None:
            self.net_location = m.get('NetLocation')
        if m.get('BusinessTypeParams') is not None:
            self.business_type_params = m.get('BusinessTypeParams')
        if m.get('LoopbackPort') is not None:
            self.loopback_port = m.get('LoopbackPort')
        if m.get('BusinessTypeId') is not None:
            self.business_type_id = m.get('BusinessTypeId')
        return self


class ModelToRole(TeaModel):
    def __init__(
        self,
        model_to_role_id: str = None,
        create_time: str = None,
        update_time: str = None,
        id: str = None,
        network_architecture_iteration_id: str = None,
        role: str = None,
        vendor: str = None,
        model: str = None,
    ):
        # 资源一级ID
        self.model_to_role_id = model_to_role_id
        # 创建时间
        self.create_time = create_time
        # 更新时间
        self.update_time = update_time
        # 角色型号对应关系uid
        self.id = id
        # 架构迭代uid
        self.network_architecture_iteration_id = network_architecture_iteration_id
        # 角色
        self.role = role
        # 设备厂商
        self.vendor = vendor
        # 设备型号
        self.model = model

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.model_to_role_id is not None:
            result['ModelToRoleId'] = self.model_to_role_id
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        if self.id is not None:
            result['Id'] = self.id
        if self.network_architecture_iteration_id is not None:
            result['NetworkArchitectureIterationId'] = self.network_architecture_iteration_id
        if self.role is not None:
            result['Role'] = self.role
        if self.vendor is not None:
            result['Vendor'] = self.vendor
        if self.model is not None:
            result['Model'] = self.model
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ModelToRoleId') is not None:
            self.model_to_role_id = m.get('ModelToRoleId')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('NetworkArchitectureIterationId') is not None:
            self.network_architecture_iteration_id = m.get('NetworkArchitectureIterationId')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        if m.get('Vendor') is not None:
            self.vendor = m.get('Vendor')
        if m.get('Model') is not None:
            self.model = m.get('Model')
        return self


class ScheduleWorker(TeaModel):
    def __init__(
        self,
        create_time: str = None,
        schedule_worker_id: str = None,
        update_time: str = None,
        worker_id: str = None,
        worker_name: str = None,
        worker_contact: str = None,
    ):
        # 创建时间
        self.create_time = create_time
        # 资源一级ID
        self.schedule_worker_id = schedule_worker_id
        # 更新时间
        self.update_time = update_time
        # 值班人员工号
        self.worker_id = worker_id
        # 值班人员姓名
        self.worker_name = worker_name
        # 联系方式
        self.worker_contact = worker_contact

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.schedule_worker_id is not None:
            result['ScheduleWorkerId'] = self.schedule_worker_id
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        if self.worker_id is not None:
            result['WorkerId'] = self.worker_id
        if self.worker_name is not None:
            result['WorkerName'] = self.worker_name
        if self.worker_contact is not None:
            result['WorkerContact'] = self.worker_contact
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('ScheduleWorkerId') is not None:
            self.schedule_worker_id = m.get('ScheduleWorkerId')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        if m.get('WorkerId') is not None:
            self.worker_id = m.get('WorkerId')
        if m.get('WorkerName') is not None:
            self.worker_name = m.get('WorkerName')
        if m.get('WorkerContact') is not None:
            self.worker_contact = m.get('WorkerContact')
        return self


class IpBlockZoneLayer(TeaModel):
    def __init__(
        self,
        name: str = None,
        value: str = None,
    ):
        # 园区层级名称
        self.name = name
        # 园区层级值
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class IpBlock(TeaModel):
    def __init__(
        self,
        resource_group_id: str = None,
        create_time: str = None,
        ip_block_id: str = None,
        block: str = None,
        mask: str = None,
        parent_id: str = None,
        net_type: str = None,
        category: str = None,
        business_type_id: str = None,
        device_name: str = None,
        zone_name: str = None,
        backup_device_name: str = None,
        net_business: str = None,
        ownership: str = None,
        application: str = None,
        description: str = None,
        reserve_parent_block: str = None,
        update_type: str = None,
        zone_layer: List[IpBlockZoneLayer] = None,
    ):
        # 资源组ID
        self.resource_group_id = resource_group_id
        # 创建时间
        self.create_time = create_time
        # 资源一级ID
        self.ip_block_id = ip_block_id
        # IP段地址
        self.block = block
        # IP段掩码
        self.mask = mask
        # 父地址段UID
        self.parent_id = parent_id
        # 公网私网标志 PUBLIC PRIVATE
        self.net_type = net_type
        # 地址类别 IPV4
        self.category = category
        # 业务类型UID
        self.business_type_id = business_type_id
        # 设备名称
        self.device_name = device_name
        # 园区名称
        self.zone_name = zone_name
        # 备份设备名称
        self.backup_device_name = backup_device_name
        # 公网地址类型 INC GUEST VIP
        self.net_business = net_business
        # IP归属
        self.ownership = ownership
        # IP用途
        self.application = application
        # 备注
        self.description = description
        # 是否保留父段 true 是 false 否
        self.reserve_parent_block = reserve_parent_block
        # 更新类型 update 更新 split 拆分
        self.update_type = update_type
        # 园区层级
        self.zone_layer = zone_layer

    def validate(self):
        if self.zone_layer:
            for k in self.zone_layer:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.ip_block_id is not None:
            result['IpBlockId'] = self.ip_block_id
        if self.block is not None:
            result['Block'] = self.block
        if self.mask is not None:
            result['Mask'] = self.mask
        if self.parent_id is not None:
            result['ParentId'] = self.parent_id
        if self.net_type is not None:
            result['NetType'] = self.net_type
        if self.category is not None:
            result['Category'] = self.category
        if self.business_type_id is not None:
            result['BusinessTypeId'] = self.business_type_id
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.zone_name is not None:
            result['ZoneName'] = self.zone_name
        if self.backup_device_name is not None:
            result['BackupDeviceName'] = self.backup_device_name
        if self.net_business is not None:
            result['NetBusiness'] = self.net_business
        if self.ownership is not None:
            result['Ownership'] = self.ownership
        if self.application is not None:
            result['Application'] = self.application
        if self.description is not None:
            result['Description'] = self.description
        if self.reserve_parent_block is not None:
            result['ReserveParentBlock'] = self.reserve_parent_block
        if self.update_type is not None:
            result['UpdateType'] = self.update_type
        result['ZoneLayer'] = []
        if self.zone_layer is not None:
            for k in self.zone_layer:
                result['ZoneLayer'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('IpBlockId') is not None:
            self.ip_block_id = m.get('IpBlockId')
        if m.get('Block') is not None:
            self.block = m.get('Block')
        if m.get('Mask') is not None:
            self.mask = m.get('Mask')
        if m.get('ParentId') is not None:
            self.parent_id = m.get('ParentId')
        if m.get('NetType') is not None:
            self.net_type = m.get('NetType')
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('BusinessTypeId') is not None:
            self.business_type_id = m.get('BusinessTypeId')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('ZoneName') is not None:
            self.zone_name = m.get('ZoneName')
        if m.get('BackupDeviceName') is not None:
            self.backup_device_name = m.get('BackupDeviceName')
        if m.get('NetBusiness') is not None:
            self.net_business = m.get('NetBusiness')
        if m.get('Ownership') is not None:
            self.ownership = m.get('Ownership')
        if m.get('Application') is not None:
            self.application = m.get('Application')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ReserveParentBlock') is not None:
            self.reserve_parent_block = m.get('ReserveParentBlock')
        if m.get('UpdateType') is not None:
            self.update_type = m.get('UpdateType')
        self.zone_layer = []
        if m.get('ZoneLayer') is not None:
            for k in m.get('ZoneLayer'):
                temp_model = IpBlockZoneLayer()
                self.zone_layer.append(temp_model.from_map(k))
        return self


class Order(TeaModel):
    def __init__(
        self,
        gmt_create: str = None,
        gmt_modify: str = None,
        order_id: str = None,
        output: str = None,
        params: str = None,
        scheme_id: str = None,
        scheme_name: str = None,
        status: str = None,
        title: str = None,
    ):
        # 创建时间
        self.gmt_create = gmt_create
        # 修改时间
        self.gmt_modify = gmt_modify
        # 工单id
        self.order_id = order_id
        # 工单返回
        self.output = output
        # 工单参数
        self.params = params
        # 方案id
        self.scheme_id = scheme_id
        # 方案名
        self.scheme_name = scheme_name
        # 任务状态
        self.status = status
        # 工单标题
        self.title = title

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modify is not None:
            result['GmtModify'] = self.gmt_modify
        if self.order_id is not None:
            result['OrderId'] = self.order_id
        if self.output is not None:
            result['Output'] = self.output
        if self.params is not None:
            result['Params'] = self.params
        if self.scheme_id is not None:
            result['SchemeId'] = self.scheme_id
        if self.scheme_name is not None:
            result['SchemeName'] = self.scheme_name
        if self.status is not None:
            result['Status'] = self.status
        if self.title is not None:
            result['Title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModify') is not None:
            self.gmt_modify = m.get('GmtModify')
        if m.get('OrderId') is not None:
            self.order_id = m.get('OrderId')
        if m.get('Output') is not None:
            self.output = m.get('Output')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('SchemeId') is not None:
            self.scheme_id = m.get('SchemeId')
        if m.get('SchemeName') is not None:
            self.scheme_name = m.get('SchemeName')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        return self


class ScriptInput(TeaModel):
    def __init__(
        self,
        description: str = None,
        name: str = None,
        sample: str = None,
        type: str = None,
    ):
        # 参数说明
        self.description = description
        # 参数名称
        self.name = name
        # 参数示例
        self.sample = sample
        # 参数类型
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.name is not None:
            result['Name'] = self.name
        if self.sample is not None:
            result['Sample'] = self.sample
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Sample') is not None:
            self.sample = m.get('Sample')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class ScriptOutput(TeaModel):
    def __init__(
        self,
        description: str = None,
        name: str = None,
        sample: str = None,
        type: str = None,
    ):
        # 参数说明
        self.description = description
        # 参数名称
        self.name = name
        # 参数示例
        self.sample = sample
        # 参数类型
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.name is not None:
            result['Name'] = self.name
        if self.sample is not None:
            result['Sample'] = self.sample
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Sample') is not None:
            self.sample = m.get('Sample')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class ScriptRule(TeaModel):
    def __init__(
        self,
        arch: str = None,
        domain: str = None,
        model: str = None,
        os: str = None,
        role: str = None,
        rule_id: str = None,
        script_id: str = None,
        vendor: str = None,
    ):
        # 设备架构
        self.arch = arch
        # 设备安全域
        self.domain = domain
        # 设备型号
        self.model = model
        # 设备OS版本
        self.os = os
        # 设备角色
        self.role = role
        # 规则id
        self.rule_id = rule_id
        # 脚本id
        self.script_id = script_id
        # 设备厂商
        self.vendor = vendor

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.arch is not None:
            result['Arch'] = self.arch
        if self.domain is not None:
            result['Domain'] = self.domain
        if self.model is not None:
            result['Model'] = self.model
        if self.os is not None:
            result['Os'] = self.os
        if self.role is not None:
            result['Role'] = self.role
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.script_id is not None:
            result['ScriptId'] = self.script_id
        if self.vendor is not None:
            result['Vendor'] = self.vendor
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Arch') is not None:
            self.arch = m.get('Arch')
        if m.get('Domain') is not None:
            self.domain = m.get('Domain')
        if m.get('Model') is not None:
            self.model = m.get('Model')
        if m.get('Os') is not None:
            self.os = m.get('Os')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('ScriptId') is not None:
            self.script_id = m.get('ScriptId')
        if m.get('Vendor') is not None:
            self.vendor = m.get('Vendor')
        return self


class Script(TeaModel):
    def __init__(
        self,
        content: str = None,
        gmt_create: str = None,
        gmt_modify: str = None,
        input: List[ScriptInput] = None,
        output: List[ScriptOutput] = None,
        rules: List[ScriptRule] = None,
        script_id: str = None,
        template_id: str = None,
        version_id: str = None,
    ):
        # 脚本代码
        self.content = content
        # 创建时间
        self.gmt_create = gmt_create
        # 修改时间
        self.gmt_modify = gmt_modify
        # 模板入参
        self.input = input
        # 模板出参
        self.output = output
        # 规则列表
        self.rules = rules
        # 脚本id
        self.script_id = script_id
        # 模板id
        self.template_id = template_id
        # 版本id
        self.version_id = version_id

    def validate(self):
        if self.input:
            for k in self.input:
                if k:
                    k.validate()
        if self.output:
            for k in self.output:
                if k:
                    k.validate()
        if self.rules:
            for k in self.rules:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modify is not None:
            result['GmtModify'] = self.gmt_modify
        result['Input'] = []
        if self.input is not None:
            for k in self.input:
                result['Input'].append(k.to_map() if k else None)
        result['Output'] = []
        if self.output is not None:
            for k in self.output:
                result['Output'].append(k.to_map() if k else None)
        result['Rules'] = []
        if self.rules is not None:
            for k in self.rules:
                result['Rules'].append(k.to_map() if k else None)
        if self.script_id is not None:
            result['ScriptId'] = self.script_id
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        if self.version_id is not None:
            result['VersionId'] = self.version_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModify') is not None:
            self.gmt_modify = m.get('GmtModify')
        self.input = []
        if m.get('Input') is not None:
            for k in m.get('Input'):
                temp_model = ScriptInput()
                self.input.append(temp_model.from_map(k))
        self.output = []
        if m.get('Output') is not None:
            for k in m.get('Output'):
                temp_model = ScriptOutput()
                self.output.append(temp_model.from_map(k))
        self.rules = []
        if m.get('Rules') is not None:
            for k in m.get('Rules'):
                temp_model = ScriptRule()
                self.rules.append(temp_model.from_map(k))
        if m.get('ScriptId') is not None:
            self.script_id = m.get('ScriptId')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        if m.get('VersionId') is not None:
            self.version_id = m.get('VersionId')
        return self


class Agent(TeaModel):
    def __init__(
        self,
        agent_id: str = None,
        agent_name: str = None,
        agent_version: str = None,
        cpu_usage: str = None,
        disk_usage: str = None,
        gmt_modify: str = None,
        ip: str = None,
        kernel_version: str = None,
        memory_usage: str = None,
        security_domain: str = None,
        status: str = None,
    ):
        # 探针Id
        self.agent_id = agent_id
        # 探针名称
        self.agent_name = agent_name
        # 探针版本
        self.agent_version = agent_version
        # cpu使用率
        self.cpu_usage = cpu_usage
        # 磁盘利用率
        self.disk_usage = disk_usage
        # 更新时间
        self.gmt_modify = gmt_modify
        # 探针IP
        self.ip = ip
        # 系统版本
        self.kernel_version = kernel_version
        # 内存使用率
        self.memory_usage = memory_usage
        # 安全域
        self.security_domain = security_domain
        # 探针状态
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_id is not None:
            result['AgentId'] = self.agent_id
        if self.agent_name is not None:
            result['AgentName'] = self.agent_name
        if self.agent_version is not None:
            result['AgentVersion'] = self.agent_version
        if self.cpu_usage is not None:
            result['CpuUsage'] = self.cpu_usage
        if self.disk_usage is not None:
            result['DiskUsage'] = self.disk_usage
        if self.gmt_modify is not None:
            result['GmtModify'] = self.gmt_modify
        if self.ip is not None:
            result['Ip'] = self.ip
        if self.kernel_version is not None:
            result['KernelVersion'] = self.kernel_version
        if self.memory_usage is not None:
            result['MemoryUsage'] = self.memory_usage
        if self.security_domain is not None:
            result['SecurityDomain'] = self.security_domain
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgentId') is not None:
            self.agent_id = m.get('AgentId')
        if m.get('AgentName') is not None:
            self.agent_name = m.get('AgentName')
        if m.get('AgentVersion') is not None:
            self.agent_version = m.get('AgentVersion')
        if m.get('CpuUsage') is not None:
            self.cpu_usage = m.get('CpuUsage')
        if m.get('DiskUsage') is not None:
            self.disk_usage = m.get('DiskUsage')
        if m.get('GmtModify') is not None:
            self.gmt_modify = m.get('GmtModify')
        if m.get('Ip') is not None:
            self.ip = m.get('Ip')
        if m.get('KernelVersion') is not None:
            self.kernel_version = m.get('KernelVersion')
        if m.get('MemoryUsage') is not None:
            self.memory_usage = m.get('MemoryUsage')
        if m.get('SecurityDomain') is not None:
            self.security_domain = m.get('SecurityDomain')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class ResourceInformationInformation(TeaModel):
    def __init__(
        self,
        key: str = None,
        key_attribute: str = None,
        key_action: str = None,
        key_description: str = None,
    ):
        # 键
        self.key = key
        # 键属性
        self.key_attribute = key_attribute
        # 键动作
        self.key_action = key_action
        # 键描述
        self.key_description = key_description

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.key_attribute is not None:
            result['KeyAttribute'] = self.key_attribute
        if self.key_action is not None:
            result['KeyAction'] = self.key_action
        if self.key_description is not None:
            result['KeyDescription'] = self.key_description
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('KeyAttribute') is not None:
            self.key_attribute = m.get('KeyAttribute')
        if m.get('KeyAction') is not None:
            self.key_action = m.get('KeyAction')
        if m.get('KeyDescription') is not None:
            self.key_description = m.get('KeyDescription')
        return self


class ResourceInformation(TeaModel):
    def __init__(
        self,
        create_time: str = None,
        resource_information_id: str = None,
        update_time: str = None,
        resource_type: str = None,
        resource_attribute: str = None,
        setup_project_id: str = None,
        information: List[ResourceInformationInformation] = None,
        architecture_id: str = None,
    ):
        # 创建时间
        self.create_time = create_time
        # 资源一级ID
        self.resource_information_id = resource_information_id
        # 更新时间
        self.update_time = update_time
        # 资源类型
        self.resource_type = resource_type
        # 资源属性
        self.resource_attribute = resource_attribute
        # 建设项目资源id
        self.setup_project_id = setup_project_id
        # 信息
        self.information = information
        # 架构id
        self.architecture_id = architecture_id

    def validate(self):
        if self.information:
            for k in self.information:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.resource_information_id is not None:
            result['ResourceInformationId'] = self.resource_information_id
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        if self.resource_attribute is not None:
            result['ResourceAttribute'] = self.resource_attribute
        if self.setup_project_id is not None:
            result['SetupProjectId'] = self.setup_project_id
        result['Information'] = []
        if self.information is not None:
            for k in self.information:
                result['Information'].append(k.to_map() if k else None)
        if self.architecture_id is not None:
            result['ArchitectureId'] = self.architecture_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('ResourceInformationId') is not None:
            self.resource_information_id = m.get('ResourceInformationId')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        if m.get('ResourceAttribute') is not None:
            self.resource_attribute = m.get('ResourceAttribute')
        if m.get('SetupProjectId') is not None:
            self.setup_project_id = m.get('SetupProjectId')
        self.information = []
        if m.get('Information') is not None:
            for k in m.get('Information'):
                temp_model = ResourceInformationInformation()
                self.information.append(temp_model.from_map(k))
        if m.get('ArchitectureId') is not None:
            self.architecture_id = m.get('ArchitectureId')
        return self


class ScheduleDutyTypeWorkerList(TeaModel):
    def __init__(
        self,
        schedule_type_id: str = None,
        schedule_worker_name: List[str] = None,
    ):
        # scheduleTypeId
        self.schedule_type_id = schedule_type_id
        # 值班人员姓名
        self.schedule_worker_name = schedule_worker_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.schedule_type_id is not None:
            result['ScheduleTypeId'] = self.schedule_type_id
        if self.schedule_worker_name is not None:
            result['ScheduleWorkerName'] = self.schedule_worker_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ScheduleTypeId') is not None:
            self.schedule_type_id = m.get('ScheduleTypeId')
        if m.get('ScheduleWorkerName') is not None:
            self.schedule_worker_name = m.get('ScheduleWorkerName')
        return self


class ScheduleDuty(TeaModel):
    def __init__(
        self,
        create_time: str = None,
        schedule_duty_id: str = None,
        update_time: str = None,
        work_date: str = None,
        work_type: str = None,
        worker_name: str = None,
        worker_id: str = None,
        start_date: str = None,
        end_date: str = None,
        schedule_type_ids: List[str] = None,
        type_worker_list: List[ScheduleDutyTypeWorkerList] = None,
    ):
        # 创建时间
        self.create_time = create_time
        # 资源一级ID
        self.schedule_duty_id = schedule_duty_id
        # 更新时间
        self.update_time = update_time
        # 值班表日期
        self.work_date = work_date
        # 值班表类型
        self.work_type = work_type
        # 值班人员姓名
        self.worker_name = worker_name
        # 值班人员工号
        self.worker_id = worker_id
        # 开始时间
        self.start_date = start_date
        # 结束时间
        self.end_date = end_date
        # scheduleTypeIds
        self.schedule_type_ids = schedule_type_ids
        # typeWorkerList
        self.type_worker_list = type_worker_list

    def validate(self):
        if self.type_worker_list:
            for k in self.type_worker_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.schedule_duty_id is not None:
            result['ScheduleDutyId'] = self.schedule_duty_id
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        if self.work_date is not None:
            result['WorkDate'] = self.work_date
        if self.work_type is not None:
            result['WorkType'] = self.work_type
        if self.worker_name is not None:
            result['WorkerName'] = self.worker_name
        if self.worker_id is not None:
            result['WorkerId'] = self.worker_id
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.schedule_type_ids is not None:
            result['ScheduleTypeIds'] = self.schedule_type_ids
        result['TypeWorkerList'] = []
        if self.type_worker_list is not None:
            for k in self.type_worker_list:
                result['TypeWorkerList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('ScheduleDutyId') is not None:
            self.schedule_duty_id = m.get('ScheduleDutyId')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        if m.get('WorkDate') is not None:
            self.work_date = m.get('WorkDate')
        if m.get('WorkType') is not None:
            self.work_type = m.get('WorkType')
        if m.get('WorkerName') is not None:
            self.worker_name = m.get('WorkerName')
        if m.get('WorkerId') is not None:
            self.worker_id = m.get('WorkerId')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('ScheduleTypeIds') is not None:
            self.schedule_type_ids = m.get('ScheduleTypeIds')
        self.type_worker_list = []
        if m.get('TypeWorkerList') is not None:
            for k in m.get('TypeWorkerList'):
                temp_model = ScheduleDutyTypeWorkerList()
                self.type_worker_list.append(temp_model.from_map(k))
        return self


class Device(TeaModel):
    def __init__(
        self,
        account_type: str = None,
        account_version: str = None,
        auth_pass_phrase: str = None,
        auth_protocol: str = None,
        community: str = None,
        device_form: str = None,
        device_id: str = None,
        device_ip: str = None,
        device_mac: str = None,
        device_sn: str = None,
        hostname: str = None,
        model: str = None,
        privacy_pass_phrase: str = None,
        privacy_protocol: str = None,
        security_domain: str = None,
        security_level: str = None,
        space: str = None,
        ssh_account: str = None,
        ssh_password: str = None,
        status: str = None,
        telnet_account: str = None,
        telnet_password: str = None,
        user_name: str = None,
        vendor: str = None,
    ):
        # 账号类型
        self.account_type = account_type
        # snmp版本号
        self.account_version = account_version
        # Auth PassPhrase
        self.auth_pass_phrase = auth_pass_phrase
        # Auth Protocol
        self.auth_protocol = auth_protocol
        # community
        self.community = community
        # 设备形态
        self.device_form = device_form
        # 设备ID
        self.device_id = device_id
        # 设备IP
        self.device_ip = device_ip
        # 设备MAC地址
        self.device_mac = device_mac
        # 设备SN
        self.device_sn = device_sn
        # 主机名
        self.hostname = hostname
        # 设备型号
        self.model = model
        # Privacy PassPhrase
        self.privacy_pass_phrase = privacy_pass_phrase
        # Privacy Protocol
        self.privacy_protocol = privacy_protocol
        # 设备安全域
        self.security_domain = security_domain
        # 安全等级
        self.security_level = security_level
        # 设备所属物理空间
        self.space = space
        # SSH登录账号
        self.ssh_account = ssh_account
        # SSH登录密码
        self.ssh_password = ssh_password
        # 设备状态
        self.status = status
        # TELNET登录账号
        self.telnet_account = telnet_account
        # TELNET登录密码
        self.telnet_password = telnet_password
        # 用户名
        self.user_name = user_name
        # 设备厂商
        self.vendor = vendor

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_type is not None:
            result['AccountType'] = self.account_type
        if self.account_version is not None:
            result['AccountVersion'] = self.account_version
        if self.auth_pass_phrase is not None:
            result['AuthPassPhrase'] = self.auth_pass_phrase
        if self.auth_protocol is not None:
            result['AuthProtocol'] = self.auth_protocol
        if self.community is not None:
            result['Community'] = self.community
        if self.device_form is not None:
            result['DeviceForm'] = self.device_form
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.device_ip is not None:
            result['DeviceIp'] = self.device_ip
        if self.device_mac is not None:
            result['DeviceMac'] = self.device_mac
        if self.device_sn is not None:
            result['DeviceSn'] = self.device_sn
        if self.hostname is not None:
            result['Hostname'] = self.hostname
        if self.model is not None:
            result['Model'] = self.model
        if self.privacy_pass_phrase is not None:
            result['PrivacyPassPhrase'] = self.privacy_pass_phrase
        if self.privacy_protocol is not None:
            result['PrivacyProtocol'] = self.privacy_protocol
        if self.security_domain is not None:
            result['SecurityDomain'] = self.security_domain
        if self.security_level is not None:
            result['SecurityLevel'] = self.security_level
        if self.space is not None:
            result['Space'] = self.space
        if self.ssh_account is not None:
            result['SshAccount'] = self.ssh_account
        if self.ssh_password is not None:
            result['SshPassword'] = self.ssh_password
        if self.status is not None:
            result['Status'] = self.status
        if self.telnet_account is not None:
            result['TelnetAccount'] = self.telnet_account
        if self.telnet_password is not None:
            result['TelnetPassword'] = self.telnet_password
        if self.user_name is not None:
            result['UserName'] = self.user_name
        if self.vendor is not None:
            result['Vendor'] = self.vendor
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountType') is not None:
            self.account_type = m.get('AccountType')
        if m.get('AccountVersion') is not None:
            self.account_version = m.get('AccountVersion')
        if m.get('AuthPassPhrase') is not None:
            self.auth_pass_phrase = m.get('AuthPassPhrase')
        if m.get('AuthProtocol') is not None:
            self.auth_protocol = m.get('AuthProtocol')
        if m.get('Community') is not None:
            self.community = m.get('Community')
        if m.get('DeviceForm') is not None:
            self.device_form = m.get('DeviceForm')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('DeviceIp') is not None:
            self.device_ip = m.get('DeviceIp')
        if m.get('DeviceMac') is not None:
            self.device_mac = m.get('DeviceMac')
        if m.get('DeviceSn') is not None:
            self.device_sn = m.get('DeviceSn')
        if m.get('Hostname') is not None:
            self.hostname = m.get('Hostname')
        if m.get('Model') is not None:
            self.model = m.get('Model')
        if m.get('PrivacyPassPhrase') is not None:
            self.privacy_pass_phrase = m.get('PrivacyPassPhrase')
        if m.get('PrivacyProtocol') is not None:
            self.privacy_protocol = m.get('PrivacyProtocol')
        if m.get('SecurityDomain') is not None:
            self.security_domain = m.get('SecurityDomain')
        if m.get('SecurityLevel') is not None:
            self.security_level = m.get('SecurityLevel')
        if m.get('Space') is not None:
            self.space = m.get('Space')
        if m.get('SshAccount') is not None:
            self.ssh_account = m.get('SshAccount')
        if m.get('SshPassword') is not None:
            self.ssh_password = m.get('SshPassword')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TelnetAccount') is not None:
            self.telnet_account = m.get('TelnetAccount')
        if m.get('TelnetPassword') is not None:
            self.telnet_password = m.get('TelnetPassword')
        if m.get('UserName') is not None:
            self.user_name = m.get('UserName')
        if m.get('Vendor') is not None:
            self.vendor = m.get('Vendor')
        return self


class TimePeriod(TeaModel):
    def __init__(
        self,
        gmt_create: str = None,
        gmt_modified: str = None,
        time_period_description: str = None,
        time_period_name: str = None,
        time_period_id: str = None,
        cron_expression: str = None,
        source: str = None,
    ):
        # 创建时间
        self.gmt_create = gmt_create
        # 修改时间
        self.gmt_modified = gmt_modified
        # 描述
        self.time_period_description = time_period_description
        # 时间段名称
        self.time_period_name = time_period_name
        # 时间段ID
        self.time_period_id = time_period_id
        # Cron表达式
        self.cron_expression = cron_expression
        # 来源
        self.source = source

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.time_period_description is not None:
            result['TimePeriodDescription'] = self.time_period_description
        if self.time_period_name is not None:
            result['TimePeriodName'] = self.time_period_name
        if self.time_period_id is not None:
            result['TimePeriodId'] = self.time_period_id
        if self.cron_expression is not None:
            result['CronExpression'] = self.cron_expression
        if self.source is not None:
            result['Source'] = self.source
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('TimePeriodDescription') is not None:
            self.time_period_description = m.get('TimePeriodDescription')
        if m.get('TimePeriodName') is not None:
            self.time_period_name = m.get('TimePeriodName')
        if m.get('TimePeriodId') is not None:
            self.time_period_id = m.get('TimePeriodId')
        if m.get('CronExpression') is not None:
            self.cron_expression = m.get('CronExpression')
        if m.get('Source') is not None:
            self.source = m.get('Source')
        return self


class AtomicStepInput(TeaModel):
    def __init__(
        self,
        description: str = None,
        name: str = None,
        sample: str = None,
        type: str = None,
    ):
        # 参数说明
        self.description = description
        # 参数名称
        self.name = name
        # 参数示例
        self.sample = sample
        # 参数类型
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.name is not None:
            result['Name'] = self.name
        if self.sample is not None:
            result['Sample'] = self.sample
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Sample') is not None:
            self.sample = m.get('Sample')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class AtomicStepOutput(TeaModel):
    def __init__(
        self,
        description: str = None,
        name: str = None,
        sample: str = None,
        type: str = None,
    ):
        # 参数说明
        self.description = description
        # 参数名称
        self.name = name
        # 参数示例
        self.sample = sample
        # 参数类型
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.name is not None:
            result['Name'] = self.name
        if self.sample is not None:
            result['Sample'] = self.sample
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Sample') is not None:
            self.sample = m.get('Sample')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class AtomicStep(TeaModel):
    def __init__(
        self,
        description: str = None,
        input: List[AtomicStepInput] = None,
        output: List[AtomicStepOutput] = None,
        step_id: str = None,
        step_name: str = None,
        step_type: str = None,
    ):
        # 步骤说明
        self.description = description
        # 步骤入参
        self.input = input
        # 步骤出参
        self.output = output
        # 步骤id
        self.step_id = step_id
        # 步骤名称
        self.step_name = step_name
        # 步骤类型
        self.step_type = step_type

    def validate(self):
        if self.input:
            for k in self.input:
                if k:
                    k.validate()
        if self.output:
            for k in self.output:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        result['Input'] = []
        if self.input is not None:
            for k in self.input:
                result['Input'].append(k.to_map() if k else None)
        result['Output'] = []
        if self.output is not None:
            for k in self.output:
                result['Output'].append(k.to_map() if k else None)
        if self.step_id is not None:
            result['StepId'] = self.step_id
        if self.step_name is not None:
            result['StepName'] = self.step_name
        if self.step_type is not None:
            result['StepType'] = self.step_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        self.input = []
        if m.get('Input') is not None:
            for k in m.get('Input'):
                temp_model = AtomicStepInput()
                self.input.append(temp_model.from_map(k))
        self.output = []
        if m.get('Output') is not None:
            for k in m.get('Output'):
                temp_model = AtomicStepOutput()
                self.output.append(temp_model.from_map(k))
        if m.get('StepId') is not None:
            self.step_id = m.get('StepId')
        if m.get('StepName') is not None:
            self.step_name = m.get('StepName')
        if m.get('StepType') is not None:
            self.step_type = m.get('StepType')
        return self


class InspectionItem(TeaModel):
    def __init__(
        self,
        item_id: str = None,
        item_name: str = None,
        item_description: str = None,
        inspection_crontab: str = None,
    ):
        # 巡检项ID
        self.item_id = item_id
        # 巡检项名字
        self.item_name = item_name
        # 巡检项描述
        self.item_description = item_description
        # 巡检定时表达式
        self.inspection_crontab = inspection_crontab

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.item_id is not None:
            result['ItemId'] = self.item_id
        if self.item_name is not None:
            result['ItemName'] = self.item_name
        if self.item_description is not None:
            result['ItemDescription'] = self.item_description
        if self.inspection_crontab is not None:
            result['InspectionCrontab'] = self.inspection_crontab
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ItemId') is not None:
            self.item_id = m.get('ItemId')
        if m.get('ItemName') is not None:
            self.item_name = m.get('ItemName')
        if m.get('ItemDescription') is not None:
            self.item_description = m.get('ItemDescription')
        if m.get('InspectionCrontab') is not None:
            self.inspection_crontab = m.get('InspectionCrontab')
        return self


class DeviceProperty(TeaModel):
    def __init__(
        self,
        content: str = None,
        device_form: str = None,
        format: str = None,
        name_cn: str = None,
        name_en: str = None,
        property_id: str = None,
    ):
        # 属性值
        self.content = content
        # 设备形态
        self.device_form = device_form
        # 属性格式，包括JSON和SPLITTER（分隔符）
        self.format = format
        # 属性展示名称
        self.name_cn = name_cn
        # 属性英文主键
        self.name_en = name_en
        # 设备属性ID
        self.property_id = property_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.device_form is not None:
            result['DeviceForm'] = self.device_form
        if self.format is not None:
            result['Format'] = self.format
        if self.name_cn is not None:
            result['NameCn'] = self.name_cn
        if self.name_en is not None:
            result['NameEn'] = self.name_en
        if self.property_id is not None:
            result['PropertyId'] = self.property_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('DeviceForm') is not None:
            self.device_form = m.get('DeviceForm')
        if m.get('Format') is not None:
            self.format = m.get('Format')
        if m.get('NameCn') is not None:
            self.name_cn = m.get('NameCn')
        if m.get('NameEn') is not None:
            self.name_en = m.get('NameEn')
        if m.get('PropertyId') is not None:
            self.property_id = m.get('PropertyId')
        return self


class AgentsTask(TeaModel):
    def __init__(
        self,
        action_type: str = None,
        agent_type: str = None,
        gmt_create: str = None,
        gmt_modify: str = None,
        params: str = None,
        status: str = None,
        agents_task_id: str = None,
    ):
        # 操作类型
        self.action_type = action_type
        # 探针类型
        self.agent_type = agent_type
        # 创建时间
        self.gmt_create = gmt_create
        # 更新时间
        self.gmt_modify = gmt_modify
        # 任务参数
        self.params = params
        # 任务状态
        self.status = status
        # 任务ID
        self.agents_task_id = agents_task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.action_type is not None:
            result['ActionType'] = self.action_type
        if self.agent_type is not None:
            result['AgentType'] = self.agent_type
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modify is not None:
            result['GmtModify'] = self.gmt_modify
        if self.params is not None:
            result['Params'] = self.params
        if self.status is not None:
            result['Status'] = self.status
        if self.agents_task_id is not None:
            result['AgentsTaskId'] = self.agents_task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ActionType') is not None:
            self.action_type = m.get('ActionType')
        if m.get('AgentType') is not None:
            self.agent_type = m.get('AgentType')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModify') is not None:
            self.gmt_modify = m.get('GmtModify')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('AgentsTaskId') is not None:
            self.agents_task_id = m.get('AgentsTaskId')
        return self


class ModuleDevice(TeaModel):
    def __init__(
        self,
        create_time: str = None,
        update_time: str = None,
        id: str = None,
        device_role: str = None,
        device_count: int = None,
        device_x: str = None,
        device_y: str = None,
        role: str = None,
        count: int = None,
        x: str = None,
        y: str = None,
    ):
        # 创建时间
        self.create_time = create_time
        # 更新时间
        self.update_time = update_time
        # 设备uuid
        self.id = id
        # 设备角色
        self.device_role = device_role
        # 区块内设备数量
        self.device_count = device_count
        # 设备x坐标
        self.device_x = device_x
        # 设备y坐标
        self.device_y = device_y
        # 设备角色
        self.role = role
        # 区块内设备数量
        self.count = count
        # 设备x坐标
        self.x = x
        # 设备y坐标
        self.y = y

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        if self.id is not None:
            result['Id'] = self.id
        if self.device_role is not None:
            result['DeviceRole'] = self.device_role
        if self.device_count is not None:
            result['DeviceCount'] = self.device_count
        if self.device_x is not None:
            result['DeviceX'] = self.device_x
        if self.device_y is not None:
            result['DeviceY'] = self.device_y
        if self.role is not None:
            result['Role'] = self.role
        if self.count is not None:
            result['Count'] = self.count
        if self.x is not None:
            result['X'] = self.x
        if self.y is not None:
            result['Y'] = self.y
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('DeviceRole') is not None:
            self.device_role = m.get('DeviceRole')
        if m.get('DeviceCount') is not None:
            self.device_count = m.get('DeviceCount')
        if m.get('DeviceX') is not None:
            self.device_x = m.get('DeviceX')
        if m.get('DeviceY') is not None:
            self.device_y = m.get('DeviceY')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('X') is not None:
            self.x = m.get('X')
        if m.get('Y') is not None:
            self.y = m.get('Y')
        return self


class ModuleModuleDetailsDeviceDetails(TeaModel):
    def __init__(
        self,
        order_number: int = None,
    ):
        # 设备序号
        self.order_number = order_number

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.order_number is not None:
            result['OrderNumber'] = self.order_number
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OrderNumber') is not None:
            self.order_number = m.get('OrderNumber')
        return self


class ModuleModuleDetails(TeaModel):
    def __init__(
        self,
        order_number: int = None,
        device_details: List[ModuleModuleDetailsDeviceDetails] = None,
    ):
        # 模块序号
        self.order_number = order_number
        # 设备详情
        self.device_details = device_details

    def validate(self):
        if self.device_details:
            for k in self.device_details:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.order_number is not None:
            result['OrderNumber'] = self.order_number
        result['DeviceDetails'] = []
        if self.device_details is not None:
            for k in self.device_details:
                result['DeviceDetails'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OrderNumber') is not None:
            self.order_number = m.get('OrderNumber')
        self.device_details = []
        if m.get('DeviceDetails') is not None:
            for k in m.get('DeviceDetails'):
                temp_model = ModuleModuleDetailsDeviceDetails()
                self.device_details.append(temp_model.from_map(k))
        return self


class Module(TeaModel):
    def __init__(
        self,
        module_id: str = None,
        create_time: str = None,
        update_time: str = None,
        id: str = None,
        parent_module_id: str = None,
        name: str = None,
        module_type: str = None,
        min_count: int = None,
        max_count: int = None,
        stack: bool = None,
        device: ModuleDevice = None,
        module_details: List[ModuleModuleDetails] = None,
    ):
        # 资源一级ID
        self.module_id = module_id
        # 创建时间
        self.create_time = create_time
        # 更新时间
        self.update_time = update_time
        # 模块uuid
        self.id = id
        # 父模块uuid
        self.parent_module_id = parent_module_id
        # 模块名字
        self.name = name
        # 模块类型
        self.module_type = module_type
        # 最小建设模块数量
        self.min_count = min_count
        # 最大建设模块数量
        self.max_count = max_count
        # 堆叠
        self.stack = stack
        # 设备信息
        self.device = device
        # 模块详情
        self.module_details = module_details

    def validate(self):
        if self.device:
            self.device.validate()
        if self.module_details:
            for k in self.module_details:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.module_id is not None:
            result['ModuleId'] = self.module_id
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        if self.id is not None:
            result['Id'] = self.id
        if self.parent_module_id is not None:
            result['ParentModuleId'] = self.parent_module_id
        if self.name is not None:
            result['Name'] = self.name
        if self.module_type is not None:
            result['ModuleType'] = self.module_type
        if self.min_count is not None:
            result['MinCount'] = self.min_count
        if self.max_count is not None:
            result['MaxCount'] = self.max_count
        if self.stack is not None:
            result['Stack'] = self.stack
        if self.device is not None:
            result['Device'] = self.device.to_map()
        result['ModuleDetails'] = []
        if self.module_details is not None:
            for k in self.module_details:
                result['ModuleDetails'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ModuleId') is not None:
            self.module_id = m.get('ModuleId')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('ParentModuleId') is not None:
            self.parent_module_id = m.get('ParentModuleId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ModuleType') is not None:
            self.module_type = m.get('ModuleType')
        if m.get('MinCount') is not None:
            self.min_count = m.get('MinCount')
        if m.get('MaxCount') is not None:
            self.max_count = m.get('MaxCount')
        if m.get('Stack') is not None:
            self.stack = m.get('Stack')
        if m.get('Device') is not None:
            temp_model = ModuleDevice()
            self.device = temp_model.from_map(m['Device'])
        self.module_details = []
        if m.get('ModuleDetails') is not None:
            for k in m.get('ModuleDetails'):
                temp_model = ModuleModuleDetails()
                self.module_details.append(temp_model.from_map(k))
        return self


class DataViewChart(TeaModel):
    def __init__(
        self,
        gmt_create: str = None,
        gmt_modified: str = None,
        data_view_id: str = None,
        chart_type: str = None,
        data_view_source: str = None,
        grid: str = None,
    ):
        # 创建时间
        self.gmt_create = gmt_create
        # 修改时间
        self.gmt_modified = gmt_modified
        # 数据视图ID
        self.data_view_id = data_view_id
        # 图表类型
        self.chart_type = chart_type
        # 数据源类型
        self.data_view_source = data_view_source
        # 布局配置
        self.grid = grid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.data_view_id is not None:
            result['DataViewId'] = self.data_view_id
        if self.chart_type is not None:
            result['ChartType'] = self.chart_type
        if self.data_view_source is not None:
            result['DataViewSource'] = self.data_view_source
        if self.grid is not None:
            result['Grid'] = self.grid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('DataViewId') is not None:
            self.data_view_id = m.get('DataViewId')
        if m.get('ChartType') is not None:
            self.chart_type = m.get('ChartType')
        if m.get('DataViewSource') is not None:
            self.data_view_source = m.get('DataViewSource')
        if m.get('Grid') is not None:
            self.grid = m.get('Grid')
        return self


class ScriptHistoryInput(TeaModel):
    def __init__(
        self,
        description: str = None,
        name: str = None,
        sample: str = None,
        type: str = None,
    ):
        # 参数说明
        self.description = description
        # 参数名称
        self.name = name
        # 参数示例
        self.sample = sample
        # 参数类型
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.name is not None:
            result['Name'] = self.name
        if self.sample is not None:
            result['Sample'] = self.sample
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Sample') is not None:
            self.sample = m.get('Sample')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class ScriptHistoryOutput(TeaModel):
    def __init__(
        self,
        description: str = None,
        name: str = None,
        sample: str = None,
        type: str = None,
    ):
        # 参数说明
        self.description = description
        # 参数名称
        self.name = name
        # 参数示例
        self.sample = sample
        # 参数类型
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.name is not None:
            result['Name'] = self.name
        if self.sample is not None:
            result['Sample'] = self.sample
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Sample') is not None:
            self.sample = m.get('Sample')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class ScriptHistory(TeaModel):
    def __init__(
        self,
        comment: str = None,
        content: str = None,
        gmt_create: str = None,
        gmt_modify: str = None,
        input: List[ScriptHistoryInput] = None,
        output: List[ScriptHistoryOutput] = None,
        script_id: str = None,
        version_id: str = None,
    ):
        # 版本说明
        self.comment = comment
        # 脚本代码
        self.content = content
        # 创建时间
        self.gmt_create = gmt_create
        # 修改时间
        self.gmt_modify = gmt_modify
        # 模板入参
        self.input = input
        # 模板出参
        self.output = output
        # 脚本id
        self.script_id = script_id
        # 版本id
        self.version_id = version_id

    def validate(self):
        if self.input:
            for k in self.input:
                if k:
                    k.validate()
        if self.output:
            for k in self.output:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.content is not None:
            result['Content'] = self.content
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modify is not None:
            result['GmtModify'] = self.gmt_modify
        result['Input'] = []
        if self.input is not None:
            for k in self.input:
                result['Input'].append(k.to_map() if k else None)
        result['Output'] = []
        if self.output is not None:
            for k in self.output:
                result['Output'].append(k.to_map() if k else None)
        if self.script_id is not None:
            result['ScriptId'] = self.script_id
        if self.version_id is not None:
            result['VersionId'] = self.version_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModify') is not None:
            self.gmt_modify = m.get('GmtModify')
        self.input = []
        if m.get('Input') is not None:
            for k in m.get('Input'):
                temp_model = ScriptHistoryInput()
                self.input.append(temp_model.from_map(k))
        self.output = []
        if m.get('Output') is not None:
            for k in m.get('Output'):
                temp_model = ScriptHistoryOutput()
                self.output.append(temp_model.from_map(k))
        if m.get('ScriptId') is not None:
            self.script_id = m.get('ScriptId')
        if m.get('VersionId') is not None:
            self.version_id = m.get('VersionId')
        return self


class NetworkArchitecture(TeaModel):
    def __init__(
        self,
        network_architecture_id: str = None,
        create_time: str = None,
        update_time: str = None,
        role: str = None,
        group_number: int = None,
        device_number: int = None,
        availabe: bool = None,
        stack: bool = None,
        selected: bool = None,
        children: List[str] = None,
        id: str = None,
        version: str = None,
        name: str = None,
        description: str = None,
        status: str = None,
        arch_version_iteration_id: str = None,
    ):
        # 资源一级ID
        self.network_architecture_id = network_architecture_id
        # 创建时间
        self.create_time = create_time
        # 更新时间
        self.update_time = update_time
        # 架构内容
        self.role = role
        # 组数
        self.group_number = group_number
        # 设备数
        self.device_number = device_number
        # 可用
        self.availabe = availabe
        # 堆叠
        self.stack = stack
        # 可选
        self.selected = selected
        # 子节点
        self.children = children
        # 架构资源id
        self.id = id
        # 架构版本
        self.version = version
        # 架构名称
        self.name = name
        # 架构描述
        self.description = description
        # 架构状态
        self.status = status
        # 架构最新版本uuid
        self.arch_version_iteration_id = arch_version_iteration_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.network_architecture_id is not None:
            result['NetworkArchitectureId'] = self.network_architecture_id
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        if self.role is not None:
            result['Role'] = self.role
        if self.group_number is not None:
            result['GroupNumber'] = self.group_number
        if self.device_number is not None:
            result['DeviceNumber'] = self.device_number
        if self.availabe is not None:
            result['Availabe'] = self.availabe
        if self.stack is not None:
            result['Stack'] = self.stack
        if self.selected is not None:
            result['Selected'] = self.selected
        if self.children is not None:
            result['Children'] = self.children
        if self.id is not None:
            result['Id'] = self.id
        if self.version is not None:
            result['Version'] = self.version
        if self.name is not None:
            result['Name'] = self.name
        if self.description is not None:
            result['Description'] = self.description
        if self.status is not None:
            result['Status'] = self.status
        if self.arch_version_iteration_id is not None:
            result['ArchVersionIterationId'] = self.arch_version_iteration_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NetworkArchitectureId') is not None:
            self.network_architecture_id = m.get('NetworkArchitectureId')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        if m.get('GroupNumber') is not None:
            self.group_number = m.get('GroupNumber')
        if m.get('DeviceNumber') is not None:
            self.device_number = m.get('DeviceNumber')
        if m.get('Availabe') is not None:
            self.availabe = m.get('Availabe')
        if m.get('Stack') is not None:
            self.stack = m.get('Stack')
        if m.get('Selected') is not None:
            self.selected = m.get('Selected')
        if m.get('Children') is not None:
            self.children = m.get('Children')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Version') is not None:
            self.version = m.get('Version')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('ArchVersionIterationId') is not None:
            self.arch_version_iteration_id = m.get('ArchVersionIterationId')
        return self


class ConfigurationVariate(TeaModel):
    def __init__(
        self,
        create_time: str = None,
        update_time: str = None,
        configuration_variate_id: str = None,
        variate_name: str = None,
        comment: str = None,
        format_function: str = None,
    ):
        # 创建时间
        self.create_time = create_time
        # 更新时间
        self.update_time = update_time
        # 资源一级ID
        self.configuration_variate_id = configuration_variate_id
        # 变量名字
        self.variate_name = variate_name
        # 描述变量
        self.comment = comment
        # python转换函数
        self.format_function = format_function

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        if self.configuration_variate_id is not None:
            result['ConfigurationVariateId'] = self.configuration_variate_id
        if self.variate_name is not None:
            result['VariateName'] = self.variate_name
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.format_function is not None:
            result['FormatFunction'] = self.format_function
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        if m.get('ConfigurationVariateId') is not None:
            self.configuration_variate_id = m.get('ConfigurationVariateId')
        if m.get('VariateName') is not None:
            self.variate_name = m.get('VariateName')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('FormatFunction') is not None:
            self.format_function = m.get('FormatFunction')
        return self


class IpZoneLayer(TeaModel):
    def __init__(
        self,
        name: str = None,
        value: str = None,
    ):
        # 园区层级名称
        self.name = name
        # 园区层级值
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class Ip(TeaModel):
    def __init__(
        self,
        ip_id: str = None,
        ip_name: str = None,
        create_time: str = None,
        ip_address: str = None,
        parent_ip_block: str = None,
        business_type_id: str = None,
        business_type_name: str = None,
        status: str = None,
        device_name: str = None,
        port: str = None,
        device_mac: str = None,
        zone_layer: List[IpZoneLayer] = None,
    ):
        # 资源一级ID
        self.ip_id = ip_id
        # 资源名称
        self.ip_name = ip_name
        # 创建时间
        self.create_time = create_time
        # IP地址
        self.ip_address = ip_address
        # 地址段
        self.parent_ip_block = parent_ip_block
        # 业务类型UID
        self.business_type_id = business_type_id
        # 业务类型名称
        self.business_type_name = business_type_name
        # 状态 using available lock
        self.status = status
        # 设备名称
        self.device_name = device_name
        # 设备端口名称
        self.port = port
        # 设备MAC
        self.device_mac = device_mac
        # 园区层级
        self.zone_layer = zone_layer

    def validate(self):
        if self.zone_layer:
            for k in self.zone_layer:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ip_id is not None:
            result['IpId'] = self.ip_id
        if self.ip_name is not None:
            result['IpName'] = self.ip_name
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.ip_address is not None:
            result['IpAddress'] = self.ip_address
        if self.parent_ip_block is not None:
            result['ParentIpBlock'] = self.parent_ip_block
        if self.business_type_id is not None:
            result['BusinessTypeId'] = self.business_type_id
        if self.business_type_name is not None:
            result['BusinessTypeName'] = self.business_type_name
        if self.status is not None:
            result['Status'] = self.status
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.port is not None:
            result['Port'] = self.port
        if self.device_mac is not None:
            result['DeviceMac'] = self.device_mac
        result['ZoneLayer'] = []
        if self.zone_layer is not None:
            for k in self.zone_layer:
                result['ZoneLayer'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IpId') is not None:
            self.ip_id = m.get('IpId')
        if m.get('IpName') is not None:
            self.ip_name = m.get('IpName')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('IpAddress') is not None:
            self.ip_address = m.get('IpAddress')
        if m.get('ParentIpBlock') is not None:
            self.parent_ip_block = m.get('ParentIpBlock')
        if m.get('BusinessTypeId') is not None:
            self.business_type_id = m.get('BusinessTypeId')
        if m.get('BusinessTypeName') is not None:
            self.business_type_name = m.get('BusinessTypeName')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('DeviceMac') is not None:
            self.device_mac = m.get('DeviceMac')
        self.zone_layer = []
        if m.get('ZoneLayer') is not None:
            for k in m.get('ZoneLayer'):
                temp_model = IpZoneLayer()
                self.zone_layer.append(temp_model.from_map(k))
        return self


class OsVersion(TeaModel):
    def __init__(
        self,
        create_time: str = None,
        vendor: str = None,
        model: str = None,
        os_version: str = None,
        status: str = None,
        file_name: str = None,
        file_path: str = None,
        os_version_id: str = None,
        access_id: str = None,
        policy: str = None,
        signature: str = None,
        directory: str = None,
        host: str = None,
        expire_time: str = None,
    ):
        # 创建时间
        self.create_time = create_time
        # 厂商
        self.vendor = vendor
        # 型号
        self.model = model
        # 版本
        self.os_version = os_version
        # 状态
        self.status = status
        # file
        self.file_name = file_name
        # 文件路径
        self.file_path = file_path
        # 资源id
        self.os_version_id = os_version_id
        # 用户名
        self.access_id = access_id
        # 策略
        self.policy = policy
        # 签名
        self.signature = signature
        # 目录
        self.directory = directory
        # 主机
        self.host = host
        # 过期时间
        self.expire_time = expire_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.vendor is not None:
            result['Vendor'] = self.vendor
        if self.model is not None:
            result['Model'] = self.model
        if self.os_version is not None:
            result['OsVersion'] = self.os_version
        if self.status is not None:
            result['Status'] = self.status
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.file_path is not None:
            result['FilePath'] = self.file_path
        if self.os_version_id is not None:
            result['OsVersionId'] = self.os_version_id
        if self.access_id is not None:
            result['AccessId'] = self.access_id
        if self.policy is not None:
            result['Policy'] = self.policy
        if self.signature is not None:
            result['Signature'] = self.signature
        if self.directory is not None:
            result['Directory'] = self.directory
        if self.host is not None:
            result['Host'] = self.host
        if self.expire_time is not None:
            result['ExpireTime'] = self.expire_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Vendor') is not None:
            self.vendor = m.get('Vendor')
        if m.get('Model') is not None:
            self.model = m.get('Model')
        if m.get('OsVersion') is not None:
            self.os_version = m.get('OsVersion')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('FilePath') is not None:
            self.file_path = m.get('FilePath')
        if m.get('OsVersionId') is not None:
            self.os_version_id = m.get('OsVersionId')
        if m.get('AccessId') is not None:
            self.access_id = m.get('AccessId')
        if m.get('Policy') is not None:
            self.policy = m.get('Policy')
        if m.get('Signature') is not None:
            self.signature = m.get('Signature')
        if m.get('Directory') is not None:
            self.directory = m.get('Directory')
        if m.get('Host') is not None:
            self.host = m.get('Host')
        if m.get('ExpireTime') is not None:
            self.expire_time = m.get('ExpireTime')
        return self


class TaskLog(TeaModel):
    def __init__(
        self,
        func_name: str = None,
        gmt_create: str = None,
        level: str = None,
        line_no: int = None,
        log_id: str = None,
        message: str = None,
        task_id: str = None,
    ):
        # 函数名
        self.func_name = func_name
        # 记录时间
        self.gmt_create = gmt_create
        # 日志等级
        self.level = level
        # 行数
        self.line_no = line_no
        # 日志id
        self.log_id = log_id
        # 日志信息
        self.message = message
        # 任务id
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.func_name is not None:
            result['FuncName'] = self.func_name
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.level is not None:
            result['Level'] = self.level
        if self.line_no is not None:
            result['LineNo'] = self.line_no
        if self.log_id is not None:
            result['LogId'] = self.log_id
        if self.message is not None:
            result['Message'] = self.message
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FuncName') is not None:
            self.func_name = m.get('FuncName')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('LineNo') is not None:
            self.line_no = m.get('LineNo')
        if m.get('LogId') is not None:
            self.log_id = m.get('LogId')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class ConfigurationSpecification(TeaModel):
    def __init__(
        self,
        create_time: str = None,
        update_time: str = None,
        specification_name: str = None,
        configuration_specification_id: str = None,
        architecture: str = None,
        role: str = None,
        vendor: str = None,
        model: str = None,
        specification_content: str = None,
        related_variate: List[str] = None,
    ):
        # 创建时间
        self.create_time = create_time
        # 更新时间
        self.update_time = update_time
        # 配置规范名字
        self.specification_name = specification_name
        # 配置规范uid
        self.configuration_specification_id = configuration_specification_id
        # 架构类型
        self.architecture = architecture
        # 角色
        self.role = role
        # 厂商
        self.vendor = vendor
        # 型号
        self.model = model
        # 配置规范内容
        self.specification_content = specification_content
        # 相关变量
        self.related_variate = related_variate

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        if self.specification_name is not None:
            result['SpecificationName'] = self.specification_name
        if self.configuration_specification_id is not None:
            result['ConfigurationSpecificationId'] = self.configuration_specification_id
        if self.architecture is not None:
            result['Architecture'] = self.architecture
        if self.role is not None:
            result['Role'] = self.role
        if self.vendor is not None:
            result['Vendor'] = self.vendor
        if self.model is not None:
            result['Model'] = self.model
        if self.specification_content is not None:
            result['SpecificationContent'] = self.specification_content
        if self.related_variate is not None:
            result['RelatedVariate'] = self.related_variate
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        if m.get('SpecificationName') is not None:
            self.specification_name = m.get('SpecificationName')
        if m.get('ConfigurationSpecificationId') is not None:
            self.configuration_specification_id = m.get('ConfigurationSpecificationId')
        if m.get('Architecture') is not None:
            self.architecture = m.get('Architecture')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        if m.get('Vendor') is not None:
            self.vendor = m.get('Vendor')
        if m.get('Model') is not None:
            self.model = m.get('Model')
        if m.get('SpecificationContent') is not None:
            self.specification_content = m.get('SpecificationContent')
        if m.get('RelatedVariate') is not None:
            self.related_variate = m.get('RelatedVariate')
        return self


class ZoneTypeZoneTypeLayer(TeaModel):
    def __init__(
        self,
        name: str = None,
        mask: int = None,
    ):
        # 园区层级名称
        self.name = name
        # 园区层级掩码
        self.mask = mask

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.mask is not None:
            result['Mask'] = self.mask
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Mask') is not None:
            self.mask = m.get('Mask')
        return self


class ZoneType(TeaModel):
    def __init__(
        self,
        zone_type_name: str = None,
        create_time: str = None,
        zone_type_id: str = None,
        name: str = None,
        zone_type_layer: List[ZoneTypeZoneTypeLayer] = None,
    ):
        # 资源名称
        self.zone_type_name = zone_type_name
        # 创建时间
        self.create_time = create_time
        # 资源一级ID
        self.zone_type_id = zone_type_id
        # 园区类型名称
        self.name = name
        # 园区层级
        self.zone_type_layer = zone_type_layer

    def validate(self):
        if self.zone_type_layer:
            for k in self.zone_type_layer:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.zone_type_name is not None:
            result['ZoneTypeName'] = self.zone_type_name
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.zone_type_id is not None:
            result['ZoneTypeId'] = self.zone_type_id
        if self.name is not None:
            result['Name'] = self.name
        result['ZoneTypeLayer'] = []
        if self.zone_type_layer is not None:
            for k in self.zone_type_layer:
                result['ZoneTypeLayer'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ZoneTypeName') is not None:
            self.zone_type_name = m.get('ZoneTypeName')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('ZoneTypeId') is not None:
            self.zone_type_id = m.get('ZoneTypeId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        self.zone_type_layer = []
        if m.get('ZoneTypeLayer') is not None:
            for k in m.get('ZoneTypeLayer'):
                temp_model = ZoneTypeZoneTypeLayer()
                self.zone_type_layer.append(temp_model.from_map(k))
        return self


class SetupProjectPackages(TeaModel):
    def __init__(
        self,
        role: str = None,
        device_number: str = None,
        vendor: str = None,
        model: str = None,
    ):
        # 角色
        self.role = role
        # 设备号
        self.device_number = device_number
        # 厂商
        self.vendor = vendor
        # 型号
        self.model = model

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.role is not None:
            result['Role'] = self.role
        if self.device_number is not None:
            result['DeviceNumber'] = self.device_number
        if self.vendor is not None:
            result['Vendor'] = self.vendor
        if self.model is not None:
            result['Model'] = self.model
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Role') is not None:
            self.role = m.get('Role')
        if m.get('DeviceNumber') is not None:
            self.device_number = m.get('DeviceNumber')
        if m.get('Vendor') is not None:
            self.vendor = m.get('Vendor')
        if m.get('Model') is not None:
            self.model = m.get('Model')
        return self


class SetupProject(TeaModel):
    def __init__(
        self,
        setup_project_name: str = None,
        create_time: str = None,
        setup_project_id: str = None,
        space_id: str = None,
        description: str = None,
        arch_id: str = None,
        delivery_time: str = None,
        nodes: str = None,
        architecture_id: str = None,
        status: str = None,
        space_type: str = None,
        space_name: str = None,
        arch_version: str = None,
        packages: List[SetupProjectPackages] = None,
    ):
        # 资源名称
        self.setup_project_name = setup_project_name
        # 创建时间
        self.create_time = create_time
        # 资源一级ID
        self.setup_project_id = setup_project_id
        # 物理空间uId
        self.space_id = space_id
        # 描述
        self.description = description
        # 架构id
        self.arch_id = arch_id
        # 预计交付时间
        self.delivery_time = delivery_time
        # 节点
        self.nodes = nodes
        # 架构id
        self.architecture_id = architecture_id
        # 状态
        self.status = status
        # 物理空间类型
        self.space_type = space_type
        # 物理空间名称
        self.space_name = space_name
        # 架构版本
        self.arch_version = arch_version
        # 套餐
        self.packages = packages

    def validate(self):
        if self.packages:
            for k in self.packages:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.setup_project_name is not None:
            result['SetupProjectName'] = self.setup_project_name
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.setup_project_id is not None:
            result['SetupProjectId'] = self.setup_project_id
        if self.space_id is not None:
            result['SpaceId'] = self.space_id
        if self.description is not None:
            result['Description'] = self.description
        if self.arch_id is not None:
            result['ArchId'] = self.arch_id
        if self.delivery_time is not None:
            result['DeliveryTime'] = self.delivery_time
        if self.nodes is not None:
            result['Nodes'] = self.nodes
        if self.architecture_id is not None:
            result['ArchitectureId'] = self.architecture_id
        if self.status is not None:
            result['Status'] = self.status
        if self.space_type is not None:
            result['SpaceType'] = self.space_type
        if self.space_name is not None:
            result['SpaceName'] = self.space_name
        if self.arch_version is not None:
            result['ArchVersion'] = self.arch_version
        result['Packages'] = []
        if self.packages is not None:
            for k in self.packages:
                result['Packages'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SetupProjectName') is not None:
            self.setup_project_name = m.get('SetupProjectName')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('SetupProjectId') is not None:
            self.setup_project_id = m.get('SetupProjectId')
        if m.get('SpaceId') is not None:
            self.space_id = m.get('SpaceId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ArchId') is not None:
            self.arch_id = m.get('ArchId')
        if m.get('DeliveryTime') is not None:
            self.delivery_time = m.get('DeliveryTime')
        if m.get('Nodes') is not None:
            self.nodes = m.get('Nodes')
        if m.get('ArchitectureId') is not None:
            self.architecture_id = m.get('ArchitectureId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('SpaceType') is not None:
            self.space_type = m.get('SpaceType')
        if m.get('SpaceName') is not None:
            self.space_name = m.get('SpaceName')
        if m.get('ArchVersion') is not None:
            self.arch_version = m.get('ArchVersion')
        self.packages = []
        if m.get('Packages') is not None:
            for k in m.get('Packages'):
                temp_model = SetupProjectPackages()
                self.packages.append(temp_model.from_map(k))
        return self


class InspectionTaskInspectionAlarmRules(TeaModel):
    def __init__(
        self,
        expression: str = None,
        operator: str = None,
        value: str = None,
        actual_value: str = None,
        level: str = None,
    ):
        # 告警表达式
        self.expression = expression
        # 告警操作符
        self.operator = operator
        # 告警值
        self.value = value
        # 告警实际值
        self.actual_value = actual_value
        # 告警级别
        self.level = level

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.expression is not None:
            result['Expression'] = self.expression
        if self.operator is not None:
            result['Operator'] = self.operator
        if self.value is not None:
            result['Value'] = self.value
        if self.actual_value is not None:
            result['ActualValue'] = self.actual_value
        if self.level is not None:
            result['Level'] = self.level
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Expression') is not None:
            self.expression = m.get('Expression')
        if m.get('Operator') is not None:
            self.operator = m.get('Operator')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        if m.get('ActualValue') is not None:
            self.actual_value = m.get('ActualValue')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        return self


class InspectionTask(TeaModel):
    def __init__(
        self,
        template_id: str = None,
        item_name: str = None,
        item_id: str = None,
        space: str = None,
        hostname: str = None,
        ip: str = None,
        vendor: str = None,
        model: str = None,
        role: str = None,
        task_status: str = None,
        device_id: str = None,
        error_code: str = None,
        inspection_result: str = None,
        execution_begin_time: str = None,
        execution_end_time: str = None,
        inspection_alarm_rules: List[InspectionTaskInspectionAlarmRules] = None,
    ):
        # 巡检模板ID
        self.template_id = template_id
        # 巡检项名字
        self.item_name = item_name
        # 巡检项ID
        self.item_id = item_id
        # 物理空间
        self.space = space
        # 主机名
        self.hostname = hostname
        # 设备IP
        self.ip = ip
        # 厂商
        self.vendor = vendor
        # 型号
        self.model = model
        # 角色
        self.role = role
        # 任务状态
        self.task_status = task_status
        # 设备ID
        self.device_id = device_id
        # 错误码
        self.error_code = error_code
        # 执行结果
        self.inspection_result = inspection_result
        # 执行开始时间
        self.execution_begin_time = execution_begin_time
        # 执行结束时间
        self.execution_end_time = execution_end_time
        # 告警规则
        self.inspection_alarm_rules = inspection_alarm_rules

    def validate(self):
        if self.inspection_alarm_rules:
            for k in self.inspection_alarm_rules:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        if self.item_name is not None:
            result['ItemName'] = self.item_name
        if self.item_id is not None:
            result['ItemId'] = self.item_id
        if self.space is not None:
            result['Space'] = self.space
        if self.hostname is not None:
            result['Hostname'] = self.hostname
        if self.ip is not None:
            result['IP'] = self.ip
        if self.vendor is not None:
            result['Vendor'] = self.vendor
        if self.model is not None:
            result['Model'] = self.model
        if self.role is not None:
            result['Role'] = self.role
        if self.task_status is not None:
            result['TaskStatus'] = self.task_status
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.inspection_result is not None:
            result['InspectionResult'] = self.inspection_result
        if self.execution_begin_time is not None:
            result['ExecutionBeginTime'] = self.execution_begin_time
        if self.execution_end_time is not None:
            result['ExecutionEndTime'] = self.execution_end_time
        result['InspectionAlarmRules'] = []
        if self.inspection_alarm_rules is not None:
            for k in self.inspection_alarm_rules:
                result['InspectionAlarmRules'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        if m.get('ItemName') is not None:
            self.item_name = m.get('ItemName')
        if m.get('ItemId') is not None:
            self.item_id = m.get('ItemId')
        if m.get('Space') is not None:
            self.space = m.get('Space')
        if m.get('Hostname') is not None:
            self.hostname = m.get('Hostname')
        if m.get('IP') is not None:
            self.ip = m.get('IP')
        if m.get('Vendor') is not None:
            self.vendor = m.get('Vendor')
        if m.get('Model') is not None:
            self.model = m.get('Model')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        if m.get('TaskStatus') is not None:
            self.task_status = m.get('TaskStatus')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('InspectionResult') is not None:
            self.inspection_result = m.get('InspectionResult')
        if m.get('ExecutionBeginTime') is not None:
            self.execution_begin_time = m.get('ExecutionBeginTime')
        if m.get('ExecutionEndTime') is not None:
            self.execution_end_time = m.get('ExecutionEndTime')
        self.inspection_alarm_rules = []
        if m.get('InspectionAlarmRules') is not None:
            for k in m.get('InspectionAlarmRules'):
                temp_model = InspectionTaskInspectionAlarmRules()
                self.inspection_alarm_rules.append(temp_model.from_map(k))
        return self


class CliTask(TeaModel):
    def __init__(
        self,
        agent_ip: str = None,
        cli_task_id: str = None,
        command: str = None,
        device_id: str = None,
        gmt_create: str = None,
        gmt_modify: str = None,
        output: str = None,
        protocol: str = None,
        response_code: str = None,
        result: str = None,
        session_id: str = None,
        status: str = None,
        timeout: int = None,
    ):
        # agent IP
        self.agent_ip = agent_ip
        # cli任务id
        self.cli_task_id = cli_task_id
        # cli命令
        self.command = command
        # 设备id
        self.device_id = device_id
        # 创建时间
        self.gmt_create = gmt_create
        # 修改时间
        self.gmt_modify = gmt_modify
        # 设备回显
        self.output = output
        # 协议
        self.protocol = protocol
        # 任务错误码
        self.response_code = response_code
        # 任务结果
        self.result = result
        # 会话id
        self.session_id = session_id
        # cli任务状态
        self.status = status
        # 超时参数
        self.timeout = timeout

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_ip is not None:
            result['AgentIp'] = self.agent_ip
        if self.cli_task_id is not None:
            result['CliTaskId'] = self.cli_task_id
        if self.command is not None:
            result['Command'] = self.command
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modify is not None:
            result['GmtModify'] = self.gmt_modify
        if self.output is not None:
            result['Output'] = self.output
        if self.protocol is not None:
            result['Protocol'] = self.protocol
        if self.response_code is not None:
            result['ResponseCode'] = self.response_code
        if self.result is not None:
            result['Result'] = self.result
        if self.session_id is not None:
            result['SessionId'] = self.session_id
        if self.status is not None:
            result['Status'] = self.status
        if self.timeout is not None:
            result['Timeout'] = self.timeout
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgentIp') is not None:
            self.agent_ip = m.get('AgentIp')
        if m.get('CliTaskId') is not None:
            self.cli_task_id = m.get('CliTaskId')
        if m.get('Command') is not None:
            self.command = m.get('Command')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModify') is not None:
            self.gmt_modify = m.get('GmtModify')
        if m.get('Output') is not None:
            self.output = m.get('Output')
        if m.get('Protocol') is not None:
            self.protocol = m.get('Protocol')
        if m.get('ResponseCode') is not None:
            self.response_code = m.get('ResponseCode')
        if m.get('Result') is not None:
            self.result = m.get('Result')
        if m.get('SessionId') is not None:
            self.session_id = m.get('SessionId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Timeout') is not None:
            self.timeout = m.get('Timeout')
        return self


class IpBlockRecordDetailZoneLayer(TeaModel):
    def __init__(
        self,
        name: str = None,
        value: str = None,
    ):
        # 园区层级名称
        self.name = name
        # 园区层级值
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class IpBlockRecordDetail(TeaModel):
    def __init__(
        self,
        business_type_name: str = None,
        device_name: str = None,
        gateway: str = None,
        parent_ip_blocks: List[str] = None,
        zone_layer: List[IpBlockRecordDetailZoneLayer] = None,
    ):
        # 业务类型
        self.business_type_name = business_type_name
        # 设备名称
        self.device_name = device_name
        # 网关
        self.gateway = gateway
        # 父地址段列表
        self.parent_ip_blocks = parent_ip_blocks
        # 园区层级
        self.zone_layer = zone_layer

    def validate(self):
        if self.zone_layer:
            for k in self.zone_layer:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.business_type_name is not None:
            result['BusinessTypeName'] = self.business_type_name
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.gateway is not None:
            result['Gateway'] = self.gateway
        if self.parent_ip_blocks is not None:
            result['ParentIpBlocks'] = self.parent_ip_blocks
        result['ZoneLayer'] = []
        if self.zone_layer is not None:
            for k in self.zone_layer:
                result['ZoneLayer'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BusinessTypeName') is not None:
            self.business_type_name = m.get('BusinessTypeName')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('Gateway') is not None:
            self.gateway = m.get('Gateway')
        if m.get('ParentIpBlocks') is not None:
            self.parent_ip_blocks = m.get('ParentIpBlocks')
        self.zone_layer = []
        if m.get('ZoneLayer') is not None:
            for k in m.get('ZoneLayer'):
                temp_model = IpBlockRecordDetailZoneLayer()
                self.zone_layer.append(temp_model.from_map(k))
        return self


class IpBlockRecord(TeaModel):
    def __init__(
        self,
        ip_block_record_id: str = None,
        create_time: str = None,
        update_time: str = None,
        title: str = None,
        creator: int = None,
        work_no: str = None,
        net_type: str = None,
        status: str = None,
        zone_name: str = None,
        description: str = None,
        detail: List[IpBlockRecordDetail] = None,
        record_type: str = None,
        ip_block_code: List[str] = None,
    ):
        # 工单uuid
        self.ip_block_record_id = ip_block_record_id
        # 创建时间
        self.create_time = create_time
        # 更新时间
        self.update_time = update_time
        # 工单名称
        self.title = title
        # 创建人
        self.creator = creator
        # 工号
        self.work_no = work_no
        # 公网私网标志 PUBLIC PRIVATE
        self.net_type = net_type
        # 工单状态 running complete fail cancel lock approving
        self.status = status
        # 园区名称
        self.zone_name = zone_name
        # 工单备注
        self.description = description
        # 工单详情
        self.detail = detail
        # 工单类型 Apply 申请工单 Recycle 释放工单
        self.record_type = record_type
        # 要释放的IP段
        self.ip_block_code = ip_block_code

    def validate(self):
        if self.detail:
            for k in self.detail:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ip_block_record_id is not None:
            result['IpBlockRecordId'] = self.ip_block_record_id
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        if self.title is not None:
            result['Title'] = self.title
        if self.creator is not None:
            result['Creator'] = self.creator
        if self.work_no is not None:
            result['WorkNo'] = self.work_no
        if self.net_type is not None:
            result['NetType'] = self.net_type
        if self.status is not None:
            result['Status'] = self.status
        if self.zone_name is not None:
            result['ZoneName'] = self.zone_name
        if self.description is not None:
            result['Description'] = self.description
        result['Detail'] = []
        if self.detail is not None:
            for k in self.detail:
                result['Detail'].append(k.to_map() if k else None)
        if self.record_type is not None:
            result['RecordType'] = self.record_type
        if self.ip_block_code is not None:
            result['IpBlockCode'] = self.ip_block_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IpBlockRecordId') is not None:
            self.ip_block_record_id = m.get('IpBlockRecordId')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        if m.get('Creator') is not None:
            self.creator = m.get('Creator')
        if m.get('WorkNo') is not None:
            self.work_no = m.get('WorkNo')
        if m.get('NetType') is not None:
            self.net_type = m.get('NetType')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('ZoneName') is not None:
            self.zone_name = m.get('ZoneName')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        self.detail = []
        if m.get('Detail') is not None:
            for k in m.get('Detail'):
                temp_model = IpBlockRecordDetail()
                self.detail.append(temp_model.from_map(k))
        if m.get('RecordType') is not None:
            self.record_type = m.get('RecordType')
        if m.get('IpBlockCode') is not None:
            self.ip_block_code = m.get('IpBlockCode')
        return self


class IpRecordDetailZoneLayer(TeaModel):
    def __init__(
        self,
        name: str = None,
        value: str = None,
    ):
        # 园区层级名称
        self.name = name
        # 园区层级值
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class IpRecordDetail(TeaModel):
    def __init__(
        self,
        ip: str = None,
        device_name: str = None,
        port: str = None,
        remote_ip: str = None,
        remote_device_name: str = None,
        remote_port: str = None,
        device_mac: str = None,
        gateway: str = None,
        parent_ip_blocks: List[str] = None,
        zone_layer: List[IpRecordDetailZoneLayer] = None,
    ):
        # 申请到的Ip
        self.ip = ip
        # 设备名称
        self.device_name = device_name
        # 设备端口
        self.port = port
        # 对端IP
        self.remote_ip = remote_ip
        # 对端设备名称
        self.remote_device_name = remote_device_name
        # 对端设备端口
        self.remote_port = remote_port
        # 设备MAC
        self.device_mac = device_mac
        # 网关
        self.gateway = gateway
        # 父地址段列表
        self.parent_ip_blocks = parent_ip_blocks
        # 园区层级
        self.zone_layer = zone_layer

    def validate(self):
        if self.zone_layer:
            for k in self.zone_layer:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ip is not None:
            result['Ip'] = self.ip
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.port is not None:
            result['Port'] = self.port
        if self.remote_ip is not None:
            result['RemoteIp'] = self.remote_ip
        if self.remote_device_name is not None:
            result['RemoteDeviceName'] = self.remote_device_name
        if self.remote_port is not None:
            result['RemotePort'] = self.remote_port
        if self.device_mac is not None:
            result['DeviceMac'] = self.device_mac
        if self.gateway is not None:
            result['Gateway'] = self.gateway
        if self.parent_ip_blocks is not None:
            result['ParentIpBlocks'] = self.parent_ip_blocks
        result['ZoneLayer'] = []
        if self.zone_layer is not None:
            for k in self.zone_layer:
                result['ZoneLayer'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Ip') is not None:
            self.ip = m.get('Ip')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('RemoteIp') is not None:
            self.remote_ip = m.get('RemoteIp')
        if m.get('RemoteDeviceName') is not None:
            self.remote_device_name = m.get('RemoteDeviceName')
        if m.get('RemotePort') is not None:
            self.remote_port = m.get('RemotePort')
        if m.get('DeviceMac') is not None:
            self.device_mac = m.get('DeviceMac')
        if m.get('Gateway') is not None:
            self.gateway = m.get('Gateway')
        if m.get('ParentIpBlocks') is not None:
            self.parent_ip_blocks = m.get('ParentIpBlocks')
        self.zone_layer = []
        if m.get('ZoneLayer') is not None:
            for k in m.get('ZoneLayer'):
                temp_model = IpRecordDetailZoneLayer()
                self.zone_layer.append(temp_model.from_map(k))
        return self


class IpRecord(TeaModel):
    def __init__(
        self,
        create_time: str = None,
        ip_record_id: str = None,
        update_time: str = None,
        business_type_name: str = None,
        creator: str = None,
        status: str = None,
        zone_name: str = None,
        description: str = None,
        ip_block: str = None,
        detail: List[IpRecordDetail] = None,
        recode_type: str = None,
        ip_code: List[str] = None,
    ):
        # 创建时间
        self.create_time = create_time
        # 资源一级ID
        self.ip_record_id = ip_record_id
        # 更新时间
        self.update_time = update_time
        # 业务类型名称
        self.business_type_name = business_type_name
        # 创建人
        self.creator = creator
        # 工单状态 running complete fail
        self.status = status
        # 园区名
        self.zone_name = zone_name
        # 备注
        self.description = description
        # 地址段
        self.ip_block = ip_block
        # 工单详情
        self.detail = detail
        # 工单类型 Apply 申请工单 Recycle 释放工单
        self.recode_type = recode_type
        # IP地址列表
        self.ip_code = ip_code

    def validate(self):
        if self.detail:
            for k in self.detail:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.ip_record_id is not None:
            result['IpRecordId'] = self.ip_record_id
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        if self.business_type_name is not None:
            result['BusinessTypeName'] = self.business_type_name
        if self.creator is not None:
            result['Creator'] = self.creator
        if self.status is not None:
            result['Status'] = self.status
        if self.zone_name is not None:
            result['ZoneName'] = self.zone_name
        if self.description is not None:
            result['Description'] = self.description
        if self.ip_block is not None:
            result['IpBlock'] = self.ip_block
        result['Detail'] = []
        if self.detail is not None:
            for k in self.detail:
                result['Detail'].append(k.to_map() if k else None)
        if self.recode_type is not None:
            result['RecodeType'] = self.recode_type
        if self.ip_code is not None:
            result['IpCode'] = self.ip_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('IpRecordId') is not None:
            self.ip_record_id = m.get('IpRecordId')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        if m.get('BusinessTypeName') is not None:
            self.business_type_name = m.get('BusinessTypeName')
        if m.get('Creator') is not None:
            self.creator = m.get('Creator')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('ZoneName') is not None:
            self.zone_name = m.get('ZoneName')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('IpBlock') is not None:
            self.ip_block = m.get('IpBlock')
        self.detail = []
        if m.get('Detail') is not None:
            for k in m.get('Detail'):
                temp_model = IpRecordDetail()
                self.detail.append(temp_model.from_map(k))
        if m.get('RecodeType') is not None:
            self.recode_type = m.get('RecodeType')
        if m.get('IpCode') is not None:
            self.ip_code = m.get('IpCode')
        return self


class MonitorItem(TeaModel):
    def __init__(
        self,
        analysis_code: str = None,
        collection_type: str = None,
        config: str = None,
        monitor_item_description: str = None,
        enable: int = None,
        exec_interval: str = None,
        gmt_create: str = None,
        gmt_modified: str = None,
        monitor_item_name: str = None,
        security_domain: str = None,
        monitor_item_id: str = None,
    ):
        # 解析代码
        self.analysis_code = analysis_code
        # 采集类型
        self.collection_type = collection_type
        # 采集配置
        self.config = config
        # 描述
        self.monitor_item_description = monitor_item_description
        # 是否启用
        self.enable = enable
        # 采集间隔
        self.exec_interval = exec_interval
        # 创建时间
        self.gmt_create = gmt_create
        # 更新时间
        self.gmt_modified = gmt_modified
        # 监控项名称
        self.monitor_item_name = monitor_item_name
        # 安全域
        self.security_domain = security_domain
        # 监控项ID
        self.monitor_item_id = monitor_item_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.analysis_code is not None:
            result['AnalysisCode'] = self.analysis_code
        if self.collection_type is not None:
            result['CollectionType'] = self.collection_type
        if self.config is not None:
            result['Config'] = self.config
        if self.monitor_item_description is not None:
            result['MonitorItemDescription'] = self.monitor_item_description
        if self.enable is not None:
            result['Enable'] = self.enable
        if self.exec_interval is not None:
            result['ExecInterval'] = self.exec_interval
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.monitor_item_name is not None:
            result['MonitorItemName'] = self.monitor_item_name
        if self.security_domain is not None:
            result['SecurityDomain'] = self.security_domain
        if self.monitor_item_id is not None:
            result['MonitorItemId'] = self.monitor_item_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AnalysisCode') is not None:
            self.analysis_code = m.get('AnalysisCode')
        if m.get('CollectionType') is not None:
            self.collection_type = m.get('CollectionType')
        if m.get('Config') is not None:
            self.config = m.get('Config')
        if m.get('MonitorItemDescription') is not None:
            self.monitor_item_description = m.get('MonitorItemDescription')
        if m.get('Enable') is not None:
            self.enable = m.get('Enable')
        if m.get('ExecInterval') is not None:
            self.exec_interval = m.get('ExecInterval')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('MonitorItemName') is not None:
            self.monitor_item_name = m.get('MonitorItemName')
        if m.get('SecurityDomain') is not None:
            self.security_domain = m.get('SecurityDomain')
        if m.get('MonitorItemId') is not None:
            self.monitor_item_id = m.get('MonitorItemId')
        return self


class PhysicalSpace(TeaModel):
    def __init__(
        self,
        address: str = None,
        city: str = None,
        country: str = None,
        province: str = None,
        space_id: str = None,
        space_name: str = None,
    ):
        # 具体所在地址
        self.address = address
        # 所属城市
        self.city = city
        # 所属国家
        self.country = country
        # 所属省份
        self.province = province
        # 物理空间ID
        self.space_id = space_id
        # 物理空间名称
        self.space_name = space_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.address is not None:
            result['Address'] = self.address
        if self.city is not None:
            result['City'] = self.city
        if self.country is not None:
            result['Country'] = self.country
        if self.province is not None:
            result['Province'] = self.province
        if self.space_id is not None:
            result['SpaceId'] = self.space_id
        if self.space_name is not None:
            result['SpaceName'] = self.space_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Address') is not None:
            self.address = m.get('Address')
        if m.get('City') is not None:
            self.city = m.get('City')
        if m.get('Country') is not None:
            self.country = m.get('Country')
        if m.get('Province') is not None:
            self.province = m.get('Province')
        if m.get('SpaceId') is not None:
            self.space_id = m.get('SpaceId')
        if m.get('SpaceName') is not None:
            self.space_name = m.get('SpaceName')
        return self


class InspectionScriptInspectionAlarmRules(TeaModel):
    def __init__(
        self,
        alarm_expression: str = None,
        alarm_operator: str = None,
        alarm_value: str = None,
        alarm_level: str = None,
    ):
        # 告警表达式
        self.alarm_expression = alarm_expression
        # 告警符号
        self.alarm_operator = alarm_operator
        # 告警值
        self.alarm_value = alarm_value
        # 告警级别
        self.alarm_level = alarm_level

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alarm_expression is not None:
            result['AlarmExpression'] = self.alarm_expression
        if self.alarm_operator is not None:
            result['AlarmOperator'] = self.alarm_operator
        if self.alarm_value is not None:
            result['AlarmValue'] = self.alarm_value
        if self.alarm_level is not None:
            result['AlarmLevel'] = self.alarm_level
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AlarmExpression') is not None:
            self.alarm_expression = m.get('AlarmExpression')
        if m.get('AlarmOperator') is not None:
            self.alarm_operator = m.get('AlarmOperator')
        if m.get('AlarmValue') is not None:
            self.alarm_value = m.get('AlarmValue')
        if m.get('AlarmLevel') is not None:
            self.alarm_level = m.get('AlarmLevel')
        return self


class InspectionScript(TeaModel):
    def __init__(
        self,
        script_id: str = None,
        item_id: str = None,
        item_name: str = None,
        item_description: str = None,
        inspection_crontab: str = None,
        vendor: str = None,
        model: str = None,
        role: str = None,
        script_status: str = None,
        script: str = None,
        inspection_alarm_rules: List[InspectionScriptInspectionAlarmRules] = None,
    ):
        # 巡检模板ID
        self.script_id = script_id
        # 巡检项ID
        self.item_id = item_id
        # 巡检项名字
        self.item_name = item_name
        # 巡检项描述
        self.item_description = item_description
        # 巡检项定时表达式
        self.inspection_crontab = inspection_crontab
        # 厂商
        self.vendor = vendor
        # 型号
        self.model = model
        # 角色
        self.role = role
        # 模板状态
        self.script_status = script_status
        # 模板执行内容
        self.script = script
        # 巡检告警规则
        self.inspection_alarm_rules = inspection_alarm_rules

    def validate(self):
        if self.inspection_alarm_rules:
            for k in self.inspection_alarm_rules:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.script_id is not None:
            result['ScriptId'] = self.script_id
        if self.item_id is not None:
            result['ItemId'] = self.item_id
        if self.item_name is not None:
            result['ItemName'] = self.item_name
        if self.item_description is not None:
            result['ItemDescription'] = self.item_description
        if self.inspection_crontab is not None:
            result['InspectionCrontab'] = self.inspection_crontab
        if self.vendor is not None:
            result['Vendor'] = self.vendor
        if self.model is not None:
            result['Model'] = self.model
        if self.role is not None:
            result['Role'] = self.role
        if self.script_status is not None:
            result['ScriptStatus'] = self.script_status
        if self.script is not None:
            result['Script'] = self.script
        result['InspectionAlarmRules'] = []
        if self.inspection_alarm_rules is not None:
            for k in self.inspection_alarm_rules:
                result['InspectionAlarmRules'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ScriptId') is not None:
            self.script_id = m.get('ScriptId')
        if m.get('ItemId') is not None:
            self.item_id = m.get('ItemId')
        if m.get('ItemName') is not None:
            self.item_name = m.get('ItemName')
        if m.get('ItemDescription') is not None:
            self.item_description = m.get('ItemDescription')
        if m.get('InspectionCrontab') is not None:
            self.inspection_crontab = m.get('InspectionCrontab')
        if m.get('Vendor') is not None:
            self.vendor = m.get('Vendor')
        if m.get('Model') is not None:
            self.model = m.get('Model')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        if m.get('ScriptStatus') is not None:
            self.script_status = m.get('ScriptStatus')
        if m.get('Script') is not None:
            self.script = m.get('Script')
        self.inspection_alarm_rules = []
        if m.get('InspectionAlarmRules') is not None:
            for k in m.get('InspectionAlarmRules'):
                temp_model = InspectionScriptInspectionAlarmRules()
                self.inspection_alarm_rules.append(temp_model.from_map(k))
        return self


class SubscriptionItem(TeaModel):
    def __init__(
        self,
        alarm_status: str = None,
        notification_mode: str = None,
        suppression_strategy: str = None,
        notification_group_id: str = None,
        subscription_type: str = None,
        trigger_times: int = None,
        monitor_item_id: str = None,
        language: str = None,
        recovery_notice: int = None,
        subscription_item_id: str = None,
    ):
        # 告警状态
        self.alarm_status = alarm_status
        # 通知方式
        self.notification_mode = notification_mode
        # 抑制策略
        self.suppression_strategy = suppression_strategy
        # 通知组ID
        self.notification_group_id = notification_group_id
        # 订阅类型
        self.subscription_type = subscription_type
        # 连续触发次数
        self.trigger_times = trigger_times
        # 监控项ID
        self.monitor_item_id = monitor_item_id
        # 发送通知的语言
        self.language = language
        # 是否发送通知
        self.recovery_notice = recovery_notice
        # 订阅项ID
        self.subscription_item_id = subscription_item_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alarm_status is not None:
            result['AlarmStatus'] = self.alarm_status
        if self.notification_mode is not None:
            result['NotificationMode'] = self.notification_mode
        if self.suppression_strategy is not None:
            result['SuppressionStrategy'] = self.suppression_strategy
        if self.notification_group_id is not None:
            result['NotificationGroupId'] = self.notification_group_id
        if self.subscription_type is not None:
            result['SubscriptionType'] = self.subscription_type
        if self.trigger_times is not None:
            result['TriggerTimes'] = self.trigger_times
        if self.monitor_item_id is not None:
            result['MonitorItemId'] = self.monitor_item_id
        if self.language is not None:
            result['Language'] = self.language
        if self.recovery_notice is not None:
            result['RecoveryNotice'] = self.recovery_notice
        if self.subscription_item_id is not None:
            result['SubscriptionItemId'] = self.subscription_item_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AlarmStatus') is not None:
            self.alarm_status = m.get('AlarmStatus')
        if m.get('NotificationMode') is not None:
            self.notification_mode = m.get('NotificationMode')
        if m.get('SuppressionStrategy') is not None:
            self.suppression_strategy = m.get('SuppressionStrategy')
        if m.get('NotificationGroupId') is not None:
            self.notification_group_id = m.get('NotificationGroupId')
        if m.get('SubscriptionType') is not None:
            self.subscription_type = m.get('SubscriptionType')
        if m.get('TriggerTimes') is not None:
            self.trigger_times = m.get('TriggerTimes')
        if m.get('MonitorItemId') is not None:
            self.monitor_item_id = m.get('MonitorItemId')
        if m.get('Language') is not None:
            self.language = m.get('Language')
        if m.get('RecoveryNotice') is not None:
            self.recovery_notice = m.get('RecoveryNotice')
        if m.get('SubscriptionItemId') is not None:
            self.subscription_item_id = m.get('SubscriptionItemId')
        return self


class DataView(TeaModel):
    def __init__(
        self,
        gmt_create: str = None,
        gmt_modified: str = None,
        data_view_name: str = None,
        data_view_description: str = None,
        data_view_id: str = None,
        data_view_chart_list: List[DataViewChart] = None,
    ):
        # 创建时间
        self.gmt_create = gmt_create
        # 修改时间
        self.gmt_modified = gmt_modified
        # 数据视图名称
        self.data_view_name = data_view_name
        # 描述
        self.data_view_description = data_view_description
        # 聚合数据
        self.data_view_id = data_view_id
        # 图表列表
        self.data_view_chart_list = data_view_chart_list

    def validate(self):
        if self.data_view_chart_list:
            for k in self.data_view_chart_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.data_view_name is not None:
            result['DataViewName'] = self.data_view_name
        if self.data_view_description is not None:
            result['DataViewDescription'] = self.data_view_description
        if self.data_view_id is not None:
            result['DataViewId'] = self.data_view_id
        result['DataViewChartList'] = []
        if self.data_view_chart_list is not None:
            for k in self.data_view_chart_list:
                result['DataViewChartList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('DataViewName') is not None:
            self.data_view_name = m.get('DataViewName')
        if m.get('DataViewDescription') is not None:
            self.data_view_description = m.get('DataViewDescription')
        if m.get('DataViewId') is not None:
            self.data_view_id = m.get('DataViewId')
        self.data_view_chart_list = []
        if m.get('DataViewChartList') is not None:
            for k in m.get('DataViewChartList'):
                temp_model = DataViewChart()
                self.data_view_chart_list.append(temp_model.from_map(k))
        return self


class DeviceTask(TeaModel):
    def __init__(
        self,
        device_id: str = None,
        device_ip: str = None,
        device_name: str = None,
        device_task_id: str = None,
        gmt_create: str = None,
        gmt_modify: str = None,
        output: str = None,
        params: str = None,
        response_code: str = None,
        result: str = None,
        script_id: str = None,
        script_version: str = None,
        status: str = None,
        template_id: str = None,
        template_name: str = None,
    ):
        # 设备id
        self.device_id = device_id
        # 设备ip
        self.device_ip = device_ip
        # 设备名
        self.device_name = device_name
        # 设备任务id
        self.device_task_id = device_task_id
        # 创建时间
        self.gmt_create = gmt_create
        # 修改时间
        self.gmt_modify = gmt_modify
        # 设备任务回显
        self.output = output
        # 设备任务参数
        self.params = params
        # 设备任务错误码
        self.response_code = response_code
        # 设备任务返回
        self.result = result
        # 脚本id
        self.script_id = script_id
        # 版本id
        self.script_version = script_version
        # 设备任务状态
        self.status = status
        # 模板id
        self.template_id = template_id
        # 模板名称
        self.template_name = template_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.device_ip is not None:
            result['DeviceIp'] = self.device_ip
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.device_task_id is not None:
            result['DeviceTaskId'] = self.device_task_id
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modify is not None:
            result['GmtModify'] = self.gmt_modify
        if self.output is not None:
            result['Output'] = self.output
        if self.params is not None:
            result['Params'] = self.params
        if self.response_code is not None:
            result['ResponseCode'] = self.response_code
        if self.result is not None:
            result['Result'] = self.result
        if self.script_id is not None:
            result['ScriptId'] = self.script_id
        if self.script_version is not None:
            result['ScriptVersion'] = self.script_version
        if self.status is not None:
            result['Status'] = self.status
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        if self.template_name is not None:
            result['TemplateName'] = self.template_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('DeviceIp') is not None:
            self.device_ip = m.get('DeviceIp')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('DeviceTaskId') is not None:
            self.device_task_id = m.get('DeviceTaskId')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModify') is not None:
            self.gmt_modify = m.get('GmtModify')
        if m.get('Output') is not None:
            self.output = m.get('Output')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('ResponseCode') is not None:
            self.response_code = m.get('ResponseCode')
        if m.get('Result') is not None:
            self.result = m.get('Result')
        if m.get('ScriptId') is not None:
            self.script_id = m.get('ScriptId')
        if m.get('ScriptVersion') is not None:
            self.script_version = m.get('ScriptVersion')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        if m.get('TemplateName') is not None:
            self.template_name = m.get('TemplateName')
        return self


class PortCollection(TeaModel):
    def __init__(
        self,
        gmt_create: str = None,
        gmt_modified: str = None,
        port_collection_description: str = None,
        port_collection_id: str = None,
        port_collection_name: str = None,
        port_list: List[Port] = None,
    ):
        # 创建时间
        self.gmt_create = gmt_create
        # 修改时间
        self.gmt_modified = gmt_modified
        # 描述
        self.port_collection_description = port_collection_description
        # 端口集ID
        self.port_collection_id = port_collection_id
        # 端口集名称
        self.port_collection_name = port_collection_name
        # 端口列表
        self.port_list = port_list

    def validate(self):
        if self.port_list:
            for k in self.port_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.port_collection_description is not None:
            result['PortCollectionDescription'] = self.port_collection_description
        if self.port_collection_id is not None:
            result['PortCollectionId'] = self.port_collection_id
        if self.port_collection_name is not None:
            result['PortCollectionName'] = self.port_collection_name
        result['PortList'] = []
        if self.port_list is not None:
            for k in self.port_list:
                result['PortList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('PortCollectionDescription') is not None:
            self.port_collection_description = m.get('PortCollectionDescription')
        if m.get('PortCollectionId') is not None:
            self.port_collection_id = m.get('PortCollectionId')
        if m.get('PortCollectionName') is not None:
            self.port_collection_name = m.get('PortCollectionName')
        self.port_list = []
        if m.get('PortList') is not None:
            for k in m.get('PortList'):
                temp_model = Port()
                self.port_list.append(temp_model.from_map(k))
        return self


class ConnectionPolicy(TeaModel):
    def __init__(
        self,
        create_time: str = None,
        connection_policy_id: str = None,
        network_architecture_iteration_id: str = None,
        name: str = None,
        algorithm: str = None,
        link_count: int = None,
        uplink_model_id: str = None,
        downlink_module_id: str = None,
        uplink_device_id: str = None,
        downlink_device_id: str = None,
        id: str = None,
        update_time: str = None,
    ):
        # 创建时间
        self.create_time = create_time
        # 资源一级ID
        self.connection_policy_id = connection_policy_id
        # 架构迭代uid
        self.network_architecture_iteration_id = network_architecture_iteration_id
        # 连接策略名字
        self.name = name
        # 连接策略算法
        self.algorithm = algorithm
        # 连接数
        self.link_count = link_count
        # 上联模块uid
        self.uplink_model_id = uplink_model_id
        # 下联模块uid
        self.downlink_module_id = downlink_module_id
        # 上联设备uid
        self.uplink_device_id = uplink_device_id
        # 下联设备uid
        self.downlink_device_id = downlink_device_id
        # 连接策略uid
        self.id = id
        # 更新时间
        self.update_time = update_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.connection_policy_id is not None:
            result['ConnectionPolicyId'] = self.connection_policy_id
        if self.network_architecture_iteration_id is not None:
            result['NetworkArchitectureIterationId'] = self.network_architecture_iteration_id
        if self.name is not None:
            result['Name'] = self.name
        if self.algorithm is not None:
            result['Algorithm'] = self.algorithm
        if self.link_count is not None:
            result['LinkCount'] = self.link_count
        if self.uplink_model_id is not None:
            result['UplinkModelId'] = self.uplink_model_id
        if self.downlink_module_id is not None:
            result['DownlinkModuleId'] = self.downlink_module_id
        if self.uplink_device_id is not None:
            result['UplinkDeviceId'] = self.uplink_device_id
        if self.downlink_device_id is not None:
            result['DownlinkDeviceId'] = self.downlink_device_id
        if self.id is not None:
            result['Id'] = self.id
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('ConnectionPolicyId') is not None:
            self.connection_policy_id = m.get('ConnectionPolicyId')
        if m.get('NetworkArchitectureIterationId') is not None:
            self.network_architecture_iteration_id = m.get('NetworkArchitectureIterationId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Algorithm') is not None:
            self.algorithm = m.get('Algorithm')
        if m.get('LinkCount') is not None:
            self.link_count = m.get('LinkCount')
        if m.get('UplinkModelId') is not None:
            self.uplink_model_id = m.get('UplinkModelId')
        if m.get('DownlinkModuleId') is not None:
            self.downlink_module_id = m.get('DownlinkModuleId')
        if m.get('UplinkDeviceId') is not None:
            self.uplink_device_id = m.get('UplinkDeviceId')
        if m.get('DownlinkDeviceId') is not None:
            self.downlink_device_id = m.get('DownlinkDeviceId')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        return self


class CreateConfigurationSpecificationRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        client_token: str = None,
        specification_name: str = None,
        architecture: str = None,
        role: str = None,
        vendor: str = None,
        model: str = None,
        specification_content: str = None,
        related_variate: List[bytes] = None,
    ):
        # instanceId
        self.instance_id = instance_id
        # 幂等参数
        self.client_token = client_token
        # 配置规范名字
        self.specification_name = specification_name
        # 架构类型
        self.architecture = architecture
        # 角色
        self.role = role
        # 厂商
        self.vendor = vendor
        # 型号
        self.model = model
        # 配置规范内容
        self.specification_content = specification_content
        # 相关变量
        self.related_variate = related_variate

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.specification_name is not None:
            result['SpecificationName'] = self.specification_name
        if self.architecture is not None:
            result['Architecture'] = self.architecture
        if self.role is not None:
            result['Role'] = self.role
        if self.vendor is not None:
            result['Vendor'] = self.vendor
        if self.model is not None:
            result['Model'] = self.model
        if self.specification_content is not None:
            result['SpecificationContent'] = self.specification_content
        if self.related_variate is not None:
            result['RelatedVariate'] = self.related_variate
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('SpecificationName') is not None:
            self.specification_name = m.get('SpecificationName')
        if m.get('Architecture') is not None:
            self.architecture = m.get('Architecture')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        if m.get('Vendor') is not None:
            self.vendor = m.get('Vendor')
        if m.get('Model') is not None:
            self.model = m.get('Model')
        if m.get('SpecificationContent') is not None:
            self.specification_content = m.get('SpecificationContent')
        if m.get('RelatedVariate') is not None:
            self.related_variate = m.get('RelatedVariate')
        return self


class CreateConfigurationSpecificationShrinkRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        client_token: str = None,
        specification_name: str = None,
        architecture: str = None,
        role: str = None,
        vendor: str = None,
        model: str = None,
        specification_content: str = None,
        related_variate_shrink: str = None,
    ):
        # instanceId
        self.instance_id = instance_id
        # 幂等参数
        self.client_token = client_token
        # 配置规范名字
        self.specification_name = specification_name
        # 架构类型
        self.architecture = architecture
        # 角色
        self.role = role
        # 厂商
        self.vendor = vendor
        # 型号
        self.model = model
        # 配置规范内容
        self.specification_content = specification_content
        # 相关变量
        self.related_variate_shrink = related_variate_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.specification_name is not None:
            result['SpecificationName'] = self.specification_name
        if self.architecture is not None:
            result['Architecture'] = self.architecture
        if self.role is not None:
            result['Role'] = self.role
        if self.vendor is not None:
            result['Vendor'] = self.vendor
        if self.model is not None:
            result['Model'] = self.model
        if self.specification_content is not None:
            result['SpecificationContent'] = self.specification_content
        if self.related_variate_shrink is not None:
            result['RelatedVariate'] = self.related_variate_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('SpecificationName') is not None:
            self.specification_name = m.get('SpecificationName')
        if m.get('Architecture') is not None:
            self.architecture = m.get('Architecture')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        if m.get('Vendor') is not None:
            self.vendor = m.get('Vendor')
        if m.get('Model') is not None:
            self.model = m.get('Model')
        if m.get('SpecificationContent') is not None:
            self.specification_content = m.get('SpecificationContent')
        if m.get('RelatedVariate') is not None:
            self.related_variate_shrink = m.get('RelatedVariate')
        return self


class CreateConfigurationSpecificationResponseBody(TeaModel):
    def __init__(
        self,
        configuration_specification_id: str = None,
        request_id: str = None,
    ):
        # 资源uuid
        self.configuration_specification_id = configuration_specification_id
        # Id of the request
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.configuration_specification_id is not None:
            result['ConfigurationSpecificationId'] = self.configuration_specification_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConfigurationSpecificationId') is not None:
            self.configuration_specification_id = m.get('ConfigurationSpecificationId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateConfigurationSpecificationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateConfigurationSpecificationResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateConfigurationSpecificationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateIpBlockRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        ip_block_id: str = None,
        block: str = None,
        mask: str = None,
        parent_id: str = None,
        net_type: str = None,
        category: str = None,
        status: str = None,
        business_type_id: str = None,
        device_name: str = None,
        zone_name: str = None,
        backup_device_name: str = None,
        net_business: str = None,
        ownership: str = None,
        application: str = None,
        description: str = None,
        reserve_parent_block: str = None,
        client_token: str = None,
    ):
        # 实例ID
        self.instance_id = instance_id
        # 资源一级ID
        self.ip_block_id = ip_block_id
        # IP段地址
        self.block = block
        # IP段掩码
        self.mask = mask
        # 父地址段UID
        self.parent_id = parent_id
        # 公网私网标志 PUBLIC PRIVATE
        self.net_type = net_type
        # 地址类别 IPV4
        self.category = category
        # 地址状态
        self.status = status
        # 业务类型UID
        self.business_type_id = business_type_id
        # 设备名称
        self.device_name = device_name
        # 园区名称
        self.zone_name = zone_name
        # 备份设备名称
        self.backup_device_name = backup_device_name
        # 公网地址类型 INC GUEST VIP
        self.net_business = net_business
        # IP归属
        self.ownership = ownership
        # IP用途
        self.application = application
        # 备注
        self.description = description
        # 是否保留父段 true 是 false 否
        self.reserve_parent_block = reserve_parent_block
        # 幂等参数
        self.client_token = client_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.ip_block_id is not None:
            result['IpBlockId'] = self.ip_block_id
        if self.block is not None:
            result['Block'] = self.block
        if self.mask is not None:
            result['Mask'] = self.mask
        if self.parent_id is not None:
            result['ParentId'] = self.parent_id
        if self.net_type is not None:
            result['NetType'] = self.net_type
        if self.category is not None:
            result['Category'] = self.category
        if self.status is not None:
            result['Status'] = self.status
        if self.business_type_id is not None:
            result['BusinessTypeId'] = self.business_type_id
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.zone_name is not None:
            result['ZoneName'] = self.zone_name
        if self.backup_device_name is not None:
            result['BackupDeviceName'] = self.backup_device_name
        if self.net_business is not None:
            result['NetBusiness'] = self.net_business
        if self.ownership is not None:
            result['Ownership'] = self.ownership
        if self.application is not None:
            result['Application'] = self.application
        if self.description is not None:
            result['Description'] = self.description
        if self.reserve_parent_block is not None:
            result['ReserveParentBlock'] = self.reserve_parent_block
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IpBlockId') is not None:
            self.ip_block_id = m.get('IpBlockId')
        if m.get('Block') is not None:
            self.block = m.get('Block')
        if m.get('Mask') is not None:
            self.mask = m.get('Mask')
        if m.get('ParentId') is not None:
            self.parent_id = m.get('ParentId')
        if m.get('NetType') is not None:
            self.net_type = m.get('NetType')
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('BusinessTypeId') is not None:
            self.business_type_id = m.get('BusinessTypeId')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('ZoneName') is not None:
            self.zone_name = m.get('ZoneName')
        if m.get('BackupDeviceName') is not None:
            self.backup_device_name = m.get('BackupDeviceName')
        if m.get('NetBusiness') is not None:
            self.net_business = m.get('NetBusiness')
        if m.get('Ownership') is not None:
            self.ownership = m.get('Ownership')
        if m.get('Application') is not None:
            self.application = m.get('Application')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ReserveParentBlock') is not None:
            self.reserve_parent_block = m.get('ReserveParentBlock')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        return self


class CreateIpBlockResponseBody(TeaModel):
    def __init__(
        self,
        ip_block_id: str = None,
        request_id: str = None,
    ):
        # 资源实例ID，如ECS实例的创建接口CreateInstance应返回InstanceId。
        self.ip_block_id = ip_block_id
        # Id of the request
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ip_block_id is not None:
            result['IpBlockId'] = self.ip_block_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IpBlockId') is not None:
            self.ip_block_id = m.get('IpBlockId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateIpBlockResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateIpBlockResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateIpBlockResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class UpdateConfigurationVariateRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        configuration_variate_id: str = None,
        variate_name: str = None,
        comment: str = None,
        format_function: str = None,
    ):
        # instanceId
        self.instance_id = instance_id
        # 资源一级ID
        self.configuration_variate_id = configuration_variate_id
        # 变量名字
        self.variate_name = variate_name
        # 描述变量
        self.comment = comment
        # python转换函数
        self.format_function = format_function

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.configuration_variate_id is not None:
            result['ConfigurationVariateId'] = self.configuration_variate_id
        if self.variate_name is not None:
            result['VariateName'] = self.variate_name
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.format_function is not None:
            result['FormatFunction'] = self.format_function
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ConfigurationVariateId') is not None:
            self.configuration_variate_id = m.get('ConfigurationVariateId')
        if m.get('VariateName') is not None:
            self.variate_name = m.get('VariateName')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('FormatFunction') is not None:
            self.format_function = m.get('FormatFunction')
        return self


class UpdateConfigurationVariateResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # Id of the request
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class UpdateConfigurationVariateResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: UpdateConfigurationVariateResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = UpdateConfigurationVariateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetScheduleTypeRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        schedule_type_id: str = None,
    ):
        # instanceId
        self.instance_id = instance_id
        # 实例 ID。
        self.schedule_type_id = schedule_type_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.schedule_type_id is not None:
            result['ScheduleTypeId'] = self.schedule_type_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ScheduleTypeId') is not None:
            self.schedule_type_id = m.get('ScheduleTypeId')
        return self


class GetScheduleTypeResponseBodyScheduleType(TeaModel):
    def __init__(
        self,
        status: str = None,
        schedule_type_id: str = None,
        create_time: str = None,
        update_time: str = None,
        schedule_type: str = None,
        related_worker: List[str] = None,
    ):
        # 值班类型状态
        self.status = status
        # 资源一级ID
        self.schedule_type_id = schedule_type_id
        # 创建时间
        self.create_time = create_time
        # 更新时间
        self.update_time = update_time
        # 值班类型value
        self.schedule_type = schedule_type
        # relatedWorker
        self.related_worker = related_worker

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.schedule_type_id is not None:
            result['ScheduleTypeId'] = self.schedule_type_id
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        if self.schedule_type is not None:
            result['ScheduleType'] = self.schedule_type
        if self.related_worker is not None:
            result['RelatedWorker'] = self.related_worker
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('ScheduleTypeId') is not None:
            self.schedule_type_id = m.get('ScheduleTypeId')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        if m.get('ScheduleType') is not None:
            self.schedule_type = m.get('ScheduleType')
        if m.get('RelatedWorker') is not None:
            self.related_worker = m.get('RelatedWorker')
        return self


class GetScheduleTypeResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        schedule_type: GetScheduleTypeResponseBodyScheduleType = None,
    ):
        # Id of the request
        self.request_id = request_id
        # 值班类型对象
        self.schedule_type = schedule_type

    def validate(self):
        if self.schedule_type:
            self.schedule_type.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.schedule_type is not None:
            result['ScheduleType'] = self.schedule_type.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ScheduleType') is not None:
            temp_model = GetScheduleTypeResponseBodyScheduleType()
            self.schedule_type = temp_model.from_map(m['ScheduleType'])
        return self


class GetScheduleTypeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetScheduleTypeResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetScheduleTypeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDeviceRequest(TeaModel):
    def __init__(
        self,
        device_id: str = None,
        instance_id: str = None,
    ):
        # 实例 ID。
        self.device_id = device_id
        # 实例ID
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class DeleteDeviceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # Id of the request
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteDeviceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteDeviceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteDeviceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListDeviceValuesRequest(TeaModel):
    def __init__(
        self,
        device_form_id: str = None,
        device_form_name: str = None,
        attribute_keyword: str = None,
        attribute_group: str = None,
        instance_id: str = None,
    ):
        # 设备形态ID
        self.device_form_id = device_form_id
        # 设备形态名称
        self.device_form_name = device_form_name
        # 查询属性主键
        self.attribute_keyword = attribute_keyword
        # 查询属性对应JSON中主键
        self.attribute_group = attribute_group
        # 实例ID
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_form_id is not None:
            result['DeviceFormId'] = self.device_form_id
        if self.device_form_name is not None:
            result['DeviceFormName'] = self.device_form_name
        if self.attribute_keyword is not None:
            result['AttributeKeyword'] = self.attribute_keyword
        if self.attribute_group is not None:
            result['AttributeGroup'] = self.attribute_group
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeviceFormId') is not None:
            self.device_form_id = m.get('DeviceFormId')
        if m.get('DeviceFormName') is not None:
            self.device_form_name = m.get('DeviceFormName')
        if m.get('AttributeKeyword') is not None:
            self.attribute_keyword = m.get('AttributeKeyword')
        if m.get('AttributeGroup') is not None:
            self.attribute_group = m.get('AttributeGroup')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class ListDeviceValuesResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        device_values: List[str] = None,
    ):
        # Id of the request
        self.request_id = request_id
        # 数组，返回示例目录。
        self.device_values = device_values

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.device_values is not None:
            result['DeviceValues'] = self.device_values
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('DeviceValues') is not None:
            self.device_values = m.get('DeviceValues')
        return self


class ListDeviceValuesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListDeviceValuesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListDeviceValuesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetIpBlockRecordRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        ip_block_record_id: str = None,
    ):
        self.instance_id = instance_id
        # 实例 ID。
        self.ip_block_record_id = ip_block_record_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.ip_block_record_id is not None:
            result['IpBlockRecordId'] = self.ip_block_record_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IpBlockRecordId') is not None:
            self.ip_block_record_id = m.get('IpBlockRecordId')
        return self


class GetIpBlockRecordResponseBodyIpBlockRecordDetailZoneLayer(TeaModel):
    def __init__(
        self,
        name: str = None,
        value: str = None,
    ):
        # 园区层级名称
        self.name = name
        # 园区层级值
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class GetIpBlockRecordResponseBodyIpBlockRecordDetail(TeaModel):
    def __init__(
        self,
        business_type_name: str = None,
        device_name: str = None,
        gateway: str = None,
        parent_ip_blocks: List[str] = None,
        zone_layer: List[GetIpBlockRecordResponseBodyIpBlockRecordDetailZoneLayer] = None,
        ip_block_code: str = None,
    ):
        # 业务类型
        self.business_type_name = business_type_name
        # 设备名称
        self.device_name = device_name
        # 网关
        self.gateway = gateway
        # 父地址段列表
        self.parent_ip_blocks = parent_ip_blocks
        # 园区层级
        self.zone_layer = zone_layer
        # 地址段
        self.ip_block_code = ip_block_code

    def validate(self):
        if self.zone_layer:
            for k in self.zone_layer:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.business_type_name is not None:
            result['BusinessTypeName'] = self.business_type_name
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.gateway is not None:
            result['Gateway'] = self.gateway
        if self.parent_ip_blocks is not None:
            result['ParentIpBlocks'] = self.parent_ip_blocks
        result['ZoneLayer'] = []
        if self.zone_layer is not None:
            for k in self.zone_layer:
                result['ZoneLayer'].append(k.to_map() if k else None)
        if self.ip_block_code is not None:
            result['IpBlockCode'] = self.ip_block_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BusinessTypeName') is not None:
            self.business_type_name = m.get('BusinessTypeName')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('Gateway') is not None:
            self.gateway = m.get('Gateway')
        if m.get('ParentIpBlocks') is not None:
            self.parent_ip_blocks = m.get('ParentIpBlocks')
        self.zone_layer = []
        if m.get('ZoneLayer') is not None:
            for k in m.get('ZoneLayer'):
                temp_model = GetIpBlockRecordResponseBodyIpBlockRecordDetailZoneLayer()
                self.zone_layer.append(temp_model.from_map(k))
        if m.get('IpBlockCode') is not None:
            self.ip_block_code = m.get('IpBlockCode')
        return self


class GetIpBlockRecordResponseBodyIpBlockRecord(TeaModel):
    def __init__(
        self,
        ip_block_record_id: str = None,
        create_time: str = None,
        update_time: str = None,
        title: str = None,
        creator: int = None,
        work_no: str = None,
        net_type: str = None,
        status: str = None,
        zone_name: str = None,
        description: str = None,
        detail: List[GetIpBlockRecordResponseBodyIpBlockRecordDetail] = None,
        record_type: str = None,
        ip_block_code: List[str] = None,
    ):
        # 工单uuid
        self.ip_block_record_id = ip_block_record_id
        # 创建时间
        self.create_time = create_time
        # 2020-12-22 10:39:17
        self.update_time = update_time
        # 工单名称
        self.title = title
        # 创建人
        self.creator = creator
        # 工号
        self.work_no = work_no
        # 公网私网标志 PUBLIC PRIVATE
        self.net_type = net_type
        # 工单状态 running complete fail cancel lock approving
        self.status = status
        # 园区名称
        self.zone_name = zone_name
        # 工单备注
        self.description = description
        # 工单详情
        self.detail = detail
        # 工单类型 Apply 申请工单 Recycle 释放工单
        self.record_type = record_type
        # 要释放的IP段
        self.ip_block_code = ip_block_code

    def validate(self):
        if self.detail:
            for k in self.detail:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ip_block_record_id is not None:
            result['IpBlockRecordId'] = self.ip_block_record_id
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        if self.title is not None:
            result['Title'] = self.title
        if self.creator is not None:
            result['Creator'] = self.creator
        if self.work_no is not None:
            result['WorkNo'] = self.work_no
        if self.net_type is not None:
            result['NetType'] = self.net_type
        if self.status is not None:
            result['Status'] = self.status
        if self.zone_name is not None:
            result['ZoneName'] = self.zone_name
        if self.description is not None:
            result['Description'] = self.description
        result['Detail'] = []
        if self.detail is not None:
            for k in self.detail:
                result['Detail'].append(k.to_map() if k else None)
        if self.record_type is not None:
            result['RecordType'] = self.record_type
        if self.ip_block_code is not None:
            result['IpBlockCode'] = self.ip_block_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IpBlockRecordId') is not None:
            self.ip_block_record_id = m.get('IpBlockRecordId')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        if m.get('Creator') is not None:
            self.creator = m.get('Creator')
        if m.get('WorkNo') is not None:
            self.work_no = m.get('WorkNo')
        if m.get('NetType') is not None:
            self.net_type = m.get('NetType')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('ZoneName') is not None:
            self.zone_name = m.get('ZoneName')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        self.detail = []
        if m.get('Detail') is not None:
            for k in m.get('Detail'):
                temp_model = GetIpBlockRecordResponseBodyIpBlockRecordDetail()
                self.detail.append(temp_model.from_map(k))
        if m.get('RecordType') is not None:
            self.record_type = m.get('RecordType')
        if m.get('IpBlockCode') is not None:
            self.ip_block_code = m.get('IpBlockCode')
        return self


class GetIpBlockRecordResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        ip_block_record: GetIpBlockRecordResponseBodyIpBlockRecord = None,
    ):
        # Id of the request
        self.request_id = request_id
        # 工单类型对象
        self.ip_block_record = ip_block_record

    def validate(self):
        if self.ip_block_record:
            self.ip_block_record.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.ip_block_record is not None:
            result['IpBlockRecord'] = self.ip_block_record.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('IpBlockRecord') is not None:
            temp_model = GetIpBlockRecordResponseBodyIpBlockRecord()
            self.ip_block_record = temp_model.from_map(m['IpBlockRecord'])
        return self


class GetIpBlockRecordResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetIpBlockRecordResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetIpBlockRecordResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListSpaceModelsRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        max_results: int = None,
        next_token: str = None,
        space_type: str = None,
        status: str = None,
    ):
        # instanceId
        self.instance_id = instance_id
        # 返回结果的最大个数。
        self.max_results = max_results
        # 当总结果个数大于MaxResults时，用于翻页的token。
        self.next_token = next_token
        # 物理空间类型
        self.space_type = space_type
        # 物理空间状态
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.space_type is not None:
            result['SpaceType'] = self.space_type
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('SpaceType') is not None:
            self.space_type = m.get('SpaceType')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class ListSpaceModelsResponseBodySpaceModelSort(TeaModel):
    def __init__(
        self,
        level_name: str = None,
        level: int = None,
    ):
        # 层级名称
        self.level_name = level_name
        # 层级
        self.level = level

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.level_name is not None:
            result['LevelName'] = self.level_name
        if self.level is not None:
            result['Level'] = self.level
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('LevelName') is not None:
            self.level_name = m.get('LevelName')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        return self


class ListSpaceModelsResponseBodySpaceModel(TeaModel):
    def __init__(
        self,
        space_type: str = None,
        sort: List[ListSpaceModelsResponseBodySpaceModelSort] = None,
        create_time: str = None,
        space_model_id: str = None,
        status: str = None,
        update_time: str = None,
    ):
        # 物理空间类型
        self.space_type = space_type
        # 层级
        self.sort = sort
        # 创建时间
        self.create_time = create_time
        # 资源一级ID
        self.space_model_id = space_model_id
        # 模型状态
        self.status = status
        # 更新时间
        self.update_time = update_time

    def validate(self):
        if self.sort:
            for k in self.sort:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.space_type is not None:
            result['SpaceType'] = self.space_type
        result['Sort'] = []
        if self.sort is not None:
            for k in self.sort:
                result['Sort'].append(k.to_map() if k else None)
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.space_model_id is not None:
            result['SpaceModelId'] = self.space_model_id
        if self.status is not None:
            result['Status'] = self.status
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SpaceType') is not None:
            self.space_type = m.get('SpaceType')
        self.sort = []
        if m.get('Sort') is not None:
            for k in m.get('Sort'):
                temp_model = ListSpaceModelsResponseBodySpaceModelSort()
                self.sort.append(temp_model.from_map(k))
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('SpaceModelId') is not None:
            self.space_model_id = m.get('SpaceModelId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        return self


class ListSpaceModelsResponseBody(TeaModel):
    def __init__(
        self,
        total_count: int = None,
        request_id: str = None,
        next_token: str = None,
        max_results: int = None,
        space_model: List[ListSpaceModelsResponseBodySpaceModel] = None,
    ):
        # 总记录数。
        self.total_count = total_count
        # Id of the request
        self.request_id = request_id
        # 当总结果个数大于MaxResults时，用于翻页的token。
        self.next_token = next_token
        # 本次读取的最大数据量
        self.max_results = max_results
        # 数组，返回示例目录。
        self.space_model = space_model

    def validate(self):
        if self.space_model:
            for k in self.space_model:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        result['SpaceModel'] = []
        if self.space_model is not None:
            for k in self.space_model:
                result['SpaceModel'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        self.space_model = []
        if m.get('SpaceModel') is not None:
            for k in m.get('SpaceModel'):
                temp_model = ListSpaceModelsResponseBodySpaceModel()
                self.space_model.append(temp_model.from_map(k))
        return self


class ListSpaceModelsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListSpaceModelsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListSpaceModelsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListDevicePropertiesRequest(TeaModel):
    def __init__(
        self,
        max_results: int = None,
        next_token: str = None,
        device_form_id: str = None,
        instance_id: str = None,
    ):
        # 返回结果的最大个数。
        self.max_results = max_results
        # 当总结果个数大于MaxResults时，用于翻页的token。
        self.next_token = next_token
        # 设备形态ID
        self.device_form_id = device_form_id
        # 实例ID
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.device_form_id is not None:
            result['DeviceFormId'] = self.device_form_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('DeviceFormId') is not None:
            self.device_form_id = m.get('DeviceFormId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class ListDevicePropertiesResponseBodyDeviceProperties(TeaModel):
    def __init__(
        self,
        device_property_id: str = None,
        device_form_id: str = None,
        device_form_name: str = None,
        property_name: str = None,
        property_key: str = None,
        property_format: str = None,
        property_content: str = None,
        built_in: bool = None,
    ):
        # 设备属性ID
        self.device_property_id = device_property_id
        # 设备形态ID
        self.device_form_id = device_form_id
        # 设备形态名称
        self.device_form_name = device_form_name
        # 属性名称
        self.property_name = property_name
        # 属性主键
        self.property_key = property_key
        # 属性格式
        self.property_format = property_format
        # 属性内容
        self.property_content = property_content
        # 是否内置属性
        self.built_in = built_in

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_property_id is not None:
            result['DevicePropertyId'] = self.device_property_id
        if self.device_form_id is not None:
            result['DeviceFormId'] = self.device_form_id
        if self.device_form_name is not None:
            result['DeviceFormName'] = self.device_form_name
        if self.property_name is not None:
            result['PropertyName'] = self.property_name
        if self.property_key is not None:
            result['PropertyKey'] = self.property_key
        if self.property_format is not None:
            result['PropertyFormat'] = self.property_format
        if self.property_content is not None:
            result['PropertyContent'] = self.property_content
        if self.built_in is not None:
            result['BuiltIn'] = self.built_in
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DevicePropertyId') is not None:
            self.device_property_id = m.get('DevicePropertyId')
        if m.get('DeviceFormId') is not None:
            self.device_form_id = m.get('DeviceFormId')
        if m.get('DeviceFormName') is not None:
            self.device_form_name = m.get('DeviceFormName')
        if m.get('PropertyName') is not None:
            self.property_name = m.get('PropertyName')
        if m.get('PropertyKey') is not None:
            self.property_key = m.get('PropertyKey')
        if m.get('PropertyFormat') is not None:
            self.property_format = m.get('PropertyFormat')
        if m.get('PropertyContent') is not None:
            self.property_content = m.get('PropertyContent')
        if m.get('BuiltIn') is not None:
            self.built_in = m.get('BuiltIn')
        return self


class ListDevicePropertiesResponseBody(TeaModel):
    def __init__(
        self,
        device_properties: List[ListDevicePropertiesResponseBodyDeviceProperties] = None,
        next_token: int = None,
        request_id: str = None,
        total_count: int = None,
        max_results: int = None,
    ):
        # 数组，返回示例目录。
        self.device_properties = device_properties
        # 当总结果个数大于MaxResults时，用于翻页的token。
        self.next_token = next_token
        # Id of the request
        self.request_id = request_id
        # 总记录数。
        self.total_count = total_count
        # 每页数量。
        self.max_results = max_results

    def validate(self):
        if self.device_properties:
            for k in self.device_properties:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DeviceProperties'] = []
        if self.device_properties is not None:
            for k in self.device_properties:
                result['DeviceProperties'].append(k.to_map() if k else None)
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.device_properties = []
        if m.get('DeviceProperties') is not None:
            for k in m.get('DeviceProperties'):
                temp_model = ListDevicePropertiesResponseBodyDeviceProperties()
                self.device_properties.append(temp_model.from_map(k))
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        return self


class ListDevicePropertiesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListDevicePropertiesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListDevicePropertiesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListInspectionDevicesRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        role: str = None,
        vendor: str = None,
        model: List[str] = None,
    ):
        # 实例id
        self.instance_id = instance_id
        # 角色
        self.role = role
        # 厂商
        self.vendor = vendor
        # 型号
        self.model = model

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.role is not None:
            result['Role'] = self.role
        if self.vendor is not None:
            result['Vendor'] = self.vendor
        if self.model is not None:
            result['Model'] = self.model
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        if m.get('Vendor') is not None:
            self.vendor = m.get('Vendor')
        if m.get('Model') is not None:
            self.model = m.get('Model')
        return self


class ListInspectionDevicesShrinkRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        role: str = None,
        vendor: str = None,
        model_shrink: str = None,
    ):
        # 实例id
        self.instance_id = instance_id
        # 角色
        self.role = role
        # 厂商
        self.vendor = vendor
        # 型号
        self.model_shrink = model_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.role is not None:
            result['Role'] = self.role
        if self.vendor is not None:
            result['Vendor'] = self.vendor
        if self.model_shrink is not None:
            result['Model'] = self.model_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        if m.get('Vendor') is not None:
            self.vendor = m.get('Vendor')
        if m.get('Model') is not None:
            self.model_shrink = m.get('Model')
        return self


class ListInspectionDevicesResponseBodyInspectionScripts(TeaModel):
    def __init__(
        self,
        role: str = None,
        vendor: str = None,
        model: str = None,
        host_name: str = None,
        manage_ip: str = None,
        device_state: str = None,
        space: str = None,
        device_id: str = None,
    ):
        # 角色
        self.role = role
        # 厂商
        self.vendor = vendor
        # 型号
        self.model = model
        # 主机名
        self.host_name = host_name
        # 管理ip
        self.manage_ip = manage_ip
        # 设备状态
        self.device_state = device_state
        # 物理空间
        self.space = space
        # 设备id
        self.device_id = device_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.role is not None:
            result['Role'] = self.role
        if self.vendor is not None:
            result['Vendor'] = self.vendor
        if self.model is not None:
            result['Model'] = self.model
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.manage_ip is not None:
            result['ManageIp'] = self.manage_ip
        if self.device_state is not None:
            result['DeviceState'] = self.device_state
        if self.space is not None:
            result['Space'] = self.space
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Role') is not None:
            self.role = m.get('Role')
        if m.get('Vendor') is not None:
            self.vendor = m.get('Vendor')
        if m.get('Model') is not None:
            self.model = m.get('Model')
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('ManageIp') is not None:
            self.manage_ip = m.get('ManageIp')
        if m.get('DeviceState') is not None:
            self.device_state = m.get('DeviceState')
        if m.get('Space') is not None:
            self.space = m.get('Space')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        return self


class ListInspectionDevicesResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        inspection_scripts: List[ListInspectionDevicesResponseBodyInspectionScripts] = None,
    ):
        # Id of the request
        self.request_id = request_id
        # content
        self.inspection_scripts = inspection_scripts

    def validate(self):
        if self.inspection_scripts:
            for k in self.inspection_scripts:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['InspectionScripts'] = []
        if self.inspection_scripts is not None:
            for k in self.inspection_scripts:
                result['InspectionScripts'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.inspection_scripts = []
        if m.get('InspectionScripts') is not None:
            for k in m.get('InspectionScripts'):
                temp_model = ListInspectionDevicesResponseBodyInspectionScripts()
                self.inspection_scripts.append(temp_model.from_map(k))
        return self


class ListInspectionDevicesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListInspectionDevicesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListInspectionDevicesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListInspectionTasksRequest(TeaModel):
    def __init__(
        self,
        max_results: int = None,
        next_token: str = None,
        item_id: str = None,
        host_name: str = None,
        ip: str = None,
        task_status: str = None,
        instance_id: str = None,
        space: str = None,
        role: str = None,
        vendor: str = None,
        model: str = None,
    ):
        # 返回结果的最大个数。
        self.max_results = max_results
        # 当总结果个数大于MaxResults时，用于翻页的token。
        self.next_token = next_token
        # 巡检项ID
        self.item_id = item_id
        # 主机名
        self.host_name = host_name
        # 设备IP
        self.ip = ip
        # 巡检状态
        self.task_status = task_status
        # 实例ID
        self.instance_id = instance_id
        # 物理空间
        self.space = space
        # 角色
        self.role = role
        # 厂商
        self.vendor = vendor
        # 型号
        self.model = model

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.item_id is not None:
            result['ItemId'] = self.item_id
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.ip is not None:
            result['IP'] = self.ip
        if self.task_status is not None:
            result['TaskStatus'] = self.task_status
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.space is not None:
            result['Space'] = self.space
        if self.role is not None:
            result['Role'] = self.role
        if self.vendor is not None:
            result['Vendor'] = self.vendor
        if self.model is not None:
            result['Model'] = self.model
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('ItemId') is not None:
            self.item_id = m.get('ItemId')
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('IP') is not None:
            self.ip = m.get('IP')
        if m.get('TaskStatus') is not None:
            self.task_status = m.get('TaskStatus')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Space') is not None:
            self.space = m.get('Space')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        if m.get('Vendor') is not None:
            self.vendor = m.get('Vendor')
        if m.get('Model') is not None:
            self.model = m.get('Model')
        return self


class ListInspectionTasksResponseBodyInspectionTasksInspectionAlarmRules(TeaModel):
    def __init__(
        self,
        alarm_expression: str = None,
        alarm_operator: str = None,
        alarm_value: str = None,
        actual_value: str = None,
        alarm_level: str = None,
    ):
        # 告警符号
        self.alarm_expression = alarm_expression
        # 告警变量
        self.alarm_operator = alarm_operator
        # 告警值
        self.alarm_value = alarm_value
        # 告警实际值
        self.actual_value = actual_value
        # 告警级别
        self.alarm_level = alarm_level

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alarm_expression is not None:
            result['AlarmExpression'] = self.alarm_expression
        if self.alarm_operator is not None:
            result['AlarmOperator'] = self.alarm_operator
        if self.alarm_value is not None:
            result['AlarmValue'] = self.alarm_value
        if self.actual_value is not None:
            result['ActualValue'] = self.actual_value
        if self.alarm_level is not None:
            result['AlarmLevel'] = self.alarm_level
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AlarmExpression') is not None:
            self.alarm_expression = m.get('AlarmExpression')
        if m.get('AlarmOperator') is not None:
            self.alarm_operator = m.get('AlarmOperator')
        if m.get('AlarmValue') is not None:
            self.alarm_value = m.get('AlarmValue')
        if m.get('ActualValue') is not None:
            self.actual_value = m.get('ActualValue')
        if m.get('AlarmLevel') is not None:
            self.alarm_level = m.get('AlarmLevel')
        return self


class ListInspectionTasksResponseBodyInspectionTasks(TeaModel):
    def __init__(
        self,
        device_id: str = None,
        item_id: str = None,
        execution_end_time: str = None,
        execution_begin_time: str = None,
        item_name: str = None,
        script_id: str = None,
        space: str = None,
        inspection_result: str = None,
        inspection_alarm_rules: List[ListInspectionTasksResponseBodyInspectionTasksInspectionAlarmRules] = None,
        ip: str = None,
        host_name: str = None,
        vendor: str = None,
        task_status: str = None,
        model: List[str] = None,
        error_code: str = None,
        inspection_message: str = None,
        task_id: str = None,
        device_display: str = None,
        role: str = None,
    ):
        # 设备ID
        self.device_id = device_id
        # 巡检项ID
        self.item_id = item_id
        # 巡检结束时间
        self.execution_end_time = execution_end_time
        # 巡检开始时间
        self.execution_begin_time = execution_begin_time
        # 巡检项名字
        self.item_name = item_name
        # 模板ID
        self.script_id = script_id
        # 物理空间
        self.space = space
        # 巡检结果
        self.inspection_result = inspection_result
        # 告警规则
        self.inspection_alarm_rules = inspection_alarm_rules
        # IP地址
        self.ip = ip
        # 主机名
        self.host_name = host_name
        # 厂商
        self.vendor = vendor
        # 任务状态
        self.task_status = task_status
        # 型号
        self.model = model
        # 错误码
        self.error_code = error_code
        # 巡检信息
        self.inspection_message = inspection_message
        # 任务ID
        self.task_id = task_id
        # 设备回显
        self.device_display = device_display
        # 角色
        self.role = role

    def validate(self):
        if self.inspection_alarm_rules:
            for k in self.inspection_alarm_rules:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.item_id is not None:
            result['ItemId'] = self.item_id
        if self.execution_end_time is not None:
            result['ExecutionEndTime'] = self.execution_end_time
        if self.execution_begin_time is not None:
            result['ExecutionBeginTime'] = self.execution_begin_time
        if self.item_name is not None:
            result['ItemName'] = self.item_name
        if self.script_id is not None:
            result['ScriptId'] = self.script_id
        if self.space is not None:
            result['Space'] = self.space
        if self.inspection_result is not None:
            result['InspectionResult'] = self.inspection_result
        result['InspectionAlarmRules'] = []
        if self.inspection_alarm_rules is not None:
            for k in self.inspection_alarm_rules:
                result['InspectionAlarmRules'].append(k.to_map() if k else None)
        if self.ip is not None:
            result['IP'] = self.ip
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.vendor is not None:
            result['Vendor'] = self.vendor
        if self.task_status is not None:
            result['TaskStatus'] = self.task_status
        if self.model is not None:
            result['Model'] = self.model
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.inspection_message is not None:
            result['InspectionMessage'] = self.inspection_message
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.device_display is not None:
            result['DeviceDisplay'] = self.device_display
        if self.role is not None:
            result['Role'] = self.role
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('ItemId') is not None:
            self.item_id = m.get('ItemId')
        if m.get('ExecutionEndTime') is not None:
            self.execution_end_time = m.get('ExecutionEndTime')
        if m.get('ExecutionBeginTime') is not None:
            self.execution_begin_time = m.get('ExecutionBeginTime')
        if m.get('ItemName') is not None:
            self.item_name = m.get('ItemName')
        if m.get('ScriptId') is not None:
            self.script_id = m.get('ScriptId')
        if m.get('Space') is not None:
            self.space = m.get('Space')
        if m.get('InspectionResult') is not None:
            self.inspection_result = m.get('InspectionResult')
        self.inspection_alarm_rules = []
        if m.get('InspectionAlarmRules') is not None:
            for k in m.get('InspectionAlarmRules'):
                temp_model = ListInspectionTasksResponseBodyInspectionTasksInspectionAlarmRules()
                self.inspection_alarm_rules.append(temp_model.from_map(k))
        if m.get('IP') is not None:
            self.ip = m.get('IP')
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('Vendor') is not None:
            self.vendor = m.get('Vendor')
        if m.get('TaskStatus') is not None:
            self.task_status = m.get('TaskStatus')
        if m.get('Model') is not None:
            self.model = m.get('Model')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('InspectionMessage') is not None:
            self.inspection_message = m.get('InspectionMessage')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('DeviceDisplay') is not None:
            self.device_display = m.get('DeviceDisplay')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        return self


class ListInspectionTasksResponseBody(TeaModel):
    def __init__(
        self,
        total_count: int = None,
        request_id: str = None,
        next_token: int = None,
        inspection_tasks: List[ListInspectionTasksResponseBodyInspectionTasks] = None,
    ):
        # 总记录数。
        self.total_count = total_count
        # 请求ID
        self.request_id = request_id
        # 当总结果个数大于MaxResults时，用于翻页的token。
        self.next_token = next_token
        # 数组，返回示例目录。
        self.inspection_tasks = inspection_tasks

    def validate(self):
        if self.inspection_tasks:
            for k in self.inspection_tasks:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        result['InspectionTasks'] = []
        if self.inspection_tasks is not None:
            for k in self.inspection_tasks:
                result['InspectionTasks'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        self.inspection_tasks = []
        if m.get('InspectionTasks') is not None:
            for k in m.get('InspectionTasks'):
                temp_model = ListInspectionTasksResponseBodyInspectionTasks()
                self.inspection_tasks.append(temp_model.from_map(k))
        return self


class ListInspectionTasksResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListInspectionTasksResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListInspectionTasksResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListScheduleWorkersRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        max_results: int = None,
        next_token: str = None,
    ):
        # instanceId
        self.instance_id = instance_id
        # 返回结果的最大个数。
        self.max_results = max_results
        # 当总结果个数大于MaxResults时，用于翻页的token。
        self.next_token = next_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        return self


class ListScheduleWorkersResponseBodyScheduleWorker(TeaModel):
    def __init__(
        self,
        schedule_worker_id: str = None,
        create_time: str = None,
        worker_id: str = None,
        worker_name: str = None,
        worker_contact: str = None,
        update_time: str = None,
    ):
        # 资源一级ID
        self.schedule_worker_id = schedule_worker_id
        # 创建时间
        self.create_time = create_time
        # 值班人员工号
        self.worker_id = worker_id
        # 值班人员姓名
        self.worker_name = worker_name
        # 联系方式
        self.worker_contact = worker_contact
        # 更新时间
        self.update_time = update_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.schedule_worker_id is not None:
            result['ScheduleWorkerId'] = self.schedule_worker_id
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.worker_id is not None:
            result['WorkerId'] = self.worker_id
        if self.worker_name is not None:
            result['WorkerName'] = self.worker_name
        if self.worker_contact is not None:
            result['WorkerContact'] = self.worker_contact
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ScheduleWorkerId') is not None:
            self.schedule_worker_id = m.get('ScheduleWorkerId')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('WorkerId') is not None:
            self.worker_id = m.get('WorkerId')
        if m.get('WorkerName') is not None:
            self.worker_name = m.get('WorkerName')
        if m.get('WorkerContact') is not None:
            self.worker_contact = m.get('WorkerContact')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        return self


class ListScheduleWorkersResponseBody(TeaModel):
    def __init__(
        self,
        schedule_worker: List[ListScheduleWorkersResponseBodyScheduleWorker] = None,
        total_count: int = None,
        max_results: int = None,
        request_id: str = None,
        next_token: int = None,
    ):
        # 数组，返回示例目录。
        self.schedule_worker = schedule_worker
        # 总记录数。
        self.total_count = total_count
        # 本次读取的最大数据量
        self.max_results = max_results
        # Id of the request
        self.request_id = request_id
        # 当总结果个数大于MaxResults时，用于翻页的token。
        self.next_token = next_token

    def validate(self):
        if self.schedule_worker:
            for k in self.schedule_worker:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ScheduleWorker'] = []
        if self.schedule_worker is not None:
            for k in self.schedule_worker:
                result['ScheduleWorker'].append(k.to_map() if k else None)
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.schedule_worker = []
        if m.get('ScheduleWorker') is not None:
            for k in m.get('ScheduleWorker'):
                temp_model = ListScheduleWorkersResponseBodyScheduleWorker()
                self.schedule_worker.append(temp_model.from_map(k))
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        return self


class ListScheduleWorkersResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListScheduleWorkersResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListScheduleWorkersResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class UpdateProjectProgressRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        setup_project_id: str = None,
        progress: str = None,
    ):
        self.instance_id = instance_id
        # 资源id
        self.setup_project_id = setup_project_id
        # 建设进展
        self.progress = progress

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.setup_project_id is not None:
            result['SetupProjectId'] = self.setup_project_id
        if self.progress is not None:
            result['Progress'] = self.progress
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('SetupProjectId') is not None:
            self.setup_project_id = m.get('SetupProjectId')
        if m.get('Progress') is not None:
            self.progress = m.get('Progress')
        return self


class UpdateProjectProgressResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # Id of the request
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class UpdateProjectProgressResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: UpdateProjectProgressResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = UpdateProjectProgressResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class UpdateDeviceResourceRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        device_resource_id: str = None,
        device_resource_ids: List[str] = None,
        setup_project_id: str = None,
        update_type: str = None,
        data: str = None,
    ):
        # instanceId
        self.instance_id = instance_id
        # 资源一级ID
        self.device_resource_id = device_resource_id
        # 资源一级ID
        self.device_resource_ids = device_resource_ids
        # 建设项目id
        self.setup_project_id = setup_project_id
        # 操作类型
        self.update_type = update_type
        # 更新数据
        self.data = data

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.device_resource_id is not None:
            result['DeviceResourceId'] = self.device_resource_id
        if self.device_resource_ids is not None:
            result['DeviceResourceIds'] = self.device_resource_ids
        if self.setup_project_id is not None:
            result['SetupProjectId'] = self.setup_project_id
        if self.update_type is not None:
            result['UpdateType'] = self.update_type
        if self.data is not None:
            result['Data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('DeviceResourceId') is not None:
            self.device_resource_id = m.get('DeviceResourceId')
        if m.get('DeviceResourceIds') is not None:
            self.device_resource_ids = m.get('DeviceResourceIds')
        if m.get('SetupProjectId') is not None:
            self.setup_project_id = m.get('SetupProjectId')
        if m.get('UpdateType') is not None:
            self.update_type = m.get('UpdateType')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        return self


class UpdateDeviceResourceShrinkRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        device_resource_id: str = None,
        device_resource_ids_shrink: str = None,
        setup_project_id: str = None,
        update_type: str = None,
        data: str = None,
    ):
        # instanceId
        self.instance_id = instance_id
        # 资源一级ID
        self.device_resource_id = device_resource_id
        # 资源一级ID
        self.device_resource_ids_shrink = device_resource_ids_shrink
        # 建设项目id
        self.setup_project_id = setup_project_id
        # 操作类型
        self.update_type = update_type
        # 更新数据
        self.data = data

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.device_resource_id is not None:
            result['DeviceResourceId'] = self.device_resource_id
        if self.device_resource_ids_shrink is not None:
            result['DeviceResourceIds'] = self.device_resource_ids_shrink
        if self.setup_project_id is not None:
            result['SetupProjectId'] = self.setup_project_id
        if self.update_type is not None:
            result['UpdateType'] = self.update_type
        if self.data is not None:
            result['Data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('DeviceResourceId') is not None:
            self.device_resource_id = m.get('DeviceResourceId')
        if m.get('DeviceResourceIds') is not None:
            self.device_resource_ids_shrink = m.get('DeviceResourceIds')
        if m.get('SetupProjectId') is not None:
            self.setup_project_id = m.get('SetupProjectId')
        if m.get('UpdateType') is not None:
            self.update_type = m.get('UpdateType')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        return self


class UpdateDeviceResourceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # Id of the request
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class UpdateDeviceResourceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: UpdateDeviceResourceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = UpdateDeviceResourceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDevicePropertyRequest(TeaModel):
    def __init__(
        self,
        device_property_id: str = None,
        property_key: str = None,
        device_form_id: str = None,
        instance_id: str = None,
    ):
        # 实例 ID。
        self.device_property_id = device_property_id
        # 属性主键
        self.property_key = property_key
        # 设备形态ID
        self.device_form_id = device_form_id
        # 实例ID
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_property_id is not None:
            result['DevicePropertyId'] = self.device_property_id
        if self.property_key is not None:
            result['PropertyKey'] = self.property_key
        if self.device_form_id is not None:
            result['DeviceFormId'] = self.device_form_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DevicePropertyId') is not None:
            self.device_property_id = m.get('DevicePropertyId')
        if m.get('PropertyKey') is not None:
            self.property_key = m.get('PropertyKey')
        if m.get('DeviceFormId') is not None:
            self.device_form_id = m.get('DeviceFormId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetDevicePropertyResponseBodyDeviceProperty(TeaModel):
    def __init__(
        self,
        device_property_id: str = None,
        device_form_id: str = None,
        device_form_name: str = None,
        property_name: str = None,
        property_key: str = None,
        property_format: str = None,
        property_content: str = None,
        built_in: bool = None,
    ):
        # 设备属性ID
        self.device_property_id = device_property_id
        # 设备形态ID
        self.device_form_id = device_form_id
        # 设备形态名称
        self.device_form_name = device_form_name
        # 属性名称
        self.property_name = property_name
        # 属性主键
        self.property_key = property_key
        # 属性格式
        self.property_format = property_format
        # 属性内容
        self.property_content = property_content
        # 是否内置属性
        self.built_in = built_in

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_property_id is not None:
            result['DevicePropertyId'] = self.device_property_id
        if self.device_form_id is not None:
            result['DeviceFormId'] = self.device_form_id
        if self.device_form_name is not None:
            result['DeviceFormName'] = self.device_form_name
        if self.property_name is not None:
            result['PropertyName'] = self.property_name
        if self.property_key is not None:
            result['PropertyKey'] = self.property_key
        if self.property_format is not None:
            result['PropertyFormat'] = self.property_format
        if self.property_content is not None:
            result['PropertyContent'] = self.property_content
        if self.built_in is not None:
            result['BuiltIn'] = self.built_in
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DevicePropertyId') is not None:
            self.device_property_id = m.get('DevicePropertyId')
        if m.get('DeviceFormId') is not None:
            self.device_form_id = m.get('DeviceFormId')
        if m.get('DeviceFormName') is not None:
            self.device_form_name = m.get('DeviceFormName')
        if m.get('PropertyName') is not None:
            self.property_name = m.get('PropertyName')
        if m.get('PropertyKey') is not None:
            self.property_key = m.get('PropertyKey')
        if m.get('PropertyFormat') is not None:
            self.property_format = m.get('PropertyFormat')
        if m.get('PropertyContent') is not None:
            self.property_content = m.get('PropertyContent')
        if m.get('BuiltIn') is not None:
            self.built_in = m.get('BuiltIn')
        return self


class GetDevicePropertyResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        device_property: GetDevicePropertyResponseBodyDeviceProperty = None,
    ):
        # Id of the request
        self.request_id = request_id
        # 设备属性详情
        self.device_property = device_property

    def validate(self):
        if self.device_property:
            self.device_property.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.device_property is not None:
            result['DeviceProperty'] = self.device_property.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('DeviceProperty') is not None:
            temp_model = GetDevicePropertyResponseBodyDeviceProperty()
            self.device_property = temp_model.from_map(m['DeviceProperty'])
        return self


class GetDevicePropertyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetDevicePropertyResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetDevicePropertyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListResourceTypesResponseBodyResourceType(TeaModel):
    def __init__(
        self,
        resource_type: str = None,
        resource_type_name: str = None,
        key: str = None,
    ):
        # 资源类型
        self.resource_type = resource_type
        # 资源名称
        self.resource_type_name = resource_type_name
        self.key = key

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        if self.resource_type_name is not None:
            result['ResourceTypeName'] = self.resource_type_name
        if self.key is not None:
            result['Key'] = self.key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        if m.get('ResourceTypeName') is not None:
            self.resource_type_name = m.get('ResourceTypeName')
        if m.get('Key') is not None:
            self.key = m.get('Key')
        return self


class ListResourceTypesResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        resource_type: List[ListResourceTypesResponseBodyResourceType] = None,
    ):
        # Id of the request
        self.request_id = request_id
        # 资源类型
        self.resource_type = resource_type

    def validate(self):
        if self.resource_type:
            for k in self.resource_type:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['ResourceType'] = []
        if self.resource_type is not None:
            for k in self.resource_type:
                result['ResourceType'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.resource_type = []
        if m.get('ResourceType') is not None:
            for k in m.get('ResourceType'):
                temp_model = ListResourceTypesResponseBodyResourceType()
                self.resource_type.append(temp_model.from_map(k))
        return self


class ListResourceTypesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListResourceTypesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListResourceTypesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetSetupProjectRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        setup_project_id: str = None,
    ):
        # instanceId
        self.instance_id = instance_id
        # 实例 ID。
        self.setup_project_id = setup_project_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.setup_project_id is not None:
            result['SetupProjectId'] = self.setup_project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('SetupProjectId') is not None:
            self.setup_project_id = m.get('SetupProjectId')
        return self


class GetSetupProjectResponseBodySetupProjectPackages(TeaModel):
    def __init__(
        self,
        role: str = None,
        device_number: str = None,
        vendor: str = None,
        model: str = None,
    ):
        # 角色
        self.role = role
        # 设备号
        self.device_number = device_number
        # 厂商
        self.vendor = vendor
        # 型号
        self.model = model

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.role is not None:
            result['Role'] = self.role
        if self.device_number is not None:
            result['DeviceNumber'] = self.device_number
        if self.vendor is not None:
            result['Vendor'] = self.vendor
        if self.model is not None:
            result['Model'] = self.model
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Role') is not None:
            self.role = m.get('Role')
        if m.get('DeviceNumber') is not None:
            self.device_number = m.get('DeviceNumber')
        if m.get('Vendor') is not None:
            self.vendor = m.get('Vendor')
        if m.get('Model') is not None:
            self.model = m.get('Model')
        return self


class GetSetupProjectResponseBodySetupProject(TeaModel):
    def __init__(
        self,
        delivery_time: str = None,
        packages: List[GetSetupProjectResponseBodySetupProjectPackages] = None,
        create_time: str = None,
        space_id: str = None,
        space_name: str = None,
        space_type: str = None,
        setup_project_id: str = None,
        nodes: str = None,
        progress: str = None,
    ):
        # 预计交付时间
        self.delivery_time = delivery_time
        # 套餐
        self.packages = packages
        # 创建时间
        self.create_time = create_time
        # 物理空间uId
        self.space_id = space_id
        # 物理空间名称
        self.space_name = space_name
        # 物理空间类型
        self.space_type = space_type
        # 资源一级ID
        self.setup_project_id = setup_project_id
        # 节点
        self.nodes = nodes
        # 项目进展
        self.progress = progress

    def validate(self):
        if self.packages:
            for k in self.packages:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.delivery_time is not None:
            result['DeliveryTime'] = self.delivery_time
        result['Packages'] = []
        if self.packages is not None:
            for k in self.packages:
                result['Packages'].append(k.to_map() if k else None)
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.space_id is not None:
            result['SpaceId'] = self.space_id
        if self.space_name is not None:
            result['SpaceName'] = self.space_name
        if self.space_type is not None:
            result['SpaceType'] = self.space_type
        if self.setup_project_id is not None:
            result['SetupProjectId'] = self.setup_project_id
        if self.nodes is not None:
            result['Nodes'] = self.nodes
        if self.progress is not None:
            result['Progress'] = self.progress
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeliveryTime') is not None:
            self.delivery_time = m.get('DeliveryTime')
        self.packages = []
        if m.get('Packages') is not None:
            for k in m.get('Packages'):
                temp_model = GetSetupProjectResponseBodySetupProjectPackages()
                self.packages.append(temp_model.from_map(k))
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('SpaceId') is not None:
            self.space_id = m.get('SpaceId')
        if m.get('SpaceName') is not None:
            self.space_name = m.get('SpaceName')
        if m.get('SpaceType') is not None:
            self.space_type = m.get('SpaceType')
        if m.get('SetupProjectId') is not None:
            self.setup_project_id = m.get('SetupProjectId')
        if m.get('Nodes') is not None:
            self.nodes = m.get('Nodes')
        if m.get('Progress') is not None:
            self.progress = m.get('Progress')
        return self


class GetSetupProjectResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        setup_project: GetSetupProjectResponseBodySetupProject = None,
    ):
        # Id of the request
        self.request_id = request_id
        # 建设项目
        self.setup_project = setup_project

    def validate(self):
        if self.setup_project:
            self.setup_project.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.setup_project is not None:
            result['SetupProject'] = self.setup_project.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SetupProject') is not None:
            temp_model = GetSetupProjectResponseBodySetupProject()
            self.setup_project = temp_model.from_map(m['SetupProject'])
        return self


class GetSetupProjectResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetSetupProjectResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetSetupProjectResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListConfigurationVariateRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        max_results: int = None,
        next_token: str = None,
        variate_name: str = None,
    ):
        # instanceId
        self.instance_id = instance_id
        # 返回结果的最大个数。
        self.max_results = max_results
        # 当总结果个数大于MaxResults时，用于翻页的token。
        self.next_token = next_token
        # 变量名字
        self.variate_name = variate_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.variate_name is not None:
            result['VariateName'] = self.variate_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('VariateName') is not None:
            self.variate_name = m.get('VariateName')
        return self


class ListConfigurationVariateResponseBodyConfigurationVariate(TeaModel):
    def __init__(
        self,
        create_time: str = None,
        configuration_variate_id: str = None,
        variate_name: str = None,
        update_time: str = None,
        comment: str = None,
        format_function: str = None,
    ):
        # 创建时间
        self.create_time = create_time
        # 配置变量id
        self.configuration_variate_id = configuration_variate_id
        # 配置变量名称
        self.variate_name = variate_name
        # 更新时间
        self.update_time = update_time
        # 配置变量描述
        self.comment = comment
        # 配置变量转换函数
        self.format_function = format_function

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.configuration_variate_id is not None:
            result['ConfigurationVariateId'] = self.configuration_variate_id
        if self.variate_name is not None:
            result['VariateName'] = self.variate_name
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.format_function is not None:
            result['FormatFunction'] = self.format_function
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('ConfigurationVariateId') is not None:
            self.configuration_variate_id = m.get('ConfigurationVariateId')
        if m.get('VariateName') is not None:
            self.variate_name = m.get('VariateName')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('FormatFunction') is not None:
            self.format_function = m.get('FormatFunction')
        return self


class ListConfigurationVariateResponseBody(TeaModel):
    def __init__(
        self,
        total_count: int = None,
        configuration_variate: List[ListConfigurationVariateResponseBodyConfigurationVariate] = None,
        request_id: str = None,
        next_token: int = None,
        max_results: int = None,
    ):
        # 总记录数。
        self.total_count = total_count
        # 数组，返回示例目录。
        self.configuration_variate = configuration_variate
        # Id of the request
        self.request_id = request_id
        # 当总结果个数大于MaxResults时，用于翻页的token。
        self.next_token = next_token
        # 本次读取的最大数据量
        self.max_results = max_results

    def validate(self):
        if self.configuration_variate:
            for k in self.configuration_variate:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['ConfigurationVariate'] = []
        if self.configuration_variate is not None:
            for k in self.configuration_variate:
                result['ConfigurationVariate'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.configuration_variate = []
        if m.get('ConfigurationVariate') is not None:
            for k in m.get('ConfigurationVariate'):
                temp_model = ListConfigurationVariateResponseBodyConfigurationVariate()
                self.configuration_variate.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        return self


class ListConfigurationVariateResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListConfigurationVariateResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListConfigurationVariateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateSpaceModelRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        space_type: str = None,
        client_token: str = None,
    ):
        # instanceId
        self.instance_id = instance_id
        # 物理空间类型
        self.space_type = space_type
        # 幂等参数
        self.client_token = client_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.space_type is not None:
            result['SpaceType'] = self.space_type
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('SpaceType') is not None:
            self.space_type = m.get('SpaceType')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        return self


class CreateSpaceModelResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        space_model_id: str = None,
    ):
        # Id of the request
        self.request_id = request_id
        # 资源实例ID，如ECS实例的创建接口CreateInstance应返回InstanceId。
        self.space_model_id = space_model_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.space_model_id is not None:
            result['SpaceModelId'] = self.space_model_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SpaceModelId') is not None:
            self.space_model_id = m.get('SpaceModelId')
        return self


class CreateSpaceModelResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateSpaceModelResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateSpaceModelResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteScheduleWorkerRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        schedule_worker_id: str = None,
    ):
        # instanceId
        self.instance_id = instance_id
        # 实例 ID。
        self.schedule_worker_id = schedule_worker_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.schedule_worker_id is not None:
            result['ScheduleWorkerId'] = self.schedule_worker_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ScheduleWorkerId') is not None:
            self.schedule_worker_id = m.get('ScheduleWorkerId')
        return self


class DeleteScheduleWorkerResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # Id of the request
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteScheduleWorkerResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteScheduleWorkerResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteScheduleWorkerResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListDedicatedLinesRequest(TeaModel):
    def __init__(
        self,
        physical_space_id: str = None,
        instance_id: str = None,
    ):
        # 物理空间ID
        self.physical_space_id = physical_space_id
        # 实例ID
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.physical_space_id is not None:
            result['PhysicalSpaceId'] = self.physical_space_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PhysicalSpaceId') is not None:
            self.physical_space_id = m.get('PhysicalSpaceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class ListDedicatedLinesResponseBodyDedicatedLines(TeaModel):
    def __init__(
        self,
        dedicated_line_id: str = None,
        isp: str = None,
        bandwidth: int = None,
        dedicated_line_ip: str = None,
        dedicated_line_gateway: str = None,
        dedicated_line_role: str = None,
        device_id: str = None,
        device_port: str = None,
        device_name: str = None,
        physical_space_id: str = None,
    ):
        # 物理空间专线ID
        self.dedicated_line_id = dedicated_line_id
        # 运营商
        self.isp = isp
        # 宽带（Mbps）
        self.bandwidth = bandwidth
        # 专线IP
        self.dedicated_line_ip = dedicated_line_ip
        # 专线网关
        self.dedicated_line_gateway = dedicated_line_gateway
        # 专线角色
        self.dedicated_line_role = dedicated_line_role
        # 关联设备ID
        self.device_id = device_id
        # 关联设备端口
        self.device_port = device_port
        # 关联设备名称
        self.device_name = device_name
        # 关联物理空间ID
        self.physical_space_id = physical_space_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dedicated_line_id is not None:
            result['DedicatedLineId'] = self.dedicated_line_id
        if self.isp is not None:
            result['Isp'] = self.isp
        if self.bandwidth is not None:
            result['Bandwidth'] = self.bandwidth
        if self.dedicated_line_ip is not None:
            result['DedicatedLineIp'] = self.dedicated_line_ip
        if self.dedicated_line_gateway is not None:
            result['DedicatedLineGateway'] = self.dedicated_line_gateway
        if self.dedicated_line_role is not None:
            result['DedicatedLineRole'] = self.dedicated_line_role
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.device_port is not None:
            result['DevicePort'] = self.device_port
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.physical_space_id is not None:
            result['PhysicalSpaceId'] = self.physical_space_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DedicatedLineId') is not None:
            self.dedicated_line_id = m.get('DedicatedLineId')
        if m.get('Isp') is not None:
            self.isp = m.get('Isp')
        if m.get('Bandwidth') is not None:
            self.bandwidth = m.get('Bandwidth')
        if m.get('DedicatedLineIp') is not None:
            self.dedicated_line_ip = m.get('DedicatedLineIp')
        if m.get('DedicatedLineGateway') is not None:
            self.dedicated_line_gateway = m.get('DedicatedLineGateway')
        if m.get('DedicatedLineRole') is not None:
            self.dedicated_line_role = m.get('DedicatedLineRole')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('DevicePort') is not None:
            self.device_port = m.get('DevicePort')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('PhysicalSpaceId') is not None:
            self.physical_space_id = m.get('PhysicalSpaceId')
        return self


class ListDedicatedLinesResponseBody(TeaModel):
    def __init__(
        self,
        dedicated_lines: List[ListDedicatedLinesResponseBodyDedicatedLines] = None,
        request_id: str = None,
    ):
        # 数组，返回示例目录。
        self.dedicated_lines = dedicated_lines
        # Id of the request
        self.request_id = request_id

    def validate(self):
        if self.dedicated_lines:
            for k in self.dedicated_lines:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DedicatedLines'] = []
        if self.dedicated_lines is not None:
            for k in self.dedicated_lines:
                result['DedicatedLines'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.dedicated_lines = []
        if m.get('DedicatedLines') is not None:
            for k in m.get('DedicatedLines'):
                temp_model = ListDedicatedLinesResponseBodyDedicatedLines()
                self.dedicated_lines.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListDedicatedLinesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListDedicatedLinesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListDedicatedLinesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class UpdateInformationKeyActionRequest(TeaModel):
    def __init__(
        self,
        resource_information_id: str = None,
        instance_id: str = None,
        key: str = None,
        value: str = None,
        key_action: str = None,
        setup_project_id: str = None,
    ):
        # 资源id
        self.resource_information_id = resource_information_id
        self.instance_id = instance_id
        # 键
        self.key = key
        # 键值
        self.value = value
        # 动作
        self.key_action = key_action
        # 建设项目id
        self.setup_project_id = setup_project_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_information_id is not None:
            result['ResourceInformationId'] = self.resource_information_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        if self.key_action is not None:
            result['KeyAction'] = self.key_action
        if self.setup_project_id is not None:
            result['SetupProjectId'] = self.setup_project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceInformationId') is not None:
            self.resource_information_id = m.get('ResourceInformationId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        if m.get('KeyAction') is not None:
            self.key_action = m.get('KeyAction')
        if m.get('SetupProjectId') is not None:
            self.setup_project_id = m.get('SetupProjectId')
        return self


class UpdateInformationKeyActionResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        action_message: str = None,
    ):
        # Id of the request
        self.request_id = request_id
        # 返回信息
        self.action_message = action_message

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.action_message is not None:
            result['ActionMessage'] = self.action_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ActionMessage') is not None:
            self.action_message = m.get('ActionMessage')
        return self


class UpdateInformationKeyActionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: UpdateInformationKeyActionResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = UpdateInformationKeyActionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetRealtimeTaskRequest(TeaModel):
    def __init__(
        self,
        task_id: str = None,
        instance_id: str = None,
    ):
        # 实时任务ID
        self.task_id = task_id
        # 实例ID
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetRealtimeTaskResponseBodyInspectionTask(TeaModel):
    def __init__(
        self,
        task_status: str = None,
        inspection_result: str = None,
        error_code: str = None,
        inspection_message: str = None,
    ):
        # 巡检状态
        self.task_status = task_status
        # 巡检输出
        self.inspection_result = inspection_result
        # 巡检错误码
        self.error_code = error_code
        # 巡检错误信息
        self.inspection_message = inspection_message

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.task_status is not None:
            result['TaskStatus'] = self.task_status
        if self.inspection_result is not None:
            result['InspectionResult'] = self.inspection_result
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.inspection_message is not None:
            result['InspectionMessage'] = self.inspection_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TaskStatus') is not None:
            self.task_status = m.get('TaskStatus')
        if m.get('InspectionResult') is not None:
            self.inspection_result = m.get('InspectionResult')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('InspectionMessage') is not None:
            self.inspection_message = m.get('InspectionMessage')
        return self


class GetRealtimeTaskResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        inspection_task: GetRealtimeTaskResponseBodyInspectionTask = None,
    ):
        # 请求ID
        self.request_id = request_id
        # 请求任务结果
        self.inspection_task = inspection_task

    def validate(self):
        if self.inspection_task:
            self.inspection_task.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.inspection_task is not None:
            result['InspectionTask'] = self.inspection_task.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('InspectionTask') is not None:
            temp_model = GetRealtimeTaskResponseBodyInspectionTask()
            self.inspection_task = temp_model.from_map(m['InspectionTask'])
        return self


class GetRealtimeTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetRealtimeTaskResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetRealtimeTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListScheduleTypesRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        max_results: int = None,
        next_token: str = None,
    ):
        # instanceId
        self.instance_id = instance_id
        # 返回结果的最大个数。
        self.max_results = max_results
        # 当总结果个数大于MaxResults时，用于翻页的token。
        self.next_token = next_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        return self


class ListScheduleTypesResponseBodyScheduleType(TeaModel):
    def __init__(
        self,
        status: str = None,
        related_worker: List[str] = None,
        create_time: str = None,
        schedule_type_id: str = None,
        update_time: str = None,
        schedule_type: str = None,
    ):
        # 值班类型状态
        self.status = status
        self.related_worker = related_worker
        # 创建时间
        self.create_time = create_time
        # 资源一级ID
        self.schedule_type_id = schedule_type_id
        # 更新时间
        self.update_time = update_time
        # 值班类型value
        self.schedule_type = schedule_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.related_worker is not None:
            result['RelatedWorker'] = self.related_worker
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.schedule_type_id is not None:
            result['ScheduleTypeId'] = self.schedule_type_id
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        if self.schedule_type is not None:
            result['ScheduleType'] = self.schedule_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('RelatedWorker') is not None:
            self.related_worker = m.get('RelatedWorker')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('ScheduleTypeId') is not None:
            self.schedule_type_id = m.get('ScheduleTypeId')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        if m.get('ScheduleType') is not None:
            self.schedule_type = m.get('ScheduleType')
        return self


class ListScheduleTypesResponseBody(TeaModel):
    def __init__(
        self,
        total_count: int = None,
        schedule_type: List[ListScheduleTypesResponseBodyScheduleType] = None,
        request_id: str = None,
        next_token: int = None,
        max_results: int = None,
    ):
        # 总记录数。
        self.total_count = total_count
        # 数组，返回示例目录。
        self.schedule_type = schedule_type
        # Id of the request
        self.request_id = request_id
        # 当总结果个数大于MaxResults时，用于翻页的token。
        self.next_token = next_token
        # 本次读取的最大数据量
        self.max_results = max_results

    def validate(self):
        if self.schedule_type:
            for k in self.schedule_type:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['ScheduleType'] = []
        if self.schedule_type is not None:
            for k in self.schedule_type:
                result['ScheduleType'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.schedule_type = []
        if m.get('ScheduleType') is not None:
            for k in m.get('ScheduleType'):
                temp_model = ListScheduleTypesResponseBodyScheduleType()
                self.schedule_type.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        return self


class ListScheduleTypesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListScheduleTypesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListScheduleTypesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateScheduleTypeRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        schedule_type: str = None,
        related_worker: List[str] = None,
        status: str = None,
        client_token: str = None,
    ):
        # instanceId
        self.instance_id = instance_id
        # 值班类型key
        self.schedule_type = schedule_type
        # relatedWorkerStr
        self.related_worker = related_worker
        # 值班类型状态
        self.status = status
        # 幂等参数
        self.client_token = client_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.schedule_type is not None:
            result['ScheduleType'] = self.schedule_type
        if self.related_worker is not None:
            result['RelatedWorker'] = self.related_worker
        if self.status is not None:
            result['Status'] = self.status
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ScheduleType') is not None:
            self.schedule_type = m.get('ScheduleType')
        if m.get('RelatedWorker') is not None:
            self.related_worker = m.get('RelatedWorker')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        return self


class CreateScheduleTypeShrinkRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        schedule_type: str = None,
        related_worker_shrink: str = None,
        status: str = None,
        client_token: str = None,
    ):
        # instanceId
        self.instance_id = instance_id
        # 值班类型key
        self.schedule_type = schedule_type
        # relatedWorkerStr
        self.related_worker_shrink = related_worker_shrink
        # 值班类型状态
        self.status = status
        # 幂等参数
        self.client_token = client_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.schedule_type is not None:
            result['ScheduleType'] = self.schedule_type
        if self.related_worker_shrink is not None:
            result['RelatedWorker'] = self.related_worker_shrink
        if self.status is not None:
            result['Status'] = self.status
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ScheduleType') is not None:
            self.schedule_type = m.get('ScheduleType')
        if m.get('RelatedWorker') is not None:
            self.related_worker_shrink = m.get('RelatedWorker')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        return self


class CreateScheduleTypeResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        schedule_type_id: str = None,
    ):
        # Id of the request
        self.request_id = request_id
        # 资源实例ID，如ECS实例的创建接口CreateInstance应返回InstanceId。
        self.schedule_type_id = schedule_type_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.schedule_type_id is not None:
            result['ScheduleTypeId'] = self.schedule_type_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ScheduleTypeId') is not None:
            self.schedule_type_id = m.get('ScheduleTypeId')
        return self


class CreateScheduleTypeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateScheduleTypeResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateScheduleTypeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetScheduleWorkerRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        schedule_worker_id: str = None,
    ):
        self.instance_id = instance_id
        # 实例 ID。
        self.schedule_worker_id = schedule_worker_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.schedule_worker_id is not None:
            result['ScheduleWorkerId'] = self.schedule_worker_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ScheduleWorkerId') is not None:
            self.schedule_worker_id = m.get('ScheduleWorkerId')
        return self


class GetScheduleWorkerResponseBodyScheduleWorker(TeaModel):
    def __init__(
        self,
        create_time: str = None,
        update_time: str = None,
        schedule_worker_id: str = None,
        worker_id: str = None,
        worker_name: str = None,
        worker_contact: str = None,
    ):
        # 创建时间
        self.create_time = create_time
        # 更新时间
        self.update_time = update_time
        # 资源一级ID
        self.schedule_worker_id = schedule_worker_id
        # 值班人员工号
        self.worker_id = worker_id
        # 值班人员姓名
        self.worker_name = worker_name
        # 联系方式
        self.worker_contact = worker_contact

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        if self.schedule_worker_id is not None:
            result['ScheduleWorkerId'] = self.schedule_worker_id
        if self.worker_id is not None:
            result['WorkerId'] = self.worker_id
        if self.worker_name is not None:
            result['WorkerName'] = self.worker_name
        if self.worker_contact is not None:
            result['WorkerContact'] = self.worker_contact
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        if m.get('ScheduleWorkerId') is not None:
            self.schedule_worker_id = m.get('ScheduleWorkerId')
        if m.get('WorkerId') is not None:
            self.worker_id = m.get('WorkerId')
        if m.get('WorkerName') is not None:
            self.worker_name = m.get('WorkerName')
        if m.get('WorkerContact') is not None:
            self.worker_contact = m.get('WorkerContact')
        return self


class GetScheduleWorkerResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        schedule_worker: GetScheduleWorkerResponseBodyScheduleWorker = None,
    ):
        # Id of the request
        self.request_id = request_id
        # 值班人员对象
        self.schedule_worker = schedule_worker

    def validate(self):
        if self.schedule_worker:
            self.schedule_worker.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.schedule_worker is not None:
            result['ScheduleWorker'] = self.schedule_worker.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ScheduleWorker') is not None:
            temp_model = GetScheduleWorkerResponseBodyScheduleWorker()
            self.schedule_worker = temp_model.from_map(m['ScheduleWorker'])
        return self


class GetScheduleWorkerResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetScheduleWorkerResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetScheduleWorkerResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateScheduleWorkerRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        worker_id: str = None,
        worker_name: str = None,
        worker_contact: str = None,
        client_token: str = None,
    ):
        # instanceId
        self.instance_id = instance_id
        # 值班人员工号
        self.worker_id = worker_id
        # 值班人员姓名
        self.worker_name = worker_name
        # 联系方式
        self.worker_contact = worker_contact
        # 幂等参数
        self.client_token = client_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.worker_id is not None:
            result['WorkerId'] = self.worker_id
        if self.worker_name is not None:
            result['WorkerName'] = self.worker_name
        if self.worker_contact is not None:
            result['WorkerContact'] = self.worker_contact
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('WorkerId') is not None:
            self.worker_id = m.get('WorkerId')
        if m.get('WorkerName') is not None:
            self.worker_name = m.get('WorkerName')
        if m.get('WorkerContact') is not None:
            self.worker_contact = m.get('WorkerContact')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        return self


class CreateScheduleWorkerResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        schedule_worker_id: str = None,
    ):
        # Id of the request
        self.request_id = request_id
        # 资源实例ID，如ECS实例的创建接口CreateInstance应返回InstanceId。
        self.schedule_worker_id = schedule_worker_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.schedule_worker_id is not None:
            result['ScheduleWorkerId'] = self.schedule_worker_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ScheduleWorkerId') is not None:
            self.schedule_worker_id = m.get('ScheduleWorkerId')
        return self


class CreateScheduleWorkerResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateScheduleWorkerResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateScheduleWorkerResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateConfigurationVariateRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        variate_name: str = None,
        client_token: str = None,
        comment: str = None,
        format_function: str = None,
    ):
        # instanceId
        self.instance_id = instance_id
        # 资源名称
        self.variate_name = variate_name
        # 幂等参数
        self.client_token = client_token
        # 描述变量
        self.comment = comment
        # python转换函数
        self.format_function = format_function

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.variate_name is not None:
            result['VariateName'] = self.variate_name
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.format_function is not None:
            result['FormatFunction'] = self.format_function
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('VariateName') is not None:
            self.variate_name = m.get('VariateName')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('FormatFunction') is not None:
            self.format_function = m.get('FormatFunction')
        return self


class CreateConfigurationVariateResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        configuration_variate_id: str = None,
    ):
        # Id of the request
        self.request_id = request_id
        # 资源实例ID，如ECS实例的创建接口CreateInstance应返回InstanceId。
        self.configuration_variate_id = configuration_variate_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.configuration_variate_id is not None:
            result['ConfigurationVariateId'] = self.configuration_variate_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ConfigurationVariateId') is not None:
            self.configuration_variate_id = m.get('ConfigurationVariateId')
        return self


class CreateConfigurationVariateResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateConfigurationVariateResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateConfigurationVariateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetSpaceModelSortRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        space_type: str = None,
        operate_type: str = None,
    ):
        # instanceId
        self.instance_id = instance_id
        # 物理空间类型
        self.space_type = space_type
        # 操作类型
        self.operate_type = operate_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.space_type is not None:
            result['SpaceType'] = self.space_type
        if self.operate_type is not None:
            result['OperateType'] = self.operate_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('SpaceType') is not None:
            self.space_type = m.get('SpaceType')
        if m.get('OperateType') is not None:
            self.operate_type = m.get('OperateType')
        return self


class GetSpaceModelSortResponseBodySpaceModel(TeaModel):
    def __init__(
        self,
        level_name: str = None,
        level: int = None,
    ):
        # 层级名称
        self.level_name = level_name
        # 层级
        self.level = level

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.level_name is not None:
            result['LevelName'] = self.level_name
        if self.level is not None:
            result['Level'] = self.level
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('LevelName') is not None:
            self.level_name = m.get('LevelName')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        return self


class GetSpaceModelSortResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        space_model: List[GetSpaceModelSortResponseBodySpaceModel] = None,
    ):
        # Id of the request
        self.request_id = request_id
        # 建设项目
        self.space_model = space_model

    def validate(self):
        if self.space_model:
            for k in self.space_model:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['SpaceModel'] = []
        if self.space_model is not None:
            for k in self.space_model:
                result['SpaceModel'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.space_model = []
        if m.get('SpaceModel') is not None:
            for k in m.get('SpaceModel'):
                temp_model = GetSpaceModelSortResponseBodySpaceModel()
                self.space_model.append(temp_model.from_map(k))
        return self


class GetSpaceModelSortResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetSpaceModelSortResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetSpaceModelSortResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateRealtimeTaskRequest(TeaModel):
    def __init__(
        self,
        device_id: str = None,
        script: str = None,
        instance_id: str = None,
        client_token: str = None,
    ):
        # 设备ID
        self.device_id = device_id
        # 模板执行脚本
        self.script = script
        # 实例ID
        self.instance_id = instance_id
        # token
        self.client_token = client_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.script is not None:
            result['Script'] = self.script
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('Script') is not None:
            self.script = m.get('Script')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        return self


class CreateRealtimeTaskResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        task_id: str = None,
    ):
        # 请求ID
        self.request_id = request_id
        # 实时任务ID
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class CreateRealtimeTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateRealtimeTaskResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateRealtimeTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDeviceFormRequest(TeaModel):
    def __init__(
        self,
        device_form_id: str = None,
        instance_id: str = None,
    ):
        # 实例 ID。
        self.device_form_id = device_form_id
        # 实例ID
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_form_id is not None:
            result['DeviceFormId'] = self.device_form_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeviceFormId') is not None:
            self.device_form_id = m.get('DeviceFormId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetDeviceFormResponseBodyDeviceFormAttributeList(TeaModel):
    def __init__(
        self,
        attribute_key: str = None,
        attribute_name: str = None,
        attribute_requirement: bool = None,
        attribute_uniqueness: bool = None,
        attribute_format: str = None,
        attribute_type: str = None,
        attribute_reference: str = None,
        attribute_table_display: bool = None,
        attribute_placeholder: str = None,
        attribute_query: bool = None,
        attribute_fuzzy_query: bool = None,
        attribute_built_in: bool = None,
    ):
        # 设备形态属性主键
        self.attribute_key = attribute_key
        # 设备形态属性名称
        self.attribute_name = attribute_name
        # 设备形态属性是否必填
        self.attribute_requirement = attribute_requirement
        # 设备形态属性是否唯一
        self.attribute_uniqueness = attribute_uniqueness
        # 设备形态属性值格式
        self.attribute_format = attribute_format
        # 设备形态属性值类型
        self.attribute_type = attribute_type
        # 设备形态属性关联对象
        self.attribute_reference = attribute_reference
        # 设备形态属性是否表格可见
        self.attribute_table_display = attribute_table_display
        # 前端查询控件占位符
        self.attribute_placeholder = attribute_placeholder
        # 前端是否展示对应的查询控件
        self.attribute_query = attribute_query
        # 前端查询控件是否支持模糊搜索
        self.attribute_fuzzy_query = attribute_fuzzy_query
        # 设备形态属性是否内置
        self.attribute_built_in = attribute_built_in

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.attribute_key is not None:
            result['AttributeKey'] = self.attribute_key
        if self.attribute_name is not None:
            result['AttributeName'] = self.attribute_name
        if self.attribute_requirement is not None:
            result['AttributeRequirement'] = self.attribute_requirement
        if self.attribute_uniqueness is not None:
            result['AttributeUniqueness'] = self.attribute_uniqueness
        if self.attribute_format is not None:
            result['AttributeFormat'] = self.attribute_format
        if self.attribute_type is not None:
            result['AttributeType'] = self.attribute_type
        if self.attribute_reference is not None:
            result['AttributeReference'] = self.attribute_reference
        if self.attribute_table_display is not None:
            result['AttributeTableDisplay'] = self.attribute_table_display
        if self.attribute_placeholder is not None:
            result['AttributePlaceholder'] = self.attribute_placeholder
        if self.attribute_query is not None:
            result['AttributeQuery'] = self.attribute_query
        if self.attribute_fuzzy_query is not None:
            result['AttributeFuzzyQuery'] = self.attribute_fuzzy_query
        if self.attribute_built_in is not None:
            result['AttributeBuiltIn'] = self.attribute_built_in
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AttributeKey') is not None:
            self.attribute_key = m.get('AttributeKey')
        if m.get('AttributeName') is not None:
            self.attribute_name = m.get('AttributeName')
        if m.get('AttributeRequirement') is not None:
            self.attribute_requirement = m.get('AttributeRequirement')
        if m.get('AttributeUniqueness') is not None:
            self.attribute_uniqueness = m.get('AttributeUniqueness')
        if m.get('AttributeFormat') is not None:
            self.attribute_format = m.get('AttributeFormat')
        if m.get('AttributeType') is not None:
            self.attribute_type = m.get('AttributeType')
        if m.get('AttributeReference') is not None:
            self.attribute_reference = m.get('AttributeReference')
        if m.get('AttributeTableDisplay') is not None:
            self.attribute_table_display = m.get('AttributeTableDisplay')
        if m.get('AttributePlaceholder') is not None:
            self.attribute_placeholder = m.get('AttributePlaceholder')
        if m.get('AttributeQuery') is not None:
            self.attribute_query = m.get('AttributeQuery')
        if m.get('AttributeFuzzyQuery') is not None:
            self.attribute_fuzzy_query = m.get('AttributeFuzzyQuery')
        if m.get('AttributeBuiltIn') is not None:
            self.attribute_built_in = m.get('AttributeBuiltIn')
        return self


class GetDeviceFormResponseBodyDeviceForm(TeaModel):
    def __init__(
        self,
        config_compare: bool = None,
        attribute_list: List[GetDeviceFormResponseBodyDeviceFormAttributeList] = None,
        device_form_id: str = None,
        device_form_name: str = None,
        form_built_in: bool = None,
        account_config: bool = None,
        detail_display: bool = None,
        unique_key: str = None,
    ):
        # 是否支持配置生成
        self.config_compare = config_compare
        # 设备形态属性列表
        self.attribute_list = attribute_list
        # 设备形态ID
        self.device_form_id = device_form_id
        # 设备形态名称
        self.device_form_name = device_form_name
        # 设备形态是否内置
        self.form_built_in = form_built_in
        # 是否需要账号配置
        self.account_config = account_config
        # 是否展示设备详情
        self.detail_display = detail_display
        # 设备形态主键
        self.unique_key = unique_key

    def validate(self):
        if self.attribute_list:
            for k in self.attribute_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_compare is not None:
            result['ConfigCompare'] = self.config_compare
        result['AttributeList'] = []
        if self.attribute_list is not None:
            for k in self.attribute_list:
                result['AttributeList'].append(k.to_map() if k else None)
        if self.device_form_id is not None:
            result['DeviceFormId'] = self.device_form_id
        if self.device_form_name is not None:
            result['DeviceFormName'] = self.device_form_name
        if self.form_built_in is not None:
            result['FormBuiltIn'] = self.form_built_in
        if self.account_config is not None:
            result['AccountConfig'] = self.account_config
        if self.detail_display is not None:
            result['DetailDisplay'] = self.detail_display
        if self.unique_key is not None:
            result['UniqueKey'] = self.unique_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConfigCompare') is not None:
            self.config_compare = m.get('ConfigCompare')
        self.attribute_list = []
        if m.get('AttributeList') is not None:
            for k in m.get('AttributeList'):
                temp_model = GetDeviceFormResponseBodyDeviceFormAttributeList()
                self.attribute_list.append(temp_model.from_map(k))
        if m.get('DeviceFormId') is not None:
            self.device_form_id = m.get('DeviceFormId')
        if m.get('DeviceFormName') is not None:
            self.device_form_name = m.get('DeviceFormName')
        if m.get('FormBuiltIn') is not None:
            self.form_built_in = m.get('FormBuiltIn')
        if m.get('AccountConfig') is not None:
            self.account_config = m.get('AccountConfig')
        if m.get('DetailDisplay') is not None:
            self.detail_display = m.get('DetailDisplay')
        if m.get('UniqueKey') is not None:
            self.unique_key = m.get('UniqueKey')
        return self


class GetDeviceFormResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        device_form: GetDeviceFormResponseBodyDeviceForm = None,
    ):
        # Id of the request
        self.request_id = request_id
        # 设备详情
        self.device_form = device_form

    def validate(self):
        if self.device_form:
            self.device_form.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.device_form is not None:
            result['DeviceForm'] = self.device_form.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('DeviceForm') is not None:
            temp_model = GetDeviceFormResponseBodyDeviceForm()
            self.device_form = temp_model.from_map(m['DeviceForm'])
        return self


class GetDeviceFormResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetDeviceFormResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetDeviceFormResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDeviceRequest(TeaModel):
    def __init__(
        self,
        device_form_id: str = None,
        physical_space_id: str = None,
        host_name: str = None,
        ip: str = None,
        sn: str = None,
        mac: str = None,
        vendor: str = None,
        model: str = None,
        service_status: str = None,
        security_domain: str = None,
        login_type: str = None,
        login_username: str = None,
        login_password: str = None,
        snmp_account_version: str = None,
        snmp_community: str = None,
        snmp_account_type: str = None,
        snmp_security_level: str = None,
        snmp_username: str = None,
        snmp_auth_passphrase: str = None,
        snmp_auth_protocol: str = None,
        snmp_privacy_passphase: str = None,
        snmp_privacy_protocol: str = None,
        ext_attributes: str = None,
        client_token: str = None,
        instance_id: str = None,
    ):
        # 设备形态ID
        self.device_form_id = device_form_id
        # 物理空间ID
        self.physical_space_id = physical_space_id
        # 主机名
        self.host_name = host_name
        # 设备IP
        self.ip = ip
        # 设备SN
        self.sn = sn
        # 设备MAC地址
        self.mac = mac
        # 设备厂商
        self.vendor = vendor
        # 设备型号
        self.model = model
        # 设备状态
        self.service_status = service_status
        # 设备安全域
        self.security_domain = security_domain
        # 登录类型
        self.login_type = login_type
        # 登录账号
        self.login_username = login_username
        # 登录密码
        self.login_password = login_password
        # SNMP 版本号
        self.snmp_account_version = snmp_account_version
        # SNMP Community
        self.snmp_community = snmp_community
        # SNMP 账号类型
        self.snmp_account_type = snmp_account_type
        # SNMP 安全级别
        self.snmp_security_level = snmp_security_level
        # SNMP 用户名
        self.snmp_username = snmp_username
        # SNMP Auth PassPhrase
        self.snmp_auth_passphrase = snmp_auth_passphrase
        # SNMP Auth Protocol
        self.snmp_auth_protocol = snmp_auth_protocol
        # SNMP Privacy Passphase
        self.snmp_privacy_passphase = snmp_privacy_passphase
        # SNMP Privacy Protocol
        self.snmp_privacy_protocol = snmp_privacy_protocol
        # 设备额外属性
        self.ext_attributes = ext_attributes
        # 幂等校验 token
        self.client_token = client_token
        # 实例ID
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_form_id is not None:
            result['DeviceFormId'] = self.device_form_id
        if self.physical_space_id is not None:
            result['PhysicalSpaceId'] = self.physical_space_id
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.ip is not None:
            result['Ip'] = self.ip
        if self.sn is not None:
            result['Sn'] = self.sn
        if self.mac is not None:
            result['Mac'] = self.mac
        if self.vendor is not None:
            result['Vendor'] = self.vendor
        if self.model is not None:
            result['Model'] = self.model
        if self.service_status is not None:
            result['ServiceStatus'] = self.service_status
        if self.security_domain is not None:
            result['SecurityDomain'] = self.security_domain
        if self.login_type is not None:
            result['LoginType'] = self.login_type
        if self.login_username is not None:
            result['LoginUsername'] = self.login_username
        if self.login_password is not None:
            result['LoginPassword'] = self.login_password
        if self.snmp_account_version is not None:
            result['SnmpAccountVersion'] = self.snmp_account_version
        if self.snmp_community is not None:
            result['SnmpCommunity'] = self.snmp_community
        if self.snmp_account_type is not None:
            result['SnmpAccountType'] = self.snmp_account_type
        if self.snmp_security_level is not None:
            result['SnmpSecurityLevel'] = self.snmp_security_level
        if self.snmp_username is not None:
            result['SnmpUsername'] = self.snmp_username
        if self.snmp_auth_passphrase is not None:
            result['SnmpAuthPassphrase'] = self.snmp_auth_passphrase
        if self.snmp_auth_protocol is not None:
            result['SnmpAuthProtocol'] = self.snmp_auth_protocol
        if self.snmp_privacy_passphase is not None:
            result['SnmpPrivacyPassphase'] = self.snmp_privacy_passphase
        if self.snmp_privacy_protocol is not None:
            result['SnmpPrivacyProtocol'] = self.snmp_privacy_protocol
        if self.ext_attributes is not None:
            result['ExtAttributes'] = self.ext_attributes
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeviceFormId') is not None:
            self.device_form_id = m.get('DeviceFormId')
        if m.get('PhysicalSpaceId') is not None:
            self.physical_space_id = m.get('PhysicalSpaceId')
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('Ip') is not None:
            self.ip = m.get('Ip')
        if m.get('Sn') is not None:
            self.sn = m.get('Sn')
        if m.get('Mac') is not None:
            self.mac = m.get('Mac')
        if m.get('Vendor') is not None:
            self.vendor = m.get('Vendor')
        if m.get('Model') is not None:
            self.model = m.get('Model')
        if m.get('ServiceStatus') is not None:
            self.service_status = m.get('ServiceStatus')
        if m.get('SecurityDomain') is not None:
            self.security_domain = m.get('SecurityDomain')
        if m.get('LoginType') is not None:
            self.login_type = m.get('LoginType')
        if m.get('LoginUsername') is not None:
            self.login_username = m.get('LoginUsername')
        if m.get('LoginPassword') is not None:
            self.login_password = m.get('LoginPassword')
        if m.get('SnmpAccountVersion') is not None:
            self.snmp_account_version = m.get('SnmpAccountVersion')
        if m.get('SnmpCommunity') is not None:
            self.snmp_community = m.get('SnmpCommunity')
        if m.get('SnmpAccountType') is not None:
            self.snmp_account_type = m.get('SnmpAccountType')
        if m.get('SnmpSecurityLevel') is not None:
            self.snmp_security_level = m.get('SnmpSecurityLevel')
        if m.get('SnmpUsername') is not None:
            self.snmp_username = m.get('SnmpUsername')
        if m.get('SnmpAuthPassphrase') is not None:
            self.snmp_auth_passphrase = m.get('SnmpAuthPassphrase')
        if m.get('SnmpAuthProtocol') is not None:
            self.snmp_auth_protocol = m.get('SnmpAuthProtocol')
        if m.get('SnmpPrivacyPassphase') is not None:
            self.snmp_privacy_passphase = m.get('SnmpPrivacyPassphase')
        if m.get('SnmpPrivacyProtocol') is not None:
            self.snmp_privacy_protocol = m.get('SnmpPrivacyProtocol')
        if m.get('ExtAttributes') is not None:
            self.ext_attributes = m.get('ExtAttributes')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class CreateDeviceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        device_id: str = None,
    ):
        # Id of the request
        self.request_id = request_id
        # 资源实例ID，如ECS实例的创建接口CreateInstance应返回InstanceId。
        self.device_id = device_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        return self


class CreateDeviceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateDeviceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateDeviceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateSetupProjectRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        delivery_time: str = None,
        space_id: str = None,
        description: str = None,
    ):
        # instanceId
        self.instance_id = instance_id
        # 创建时间
        self.delivery_time = delivery_time
        # 物理空间uId
        self.space_id = space_id
        # 描述
        self.description = description

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.delivery_time is not None:
            result['DeliveryTime'] = self.delivery_time
        if self.space_id is not None:
            result['SpaceId'] = self.space_id
        if self.description is not None:
            result['Description'] = self.description
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('DeliveryTime') is not None:
            self.delivery_time = m.get('DeliveryTime')
        if m.get('SpaceId') is not None:
            self.space_id = m.get('SpaceId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        return self


class CreateSetupProjectResponseBody(TeaModel):
    def __init__(
        self,
        setup_project_id: str = None,
        request_id: str = None,
    ):
        # 资源实例ID，如ECS实例的创建接口CreateInstance应返回InstanceId。
        self.setup_project_id = setup_project_id
        # Id of the request
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.setup_project_id is not None:
            result['SetupProjectId'] = self.setup_project_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SetupProjectId') is not None:
            self.setup_project_id = m.get('SetupProjectId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateSetupProjectResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateSetupProjectResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateSetupProjectResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class UpdateDedicatedLineRequest(TeaModel):
    def __init__(
        self,
        dedicated_line_id: str = None,
        isp: str = None,
        bandwidth: int = None,
        dedicated_line_ip: str = None,
        dedicated_line_gateway: str = None,
        dedicated_line_role: str = None,
        device_id: str = None,
        device_port: str = None,
        instance_id: str = None,
    ):
        # 实例 ID。
        self.dedicated_line_id = dedicated_line_id
        # 运营商
        self.isp = isp
        # 宽带（Mbps）
        self.bandwidth = bandwidth
        # 专线IP
        self.dedicated_line_ip = dedicated_line_ip
        # 专线网关
        self.dedicated_line_gateway = dedicated_line_gateway
        # 专线角色
        self.dedicated_line_role = dedicated_line_role
        # 关联设备ID
        self.device_id = device_id
        # 关联设备端口名称
        self.device_port = device_port
        # 实例ID
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dedicated_line_id is not None:
            result['DedicatedLineId'] = self.dedicated_line_id
        if self.isp is not None:
            result['Isp'] = self.isp
        if self.bandwidth is not None:
            result['Bandwidth'] = self.bandwidth
        if self.dedicated_line_ip is not None:
            result['DedicatedLineIp'] = self.dedicated_line_ip
        if self.dedicated_line_gateway is not None:
            result['DedicatedLineGateway'] = self.dedicated_line_gateway
        if self.dedicated_line_role is not None:
            result['DedicatedLineRole'] = self.dedicated_line_role
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.device_port is not None:
            result['DevicePort'] = self.device_port
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DedicatedLineId') is not None:
            self.dedicated_line_id = m.get('DedicatedLineId')
        if m.get('Isp') is not None:
            self.isp = m.get('Isp')
        if m.get('Bandwidth') is not None:
            self.bandwidth = m.get('Bandwidth')
        if m.get('DedicatedLineIp') is not None:
            self.dedicated_line_ip = m.get('DedicatedLineIp')
        if m.get('DedicatedLineGateway') is not None:
            self.dedicated_line_gateway = m.get('DedicatedLineGateway')
        if m.get('DedicatedLineRole') is not None:
            self.dedicated_line_role = m.get('DedicatedLineRole')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('DevicePort') is not None:
            self.device_port = m.get('DevicePort')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class UpdateDedicatedLineResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # Id of the request
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class UpdateDedicatedLineResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: UpdateDedicatedLineResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = UpdateDedicatedLineResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetOsVersionRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        os_version_id: str = None,
    ):
        self.instance_id = instance_id
        # 实例 ID。
        self.os_version_id = os_version_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.os_version_id is not None:
            result['OsVersionId'] = self.os_version_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('OsVersionId') is not None:
            self.os_version_id = m.get('OsVersionId')
        return self


class GetOsVersionResponseBodyOsVersion(TeaModel):
    def __init__(
        self,
        download_path: str = None,
    ):
        # 下载路径
        self.download_path = download_path

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.download_path is not None:
            result['DownloadPath'] = self.download_path
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DownloadPath') is not None:
            self.download_path = m.get('DownloadPath')
        return self


class GetOsVersionResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        os_version: List[GetOsVersionResponseBodyOsVersion] = None,
    ):
        # Id of the request
        self.request_id = request_id
        # 数组，返回示例目录。
        self.os_version = os_version

    def validate(self):
        if self.os_version:
            for k in self.os_version:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['OsVersion'] = []
        if self.os_version is not None:
            for k in self.os_version:
                result['OsVersion'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.os_version = []
        if m.get('OsVersion') is not None:
            for k in m.get('OsVersion'):
                temp_model = GetOsVersionResponseBodyOsVersion()
                self.os_version.append(temp_model.from_map(k))
        return self


class GetOsVersionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetOsVersionResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetOsVersionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class UpdateScheduleDutyRequestTypeWorkerList(TeaModel):
    def __init__(
        self,
        schedule_type_id: str = None,
        schedule_worker_name: List[str] = None,
    ):
        # scheduleTypeId
        self.schedule_type_id = schedule_type_id
        # 值班人员姓名
        self.schedule_worker_name = schedule_worker_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.schedule_type_id is not None:
            result['ScheduleTypeId'] = self.schedule_type_id
        if self.schedule_worker_name is not None:
            result['ScheduleWorkerName'] = self.schedule_worker_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ScheduleTypeId') is not None:
            self.schedule_type_id = m.get('ScheduleTypeId')
        if m.get('ScheduleWorkerName') is not None:
            self.schedule_worker_name = m.get('ScheduleWorkerName')
        return self


class UpdateScheduleDutyRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        schedule_duty_id: str = None,
        type_worker_list: List[UpdateScheduleDutyRequestTypeWorkerList] = None,
    ):
        # instanceId
        self.instance_id = instance_id
        # 资源一级ID
        self.schedule_duty_id = schedule_duty_id
        # typeWorkerList
        self.type_worker_list = type_worker_list

    def validate(self):
        if self.type_worker_list:
            for k in self.type_worker_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.schedule_duty_id is not None:
            result['ScheduleDutyId'] = self.schedule_duty_id
        result['TypeWorkerList'] = []
        if self.type_worker_list is not None:
            for k in self.type_worker_list:
                result['TypeWorkerList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ScheduleDutyId') is not None:
            self.schedule_duty_id = m.get('ScheduleDutyId')
        self.type_worker_list = []
        if m.get('TypeWorkerList') is not None:
            for k in m.get('TypeWorkerList'):
                temp_model = UpdateScheduleDutyRequestTypeWorkerList()
                self.type_worker_list.append(temp_model.from_map(k))
        return self


class UpdateScheduleDutyShrinkRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        schedule_duty_id: str = None,
        type_worker_list_shrink: str = None,
    ):
        # instanceId
        self.instance_id = instance_id
        # 资源一级ID
        self.schedule_duty_id = schedule_duty_id
        # typeWorkerList
        self.type_worker_list_shrink = type_worker_list_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.schedule_duty_id is not None:
            result['ScheduleDutyId'] = self.schedule_duty_id
        if self.type_worker_list_shrink is not None:
            result['TypeWorkerList'] = self.type_worker_list_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ScheduleDutyId') is not None:
            self.schedule_duty_id = m.get('ScheduleDutyId')
        if m.get('TypeWorkerList') is not None:
            self.type_worker_list_shrink = m.get('TypeWorkerList')
        return self


class UpdateScheduleDutyResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # Id of the request
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class UpdateScheduleDutyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: UpdateScheduleDutyResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = UpdateScheduleDutyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateIpRecordRequestDeviceZoneLayer(TeaModel):
    def __init__(
        self,
        name: str = None,
        value: str = None,
    ):
        # 园区层级名称
        self.name = name
        # 园区层级值
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateIpRecordRequestDevice(TeaModel):
    def __init__(
        self,
        device_name: str = None,
        port: str = None,
        remote_device_name: str = None,
        remote_port: str = None,
        device_mac: str = None,
        zone_layer: List[CreateIpRecordRequestDeviceZoneLayer] = None,
    ):
        # 设备名称
        self.device_name = device_name
        # 设备端口
        self.port = port
        # 对端设备名称
        self.remote_device_name = remote_device_name
        # 对端设备端口
        self.remote_port = remote_port
        # 设备MAC
        self.device_mac = device_mac
        # 园区层级
        self.zone_layer = zone_layer

    def validate(self):
        if self.zone_layer:
            for k in self.zone_layer:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.port is not None:
            result['Port'] = self.port
        if self.remote_device_name is not None:
            result['RemoteDeviceName'] = self.remote_device_name
        if self.remote_port is not None:
            result['RemotePort'] = self.remote_port
        if self.device_mac is not None:
            result['DeviceMac'] = self.device_mac
        result['ZoneLayer'] = []
        if self.zone_layer is not None:
            for k in self.zone_layer:
                result['ZoneLayer'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('RemoteDeviceName') is not None:
            self.remote_device_name = m.get('RemoteDeviceName')
        if m.get('RemotePort') is not None:
            self.remote_port = m.get('RemotePort')
        if m.get('DeviceMac') is not None:
            self.device_mac = m.get('DeviceMac')
        self.zone_layer = []
        if m.get('ZoneLayer') is not None:
            for k in m.get('ZoneLayer'):
                temp_model = CreateIpRecordRequestDeviceZoneLayer()
                self.zone_layer.append(temp_model.from_map(k))
        return self


class CreateIpRecordRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        ip_record_name: str = None,
        business_type_id: str = None,
        creator: str = None,
        device: List[CreateIpRecordRequestDevice] = None,
        record_type: str = None,
        ip_code: List[str] = None,
        client_token: str = None,
    ):
        self.instance_id = instance_id
        # 资源名称
        self.ip_record_name = ip_record_name
        # 业务类型uuid
        self.business_type_id = business_type_id
        # 创建人
        self.creator = creator
        # 设备列表
        self.device = device
        # 工单类型 Apply 申请工单 Recycle 释放工单
        self.record_type = record_type
        # IP地址列表
        self.ip_code = ip_code
        # 幂等参数
        self.client_token = client_token

    def validate(self):
        if self.device:
            for k in self.device:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.ip_record_name is not None:
            result['IpRecordName'] = self.ip_record_name
        if self.business_type_id is not None:
            result['BusinessTypeId'] = self.business_type_id
        if self.creator is not None:
            result['Creator'] = self.creator
        result['Device'] = []
        if self.device is not None:
            for k in self.device:
                result['Device'].append(k.to_map() if k else None)
        if self.record_type is not None:
            result['RecordType'] = self.record_type
        if self.ip_code is not None:
            result['IpCode'] = self.ip_code
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IpRecordName') is not None:
            self.ip_record_name = m.get('IpRecordName')
        if m.get('BusinessTypeId') is not None:
            self.business_type_id = m.get('BusinessTypeId')
        if m.get('Creator') is not None:
            self.creator = m.get('Creator')
        self.device = []
        if m.get('Device') is not None:
            for k in m.get('Device'):
                temp_model = CreateIpRecordRequestDevice()
                self.device.append(temp_model.from_map(k))
        if m.get('RecordType') is not None:
            self.record_type = m.get('RecordType')
        if m.get('IpCode') is not None:
            self.ip_code = m.get('IpCode')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        return self


class CreateIpRecordShrinkRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        ip_record_name: str = None,
        business_type_id: str = None,
        creator: str = None,
        device_shrink: str = None,
        record_type: str = None,
        ip_code_shrink: str = None,
        client_token: str = None,
    ):
        self.instance_id = instance_id
        # 资源名称
        self.ip_record_name = ip_record_name
        # 业务类型uuid
        self.business_type_id = business_type_id
        # 创建人
        self.creator = creator
        # 设备列表
        self.device_shrink = device_shrink
        # 工单类型 Apply 申请工单 Recycle 释放工单
        self.record_type = record_type
        # IP地址列表
        self.ip_code_shrink = ip_code_shrink
        # 幂等参数
        self.client_token = client_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.ip_record_name is not None:
            result['IpRecordName'] = self.ip_record_name
        if self.business_type_id is not None:
            result['BusinessTypeId'] = self.business_type_id
        if self.creator is not None:
            result['Creator'] = self.creator
        if self.device_shrink is not None:
            result['Device'] = self.device_shrink
        if self.record_type is not None:
            result['RecordType'] = self.record_type
        if self.ip_code_shrink is not None:
            result['IpCode'] = self.ip_code_shrink
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IpRecordName') is not None:
            self.ip_record_name = m.get('IpRecordName')
        if m.get('BusinessTypeId') is not None:
            self.business_type_id = m.get('BusinessTypeId')
        if m.get('Creator') is not None:
            self.creator = m.get('Creator')
        if m.get('Device') is not None:
            self.device_shrink = m.get('Device')
        if m.get('RecordType') is not None:
            self.record_type = m.get('RecordType')
        if m.get('IpCode') is not None:
            self.ip_code_shrink = m.get('IpCode')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        return self


class CreateIpRecordResponseBody(TeaModel):
    def __init__(
        self,
        ip_record_id: str = None,
        request_id: str = None,
        job_id: str = None,
    ):
        # 资源实例ID，如ECS实例的创建接口CreateInstance应返回InstanceId。
        self.ip_record_id = ip_record_id
        # Id of the request
        self.request_id = request_id
        # 若创建接口为异步实现，则需返回明确的JobId。
        self.job_id = job_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ip_record_id is not None:
            result['IpRecordId'] = self.ip_record_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IpRecordId') is not None:
            self.ip_record_id = m.get('IpRecordId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class CreateIpRecordResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateIpRecordResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateIpRecordResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListInstancesResponseBodyInstances(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        instance_name: str = None,
        instance_spec: str = None,
        instance_open_date: str = None,
        instance_end_date: str = None,
        instance_device_max_count: str = None,
    ):
        # 实例ID
        self.instance_id = instance_id
        # 实例名称
        self.instance_name = instance_name
        # 实例规格
        self.instance_spec = instance_spec
        # 实例开通时间
        self.instance_open_date = instance_open_date
        # 实例到期时间
        self.instance_end_date = instance_end_date
        # 最大纳管设备数量
        self.instance_device_max_count = instance_device_max_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.instance_spec is not None:
            result['InstanceSpec'] = self.instance_spec
        if self.instance_open_date is not None:
            result['InstanceOpenDate'] = self.instance_open_date
        if self.instance_end_date is not None:
            result['InstanceEndDate'] = self.instance_end_date
        if self.instance_device_max_count is not None:
            result['InstanceDeviceMaxCount'] = self.instance_device_max_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('InstanceSpec') is not None:
            self.instance_spec = m.get('InstanceSpec')
        if m.get('InstanceOpenDate') is not None:
            self.instance_open_date = m.get('InstanceOpenDate')
        if m.get('InstanceEndDate') is not None:
            self.instance_end_date = m.get('InstanceEndDate')
        if m.get('InstanceDeviceMaxCount') is not None:
            self.instance_device_max_count = m.get('InstanceDeviceMaxCount')
        return self


class ListInstancesResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        instances: List[ListInstancesResponseBodyInstances] = None,
    ):
        # Id of the request
        self.request_id = request_id
        # 实例列表
        self.instances = instances

    def validate(self):
        if self.instances:
            for k in self.instances:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['Instances'] = []
        if self.instances is not None:
            for k in self.instances:
                result['Instances'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.instances = []
        if m.get('Instances') is not None:
            for k in m.get('Instances'):
                temp_model = ListInstancesResponseBodyInstances()
                self.instances.append(temp_model.from_map(k))
        return self


class ListInstancesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListInstancesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListInstancesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListZoneTypesRequest(TeaModel):
    def __init__(
        self,
        name: str = None,
        max_results: int = None,
        next_token: str = None,
        instance_id: str = None,
    ):
        # 园区类型名称
        self.name = name
        # 返回结果的最大个数。
        self.max_results = max_results
        # 当总结果个数大于MaxResults时，用于翻页的token。
        self.next_token = next_token
        # 实例ID
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class ListZoneTypesResponseBodyZoneTypeZoneTypeLayer(TeaModel):
    def __init__(
        self,
        name: str = None,
        mask: int = None,
    ):
        # 园区层级名称
        self.name = name
        # 园区层级掩码
        self.mask = mask

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.mask is not None:
            result['Mask'] = self.mask
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Mask') is not None:
            self.mask = m.get('Mask')
        return self


class ListZoneTypesResponseBodyZoneType(TeaModel):
    def __init__(
        self,
        name: str = None,
        zone_type_name: str = None,
        zone_type_layer: List[ListZoneTypesResponseBodyZoneTypeZoneTypeLayer] = None,
        create_time: str = None,
        zone_type_id: str = None,
    ):
        # 园区类型名称
        self.name = name
        # 资源名称
        self.zone_type_name = zone_type_name
        # 园区层级
        self.zone_type_layer = zone_type_layer
        # 创建时间
        self.create_time = create_time
        # 资源一级ID
        self.zone_type_id = zone_type_id

    def validate(self):
        if self.zone_type_layer:
            for k in self.zone_type_layer:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.zone_type_name is not None:
            result['ZoneTypeName'] = self.zone_type_name
        result['ZoneTypeLayer'] = []
        if self.zone_type_layer is not None:
            for k in self.zone_type_layer:
                result['ZoneTypeLayer'].append(k.to_map() if k else None)
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.zone_type_id is not None:
            result['ZoneTypeId'] = self.zone_type_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ZoneTypeName') is not None:
            self.zone_type_name = m.get('ZoneTypeName')
        self.zone_type_layer = []
        if m.get('ZoneTypeLayer') is not None:
            for k in m.get('ZoneTypeLayer'):
                temp_model = ListZoneTypesResponseBodyZoneTypeZoneTypeLayer()
                self.zone_type_layer.append(temp_model.from_map(k))
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('ZoneTypeId') is not None:
            self.zone_type_id = m.get('ZoneTypeId')
        return self


class ListZoneTypesResponseBody(TeaModel):
    def __init__(
        self,
        total_count: int = None,
        max_results: int = None,
        request_id: str = None,
        next_token: int = None,
        zone_type: List[ListZoneTypesResponseBodyZoneType] = None,
    ):
        # 总记录数。
        self.total_count = total_count
        # 本次读取的最大数据量
        self.max_results = max_results
        # Id of the request
        self.request_id = request_id
        # 当总结果个数大于MaxResults时，用于翻页的token。
        self.next_token = next_token
        # 数组，返回示例目录。
        self.zone_type = zone_type

    def validate(self):
        if self.zone_type:
            for k in self.zone_type:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        result['ZoneType'] = []
        if self.zone_type is not None:
            for k in self.zone_type:
                result['ZoneType'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        self.zone_type = []
        if m.get('ZoneType') is not None:
            for k in m.get('ZoneType'):
                temp_model = ListZoneTypesResponseBodyZoneType()
                self.zone_type.append(temp_model.from_map(k))
        return self


class ListZoneTypesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListZoneTypesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListZoneTypesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class UpdatePhysicalSpaceRequest(TeaModel):
    def __init__(
        self,
        physical_space_id: str = None,
        physical_space_name: str = None,
        country: str = None,
        province: str = None,
        city: str = None,
        address: str = None,
        instance_id: str = None,
        owner: str = None,
        space_abbreviation: str = None,
        space_type: str = None,
    ):
        # 实例 ID。
        self.physical_space_id = physical_space_id
        # 物理空间名称
        self.physical_space_name = physical_space_name
        # 所属国家
        self.country = country
        # 所属省份
        self.province = province
        # 所属城市
        self.city = city
        # 具体地址
        self.address = address
        # 实例ID
        self.instance_id = instance_id
        # 负责人
        self.owner = owner
        # 缩写
        self.space_abbreviation = space_abbreviation
        # 模型
        self.space_type = space_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.physical_space_id is not None:
            result['PhysicalSpaceId'] = self.physical_space_id
        if self.physical_space_name is not None:
            result['PhysicalSpaceName'] = self.physical_space_name
        if self.country is not None:
            result['Country'] = self.country
        if self.province is not None:
            result['Province'] = self.province
        if self.city is not None:
            result['City'] = self.city
        if self.address is not None:
            result['Address'] = self.address
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.space_abbreviation is not None:
            result['SpaceAbbreviation'] = self.space_abbreviation
        if self.space_type is not None:
            result['SpaceType'] = self.space_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PhysicalSpaceId') is not None:
            self.physical_space_id = m.get('PhysicalSpaceId')
        if m.get('PhysicalSpaceName') is not None:
            self.physical_space_name = m.get('PhysicalSpaceName')
        if m.get('Country') is not None:
            self.country = m.get('Country')
        if m.get('Province') is not None:
            self.province = m.get('Province')
        if m.get('City') is not None:
            self.city = m.get('City')
        if m.get('Address') is not None:
            self.address = m.get('Address')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('SpaceAbbreviation') is not None:
            self.space_abbreviation = m.get('SpaceAbbreviation')
        if m.get('SpaceType') is not None:
            self.space_type = m.get('SpaceType')
        return self


class UpdatePhysicalSpaceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # Id of the request
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class UpdatePhysicalSpaceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: UpdatePhysicalSpaceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = UpdatePhysicalSpaceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class UpdateResourceInstanceRequestResourceInformation(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        # 键
        self.key = key
        # 值
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class UpdateResourceInstanceRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        resource_information_id: str = None,
        setup_project_id: str = None,
        resource_information: List[UpdateResourceInstanceRequestResourceInformation] = None,
    ):
        self.instance_id = instance_id
        # 资源id
        self.resource_information_id = resource_information_id
        # 建设项目资源uuid
        self.setup_project_id = setup_project_id
        # 数据
        self.resource_information = resource_information

    def validate(self):
        if self.resource_information:
            for k in self.resource_information:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.resource_information_id is not None:
            result['ResourceInformationId'] = self.resource_information_id
        if self.setup_project_id is not None:
            result['SetupProjectId'] = self.setup_project_id
        result['ResourceInformation'] = []
        if self.resource_information is not None:
            for k in self.resource_information:
                result['ResourceInformation'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ResourceInformationId') is not None:
            self.resource_information_id = m.get('ResourceInformationId')
        if m.get('SetupProjectId') is not None:
            self.setup_project_id = m.get('SetupProjectId')
        self.resource_information = []
        if m.get('ResourceInformation') is not None:
            for k in m.get('ResourceInformation'):
                temp_model = UpdateResourceInstanceRequestResourceInformation()
                self.resource_information.append(temp_model.from_map(k))
        return self


class UpdateResourceInstanceShrinkRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        resource_information_id: str = None,
        setup_project_id: str = None,
        resource_information_shrink: str = None,
    ):
        self.instance_id = instance_id
        # 资源id
        self.resource_information_id = resource_information_id
        # 建设项目资源uuid
        self.setup_project_id = setup_project_id
        # 数据
        self.resource_information_shrink = resource_information_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.resource_information_id is not None:
            result['ResourceInformationId'] = self.resource_information_id
        if self.setup_project_id is not None:
            result['SetupProjectId'] = self.setup_project_id
        if self.resource_information_shrink is not None:
            result['ResourceInformation'] = self.resource_information_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ResourceInformationId') is not None:
            self.resource_information_id = m.get('ResourceInformationId')
        if m.get('SetupProjectId') is not None:
            self.setup_project_id = m.get('SetupProjectId')
        if m.get('ResourceInformation') is not None:
            self.resource_information_shrink = m.get('ResourceInformation')
        return self


class UpdateResourceInstanceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # Id of the request
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class UpdateResourceInstanceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: UpdateResourceInstanceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = UpdateResourceInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetScheduleDutyRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        schedule_duty_id: str = None,
    ):
        # instanceId
        self.instance_id = instance_id
        # scheduleDutyId
        self.schedule_duty_id = schedule_duty_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.schedule_duty_id is not None:
            result['ScheduleDutyId'] = self.schedule_duty_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ScheduleDutyId') is not None:
            self.schedule_duty_id = m.get('ScheduleDutyId')
        return self


class GetScheduleDutyResponseBodyScheduleDuty(TeaModel):
    def __init__(
        self,
        work_type: str = None,
        create_time: str = None,
        update_time: str = None,
        work_date: str = None,
        worker_id: str = None,
        schedule_duty_id: str = None,
        worker_name: str = None,
    ):
        # 值班表类型
        self.work_type = work_type
        # 创建时间
        self.create_time = create_time
        # 更新时间
        self.update_time = update_time
        # 值班表日期
        self.work_date = work_date
        # 值班人员工号
        self.worker_id = worker_id
        # 资源一级ID
        self.schedule_duty_id = schedule_duty_id
        # 值班人员姓名
        self.worker_name = worker_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.work_type is not None:
            result['WorkType'] = self.work_type
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        if self.work_date is not None:
            result['WorkDate'] = self.work_date
        if self.worker_id is not None:
            result['WorkerId'] = self.worker_id
        if self.schedule_duty_id is not None:
            result['ScheduleDutyId'] = self.schedule_duty_id
        if self.worker_name is not None:
            result['WorkerName'] = self.worker_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('WorkType') is not None:
            self.work_type = m.get('WorkType')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        if m.get('WorkDate') is not None:
            self.work_date = m.get('WorkDate')
        if m.get('WorkerId') is not None:
            self.worker_id = m.get('WorkerId')
        if m.get('ScheduleDutyId') is not None:
            self.schedule_duty_id = m.get('ScheduleDutyId')
        if m.get('WorkerName') is not None:
            self.worker_name = m.get('WorkerName')
        return self


class GetScheduleDutyResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        schedule_duty: GetScheduleDutyResponseBodyScheduleDuty = None,
    ):
        # Id of the request
        self.request_id = request_id
        # 值班表对象
        self.schedule_duty = schedule_duty

    def validate(self):
        if self.schedule_duty:
            self.schedule_duty.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.schedule_duty is not None:
            result['ScheduleDuty'] = self.schedule_duty.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ScheduleDuty') is not None:
            temp_model = GetScheduleDutyResponseBodyScheduleDuty()
            self.schedule_duty = temp_model.from_map(m['ScheduleDuty'])
        return self


class GetScheduleDutyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetScheduleDutyResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetScheduleDutyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetConfigurationVariateRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        configuration_variate_id: str = None,
    ):
        # instanceId
        self.instance_id = instance_id
        # 实例 ID。
        self.configuration_variate_id = configuration_variate_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.configuration_variate_id is not None:
            result['ConfigurationVariateId'] = self.configuration_variate_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ConfigurationVariateId') is not None:
            self.configuration_variate_id = m.get('ConfigurationVariateId')
        return self


class GetConfigurationVariateResponseBodyConfigurationVariate(TeaModel):
    def __init__(
        self,
        variate_name: str = None,
        comment: str = None,
        format_function: str = None,
    ):
        # project
        self.variate_name = variate_name
        # 变量描述
        self.comment = comment
        # 转换函数
        self.format_function = format_function

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.variate_name is not None:
            result['VariateName'] = self.variate_name
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.format_function is not None:
            result['FormatFunction'] = self.format_function
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('VariateName') is not None:
            self.variate_name = m.get('VariateName')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('FormatFunction') is not None:
            self.format_function = m.get('FormatFunction')
        return self


class GetConfigurationVariateResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        configuration_variate: GetConfigurationVariateResponseBodyConfigurationVariate = None,
    ):
        # Id of the request
        self.request_id = request_id
        # 资源对象
        self.configuration_variate = configuration_variate

    def validate(self):
        if self.configuration_variate:
            self.configuration_variate.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.configuration_variate is not None:
            result['ConfigurationVariate'] = self.configuration_variate.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ConfigurationVariate') is not None:
            temp_model = GetConfigurationVariateResponseBodyConfigurationVariate()
            self.configuration_variate = temp_model.from_map(m['ConfigurationVariate'])
        return self


class GetConfigurationVariateResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetConfigurationVariateResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetConfigurationVariateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetAlarmStatusRequest(TeaModel):
    def __init__(
        self,
        device_id: str = None,
        monitor_item_id: str = None,
        type: str = None,
        aggregate_data_id: str = None,
        dedicated_line_id: str = None,
        instance_id: str = None,
        port_collection_id: str = None,
    ):
        # 设备ID
        self.device_id = device_id
        # 监控项ID
        self.monitor_item_id = monitor_item_id
        # 数据类型
        self.type = type
        # 聚合数据ID
        self.aggregate_data_id = aggregate_data_id
        # 专线ID
        self.dedicated_line_id = dedicated_line_id
        # 实例ID
        self.instance_id = instance_id
        # 端口集ID
        self.port_collection_id = port_collection_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.monitor_item_id is not None:
            result['MonitorItemId'] = self.monitor_item_id
        if self.type is not None:
            result['Type'] = self.type
        if self.aggregate_data_id is not None:
            result['AggregateDataId'] = self.aggregate_data_id
        if self.dedicated_line_id is not None:
            result['DedicatedLineId'] = self.dedicated_line_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.port_collection_id is not None:
            result['PortCollectionId'] = self.port_collection_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('MonitorItemId') is not None:
            self.monitor_item_id = m.get('MonitorItemId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('AggregateDataId') is not None:
            self.aggregate_data_id = m.get('AggregateDataId')
        if m.get('DedicatedLineId') is not None:
            self.dedicated_line_id = m.get('DedicatedLineId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PortCollectionId') is not None:
            self.port_collection_id = m.get('PortCollectionId')
        return self


class GetAlarmStatusResponseBodyAlarmStatusResourceDevice(TeaModel):
    def __init__(
        self,
        host_name: str = None,
        ip: str = None,
        vendor: str = None,
        model: str = None,
        status: str = None,
        sn: str = None,
        space: str = None,
        device_id: str = None,
        security_domain: str = None,
        device_form: str = None,
    ):
        # 设备名
        self.host_name = host_name
        # IP
        self.ip = ip
        # 厂商
        self.vendor = vendor
        # 型号
        self.model = model
        # 状态
        self.status = status
        # sn
        self.sn = sn
        # 物理空间
        self.space = space
        # 设备ID
        self.device_id = device_id
        # 安全域
        self.security_domain = security_domain
        # 设备形态
        self.device_form = device_form

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.ip is not None:
            result['Ip'] = self.ip
        if self.vendor is not None:
            result['Vendor'] = self.vendor
        if self.model is not None:
            result['Model'] = self.model
        if self.status is not None:
            result['Status'] = self.status
        if self.sn is not None:
            result['Sn'] = self.sn
        if self.space is not None:
            result['Space'] = self.space
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.security_domain is not None:
            result['SecurityDomain'] = self.security_domain
        if self.device_form is not None:
            result['DeviceForm'] = self.device_form
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('Ip') is not None:
            self.ip = m.get('Ip')
        if m.get('Vendor') is not None:
            self.vendor = m.get('Vendor')
        if m.get('Model') is not None:
            self.model = m.get('Model')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Sn') is not None:
            self.sn = m.get('Sn')
        if m.get('Space') is not None:
            self.space = m.get('Space')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('SecurityDomain') is not None:
            self.security_domain = m.get('SecurityDomain')
        if m.get('DeviceForm') is not None:
            self.device_form = m.get('DeviceForm')
        return self


class GetAlarmStatusResponseBodyAlarmStatusMonitorItem(TeaModel):
    def __init__(
        self,
        monitor_item_name: str = None,
        monitor_item_description: str = None,
        security_domain: str = None,
        collection_type: str = None,
        exec_interval: str = None,
        monitor_item_id: str = None,
        device_form: str = None,
        effective: int = None,
    ):
        # 监控项名称
        self.monitor_item_name = monitor_item_name
        # 描述
        self.monitor_item_description = monitor_item_description
        # 安全域
        self.security_domain = security_domain
        # 采集类型
        self.collection_type = collection_type
        # 执行间隔
        self.exec_interval = exec_interval
        # 监控项ID
        self.monitor_item_id = monitor_item_id
        # 设备形态
        self.device_form = device_form
        # 是否启用
        self.effective = effective

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.monitor_item_name is not None:
            result['MonitorItemName'] = self.monitor_item_name
        if self.monitor_item_description is not None:
            result['MonitorItemDescription'] = self.monitor_item_description
        if self.security_domain is not None:
            result['SecurityDomain'] = self.security_domain
        if self.collection_type is not None:
            result['CollectionType'] = self.collection_type
        if self.exec_interval is not None:
            result['ExecInterval'] = self.exec_interval
        if self.monitor_item_id is not None:
            result['MonitorItemId'] = self.monitor_item_id
        if self.device_form is not None:
            result['DeviceForm'] = self.device_form
        if self.effective is not None:
            result['Effective'] = self.effective
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MonitorItemName') is not None:
            self.monitor_item_name = m.get('MonitorItemName')
        if m.get('MonitorItemDescription') is not None:
            self.monitor_item_description = m.get('MonitorItemDescription')
        if m.get('SecurityDomain') is not None:
            self.security_domain = m.get('SecurityDomain')
        if m.get('CollectionType') is not None:
            self.collection_type = m.get('CollectionType')
        if m.get('ExecInterval') is not None:
            self.exec_interval = m.get('ExecInterval')
        if m.get('MonitorItemId') is not None:
            self.monitor_item_id = m.get('MonitorItemId')
        if m.get('DeviceForm') is not None:
            self.device_form = m.get('DeviceForm')
        if m.get('Effective') is not None:
            self.effective = m.get('Effective')
        return self


class GetAlarmStatusResponseBodyAlarmStatusNotificationSwitch(TeaModel):
    def __init__(
        self,
        reason: str = None,
        expiry_time: str = None,
    ):
        # 关闭原因
        self.reason = reason
        # 关闭到期时间
        self.expiry_time = expiry_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.reason is not None:
            result['Reason'] = self.reason
        if self.expiry_time is not None:
            result['ExpiryTime'] = self.expiry_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Reason') is not None:
            self.reason = m.get('Reason')
        if m.get('ExpiryTime') is not None:
            self.expiry_time = m.get('ExpiryTime')
        return self


class GetAlarmStatusResponseBodyAlarmStatusAggregateData(TeaModel):
    def __init__(
        self,
        aggregate_mode: str = None,
        aggregate_data_description: str = None,
        data_item: str = None,
        aggregate_data_name: str = None,
        device_id: str = None,
        is_all_device: int = None,
        aggregate_data_id: str = None,
        monitor_item_id: str = None,
    ):
        # 聚合方式
        self.aggregate_mode = aggregate_mode
        # 描述
        self.aggregate_data_description = aggregate_data_description
        # 数据项
        self.data_item = data_item
        # 聚合数据名称
        self.aggregate_data_name = aggregate_data_name
        # 设备ID
        self.device_id = device_id
        # 是否聚合全部设备
        self.is_all_device = is_all_device
        # 聚合数据ID
        self.aggregate_data_id = aggregate_data_id
        # 监控项ID
        self.monitor_item_id = monitor_item_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aggregate_mode is not None:
            result['AggregateMode'] = self.aggregate_mode
        if self.aggregate_data_description is not None:
            result['AggregateDataDescription'] = self.aggregate_data_description
        if self.data_item is not None:
            result['DataItem'] = self.data_item
        if self.aggregate_data_name is not None:
            result['AggregateDataName'] = self.aggregate_data_name
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.is_all_device is not None:
            result['IsAllDevice'] = self.is_all_device
        if self.aggregate_data_id is not None:
            result['AggregateDataId'] = self.aggregate_data_id
        if self.monitor_item_id is not None:
            result['MonitorItemId'] = self.monitor_item_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AggregateMode') is not None:
            self.aggregate_mode = m.get('AggregateMode')
        if m.get('AggregateDataDescription') is not None:
            self.aggregate_data_description = m.get('AggregateDataDescription')
        if m.get('DataItem') is not None:
            self.data_item = m.get('DataItem')
        if m.get('AggregateDataName') is not None:
            self.aggregate_data_name = m.get('AggregateDataName')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('IsAllDevice') is not None:
            self.is_all_device = m.get('IsAllDevice')
        if m.get('AggregateDataId') is not None:
            self.aggregate_data_id = m.get('AggregateDataId')
        if m.get('MonitorItemId') is not None:
            self.monitor_item_id = m.get('MonitorItemId')
        return self


class GetAlarmStatusResponseBodyAlarmStatusDedicatedLine(TeaModel):
    def __init__(
        self,
        dedicated_line_name: str = None,
        space: str = None,
        port_name: str = None,
        device_id: str = None,
        bandwidth: str = None,
        ip: str = None,
    ):
        # 专线名称
        self.dedicated_line_name = dedicated_line_name
        # 物理空间
        self.space = space
        # 端口名
        self.port_name = port_name
        # 设备ID
        self.device_id = device_id
        # 带宽
        self.bandwidth = bandwidth
        # IP
        self.ip = ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dedicated_line_name is not None:
            result['DedicatedLineName'] = self.dedicated_line_name
        if self.space is not None:
            result['Space'] = self.space
        if self.port_name is not None:
            result['PortName'] = self.port_name
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.bandwidth is not None:
            result['Bandwidth'] = self.bandwidth
        if self.ip is not None:
            result['Ip'] = self.ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DedicatedLineName') is not None:
            self.dedicated_line_name = m.get('DedicatedLineName')
        if m.get('Space') is not None:
            self.space = m.get('Space')
        if m.get('PortName') is not None:
            self.port_name = m.get('PortName')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('Bandwidth') is not None:
            self.bandwidth = m.get('Bandwidth')
        if m.get('Ip') is not None:
            self.ip = m.get('Ip')
        return self


class GetAlarmStatusResponseBodyAlarmStatusPortCollectionPortListResourceDevice(TeaModel):
    def __init__(
        self,
        host_name: str = None,
        ip: str = None,
        security_domain: str = None,
    ):
        # 设备名
        self.host_name = host_name
        # IP
        self.ip = ip
        # 安全域
        self.security_domain = security_domain

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.ip is not None:
            result['Ip'] = self.ip
        if self.security_domain is not None:
            result['SecurityDomain'] = self.security_domain
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('Ip') is not None:
            self.ip = m.get('Ip')
        if m.get('SecurityDomain') is not None:
            self.security_domain = m.get('SecurityDomain')
        return self


class GetAlarmStatusResponseBodyAlarmStatusPortCollectionPortList(TeaModel):
    def __init__(
        self,
        port_name: str = None,
        device_id: str = None,
        resource_device: GetAlarmStatusResponseBodyAlarmStatusPortCollectionPortListResourceDevice = None,
    ):
        # 端口名
        self.port_name = port_name
        # 设备ID
        self.device_id = device_id
        # 设备详情
        self.resource_device = resource_device

    def validate(self):
        if self.resource_device:
            self.resource_device.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.port_name is not None:
            result['PortName'] = self.port_name
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.resource_device is not None:
            result['ResourceDevice'] = self.resource_device.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PortName') is not None:
            self.port_name = m.get('PortName')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('ResourceDevice') is not None:
            temp_model = GetAlarmStatusResponseBodyAlarmStatusPortCollectionPortListResourceDevice()
            self.resource_device = temp_model.from_map(m['ResourceDevice'])
        return self


class GetAlarmStatusResponseBodyAlarmStatusPortCollection(TeaModel):
    def __init__(
        self,
        port_collection_name: str = None,
        port_collection_id: str = None,
        port_collection_description: str = None,
        port_list: List[GetAlarmStatusResponseBodyAlarmStatusPortCollectionPortList] = None,
    ):
        # 端口集名称
        self.port_collection_name = port_collection_name
        # 端口集ID
        self.port_collection_id = port_collection_id
        # 端口集描述
        self.port_collection_description = port_collection_description
        # 端口列表
        self.port_list = port_list

    def validate(self):
        if self.port_list:
            for k in self.port_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.port_collection_name is not None:
            result['PortCollectionName'] = self.port_collection_name
        if self.port_collection_id is not None:
            result['PortCollectionId'] = self.port_collection_id
        if self.port_collection_description is not None:
            result['PortCollectionDescription'] = self.port_collection_description
        result['PortList'] = []
        if self.port_list is not None:
            for k in self.port_list:
                result['PortList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PortCollectionName') is not None:
            self.port_collection_name = m.get('PortCollectionName')
        if m.get('PortCollectionId') is not None:
            self.port_collection_id = m.get('PortCollectionId')
        if m.get('PortCollectionDescription') is not None:
            self.port_collection_description = m.get('PortCollectionDescription')
        self.port_list = []
        if m.get('PortList') is not None:
            for k in m.get('PortList'):
                temp_model = GetAlarmStatusResponseBodyAlarmStatusPortCollectionPortList()
                self.port_list.append(temp_model.from_map(k))
        return self


class GetAlarmStatusResponseBodyAlarmStatus(TeaModel):
    def __init__(
        self,
        device_id: str = None,
        monitor_item_id: str = None,
        collection_time: str = None,
        receive_time: str = None,
        alarm_rule: str = None,
        alarm_status: str = None,
        result: str = None,
        abnormal_data_item: str = None,
        unique_key: str = None,
        response_code: str = None,
        resource_device: GetAlarmStatusResponseBodyAlarmStatusResourceDevice = None,
        monitor_item: GetAlarmStatusResponseBodyAlarmStatusMonitorItem = None,
        first_abnormal_time: str = None,
        notification_switch: GetAlarmStatusResponseBodyAlarmStatusNotificationSwitch = None,
        aggregate_data_id: str = None,
        dedicated_line_id: str = None,
        aggregate_data: GetAlarmStatusResponseBodyAlarmStatusAggregateData = None,
        dedicated_line: GetAlarmStatusResponseBodyAlarmStatusDedicatedLine = None,
        port_collection_id: str = None,
        port_collection: GetAlarmStatusResponseBodyAlarmStatusPortCollection = None,
    ):
        # 设备ID
        self.device_id = device_id
        # 监控项ID
        self.monitor_item_id = monitor_item_id
        # 采集时间
        self.collection_time = collection_time
        # 接收时间
        self.receive_time = receive_time
        # 命中告警规则
        self.alarm_rule = alarm_rule
        # 告警状态
        self.alarm_status = alarm_status
        # 采集结果
        self.result = result
        # 异常数据项
        self.abnormal_data_item = abnormal_data_item
        # 索引
        self.unique_key = unique_key
        # 采集状态码
        self.response_code = response_code
        # 设备
        self.resource_device = resource_device
        # 监控项
        self.monitor_item = monitor_item
        # 首次异常时间
        self.first_abnormal_time = first_abnormal_time
        # 告警开关
        self.notification_switch = notification_switch
        # 聚合数据ID
        self.aggregate_data_id = aggregate_data_id
        # 专线ID
        self.dedicated_line_id = dedicated_line_id
        # 聚合数据详情
        self.aggregate_data = aggregate_data
        # 专线详情
        self.dedicated_line = dedicated_line
        # 端口集ID
        self.port_collection_id = port_collection_id
        self.port_collection = port_collection

    def validate(self):
        if self.resource_device:
            self.resource_device.validate()
        if self.monitor_item:
            self.monitor_item.validate()
        if self.notification_switch:
            self.notification_switch.validate()
        if self.aggregate_data:
            self.aggregate_data.validate()
        if self.dedicated_line:
            self.dedicated_line.validate()
        if self.port_collection:
            self.port_collection.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.monitor_item_id is not None:
            result['MonitorItemId'] = self.monitor_item_id
        if self.collection_time is not None:
            result['CollectionTime'] = self.collection_time
        if self.receive_time is not None:
            result['ReceiveTime'] = self.receive_time
        if self.alarm_rule is not None:
            result['AlarmRule'] = self.alarm_rule
        if self.alarm_status is not None:
            result['AlarmStatus'] = self.alarm_status
        if self.result is not None:
            result['Result'] = self.result
        if self.abnormal_data_item is not None:
            result['AbnormalDataItem'] = self.abnormal_data_item
        if self.unique_key is not None:
            result['UniqueKey'] = self.unique_key
        if self.response_code is not None:
            result['ResponseCode'] = self.response_code
        if self.resource_device is not None:
            result['ResourceDevice'] = self.resource_device.to_map()
        if self.monitor_item is not None:
            result['MonitorItem'] = self.monitor_item.to_map()
        if self.first_abnormal_time is not None:
            result['FirstAbnormalTime'] = self.first_abnormal_time
        if self.notification_switch is not None:
            result['NotificationSwitch'] = self.notification_switch.to_map()
        if self.aggregate_data_id is not None:
            result['AggregateDataId'] = self.aggregate_data_id
        if self.dedicated_line_id is not None:
            result['DedicatedLineId'] = self.dedicated_line_id
        if self.aggregate_data is not None:
            result['AggregateData'] = self.aggregate_data.to_map()
        if self.dedicated_line is not None:
            result['DedicatedLine'] = self.dedicated_line.to_map()
        if self.port_collection_id is not None:
            result['PortCollectionId'] = self.port_collection_id
        if self.port_collection is not None:
            result['PortCollection'] = self.port_collection.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('MonitorItemId') is not None:
            self.monitor_item_id = m.get('MonitorItemId')
        if m.get('CollectionTime') is not None:
            self.collection_time = m.get('CollectionTime')
        if m.get('ReceiveTime') is not None:
            self.receive_time = m.get('ReceiveTime')
        if m.get('AlarmRule') is not None:
            self.alarm_rule = m.get('AlarmRule')
        if m.get('AlarmStatus') is not None:
            self.alarm_status = m.get('AlarmStatus')
        if m.get('Result') is not None:
            self.result = m.get('Result')
        if m.get('AbnormalDataItem') is not None:
            self.abnormal_data_item = m.get('AbnormalDataItem')
        if m.get('UniqueKey') is not None:
            self.unique_key = m.get('UniqueKey')
        if m.get('ResponseCode') is not None:
            self.response_code = m.get('ResponseCode')
        if m.get('ResourceDevice') is not None:
            temp_model = GetAlarmStatusResponseBodyAlarmStatusResourceDevice()
            self.resource_device = temp_model.from_map(m['ResourceDevice'])
        if m.get('MonitorItem') is not None:
            temp_model = GetAlarmStatusResponseBodyAlarmStatusMonitorItem()
            self.monitor_item = temp_model.from_map(m['MonitorItem'])
        if m.get('FirstAbnormalTime') is not None:
            self.first_abnormal_time = m.get('FirstAbnormalTime')
        if m.get('NotificationSwitch') is not None:
            temp_model = GetAlarmStatusResponseBodyAlarmStatusNotificationSwitch()
            self.notification_switch = temp_model.from_map(m['NotificationSwitch'])
        if m.get('AggregateDataId') is not None:
            self.aggregate_data_id = m.get('AggregateDataId')
        if m.get('DedicatedLineId') is not None:
            self.dedicated_line_id = m.get('DedicatedLineId')
        if m.get('AggregateData') is not None:
            temp_model = GetAlarmStatusResponseBodyAlarmStatusAggregateData()
            self.aggregate_data = temp_model.from_map(m['AggregateData'])
        if m.get('DedicatedLine') is not None:
            temp_model = GetAlarmStatusResponseBodyAlarmStatusDedicatedLine()
            self.dedicated_line = temp_model.from_map(m['DedicatedLine'])
        if m.get('PortCollectionId') is not None:
            self.port_collection_id = m.get('PortCollectionId')
        if m.get('PortCollection') is not None:
            temp_model = GetAlarmStatusResponseBodyAlarmStatusPortCollection()
            self.port_collection = temp_model.from_map(m['PortCollection'])
        return self


class GetAlarmStatusResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        alarm_status: GetAlarmStatusResponseBodyAlarmStatus = None,
    ):
        # request Id
        self.request_id = request_id
        # 告警状态
        self.alarm_status = alarm_status

    def validate(self):
        if self.alarm_status:
            self.alarm_status.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.alarm_status is not None:
            result['AlarmStatus'] = self.alarm_status.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('AlarmStatus') is not None:
            temp_model = GetAlarmStatusResponseBodyAlarmStatus()
            self.alarm_status = temp_model.from_map(m['AlarmStatus'])
        return self


class GetAlarmStatusResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetAlarmStatusResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetAlarmStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetIpRecordRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        ip_record_id: str = None,
    ):
        self.instance_id = instance_id
        # 实例 ID。
        self.ip_record_id = ip_record_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.ip_record_id is not None:
            result['IpRecordId'] = self.ip_record_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IpRecordId') is not None:
            self.ip_record_id = m.get('IpRecordId')
        return self


class GetIpRecordResponseBodyIpRecordDetailZoneLayer(TeaModel):
    def __init__(
        self,
        name: str = None,
        value: str = None,
    ):
        # 园区层级名称
        self.name = name
        # 园区层级值
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class GetIpRecordResponseBodyIpRecordDetail(TeaModel):
    def __init__(
        self,
        ip: str = None,
        device_name: str = None,
        port: str = None,
        remote_ip: str = None,
        remote_device_name: str = None,
        remote_port: str = None,
        device_mac: str = None,
        gateway: str = None,
        parent_ip_blocks: List[str] = None,
        zone_layer: List[GetIpRecordResponseBodyIpRecordDetailZoneLayer] = None,
    ):
        # 申请到的Ip
        self.ip = ip
        # 设备名称
        self.device_name = device_name
        # 设备端口
        self.port = port
        # 对端IP
        self.remote_ip = remote_ip
        # 对端设备名称
        self.remote_device_name = remote_device_name
        # 对端设备端口
        self.remote_port = remote_port
        # 设备MAC
        self.device_mac = device_mac
        # 网关
        self.gateway = gateway
        # 父地址段列表
        self.parent_ip_blocks = parent_ip_blocks
        # 园区层级
        self.zone_layer = zone_layer

    def validate(self):
        if self.zone_layer:
            for k in self.zone_layer:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ip is not None:
            result['Ip'] = self.ip
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.port is not None:
            result['Port'] = self.port
        if self.remote_ip is not None:
            result['RemoteIp'] = self.remote_ip
        if self.remote_device_name is not None:
            result['RemoteDeviceName'] = self.remote_device_name
        if self.remote_port is not None:
            result['RemotePort'] = self.remote_port
        if self.device_mac is not None:
            result['DeviceMac'] = self.device_mac
        if self.gateway is not None:
            result['Gateway'] = self.gateway
        if self.parent_ip_blocks is not None:
            result['ParentIpBlocks'] = self.parent_ip_blocks
        result['ZoneLayer'] = []
        if self.zone_layer is not None:
            for k in self.zone_layer:
                result['ZoneLayer'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Ip') is not None:
            self.ip = m.get('Ip')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('RemoteIp') is not None:
            self.remote_ip = m.get('RemoteIp')
        if m.get('RemoteDeviceName') is not None:
            self.remote_device_name = m.get('RemoteDeviceName')
        if m.get('RemotePort') is not None:
            self.remote_port = m.get('RemotePort')
        if m.get('DeviceMac') is not None:
            self.device_mac = m.get('DeviceMac')
        if m.get('Gateway') is not None:
            self.gateway = m.get('Gateway')
        if m.get('ParentIpBlocks') is not None:
            self.parent_ip_blocks = m.get('ParentIpBlocks')
        self.zone_layer = []
        if m.get('ZoneLayer') is not None:
            for k in m.get('ZoneLayer'):
                temp_model = GetIpRecordResponseBodyIpRecordDetailZoneLayer()
                self.zone_layer.append(temp_model.from_map(k))
        return self


class GetIpRecordResponseBodyIpRecord(TeaModel):
    def __init__(
        self,
        status: str = None,
        description: str = None,
        ip_code: List[str] = None,
        create_time: str = None,
        update_time: str = None,
        creator: str = None,
        ip_record_id: str = None,
        ip_record_name: str = None,
        zone_name: str = None,
        business_type_name: str = None,
        recode_type: str = None,
        ip_block: str = None,
        detail: List[GetIpRecordResponseBodyIpRecordDetail] = None,
    ):
        # 工单状态 running complete fail
        self.status = status
        # 备注
        self.description = description
        # IP地址列表
        self.ip_code = ip_code
        # 创建时间
        self.create_time = create_time
        # 修改时间
        self.update_time = update_time
        # 创建人
        self.creator = creator
        # 资源一级ID
        self.ip_record_id = ip_record_id
        # 资源名称
        self.ip_record_name = ip_record_name
        # 园区名
        self.zone_name = zone_name
        # 业务类型名称
        self.business_type_name = business_type_name
        # 工单类型 Apply 申请工单 Recycle 释放工单
        self.recode_type = recode_type
        # 地址段
        self.ip_block = ip_block
        # 工单详情
        self.detail = detail

    def validate(self):
        if self.detail:
            for k in self.detail:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.description is not None:
            result['Description'] = self.description
        if self.ip_code is not None:
            result['IpCode'] = self.ip_code
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        if self.creator is not None:
            result['Creator'] = self.creator
        if self.ip_record_id is not None:
            result['IpRecordId'] = self.ip_record_id
        if self.ip_record_name is not None:
            result['IpRecordName'] = self.ip_record_name
        if self.zone_name is not None:
            result['ZoneName'] = self.zone_name
        if self.business_type_name is not None:
            result['BusinessTypeName'] = self.business_type_name
        if self.recode_type is not None:
            result['RecodeType'] = self.recode_type
        if self.ip_block is not None:
            result['IpBlock'] = self.ip_block
        result['Detail'] = []
        if self.detail is not None:
            for k in self.detail:
                result['Detail'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('IpCode') is not None:
            self.ip_code = m.get('IpCode')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        if m.get('Creator') is not None:
            self.creator = m.get('Creator')
        if m.get('IpRecordId') is not None:
            self.ip_record_id = m.get('IpRecordId')
        if m.get('IpRecordName') is not None:
            self.ip_record_name = m.get('IpRecordName')
        if m.get('ZoneName') is not None:
            self.zone_name = m.get('ZoneName')
        if m.get('BusinessTypeName') is not None:
            self.business_type_name = m.get('BusinessTypeName')
        if m.get('RecodeType') is not None:
            self.recode_type = m.get('RecodeType')
        if m.get('IpBlock') is not None:
            self.ip_block = m.get('IpBlock')
        self.detail = []
        if m.get('Detail') is not None:
            for k in m.get('Detail'):
                temp_model = GetIpRecordResponseBodyIpRecordDetail()
                self.detail.append(temp_model.from_map(k))
        return self


class GetIpRecordResponseBody(TeaModel):
    def __init__(
        self,
        ip_record: GetIpRecordResponseBodyIpRecord = None,
        request_id: str = None,
    ):
        # 工单类型对象
        self.ip_record = ip_record
        # Id of the request
        self.request_id = request_id

    def validate(self):
        if self.ip_record:
            self.ip_record.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ip_record is not None:
            result['IpRecord'] = self.ip_record.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IpRecord') is not None:
            temp_model = GetIpRecordResponseBodyIpRecord()
            self.ip_record = temp_model.from_map(m['IpRecord'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetIpRecordResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetIpRecordResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetIpRecordResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListScheduleDutiesRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        max_results: int = None,
        next_token: str = None,
        start_date: str = None,
        end_date: str = None,
    ):
        self.instance_id = instance_id
        # 返回结果的最大个数。
        self.max_results = max_results
        # 当总结果个数大于MaxResults时，用于翻页的token。
        self.next_token = next_token
        self.start_date = start_date
        self.end_date = end_date

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        return self


class ListScheduleDutiesResponseBodyScheduleDutiesTypeWorkerList(TeaModel):
    def __init__(
        self,
        schedule_duty_id: str = None,
        schedule_type_id: str = None,
        schedule_type_name: str = None,
        schedule_worker_name: List[str] = None,
    ):
        # 值班表id
        self.schedule_duty_id = schedule_duty_id
        # 值班类型Id
        self.schedule_type_id = schedule_type_id
        # 值班类型名称
        self.schedule_type_name = schedule_type_name
        # 值班人员名称
        self.schedule_worker_name = schedule_worker_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.schedule_duty_id is not None:
            result['ScheduleDutyId'] = self.schedule_duty_id
        if self.schedule_type_id is not None:
            result['ScheduleTypeId'] = self.schedule_type_id
        if self.schedule_type_name is not None:
            result['ScheduleTypeName'] = self.schedule_type_name
        if self.schedule_worker_name is not None:
            result['ScheduleWorkerName'] = self.schedule_worker_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ScheduleDutyId') is not None:
            self.schedule_duty_id = m.get('ScheduleDutyId')
        if m.get('ScheduleTypeId') is not None:
            self.schedule_type_id = m.get('ScheduleTypeId')
        if m.get('ScheduleTypeName') is not None:
            self.schedule_type_name = m.get('ScheduleTypeName')
        if m.get('ScheduleWorkerName') is not None:
            self.schedule_worker_name = m.get('ScheduleWorkerName')
        return self


class ListScheduleDutiesResponseBodyScheduleDuties(TeaModel):
    def __init__(
        self,
        schedule_duty_date: str = None,
        schedule_duty_id: str = None,
        create_time: str = None,
        update_time: str = None,
        holiday: bool = None,
        type_worker_list: List[ListScheduleDutiesResponseBodyScheduleDutiesTypeWorkerList] = None,
    ):
        # 值班表日期
        self.schedule_duty_date = schedule_duty_date
        # 资源一级ID
        self.schedule_duty_id = schedule_duty_id
        # 创建时间
        self.create_time = create_time
        # 更新时间
        self.update_time = update_time
        # 是否节假日
        self.holiday = holiday
        self.type_worker_list = type_worker_list

    def validate(self):
        if self.type_worker_list:
            for k in self.type_worker_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.schedule_duty_date is not None:
            result['ScheduleDutyDate'] = self.schedule_duty_date
        if self.schedule_duty_id is not None:
            result['ScheduleDutyId'] = self.schedule_duty_id
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        if self.holiday is not None:
            result['Holiday'] = self.holiday
        result['TypeWorkerList'] = []
        if self.type_worker_list is not None:
            for k in self.type_worker_list:
                result['TypeWorkerList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ScheduleDutyDate') is not None:
            self.schedule_duty_date = m.get('ScheduleDutyDate')
        if m.get('ScheduleDutyId') is not None:
            self.schedule_duty_id = m.get('ScheduleDutyId')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        if m.get('Holiday') is not None:
            self.holiday = m.get('Holiday')
        self.type_worker_list = []
        if m.get('TypeWorkerList') is not None:
            for k in m.get('TypeWorkerList'):
                temp_model = ListScheduleDutiesResponseBodyScheduleDutiesTypeWorkerList()
                self.type_worker_list.append(temp_model.from_map(k))
        return self


class ListScheduleDutiesResponseBody(TeaModel):
    def __init__(
        self,
        total_count: int = None,
        request_id: str = None,
        next_token: int = None,
        schedule_duties: List[ListScheduleDutiesResponseBodyScheduleDuties] = None,
    ):
        # 总记录数。
        self.total_count = total_count
        # Id of the request
        self.request_id = request_id
        # 当总结果个数大于MaxResults时，用于翻页的token。
        self.next_token = next_token
        # 数组，返回示例目录。
        self.schedule_duties = schedule_duties

    def validate(self):
        if self.schedule_duties:
            for k in self.schedule_duties:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        result['ScheduleDuties'] = []
        if self.schedule_duties is not None:
            for k in self.schedule_duties:
                result['ScheduleDuties'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        self.schedule_duties = []
        if m.get('ScheduleDuties') is not None:
            for k in m.get('ScheduleDuties'):
                temp_model = ListScheduleDutiesResponseBodyScheduleDuties()
                self.schedule_duties.append(temp_model.from_map(k))
        return self


class ListScheduleDutiesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListScheduleDutiesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListScheduleDutiesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class LockSpaceModelRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        space_model_id: str = None,
    ):
        # instanceId
        self.instance_id = instance_id
        # 资源id
        self.space_model_id = space_model_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.space_model_id is not None:
            result['SpaceModelId'] = self.space_model_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('SpaceModelId') is not None:
            self.space_model_id = m.get('SpaceModelId')
        return self


class LockSpaceModelResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # Id of the request
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class LockSpaceModelResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: LockSpaceModelResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = LockSpaceModelResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class UpdateResourceInformationRequestInformation(TeaModel):
    def __init__(
        self,
        key: str = None,
        key_attribute: str = None,
        key_action: str = None,
        key_description: str = None,
        setup_project_id: str = None,
    ):
        # 键
        self.key = key
        # 键属性
        self.key_attribute = key_attribute
        # 键动作
        self.key_action = key_action
        # 键描述
        self.key_description = key_description
        # 建设项目id
        self.setup_project_id = setup_project_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.key_attribute is not None:
            result['KeyAttribute'] = self.key_attribute
        if self.key_action is not None:
            result['KeyAction'] = self.key_action
        if self.key_description is not None:
            result['KeyDescription'] = self.key_description
        if self.setup_project_id is not None:
            result['SetupProjectId'] = self.setup_project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('KeyAttribute') is not None:
            self.key_attribute = m.get('KeyAttribute')
        if m.get('KeyAction') is not None:
            self.key_action = m.get('KeyAction')
        if m.get('KeyDescription') is not None:
            self.key_description = m.get('KeyDescription')
        if m.get('SetupProjectId') is not None:
            self.setup_project_id = m.get('SetupProjectId')
        return self


class UpdateResourceInformationRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        resource_information_id: str = None,
        resource_type: str = None,
        resource_attribute: str = None,
        information: List[UpdateResourceInformationRequestInformation] = None,
    ):
        # instanceId
        self.instance_id = instance_id
        # 资源信息Id
        self.resource_information_id = resource_information_id
        # 资源类型
        self.resource_type = resource_type
        # 资源属性
        self.resource_attribute = resource_attribute
        # 信息
        self.information = information

    def validate(self):
        if self.information:
            for k in self.information:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.resource_information_id is not None:
            result['ResourceInformationId'] = self.resource_information_id
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        if self.resource_attribute is not None:
            result['ResourceAttribute'] = self.resource_attribute
        result['Information'] = []
        if self.information is not None:
            for k in self.information:
                result['Information'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ResourceInformationId') is not None:
            self.resource_information_id = m.get('ResourceInformationId')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        if m.get('ResourceAttribute') is not None:
            self.resource_attribute = m.get('ResourceAttribute')
        self.information = []
        if m.get('Information') is not None:
            for k in m.get('Information'):
                temp_model = UpdateResourceInformationRequestInformation()
                self.information.append(temp_model.from_map(k))
        return self


class UpdateResourceInformationShrinkRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        resource_information_id: str = None,
        resource_type: str = None,
        resource_attribute: str = None,
        information_shrink: str = None,
    ):
        # instanceId
        self.instance_id = instance_id
        # 资源信息Id
        self.resource_information_id = resource_information_id
        # 资源类型
        self.resource_type = resource_type
        # 资源属性
        self.resource_attribute = resource_attribute
        # 信息
        self.information_shrink = information_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.resource_information_id is not None:
            result['ResourceInformationId'] = self.resource_information_id
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        if self.resource_attribute is not None:
            result['ResourceAttribute'] = self.resource_attribute
        if self.information_shrink is not None:
            result['Information'] = self.information_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ResourceInformationId') is not None:
            self.resource_information_id = m.get('ResourceInformationId')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        if m.get('ResourceAttribute') is not None:
            self.resource_attribute = m.get('ResourceAttribute')
        if m.get('Information') is not None:
            self.information_shrink = m.get('Information')
        return self


class UpdateResourceInformationResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # Id of the request
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class UpdateResourceInformationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: UpdateResourceInformationResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = UpdateResourceInformationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateTimePeriodRequest(TeaModel):
    def __init__(
        self,
        time_period_name: str = None,
        time_period_description: str = None,
        expression: str = None,
        client_token: str = None,
        instance_id: str = None,
    ):
        # 时间段名称
        self.time_period_name = time_period_name
        # 描述
        self.time_period_description = time_period_description
        # cron表达式
        self.expression = expression
        # 幂等参数
        self.client_token = client_token
        # 实例ID
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.time_period_name is not None:
            result['TimePeriodName'] = self.time_period_name
        if self.time_period_description is not None:
            result['TimePeriodDescription'] = self.time_period_description
        if self.expression is not None:
            result['Expression'] = self.expression
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TimePeriodName') is not None:
            self.time_period_name = m.get('TimePeriodName')
        if m.get('TimePeriodDescription') is not None:
            self.time_period_description = m.get('TimePeriodDescription')
        if m.get('Expression') is not None:
            self.expression = m.get('Expression')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class CreateTimePeriodResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        time_period_id: str = None,
    ):
        # Id of the request
        self.request_id = request_id
        # 时间段ID
        self.time_period_id = time_period_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.time_period_id is not None:
            result['TimePeriodId'] = self.time_period_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TimePeriodId') is not None:
            self.time_period_id = m.get('TimePeriodId')
        return self


class CreateTimePeriodResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateTimePeriodResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateTimePeriodResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListDevicesRequest(TeaModel):
    def __init__(
        self,
        max_results: int = None,
        next_token: str = None,
        device_form_id: str = None,
        device_form_name: str = None,
        physical_space_id: str = None,
        host_name: List[str] = None,
        ip: List[str] = None,
        sn: List[str] = None,
        mac: List[str] = None,
        vendor: List[str] = None,
        model: List[str] = None,
        service_status: List[str] = None,
        security_domain: List[str] = None,
        ext_attributes: str = None,
        instance_id: str = None,
    ):
        # 返回结果的最大个数。
        self.max_results = max_results
        # 当总结果个数大于MaxResults时，用于翻页的token。
        self.next_token = next_token
        # 设备形态ID
        self.device_form_id = device_form_id
        # 设备形态名称
        self.device_form_name = device_form_name
        # 物理空间ID
        self.physical_space_id = physical_space_id
        # 设备主机名
        self.host_name = host_name
        # 设备IP
        self.ip = ip
        # 设备SN
        self.sn = sn
        # 设备MAC
        self.mac = mac
        # 设备厂商
        self.vendor = vendor
        # 设备型号
        self.model = model
        # 设备服务状态
        self.service_status = service_status
        # 安全域
        self.security_domain = security_domain
        # 设备额外属性
        self.ext_attributes = ext_attributes
        # 实例ID
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.device_form_id is not None:
            result['DeviceFormId'] = self.device_form_id
        if self.device_form_name is not None:
            result['DeviceFormName'] = self.device_form_name
        if self.physical_space_id is not None:
            result['PhysicalSpaceId'] = self.physical_space_id
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.ip is not None:
            result['Ip'] = self.ip
        if self.sn is not None:
            result['Sn'] = self.sn
        if self.mac is not None:
            result['Mac'] = self.mac
        if self.vendor is not None:
            result['Vendor'] = self.vendor
        if self.model is not None:
            result['Model'] = self.model
        if self.service_status is not None:
            result['ServiceStatus'] = self.service_status
        if self.security_domain is not None:
            result['SecurityDomain'] = self.security_domain
        if self.ext_attributes is not None:
            result['ExtAttributes'] = self.ext_attributes
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('DeviceFormId') is not None:
            self.device_form_id = m.get('DeviceFormId')
        if m.get('DeviceFormName') is not None:
            self.device_form_name = m.get('DeviceFormName')
        if m.get('PhysicalSpaceId') is not None:
            self.physical_space_id = m.get('PhysicalSpaceId')
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('Ip') is not None:
            self.ip = m.get('Ip')
        if m.get('Sn') is not None:
            self.sn = m.get('Sn')
        if m.get('Mac') is not None:
            self.mac = m.get('Mac')
        if m.get('Vendor') is not None:
            self.vendor = m.get('Vendor')
        if m.get('Model') is not None:
            self.model = m.get('Model')
        if m.get('ServiceStatus') is not None:
            self.service_status = m.get('ServiceStatus')
        if m.get('SecurityDomain') is not None:
            self.security_domain = m.get('SecurityDomain')
        if m.get('ExtAttributes') is not None:
            self.ext_attributes = m.get('ExtAttributes')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class ListDevicesResponseBodyDevices(TeaModel):
    def __init__(
        self,
        device_id: str = None,
        device_form_name: str = None,
        device_form_id: str = None,
        physical_space_id: str = None,
        physical_space_name: str = None,
        host_name: str = None,
        ip: str = None,
        sn: str = None,
        mac: str = None,
        vendor: str = None,
        model: str = None,
        security_domain: str = None,
        service_status: str = None,
        login_type: str = None,
        login_username: str = None,
        login_password: str = None,
        snmp_account_version: str = None,
        snmp_community: str = None,
        snmp_account_type: str = None,
        snmp_security_level: str = None,
        snmp_username: str = None,
        snmp_auth_pass_phrase: str = None,
        snmp_auth_protocol: str = None,
        snmp_privacy_passphase: str = None,
        snmp_privacy_protocol: str = None,
        ext_attributes: str = None,
    ):
        # 设备ID
        self.device_id = device_id
        # 设备形态名称
        self.device_form_name = device_form_name
        # 设备形态ID
        self.device_form_id = device_form_id
        # 物理空间ID
        self.physical_space_id = physical_space_id
        # 物理空间名称
        self.physical_space_name = physical_space_name
        # 主机名
        self.host_name = host_name
        # 设备IP
        self.ip = ip
        # 设备SN
        self.sn = sn
        # 设备MAC地址
        self.mac = mac
        # 设备厂商
        self.vendor = vendor
        # 设备型号
        self.model = model
        # 设备安全域
        self.security_domain = security_domain
        # 设备状态
        self.service_status = service_status
        # 登录类型
        self.login_type = login_type
        # 登录账号
        self.login_username = login_username
        # 登录密码
        self.login_password = login_password
        # SNMP版本号
        self.snmp_account_version = snmp_account_version
        # SNMP Community
        self.snmp_community = snmp_community
        # SNMP 账号类型
        self.snmp_account_type = snmp_account_type
        # SNMP 安全级别
        self.snmp_security_level = snmp_security_level
        # SNMP 用户名
        self.snmp_username = snmp_username
        # SNMP Auth PassPhrase
        self.snmp_auth_pass_phrase = snmp_auth_pass_phrase
        # SNMP Auth Protocol
        self.snmp_auth_protocol = snmp_auth_protocol
        # SNMP Privacy Passphase
        self.snmp_privacy_passphase = snmp_privacy_passphase
        # SNMP Privacy Protocol
        self.snmp_privacy_protocol = snmp_privacy_protocol
        # 设备额外属性
        self.ext_attributes = ext_attributes

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.device_form_name is not None:
            result['DeviceFormName'] = self.device_form_name
        if self.device_form_id is not None:
            result['DeviceFormId'] = self.device_form_id
        if self.physical_space_id is not None:
            result['PhysicalSpaceId'] = self.physical_space_id
        if self.physical_space_name is not None:
            result['PhysicalSpaceName'] = self.physical_space_name
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.ip is not None:
            result['Ip'] = self.ip
        if self.sn is not None:
            result['Sn'] = self.sn
        if self.mac is not None:
            result['Mac'] = self.mac
        if self.vendor is not None:
            result['Vendor'] = self.vendor
        if self.model is not None:
            result['Model'] = self.model
        if self.security_domain is not None:
            result['SecurityDomain'] = self.security_domain
        if self.service_status is not None:
            result['ServiceStatus'] = self.service_status
        if self.login_type is not None:
            result['LoginType'] = self.login_type
        if self.login_username is not None:
            result['LoginUsername'] = self.login_username
        if self.login_password is not None:
            result['LoginPassword'] = self.login_password
        if self.snmp_account_version is not None:
            result['SnmpAccountVersion'] = self.snmp_account_version
        if self.snmp_community is not None:
            result['SnmpCommunity'] = self.snmp_community
        if self.snmp_account_type is not None:
            result['SnmpAccountType'] = self.snmp_account_type
        if self.snmp_security_level is not None:
            result['SnmpSecurityLevel'] = self.snmp_security_level
        if self.snmp_username is not None:
            result['SnmpUsername'] = self.snmp_username
        if self.snmp_auth_pass_phrase is not None:
            result['SnmpAuthPassPhrase'] = self.snmp_auth_pass_phrase
        if self.snmp_auth_protocol is not None:
            result['SnmpAuthProtocol'] = self.snmp_auth_protocol
        if self.snmp_privacy_passphase is not None:
            result['SnmpPrivacyPassphase'] = self.snmp_privacy_passphase
        if self.snmp_privacy_protocol is not None:
            result['SnmpPrivacyProtocol'] = self.snmp_privacy_protocol
        if self.ext_attributes is not None:
            result['ExtAttributes'] = self.ext_attributes
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('DeviceFormName') is not None:
            self.device_form_name = m.get('DeviceFormName')
        if m.get('DeviceFormId') is not None:
            self.device_form_id = m.get('DeviceFormId')
        if m.get('PhysicalSpaceId') is not None:
            self.physical_space_id = m.get('PhysicalSpaceId')
        if m.get('PhysicalSpaceName') is not None:
            self.physical_space_name = m.get('PhysicalSpaceName')
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('Ip') is not None:
            self.ip = m.get('Ip')
        if m.get('Sn') is not None:
            self.sn = m.get('Sn')
        if m.get('Mac') is not None:
            self.mac = m.get('Mac')
        if m.get('Vendor') is not None:
            self.vendor = m.get('Vendor')
        if m.get('Model') is not None:
            self.model = m.get('Model')
        if m.get('SecurityDomain') is not None:
            self.security_domain = m.get('SecurityDomain')
        if m.get('ServiceStatus') is not None:
            self.service_status = m.get('ServiceStatus')
        if m.get('LoginType') is not None:
            self.login_type = m.get('LoginType')
        if m.get('LoginUsername') is not None:
            self.login_username = m.get('LoginUsername')
        if m.get('LoginPassword') is not None:
            self.login_password = m.get('LoginPassword')
        if m.get('SnmpAccountVersion') is not None:
            self.snmp_account_version = m.get('SnmpAccountVersion')
        if m.get('SnmpCommunity') is not None:
            self.snmp_community = m.get('SnmpCommunity')
        if m.get('SnmpAccountType') is not None:
            self.snmp_account_type = m.get('SnmpAccountType')
        if m.get('SnmpSecurityLevel') is not None:
            self.snmp_security_level = m.get('SnmpSecurityLevel')
        if m.get('SnmpUsername') is not None:
            self.snmp_username = m.get('SnmpUsername')
        if m.get('SnmpAuthPassPhrase') is not None:
            self.snmp_auth_pass_phrase = m.get('SnmpAuthPassPhrase')
        if m.get('SnmpAuthProtocol') is not None:
            self.snmp_auth_protocol = m.get('SnmpAuthProtocol')
        if m.get('SnmpPrivacyPassphase') is not None:
            self.snmp_privacy_passphase = m.get('SnmpPrivacyPassphase')
        if m.get('SnmpPrivacyProtocol') is not None:
            self.snmp_privacy_protocol = m.get('SnmpPrivacyProtocol')
        if m.get('ExtAttributes') is not None:
            self.ext_attributes = m.get('ExtAttributes')
        return self


class ListDevicesResponseBody(TeaModel):
    def __init__(
        self,
        total_count: int = None,
        request_id: str = None,
        next_token: int = None,
        devices: List[ListDevicesResponseBodyDevices] = None,
        max_results: int = None,
    ):
        # 总记录数。
        self.total_count = total_count
        # Id of the request
        self.request_id = request_id
        # 当总结果个数大于MaxResults时，用于翻页的token。
        self.next_token = next_token
        # 数组，返回示例目录。
        self.devices = devices
        # 每页数量。
        self.max_results = max_results

    def validate(self):
        if self.devices:
            for k in self.devices:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        result['Devices'] = []
        if self.devices is not None:
            for k in self.devices:
                result['Devices'].append(k.to_map() if k else None)
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        self.devices = []
        if m.get('Devices') is not None:
            for k in m.get('Devices'):
                temp_model = ListDevicesResponseBodyDevices()
                self.devices.append(temp_model.from_map(k))
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        return self


class ListDevicesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListDevicesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListDevicesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListInspectionTaskReportsRequest(TeaModel):
    def __init__(
        self,
        inspection_item_id: str = None,
        vendor: str = None,
        instance_id: str = None,
    ):
        # 巡检项id
        self.inspection_item_id = inspection_item_id
        # 厂商
        self.vendor = vendor
        # 实例id
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.inspection_item_id is not None:
            result['InspectionItemId'] = self.inspection_item_id
        if self.vendor is not None:
            result['Vendor'] = self.vendor
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InspectionItemId') is not None:
            self.inspection_item_id = m.get('InspectionItemId')
        if m.get('Vendor') is not None:
            self.vendor = m.get('Vendor')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class ListInspectionTaskReportsResponseBodyInspectionTaskAlarmStatistic(TeaModel):
    def __init__(
        self,
        inspection_item: str = None,
        vendor: str = None,
        model: str = None,
        critical_number: int = None,
        warning_number: int = None,
    ):
        # 巡检项
        self.inspection_item = inspection_item
        # 厂商
        self.vendor = vendor
        # 型号
        self.model = model
        # 高危数量
        self.critical_number = critical_number
        # 中危数量
        self.warning_number = warning_number

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.inspection_item is not None:
            result['InspectionItem'] = self.inspection_item
        if self.vendor is not None:
            result['Vendor'] = self.vendor
        if self.model is not None:
            result['Model'] = self.model
        if self.critical_number is not None:
            result['CriticalNumber'] = self.critical_number
        if self.warning_number is not None:
            result['WarningNumber'] = self.warning_number
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InspectionItem') is not None:
            self.inspection_item = m.get('InspectionItem')
        if m.get('Vendor') is not None:
            self.vendor = m.get('Vendor')
        if m.get('Model') is not None:
            self.model = m.get('Model')
        if m.get('CriticalNumber') is not None:
            self.critical_number = m.get('CriticalNumber')
        if m.get('WarningNumber') is not None:
            self.warning_number = m.get('WarningNumber')
        return self


class ListInspectionTaskReportsResponseBodyInspectionTask(TeaModel):
    def __init__(
        self,
        total_device_number: int = None,
        actual_device_number: int = None,
        device_rate: str = None,
        task_number: int = None,
        running_task_number: int = None,
        running_task_rate: str = None,
        success_task_number: int = None,
        success_task_rate: str = None,
        failure_task_number: int = None,
        failure_task_rate: str = None,
        failure_statistic: str = None,
        alarm_number: int = None,
        critical_number: int = None,
        critical_rate: str = None,
        warning_number: int = None,
        warning_rate: str = None,
        normal_number: int = None,
        normal_rate: str = None,
        alarm_statistic: List[ListInspectionTaskReportsResponseBodyInspectionTaskAlarmStatistic] = None,
    ):
        # 总设备数
        self.total_device_number = total_device_number
        # 实际设备数
        self.actual_device_number = actual_device_number
        # 设备占比
        self.device_rate = device_rate
        # 任务数
        self.task_number = task_number
        # 正在运行任务数
        self.running_task_number = running_task_number
        # 运行占比
        self.running_task_rate = running_task_rate
        # 成功任务数
        self.success_task_number = success_task_number
        # 成功占比
        self.success_task_rate = success_task_rate
        # 失败任务数
        self.failure_task_number = failure_task_number
        # 失败占比
        self.failure_task_rate = failure_task_rate
        # 失败详情
        self.failure_statistic = failure_statistic
        # 告警数量
        self.alarm_number = alarm_number
        # 高危数量
        self.critical_number = critical_number
        # 高危占比
        self.critical_rate = critical_rate
        # 中危数量
        self.warning_number = warning_number
        # 中危占比
        self.warning_rate = warning_rate
        # 正常数量
        self.normal_number = normal_number
        # 正常占比
        self.normal_rate = normal_rate
        self.alarm_statistic = alarm_statistic

    def validate(self):
        if self.alarm_statistic:
            for k in self.alarm_statistic:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.total_device_number is not None:
            result['TotalDeviceNumber'] = self.total_device_number
        if self.actual_device_number is not None:
            result['ActualDeviceNumber'] = self.actual_device_number
        if self.device_rate is not None:
            result['DeviceRate'] = self.device_rate
        if self.task_number is not None:
            result['TaskNumber'] = self.task_number
        if self.running_task_number is not None:
            result['RunningTaskNumber'] = self.running_task_number
        if self.running_task_rate is not None:
            result['RunningTaskRate'] = self.running_task_rate
        if self.success_task_number is not None:
            result['SuccessTaskNumber'] = self.success_task_number
        if self.success_task_rate is not None:
            result['SuccessTaskRate'] = self.success_task_rate
        if self.failure_task_number is not None:
            result['FailureTaskNumber'] = self.failure_task_number
        if self.failure_task_rate is not None:
            result['FailureTaskRate'] = self.failure_task_rate
        if self.failure_statistic is not None:
            result['FailureStatistic'] = self.failure_statistic
        if self.alarm_number is not None:
            result['AlarmNumber'] = self.alarm_number
        if self.critical_number is not None:
            result['CriticalNumber'] = self.critical_number
        if self.critical_rate is not None:
            result['CriticalRate'] = self.critical_rate
        if self.warning_number is not None:
            result['WarningNumber'] = self.warning_number
        if self.warning_rate is not None:
            result['WarningRate'] = self.warning_rate
        if self.normal_number is not None:
            result['NormalNumber'] = self.normal_number
        if self.normal_rate is not None:
            result['NormalRate'] = self.normal_rate
        result['AlarmStatistic'] = []
        if self.alarm_statistic is not None:
            for k in self.alarm_statistic:
                result['AlarmStatistic'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TotalDeviceNumber') is not None:
            self.total_device_number = m.get('TotalDeviceNumber')
        if m.get('ActualDeviceNumber') is not None:
            self.actual_device_number = m.get('ActualDeviceNumber')
        if m.get('DeviceRate') is not None:
            self.device_rate = m.get('DeviceRate')
        if m.get('TaskNumber') is not None:
            self.task_number = m.get('TaskNumber')
        if m.get('RunningTaskNumber') is not None:
            self.running_task_number = m.get('RunningTaskNumber')
        if m.get('RunningTaskRate') is not None:
            self.running_task_rate = m.get('RunningTaskRate')
        if m.get('SuccessTaskNumber') is not None:
            self.success_task_number = m.get('SuccessTaskNumber')
        if m.get('SuccessTaskRate') is not None:
            self.success_task_rate = m.get('SuccessTaskRate')
        if m.get('FailureTaskNumber') is not None:
            self.failure_task_number = m.get('FailureTaskNumber')
        if m.get('FailureTaskRate') is not None:
            self.failure_task_rate = m.get('FailureTaskRate')
        if m.get('FailureStatistic') is not None:
            self.failure_statistic = m.get('FailureStatistic')
        if m.get('AlarmNumber') is not None:
            self.alarm_number = m.get('AlarmNumber')
        if m.get('CriticalNumber') is not None:
            self.critical_number = m.get('CriticalNumber')
        if m.get('CriticalRate') is not None:
            self.critical_rate = m.get('CriticalRate')
        if m.get('WarningNumber') is not None:
            self.warning_number = m.get('WarningNumber')
        if m.get('WarningRate') is not None:
            self.warning_rate = m.get('WarningRate')
        if m.get('NormalNumber') is not None:
            self.normal_number = m.get('NormalNumber')
        if m.get('NormalRate') is not None:
            self.normal_rate = m.get('NormalRate')
        self.alarm_statistic = []
        if m.get('AlarmStatistic') is not None:
            for k in m.get('AlarmStatistic'):
                temp_model = ListInspectionTaskReportsResponseBodyInspectionTaskAlarmStatistic()
                self.alarm_statistic.append(temp_model.from_map(k))
        return self


class ListInspectionTaskReportsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        inspection_task: List[ListInspectionTaskReportsResponseBodyInspectionTask] = None,
    ):
        # Id of the request
        self.request_id = request_id
        # 内容
        self.inspection_task = inspection_task

    def validate(self):
        if self.inspection_task:
            for k in self.inspection_task:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['InspectionTask'] = []
        if self.inspection_task is not None:
            for k in self.inspection_task:
                result['InspectionTask'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.inspection_task = []
        if m.get('InspectionTask') is not None:
            for k in m.get('InspectionTask'):
                temp_model = ListInspectionTaskReportsResponseBodyInspectionTask()
                self.inspection_task.append(temp_model.from_map(k))
        return self


class ListInspectionTaskReportsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListInspectionTaskReportsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListInspectionTaskReportsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateMonitorItemRequestAlarmRuleList(TeaModel):
    def __init__(
        self,
        alarm_status: str = None,
        variable: str = None,
        expression: str = None,
        value: str = None,
    ):
        # 告警状态
        self.alarm_status = alarm_status
        # 指标名
        self.variable = variable
        # 表达式
        self.expression = expression
        # 比较值
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alarm_status is not None:
            result['AlarmStatus'] = self.alarm_status
        if self.variable is not None:
            result['Variable'] = self.variable
        if self.expression is not None:
            result['Expression'] = self.expression
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AlarmStatus') is not None:
            self.alarm_status = m.get('AlarmStatus')
        if m.get('Variable') is not None:
            self.variable = m.get('Variable')
        if m.get('Expression') is not None:
            self.expression = m.get('Expression')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateMonitorItemRequest(TeaModel):
    def __init__(
        self,
        monitor_item_name: str = None,
        monitor_item_description: str = None,
        data_item: str = None,
        security_domain: str = None,
        analysis_code: str = None,
        collection_type: str = None,
        effective: int = None,
        config: str = None,
        exec_interval: int = None,
        device_form: str = None,
        alarm_rule_list: List[CreateMonitorItemRequestAlarmRuleList] = None,
        type: str = None,
        client_token: str = None,
        instance_id: str = None,
    ):
        # 监控项名称
        self.monitor_item_name = monitor_item_name
        # 监控项描述
        self.monitor_item_description = monitor_item_description
        # 数据项
        self.data_item = data_item
        # 安全域
        self.security_domain = security_domain
        # 解析代码
        self.analysis_code = analysis_code
        # 采集类型
        self.collection_type = collection_type
        # 是否启用
        self.effective = effective
        # 监控项参数配置
        self.config = config
        # 执行间隔(s)
        self.exec_interval = exec_interval
        # 设备形态
        self.device_form = device_form
        # 告警规则列表
        self.alarm_rule_list = alarm_rule_list
        # 类型
        self.type = type
        # 幂等参数
        self.client_token = client_token
        # 实例ID
        self.instance_id = instance_id

    def validate(self):
        if self.alarm_rule_list:
            for k in self.alarm_rule_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.monitor_item_name is not None:
            result['MonitorItemName'] = self.monitor_item_name
        if self.monitor_item_description is not None:
            result['MonitorItemDescription'] = self.monitor_item_description
        if self.data_item is not None:
            result['DataItem'] = self.data_item
        if self.security_domain is not None:
            result['SecurityDomain'] = self.security_domain
        if self.analysis_code is not None:
            result['AnalysisCode'] = self.analysis_code
        if self.collection_type is not None:
            result['CollectionType'] = self.collection_type
        if self.effective is not None:
            result['Effective'] = self.effective
        if self.config is not None:
            result['Config'] = self.config
        if self.exec_interval is not None:
            result['ExecInterval'] = self.exec_interval
        if self.device_form is not None:
            result['DeviceForm'] = self.device_form
        result['AlarmRuleList'] = []
        if self.alarm_rule_list is not None:
            for k in self.alarm_rule_list:
                result['AlarmRuleList'].append(k.to_map() if k else None)
        if self.type is not None:
            result['Type'] = self.type
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MonitorItemName') is not None:
            self.monitor_item_name = m.get('MonitorItemName')
        if m.get('MonitorItemDescription') is not None:
            self.monitor_item_description = m.get('MonitorItemDescription')
        if m.get('DataItem') is not None:
            self.data_item = m.get('DataItem')
        if m.get('SecurityDomain') is not None:
            self.security_domain = m.get('SecurityDomain')
        if m.get('AnalysisCode') is not None:
            self.analysis_code = m.get('AnalysisCode')
        if m.get('CollectionType') is not None:
            self.collection_type = m.get('CollectionType')
        if m.get('Effective') is not None:
            self.effective = m.get('Effective')
        if m.get('Config') is not None:
            self.config = m.get('Config')
        if m.get('ExecInterval') is not None:
            self.exec_interval = m.get('ExecInterval')
        if m.get('DeviceForm') is not None:
            self.device_form = m.get('DeviceForm')
        self.alarm_rule_list = []
        if m.get('AlarmRuleList') is not None:
            for k in m.get('AlarmRuleList'):
                temp_model = CreateMonitorItemRequestAlarmRuleList()
                self.alarm_rule_list.append(temp_model.from_map(k))
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class CreateMonitorItemResponseBody(TeaModel):
    def __init__(
        self,
        monitor_item_id: str = None,
        request_id: str = None,
    ):
        # 监控项ID
        self.monitor_item_id = monitor_item_id
        # Id of the request
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.monitor_item_id is not None:
            result['MonitorItemId'] = self.monitor_item_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MonitorItemId') is not None:
            self.monitor_item_id = m.get('MonitorItemId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateMonitorItemResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateMonitorItemResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateMonitorItemResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreatePhysicalSpaceRequest(TeaModel):
    def __init__(
        self,
        physical_space_name: str = None,
        country: str = None,
        province: str = None,
        city: str = None,
        address: str = None,
        client_token: str = None,
        instance_id: str = None,
        space_type: str = None,
        space_abbreviation: str = None,
        owner: str = None,
    ):
        # 物理空间名称
        self.physical_space_name = physical_space_name
        # 所属国家
        self.country = country
        # 所属省份
        self.province = province
        # 所属城市
        self.city = city
        # 具体地址
        self.address = address
        # 幂等校验 token
        self.client_token = client_token
        # 实例ID
        self.instance_id = instance_id
        # 物理空间模型
        self.space_type = space_type
        # 物理空间缩写
        self.space_abbreviation = space_abbreviation
        # 负责人
        self.owner = owner

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.physical_space_name is not None:
            result['PhysicalSpaceName'] = self.physical_space_name
        if self.country is not None:
            result['Country'] = self.country
        if self.province is not None:
            result['Province'] = self.province
        if self.city is not None:
            result['City'] = self.city
        if self.address is not None:
            result['Address'] = self.address
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.space_type is not None:
            result['SpaceType'] = self.space_type
        if self.space_abbreviation is not None:
            result['SpaceAbbreviation'] = self.space_abbreviation
        if self.owner is not None:
            result['Owner'] = self.owner
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PhysicalSpaceName') is not None:
            self.physical_space_name = m.get('PhysicalSpaceName')
        if m.get('Country') is not None:
            self.country = m.get('Country')
        if m.get('Province') is not None:
            self.province = m.get('Province')
        if m.get('City') is not None:
            self.city = m.get('City')
        if m.get('Address') is not None:
            self.address = m.get('Address')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('SpaceType') is not None:
            self.space_type = m.get('SpaceType')
        if m.get('SpaceAbbreviation') is not None:
            self.space_abbreviation = m.get('SpaceAbbreviation')
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        return self


class CreatePhysicalSpaceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        physical_space_id: str = None,
    ):
        # Id of the request
        self.request_id = request_id
        # 物理空间ID
        self.physical_space_id = physical_space_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.physical_space_id is not None:
            result['PhysicalSpaceId'] = self.physical_space_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PhysicalSpaceId') is not None:
            self.physical_space_id = m.get('PhysicalSpaceId')
        return self


class CreatePhysicalSpaceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreatePhysicalSpaceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreatePhysicalSpaceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class UpdateDevicesRequest(TeaModel):
    def __init__(
        self,
        device_ids: List[str] = None,
        login_type: str = None,
        login_username: str = None,
        login_password: str = None,
        snmp_account_version: str = None,
        snmp_community: str = None,
        snmp_account_type: str = None,
        snmp_security_level: str = None,
        snmp_user_name: str = None,
        snmp_auth_passphrase: str = None,
        snmp_auth_protocol: str = None,
        snmp_privacy_passphase: str = None,
        snmp_privacy_protocol: str = None,
        instance_id: str = None,
    ):
        # 设备ID
        self.device_ids = device_ids
        # 登录类型
        self.login_type = login_type
        # 登录账号
        self.login_username = login_username
        # 登录密码
        self.login_password = login_password
        # SNMP 版本号
        self.snmp_account_version = snmp_account_version
        # SNMP Community
        self.snmp_community = snmp_community
        # SNMP 账号类型
        self.snmp_account_type = snmp_account_type
        # SNMP 安全级别
        self.snmp_security_level = snmp_security_level
        # SNMP 用户名
        self.snmp_user_name = snmp_user_name
        # SNMP Auth PassPhrase
        self.snmp_auth_passphrase = snmp_auth_passphrase
        # SNMP Auth Protocol
        self.snmp_auth_protocol = snmp_auth_protocol
        # SNMP Privacy Passphase
        self.snmp_privacy_passphase = snmp_privacy_passphase
        # SNMP Privacy Protocol
        self.snmp_privacy_protocol = snmp_privacy_protocol
        # 实例ID
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_ids is not None:
            result['DeviceIds'] = self.device_ids
        if self.login_type is not None:
            result['LoginType'] = self.login_type
        if self.login_username is not None:
            result['LoginUsername'] = self.login_username
        if self.login_password is not None:
            result['LoginPassword'] = self.login_password
        if self.snmp_account_version is not None:
            result['SnmpAccountVersion'] = self.snmp_account_version
        if self.snmp_community is not None:
            result['SnmpCommunity'] = self.snmp_community
        if self.snmp_account_type is not None:
            result['SnmpAccountType'] = self.snmp_account_type
        if self.snmp_security_level is not None:
            result['SnmpSecurityLevel'] = self.snmp_security_level
        if self.snmp_user_name is not None:
            result['SnmpUserName'] = self.snmp_user_name
        if self.snmp_auth_passphrase is not None:
            result['SnmpAuthPassphrase'] = self.snmp_auth_passphrase
        if self.snmp_auth_protocol is not None:
            result['SnmpAuthProtocol'] = self.snmp_auth_protocol
        if self.snmp_privacy_passphase is not None:
            result['SnmpPrivacyPassphase'] = self.snmp_privacy_passphase
        if self.snmp_privacy_protocol is not None:
            result['SnmpPrivacyProtocol'] = self.snmp_privacy_protocol
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeviceIds') is not None:
            self.device_ids = m.get('DeviceIds')
        if m.get('LoginType') is not None:
            self.login_type = m.get('LoginType')
        if m.get('LoginUsername') is not None:
            self.login_username = m.get('LoginUsername')
        if m.get('LoginPassword') is not None:
            self.login_password = m.get('LoginPassword')
        if m.get('SnmpAccountVersion') is not None:
            self.snmp_account_version = m.get('SnmpAccountVersion')
        if m.get('SnmpCommunity') is not None:
            self.snmp_community = m.get('SnmpCommunity')
        if m.get('SnmpAccountType') is not None:
            self.snmp_account_type = m.get('SnmpAccountType')
        if m.get('SnmpSecurityLevel') is not None:
            self.snmp_security_level = m.get('SnmpSecurityLevel')
        if m.get('SnmpUserName') is not None:
            self.snmp_user_name = m.get('SnmpUserName')
        if m.get('SnmpAuthPassphrase') is not None:
            self.snmp_auth_passphrase = m.get('SnmpAuthPassphrase')
        if m.get('SnmpAuthProtocol') is not None:
            self.snmp_auth_protocol = m.get('SnmpAuthProtocol')
        if m.get('SnmpPrivacyPassphase') is not None:
            self.snmp_privacy_passphase = m.get('SnmpPrivacyPassphase')
        if m.get('SnmpPrivacyProtocol') is not None:
            self.snmp_privacy_protocol = m.get('SnmpPrivacyProtocol')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class UpdateDevicesResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # Id of the request
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class UpdateDevicesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: UpdateDevicesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = UpdateDevicesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class UpdateScheduleTypeRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        schedule_type_id: str = None,
        schedule_type: str = None,
        related_worker: List[str] = None,
        status: str = None,
    ):
        # instanceId
        self.instance_id = instance_id
        # 资源一级ID
        self.schedule_type_id = schedule_type_id
        # 值班类型key
        self.schedule_type = schedule_type
        # relatedWorkerStr
        self.related_worker = related_worker
        # 值班类型状态
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.schedule_type_id is not None:
            result['ScheduleTypeId'] = self.schedule_type_id
        if self.schedule_type is not None:
            result['ScheduleType'] = self.schedule_type
        if self.related_worker is not None:
            result['RelatedWorker'] = self.related_worker
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ScheduleTypeId') is not None:
            self.schedule_type_id = m.get('ScheduleTypeId')
        if m.get('ScheduleType') is not None:
            self.schedule_type = m.get('ScheduleType')
        if m.get('RelatedWorker') is not None:
            self.related_worker = m.get('RelatedWorker')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class UpdateScheduleTypeShrinkRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        schedule_type_id: str = None,
        schedule_type: str = None,
        related_worker_shrink: str = None,
        status: str = None,
    ):
        # instanceId
        self.instance_id = instance_id
        # 资源一级ID
        self.schedule_type_id = schedule_type_id
        # 值班类型key
        self.schedule_type = schedule_type
        # relatedWorkerStr
        self.related_worker_shrink = related_worker_shrink
        # 值班类型状态
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.schedule_type_id is not None:
            result['ScheduleTypeId'] = self.schedule_type_id
        if self.schedule_type is not None:
            result['ScheduleType'] = self.schedule_type
        if self.related_worker_shrink is not None:
            result['RelatedWorker'] = self.related_worker_shrink
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ScheduleTypeId') is not None:
            self.schedule_type_id = m.get('ScheduleTypeId')
        if m.get('ScheduleType') is not None:
            self.schedule_type = m.get('ScheduleType')
        if m.get('RelatedWorker') is not None:
            self.related_worker_shrink = m.get('RelatedWorker')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class UpdateScheduleTypeResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # Id of the request
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class UpdateScheduleTypeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: UpdateScheduleTypeResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = UpdateScheduleTypeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DownloadDeviceResourceRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        device_resource_id: str = None,
        device_resource_ids: List[str] = None,
        download_type: str = None,
        setup_project_id: str = None,
    ):
        # instanceId
        self.instance_id = instance_id
        # deviceResourceId
        self.device_resource_id = device_resource_id
        # 资源uuid
        self.device_resource_ids = device_resource_ids
        # 操作类型
        self.download_type = download_type
        # 建设项目id
        self.setup_project_id = setup_project_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.device_resource_id is not None:
            result['DeviceResourceId'] = self.device_resource_id
        if self.device_resource_ids is not None:
            result['DeviceResourceIds'] = self.device_resource_ids
        if self.download_type is not None:
            result['DownloadType'] = self.download_type
        if self.setup_project_id is not None:
            result['SetupProjectId'] = self.setup_project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('DeviceResourceId') is not None:
            self.device_resource_id = m.get('DeviceResourceId')
        if m.get('DeviceResourceIds') is not None:
            self.device_resource_ids = m.get('DeviceResourceIds')
        if m.get('DownloadType') is not None:
            self.download_type = m.get('DownloadType')
        if m.get('SetupProjectId') is not None:
            self.setup_project_id = m.get('SetupProjectId')
        return self


class DownloadDeviceResourceShrinkRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        device_resource_id: str = None,
        device_resource_ids_shrink: str = None,
        download_type: str = None,
        setup_project_id: str = None,
    ):
        # instanceId
        self.instance_id = instance_id
        # deviceResourceId
        self.device_resource_id = device_resource_id
        # 资源uuid
        self.device_resource_ids_shrink = device_resource_ids_shrink
        # 操作类型
        self.download_type = download_type
        # 建设项目id
        self.setup_project_id = setup_project_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.device_resource_id is not None:
            result['DeviceResourceId'] = self.device_resource_id
        if self.device_resource_ids_shrink is not None:
            result['DeviceResourceIds'] = self.device_resource_ids_shrink
        if self.download_type is not None:
            result['DownloadType'] = self.download_type
        if self.setup_project_id is not None:
            result['SetupProjectId'] = self.setup_project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('DeviceResourceId') is not None:
            self.device_resource_id = m.get('DeviceResourceId')
        if m.get('DeviceResourceIds') is not None:
            self.device_resource_ids_shrink = m.get('DeviceResourceIds')
        if m.get('DownloadType') is not None:
            self.download_type = m.get('DownloadType')
        if m.get('SetupProjectId') is not None:
            self.setup_project_id = m.get('SetupProjectId')
        return self


class DownloadDeviceResourceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        download_url: str = None,
    ):
        # Id of the request
        self.request_id = request_id
        # 下载链接
        self.download_url = download_url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.download_url is not None:
            result['DownloadUrl'] = self.download_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('DownloadUrl') is not None:
            self.download_url = m.get('DownloadUrl')
        return self


class DownloadDeviceResourceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DownloadDeviceResourceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DownloadDeviceResourceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetOsDownloadPathRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        os_version_id: str = None,
    ):
        self.instance_id = instance_id
        # 架构资源uuid
        self.os_version_id = os_version_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.os_version_id is not None:
            result['OsVersionId'] = self.os_version_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('OsVersionId') is not None:
            self.os_version_id = m.get('OsVersionId')
        return self


class GetOsDownloadPathResponseBodyOsVersion(TeaModel):
    def __init__(
        self,
        download_path: str = None,
    ):
        # 系统版本下载路径
        self.download_path = download_path

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.download_path is not None:
            result['DownloadPath'] = self.download_path
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DownloadPath') is not None:
            self.download_path = m.get('DownloadPath')
        return self


class GetOsDownloadPathResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        os_version: GetOsDownloadPathResponseBodyOsVersion = None,
    ):
        # Id of the request
        self.request_id = request_id
        # 系统版本
        self.os_version = os_version

    def validate(self):
        if self.os_version:
            self.os_version.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.os_version is not None:
            result['OsVersion'] = self.os_version.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('OsVersion') is not None:
            temp_model = GetOsDownloadPathResponseBodyOsVersion()
            self.os_version = temp_model.from_map(m['OsVersion'])
        return self


class GetOsDownloadPathResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetOsDownloadPathResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetOsDownloadPathResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListConnectionPoliciesRequest(TeaModel):
    def __init__(
        self,
        max_results: int = None,
        next_token: str = None,
        instance_id: str = None,
        architecture_iteration_id: str = None,
        connection_policy_id: str = None,
        uplink_architecture_module_id: str = None,
        downlink_architecture_module_id: str = None,
        uplink_architecture_device_id: str = None,
        downlink_architecture_device_id: str = None,
    ):
        # 返回结果的最大个数。
        self.max_results = max_results
        # 当总结果个数大于MaxResults时，用于翻页的token。
        self.next_token = next_token
        self.instance_id = instance_id
        # 架构迭代uid
        self.architecture_iteration_id = architecture_iteration_id
        # 连接策略id
        self.connection_policy_id = connection_policy_id
        # 上联模块uid
        self.uplink_architecture_module_id = uplink_architecture_module_id
        # 下联模块uid
        self.downlink_architecture_module_id = downlink_architecture_module_id
        # 上联设备uid
        self.uplink_architecture_device_id = uplink_architecture_device_id
        # 下联设备uid
        self.downlink_architecture_device_id = downlink_architecture_device_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.architecture_iteration_id is not None:
            result['ArchitectureIterationId'] = self.architecture_iteration_id
        if self.connection_policy_id is not None:
            result['ConnectionPolicyId'] = self.connection_policy_id
        if self.uplink_architecture_module_id is not None:
            result['UplinkArchitectureModuleId'] = self.uplink_architecture_module_id
        if self.downlink_architecture_module_id is not None:
            result['DownlinkArchitectureModuleId'] = self.downlink_architecture_module_id
        if self.uplink_architecture_device_id is not None:
            result['UplinkArchitectureDeviceId'] = self.uplink_architecture_device_id
        if self.downlink_architecture_device_id is not None:
            result['DownlinkArchitectureDeviceId'] = self.downlink_architecture_device_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ArchitectureIterationId') is not None:
            self.architecture_iteration_id = m.get('ArchitectureIterationId')
        if m.get('ConnectionPolicyId') is not None:
            self.connection_policy_id = m.get('ConnectionPolicyId')
        if m.get('UplinkArchitectureModuleId') is not None:
            self.uplink_architecture_module_id = m.get('UplinkArchitectureModuleId')
        if m.get('DownlinkArchitectureModuleId') is not None:
            self.downlink_architecture_module_id = m.get('DownlinkArchitectureModuleId')
        if m.get('UplinkArchitectureDeviceId') is not None:
            self.uplink_architecture_device_id = m.get('UplinkArchitectureDeviceId')
        if m.get('DownlinkArchitectureDeviceId') is not None:
            self.downlink_architecture_device_id = m.get('DownlinkArchitectureDeviceId')
        return self


class ListConnectionPoliciesResponseBodyConnectionPolicy(TeaModel):
    def __init__(
        self,
        id: str = None,
        architecture_iteration_id: str = None,
        name: str = None,
        link_count: int = None,
        algorithm: str = None,
        create_time: str = None,
        update_time: str = None,
        uplink_architecture_module_id: str = None,
        downlink_architecture_module_id: str = None,
        uplink_architecture_device_id: str = None,
        downlink_architecture_device_id: str = None,
    ):
        # 连接策略uid
        self.id = id
        # 架构迭代uid
        self.architecture_iteration_id = architecture_iteration_id
        # 连接策略名字
        self.name = name
        # 连接数
        self.link_count = link_count
        # 连接策略算法
        self.algorithm = algorithm
        # 创建时间
        self.create_time = create_time
        # 更新是啊金
        self.update_time = update_time
        # 下联模块uid
        self.uplink_architecture_module_id = uplink_architecture_module_id
        # 下联设备uid
        self.downlink_architecture_module_id = downlink_architecture_module_id
        # 上联模块uid
        self.uplink_architecture_device_id = uplink_architecture_device_id
        # 上联设备uid
        self.downlink_architecture_device_id = downlink_architecture_device_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.architecture_iteration_id is not None:
            result['ArchitectureIterationId'] = self.architecture_iteration_id
        if self.name is not None:
            result['Name'] = self.name
        if self.link_count is not None:
            result['LinkCount'] = self.link_count
        if self.algorithm is not None:
            result['Algorithm'] = self.algorithm
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        if self.uplink_architecture_module_id is not None:
            result['UplinkArchitectureModuleId'] = self.uplink_architecture_module_id
        if self.downlink_architecture_module_id is not None:
            result['DownlinkArchitectureModuleId'] = self.downlink_architecture_module_id
        if self.uplink_architecture_device_id is not None:
            result['UplinkArchitectureDeviceId'] = self.uplink_architecture_device_id
        if self.downlink_architecture_device_id is not None:
            result['DownlinkArchitectureDeviceId'] = self.downlink_architecture_device_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('ArchitectureIterationId') is not None:
            self.architecture_iteration_id = m.get('ArchitectureIterationId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('LinkCount') is not None:
            self.link_count = m.get('LinkCount')
        if m.get('Algorithm') is not None:
            self.algorithm = m.get('Algorithm')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        if m.get('UplinkArchitectureModuleId') is not None:
            self.uplink_architecture_module_id = m.get('UplinkArchitectureModuleId')
        if m.get('DownlinkArchitectureModuleId') is not None:
            self.downlink_architecture_module_id = m.get('DownlinkArchitectureModuleId')
        if m.get('UplinkArchitectureDeviceId') is not None:
            self.uplink_architecture_device_id = m.get('UplinkArchitectureDeviceId')
        if m.get('DownlinkArchitectureDeviceId') is not None:
            self.downlink_architecture_device_id = m.get('DownlinkArchitectureDeviceId')
        return self


class ListConnectionPoliciesResponseBody(TeaModel):
    def __init__(
        self,
        total_count: int = None,
        connection_policy: List[ListConnectionPoliciesResponseBodyConnectionPolicy] = None,
        request_id: str = None,
        next_token: int = None,
        max_results: int = None,
    ):
        # 总记录数。
        self.total_count = total_count
        # 数组，返回示例目录。
        self.connection_policy = connection_policy
        # Id of the request
        self.request_id = request_id
        # 当总结果个数大于MaxResults时，用于翻页的token。
        self.next_token = next_token
        # 本次读取的最大数据量
        self.max_results = max_results

    def validate(self):
        if self.connection_policy:
            for k in self.connection_policy:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['ConnectionPolicy'] = []
        if self.connection_policy is not None:
            for k in self.connection_policy:
                result['ConnectionPolicy'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.connection_policy = []
        if m.get('ConnectionPolicy') is not None:
            for k in m.get('ConnectionPolicy'):
                temp_model = ListConnectionPoliciesResponseBodyConnectionPolicy()
                self.connection_policy.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        return self


class ListConnectionPoliciesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListConnectionPoliciesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListConnectionPoliciesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class UpdateScheduleWorkerRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        schedule_worker_id: str = None,
        worker_id: str = None,
        worker_name: str = None,
        worker_contact: str = None,
    ):
        # instanceId
        self.instance_id = instance_id
        # 资源一级ID
        self.schedule_worker_id = schedule_worker_id
        # 值班人员工号
        self.worker_id = worker_id
        # 值班人员姓名
        self.worker_name = worker_name
        # 联系方式
        self.worker_contact = worker_contact

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.schedule_worker_id is not None:
            result['ScheduleWorkerId'] = self.schedule_worker_id
        if self.worker_id is not None:
            result['WorkerId'] = self.worker_id
        if self.worker_name is not None:
            result['WorkerName'] = self.worker_name
        if self.worker_contact is not None:
            result['WorkerContact'] = self.worker_contact
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ScheduleWorkerId') is not None:
            self.schedule_worker_id = m.get('ScheduleWorkerId')
        if m.get('WorkerId') is not None:
            self.worker_id = m.get('WorkerId')
        if m.get('WorkerName') is not None:
            self.worker_name = m.get('WorkerName')
        if m.get('WorkerContact') is not None:
            self.worker_contact = m.get('WorkerContact')
        return self


class UpdateScheduleWorkerResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # Id of the request
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class UpdateScheduleWorkerResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: UpdateScheduleWorkerResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = UpdateScheduleWorkerResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteConfigurationVariateRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        configuration_variate_id: str = None,
    ):
        # instanceId
        self.instance_id = instance_id
        # 实例 ID。
        self.configuration_variate_id = configuration_variate_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.configuration_variate_id is not None:
            result['ConfigurationVariateId'] = self.configuration_variate_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ConfigurationVariateId') is not None:
            self.configuration_variate_id = m.get('ConfigurationVariateId')
        return self


class DeleteConfigurationVariateResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # Id of the request
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteConfigurationVariateResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteConfigurationVariateResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteConfigurationVariateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateScheduleDutyRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        start_date: str = None,
        end_date: str = None,
        schedule_type_ids: List[str] = None,
        client_token: str = None,
    ):
        # instanceId
        self.instance_id = instance_id
        # 开始时间
        self.start_date = start_date
        # 结束时间
        self.end_date = end_date
        # 值班表类型
        self.schedule_type_ids = schedule_type_ids
        # 幂等参数
        self.client_token = client_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.schedule_type_ids is not None:
            result['ScheduleTypeIds'] = self.schedule_type_ids
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('ScheduleTypeIds') is not None:
            self.schedule_type_ids = m.get('ScheduleTypeIds')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        return self


class CreateScheduleDutyShrinkRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        start_date: str = None,
        end_date: str = None,
        schedule_type_ids_shrink: str = None,
        client_token: str = None,
    ):
        # instanceId
        self.instance_id = instance_id
        # 开始时间
        self.start_date = start_date
        # 结束时间
        self.end_date = end_date
        # 值班表类型
        self.schedule_type_ids_shrink = schedule_type_ids_shrink
        # 幂等参数
        self.client_token = client_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.schedule_type_ids_shrink is not None:
            result['ScheduleTypeIds'] = self.schedule_type_ids_shrink
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('ScheduleTypeIds') is not None:
            self.schedule_type_ids_shrink = m.get('ScheduleTypeIds')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        return self


class CreateScheduleDutyResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        schedule_duty_id: str = None,
    ):
        # Id of the request
        self.request_id = request_id
        # 资源实例ID，如ECS实例的创建接口CreateInstance应返回InstanceId。
        self.schedule_duty_id = schedule_duty_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.schedule_duty_id is not None:
            result['ScheduleDutyId'] = self.schedule_duty_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ScheduleDutyId') is not None:
            self.schedule_duty_id = m.get('ScheduleDutyId')
        return self


class CreateScheduleDutyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateScheduleDutyResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateScheduleDutyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetPhysicalSpaceRequest(TeaModel):
    def __init__(
        self,
        physical_space_id: str = None,
        instance_id: str = None,
    ):
        # 实例 ID。
        self.physical_space_id = physical_space_id
        # 实例ID
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.physical_space_id is not None:
            result['PhysicalSpaceId'] = self.physical_space_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PhysicalSpaceId') is not None:
            self.physical_space_id = m.get('PhysicalSpaceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetPhysicalSpaceResponseBodyPhysicalSpace(TeaModel):
    def __init__(
        self,
        physical_space_id: str = None,
        physical_space_name: str = None,
        country: str = None,
        province: str = None,
        city: str = None,
        address: str = None,
        space_type: str = None,
        space_abbreviation: str = None,
        owner: str = None,
    ):
        # 物理空间ID
        self.physical_space_id = physical_space_id
        # 物理空间名称
        self.physical_space_name = physical_space_name
        # 所属国家
        self.country = country
        # 所属省份
        self.province = province
        # 所属城市
        self.city = city
        # 具体地址
        self.address = address
        # 模型
        self.space_type = space_type
        # 缩写
        self.space_abbreviation = space_abbreviation
        # 负责人
        self.owner = owner

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.physical_space_id is not None:
            result['PhysicalSpaceId'] = self.physical_space_id
        if self.physical_space_name is not None:
            result['PhysicalSpaceName'] = self.physical_space_name
        if self.country is not None:
            result['Country'] = self.country
        if self.province is not None:
            result['Province'] = self.province
        if self.city is not None:
            result['City'] = self.city
        if self.address is not None:
            result['Address'] = self.address
        if self.space_type is not None:
            result['SpaceType'] = self.space_type
        if self.space_abbreviation is not None:
            result['SpaceAbbreviation'] = self.space_abbreviation
        if self.owner is not None:
            result['Owner'] = self.owner
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PhysicalSpaceId') is not None:
            self.physical_space_id = m.get('PhysicalSpaceId')
        if m.get('PhysicalSpaceName') is not None:
            self.physical_space_name = m.get('PhysicalSpaceName')
        if m.get('Country') is not None:
            self.country = m.get('Country')
        if m.get('Province') is not None:
            self.province = m.get('Province')
        if m.get('City') is not None:
            self.city = m.get('City')
        if m.get('Address') is not None:
            self.address = m.get('Address')
        if m.get('SpaceType') is not None:
            self.space_type = m.get('SpaceType')
        if m.get('SpaceAbbreviation') is not None:
            self.space_abbreviation = m.get('SpaceAbbreviation')
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        return self


class GetPhysicalSpaceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        physical_space: GetPhysicalSpaceResponseBodyPhysicalSpace = None,
    ):
        # Id of the request
        self.request_id = request_id
        # 物理空间详情
        self.physical_space = physical_space

    def validate(self):
        if self.physical_space:
            self.physical_space.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.physical_space is not None:
            result['PhysicalSpace'] = self.physical_space.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PhysicalSpace') is not None:
            temp_model = GetPhysicalSpaceResponseBodyPhysicalSpace()
            self.physical_space = temp_model.from_map(m['PhysicalSpace'])
        return self


class GetPhysicalSpaceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetPhysicalSpaceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetPhysicalSpaceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteResourceInformationRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        resource_information_id: str = None,
    ):
        # instanceId
        self.instance_id = instance_id
        # 实例 ID。
        self.resource_information_id = resource_information_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.resource_information_id is not None:
            result['ResourceInformationId'] = self.resource_information_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ResourceInformationId') is not None:
            self.resource_information_id = m.get('ResourceInformationId')
        return self


class DeleteResourceInformationResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # Id of the request
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteResourceInformationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteResourceInformationResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteResourceInformationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteSetupProjectRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        setup_project_id: str = None,
    ):
        # instanceId
        self.instance_id = instance_id
        # 实例 ID。
        self.setup_project_id = setup_project_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.setup_project_id is not None:
            result['SetupProjectId'] = self.setup_project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('SetupProjectId') is not None:
            self.setup_project_id = m.get('SetupProjectId')
        return self


class DeleteSetupProjectResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # Id of the request
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteSetupProjectResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteSetupProjectResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteSetupProjectResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDedicatedLineRequest(TeaModel):
    def __init__(
        self,
        physical_space_id: str = None,
        isp: str = None,
        bandwidth: int = None,
        dedicated_line_ip: str = None,
        dedicated_line_gateway: str = None,
        dedicated_line_role: str = None,
        device_id: str = None,
        device_port: str = None,
        client_token: str = None,
        instance_id: str = None,
    ):
        # 物理空间ID
        self.physical_space_id = physical_space_id
        # 运营商
        self.isp = isp
        # 宽带（Mbps）
        self.bandwidth = bandwidth
        # 专线IP
        self.dedicated_line_ip = dedicated_line_ip
        # 专线网关
        self.dedicated_line_gateway = dedicated_line_gateway
        # 专线角色
        self.dedicated_line_role = dedicated_line_role
        # 关联设备ID
        self.device_id = device_id
        # 关联设备端口名称
        self.device_port = device_port
        # 幂等校验 token
        self.client_token = client_token
        # 实例ID
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.physical_space_id is not None:
            result['PhysicalSpaceId'] = self.physical_space_id
        if self.isp is not None:
            result['Isp'] = self.isp
        if self.bandwidth is not None:
            result['Bandwidth'] = self.bandwidth
        if self.dedicated_line_ip is not None:
            result['DedicatedLineIp'] = self.dedicated_line_ip
        if self.dedicated_line_gateway is not None:
            result['DedicatedLineGateway'] = self.dedicated_line_gateway
        if self.dedicated_line_role is not None:
            result['DedicatedLineRole'] = self.dedicated_line_role
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.device_port is not None:
            result['DevicePort'] = self.device_port
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PhysicalSpaceId') is not None:
            self.physical_space_id = m.get('PhysicalSpaceId')
        if m.get('Isp') is not None:
            self.isp = m.get('Isp')
        if m.get('Bandwidth') is not None:
            self.bandwidth = m.get('Bandwidth')
        if m.get('DedicatedLineIp') is not None:
            self.dedicated_line_ip = m.get('DedicatedLineIp')
        if m.get('DedicatedLineGateway') is not None:
            self.dedicated_line_gateway = m.get('DedicatedLineGateway')
        if m.get('DedicatedLineRole') is not None:
            self.dedicated_line_role = m.get('DedicatedLineRole')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('DevicePort') is not None:
            self.device_port = m.get('DevicePort')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class CreateDedicatedLineResponseBody(TeaModel):
    def __init__(
        self,
        dedicated_line_id: str = None,
        request_id: str = None,
    ):
        # 资源实例ID，如ECS实例的创建接口CreateInstance应返回InstanceId。
        self.dedicated_line_id = dedicated_line_id
        # Id of the request
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dedicated_line_id is not None:
            result['DedicatedLineId'] = self.dedicated_line_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DedicatedLineId') is not None:
            self.dedicated_line_id = m.get('DedicatedLineId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateDedicatedLineResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateDedicatedLineResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateDedicatedLineResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ApplyIPRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        ip_type: str = None,
        setup_project_id: str = None,
        business_type_id: str = None,
        device_resource_ids: List[str] = None,
        loopback_port: str = None,
        net_location: str = None,
        business_type_params: str = None,
        device_resource_id: str = None,
    ):
        # instanceId
        self.instance_id = instance_id
        # ip地址类型
        self.ip_type = ip_type
        # 建设项目id
        self.setup_project_id = setup_project_id
        # 业务类型id
        self.business_type_id = business_type_id
        # 设备uuid列表
        self.device_resource_ids = device_resource_ids
        # Loopback端口
        self.loopback_port = loopback_port
        # 位置空间
        self.net_location = net_location
        # 业务参数
        self.business_type_params = business_type_params
        # deviceResourceId
        self.device_resource_id = device_resource_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.ip_type is not None:
            result['IpType'] = self.ip_type
        if self.setup_project_id is not None:
            result['SetupProjectId'] = self.setup_project_id
        if self.business_type_id is not None:
            result['BusinessTypeId'] = self.business_type_id
        if self.device_resource_ids is not None:
            result['DeviceResourceIds'] = self.device_resource_ids
        if self.loopback_port is not None:
            result['LoopbackPort'] = self.loopback_port
        if self.net_location is not None:
            result['NetLocation'] = self.net_location
        if self.business_type_params is not None:
            result['BusinessTypeParams'] = self.business_type_params
        if self.device_resource_id is not None:
            result['DeviceResourceId'] = self.device_resource_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IpType') is not None:
            self.ip_type = m.get('IpType')
        if m.get('SetupProjectId') is not None:
            self.setup_project_id = m.get('SetupProjectId')
        if m.get('BusinessTypeId') is not None:
            self.business_type_id = m.get('BusinessTypeId')
        if m.get('DeviceResourceIds') is not None:
            self.device_resource_ids = m.get('DeviceResourceIds')
        if m.get('LoopbackPort') is not None:
            self.loopback_port = m.get('LoopbackPort')
        if m.get('NetLocation') is not None:
            self.net_location = m.get('NetLocation')
        if m.get('BusinessTypeParams') is not None:
            self.business_type_params = m.get('BusinessTypeParams')
        if m.get('DeviceResourceId') is not None:
            self.device_resource_id = m.get('DeviceResourceId')
        return self


class ApplyIPShrinkRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        ip_type: str = None,
        setup_project_id: str = None,
        business_type_id: str = None,
        device_resource_ids_shrink: str = None,
        loopback_port: str = None,
        net_location: str = None,
        business_type_params: str = None,
        device_resource_id: str = None,
    ):
        # instanceId
        self.instance_id = instance_id
        # ip地址类型
        self.ip_type = ip_type
        # 建设项目id
        self.setup_project_id = setup_project_id
        # 业务类型id
        self.business_type_id = business_type_id
        # 设备uuid列表
        self.device_resource_ids_shrink = device_resource_ids_shrink
        # Loopback端口
        self.loopback_port = loopback_port
        # 位置空间
        self.net_location = net_location
        # 业务参数
        self.business_type_params = business_type_params
        # deviceResourceId
        self.device_resource_id = device_resource_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.ip_type is not None:
            result['IpType'] = self.ip_type
        if self.setup_project_id is not None:
            result['SetupProjectId'] = self.setup_project_id
        if self.business_type_id is not None:
            result['BusinessTypeId'] = self.business_type_id
        if self.device_resource_ids_shrink is not None:
            result['DeviceResourceIds'] = self.device_resource_ids_shrink
        if self.loopback_port is not None:
            result['LoopbackPort'] = self.loopback_port
        if self.net_location is not None:
            result['NetLocation'] = self.net_location
        if self.business_type_params is not None:
            result['BusinessTypeParams'] = self.business_type_params
        if self.device_resource_id is not None:
            result['DeviceResourceId'] = self.device_resource_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IpType') is not None:
            self.ip_type = m.get('IpType')
        if m.get('SetupProjectId') is not None:
            self.setup_project_id = m.get('SetupProjectId')
        if m.get('BusinessTypeId') is not None:
            self.business_type_id = m.get('BusinessTypeId')
        if m.get('DeviceResourceIds') is not None:
            self.device_resource_ids_shrink = m.get('DeviceResourceIds')
        if m.get('LoopbackPort') is not None:
            self.loopback_port = m.get('LoopbackPort')
        if m.get('NetLocation') is not None:
            self.net_location = m.get('NetLocation')
        if m.get('BusinessTypeParams') is not None:
            self.business_type_params = m.get('BusinessTypeParams')
        if m.get('DeviceResourceId') is not None:
            self.device_resource_id = m.get('DeviceResourceId')
        return self


class ApplyIPResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # Id of the request
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ApplyIPResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ApplyIPResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ApplyIPResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class UpdateOsVersionRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        os_version_id: str = None,
        vendor: str = None,
        model: str = None,
        os_version: str = None,
        status: str = None,
        file_name: str = None,
        file_path: str = None,
    ):
        # instanceId
        self.instance_id = instance_id
        # osVersionId
        self.os_version_id = os_version_id
        # 厂商
        self.vendor = vendor
        # 型号
        self.model = model
        # 系统版本
        self.os_version = os_version
        # 状态
        self.status = status
        # 文件名
        self.file_name = file_name
        # 文件路径
        self.file_path = file_path

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.os_version_id is not None:
            result['OsVersionId'] = self.os_version_id
        if self.vendor is not None:
            result['Vendor'] = self.vendor
        if self.model is not None:
            result['Model'] = self.model
        if self.os_version is not None:
            result['OsVersion'] = self.os_version
        if self.status is not None:
            result['Status'] = self.status
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.file_path is not None:
            result['FilePath'] = self.file_path
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('OsVersionId') is not None:
            self.os_version_id = m.get('OsVersionId')
        if m.get('Vendor') is not None:
            self.vendor = m.get('Vendor')
        if m.get('Model') is not None:
            self.model = m.get('Model')
        if m.get('OsVersion') is not None:
            self.os_version = m.get('OsVersion')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('FilePath') is not None:
            self.file_path = m.get('FilePath')
        return self


class UpdateOsVersionResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # Id of the request
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class UpdateOsVersionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: UpdateOsVersionResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = UpdateOsVersionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetSpaceModelInstanceRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        space_id: str = None,
        space_type: str = None,
        operate_type: str = None,
    ):
        # instanceId
        self.instance_id = instance_id
        # 资源id
        self.space_id = space_id
        # 物理空间类型
        self.space_type = space_type
        # 操作类型
        self.operate_type = operate_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.space_id is not None:
            result['SpaceId'] = self.space_id
        if self.space_type is not None:
            result['SpaceType'] = self.space_type
        if self.operate_type is not None:
            result['OperateType'] = self.operate_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('SpaceId') is not None:
            self.space_id = m.get('SpaceId')
        if m.get('SpaceType') is not None:
            self.space_type = m.get('SpaceType')
        if m.get('OperateType') is not None:
            self.operate_type = m.get('OperateType')
        return self


class GetSpaceModelInstanceResponseBodySpaceModel(TeaModel):
    def __init__(
        self,
        instance: str = None,
    ):
        # 物理空间实例
        self.instance = instance

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance is not None:
            result['Instance'] = self.instance
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Instance') is not None:
            self.instance = m.get('Instance')
        return self


class GetSpaceModelInstanceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        space_model: GetSpaceModelInstanceResponseBodySpaceModel = None,
    ):
        # Id of the request
        self.request_id = request_id
        # 建设项目
        self.space_model = space_model

    def validate(self):
        if self.space_model:
            self.space_model.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.space_model is not None:
            result['SpaceModel'] = self.space_model.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SpaceModel') is not None:
            temp_model = GetSpaceModelInstanceResponseBodySpaceModel()
            self.space_model = temp_model.from_map(m['SpaceModel'])
        return self


class GetSpaceModelInstanceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetSpaceModelInstanceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetSpaceModelInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListOsVersionsRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        max_results: int = None,
        next_token: str = None,
    ):
        # instanceId
        self.instance_id = instance_id
        # 返回结果的最大个数。
        self.max_results = max_results
        # 当总结果个数大于MaxResults时，用于翻页的token。
        self.next_token = next_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        return self


class ListOsVersionsResponseBodyOsVersion(TeaModel):
    def __init__(
        self,
        os_version: str = None,
        file_name: str = None,
        status: str = None,
        file_path: str = None,
        create_time: str = None,
        vendor: str = None,
        model: str = None,
        os_version_id: str = None,
        update_time: str = None,
    ):
        # 系统版本
        self.os_version = os_version
        # 文件名
        self.file_name = file_name
        # 状态
        self.status = status
        # 文件路径
        self.file_path = file_path
        # 创建时间
        self.create_time = create_time
        # 厂商
        self.vendor = vendor
        # 型号
        self.model = model
        # 资源uuid
        self.os_version_id = os_version_id
        # 修改时间
        self.update_time = update_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.os_version is not None:
            result['OsVersion'] = self.os_version
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.status is not None:
            result['Status'] = self.status
        if self.file_path is not None:
            result['FilePath'] = self.file_path
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.vendor is not None:
            result['Vendor'] = self.vendor
        if self.model is not None:
            result['Model'] = self.model
        if self.os_version_id is not None:
            result['OsVersionId'] = self.os_version_id
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OsVersion') is not None:
            self.os_version = m.get('OsVersion')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('FilePath') is not None:
            self.file_path = m.get('FilePath')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Vendor') is not None:
            self.vendor = m.get('Vendor')
        if m.get('Model') is not None:
            self.model = m.get('Model')
        if m.get('OsVersionId') is not None:
            self.os_version_id = m.get('OsVersionId')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        return self


class ListOsVersionsResponseBody(TeaModel):
    def __init__(
        self,
        total_count: int = None,
        max_results: int = None,
        request_id: str = None,
        next_token: int = None,
        os_version: List[ListOsVersionsResponseBodyOsVersion] = None,
    ):
        # 总记录数。
        self.total_count = total_count
        # 本次读取的最大数据量
        self.max_results = max_results
        # Id of the request
        self.request_id = request_id
        # 当总结果个数大于MaxResults时，用于翻页的token。
        self.next_token = next_token
        # 数组，返回示例目录。
        self.os_version = os_version

    def validate(self):
        if self.os_version:
            for k in self.os_version:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        result['OsVersion'] = []
        if self.os_version is not None:
            for k in self.os_version:
                result['OsVersion'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        self.os_version = []
        if m.get('OsVersion') is not None:
            for k in m.get('OsVersion'):
                temp_model = ListOsVersionsResponseBodyOsVersion()
                self.os_version.append(temp_model.from_map(k))
        return self


class ListOsVersionsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListOsVersionsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListOsVersionsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDeviceConfigRequest(TeaModel):
    def __init__(
        self,
        device_id: str = None,
        date: str = None,
        instance_id: str = None,
    ):
        # 实例 ID。
        self.device_id = device_id
        # 查询日期，格式 yyyy-MM-dd
        self.date = date
        # 实例ID
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.date is not None:
            result['Date'] = self.date
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('Date') is not None:
            self.date = m.get('Date')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetDeviceConfigResponseBody(TeaModel):
    def __init__(
        self,
        device_config: str = None,
        request_id: str = None,
    ):
        # 设备配置内容
        self.device_config = device_config
        # Id of the request
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_config is not None:
            result['DeviceConfig'] = self.device_config
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeviceConfig') is not None:
            self.device_config = m.get('DeviceConfig')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetDeviceConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetDeviceConfigResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetDeviceConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDedicatedLineRequest(TeaModel):
    def __init__(
        self,
        dedicated_line_id: str = None,
        instance_id: str = None,
    ):
        # 实例 ID。
        self.dedicated_line_id = dedicated_line_id
        # 实例ID
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dedicated_line_id is not None:
            result['DedicatedLineId'] = self.dedicated_line_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DedicatedLineId') is not None:
            self.dedicated_line_id = m.get('DedicatedLineId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetDedicatedLineResponseBodyDedicatedLine(TeaModel):
    def __init__(
        self,
        dedicated_line_id: str = None,
        isp: str = None,
        bandwidth: int = None,
        dedicated_line_ip: str = None,
        dedicated_line_gateway: str = None,
        dedicated_line_role: str = None,
        device_id: str = None,
        device_port: str = None,
        device_name: str = None,
        physical_space_id: str = None,
    ):
        # 专线ID
        self.dedicated_line_id = dedicated_line_id
        # 运营商
        self.isp = isp
        # 宽带（Mbps）
        self.bandwidth = bandwidth
        # 专线IP
        self.dedicated_line_ip = dedicated_line_ip
        # 专线网关
        self.dedicated_line_gateway = dedicated_line_gateway
        # 专线角色
        self.dedicated_line_role = dedicated_line_role
        # 关联设备ID
        self.device_id = device_id
        # 关联设备端口名称
        self.device_port = device_port
        # 关联设备名称
        self.device_name = device_name
        # 物理空间ID
        self.physical_space_id = physical_space_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dedicated_line_id is not None:
            result['DedicatedLineId'] = self.dedicated_line_id
        if self.isp is not None:
            result['Isp'] = self.isp
        if self.bandwidth is not None:
            result['Bandwidth'] = self.bandwidth
        if self.dedicated_line_ip is not None:
            result['DedicatedLineIp'] = self.dedicated_line_ip
        if self.dedicated_line_gateway is not None:
            result['DedicatedLineGateway'] = self.dedicated_line_gateway
        if self.dedicated_line_role is not None:
            result['DedicatedLineRole'] = self.dedicated_line_role
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.device_port is not None:
            result['DevicePort'] = self.device_port
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.physical_space_id is not None:
            result['PhysicalSpaceId'] = self.physical_space_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DedicatedLineId') is not None:
            self.dedicated_line_id = m.get('DedicatedLineId')
        if m.get('Isp') is not None:
            self.isp = m.get('Isp')
        if m.get('Bandwidth') is not None:
            self.bandwidth = m.get('Bandwidth')
        if m.get('DedicatedLineIp') is not None:
            self.dedicated_line_ip = m.get('DedicatedLineIp')
        if m.get('DedicatedLineGateway') is not None:
            self.dedicated_line_gateway = m.get('DedicatedLineGateway')
        if m.get('DedicatedLineRole') is not None:
            self.dedicated_line_role = m.get('DedicatedLineRole')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('DevicePort') is not None:
            self.device_port = m.get('DevicePort')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('PhysicalSpaceId') is not None:
            self.physical_space_id = m.get('PhysicalSpaceId')
        return self


class GetDedicatedLineResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        dedicated_line: GetDedicatedLineResponseBodyDedicatedLine = None,
    ):
        # Id of the request
        self.request_id = request_id
        # 物理空间专线详情
        self.dedicated_line = dedicated_line

    def validate(self):
        if self.dedicated_line:
            self.dedicated_line.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.dedicated_line is not None:
            result['DedicatedLine'] = self.dedicated_line.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('DedicatedLine') is not None:
            temp_model = GetDedicatedLineResponseBodyDedicatedLine()
            self.dedicated_line = temp_model.from_map(m['DedicatedLine'])
        return self


class GetDedicatedLineResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetDedicatedLineResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetDedicatedLineResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDeviceResourceRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        device_resource_id: str = None,
    ):
        # instanceId
        self.instance_id = instance_id
        # 实例 ID。
        self.device_resource_id = device_resource_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.device_resource_id is not None:
            result['DeviceResourceId'] = self.device_resource_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('DeviceResourceId') is not None:
            self.device_resource_id = m.get('DeviceResourceId')
        return self


class GetDeviceResourceResponseBodyDeviceResource(TeaModel):
    def __init__(
        self,
        device_resource_id: str = None,
        setup_project_id: str = None,
        role: str = None,
        block_number: str = None,
        device_num: str = None,
        vendor: str = None,
        model: str = None,
        host_name: str = None,
        sn: str = None,
        location: str = None,
        manager_ip: str = None,
        delivery_ip: str = None,
        generate_config: str = None,
        config_task_status: str = None,
        config: str = None,
        loopback: str = None,
        inter_connection: str = None,
        business: str = None,
        stack: bool = None,
    ):
        # 资源一级ID
        self.device_resource_id = device_resource_id
        # 建设项目id
        self.setup_project_id = setup_project_id
        # 角色
        self.role = role
        # 组号
        self.block_number = block_number
        # 设备号
        self.device_num = device_num
        # 厂商
        self.vendor = vendor
        # 模型
        self.model = model
        # 主机名
        self.host_name = host_name
        # 设备sn号
        self.sn = sn
        # 物理空间位置
        self.location = location
        # 带内管理地址
        self.manager_ip = manager_ip
        # 交付登录地址
        self.delivery_ip = delivery_ip
        # 配置生成
        self.generate_config = generate_config
        # 配置下发状态
        self.config_task_status = config_task_status
        # 设备配置
        self.config = config
        # loopback地址
        self.loopback = loopback
        # 设备互联地址
        self.inter_connection = inter_connection
        # 设备业务地址
        self.business = business
        # 堆叠状态
        self.stack = stack

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_resource_id is not None:
            result['DeviceResourceId'] = self.device_resource_id
        if self.setup_project_id is not None:
            result['SetupProjectId'] = self.setup_project_id
        if self.role is not None:
            result['Role'] = self.role
        if self.block_number is not None:
            result['BlockNumber'] = self.block_number
        if self.device_num is not None:
            result['DeviceNum'] = self.device_num
        if self.vendor is not None:
            result['Vendor'] = self.vendor
        if self.model is not None:
            result['Model'] = self.model
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.sn is not None:
            result['Sn'] = self.sn
        if self.location is not None:
            result['Location'] = self.location
        if self.manager_ip is not None:
            result['ManagerIp'] = self.manager_ip
        if self.delivery_ip is not None:
            result['DeliveryIp'] = self.delivery_ip
        if self.generate_config is not None:
            result['GenerateConfig'] = self.generate_config
        if self.config_task_status is not None:
            result['ConfigTaskStatus'] = self.config_task_status
        if self.config is not None:
            result['Config'] = self.config
        if self.loopback is not None:
            result['Loopback'] = self.loopback
        if self.inter_connection is not None:
            result['InterConnection'] = self.inter_connection
        if self.business is not None:
            result['Business'] = self.business
        if self.stack is not None:
            result['Stack'] = self.stack
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeviceResourceId') is not None:
            self.device_resource_id = m.get('DeviceResourceId')
        if m.get('SetupProjectId') is not None:
            self.setup_project_id = m.get('SetupProjectId')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        if m.get('BlockNumber') is not None:
            self.block_number = m.get('BlockNumber')
        if m.get('DeviceNum') is not None:
            self.device_num = m.get('DeviceNum')
        if m.get('Vendor') is not None:
            self.vendor = m.get('Vendor')
        if m.get('Model') is not None:
            self.model = m.get('Model')
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('Sn') is not None:
            self.sn = m.get('Sn')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('ManagerIp') is not None:
            self.manager_ip = m.get('ManagerIp')
        if m.get('DeliveryIp') is not None:
            self.delivery_ip = m.get('DeliveryIp')
        if m.get('GenerateConfig') is not None:
            self.generate_config = m.get('GenerateConfig')
        if m.get('ConfigTaskStatus') is not None:
            self.config_task_status = m.get('ConfigTaskStatus')
        if m.get('Config') is not None:
            self.config = m.get('Config')
        if m.get('Loopback') is not None:
            self.loopback = m.get('Loopback')
        if m.get('InterConnection') is not None:
            self.inter_connection = m.get('InterConnection')
        if m.get('Business') is not None:
            self.business = m.get('Business')
        if m.get('Stack') is not None:
            self.stack = m.get('Stack')
        return self


class GetDeviceResourceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        device_resource: GetDeviceResourceResponseBodyDeviceResource = None,
    ):
        # Id of the request
        self.request_id = request_id
        # 设备资源
        self.device_resource = device_resource

    def validate(self):
        if self.device_resource:
            self.device_resource.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.device_resource is not None:
            result['DeviceResource'] = self.device_resource.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('DeviceResource') is not None:
            temp_model = GetDeviceResourceResponseBodyDeviceResource()
            self.device_resource = temp_model.from_map(m['DeviceResource'])
        return self


class GetDeviceResourceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetDeviceResourceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetDeviceResourceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDedicatedLineRequest(TeaModel):
    def __init__(
        self,
        dedicated_line_id: str = None,
        instance_id: str = None,
    ):
        # 实例 ID。
        self.dedicated_line_id = dedicated_line_id
        # 实例ID
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dedicated_line_id is not None:
            result['DedicatedLineId'] = self.dedicated_line_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DedicatedLineId') is not None:
            self.dedicated_line_id = m.get('DedicatedLineId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class DeleteDedicatedLineResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # Id of the request
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteDedicatedLineResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteDedicatedLineResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteDedicatedLineResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListIpRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        max_results: int = None,
        next_token: str = None,
        ip_address: str = None,
        ip_block_id: str = None,
    ):
        self.instance_id = instance_id
        # 返回结果的最大个数。
        self.max_results = max_results
        # 当总结果个数大于MaxResults时，用于翻页的token。
        self.next_token = next_token
        # Ip地址
        self.ip_address = ip_address
        # IP地址段的UID
        self.ip_block_id = ip_block_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.ip_address is not None:
            result['IpAddress'] = self.ip_address
        if self.ip_block_id is not None:
            result['IpBlockId'] = self.ip_block_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('IpAddress') is not None:
            self.ip_address = m.get('IpAddress')
        if m.get('IpBlockId') is not None:
            self.ip_block_id = m.get('IpBlockId')
        return self


class ListIpResponseBodyIpZoneLayer(TeaModel):
    def __init__(
        self,
        name: str = None,
        value: str = None,
    ):
        # 园区层级名称
        self.name = name
        # 园区层级值
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class ListIpResponseBodyIp(TeaModel):
    def __init__(
        self,
        port: str = None,
        device_mac: str = None,
        ip_address: str = None,
        ip_id: str = None,
        status: str = None,
        parent_ip_block: str = None,
        create_time: str = None,
        zone_layer: List[ListIpResponseBodyIpZoneLayer] = None,
        business_type_name: str = None,
        business_type_id: str = None,
        device_name: str = None,
    ):
        # 设备端口名称
        self.port = port
        # 设备MAC
        self.device_mac = device_mac
        # IP地址
        self.ip_address = ip_address
        # 资源一级ID
        self.ip_id = ip_id
        # 状态 using available lock
        self.status = status
        # 地址段
        self.parent_ip_block = parent_ip_block
        # 创建时间
        self.create_time = create_time
        # 园区层级
        self.zone_layer = zone_layer
        # 业务类型名称
        self.business_type_name = business_type_name
        # 业务类型UID
        self.business_type_id = business_type_id
        # 设备名称
        self.device_name = device_name

    def validate(self):
        if self.zone_layer:
            for k in self.zone_layer:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.port is not None:
            result['Port'] = self.port
        if self.device_mac is not None:
            result['DeviceMac'] = self.device_mac
        if self.ip_address is not None:
            result['IpAddress'] = self.ip_address
        if self.ip_id is not None:
            result['IpId'] = self.ip_id
        if self.status is not None:
            result['Status'] = self.status
        if self.parent_ip_block is not None:
            result['ParentIpBlock'] = self.parent_ip_block
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        result['ZoneLayer'] = []
        if self.zone_layer is not None:
            for k in self.zone_layer:
                result['ZoneLayer'].append(k.to_map() if k else None)
        if self.business_type_name is not None:
            result['BusinessTypeName'] = self.business_type_name
        if self.business_type_id is not None:
            result['BusinessTypeId'] = self.business_type_id
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('DeviceMac') is not None:
            self.device_mac = m.get('DeviceMac')
        if m.get('IpAddress') is not None:
            self.ip_address = m.get('IpAddress')
        if m.get('IpId') is not None:
            self.ip_id = m.get('IpId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('ParentIpBlock') is not None:
            self.parent_ip_block = m.get('ParentIpBlock')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        self.zone_layer = []
        if m.get('ZoneLayer') is not None:
            for k in m.get('ZoneLayer'):
                temp_model = ListIpResponseBodyIpZoneLayer()
                self.zone_layer.append(temp_model.from_map(k))
        if m.get('BusinessTypeName') is not None:
            self.business_type_name = m.get('BusinessTypeName')
        if m.get('BusinessTypeId') is not None:
            self.business_type_id = m.get('BusinessTypeId')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        return self


class ListIpResponseBody(TeaModel):
    def __init__(
        self,
        total_count: int = None,
        request_id: str = None,
        next_token: str = None,
        max_results: int = None,
        ip: List[ListIpResponseBodyIp] = None,
    ):
        # 总记录数。
        self.total_count = total_count
        # Id of the request
        self.request_id = request_id
        # 当总结果个数大于MaxResults时，用于翻页的token。
        self.next_token = next_token
        # 本次读取的最大数据量
        self.max_results = max_results
        # 数组，返回示例目录。
        self.ip = ip

    def validate(self):
        if self.ip:
            for k in self.ip:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        result['Ip'] = []
        if self.ip is not None:
            for k in self.ip:
                result['Ip'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        self.ip = []
        if m.get('Ip') is not None:
            for k in m.get('Ip'):
                temp_model = ListIpResponseBodyIp()
                self.ip.append(temp_model.from_map(k))
        return self


class ListIpResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListIpResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListIpResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListConfigurationSpecificationsRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        max_results: int = None,
        next_token: str = None,
        architecture: str = None,
        role: str = None,
        vendor: str = None,
        model: str = None,
        specification_name: str = None,
    ):
        # instanceId
        self.instance_id = instance_id
        # 返回结果的最大个数。
        self.max_results = max_results
        # 当总结果个数大于MaxResults时，用于翻页的token。
        self.next_token = next_token
        # 架构类型
        self.architecture = architecture
        # 角色
        self.role = role
        # 厂商
        self.vendor = vendor
        # 型号
        self.model = model
        # 配置规范名字
        self.specification_name = specification_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.architecture is not None:
            result['Architecture'] = self.architecture
        if self.role is not None:
            result['Role'] = self.role
        if self.vendor is not None:
            result['Vendor'] = self.vendor
        if self.model is not None:
            result['Model'] = self.model
        if self.specification_name is not None:
            result['SpecificationName'] = self.specification_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('Architecture') is not None:
            self.architecture = m.get('Architecture')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        if m.get('Vendor') is not None:
            self.vendor = m.get('Vendor')
        if m.get('Model') is not None:
            self.model = m.get('Model')
        if m.get('SpecificationName') is not None:
            self.specification_name = m.get('SpecificationName')
        return self


class ListConfigurationSpecificationsResponseBodyConfigurationSpecification(TeaModel):
    def __init__(
        self,
        create_time: str = None,
        update_time: str = None,
        specification_name: str = None,
        architecture: str = None,
        role: str = None,
        model: str = None,
        vendor: str = None,
        specification_content: str = None,
        related_variate: List[str] = None,
        configuration_specification_id: str = None,
    ):
        # 创建时间
        self.create_time = create_time
        # 更新时间
        self.update_time = update_time
        # 配置规范名字
        self.specification_name = specification_name
        # 架构
        self.architecture = architecture
        # 角色
        self.role = role
        # 型号
        self.model = model
        # 厂商
        self.vendor = vendor
        # 规范内容
        self.specification_content = specification_content
        # 相关变量
        self.related_variate = related_variate
        # 配置规范id
        self.configuration_specification_id = configuration_specification_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        if self.specification_name is not None:
            result['SpecificationName'] = self.specification_name
        if self.architecture is not None:
            result['Architecture'] = self.architecture
        if self.role is not None:
            result['Role'] = self.role
        if self.model is not None:
            result['Model'] = self.model
        if self.vendor is not None:
            result['Vendor'] = self.vendor
        if self.specification_content is not None:
            result['SpecificationContent'] = self.specification_content
        if self.related_variate is not None:
            result['RelatedVariate'] = self.related_variate
        if self.configuration_specification_id is not None:
            result['ConfigurationSpecificationId'] = self.configuration_specification_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        if m.get('SpecificationName') is not None:
            self.specification_name = m.get('SpecificationName')
        if m.get('Architecture') is not None:
            self.architecture = m.get('Architecture')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        if m.get('Model') is not None:
            self.model = m.get('Model')
        if m.get('Vendor') is not None:
            self.vendor = m.get('Vendor')
        if m.get('SpecificationContent') is not None:
            self.specification_content = m.get('SpecificationContent')
        if m.get('RelatedVariate') is not None:
            self.related_variate = m.get('RelatedVariate')
        if m.get('ConfigurationSpecificationId') is not None:
            self.configuration_specification_id = m.get('ConfigurationSpecificationId')
        return self


class ListConfigurationSpecificationsResponseBody(TeaModel):
    def __init__(
        self,
        total_count: int = None,
        request_id: str = None,
        next_token: int = None,
        configuration_specification: List[ListConfigurationSpecificationsResponseBodyConfigurationSpecification] = None,
        max_results: int = None,
    ):
        # 总记录数。
        self.total_count = total_count
        # Id of the request
        self.request_id = request_id
        # 当总结果个数大于MaxResults时，用于翻页的token。
        self.next_token = next_token
        # 数组，返回示例目录。
        self.configuration_specification = configuration_specification
        # 本次读取的最大数据量
        self.max_results = max_results

    def validate(self):
        if self.configuration_specification:
            for k in self.configuration_specification:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        result['ConfigurationSpecification'] = []
        if self.configuration_specification is not None:
            for k in self.configuration_specification:
                result['ConfigurationSpecification'].append(k.to_map() if k else None)
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        self.configuration_specification = []
        if m.get('ConfigurationSpecification') is not None:
            for k in m.get('ConfigurationSpecification'):
                temp_model = ListConfigurationSpecificationsResponseBodyConfigurationSpecification()
                self.configuration_specification.append(temp_model.from_map(k))
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        return self


class ListConfigurationSpecificationsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListConfigurationSpecificationsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListConfigurationSpecificationsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class EnableNotificationRequestList(TeaModel):
    def __init__(
        self,
        type: str = None,
        monitor_item_id: str = None,
        device_id: str = None,
        aggregate_data_id: str = None,
        dedicated_line_id: str = None,
        port_collection_id: str = None,
    ):
        # 类型
        self.type = type
        # 监控项ID
        self.monitor_item_id = monitor_item_id
        # 设备ID
        self.device_id = device_id
        # 聚合数据ID
        self.aggregate_data_id = aggregate_data_id
        # 专线ID
        self.dedicated_line_id = dedicated_line_id
        # 端口集ID
        self.port_collection_id = port_collection_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.monitor_item_id is not None:
            result['MonitorItemId'] = self.monitor_item_id
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.aggregate_data_id is not None:
            result['AggregateDataId'] = self.aggregate_data_id
        if self.dedicated_line_id is not None:
            result['DedicatedLineId'] = self.dedicated_line_id
        if self.port_collection_id is not None:
            result['PortCollectionId'] = self.port_collection_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('MonitorItemId') is not None:
            self.monitor_item_id = m.get('MonitorItemId')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('AggregateDataId') is not None:
            self.aggregate_data_id = m.get('AggregateDataId')
        if m.get('DedicatedLineId') is not None:
            self.dedicated_line_id = m.get('DedicatedLineId')
        if m.get('PortCollectionId') is not None:
            self.port_collection_id = m.get('PortCollectionId')
        return self


class EnableNotificationRequest(TeaModel):
    def __init__(
        self,
        list: List[EnableNotificationRequestList] = None,
        instance_id: str = None,
    ):
        # 通知对象
        self.list = list
        # 实例ID
        self.instance_id = instance_id

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = EnableNotificationRequestList()
                self.list.append(temp_model.from_map(k))
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class EnableNotificationResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # request id
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class EnableNotificationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: EnableNotificationResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = EnableNotificationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class UpdateDevicePropertyRequest(TeaModel):
    def __init__(
        self,
        device_property_id: str = None,
        property_format: str = None,
        property_content: str = None,
        property_name: str = None,
        instance_id: str = None,
    ):
        # 实例 ID。
        self.device_property_id = device_property_id
        # 属性格式
        self.property_format = property_format
        # 属性内容
        self.property_content = property_content
        # 属性名称
        self.property_name = property_name
        # 实例ID
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_property_id is not None:
            result['DevicePropertyId'] = self.device_property_id
        if self.property_format is not None:
            result['PropertyFormat'] = self.property_format
        if self.property_content is not None:
            result['PropertyContent'] = self.property_content
        if self.property_name is not None:
            result['PropertyName'] = self.property_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DevicePropertyId') is not None:
            self.device_property_id = m.get('DevicePropertyId')
        if m.get('PropertyFormat') is not None:
            self.property_format = m.get('PropertyFormat')
        if m.get('PropertyContent') is not None:
            self.property_content = m.get('PropertyContent')
        if m.get('PropertyName') is not None:
            self.property_name = m.get('PropertyName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class UpdateDevicePropertyResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # Id of the request
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class UpdateDevicePropertyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: UpdateDevicePropertyResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = UpdateDevicePropertyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListNotificationHistoriesRequest(TeaModel):
    def __init__(
        self,
        next_token: str = None,
        max_results: int = None,
        monitor_item_id: str = None,
        device_id: str = None,
        type: str = None,
        dedicated_line_id: str = None,
        aggregate_data_id: str = None,
        instance_id: str = None,
        port_collection_id: str = None,
    ):
        # 标记当前开始读取的位置，置空表示从头开始
        self.next_token = next_token
        # 本次读取的最大数据记录数量
        self.max_results = max_results
        # 监控项ID
        self.monitor_item_id = monitor_item_id
        # 设备ID
        self.device_id = device_id
        # 类型
        self.type = type
        # 专线ID
        self.dedicated_line_id = dedicated_line_id
        # 聚合数据ID
        self.aggregate_data_id = aggregate_data_id
        # 实例ID
        self.instance_id = instance_id
        # 端口集ID
        self.port_collection_id = port_collection_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.monitor_item_id is not None:
            result['MonitorItemId'] = self.monitor_item_id
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.type is not None:
            result['Type'] = self.type
        if self.dedicated_line_id is not None:
            result['DedicatedLineId'] = self.dedicated_line_id
        if self.aggregate_data_id is not None:
            result['AggregateDataId'] = self.aggregate_data_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.port_collection_id is not None:
            result['PortCollectionId'] = self.port_collection_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('MonitorItemId') is not None:
            self.monitor_item_id = m.get('MonitorItemId')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('DedicatedLineId') is not None:
            self.dedicated_line_id = m.get('DedicatedLineId')
        if m.get('AggregateDataId') is not None:
            self.aggregate_data_id = m.get('AggregateDataId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PortCollectionId') is not None:
            self.port_collection_id = m.get('PortCollectionId')
        return self


class ListNotificationHistoriesResponseBodyNotificationHistories(TeaModel):
    def __init__(
        self,
        time: str = None,
        notification_mode: str = None,
        status: str = None,
        output: str = None,
        message: str = None,
        device_id: str = None,
        monitor_item_id: str = None,
        notification_group_id: str = None,
        notification_group_name: str = None,
        dedicated_line_id: str = None,
        aggregate_data_id: str = None,
        port_collection_id: str = None,
    ):
        # 发送时间
        self.time = time
        # 发送方式
        self.notification_mode = notification_mode
        # 发送状态
        self.status = status
        # 输出内容
        self.output = output
        # 发送内容
        self.message = message
        # 设备ID
        self.device_id = device_id
        # 监控项ID
        self.monitor_item_id = monitor_item_id
        # 通知组ID
        self.notification_group_id = notification_group_id
        # 通知组名称
        self.notification_group_name = notification_group_name
        # 专线ID
        self.dedicated_line_id = dedicated_line_id
        # 聚合数据ID
        self.aggregate_data_id = aggregate_data_id
        # 端口集ID
        self.port_collection_id = port_collection_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.time is not None:
            result['Time'] = self.time
        if self.notification_mode is not None:
            result['NotificationMode'] = self.notification_mode
        if self.status is not None:
            result['Status'] = self.status
        if self.output is not None:
            result['Output'] = self.output
        if self.message is not None:
            result['Message'] = self.message
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.monitor_item_id is not None:
            result['MonitorItemId'] = self.monitor_item_id
        if self.notification_group_id is not None:
            result['NotificationGroupId'] = self.notification_group_id
        if self.notification_group_name is not None:
            result['NotificationGroupName'] = self.notification_group_name
        if self.dedicated_line_id is not None:
            result['DedicatedLineId'] = self.dedicated_line_id
        if self.aggregate_data_id is not None:
            result['AggregateDataId'] = self.aggregate_data_id
        if self.port_collection_id is not None:
            result['PortCollectionId'] = self.port_collection_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Time') is not None:
            self.time = m.get('Time')
        if m.get('NotificationMode') is not None:
            self.notification_mode = m.get('NotificationMode')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Output') is not None:
            self.output = m.get('Output')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('MonitorItemId') is not None:
            self.monitor_item_id = m.get('MonitorItemId')
        if m.get('NotificationGroupId') is not None:
            self.notification_group_id = m.get('NotificationGroupId')
        if m.get('NotificationGroupName') is not None:
            self.notification_group_name = m.get('NotificationGroupName')
        if m.get('DedicatedLineId') is not None:
            self.dedicated_line_id = m.get('DedicatedLineId')
        if m.get('AggregateDataId') is not None:
            self.aggregate_data_id = m.get('AggregateDataId')
        if m.get('PortCollectionId') is not None:
            self.port_collection_id = m.get('PortCollectionId')
        return self


class ListNotificationHistoriesResponseBody(TeaModel):
    def __init__(
        self,
        total_count: int = None,
        request_id: str = None,
        next_token: str = None,
        max_results: int = None,
        notification_histories: List[ListNotificationHistoriesResponseBodyNotificationHistories] = None,
    ):
        # TotalCount本次请求条件下的数据总量，此参数为可选参数，默认可不返回
        self.total_count = total_count
        # request Id
        self.request_id = request_id
        # 表示当前调用返回读取到的位置，空代表数据已经读取完毕
        self.next_token = next_token
        # MaxResults本次请求所返回的最大记录条数
        self.max_results = max_results
        # 数据列表
        self.notification_histories = notification_histories

    def validate(self):
        if self.notification_histories:
            for k in self.notification_histories:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        result['NotificationHistories'] = []
        if self.notification_histories is not None:
            for k in self.notification_histories:
                result['NotificationHistories'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        self.notification_histories = []
        if m.get('NotificationHistories') is not None:
            for k in m.get('NotificationHistories'):
                temp_model = ListNotificationHistoriesResponseBodyNotificationHistories()
                self.notification_histories.append(temp_model.from_map(k))
        return self


class ListNotificationHistoriesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListNotificationHistoriesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListNotificationHistoriesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDevicePropertyRequest(TeaModel):
    def __init__(
        self,
        device_property_id: str = None,
        instance_id: str = None,
    ):
        # 实例 ID。
        self.device_property_id = device_property_id
        # 实例ID
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_property_id is not None:
            result['DevicePropertyId'] = self.device_property_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DevicePropertyId') is not None:
            self.device_property_id = m.get('DevicePropertyId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class DeleteDevicePropertyResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # Id of the request
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteDevicePropertyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteDevicePropertyResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteDevicePropertyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListResourceInstancesRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        setup_project_id: str = None,
    ):
        self.instance_id = instance_id
        # 建设项目资源id
        self.setup_project_id = setup_project_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.setup_project_id is not None:
            result['SetupProjectId'] = self.setup_project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('SetupProjectId') is not None:
            self.setup_project_id = m.get('SetupProjectId')
        return self


class ListResourceInstancesResponseBodyLogicResourceKeyList(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
        key_attribute: str = None,
        key_action: str = None,
        key_description: str = None,
    ):
        self.key = key
        self.value = value
        self.key_attribute = key_attribute
        self.key_action = key_action
        self.key_description = key_description

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        if self.key_attribute is not None:
            result['KeyAttribute'] = self.key_attribute
        if self.key_action is not None:
            result['KeyAction'] = self.key_action
        if self.key_description is not None:
            result['KeyDescription'] = self.key_description
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        if m.get('KeyAttribute') is not None:
            self.key_attribute = m.get('KeyAttribute')
        if m.get('KeyAction') is not None:
            self.key_action = m.get('KeyAction')
        if m.get('KeyDescription') is not None:
            self.key_description = m.get('KeyDescription')
        return self


class ListResourceInstancesResponseBodyLogicResource(TeaModel):
    def __init__(
        self,
        resource_type: str = None,
        resource_attribute: str = None,
        key_list: List[ListResourceInstancesResponseBodyLogicResourceKeyList] = None,
    ):
        self.resource_type = resource_type
        self.resource_attribute = resource_attribute
        self.key_list = key_list

    def validate(self):
        if self.key_list:
            for k in self.key_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        if self.resource_attribute is not None:
            result['ResourceAttribute'] = self.resource_attribute
        result['KeyList'] = []
        if self.key_list is not None:
            for k in self.key_list:
                result['KeyList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        if m.get('ResourceAttribute') is not None:
            self.resource_attribute = m.get('ResourceAttribute')
        self.key_list = []
        if m.get('KeyList') is not None:
            for k in m.get('KeyList'):
                temp_model = ListResourceInstancesResponseBodyLogicResourceKeyList()
                self.key_list.append(temp_model.from_map(k))
        return self


class ListResourceInstancesResponseBody(TeaModel):
    def __init__(
        self,
        logic_resource: List[ListResourceInstancesResponseBodyLogicResource] = None,
        request_id: str = None,
    ):
        self.logic_resource = logic_resource
        # 请求id
        self.request_id = request_id

    def validate(self):
        if self.logic_resource:
            for k in self.logic_resource:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['LogicResource'] = []
        if self.logic_resource is not None:
            for k in self.logic_resource:
                result['LogicResource'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.logic_resource = []
        if m.get('LogicResource') is not None:
            for k in m.get('LogicResource'):
                temp_model = ListResourceInstancesResponseBodyLogicResource()
                self.logic_resource.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListResourceInstancesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListResourceInstancesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListResourceInstancesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListIpBlocksRequest(TeaModel):
    def __init__(
        self,
        max_results: int = None,
        next_token: str = None,
        instance_id: str = None,
        net_type: str = None,
        tree_type: bool = None,
        ip_block: str = None,
        ip: str = None,
        status: str = None,
        zone_name: str = None,
        net_business: str = None,
    ):
        # 返回结果的最大个数。
        self.max_results = max_results
        # 当总结果个数大于MaxResults时，用于翻页的token。
        self.next_token = next_token
        self.instance_id = instance_id
        # 网络类型 PRIVATE PUBLIC
        self.net_type = net_type
        # 是否树状展示地址段
        self.tree_type = tree_type
        # 地址段
        self.ip_block = ip_block
        # IP地址
        self.ip = ip
        # 地址段状态
        self.status = status
        # 园区名称，NetType为PUBLIC有效
        self.zone_name = zone_name
        # 公网地址类型，NetType为PUBLIC有效
        self.net_business = net_business

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.net_type is not None:
            result['NetType'] = self.net_type
        if self.tree_type is not None:
            result['TreeType'] = self.tree_type
        if self.ip_block is not None:
            result['IpBlock'] = self.ip_block
        if self.ip is not None:
            result['Ip'] = self.ip
        if self.status is not None:
            result['Status'] = self.status
        if self.zone_name is not None:
            result['ZoneName'] = self.zone_name
        if self.net_business is not None:
            result['NetBusiness'] = self.net_business
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('NetType') is not None:
            self.net_type = m.get('NetType')
        if m.get('TreeType') is not None:
            self.tree_type = m.get('TreeType')
        if m.get('IpBlock') is not None:
            self.ip_block = m.get('IpBlock')
        if m.get('Ip') is not None:
            self.ip = m.get('Ip')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('ZoneName') is not None:
            self.zone_name = m.get('ZoneName')
        if m.get('NetBusiness') is not None:
            self.net_business = m.get('NetBusiness')
        return self


class ListIpBlocksResponseBodyIpBlockZoneLayer(TeaModel):
    def __init__(
        self,
        name: str = None,
        value: str = None,
    ):
        # 园区层级名称
        self.name = name
        # 园区层级值
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class ListIpBlocksResponseBodyIpBlock(TeaModel):
    def __init__(
        self,
        ip_block_id: str = None,
        ip_block_code: str = None,
        parent_id: str = None,
        net_type: str = None,
        status: str = None,
        ownership: str = None,
        category: str = None,
        description: str = None,
        backup_device_name: str = None,
        zone_layer: List[ListIpBlocksResponseBodyIpBlockZoneLayer] = None,
        business_type_id: str = None,
        business_type_name: str = None,
        net_business: str = None,
        application: str = None,
        device_name: str = None,
        zone_name: str = None,
        ip_blocks: List[str] = None,
    ):
        # IP地址段UID
        self.ip_block_id = ip_block_id
        # IP段
        self.ip_block_code = ip_block_code
        # 父地址段UID
        self.parent_id = parent_id
        # 公网私网标志 PUBLIC PRIVATE
        self.net_type = net_type
        # 状态： using available lock
        self.status = status
        # IP归属
        self.ownership = ownership
        # 地址类别 IPV4
        self.category = category
        # 备注
        self.description = description
        # 备份设备名称
        self.backup_device_name = backup_device_name
        # 园区层级
        self.zone_layer = zone_layer
        # 业务类型UID
        self.business_type_id = business_type_id
        # 业务类型名称
        self.business_type_name = business_type_name
        # 公网地址类型 INC GUEST VIP
        self.net_business = net_business
        # IP用途
        self.application = application
        # 设备名称
        self.device_name = device_name
        # 园区名称
        self.zone_name = zone_name
        # 地址段子段列表
        self.ip_blocks = ip_blocks

    def validate(self):
        if self.zone_layer:
            for k in self.zone_layer:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ip_block_id is not None:
            result['IpBlockId'] = self.ip_block_id
        if self.ip_block_code is not None:
            result['IpBlockCode'] = self.ip_block_code
        if self.parent_id is not None:
            result['ParentId'] = self.parent_id
        if self.net_type is not None:
            result['NetType'] = self.net_type
        if self.status is not None:
            result['Status'] = self.status
        if self.ownership is not None:
            result['Ownership'] = self.ownership
        if self.category is not None:
            result['Category'] = self.category
        if self.description is not None:
            result['Description'] = self.description
        if self.backup_device_name is not None:
            result['BackupDeviceName'] = self.backup_device_name
        result['ZoneLayer'] = []
        if self.zone_layer is not None:
            for k in self.zone_layer:
                result['ZoneLayer'].append(k.to_map() if k else None)
        if self.business_type_id is not None:
            result['BusinessTypeId'] = self.business_type_id
        if self.business_type_name is not None:
            result['BusinessTypeName'] = self.business_type_name
        if self.net_business is not None:
            result['NetBusiness'] = self.net_business
        if self.application is not None:
            result['Application'] = self.application
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.zone_name is not None:
            result['ZoneName'] = self.zone_name
        if self.ip_blocks is not None:
            result['IpBlocks'] = self.ip_blocks
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IpBlockId') is not None:
            self.ip_block_id = m.get('IpBlockId')
        if m.get('IpBlockCode') is not None:
            self.ip_block_code = m.get('IpBlockCode')
        if m.get('ParentId') is not None:
            self.parent_id = m.get('ParentId')
        if m.get('NetType') is not None:
            self.net_type = m.get('NetType')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Ownership') is not None:
            self.ownership = m.get('Ownership')
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('BackupDeviceName') is not None:
            self.backup_device_name = m.get('BackupDeviceName')
        self.zone_layer = []
        if m.get('ZoneLayer') is not None:
            for k in m.get('ZoneLayer'):
                temp_model = ListIpBlocksResponseBodyIpBlockZoneLayer()
                self.zone_layer.append(temp_model.from_map(k))
        if m.get('BusinessTypeId') is not None:
            self.business_type_id = m.get('BusinessTypeId')
        if m.get('BusinessTypeName') is not None:
            self.business_type_name = m.get('BusinessTypeName')
        if m.get('NetBusiness') is not None:
            self.net_business = m.get('NetBusiness')
        if m.get('Application') is not None:
            self.application = m.get('Application')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('ZoneName') is not None:
            self.zone_name = m.get('ZoneName')
        if m.get('IpBlocks') is not None:
            self.ip_blocks = m.get('IpBlocks')
        return self


class ListIpBlocksResponseBody(TeaModel):
    def __init__(
        self,
        total_count: int = None,
        request_id: str = None,
        next_token: int = None,
        max_results: int = None,
        ip_block: List[ListIpBlocksResponseBodyIpBlock] = None,
    ):
        # 总记录数。
        self.total_count = total_count
        # Id of the request
        self.request_id = request_id
        # 当总结果个数大于MaxResults时，用于翻页的token。
        self.next_token = next_token
        # 每页数量。
        self.max_results = max_results
        # 地址段对象
        self.ip_block = ip_block

    def validate(self):
        if self.ip_block:
            for k in self.ip_block:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        result['IpBlock'] = []
        if self.ip_block is not None:
            for k in self.ip_block:
                result['IpBlock'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        self.ip_block = []
        if m.get('IpBlock') is not None:
            for k in m.get('IpBlock'):
                temp_model = ListIpBlocksResponseBodyIpBlock()
                self.ip_block.append(temp_model.from_map(k))
        return self


class ListIpBlocksResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListIpBlocksResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListIpBlocksResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListDeviceResourcesRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        max_results: int = None,
        next_token: str = None,
        business_type: str = None,
        list_type: str = None,
        setup_project_id: str = None,
    ):
        # instanceId
        self.instance_id = instance_id
        # 返回结果的最大个数。
        self.max_results = max_results
        # 当总结果个数大于MaxResults时，用于翻页的token。
        self.next_token = next_token
        # 业务类型
        self.business_type = business_type
        # List类型
        self.list_type = list_type
        # 建设项目id
        self.setup_project_id = setup_project_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.business_type is not None:
            result['BusinessType'] = self.business_type
        if self.list_type is not None:
            result['ListType'] = self.list_type
        if self.setup_project_id is not None:
            result['SetupProjectId'] = self.setup_project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('BusinessType') is not None:
            self.business_type = m.get('BusinessType')
        if m.get('ListType') is not None:
            self.list_type = m.get('ListType')
        if m.get('SetupProjectId') is not None:
            self.setup_project_id = m.get('SetupProjectId')
        return self


class ListDeviceResourcesResponseBodyDeviceResource(TeaModel):
    def __init__(
        self,
        setup_project_id: str = None,
        device_resource_id: str = None,
        role: str = None,
        block_number: str = None,
        device_number: str = None,
        vendor: str = None,
        model: str = None,
        host_name: str = None,
        sn: str = None,
        config_task_id: str = None,
        location: str = None,
        manager_ip: str = None,
        delivery_ip: str = None,
        generate_config: str = None,
        config_task_status: str = None,
        config: str = None,
        specification: str = None,
        params: str = None,
        loopback: str = None,
        inter_connection: str = None,
        business: str = None,
        stack: bool = None,
    ):
        # 建设项目id
        self.setup_project_id = setup_project_id
        # 资源一级ID
        self.device_resource_id = device_resource_id
        # 角色
        self.role = role
        # 组号
        self.block_number = block_number
        # 设备号
        self.device_number = device_number
        # 厂商
        self.vendor = vendor
        # 模型
        self.model = model
        # 主机名
        self.host_name = host_name
        # 设备sn号
        self.sn = sn
        # 配置任务Id
        self.config_task_id = config_task_id
        # 物理空间位置
        self.location = location
        # 带内管理地址
        self.manager_ip = manager_ip
        # 交付登录地址
        self.delivery_ip = delivery_ip
        # 配置生成
        self.generate_config = generate_config
        # 配置下发状态
        self.config_task_status = config_task_status
        # 设备配置
        self.config = config
        # 配置规范
        self.specification = specification
        # 配置入参
        self.params = params
        # loopback地址
        self.loopback = loopback
        # 设备互联地址
        self.inter_connection = inter_connection
        # 设备业务地址
        self.business = business
        # 堆叠状态
        self.stack = stack

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.setup_project_id is not None:
            result['SetupProjectId'] = self.setup_project_id
        if self.device_resource_id is not None:
            result['DeviceResourceId'] = self.device_resource_id
        if self.role is not None:
            result['Role'] = self.role
        if self.block_number is not None:
            result['BlockNumber'] = self.block_number
        if self.device_number is not None:
            result['DeviceNumber'] = self.device_number
        if self.vendor is not None:
            result['Vendor'] = self.vendor
        if self.model is not None:
            result['Model'] = self.model
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.sn is not None:
            result['Sn'] = self.sn
        if self.config_task_id is not None:
            result['ConfigTaskId'] = self.config_task_id
        if self.location is not None:
            result['Location'] = self.location
        if self.manager_ip is not None:
            result['ManagerIp'] = self.manager_ip
        if self.delivery_ip is not None:
            result['DeliveryIp'] = self.delivery_ip
        if self.generate_config is not None:
            result['GenerateConfig'] = self.generate_config
        if self.config_task_status is not None:
            result['ConfigTaskStatus'] = self.config_task_status
        if self.config is not None:
            result['Config'] = self.config
        if self.specification is not None:
            result['Specification'] = self.specification
        if self.params is not None:
            result['Params'] = self.params
        if self.loopback is not None:
            result['Loopback'] = self.loopback
        if self.inter_connection is not None:
            result['InterConnection'] = self.inter_connection
        if self.business is not None:
            result['Business'] = self.business
        if self.stack is not None:
            result['Stack'] = self.stack
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SetupProjectId') is not None:
            self.setup_project_id = m.get('SetupProjectId')
        if m.get('DeviceResourceId') is not None:
            self.device_resource_id = m.get('DeviceResourceId')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        if m.get('BlockNumber') is not None:
            self.block_number = m.get('BlockNumber')
        if m.get('DeviceNumber') is not None:
            self.device_number = m.get('DeviceNumber')
        if m.get('Vendor') is not None:
            self.vendor = m.get('Vendor')
        if m.get('Model') is not None:
            self.model = m.get('Model')
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('Sn') is not None:
            self.sn = m.get('Sn')
        if m.get('ConfigTaskId') is not None:
            self.config_task_id = m.get('ConfigTaskId')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('ManagerIp') is not None:
            self.manager_ip = m.get('ManagerIp')
        if m.get('DeliveryIp') is not None:
            self.delivery_ip = m.get('DeliveryIp')
        if m.get('GenerateConfig') is not None:
            self.generate_config = m.get('GenerateConfig')
        if m.get('ConfigTaskStatus') is not None:
            self.config_task_status = m.get('ConfigTaskStatus')
        if m.get('Config') is not None:
            self.config = m.get('Config')
        if m.get('Specification') is not None:
            self.specification = m.get('Specification')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('Loopback') is not None:
            self.loopback = m.get('Loopback')
        if m.get('InterConnection') is not None:
            self.inter_connection = m.get('InterConnection')
        if m.get('Business') is not None:
            self.business = m.get('Business')
        if m.get('Stack') is not None:
            self.stack = m.get('Stack')
        return self


class ListDeviceResourcesResponseBody(TeaModel):
    def __init__(
        self,
        total_count: int = None,
        device_resource: List[ListDeviceResourcesResponseBodyDeviceResource] = None,
        request_id: str = None,
        next_token: int = None,
        max_results: int = None,
    ):
        # 总记录数。
        self.total_count = total_count
        # 数组，返回示例目录。
        self.device_resource = device_resource
        # Id of the request
        self.request_id = request_id
        # 当总结果个数大于MaxResults时，用于翻页的token。
        self.next_token = next_token
        # 本次读取的最大数据量
        self.max_results = max_results

    def validate(self):
        if self.device_resource:
            for k in self.device_resource:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['DeviceResource'] = []
        if self.device_resource is not None:
            for k in self.device_resource:
                result['DeviceResource'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.device_resource = []
        if m.get('DeviceResource') is not None:
            for k in m.get('DeviceResource'):
                temp_model = ListDeviceResourcesResponseBodyDeviceResource()
                self.device_resource.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        return self


class ListDeviceResourcesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListDeviceResourcesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListDeviceResourcesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListResourceInformationsRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        max_results: int = None,
        next_token: str = None,
        architecture_id: str = None,
    ):
        # instanceId
        self.instance_id = instance_id
        # 返回结果的最大个数。
        self.max_results = max_results
        # 当总结果个数大于MaxResults时，用于翻页的token。
        self.next_token = next_token
        # 架构id
        self.architecture_id = architecture_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.architecture_id is not None:
            result['ArchitectureId'] = self.architecture_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('ArchitectureId') is not None:
            self.architecture_id = m.get('ArchitectureId')
        return self


class ListResourceInformationsResponseBodyResourceInformationInformation(TeaModel):
    def __init__(
        self,
        key: str = None,
        key_attribute: str = None,
        key_action: str = None,
        key_description: str = None,
    ):
        # 键
        self.key = key
        # 键属性
        self.key_attribute = key_attribute
        # 键动作
        self.key_action = key_action
        # 键描述
        self.key_description = key_description

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.key_attribute is not None:
            result['KeyAttribute'] = self.key_attribute
        if self.key_action is not None:
            result['KeyAction'] = self.key_action
        if self.key_description is not None:
            result['KeyDescription'] = self.key_description
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('KeyAttribute') is not None:
            self.key_attribute = m.get('KeyAttribute')
        if m.get('KeyAction') is not None:
            self.key_action = m.get('KeyAction')
        if m.get('KeyDescription') is not None:
            self.key_description = m.get('KeyDescription')
        return self


class ListResourceInformationsResponseBodyResourceInformation(TeaModel):
    def __init__(
        self,
        information: List[ListResourceInformationsResponseBodyResourceInformationInformation] = None,
        resource_information_id: str = None,
        resource_attribute: str = None,
        resource_type: str = None,
    ):
        # 信息
        self.information = information
        # 资源一级ID
        self.resource_information_id = resource_information_id
        # 资源属性
        self.resource_attribute = resource_attribute
        # 资源类型
        self.resource_type = resource_type

    def validate(self):
        if self.information:
            for k in self.information:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Information'] = []
        if self.information is not None:
            for k in self.information:
                result['Information'].append(k.to_map() if k else None)
        if self.resource_information_id is not None:
            result['ResourceInformationId'] = self.resource_information_id
        if self.resource_attribute is not None:
            result['ResourceAttribute'] = self.resource_attribute
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.information = []
        if m.get('Information') is not None:
            for k in m.get('Information'):
                temp_model = ListResourceInformationsResponseBodyResourceInformationInformation()
                self.information.append(temp_model.from_map(k))
        if m.get('ResourceInformationId') is not None:
            self.resource_information_id = m.get('ResourceInformationId')
        if m.get('ResourceAttribute') is not None:
            self.resource_attribute = m.get('ResourceAttribute')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        return self


class ListResourceInformationsResponseBody(TeaModel):
    def __init__(
        self,
        total_count: int = None,
        request_id: str = None,
        next_token: int = None,
        max_results: int = None,
        resource_information: List[ListResourceInformationsResponseBodyResourceInformation] = None,
    ):
        # 总记录数。
        self.total_count = total_count
        # Id of the request
        self.request_id = request_id
        # 当总结果个数大于MaxResults时，用于翻页的token。
        self.next_token = next_token
        # 本次读取的最大数据量
        self.max_results = max_results
        # 数组，返回示例目录。
        self.resource_information = resource_information

    def validate(self):
        if self.resource_information:
            for k in self.resource_information:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        result['ResourceInformation'] = []
        if self.resource_information is not None:
            for k in self.resource_information:
                result['ResourceInformation'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        self.resource_information = []
        if m.get('ResourceInformation') is not None:
            for k in m.get('ResourceInformation'):
                temp_model = ListResourceInformationsResponseBodyResourceInformation()
                self.resource_information.append(temp_model.from_map(k))
        return self


class ListResourceInformationsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListResourceInformationsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListResourceInformationsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListDeviceFormsRequest(TeaModel):
    def __init__(
        self,
        max_results: int = None,
        next_token: str = None,
        instance_id: str = None,
    ):
        # 返回结果的最大个数。
        self.max_results = max_results
        # 当总结果个数大于MaxResults时，用于翻页的token。
        self.next_token = next_token
        # 实例ID
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class ListDeviceFormsResponseBodyDeviceFormsAttributeList(TeaModel):
    def __init__(
        self,
        attribute_key: str = None,
        attribute_name: str = None,
        attribute_requirement: bool = None,
        attribute_uniqueness: bool = None,
        attribute_format: str = None,
        attribute_type: str = None,
        attribute_reference: str = None,
        attribute_table_display: bool = None,
        attribute_placeholder: str = None,
        attribute_query: bool = None,
        attribute_fuzzy_query: bool = None,
        attribute_built_in: bool = None,
    ):
        # 设备形态属性主键
        self.attribute_key = attribute_key
        # 设备形态属性名称
        self.attribute_name = attribute_name
        # 设备形态属性是否必填
        self.attribute_requirement = attribute_requirement
        # 设备形态属性是否唯一
        self.attribute_uniqueness = attribute_uniqueness
        # 设备形态属性值格式
        self.attribute_format = attribute_format
        # 设备形态属性值类型
        self.attribute_type = attribute_type
        # 设备形态属性关联对象
        self.attribute_reference = attribute_reference
        # 设备形态属性是否表格可见
        self.attribute_table_display = attribute_table_display
        # 前端查询控件占位符
        self.attribute_placeholder = attribute_placeholder
        # 前端是否展示对应的查询控件
        self.attribute_query = attribute_query
        # 前端查询控件是否支持模糊搜索
        self.attribute_fuzzy_query = attribute_fuzzy_query
        # 设备形态属性是否内置
        self.attribute_built_in = attribute_built_in

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.attribute_key is not None:
            result['AttributeKey'] = self.attribute_key
        if self.attribute_name is not None:
            result['AttributeName'] = self.attribute_name
        if self.attribute_requirement is not None:
            result['AttributeRequirement'] = self.attribute_requirement
        if self.attribute_uniqueness is not None:
            result['AttributeUniqueness'] = self.attribute_uniqueness
        if self.attribute_format is not None:
            result['AttributeFormat'] = self.attribute_format
        if self.attribute_type is not None:
            result['AttributeType'] = self.attribute_type
        if self.attribute_reference is not None:
            result['AttributeReference'] = self.attribute_reference
        if self.attribute_table_display is not None:
            result['AttributeTableDisplay'] = self.attribute_table_display
        if self.attribute_placeholder is not None:
            result['AttributePlaceholder'] = self.attribute_placeholder
        if self.attribute_query is not None:
            result['AttributeQuery'] = self.attribute_query
        if self.attribute_fuzzy_query is not None:
            result['AttributeFuzzyQuery'] = self.attribute_fuzzy_query
        if self.attribute_built_in is not None:
            result['AttributeBuiltIn'] = self.attribute_built_in
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AttributeKey') is not None:
            self.attribute_key = m.get('AttributeKey')
        if m.get('AttributeName') is not None:
            self.attribute_name = m.get('AttributeName')
        if m.get('AttributeRequirement') is not None:
            self.attribute_requirement = m.get('AttributeRequirement')
        if m.get('AttributeUniqueness') is not None:
            self.attribute_uniqueness = m.get('AttributeUniqueness')
        if m.get('AttributeFormat') is not None:
            self.attribute_format = m.get('AttributeFormat')
        if m.get('AttributeType') is not None:
            self.attribute_type = m.get('AttributeType')
        if m.get('AttributeReference') is not None:
            self.attribute_reference = m.get('AttributeReference')
        if m.get('AttributeTableDisplay') is not None:
            self.attribute_table_display = m.get('AttributeTableDisplay')
        if m.get('AttributePlaceholder') is not None:
            self.attribute_placeholder = m.get('AttributePlaceholder')
        if m.get('AttributeQuery') is not None:
            self.attribute_query = m.get('AttributeQuery')
        if m.get('AttributeFuzzyQuery') is not None:
            self.attribute_fuzzy_query = m.get('AttributeFuzzyQuery')
        if m.get('AttributeBuiltIn') is not None:
            self.attribute_built_in = m.get('AttributeBuiltIn')
        return self


class ListDeviceFormsResponseBodyDeviceForms(TeaModel):
    def __init__(
        self,
        config_compare: bool = None,
        attribute_list: List[ListDeviceFormsResponseBodyDeviceFormsAttributeList] = None,
        account_config: bool = None,
        detail_display: bool = None,
        form_built_in: bool = None,
        unique_key: str = None,
        device_form_id: str = None,
        device_form_name: str = None,
    ):
        # 是否支持配置生成
        self.config_compare = config_compare
        # 设备形态属性列表
        self.attribute_list = attribute_list
        # 是否需要账号配置
        self.account_config = account_config
        # 是否展示详情
        self.detail_display = detail_display
        # 设备形态是否内置
        self.form_built_in = form_built_in
        # 设备形态主键
        self.unique_key = unique_key
        # 设备形态ID
        self.device_form_id = device_form_id
        # 设备形态名称
        self.device_form_name = device_form_name

    def validate(self):
        if self.attribute_list:
            for k in self.attribute_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_compare is not None:
            result['ConfigCompare'] = self.config_compare
        result['AttributeList'] = []
        if self.attribute_list is not None:
            for k in self.attribute_list:
                result['AttributeList'].append(k.to_map() if k else None)
        if self.account_config is not None:
            result['AccountConfig'] = self.account_config
        if self.detail_display is not None:
            result['DetailDisplay'] = self.detail_display
        if self.form_built_in is not None:
            result['FormBuiltIn'] = self.form_built_in
        if self.unique_key is not None:
            result['UniqueKey'] = self.unique_key
        if self.device_form_id is not None:
            result['DeviceFormId'] = self.device_form_id
        if self.device_form_name is not None:
            result['DeviceFormName'] = self.device_form_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConfigCompare') is not None:
            self.config_compare = m.get('ConfigCompare')
        self.attribute_list = []
        if m.get('AttributeList') is not None:
            for k in m.get('AttributeList'):
                temp_model = ListDeviceFormsResponseBodyDeviceFormsAttributeList()
                self.attribute_list.append(temp_model.from_map(k))
        if m.get('AccountConfig') is not None:
            self.account_config = m.get('AccountConfig')
        if m.get('DetailDisplay') is not None:
            self.detail_display = m.get('DetailDisplay')
        if m.get('FormBuiltIn') is not None:
            self.form_built_in = m.get('FormBuiltIn')
        if m.get('UniqueKey') is not None:
            self.unique_key = m.get('UniqueKey')
        if m.get('DeviceFormId') is not None:
            self.device_form_id = m.get('DeviceFormId')
        if m.get('DeviceFormName') is not None:
            self.device_form_name = m.get('DeviceFormName')
        return self


class ListDeviceFormsResponseBody(TeaModel):
    def __init__(
        self,
        device_forms: List[ListDeviceFormsResponseBodyDeviceForms] = None,
        total_count: int = None,
        request_id: str = None,
        next_token: int = None,
        max_results: int = None,
    ):
        # 数组，返回示例目录。
        self.device_forms = device_forms
        # 总记录数。
        self.total_count = total_count
        # Id of the request
        self.request_id = request_id
        # 当总结果个数大于MaxResults时，用于翻页的token。
        self.next_token = next_token
        # 每页数量。
        self.max_results = max_results

    def validate(self):
        if self.device_forms:
            for k in self.device_forms:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DeviceForms'] = []
        if self.device_forms is not None:
            for k in self.device_forms:
                result['DeviceForms'].append(k.to_map() if k else None)
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.device_forms = []
        if m.get('DeviceForms') is not None:
            for k in m.get('DeviceForms'):
                temp_model = ListDeviceFormsResponseBodyDeviceForms()
                self.device_forms.append(temp_model.from_map(k))
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        return self


class ListDeviceFormsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListDeviceFormsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListDeviceFormsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetConfigurationSpecificationRequest(TeaModel):
    def __init__(
        self,
        configuration_specification_id: str = None,
        instance_id: str = None,
    ):
        # 实例 ID。
        self.configuration_specification_id = configuration_specification_id
        # instanceId
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.configuration_specification_id is not None:
            result['ConfigurationSpecificationId'] = self.configuration_specification_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConfigurationSpecificationId') is not None:
            self.configuration_specification_id = m.get('ConfigurationSpecificationId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetConfigurationSpecificationResponseBodyConfigurationSpecification(TeaModel):
    def __init__(
        self,
        create_time: str = None,
        configuration_specification_id: str = None,
        update_time: str = None,
        specification_name: str = None,
        architecture: str = None,
        role: str = None,
        mode: str = None,
        vendor: str = None,
        specification_content: str = None,
        related_variate: List[str] = None,
    ):
        # 创建时间
        self.create_time = create_time
        # 配置规范资源ID
        self.configuration_specification_id = configuration_specification_id
        # 更新时间
        self.update_time = update_time
        # 配置规范名字
        self.specification_name = specification_name
        # 架构
        self.architecture = architecture
        # 角色
        self.role = role
        # 型号
        self.mode = mode
        # 厂商
        self.vendor = vendor
        # 规范内容
        self.specification_content = specification_content
        # 相关变量
        self.related_variate = related_variate

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.configuration_specification_id is not None:
            result['ConfigurationSpecificationId'] = self.configuration_specification_id
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        if self.specification_name is not None:
            result['SpecificationName'] = self.specification_name
        if self.architecture is not None:
            result['Architecture'] = self.architecture
        if self.role is not None:
            result['Role'] = self.role
        if self.mode is not None:
            result['Mode'] = self.mode
        if self.vendor is not None:
            result['Vendor'] = self.vendor
        if self.specification_content is not None:
            result['SpecificationContent'] = self.specification_content
        if self.related_variate is not None:
            result['RelatedVariate'] = self.related_variate
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('ConfigurationSpecificationId') is not None:
            self.configuration_specification_id = m.get('ConfigurationSpecificationId')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        if m.get('SpecificationName') is not None:
            self.specification_name = m.get('SpecificationName')
        if m.get('Architecture') is not None:
            self.architecture = m.get('Architecture')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        if m.get('Mode') is not None:
            self.mode = m.get('Mode')
        if m.get('Vendor') is not None:
            self.vendor = m.get('Vendor')
        if m.get('SpecificationContent') is not None:
            self.specification_content = m.get('SpecificationContent')
        if m.get('RelatedVariate') is not None:
            self.related_variate = m.get('RelatedVariate')
        return self


class GetConfigurationSpecificationResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        configuration_specification: GetConfigurationSpecificationResponseBodyConfigurationSpecification = None,
    ):
        # Id of the request
        self.request_id = request_id
        # 配置规范对象
        self.configuration_specification = configuration_specification

    def validate(self):
        if self.configuration_specification:
            self.configuration_specification.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.configuration_specification is not None:
            result['ConfigurationSpecification'] = self.configuration_specification.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ConfigurationSpecification') is not None:
            temp_model = GetConfigurationSpecificationResponseBodyConfigurationSpecification()
            self.configuration_specification = temp_model.from_map(m['ConfigurationSpecification'])
        return self


class GetConfigurationSpecificationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetConfigurationSpecificationResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetConfigurationSpecificationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteScheduleDutyRequestTypeWorkerList(TeaModel):
    def __init__(
        self,
        schedule_type_id: str = None,
        schedule_type_name: str = None,
        schedule_worker_name: str = None,
    ):
        self.schedule_type_id = schedule_type_id
        self.schedule_type_name = schedule_type_name
        self.schedule_worker_name = schedule_worker_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.schedule_type_id is not None:
            result['ScheduleTypeId'] = self.schedule_type_id
        if self.schedule_type_name is not None:
            result['ScheduleTypeName'] = self.schedule_type_name
        if self.schedule_worker_name is not None:
            result['ScheduleWorkerName'] = self.schedule_worker_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ScheduleTypeId') is not None:
            self.schedule_type_id = m.get('ScheduleTypeId')
        if m.get('ScheduleTypeName') is not None:
            self.schedule_type_name = m.get('ScheduleTypeName')
        if m.get('ScheduleWorkerName') is not None:
            self.schedule_worker_name = m.get('ScheduleWorkerName')
        return self


class DeleteScheduleDutyRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        schedule_duty_id: str = None,
        type_worker_list: List[DeleteScheduleDutyRequestTypeWorkerList] = None,
    ):
        # instanceId
        self.instance_id = instance_id
        # 实例 ID。
        self.schedule_duty_id = schedule_duty_id
        # typeWorkerList
        self.type_worker_list = type_worker_list

    def validate(self):
        if self.type_worker_list:
            for k in self.type_worker_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.schedule_duty_id is not None:
            result['ScheduleDutyId'] = self.schedule_duty_id
        result['TypeWorkerList'] = []
        if self.type_worker_list is not None:
            for k in self.type_worker_list:
                result['TypeWorkerList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ScheduleDutyId') is not None:
            self.schedule_duty_id = m.get('ScheduleDutyId')
        self.type_worker_list = []
        if m.get('TypeWorkerList') is not None:
            for k in m.get('TypeWorkerList'):
                temp_model = DeleteScheduleDutyRequestTypeWorkerList()
                self.type_worker_list.append(temp_model.from_map(k))
        return self


class DeleteScheduleDutyShrinkRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        schedule_duty_id: str = None,
        type_worker_list_shrink: str = None,
    ):
        # instanceId
        self.instance_id = instance_id
        # 实例 ID。
        self.schedule_duty_id = schedule_duty_id
        # typeWorkerList
        self.type_worker_list_shrink = type_worker_list_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.schedule_duty_id is not None:
            result['ScheduleDutyId'] = self.schedule_duty_id
        if self.type_worker_list_shrink is not None:
            result['TypeWorkerList'] = self.type_worker_list_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ScheduleDutyId') is not None:
            self.schedule_duty_id = m.get('ScheduleDutyId')
        if m.get('TypeWorkerList') is not None:
            self.type_worker_list_shrink = m.get('TypeWorkerList')
        return self


class DeleteScheduleDutyResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # Id of the request
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteScheduleDutyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteScheduleDutyResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteScheduleDutyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class UploadScheduleDutyRequestScheduleDutyWorker(TeaModel):
    def __init__(
        self,
        work_type: str = None,
        worker_name: str = None,
    ):
        # 值班表类型
        self.work_type = work_type
        # 值班人员姓名
        self.worker_name = worker_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.work_type is not None:
            result['WorkType'] = self.work_type
        if self.worker_name is not None:
            result['WorkerName'] = self.worker_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('WorkType') is not None:
            self.work_type = m.get('WorkType')
        if m.get('WorkerName') is not None:
            self.worker_name = m.get('WorkerName')
        return self


class UploadScheduleDutyRequestScheduleDuty(TeaModel):
    def __init__(
        self,
        work_date: str = None,
        worker: List[UploadScheduleDutyRequestScheduleDutyWorker] = None,
    ):
        # 值班表日期
        self.work_date = work_date
        # worker
        self.worker = worker

    def validate(self):
        if self.worker:
            for k in self.worker:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.work_date is not None:
            result['WorkDate'] = self.work_date
        result['Worker'] = []
        if self.worker is not None:
            for k in self.worker:
                result['Worker'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('WorkDate') is not None:
            self.work_date = m.get('WorkDate')
        self.worker = []
        if m.get('Worker') is not None:
            for k in m.get('Worker'):
                temp_model = UploadScheduleDutyRequestScheduleDutyWorker()
                self.worker.append(temp_model.from_map(k))
        return self


class UploadScheduleDutyRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        schedule_duty: List[UploadScheduleDutyRequestScheduleDuty] = None,
    ):
        # instanceId
        self.instance_id = instance_id
        # scheduleDuty
        self.schedule_duty = schedule_duty

    def validate(self):
        if self.schedule_duty:
            for k in self.schedule_duty:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        result['ScheduleDuty'] = []
        if self.schedule_duty is not None:
            for k in self.schedule_duty:
                result['ScheduleDuty'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        self.schedule_duty = []
        if m.get('ScheduleDuty') is not None:
            for k in m.get('ScheduleDuty'):
                temp_model = UploadScheduleDutyRequestScheduleDuty()
                self.schedule_duty.append(temp_model.from_map(k))
        return self


class UploadScheduleDutyShrinkRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        schedule_duty_shrink: str = None,
    ):
        # instanceId
        self.instance_id = instance_id
        # scheduleDuty
        self.schedule_duty_shrink = schedule_duty_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.schedule_duty_shrink is not None:
            result['ScheduleDuty'] = self.schedule_duty_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ScheduleDuty') is not None:
            self.schedule_duty_shrink = m.get('ScheduleDuty')
        return self


class UploadScheduleDutyResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # Id of the request
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class UploadScheduleDutyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: UploadScheduleDutyResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = UploadScheduleDutyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListAlarmStatusHistoriesRequest(TeaModel):
    def __init__(
        self,
        start: int = None,
        end: int = None,
        device_id: str = None,
        monitor_item_id: str = None,
        type: str = None,
        aggregate_data_id: str = None,
        dedicated_line_id: str = None,
        instance_id: str = None,
        port_collection_id: str = None,
    ):
        # 开始时间秒级时间戳
        self.start = start
        # 结束时间秒级时间戳
        self.end = end
        # 设备ID
        self.device_id = device_id
        # 监控项ID
        self.monitor_item_id = monitor_item_id
        # 类型
        self.type = type
        # 聚合数据ID
        self.aggregate_data_id = aggregate_data_id
        # 专线ID
        self.dedicated_line_id = dedicated_line_id
        # 实例ID
        self.instance_id = instance_id
        # 端口集ID
        self.port_collection_id = port_collection_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.start is not None:
            result['Start'] = self.start
        if self.end is not None:
            result['End'] = self.end
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.monitor_item_id is not None:
            result['MonitorItemId'] = self.monitor_item_id
        if self.type is not None:
            result['Type'] = self.type
        if self.aggregate_data_id is not None:
            result['AggregateDataId'] = self.aggregate_data_id
        if self.dedicated_line_id is not None:
            result['DedicatedLineId'] = self.dedicated_line_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.port_collection_id is not None:
            result['PortCollectionId'] = self.port_collection_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Start') is not None:
            self.start = m.get('Start')
        if m.get('End') is not None:
            self.end = m.get('End')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('MonitorItemId') is not None:
            self.monitor_item_id = m.get('MonitorItemId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('AggregateDataId') is not None:
            self.aggregate_data_id = m.get('AggregateDataId')
        if m.get('DedicatedLineId') is not None:
            self.dedicated_line_id = m.get('DedicatedLineId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PortCollectionId') is not None:
            self.port_collection_id = m.get('PortCollectionId')
        return self


class ListAlarmStatusHistoriesResponseBodyAlarmStatusHistories(TeaModel):
    def __init__(
        self,
        timestamp: int = None,
        value: str = None,
    ):
        # 时间戳
        self.timestamp = timestamp
        # 数值
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class ListAlarmStatusHistoriesResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        alarm_status_histories: List[ListAlarmStatusHistoriesResponseBodyAlarmStatusHistories] = None,
    ):
        # request id
        self.request_id = request_id
        # 数据列表
        self.alarm_status_histories = alarm_status_histories

    def validate(self):
        if self.alarm_status_histories:
            for k in self.alarm_status_histories:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['AlarmStatusHistories'] = []
        if self.alarm_status_histories is not None:
            for k in self.alarm_status_histories:
                result['AlarmStatusHistories'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.alarm_status_histories = []
        if m.get('AlarmStatusHistories') is not None:
            for k in m.get('AlarmStatusHistories'):
                temp_model = ListAlarmStatusHistoriesResponseBodyAlarmStatusHistories()
                self.alarm_status_histories.append(temp_model.from_map(k))
        return self


class ListAlarmStatusHistoriesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListAlarmStatusHistoriesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListAlarmStatusHistoriesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetSpaceModelRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        space_model_id: str = None,
    ):
        # instanceId
        self.instance_id = instance_id
        # 实例 ID。
        self.space_model_id = space_model_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.space_model_id is not None:
            result['SpaceModelId'] = self.space_model_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('SpaceModelId') is not None:
            self.space_model_id = m.get('SpaceModelId')
        return self


class GetSpaceModelResponseBodySpaceModelSort(TeaModel):
    def __init__(
        self,
        level_name: str = None,
        level: int = None,
    ):
        # 层级名称
        self.level_name = level_name
        # 层级
        self.level = level

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.level_name is not None:
            result['LevelName'] = self.level_name
        if self.level is not None:
            result['Level'] = self.level
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('LevelName') is not None:
            self.level_name = m.get('LevelName')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        return self


class GetSpaceModelResponseBodySpaceModel(TeaModel):
    def __init__(
        self,
        space_model_id: str = None,
        status: str = None,
        space_type: str = None,
        create_time: str = None,
        update_time: str = None,
        sort: List[GetSpaceModelResponseBodySpaceModelSort] = None,
    ):
        # 物理空间模型id
        self.space_model_id = space_model_id
        # 模型状态
        self.status = status
        # 物理空间类型
        self.space_type = space_type
        # 创建时间
        self.create_time = create_time
        # 更新时间
        self.update_time = update_time
        # 模型实例
        self.sort = sort

    def validate(self):
        if self.sort:
            for k in self.sort:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.space_model_id is not None:
            result['SpaceModelId'] = self.space_model_id
        if self.status is not None:
            result['Status'] = self.status
        if self.space_type is not None:
            result['SpaceType'] = self.space_type
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        result['Sort'] = []
        if self.sort is not None:
            for k in self.sort:
                result['Sort'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SpaceModelId') is not None:
            self.space_model_id = m.get('SpaceModelId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('SpaceType') is not None:
            self.space_type = m.get('SpaceType')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        self.sort = []
        if m.get('Sort') is not None:
            for k in m.get('Sort'):
                temp_model = GetSpaceModelResponseBodySpaceModelSort()
                self.sort.append(temp_model.from_map(k))
        return self


class GetSpaceModelResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        space_model: GetSpaceModelResponseBodySpaceModel = None,
    ):
        # Id of the request
        self.request_id = request_id
        # 物理空间模型
        self.space_model = space_model

    def validate(self):
        if self.space_model:
            self.space_model.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.space_model is not None:
            result['SpaceModel'] = self.space_model.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SpaceModel') is not None:
            temp_model = GetSpaceModelResponseBodySpaceModel()
            self.space_model = temp_model.from_map(m['SpaceModel'])
        return self


class GetSpaceModelResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetSpaceModelResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetSpaceModelResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDeviceFormRequest(TeaModel):
    def __init__(
        self,
        device_form_name: str = None,
        config_compare: bool = None,
        account_config: bool = None,
        detail_display: bool = None,
        unique_key: str = None,
        client_token: str = None,
        instance_id: str = None,
    ):
        # 设备形态名称
        self.device_form_name = device_form_name
        # 是否支持配置生成
        self.config_compare = config_compare
        # 是否需要账号配置
        self.account_config = account_config
        # 是否展示设备详情
        self.detail_display = detail_display
        # 设备形态的主键
        self.unique_key = unique_key
        # 幂等校验 token
        self.client_token = client_token
        # 实例ID
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_form_name is not None:
            result['DeviceFormName'] = self.device_form_name
        if self.config_compare is not None:
            result['ConfigCompare'] = self.config_compare
        if self.account_config is not None:
            result['AccountConfig'] = self.account_config
        if self.detail_display is not None:
            result['DetailDisplay'] = self.detail_display
        if self.unique_key is not None:
            result['UniqueKey'] = self.unique_key
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeviceFormName') is not None:
            self.device_form_name = m.get('DeviceFormName')
        if m.get('ConfigCompare') is not None:
            self.config_compare = m.get('ConfigCompare')
        if m.get('AccountConfig') is not None:
            self.account_config = m.get('AccountConfig')
        if m.get('DetailDisplay') is not None:
            self.detail_display = m.get('DetailDisplay')
        if m.get('UniqueKey') is not None:
            self.unique_key = m.get('UniqueKey')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class CreateDeviceFormResponseBody(TeaModel):
    def __init__(
        self,
        device_form_id: str = None,
        request_id: str = None,
    ):
        # 资源实例ID，如ECS实例的创建接口CreateInstance应返回InstanceId。
        self.device_form_id = device_form_id
        # Id of the request
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_form_id is not None:
            result['DeviceFormId'] = self.device_form_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeviceFormId') is not None:
            self.device_form_id = m.get('DeviceFormId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateDeviceFormResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateDeviceFormResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateDeviceFormResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListPhysicalSpacesRequest(TeaModel):
    def __init__(
        self,
        max_results: int = None,
        next_token: str = None,
        physical_space_ids: List[str] = None,
        physical_space_name: str = None,
        instance_id: str = None,
    ):
        # 返回结果的最大个数。
        self.max_results = max_results
        # 当总结果个数大于MaxResults时，用于翻页的token。
        self.next_token = next_token
        # 物理空间ID
        self.physical_space_ids = physical_space_ids
        # 物理空间名称，支持模糊搜索。
        self.physical_space_name = physical_space_name
        # 实例ID
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.physical_space_ids is not None:
            result['PhysicalSpaceIds'] = self.physical_space_ids
        if self.physical_space_name is not None:
            result['PhysicalSpaceName'] = self.physical_space_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('PhysicalSpaceIds') is not None:
            self.physical_space_ids = m.get('PhysicalSpaceIds')
        if m.get('PhysicalSpaceName') is not None:
            self.physical_space_name = m.get('PhysicalSpaceName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class ListPhysicalSpacesResponseBodyPhysicalSpaces(TeaModel):
    def __init__(
        self,
        physical_space_id: str = None,
        physical_space_name: str = None,
        country: str = None,
        province: str = None,
        city: str = None,
        address: str = None,
        space_abbreviation: str = None,
        space_type: str = None,
        owner: str = None,
        instance: str = None,
    ):
        # 物理空间ID
        self.physical_space_id = physical_space_id
        # 物理空间名称
        self.physical_space_name = physical_space_name
        # 所属国家
        self.country = country
        # 所属省份
        self.province = province
        # 所属城市
        self.city = city
        # 具体地址
        self.address = address
        # 缩写
        self.space_abbreviation = space_abbreviation
        # 模型
        self.space_type = space_type
        # 负责人
        self.owner = owner
        # 实例
        self.instance = instance

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.physical_space_id is not None:
            result['PhysicalSpaceId'] = self.physical_space_id
        if self.physical_space_name is not None:
            result['PhysicalSpaceName'] = self.physical_space_name
        if self.country is not None:
            result['Country'] = self.country
        if self.province is not None:
            result['Province'] = self.province
        if self.city is not None:
            result['City'] = self.city
        if self.address is not None:
            result['Address'] = self.address
        if self.space_abbreviation is not None:
            result['SpaceAbbreviation'] = self.space_abbreviation
        if self.space_type is not None:
            result['SpaceType'] = self.space_type
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.instance is not None:
            result['Instance'] = self.instance
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PhysicalSpaceId') is not None:
            self.physical_space_id = m.get('PhysicalSpaceId')
        if m.get('PhysicalSpaceName') is not None:
            self.physical_space_name = m.get('PhysicalSpaceName')
        if m.get('Country') is not None:
            self.country = m.get('Country')
        if m.get('Province') is not None:
            self.province = m.get('Province')
        if m.get('City') is not None:
            self.city = m.get('City')
        if m.get('Address') is not None:
            self.address = m.get('Address')
        if m.get('SpaceAbbreviation') is not None:
            self.space_abbreviation = m.get('SpaceAbbreviation')
        if m.get('SpaceType') is not None:
            self.space_type = m.get('SpaceType')
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('Instance') is not None:
            self.instance = m.get('Instance')
        return self


class ListPhysicalSpacesResponseBody(TeaModel):
    def __init__(
        self,
        next_token: int = None,
        physical_spaces: List[ListPhysicalSpacesResponseBodyPhysicalSpaces] = None,
        request_id: str = None,
        total_count: int = None,
        max_results: int = None,
    ):
        # 当总结果个数大于MaxResults时，用于翻页的token。
        self.next_token = next_token
        # 数组，返回示例目录。
        self.physical_spaces = physical_spaces
        # Id of the request
        self.request_id = request_id
        # 总记录数。
        self.total_count = total_count
        # 每页数量。
        self.max_results = max_results

    def validate(self):
        if self.physical_spaces:
            for k in self.physical_spaces:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        result['PhysicalSpaces'] = []
        if self.physical_spaces is not None:
            for k in self.physical_spaces:
                result['PhysicalSpaces'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        self.physical_spaces = []
        if m.get('PhysicalSpaces') is not None:
            for k in m.get('PhysicalSpaces'):
                temp_model = ListPhysicalSpacesResponseBodyPhysicalSpaces()
                self.physical_spaces.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        return self


class ListPhysicalSpacesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListPhysicalSpacesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListPhysicalSpacesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListMonitorDataRequest(TeaModel):
    def __init__(
        self,
        start: int = None,
        end: int = None,
        data_type: str = None,
        data_item: str = None,
        monitor_item_id: str = None,
        device_id: str = None,
        key: str = None,
        aggregate_data_id: str = None,
        port_collection_id: str = None,
        dedicated_line_id: str = None,
        instance_id: str = None,
    ):
        # 开始时间
        self.start = start
        # 结束时间
        self.end = end
        # 数据类型
        self.data_type = data_type
        # 数据项
        self.data_item = data_item
        # 监控项ID
        self.monitor_item_id = monitor_item_id
        # 设备ID
        self.device_id = device_id
        # key
        self.key = key
        # 聚合数据ID
        self.aggregate_data_id = aggregate_data_id
        # 端口集ID
        self.port_collection_id = port_collection_id
        # 专线ID
        self.dedicated_line_id = dedicated_line_id
        # 实例ID
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.start is not None:
            result['Start'] = self.start
        if self.end is not None:
            result['End'] = self.end
        if self.data_type is not None:
            result['DataType'] = self.data_type
        if self.data_item is not None:
            result['DataItem'] = self.data_item
        if self.monitor_item_id is not None:
            result['MonitorItemId'] = self.monitor_item_id
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.key is not None:
            result['Key'] = self.key
        if self.aggregate_data_id is not None:
            result['AggregateDataId'] = self.aggregate_data_id
        if self.port_collection_id is not None:
            result['PortCollectionId'] = self.port_collection_id
        if self.dedicated_line_id is not None:
            result['DedicatedLineId'] = self.dedicated_line_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Start') is not None:
            self.start = m.get('Start')
        if m.get('End') is not None:
            self.end = m.get('End')
        if m.get('DataType') is not None:
            self.data_type = m.get('DataType')
        if m.get('DataItem') is not None:
            self.data_item = m.get('DataItem')
        if m.get('MonitorItemId') is not None:
            self.monitor_item_id = m.get('MonitorItemId')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('AggregateDataId') is not None:
            self.aggregate_data_id = m.get('AggregateDataId')
        if m.get('PortCollectionId') is not None:
            self.port_collection_id = m.get('PortCollectionId')
        if m.get('DedicatedLineId') is not None:
            self.dedicated_line_id = m.get('DedicatedLineId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class ListMonitorDataResponseBodyMonitorData(TeaModel):
    def __init__(
        self,
        timestamp: int = None,
        value: str = None,
        data_item: str = None,
        key: str = None,
    ):
        # 时间戳
        self.timestamp = timestamp
        # 数值
        self.value = value
        # 数据项
        self.data_item = data_item
        # key
        self.key = key

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        if self.value is not None:
            result['Value'] = self.value
        if self.data_item is not None:
            result['DataItem'] = self.data_item
        if self.key is not None:
            result['Key'] = self.key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        if m.get('DataItem') is not None:
            self.data_item = m.get('DataItem')
        if m.get('Key') is not None:
            self.key = m.get('Key')
        return self


class ListMonitorDataResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        monitor_data: List[ListMonitorDataResponseBodyMonitorData] = None,
    ):
        # Request Id
        self.request_id = request_id
        # 数据列表
        self.monitor_data = monitor_data

    def validate(self):
        if self.monitor_data:
            for k in self.monitor_data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['MonitorData'] = []
        if self.monitor_data is not None:
            for k in self.monitor_data:
                result['MonitorData'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.monitor_data = []
        if m.get('MonitorData') is not None:
            for k in m.get('MonitorData'):
                temp_model = ListMonitorDataResponseBodyMonitorData()
                self.monitor_data.append(temp_model.from_map(k))
        return self


class ListMonitorDataResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListMonitorDataResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListMonitorDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateResourceInformationRequestInformation(TeaModel):
    def __init__(
        self,
        key: str = None,
        key_attribute: str = None,
        key_action: str = None,
        key_description: str = None,
    ):
        # 键
        self.key = key
        # 键属性
        self.key_attribute = key_attribute
        # 键动作
        self.key_action = key_action
        # 键描述
        self.key_description = key_description

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.key_attribute is not None:
            result['KeyAttribute'] = self.key_attribute
        if self.key_action is not None:
            result['KeyAction'] = self.key_action
        if self.key_description is not None:
            result['KeyDescription'] = self.key_description
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('KeyAttribute') is not None:
            self.key_attribute = m.get('KeyAttribute')
        if m.get('KeyAction') is not None:
            self.key_action = m.get('KeyAction')
        if m.get('KeyDescription') is not None:
            self.key_description = m.get('KeyDescription')
        return self


class CreateResourceInformationRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        resource_type: str = None,
        resource_attribute: str = None,
        architecture_id: str = None,
        information: List[CreateResourceInformationRequestInformation] = None,
        client_token: str = None,
    ):
        # instanceId
        self.instance_id = instance_id
        # 资源类型
        self.resource_type = resource_type
        # 资源属性
        self.resource_attribute = resource_attribute
        # 架构id
        self.architecture_id = architecture_id
        # 信息
        self.information = information
        # 幂等参数
        self.client_token = client_token

    def validate(self):
        if self.information:
            for k in self.information:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        if self.resource_attribute is not None:
            result['ResourceAttribute'] = self.resource_attribute
        if self.architecture_id is not None:
            result['ArchitectureId'] = self.architecture_id
        result['Information'] = []
        if self.information is not None:
            for k in self.information:
                result['Information'].append(k.to_map() if k else None)
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        if m.get('ResourceAttribute') is not None:
            self.resource_attribute = m.get('ResourceAttribute')
        if m.get('ArchitectureId') is not None:
            self.architecture_id = m.get('ArchitectureId')
        self.information = []
        if m.get('Information') is not None:
            for k in m.get('Information'):
                temp_model = CreateResourceInformationRequestInformation()
                self.information.append(temp_model.from_map(k))
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        return self


class CreateResourceInformationResponseBody(TeaModel):
    def __init__(
        self,
        resource_information_id: str = None,
        request_id: str = None,
    ):
        # 资源实例ID，如ECS实例的创建接口CreateInstance应返回InstanceId。
        self.resource_information_id = resource_information_id
        # Id of the request
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_information_id is not None:
            result['ResourceInformationId'] = self.resource_information_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceInformationId') is not None:
            self.resource_information_id = m.get('ResourceInformationId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateResourceInformationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateResourceInformationResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateResourceInformationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class UpdateSpaceModelInstanceRequest(TeaModel):
    def __init__(
        self,
        space_id: str = None,
        instance: str = None,
    ):
        # 物理空间id
        self.space_id = space_id
        # 物理空间实例
        self.instance = instance

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.space_id is not None:
            result['SpaceId'] = self.space_id
        if self.instance is not None:
            result['Instance'] = self.instance
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SpaceId') is not None:
            self.space_id = m.get('SpaceId')
        if m.get('Instance') is not None:
            self.instance = m.get('Instance')
        return self


class UpdateSpaceModelInstanceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # Id of the request
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class UpdateSpaceModelInstanceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: UpdateSpaceModelInstanceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = UpdateSpaceModelInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class UpdateIpRecordRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        client_token: str = None,
        ip_record_id: str = None,
        status: str = None,
    ):
        self.instance_id = instance_id
        # 用于保证请求的幂等性。由客户端生成该参数值，要保证在不同请求间唯一。只支持 ASCII 字符，且不能超过 64 个字符
        self.client_token = client_token
        # 资源一级ID
        self.ip_record_id = ip_record_id
        # 工单状态 running complete fail
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.ip_record_id is not None:
            result['IpRecordId'] = self.ip_record_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('IpRecordId') is not None:
            self.ip_record_id = m.get('IpRecordId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class UpdateIpRecordResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # Id of the request
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class UpdateIpRecordResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: UpdateIpRecordResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = UpdateIpRecordResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ReleaseIPRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        ip_type: str = None,
        setup_project_id: str = None,
        device_resource_ids: List[str] = None,
        device_resource_id: str = None,
    ):
        # instanceId
        self.instance_id = instance_id
        # ip地址类型
        self.ip_type = ip_type
        # 建设项目id
        self.setup_project_id = setup_project_id
        # deviceResourceIdStr
        self.device_resource_ids = device_resource_ids
        # deviceResourceId
        self.device_resource_id = device_resource_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.ip_type is not None:
            result['IpType'] = self.ip_type
        if self.setup_project_id is not None:
            result['SetupProjectId'] = self.setup_project_id
        if self.device_resource_ids is not None:
            result['DeviceResourceIds'] = self.device_resource_ids
        if self.device_resource_id is not None:
            result['DeviceResourceId'] = self.device_resource_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IpType') is not None:
            self.ip_type = m.get('IpType')
        if m.get('SetupProjectId') is not None:
            self.setup_project_id = m.get('SetupProjectId')
        if m.get('DeviceResourceIds') is not None:
            self.device_resource_ids = m.get('DeviceResourceIds')
        if m.get('DeviceResourceId') is not None:
            self.device_resource_id = m.get('DeviceResourceId')
        return self


class ReleaseIPShrinkRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        ip_type: str = None,
        setup_project_id: str = None,
        device_resource_ids_shrink: str = None,
        device_resource_id: str = None,
    ):
        # instanceId
        self.instance_id = instance_id
        # ip地址类型
        self.ip_type = ip_type
        # 建设项目id
        self.setup_project_id = setup_project_id
        # deviceResourceIdStr
        self.device_resource_ids_shrink = device_resource_ids_shrink
        # deviceResourceId
        self.device_resource_id = device_resource_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.ip_type is not None:
            result['IpType'] = self.ip_type
        if self.setup_project_id is not None:
            result['SetupProjectId'] = self.setup_project_id
        if self.device_resource_ids_shrink is not None:
            result['DeviceResourceIds'] = self.device_resource_ids_shrink
        if self.device_resource_id is not None:
            result['DeviceResourceId'] = self.device_resource_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IpType') is not None:
            self.ip_type = m.get('IpType')
        if m.get('SetupProjectId') is not None:
            self.setup_project_id = m.get('SetupProjectId')
        if m.get('DeviceResourceIds') is not None:
            self.device_resource_ids_shrink = m.get('DeviceResourceIds')
        if m.get('DeviceResourceId') is not None:
            self.device_resource_id = m.get('DeviceResourceId')
        return self


class ReleaseIPResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # Id of the request
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ReleaseIPResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ReleaseIPResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ReleaseIPResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDeviceResourceRequest(TeaModel):
    def __init__(
        self,
        device_resource_id: str = None,
        instance_id: str = None,
    ):
        # 实例 ID。
        self.device_resource_id = device_resource_id
        # instanceId
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_resource_id is not None:
            result['DeviceResourceId'] = self.device_resource_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeviceResourceId') is not None:
            self.device_resource_id = m.get('DeviceResourceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class DeleteDeviceResourceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # Id of the request
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteDeviceResourceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteDeviceResourceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteDeviceResourceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetIpBlockRequest(TeaModel):
    def __init__(
        self,
        ip_block_id: str = None,
        instance_id: str = None,
    ):
        # 资源ID
        self.ip_block_id = ip_block_id
        # 实例ID
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ip_block_id is not None:
            result['IpBlockId'] = self.ip_block_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IpBlockId') is not None:
            self.ip_block_id = m.get('IpBlockId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetIpBlockResponseBodyIpBlockZoneLayer(TeaModel):
    def __init__(
        self,
        name: str = None,
        value: str = None,
    ):
        # 园区层级名称
        self.name = name
        # 园区层级值
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class GetIpBlockResponseBodyIpBlock(TeaModel):
    def __init__(
        self,
        ip_block_id: str = None,
        ip_block_code: str = None,
        parent_id: str = None,
        net_type: str = None,
        status: str = None,
        ownership: str = None,
        category: str = None,
        description: str = None,
        backup_device_name: str = None,
        zone_layer: List[GetIpBlockResponseBodyIpBlockZoneLayer] = None,
        business_type_id: str = None,
        business_type_name: str = None,
        net_business: str = None,
        application: str = None,
        device_name: str = None,
        zone_name: str = None,
    ):
        # IP地址段UID
        self.ip_block_id = ip_block_id
        # IP段
        self.ip_block_code = ip_block_code
        # 父地址段UID
        self.parent_id = parent_id
        # 公网私网标志 PUBLIC PRIVATE
        self.net_type = net_type
        # 状态： using available lock
        self.status = status
        # IP归属
        self.ownership = ownership
        # 地址类别 IPV4
        self.category = category
        # 备注
        self.description = description
        # 备份设备名称
        self.backup_device_name = backup_device_name
        # 园区层级
        self.zone_layer = zone_layer
        # 业务类型UID
        self.business_type_id = business_type_id
        # 业务类型名称
        self.business_type_name = business_type_name
        # 公网地址类型 INC GUEST VIP
        self.net_business = net_business
        # IP用途
        self.application = application
        # 设备名称
        self.device_name = device_name
        # 园区名称
        self.zone_name = zone_name

    def validate(self):
        if self.zone_layer:
            for k in self.zone_layer:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ip_block_id is not None:
            result['IpBlockId'] = self.ip_block_id
        if self.ip_block_code is not None:
            result['IpBlockCode'] = self.ip_block_code
        if self.parent_id is not None:
            result['ParentId'] = self.parent_id
        if self.net_type is not None:
            result['NetType'] = self.net_type
        if self.status is not None:
            result['Status'] = self.status
        if self.ownership is not None:
            result['Ownership'] = self.ownership
        if self.category is not None:
            result['Category'] = self.category
        if self.description is not None:
            result['Description'] = self.description
        if self.backup_device_name is not None:
            result['BackupDeviceName'] = self.backup_device_name
        result['ZoneLayer'] = []
        if self.zone_layer is not None:
            for k in self.zone_layer:
                result['ZoneLayer'].append(k.to_map() if k else None)
        if self.business_type_id is not None:
            result['BusinessTypeId'] = self.business_type_id
        if self.business_type_name is not None:
            result['BusinessTypeName'] = self.business_type_name
        if self.net_business is not None:
            result['NetBusiness'] = self.net_business
        if self.application is not None:
            result['Application'] = self.application
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.zone_name is not None:
            result['ZoneName'] = self.zone_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IpBlockId') is not None:
            self.ip_block_id = m.get('IpBlockId')
        if m.get('IpBlockCode') is not None:
            self.ip_block_code = m.get('IpBlockCode')
        if m.get('ParentId') is not None:
            self.parent_id = m.get('ParentId')
        if m.get('NetType') is not None:
            self.net_type = m.get('NetType')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Ownership') is not None:
            self.ownership = m.get('Ownership')
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('BackupDeviceName') is not None:
            self.backup_device_name = m.get('BackupDeviceName')
        self.zone_layer = []
        if m.get('ZoneLayer') is not None:
            for k in m.get('ZoneLayer'):
                temp_model = GetIpBlockResponseBodyIpBlockZoneLayer()
                self.zone_layer.append(temp_model.from_map(k))
        if m.get('BusinessTypeId') is not None:
            self.business_type_id = m.get('BusinessTypeId')
        if m.get('BusinessTypeName') is not None:
            self.business_type_name = m.get('BusinessTypeName')
        if m.get('NetBusiness') is not None:
            self.net_business = m.get('NetBusiness')
        if m.get('Application') is not None:
            self.application = m.get('Application')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('ZoneName') is not None:
            self.zone_name = m.get('ZoneName')
        return self


class GetIpBlockResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        ip_block: GetIpBlockResponseBodyIpBlock = None,
    ):
        # Id of the request
        self.request_id = request_id
        # 园区类型对象
        self.ip_block = ip_block

    def validate(self):
        if self.ip_block:
            self.ip_block.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.ip_block is not None:
            result['IpBlock'] = self.ip_block.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('IpBlock') is not None:
            temp_model = GetIpBlockResponseBodyIpBlock()
            self.ip_block = temp_model.from_map(m['IpBlock'])
        return self


class GetIpBlockResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetIpBlockResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetIpBlockResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteIpBlockRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        ip_block_id: str = None,
    ):
        # 实例 ID。
        self.instance_id = instance_id
        # 资源ID
        self.ip_block_id = ip_block_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.ip_block_id is not None:
            result['IpBlockId'] = self.ip_block_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IpBlockId') is not None:
            self.ip_block_id = m.get('IpBlockId')
        return self


class DeleteIpBlockResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # Id of the request
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteIpBlockResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteIpBlockResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteIpBlockResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteInspectionTaskRequest(TeaModel):
    def __init__(
        self,
        task_id: str = None,
        instance_id: str = None,
    ):
        # 周期性任务的ID
        self.task_id = task_id
        # 实例ID
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class DeleteInspectionTaskResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # 请求ID
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteInspectionTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteInspectionTaskResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteInspectionTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteConfigurationSpecificationRequest(TeaModel):
    def __init__(
        self,
        configuration_specification_id: str = None,
        instance_id: str = None,
    ):
        # 实例 ID。
        self.configuration_specification_id = configuration_specification_id
        # instanceId
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.configuration_specification_id is not None:
            result['ConfigurationSpecificationId'] = self.configuration_specification_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConfigurationSpecificationId') is not None:
            self.configuration_specification_id = m.get('ConfigurationSpecificationId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class DeleteConfigurationSpecificationResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # Id of the request
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteConfigurationSpecificationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteConfigurationSpecificationResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteConfigurationSpecificationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListBusinessTypesRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        max_results: int = None,
        next_token: str = None,
        name: str = None,
        reserve_number: int = None,
        type: str = None,
        zone_type: str = None,
    ):
        self.instance_id = instance_id
        # 返回结果的最大个数。
        self.max_results = max_results
        # 当总结果个数大于MaxResults时，用于翻页的token。
        self.next_token = next_token
        # 业务类型名称
        self.name = name
        # 保留地址数目
        self.reserve_number = reserve_number
        # 业务类型大类
        self.type = type
        # 绑定的园区类型
        self.zone_type = zone_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.name is not None:
            result['Name'] = self.name
        if self.reserve_number is not None:
            result['ReserveNumber'] = self.reserve_number
        if self.type is not None:
            result['Type'] = self.type
        if self.zone_type is not None:
            result['ZoneType'] = self.zone_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ReserveNumber') is not None:
            self.reserve_number = m.get('ReserveNumber')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('ZoneType') is not None:
            self.zone_type = m.get('ZoneType')
        return self


class ListBusinessTypesResponseBodyBusinessType(TeaModel):
    def __init__(
        self,
        update_time: str = None,
        create_time: str = None,
        business_type_id: str = None,
        name: str = None,
        abbreviation: str = None,
        mask: str = None,
        gateway: int = None,
        sharing: str = None,
        direction: int = None,
        reserve_number: int = None,
        type: str = None,
        zone_type: str = None,
        lease_time: str = None,
        vlan: str = None,
        action_flag: str = None,
    ):
        # 修改时间
        self.update_time = update_time
        # 创建时间
        self.create_time = create_time
        # 资源一级ID
        self.business_type_id = business_type_id
        # 业务类型名称
        self.name = name
        # 业务类型缩写
        self.abbreviation = abbreviation
        # 掩码
        self.mask = mask
        # 网关地址位置，正数为正数序号，负数为倒数序号
        self.gateway = gateway
        # 是否复用 reuse/single
        self.sharing = sharing
        # 分配方向，0表示正向，1表示反向
        self.direction = direction
        # 保留地址数目
        self.reserve_number = reserve_number
        # 业务类型大类
        self.type = type
        # 绑定的园区类型
        self.zone_type = zone_type
        # 有效时间
        self.lease_time = lease_time
        # Vlan
        self.vlan = vlan
        # 业务类型地址申请完对应的动作，DHCP表示需要触发DHCP变更
        self.action_flag = action_flag

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.business_type_id is not None:
            result['BusinessTypeId'] = self.business_type_id
        if self.name is not None:
            result['Name'] = self.name
        if self.abbreviation is not None:
            result['Abbreviation'] = self.abbreviation
        if self.mask is not None:
            result['Mask'] = self.mask
        if self.gateway is not None:
            result['Gateway'] = self.gateway
        if self.sharing is not None:
            result['Sharing'] = self.sharing
        if self.direction is not None:
            result['Direction'] = self.direction
        if self.reserve_number is not None:
            result['ReserveNumber'] = self.reserve_number
        if self.type is not None:
            result['Type'] = self.type
        if self.zone_type is not None:
            result['ZoneType'] = self.zone_type
        if self.lease_time is not None:
            result['LeaseTime'] = self.lease_time
        if self.vlan is not None:
            result['Vlan'] = self.vlan
        if self.action_flag is not None:
            result['ActionFlag'] = self.action_flag
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('BusinessTypeId') is not None:
            self.business_type_id = m.get('BusinessTypeId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Abbreviation') is not None:
            self.abbreviation = m.get('Abbreviation')
        if m.get('Mask') is not None:
            self.mask = m.get('Mask')
        if m.get('Gateway') is not None:
            self.gateway = m.get('Gateway')
        if m.get('Sharing') is not None:
            self.sharing = m.get('Sharing')
        if m.get('Direction') is not None:
            self.direction = m.get('Direction')
        if m.get('ReserveNumber') is not None:
            self.reserve_number = m.get('ReserveNumber')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('ZoneType') is not None:
            self.zone_type = m.get('ZoneType')
        if m.get('LeaseTime') is not None:
            self.lease_time = m.get('LeaseTime')
        if m.get('Vlan') is not None:
            self.vlan = m.get('Vlan')
        if m.get('ActionFlag') is not None:
            self.action_flag = m.get('ActionFlag')
        return self


class ListBusinessTypesResponseBody(TeaModel):
    def __init__(
        self,
        total_count: int = None,
        request_id: str = None,
        next_token: int = None,
        max_results: int = None,
        business_type: List[ListBusinessTypesResponseBodyBusinessType] = None,
    ):
        # 总记录数。
        self.total_count = total_count
        # Id of the request
        self.request_id = request_id
        # 当总结果个数大于MaxResults时，用于翻页的token。
        self.next_token = next_token
        # 本次读取的最大数据量
        self.max_results = max_results
        # 数组，返回示例目录。
        self.business_type = business_type

    def validate(self):
        if self.business_type:
            for k in self.business_type:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        result['BusinessType'] = []
        if self.business_type is not None:
            for k in self.business_type:
                result['BusinessType'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        self.business_type = []
        if m.get('BusinessType') is not None:
            for k in m.get('BusinessType'):
                temp_model = ListBusinessTypesResponseBodyBusinessType()
                self.business_type.append(temp_model.from_map(k))
        return self


class ListBusinessTypesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListBusinessTypesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListBusinessTypesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListSetupProjectsRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        max_results: int = None,
        next_token: str = None,
        status: str = None,
        space_id: str = None,
    ):
        # instanceId
        self.instance_id = instance_id
        # 返回结果的最大个数。
        self.max_results = max_results
        # 当总结果个数大于MaxResults时，用于翻页的token。
        self.next_token = next_token
        # 集群名
        self.status = status
        # 物理空间id
        self.space_id = space_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.status is not None:
            result['Status'] = self.status
        if self.space_id is not None:
            result['SpaceId'] = self.space_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('SpaceId') is not None:
            self.space_id = m.get('SpaceId')
        return self


class ListSetupProjectsResponseBodySetupProjectPackages(TeaModel):
    def __init__(
        self,
        role: str = None,
        device_number: int = None,
        vendor: str = None,
        model: str = None,
    ):
        # 角色
        self.role = role
        # 设备号
        self.device_number = device_number
        # 厂商
        self.vendor = vendor
        # 型号
        self.model = model

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.role is not None:
            result['Role'] = self.role
        if self.device_number is not None:
            result['DeviceNumber'] = self.device_number
        if self.vendor is not None:
            result['Vendor'] = self.vendor
        if self.model is not None:
            result['Model'] = self.model
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Role') is not None:
            self.role = m.get('Role')
        if m.get('DeviceNumber') is not None:
            self.device_number = m.get('DeviceNumber')
        if m.get('Vendor') is not None:
            self.vendor = m.get('Vendor')
        if m.get('Model') is not None:
            self.model = m.get('Model')
        return self


class ListSetupProjectsResponseBodySetupProject(TeaModel):
    def __init__(
        self,
        progress: str = None,
        space_type: str = None,
        space_name: str = None,
        arch_version: str = None,
        architecture_id: str = None,
        packages: List[ListSetupProjectsResponseBodySetupProjectPackages] = None,
        delivery_time: str = None,
        create_time: str = None,
        space_id: str = None,
        setup_project_id: str = None,
        nodes: str = None,
        description: str = None,
    ):
        # 项目进展
        self.progress = progress
        # 物理空间类型
        self.space_type = space_type
        # 物理空间名称
        self.space_name = space_name
        # 架构版本
        self.arch_version = arch_version
        # 架构id
        self.architecture_id = architecture_id
        # 套餐
        self.packages = packages
        # 预计交付时间
        self.delivery_time = delivery_time
        # 创建时间
        self.create_time = create_time
        # 物理空间uId
        self.space_id = space_id
        # 资源一级ID
        self.setup_project_id = setup_project_id
        # 节点
        self.nodes = nodes
        # 描述
        self.description = description

    def validate(self):
        if self.packages:
            for k in self.packages:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.progress is not None:
            result['Progress'] = self.progress
        if self.space_type is not None:
            result['SpaceType'] = self.space_type
        if self.space_name is not None:
            result['SpaceName'] = self.space_name
        if self.arch_version is not None:
            result['ArchVersion'] = self.arch_version
        if self.architecture_id is not None:
            result['ArchitectureId'] = self.architecture_id
        result['Packages'] = []
        if self.packages is not None:
            for k in self.packages:
                result['Packages'].append(k.to_map() if k else None)
        if self.delivery_time is not None:
            result['DeliveryTime'] = self.delivery_time
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.space_id is not None:
            result['SpaceId'] = self.space_id
        if self.setup_project_id is not None:
            result['SetupProjectId'] = self.setup_project_id
        if self.nodes is not None:
            result['Nodes'] = self.nodes
        if self.description is not None:
            result['Description'] = self.description
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Progress') is not None:
            self.progress = m.get('Progress')
        if m.get('SpaceType') is not None:
            self.space_type = m.get('SpaceType')
        if m.get('SpaceName') is not None:
            self.space_name = m.get('SpaceName')
        if m.get('ArchVersion') is not None:
            self.arch_version = m.get('ArchVersion')
        if m.get('ArchitectureId') is not None:
            self.architecture_id = m.get('ArchitectureId')
        self.packages = []
        if m.get('Packages') is not None:
            for k in m.get('Packages'):
                temp_model = ListSetupProjectsResponseBodySetupProjectPackages()
                self.packages.append(temp_model.from_map(k))
        if m.get('DeliveryTime') is not None:
            self.delivery_time = m.get('DeliveryTime')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('SpaceId') is not None:
            self.space_id = m.get('SpaceId')
        if m.get('SetupProjectId') is not None:
            self.setup_project_id = m.get('SetupProjectId')
        if m.get('Nodes') is not None:
            self.nodes = m.get('Nodes')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        return self


class ListSetupProjectsResponseBody(TeaModel):
    def __init__(
        self,
        setup_project: List[ListSetupProjectsResponseBodySetupProject] = None,
        total_count: int = None,
        request_id: str = None,
        next_token: int = None,
        max_results: int = None,
    ):
        # 数组，返回示例目录。
        self.setup_project = setup_project
        # 总记录数。
        self.total_count = total_count
        # Id of the request
        self.request_id = request_id
        # 当总结果个数大于MaxResults时，用于翻页的token。
        self.next_token = next_token
        # 本次读取的最大数据量
        self.max_results = max_results

    def validate(self):
        if self.setup_project:
            for k in self.setup_project:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['SetupProject'] = []
        if self.setup_project is not None:
            for k in self.setup_project:
                result['SetupProject'].append(k.to_map() if k else None)
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.setup_project = []
        if m.get('SetupProject') is not None:
            for k in m.get('SetupProject'):
                temp_model = ListSetupProjectsResponseBodySetupProject()
                self.setup_project.append(temp_model.from_map(k))
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        return self


class ListSetupProjectsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListSetupProjectsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListSetupProjectsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListTasksHistoriesRequest(TeaModel):
    def __init__(
        self,
        max_results: int = None,
        next_token: str = None,
        item_id: str = None,
        device_id: str = None,
        instance_id: str = None,
    ):
        # 返回结果的最大个数。
        self.max_results = max_results
        # 当总结果个数大于MaxResults时，用于翻页的token。
        self.next_token = next_token
        # 巡检项ID
        self.item_id = item_id
        # 设备ID
        self.device_id = device_id
        # 实例ID
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.item_id is not None:
            result['ItemId'] = self.item_id
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('ItemId') is not None:
            self.item_id = m.get('ItemId')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class ListTasksHistoriesResponseBodyInspectionTasksInspectionAlarmRules(TeaModel):
    def __init__(
        self,
        alarm_expression: str = None,
        alarm_operator: str = None,
        alarm_value: str = None,
        actual_value: str = None,
        alarm_level: str = None,
    ):
        # 告警表达式
        self.alarm_expression = alarm_expression
        # 告警操作符
        self.alarm_operator = alarm_operator
        # 告警值
        self.alarm_value = alarm_value
        # 告警实际值
        self.actual_value = actual_value
        # 告警级别
        self.alarm_level = alarm_level

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alarm_expression is not None:
            result['AlarmExpression'] = self.alarm_expression
        if self.alarm_operator is not None:
            result['AlarmOperator'] = self.alarm_operator
        if self.alarm_value is not None:
            result['AlarmValue'] = self.alarm_value
        if self.actual_value is not None:
            result['ActualValue'] = self.actual_value
        if self.alarm_level is not None:
            result['AlarmLevel'] = self.alarm_level
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AlarmExpression') is not None:
            self.alarm_expression = m.get('AlarmExpression')
        if m.get('AlarmOperator') is not None:
            self.alarm_operator = m.get('AlarmOperator')
        if m.get('AlarmValue') is not None:
            self.alarm_value = m.get('AlarmValue')
        if m.get('ActualValue') is not None:
            self.actual_value = m.get('ActualValue')
        if m.get('AlarmLevel') is not None:
            self.alarm_level = m.get('AlarmLevel')
        return self


class ListTasksHistoriesResponseBodyInspectionTasks(TeaModel):
    def __init__(
        self,
        execution_end_time: str = None,
        execution_begin_time: str = None,
        inspection_result: str = None,
        inspection_alarm_rules: List[ListTasksHistoriesResponseBodyInspectionTasksInspectionAlarmRules] = None,
        task_id: str = None,
    ):
        # 巡检结束时间
        self.execution_end_time = execution_end_time
        # 巡检开始时间
        self.execution_begin_time = execution_begin_time
        # 巡检结果
        self.inspection_result = inspection_result
        # 告警规则
        self.inspection_alarm_rules = inspection_alarm_rules
        # 任务ID
        self.task_id = task_id

    def validate(self):
        if self.inspection_alarm_rules:
            for k in self.inspection_alarm_rules:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.execution_end_time is not None:
            result['ExecutionEndTime'] = self.execution_end_time
        if self.execution_begin_time is not None:
            result['ExecutionBeginTime'] = self.execution_begin_time
        if self.inspection_result is not None:
            result['InspectionResult'] = self.inspection_result
        result['InspectionAlarmRules'] = []
        if self.inspection_alarm_rules is not None:
            for k in self.inspection_alarm_rules:
                result['InspectionAlarmRules'].append(k.to_map() if k else None)
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExecutionEndTime') is not None:
            self.execution_end_time = m.get('ExecutionEndTime')
        if m.get('ExecutionBeginTime') is not None:
            self.execution_begin_time = m.get('ExecutionBeginTime')
        if m.get('InspectionResult') is not None:
            self.inspection_result = m.get('InspectionResult')
        self.inspection_alarm_rules = []
        if m.get('InspectionAlarmRules') is not None:
            for k in m.get('InspectionAlarmRules'):
                temp_model = ListTasksHistoriesResponseBodyInspectionTasksInspectionAlarmRules()
                self.inspection_alarm_rules.append(temp_model.from_map(k))
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class ListTasksHistoriesResponseBody(TeaModel):
    def __init__(
        self,
        total_count: int = None,
        request_id: str = None,
        next_token: int = None,
        inspection_tasks: List[ListTasksHistoriesResponseBodyInspectionTasks] = None,
    ):
        # 总记录数。
        self.total_count = total_count
        # 请求ID
        self.request_id = request_id
        # 当总结果个数大于MaxResults时，用于翻页的token。
        self.next_token = next_token
        # 数组，返回示例目录。
        self.inspection_tasks = inspection_tasks

    def validate(self):
        if self.inspection_tasks:
            for k in self.inspection_tasks:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        result['InspectionTasks'] = []
        if self.inspection_tasks is not None:
            for k in self.inspection_tasks:
                result['InspectionTasks'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        self.inspection_tasks = []
        if m.get('InspectionTasks') is not None:
            for k in m.get('InspectionTasks'):
                temp_model = ListTasksHistoriesResponseBodyInspectionTasks()
                self.inspection_tasks.append(temp_model.from_map(k))
        return self


class ListTasksHistoriesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListTasksHistoriesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListTasksHistoriesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class UpdateConfigurationSpecificationRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        specification_name: str = None,
        configuration_specification_id: str = None,
        architecture: str = None,
        role: str = None,
        vendor: str = None,
        model: str = None,
        specification_content: str = None,
        related_variate: List[bytes] = None,
    ):
        # instanceId
        self.instance_id = instance_id
        # 配置规范名字
        self.specification_name = specification_name
        # 配置规范id
        self.configuration_specification_id = configuration_specification_id
        # 架构类型
        self.architecture = architecture
        # 角色
        self.role = role
        # 厂商
        self.vendor = vendor
        # 型号
        self.model = model
        # 配置规范内容
        self.specification_content = specification_content
        # 相关变量
        self.related_variate = related_variate

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.specification_name is not None:
            result['SpecificationName'] = self.specification_name
        if self.configuration_specification_id is not None:
            result['ConfigurationSpecificationId'] = self.configuration_specification_id
        if self.architecture is not None:
            result['Architecture'] = self.architecture
        if self.role is not None:
            result['Role'] = self.role
        if self.vendor is not None:
            result['Vendor'] = self.vendor
        if self.model is not None:
            result['Model'] = self.model
        if self.specification_content is not None:
            result['SpecificationContent'] = self.specification_content
        if self.related_variate is not None:
            result['RelatedVariate'] = self.related_variate
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('SpecificationName') is not None:
            self.specification_name = m.get('SpecificationName')
        if m.get('ConfigurationSpecificationId') is not None:
            self.configuration_specification_id = m.get('ConfigurationSpecificationId')
        if m.get('Architecture') is not None:
            self.architecture = m.get('Architecture')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        if m.get('Vendor') is not None:
            self.vendor = m.get('Vendor')
        if m.get('Model') is not None:
            self.model = m.get('Model')
        if m.get('SpecificationContent') is not None:
            self.specification_content = m.get('SpecificationContent')
        if m.get('RelatedVariate') is not None:
            self.related_variate = m.get('RelatedVariate')
        return self


class UpdateConfigurationSpecificationShrinkRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        specification_name: str = None,
        configuration_specification_id: str = None,
        architecture: str = None,
        role: str = None,
        vendor: str = None,
        model: str = None,
        specification_content: str = None,
        related_variate_shrink: str = None,
    ):
        # instanceId
        self.instance_id = instance_id
        # 配置规范名字
        self.specification_name = specification_name
        # 配置规范id
        self.configuration_specification_id = configuration_specification_id
        # 架构类型
        self.architecture = architecture
        # 角色
        self.role = role
        # 厂商
        self.vendor = vendor
        # 型号
        self.model = model
        # 配置规范内容
        self.specification_content = specification_content
        # 相关变量
        self.related_variate_shrink = related_variate_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.specification_name is not None:
            result['SpecificationName'] = self.specification_name
        if self.configuration_specification_id is not None:
            result['ConfigurationSpecificationId'] = self.configuration_specification_id
        if self.architecture is not None:
            result['Architecture'] = self.architecture
        if self.role is not None:
            result['Role'] = self.role
        if self.vendor is not None:
            result['Vendor'] = self.vendor
        if self.model is not None:
            result['Model'] = self.model
        if self.specification_content is not None:
            result['SpecificationContent'] = self.specification_content
        if self.related_variate_shrink is not None:
            result['RelatedVariate'] = self.related_variate_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('SpecificationName') is not None:
            self.specification_name = m.get('SpecificationName')
        if m.get('ConfigurationSpecificationId') is not None:
            self.configuration_specification_id = m.get('ConfigurationSpecificationId')
        if m.get('Architecture') is not None:
            self.architecture = m.get('Architecture')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        if m.get('Vendor') is not None:
            self.vendor = m.get('Vendor')
        if m.get('Model') is not None:
            self.model = m.get('Model')
        if m.get('SpecificationContent') is not None:
            self.specification_content = m.get('SpecificationContent')
        if m.get('RelatedVariate') is not None:
            self.related_variate_shrink = m.get('RelatedVariate')
        return self


class UpdateConfigurationSpecificationResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # Id of the request
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class UpdateConfigurationSpecificationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: UpdateConfigurationSpecificationResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = UpdateConfigurationSpecificationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateOsVersionRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        create_time: str = None,
        vendor: str = None,
        model: str = None,
        os_version: str = None,
        status: str = None,
        file_name: str = None,
        file_path: str = None,
        client_token: str = None,
    ):
        # instanceId
        self.instance_id = instance_id
        # 创建时间
        self.create_time = create_time
        # 厂商
        self.vendor = vendor
        # 型号
        self.model = model
        # 系统版本
        self.os_version = os_version
        # 状态
        self.status = status
        # 文件名
        self.file_name = file_name
        # 文件路径
        self.file_path = file_path
        # 幂等参数
        self.client_token = client_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.vendor is not None:
            result['Vendor'] = self.vendor
        if self.model is not None:
            result['Model'] = self.model
        if self.os_version is not None:
            result['OsVersion'] = self.os_version
        if self.status is not None:
            result['Status'] = self.status
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.file_path is not None:
            result['FilePath'] = self.file_path
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Vendor') is not None:
            self.vendor = m.get('Vendor')
        if m.get('Model') is not None:
            self.model = m.get('Model')
        if m.get('OsVersion') is not None:
            self.os_version = m.get('OsVersion')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('FilePath') is not None:
            self.file_path = m.get('FilePath')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        return self


class CreateOsVersionResponseBody(TeaModel):
    def __init__(
        self,
        os_version_id: str = None,
        request_id: str = None,
    ):
        # 资源实例ID，如ECS实例的创建接口CreateInstance应返回InstanceId。
        self.os_version_id = os_version_id
        # Id of the request
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.os_version_id is not None:
            result['OsVersionId'] = self.os_version_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OsVersionId') is not None:
            self.os_version_id = m.get('OsVersionId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateOsVersionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateOsVersionResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateOsVersionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateIpBlockRecordRequestZoneLayer(TeaModel):
    def __init__(
        self,
        name: str = None,
        value: str = None,
    ):
        # 园区层级名称
        self.name = name
        # 园区层级值
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateIpBlockRecordRequestBusinessType(TeaModel):
    def __init__(
        self,
        name: str = None,
        number: int = None,
    ):
        # 地址业务类型名称
        self.name = name
        # 地址业务类型数量
        self.number = number

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.number is not None:
            result['Number'] = self.number
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Number') is not None:
            self.number = m.get('Number')
        return self


class CreateIpBlockRecordRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        client_token: str = None,
        title: str = None,
        creator: str = None,
        work_no: str = None,
        net_type: str = None,
        zone_layer: List[CreateIpBlockRecordRequestZoneLayer] = None,
        business_type: List[CreateIpBlockRecordRequestBusinessType] = None,
        net_business: str = None,
        parent_ip_block: str = None,
        mask: int = None,
        record_type: str = None,
        ip_block_code: List[str] = None,
    ):
        self.instance_id = instance_id
        # 幂等参数
        self.client_token = client_token
        # 工单名称
        self.title = title
        # 创建人
        self.creator = creator
        # 工号
        self.work_no = work_no
        # 公网私网标志 PUBLIC PRIVATE
        self.net_type = net_type
        # 园区层级
        self.zone_layer = zone_layer
        # 地址业务类型
        self.business_type = business_type
        # 公网地址类型 INC GUEST VIP
        self.net_business = net_business
        # 父段地址
        self.parent_ip_block = parent_ip_block
        # 申请公网地址的掩码大小
        self.mask = mask
        # 工单类型 Apply 申请工单 Recycle 释放工单
        self.record_type = record_type
        # 要释放的IP段
        self.ip_block_code = ip_block_code

    def validate(self):
        if self.zone_layer:
            for k in self.zone_layer:
                if k:
                    k.validate()
        if self.business_type:
            for k in self.business_type:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.title is not None:
            result['Title'] = self.title
        if self.creator is not None:
            result['Creator'] = self.creator
        if self.work_no is not None:
            result['WorkNo'] = self.work_no
        if self.net_type is not None:
            result['NetType'] = self.net_type
        result['ZoneLayer'] = []
        if self.zone_layer is not None:
            for k in self.zone_layer:
                result['ZoneLayer'].append(k.to_map() if k else None)
        result['BusinessType'] = []
        if self.business_type is not None:
            for k in self.business_type:
                result['BusinessType'].append(k.to_map() if k else None)
        if self.net_business is not None:
            result['NetBusiness'] = self.net_business
        if self.parent_ip_block is not None:
            result['ParentIpBlock'] = self.parent_ip_block
        if self.mask is not None:
            result['Mask'] = self.mask
        if self.record_type is not None:
            result['RecordType'] = self.record_type
        if self.ip_block_code is not None:
            result['IpBlockCode'] = self.ip_block_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        if m.get('Creator') is not None:
            self.creator = m.get('Creator')
        if m.get('WorkNo') is not None:
            self.work_no = m.get('WorkNo')
        if m.get('NetType') is not None:
            self.net_type = m.get('NetType')
        self.zone_layer = []
        if m.get('ZoneLayer') is not None:
            for k in m.get('ZoneLayer'):
                temp_model = CreateIpBlockRecordRequestZoneLayer()
                self.zone_layer.append(temp_model.from_map(k))
        self.business_type = []
        if m.get('BusinessType') is not None:
            for k in m.get('BusinessType'):
                temp_model = CreateIpBlockRecordRequestBusinessType()
                self.business_type.append(temp_model.from_map(k))
        if m.get('NetBusiness') is not None:
            self.net_business = m.get('NetBusiness')
        if m.get('ParentIpBlock') is not None:
            self.parent_ip_block = m.get('ParentIpBlock')
        if m.get('Mask') is not None:
            self.mask = m.get('Mask')
        if m.get('RecordType') is not None:
            self.record_type = m.get('RecordType')
        if m.get('IpBlockCode') is not None:
            self.ip_block_code = m.get('IpBlockCode')
        return self


class CreateIpBlockRecordShrinkRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        client_token: str = None,
        title: str = None,
        creator: str = None,
        work_no: str = None,
        net_type: str = None,
        zone_layer_shrink: str = None,
        business_type_shrink: str = None,
        net_business: str = None,
        parent_ip_block: str = None,
        mask: int = None,
        record_type: str = None,
        ip_block_code_shrink: str = None,
    ):
        self.instance_id = instance_id
        # 幂等参数
        self.client_token = client_token
        # 工单名称
        self.title = title
        # 创建人
        self.creator = creator
        # 工号
        self.work_no = work_no
        # 公网私网标志 PUBLIC PRIVATE
        self.net_type = net_type
        # 园区层级
        self.zone_layer_shrink = zone_layer_shrink
        # 地址业务类型
        self.business_type_shrink = business_type_shrink
        # 公网地址类型 INC GUEST VIP
        self.net_business = net_business
        # 父段地址
        self.parent_ip_block = parent_ip_block
        # 申请公网地址的掩码大小
        self.mask = mask
        # 工单类型 Apply 申请工单 Recycle 释放工单
        self.record_type = record_type
        # 要释放的IP段
        self.ip_block_code_shrink = ip_block_code_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.title is not None:
            result['Title'] = self.title
        if self.creator is not None:
            result['Creator'] = self.creator
        if self.work_no is not None:
            result['WorkNo'] = self.work_no
        if self.net_type is not None:
            result['NetType'] = self.net_type
        if self.zone_layer_shrink is not None:
            result['ZoneLayer'] = self.zone_layer_shrink
        if self.business_type_shrink is not None:
            result['BusinessType'] = self.business_type_shrink
        if self.net_business is not None:
            result['NetBusiness'] = self.net_business
        if self.parent_ip_block is not None:
            result['ParentIpBlock'] = self.parent_ip_block
        if self.mask is not None:
            result['Mask'] = self.mask
        if self.record_type is not None:
            result['RecordType'] = self.record_type
        if self.ip_block_code_shrink is not None:
            result['IpBlockCode'] = self.ip_block_code_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        if m.get('Creator') is not None:
            self.creator = m.get('Creator')
        if m.get('WorkNo') is not None:
            self.work_no = m.get('WorkNo')
        if m.get('NetType') is not None:
            self.net_type = m.get('NetType')
        if m.get('ZoneLayer') is not None:
            self.zone_layer_shrink = m.get('ZoneLayer')
        if m.get('BusinessType') is not None:
            self.business_type_shrink = m.get('BusinessType')
        if m.get('NetBusiness') is not None:
            self.net_business = m.get('NetBusiness')
        if m.get('ParentIpBlock') is not None:
            self.parent_ip_block = m.get('ParentIpBlock')
        if m.get('Mask') is not None:
            self.mask = m.get('Mask')
        if m.get('RecordType') is not None:
            self.record_type = m.get('RecordType')
        if m.get('IpBlockCode') is not None:
            self.ip_block_code_shrink = m.get('IpBlockCode')
        return self


class CreateIpBlockRecordResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        ip_block_record_id: str = None,
    ):
        # Id of the request
        self.request_id = request_id
        # 资源实例ID，如ECS实例的创建接口CreateInstance应返回InstanceId。
        self.ip_block_record_id = ip_block_record_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.ip_block_record_id is not None:
            result['IpBlockRecordId'] = self.ip_block_record_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('IpBlockRecordId') is not None:
            self.ip_block_record_id = m.get('IpBlockRecordId')
        return self


class CreateIpBlockRecordResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateIpBlockRecordResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateIpBlockRecordResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class UpdateIpBlockRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        client_token: str = None,
        ip_block_id: str = None,
        business_type_id: str = None,
        device_name: str = None,
        zone_name: str = None,
        backup_device_name: str = None,
        net_business: str = None,
        ownership: str = None,
        application: str = None,
        description: str = None,
        update_type: str = None,
        status: str = None,
    ):
        self.instance_id = instance_id
        # 用于保证请求的幂等性。由客户端生成该参数值，要保证在不同请求间唯一。只支持 ASCII 字符，且不能超过 64 个字符
        self.client_token = client_token
        # 资源一级ID
        self.ip_block_id = ip_block_id
        # 业务类型UID
        self.business_type_id = business_type_id
        # 设备名称
        self.device_name = device_name
        # 园区名称
        self.zone_name = zone_name
        # 备份设备名称
        self.backup_device_name = backup_device_name
        # 公网地址类型 INC GUEST VIP
        self.net_business = net_business
        # IP归属
        self.ownership = ownership
        # IP用途
        self.application = application
        # 备注
        self.description = description
        # 更新类型 update 更新 split 拆分
        self.update_type = update_type
        # 状态： using available lock
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.ip_block_id is not None:
            result['IpBlockId'] = self.ip_block_id
        if self.business_type_id is not None:
            result['BusinessTypeId'] = self.business_type_id
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.zone_name is not None:
            result['ZoneName'] = self.zone_name
        if self.backup_device_name is not None:
            result['BackupDeviceName'] = self.backup_device_name
        if self.net_business is not None:
            result['NetBusiness'] = self.net_business
        if self.ownership is not None:
            result['Ownership'] = self.ownership
        if self.application is not None:
            result['Application'] = self.application
        if self.description is not None:
            result['Description'] = self.description
        if self.update_type is not None:
            result['UpdateType'] = self.update_type
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('IpBlockId') is not None:
            self.ip_block_id = m.get('IpBlockId')
        if m.get('BusinessTypeId') is not None:
            self.business_type_id = m.get('BusinessTypeId')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('ZoneName') is not None:
            self.zone_name = m.get('ZoneName')
        if m.get('BackupDeviceName') is not None:
            self.backup_device_name = m.get('BackupDeviceName')
        if m.get('NetBusiness') is not None:
            self.net_business = m.get('NetBusiness')
        if m.get('Ownership') is not None:
            self.ownership = m.get('Ownership')
        if m.get('Application') is not None:
            self.application = m.get('Application')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('UpdateType') is not None:
            self.update_type = m.get('UpdateType')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class UpdateIpBlockResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # Id of the request
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class UpdateIpBlockResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: UpdateIpBlockResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = UpdateIpBlockResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDevicePropertyRequest(TeaModel):
    def __init__(
        self,
        device_form_id: str = None,
        property_name: str = None,
        property_key: str = None,
        property_format: str = None,
        property_content: str = None,
        client_token: str = None,
        instance_id: str = None,
    ):
        # 设备形态ID
        self.device_form_id = device_form_id
        # 属性名称
        self.property_name = property_name
        # 属性主键
        self.property_key = property_key
        # 属性格式
        self.property_format = property_format
        # 属性内容
        self.property_content = property_content
        # 幂等校验 token
        self.client_token = client_token
        # 实例ID
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_form_id is not None:
            result['DeviceFormId'] = self.device_form_id
        if self.property_name is not None:
            result['PropertyName'] = self.property_name
        if self.property_key is not None:
            result['PropertyKey'] = self.property_key
        if self.property_format is not None:
            result['PropertyFormat'] = self.property_format
        if self.property_content is not None:
            result['PropertyContent'] = self.property_content
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeviceFormId') is not None:
            self.device_form_id = m.get('DeviceFormId')
        if m.get('PropertyName') is not None:
            self.property_name = m.get('PropertyName')
        if m.get('PropertyKey') is not None:
            self.property_key = m.get('PropertyKey')
        if m.get('PropertyFormat') is not None:
            self.property_format = m.get('PropertyFormat')
        if m.get('PropertyContent') is not None:
            self.property_content = m.get('PropertyContent')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class CreateDevicePropertyResponseBody(TeaModel):
    def __init__(
        self,
        device_property_id: str = None,
        request_id: str = None,
    ):
        # 资源实例ID，如ECS实例的创建接口CreateInstance应返回InstanceId。
        self.device_property_id = device_property_id
        # Id of the request
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_property_id is not None:
            result['DevicePropertyId'] = self.device_property_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DevicePropertyId') is not None:
            self.device_property_id = m.get('DevicePropertyId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateDevicePropertyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateDevicePropertyResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateDevicePropertyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class UpdateIpBlockRecordRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        client_token: str = None,
        ip_block_record_id: str = None,
        status: str = None,
    ):
        self.instance_id = instance_id
        # 用于保证请求的幂等性。由客户端生成该参数值，要保证在不同请求间唯一。只支持 ASCII 字符，且不能超过 64 个字符
        self.client_token = client_token
        # 资源一级ID
        self.ip_block_record_id = ip_block_record_id
        # 工单状态
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.ip_block_record_id is not None:
            result['IpBlockRecordId'] = self.ip_block_record_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('IpBlockRecordId') is not None:
            self.ip_block_record_id = m.get('IpBlockRecordId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class UpdateIpBlockRecordResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # Id of the request
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class UpdateIpBlockRecordResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: UpdateIpBlockRecordResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = UpdateIpBlockRecordResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class RetryTasksRequestRetryTasks(TeaModel):
    def __init__(
        self,
        device_id: str = None,
        script_id: str = None,
    ):
        # 设备ID
        self.device_id = device_id
        # 脚本ID
        self.script_id = script_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.script_id is not None:
            result['ScriptId'] = self.script_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('ScriptId') is not None:
            self.script_id = m.get('ScriptId')
        return self


class RetryTasksRequest(TeaModel):
    def __init__(
        self,
        retry_tasks: List[RetryTasksRequestRetryTasks] = None,
        instance_id: str = None,
    ):
        # 重执行任务的数组
        self.retry_tasks = retry_tasks
        # 实例ID
        self.instance_id = instance_id

    def validate(self):
        if self.retry_tasks:
            for k in self.retry_tasks:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['RetryTasks'] = []
        if self.retry_tasks is not None:
            for k in self.retry_tasks:
                result['RetryTasks'].append(k.to_map() if k else None)
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.retry_tasks = []
        if m.get('RetryTasks') is not None:
            for k in m.get('RetryTasks'):
                temp_model = RetryTasksRequestRetryTasks()
                self.retry_tasks.append(temp_model.from_map(k))
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class RetryTasksShrinkRequest(TeaModel):
    def __init__(
        self,
        retry_tasks_shrink: str = None,
        instance_id: str = None,
    ):
        # 重执行任务的数组
        self.retry_tasks_shrink = retry_tasks_shrink
        # 实例ID
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.retry_tasks_shrink is not None:
            result['RetryTasks'] = self.retry_tasks_shrink
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RetryTasks') is not None:
            self.retry_tasks_shrink = m.get('RetryTasks')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class RetryTasksResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # 请求ID
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class RetryTasksResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: RetryTasksResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = RetryTasksResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetPhysicalSpaceTopoRequest(TeaModel):
    def __init__(
        self,
        physical_space_id: str = None,
        topo_type: str = None,
        instance_id: str = None,
    ):
        # 物理空间id
        self.physical_space_id = physical_space_id
        # 拓扑类型
        self.topo_type = topo_type
        # 实例ID
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.physical_space_id is not None:
            result['PhysicalSpaceId'] = self.physical_space_id
        if self.topo_type is not None:
            result['TopoType'] = self.topo_type
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PhysicalSpaceId') is not None:
            self.physical_space_id = m.get('PhysicalSpaceId')
        if m.get('TopoType') is not None:
            self.topo_type = m.get('TopoType')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetPhysicalSpaceTopoResponseBodyTopoDataLinks(TeaModel):
    def __init__(
        self,
        source_device_id: str = None,
        source_port: str = None,
        target_device_id: str = None,
        target_port: str = None,
        source_device_name: str = None,
        target_device_name: str = None,
    ):
        # 源设备id
        self.source_device_id = source_device_id
        # 源设备端口
        self.source_port = source_port
        # 目标设备id
        self.target_device_id = target_device_id
        # 目标设备端口
        self.target_port = target_port
        # 源设备名
        self.source_device_name = source_device_name
        # 目标设备名
        self.target_device_name = target_device_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_device_id is not None:
            result['SourceDeviceId'] = self.source_device_id
        if self.source_port is not None:
            result['SourcePort'] = self.source_port
        if self.target_device_id is not None:
            result['TargetDeviceId'] = self.target_device_id
        if self.target_port is not None:
            result['TargetPort'] = self.target_port
        if self.source_device_name is not None:
            result['SourceDeviceName'] = self.source_device_name
        if self.target_device_name is not None:
            result['TargetDeviceName'] = self.target_device_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SourceDeviceId') is not None:
            self.source_device_id = m.get('SourceDeviceId')
        if m.get('SourcePort') is not None:
            self.source_port = m.get('SourcePort')
        if m.get('TargetDeviceId') is not None:
            self.target_device_id = m.get('TargetDeviceId')
        if m.get('TargetPort') is not None:
            self.target_port = m.get('TargetPort')
        if m.get('SourceDeviceName') is not None:
            self.source_device_name = m.get('SourceDeviceName')
        if m.get('TargetDeviceName') is not None:
            self.target_device_name = m.get('TargetDeviceName')
        return self


class GetPhysicalSpaceTopoResponseBodyTopoDataDevices(TeaModel):
    def __init__(
        self,
        device_id: str = None,
        device_role: str = None,
        host_name: str = None,
        ip: str = None,
    ):
        # 设备id
        self.device_id = device_id
        # 设备角色
        self.device_role = device_role
        # 设备主机名
        self.host_name = host_name
        # 设备ip
        self.ip = ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.device_role is not None:
            result['DeviceRole'] = self.device_role
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.ip is not None:
            result['Ip'] = self.ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('DeviceRole') is not None:
            self.device_role = m.get('DeviceRole')
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('Ip') is not None:
            self.ip = m.get('Ip')
        return self


class GetPhysicalSpaceTopoResponseBodyTopoData(TeaModel):
    def __init__(
        self,
        update_time: str = None,
        links: List[GetPhysicalSpaceTopoResponseBodyTopoDataLinks] = None,
        devices: List[GetPhysicalSpaceTopoResponseBodyTopoDataDevices] = None,
    ):
        # 更新时间
        self.update_time = update_time
        self.links = links
        self.devices = devices

    def validate(self):
        if self.links:
            for k in self.links:
                if k:
                    k.validate()
        if self.devices:
            for k in self.devices:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        result['Links'] = []
        if self.links is not None:
            for k in self.links:
                result['Links'].append(k.to_map() if k else None)
        result['Devices'] = []
        if self.devices is not None:
            for k in self.devices:
                result['Devices'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        self.links = []
        if m.get('Links') is not None:
            for k in m.get('Links'):
                temp_model = GetPhysicalSpaceTopoResponseBodyTopoDataLinks()
                self.links.append(temp_model.from_map(k))
        self.devices = []
        if m.get('Devices') is not None:
            for k in m.get('Devices'):
                temp_model = GetPhysicalSpaceTopoResponseBodyTopoDataDevices()
                self.devices.append(temp_model.from_map(k))
        return self


class GetPhysicalSpaceTopoResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        topo_data: GetPhysicalSpaceTopoResponseBodyTopoData = None,
    ):
        # Id of the request
        self.request_id = request_id
        # 拓扑数据
        self.topo_data = topo_data

    def validate(self):
        if self.topo_data:
            self.topo_data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.topo_data is not None:
            result['TopoData'] = self.topo_data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TopoData') is not None:
            temp_model = GetPhysicalSpaceTopoResponseBodyTopoData()
            self.topo_data = temp_model.from_map(m['TopoData'])
        return self


class GetPhysicalSpaceTopoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetPhysicalSpaceTopoResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetPhysicalSpaceTopoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetOssPolicyRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
    ):
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetOssPolicyResponseBodyOssPolicy(TeaModel):
    def __init__(
        self,
        access_id: str = None,
        policy: str = None,
        signature: str = None,
        directory: str = None,
        host: str = None,
        expire_time: str = None,
    ):
        # 通行id
        self.access_id = access_id
        # 通行规则
        self.policy = policy
        # 签名
        self.signature = signature
        # 目录
        self.directory = directory
        # 主机名
        self.host = host
        # 过期时间
        self.expire_time = expire_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_id is not None:
            result['AccessId'] = self.access_id
        if self.policy is not None:
            result['Policy'] = self.policy
        if self.signature is not None:
            result['Signature'] = self.signature
        if self.directory is not None:
            result['Directory'] = self.directory
        if self.host is not None:
            result['Host'] = self.host
        if self.expire_time is not None:
            result['ExpireTime'] = self.expire_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccessId') is not None:
            self.access_id = m.get('AccessId')
        if m.get('Policy') is not None:
            self.policy = m.get('Policy')
        if m.get('Signature') is not None:
            self.signature = m.get('Signature')
        if m.get('Directory') is not None:
            self.directory = m.get('Directory')
        if m.get('Host') is not None:
            self.host = m.get('Host')
        if m.get('ExpireTime') is not None:
            self.expire_time = m.get('ExpireTime')
        return self


class GetOssPolicyResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        oss_policy: GetOssPolicyResponseBodyOssPolicy = None,
    ):
        # Id of the request
        self.request_id = request_id
        # 资源上传规则
        self.oss_policy = oss_policy

    def validate(self):
        if self.oss_policy:
            self.oss_policy.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.oss_policy is not None:
            result['OssPolicy'] = self.oss_policy.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('OssPolicy') is not None:
            temp_model = GetOssPolicyResponseBodyOssPolicy()
            self.oss_policy = temp_model.from_map(m['OssPolicy'])
        return self


class GetOssPolicyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetOssPolicyResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetOssPolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDeviceFormRequest(TeaModel):
    def __init__(
        self,
        device_form_id: str = None,
        instance_id: str = None,
    ):
        # 实例 ID。
        self.device_form_id = device_form_id
        # 实例ID
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_form_id is not None:
            result['DeviceFormId'] = self.device_form_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeviceFormId') is not None:
            self.device_form_id = m.get('DeviceFormId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class DeleteDeviceFormResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # Id of the request
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteDeviceFormResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteDeviceFormResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteDeviceFormResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class UpdateDeviceFormRequestAttributeList(TeaModel):
    def __init__(
        self,
        attribute_key: str = None,
        attribute_name: str = None,
        attribute_requirement: bool = None,
        attribute_uniqueness: bool = None,
        attribute_format: str = None,
        attribute_type: str = None,
        attribute_reference: str = None,
        attribute_table_display: bool = None,
        attribute_placeholder: str = None,
        attribute_query: bool = None,
        attribute_fuzzy_query: bool = None,
    ):
        # 设备形态属性主键
        self.attribute_key = attribute_key
        # 设备形态属性名称
        self.attribute_name = attribute_name
        # 设备形态属性是否必填
        self.attribute_requirement = attribute_requirement
        # 设备形态属性是否唯一
        self.attribute_uniqueness = attribute_uniqueness
        # 设备形态属性值格式
        self.attribute_format = attribute_format
        # 设备形态属性值类型
        self.attribute_type = attribute_type
        # 设备形态属性关联对象
        self.attribute_reference = attribute_reference
        # 设备形态属性是否表格可见
        self.attribute_table_display = attribute_table_display
        # 前端查询控件占位符
        self.attribute_placeholder = attribute_placeholder
        # 前端展示搜索控件
        self.attribute_query = attribute_query
        # 查询支持模糊搜索
        self.attribute_fuzzy_query = attribute_fuzzy_query

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.attribute_key is not None:
            result['AttributeKey'] = self.attribute_key
        if self.attribute_name is not None:
            result['AttributeName'] = self.attribute_name
        if self.attribute_requirement is not None:
            result['AttributeRequirement'] = self.attribute_requirement
        if self.attribute_uniqueness is not None:
            result['AttributeUniqueness'] = self.attribute_uniqueness
        if self.attribute_format is not None:
            result['AttributeFormat'] = self.attribute_format
        if self.attribute_type is not None:
            result['AttributeType'] = self.attribute_type
        if self.attribute_reference is not None:
            result['AttributeReference'] = self.attribute_reference
        if self.attribute_table_display is not None:
            result['AttributeTableDisplay'] = self.attribute_table_display
        if self.attribute_placeholder is not None:
            result['AttributePlaceholder'] = self.attribute_placeholder
        if self.attribute_query is not None:
            result['AttributeQuery'] = self.attribute_query
        if self.attribute_fuzzy_query is not None:
            result['AttributeFuzzyQuery'] = self.attribute_fuzzy_query
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AttributeKey') is not None:
            self.attribute_key = m.get('AttributeKey')
        if m.get('AttributeName') is not None:
            self.attribute_name = m.get('AttributeName')
        if m.get('AttributeRequirement') is not None:
            self.attribute_requirement = m.get('AttributeRequirement')
        if m.get('AttributeUniqueness') is not None:
            self.attribute_uniqueness = m.get('AttributeUniqueness')
        if m.get('AttributeFormat') is not None:
            self.attribute_format = m.get('AttributeFormat')
        if m.get('AttributeType') is not None:
            self.attribute_type = m.get('AttributeType')
        if m.get('AttributeReference') is not None:
            self.attribute_reference = m.get('AttributeReference')
        if m.get('AttributeTableDisplay') is not None:
            self.attribute_table_display = m.get('AttributeTableDisplay')
        if m.get('AttributePlaceholder') is not None:
            self.attribute_placeholder = m.get('AttributePlaceholder')
        if m.get('AttributeQuery') is not None:
            self.attribute_query = m.get('AttributeQuery')
        if m.get('AttributeFuzzyQuery') is not None:
            self.attribute_fuzzy_query = m.get('AttributeFuzzyQuery')
        return self


class UpdateDeviceFormRequest(TeaModel):
    def __init__(
        self,
        device_form_id: str = None,
        config_compare: bool = None,
        account_config: bool = None,
        attribute_list: List[UpdateDeviceFormRequestAttributeList] = None,
        detail_display: bool = None,
        instance_id: str = None,
    ):
        # 设备形态ID
        self.device_form_id = device_form_id
        # 是否支持配置生成
        self.config_compare = config_compare
        # 是否需要账号配置
        self.account_config = account_config
        # 设备形态属性列表
        self.attribute_list = attribute_list
        # 是否展示设备详情
        self.detail_display = detail_display
        # 实例ID
        self.instance_id = instance_id

    def validate(self):
        if self.attribute_list:
            for k in self.attribute_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_form_id is not None:
            result['DeviceFormId'] = self.device_form_id
        if self.config_compare is not None:
            result['ConfigCompare'] = self.config_compare
        if self.account_config is not None:
            result['AccountConfig'] = self.account_config
        result['AttributeList'] = []
        if self.attribute_list is not None:
            for k in self.attribute_list:
                result['AttributeList'].append(k.to_map() if k else None)
        if self.detail_display is not None:
            result['DetailDisplay'] = self.detail_display
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeviceFormId') is not None:
            self.device_form_id = m.get('DeviceFormId')
        if m.get('ConfigCompare') is not None:
            self.config_compare = m.get('ConfigCompare')
        if m.get('AccountConfig') is not None:
            self.account_config = m.get('AccountConfig')
        self.attribute_list = []
        if m.get('AttributeList') is not None:
            for k in m.get('AttributeList'):
                temp_model = UpdateDeviceFormRequestAttributeList()
                self.attribute_list.append(temp_model.from_map(k))
        if m.get('DetailDisplay') is not None:
            self.detail_display = m.get('DetailDisplay')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class UpdateDeviceFormShrinkRequest(TeaModel):
    def __init__(
        self,
        device_form_id: str = None,
        config_compare: bool = None,
        account_config: bool = None,
        attribute_list_shrink: str = None,
        detail_display: bool = None,
        instance_id: str = None,
    ):
        # 设备形态ID
        self.device_form_id = device_form_id
        # 是否支持配置生成
        self.config_compare = config_compare
        # 是否需要账号配置
        self.account_config = account_config
        # 设备形态属性列表
        self.attribute_list_shrink = attribute_list_shrink
        # 是否展示设备详情
        self.detail_display = detail_display
        # 实例ID
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_form_id is not None:
            result['DeviceFormId'] = self.device_form_id
        if self.config_compare is not None:
            result['ConfigCompare'] = self.config_compare
        if self.account_config is not None:
            result['AccountConfig'] = self.account_config
        if self.attribute_list_shrink is not None:
            result['AttributeList'] = self.attribute_list_shrink
        if self.detail_display is not None:
            result['DetailDisplay'] = self.detail_display
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeviceFormId') is not None:
            self.device_form_id = m.get('DeviceFormId')
        if m.get('ConfigCompare') is not None:
            self.config_compare = m.get('ConfigCompare')
        if m.get('AccountConfig') is not None:
            self.account_config = m.get('AccountConfig')
        if m.get('AttributeList') is not None:
            self.attribute_list_shrink = m.get('AttributeList')
        if m.get('DetailDisplay') is not None:
            self.detail_display = m.get('DetailDisplay')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class UpdateDeviceFormResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # Id of the request
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class UpdateDeviceFormResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: UpdateDeviceFormResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = UpdateDeviceFormResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class UpdateDeviceRequest(TeaModel):
    def __init__(
        self,
        device_id: str = None,
        physical_space_id: str = None,
        host_name: str = None,
        ip: str = None,
        sn: str = None,
        mac: str = None,
        vendor: str = None,
        model: str = None,
        service_status: str = None,
        security_domain: str = None,
        login_type: str = None,
        login_username: str = None,
        login_password: str = None,
        snmp_account_version: str = None,
        snmp_community: str = None,
        snmp_account_type: str = None,
        snmp_security_level: str = None,
        snmp_username: str = None,
        snmp_auth_passphrase: str = None,
        snmp_auth_protocol: str = None,
        snmp_privacy_passphase: str = None,
        snmp_privacy_protocol: str = None,
        ext_attributes: str = None,
        instance_id: str = None,
    ):
        # 设备ID
        self.device_id = device_id
        # 物理空间
        self.physical_space_id = physical_space_id
        # 主机名
        self.host_name = host_name
        # 设备IP
        self.ip = ip
        # 设备SN
        self.sn = sn
        # 设备MAC地址
        self.mac = mac
        # 设备厂商
        self.vendor = vendor
        # 设备型号
        self.model = model
        # 设备状态
        self.service_status = service_status
        # 设备安全域
        self.security_domain = security_domain
        # 登录类型
        self.login_type = login_type
        # 登录账号
        self.login_username = login_username
        # 登录密码
        self.login_password = login_password
        # SNMP 版本号
        self.snmp_account_version = snmp_account_version
        # SNMP Community
        self.snmp_community = snmp_community
        # SNMP 账号类型
        self.snmp_account_type = snmp_account_type
        # SNMP 安全级别
        self.snmp_security_level = snmp_security_level
        # SNMP 用户名
        self.snmp_username = snmp_username
        # SNMP Auth PassPhrase
        self.snmp_auth_passphrase = snmp_auth_passphrase
        # Auth Protocol
        self.snmp_auth_protocol = snmp_auth_protocol
        # Privacy Passphase
        self.snmp_privacy_passphase = snmp_privacy_passphase
        # Privacy Protocol
        self.snmp_privacy_protocol = snmp_privacy_protocol
        # 设备额外属性
        self.ext_attributes = ext_attributes
        # 实例ID
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.physical_space_id is not None:
            result['PhysicalSpaceId'] = self.physical_space_id
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.ip is not None:
            result['Ip'] = self.ip
        if self.sn is not None:
            result['Sn'] = self.sn
        if self.mac is not None:
            result['Mac'] = self.mac
        if self.vendor is not None:
            result['Vendor'] = self.vendor
        if self.model is not None:
            result['Model'] = self.model
        if self.service_status is not None:
            result['ServiceStatus'] = self.service_status
        if self.security_domain is not None:
            result['SecurityDomain'] = self.security_domain
        if self.login_type is not None:
            result['LoginType'] = self.login_type
        if self.login_username is not None:
            result['LoginUsername'] = self.login_username
        if self.login_password is not None:
            result['LoginPassword'] = self.login_password
        if self.snmp_account_version is not None:
            result['SnmpAccountVersion'] = self.snmp_account_version
        if self.snmp_community is not None:
            result['SnmpCommunity'] = self.snmp_community
        if self.snmp_account_type is not None:
            result['SnmpAccountType'] = self.snmp_account_type
        if self.snmp_security_level is not None:
            result['SnmpSecurityLevel'] = self.snmp_security_level
        if self.snmp_username is not None:
            result['SnmpUsername'] = self.snmp_username
        if self.snmp_auth_passphrase is not None:
            result['SnmpAuthPassphrase'] = self.snmp_auth_passphrase
        if self.snmp_auth_protocol is not None:
            result['SnmpAuthProtocol'] = self.snmp_auth_protocol
        if self.snmp_privacy_passphase is not None:
            result['SnmpPrivacyPassphase'] = self.snmp_privacy_passphase
        if self.snmp_privacy_protocol is not None:
            result['SnmpPrivacyProtocol'] = self.snmp_privacy_protocol
        if self.ext_attributes is not None:
            result['ExtAttributes'] = self.ext_attributes
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('PhysicalSpaceId') is not None:
            self.physical_space_id = m.get('PhysicalSpaceId')
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('Ip') is not None:
            self.ip = m.get('Ip')
        if m.get('Sn') is not None:
            self.sn = m.get('Sn')
        if m.get('Mac') is not None:
            self.mac = m.get('Mac')
        if m.get('Vendor') is not None:
            self.vendor = m.get('Vendor')
        if m.get('Model') is not None:
            self.model = m.get('Model')
        if m.get('ServiceStatus') is not None:
            self.service_status = m.get('ServiceStatus')
        if m.get('SecurityDomain') is not None:
            self.security_domain = m.get('SecurityDomain')
        if m.get('LoginType') is not None:
            self.login_type = m.get('LoginType')
        if m.get('LoginUsername') is not None:
            self.login_username = m.get('LoginUsername')
        if m.get('LoginPassword') is not None:
            self.login_password = m.get('LoginPassword')
        if m.get('SnmpAccountVersion') is not None:
            self.snmp_account_version = m.get('SnmpAccountVersion')
        if m.get('SnmpCommunity') is not None:
            self.snmp_community = m.get('SnmpCommunity')
        if m.get('SnmpAccountType') is not None:
            self.snmp_account_type = m.get('SnmpAccountType')
        if m.get('SnmpSecurityLevel') is not None:
            self.snmp_security_level = m.get('SnmpSecurityLevel')
        if m.get('SnmpUsername') is not None:
            self.snmp_username = m.get('SnmpUsername')
        if m.get('SnmpAuthPassphrase') is not None:
            self.snmp_auth_passphrase = m.get('SnmpAuthPassphrase')
        if m.get('SnmpAuthProtocol') is not None:
            self.snmp_auth_protocol = m.get('SnmpAuthProtocol')
        if m.get('SnmpPrivacyPassphase') is not None:
            self.snmp_privacy_passphase = m.get('SnmpPrivacyPassphase')
        if m.get('SnmpPrivacyProtocol') is not None:
            self.snmp_privacy_protocol = m.get('SnmpPrivacyProtocol')
        if m.get('ExtAttributes') is not None:
            self.ext_attributes = m.get('ExtAttributes')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class UpdateDeviceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # Id of the request
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class UpdateDeviceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: UpdateDeviceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = UpdateDeviceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDeviceRequest(TeaModel):
    def __init__(
        self,
        device_id: str = None,
        instance_id: str = None,
    ):
        # 实例 ID。
        self.device_id = device_id
        # 实例ID
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetDeviceResponseBodyDevice(TeaModel):
    def __init__(
        self,
        device_id: str = None,
        device_form_id: str = None,
        device_form_name: str = None,
        physical_space_id: str = None,
        physical_space_name: str = None,
        host_name: str = None,
        ip: str = None,
        sn: str = None,
        mac: str = None,
        vendor: str = None,
        model: str = None,
        security_domain: str = None,
        service_status: str = None,
        login_type: str = None,
        login_username: str = None,
        login_password: str = None,
        snmp_account_version: str = None,
        snmp_community: str = None,
        snmp_account_type: str = None,
        snmp_security_level: str = None,
        snmp_username: str = None,
        snmp_auth_passphrase: str = None,
        snmp_auth_protocol: str = None,
        snmp_privacy_passphase: str = None,
        snmp_privacy_protocol: str = None,
        ext_attributes: str = None,
    ):
        # 设备ID
        self.device_id = device_id
        # 设备形态ID
        self.device_form_id = device_form_id
        # 设备形态名称
        self.device_form_name = device_form_name
        # 物理空间ID
        self.physical_space_id = physical_space_id
        # 物理空间名称
        self.physical_space_name = physical_space_name
        # 主机名
        self.host_name = host_name
        # 设备IP
        self.ip = ip
        # 设备SN
        self.sn = sn
        # 设备MAC地址
        self.mac = mac
        # 设备厂商
        self.vendor = vendor
        # 设备型号
        self.model = model
        # 设备安全域
        self.security_domain = security_domain
        # 设备状态
        self.service_status = service_status
        # 登录类型
        self.login_type = login_type
        # 登录账号
        self.login_username = login_username
        # 登录密码
        self.login_password = login_password
        # SNMP版本号
        self.snmp_account_version = snmp_account_version
        # SNMP Community
        self.snmp_community = snmp_community
        # SNMP 账号类型
        self.snmp_account_type = snmp_account_type
        # SNMP 安全级别
        self.snmp_security_level = snmp_security_level
        # SNMP 用户名
        self.snmp_username = snmp_username
        # SNMP Auth PassPhrase
        self.snmp_auth_passphrase = snmp_auth_passphrase
        # SNMP Auth Protocol
        self.snmp_auth_protocol = snmp_auth_protocol
        # SNMP Privacy Passphase
        self.snmp_privacy_passphase = snmp_privacy_passphase
        # SNMP Privacy Protocol
        self.snmp_privacy_protocol = snmp_privacy_protocol
        # 设备额外属性
        self.ext_attributes = ext_attributes

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.device_form_id is not None:
            result['DeviceFormId'] = self.device_form_id
        if self.device_form_name is not None:
            result['DeviceFormName'] = self.device_form_name
        if self.physical_space_id is not None:
            result['PhysicalSpaceId'] = self.physical_space_id
        if self.physical_space_name is not None:
            result['PhysicalSpaceName'] = self.physical_space_name
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.ip is not None:
            result['Ip'] = self.ip
        if self.sn is not None:
            result['Sn'] = self.sn
        if self.mac is not None:
            result['Mac'] = self.mac
        if self.vendor is not None:
            result['Vendor'] = self.vendor
        if self.model is not None:
            result['Model'] = self.model
        if self.security_domain is not None:
            result['SecurityDomain'] = self.security_domain
        if self.service_status is not None:
            result['ServiceStatus'] = self.service_status
        if self.login_type is not None:
            result['LoginType'] = self.login_type
        if self.login_username is not None:
            result['LoginUsername'] = self.login_username
        if self.login_password is not None:
            result['LoginPassword'] = self.login_password
        if self.snmp_account_version is not None:
            result['SnmpAccountVersion'] = self.snmp_account_version
        if self.snmp_community is not None:
            result['SnmpCommunity'] = self.snmp_community
        if self.snmp_account_type is not None:
            result['SnmpAccountType'] = self.snmp_account_type
        if self.snmp_security_level is not None:
            result['SnmpSecurityLevel'] = self.snmp_security_level
        if self.snmp_username is not None:
            result['SnmpUsername'] = self.snmp_username
        if self.snmp_auth_passphrase is not None:
            result['SnmpAuthPassphrase'] = self.snmp_auth_passphrase
        if self.snmp_auth_protocol is not None:
            result['SnmpAuthProtocol'] = self.snmp_auth_protocol
        if self.snmp_privacy_passphase is not None:
            result['SnmpPrivacyPassphase'] = self.snmp_privacy_passphase
        if self.snmp_privacy_protocol is not None:
            result['SnmpPrivacyProtocol'] = self.snmp_privacy_protocol
        if self.ext_attributes is not None:
            result['ExtAttributes'] = self.ext_attributes
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('DeviceFormId') is not None:
            self.device_form_id = m.get('DeviceFormId')
        if m.get('DeviceFormName') is not None:
            self.device_form_name = m.get('DeviceFormName')
        if m.get('PhysicalSpaceId') is not None:
            self.physical_space_id = m.get('PhysicalSpaceId')
        if m.get('PhysicalSpaceName') is not None:
            self.physical_space_name = m.get('PhysicalSpaceName')
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('Ip') is not None:
            self.ip = m.get('Ip')
        if m.get('Sn') is not None:
            self.sn = m.get('Sn')
        if m.get('Mac') is not None:
            self.mac = m.get('Mac')
        if m.get('Vendor') is not None:
            self.vendor = m.get('Vendor')
        if m.get('Model') is not None:
            self.model = m.get('Model')
        if m.get('SecurityDomain') is not None:
            self.security_domain = m.get('SecurityDomain')
        if m.get('ServiceStatus') is not None:
            self.service_status = m.get('ServiceStatus')
        if m.get('LoginType') is not None:
            self.login_type = m.get('LoginType')
        if m.get('LoginUsername') is not None:
            self.login_username = m.get('LoginUsername')
        if m.get('LoginPassword') is not None:
            self.login_password = m.get('LoginPassword')
        if m.get('SnmpAccountVersion') is not None:
            self.snmp_account_version = m.get('SnmpAccountVersion')
        if m.get('SnmpCommunity') is not None:
            self.snmp_community = m.get('SnmpCommunity')
        if m.get('SnmpAccountType') is not None:
            self.snmp_account_type = m.get('SnmpAccountType')
        if m.get('SnmpSecurityLevel') is not None:
            self.snmp_security_level = m.get('SnmpSecurityLevel')
        if m.get('SnmpUsername') is not None:
            self.snmp_username = m.get('SnmpUsername')
        if m.get('SnmpAuthPassphrase') is not None:
            self.snmp_auth_passphrase = m.get('SnmpAuthPassphrase')
        if m.get('SnmpAuthProtocol') is not None:
            self.snmp_auth_protocol = m.get('SnmpAuthProtocol')
        if m.get('SnmpPrivacyPassphase') is not None:
            self.snmp_privacy_passphase = m.get('SnmpPrivacyPassphase')
        if m.get('SnmpPrivacyProtocol') is not None:
            self.snmp_privacy_protocol = m.get('SnmpPrivacyProtocol')
        if m.get('ExtAttributes') is not None:
            self.ext_attributes = m.get('ExtAttributes')
        return self


class GetDeviceResponseBody(TeaModel):
    def __init__(
        self,
        device: GetDeviceResponseBodyDevice = None,
        request_id: str = None,
    ):
        # 设备详情
        self.device = device
        # Id of the request
        self.request_id = request_id

    def validate(self):
        if self.device:
            self.device.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device is not None:
            result['Device'] = self.device.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Device') is not None:
            temp_model = GetDeviceResponseBodyDevice()
            self.device = temp_model.from_map(m['Device'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetDeviceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetDeviceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetDeviceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class UpdateSetupProjectRequestPackages(TeaModel):
    def __init__(
        self,
        role: str = None,
        device_number: int = None,
        vendor: str = None,
        model: str = None,
    ):
        # 角色
        self.role = role
        # 设备号
        self.device_number = device_number
        # 厂商
        self.vendor = vendor
        # 型号
        self.model = model

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.role is not None:
            result['Role'] = self.role
        if self.device_number is not None:
            result['DeviceNumber'] = self.device_number
        if self.vendor is not None:
            result['Vendor'] = self.vendor
        if self.model is not None:
            result['Model'] = self.model
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Role') is not None:
            self.role = m.get('Role')
        if m.get('DeviceNumber') is not None:
            self.device_number = m.get('DeviceNumber')
        if m.get('Vendor') is not None:
            self.vendor = m.get('Vendor')
        if m.get('Model') is not None:
            self.model = m.get('Model')
        return self


class UpdateSetupProjectRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        setup_project_id: str = None,
        space_id: str = None,
        description: str = None,
        architecture_id: str = None,
        delivery_time: str = None,
        nodes: str = None,
        packages: List[UpdateSetupProjectRequestPackages] = None,
    ):
        # instanceId
        self.instance_id = instance_id
        # 资源一级ID
        self.setup_project_id = setup_project_id
        # 物理空间uId
        self.space_id = space_id
        # 描述
        self.description = description
        # 架构id
        self.architecture_id = architecture_id
        # 预计交付时间
        self.delivery_time = delivery_time
        # 节点
        self.nodes = nodes
        # 套餐
        self.packages = packages

    def validate(self):
        if self.packages:
            for k in self.packages:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.setup_project_id is not None:
            result['SetupProjectId'] = self.setup_project_id
        if self.space_id is not None:
            result['SpaceId'] = self.space_id
        if self.description is not None:
            result['Description'] = self.description
        if self.architecture_id is not None:
            result['ArchitectureId'] = self.architecture_id
        if self.delivery_time is not None:
            result['DeliveryTime'] = self.delivery_time
        if self.nodes is not None:
            result['Nodes'] = self.nodes
        result['Packages'] = []
        if self.packages is not None:
            for k in self.packages:
                result['Packages'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('SetupProjectId') is not None:
            self.setup_project_id = m.get('SetupProjectId')
        if m.get('SpaceId') is not None:
            self.space_id = m.get('SpaceId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ArchitectureId') is not None:
            self.architecture_id = m.get('ArchitectureId')
        if m.get('DeliveryTime') is not None:
            self.delivery_time = m.get('DeliveryTime')
        if m.get('Nodes') is not None:
            self.nodes = m.get('Nodes')
        self.packages = []
        if m.get('Packages') is not None:
            for k in m.get('Packages'):
                temp_model = UpdateSetupProjectRequestPackages()
                self.packages.append(temp_model.from_map(k))
        return self


class UpdateSetupProjectShrinkRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        setup_project_id: str = None,
        space_id: str = None,
        description: str = None,
        architecture_id: str = None,
        delivery_time: str = None,
        nodes: str = None,
        packages_shrink: str = None,
    ):
        # instanceId
        self.instance_id = instance_id
        # 资源一级ID
        self.setup_project_id = setup_project_id
        # 物理空间uId
        self.space_id = space_id
        # 描述
        self.description = description
        # 架构id
        self.architecture_id = architecture_id
        # 预计交付时间
        self.delivery_time = delivery_time
        # 节点
        self.nodes = nodes
        # 套餐
        self.packages_shrink = packages_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.setup_project_id is not None:
            result['SetupProjectId'] = self.setup_project_id
        if self.space_id is not None:
            result['SpaceId'] = self.space_id
        if self.description is not None:
            result['Description'] = self.description
        if self.architecture_id is not None:
            result['ArchitectureId'] = self.architecture_id
        if self.delivery_time is not None:
            result['DeliveryTime'] = self.delivery_time
        if self.nodes is not None:
            result['Nodes'] = self.nodes
        if self.packages_shrink is not None:
            result['Packages'] = self.packages_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('SetupProjectId') is not None:
            self.setup_project_id = m.get('SetupProjectId')
        if m.get('SpaceId') is not None:
            self.space_id = m.get('SpaceId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ArchitectureId') is not None:
            self.architecture_id = m.get('ArchitectureId')
        if m.get('DeliveryTime') is not None:
            self.delivery_time = m.get('DeliveryTime')
        if m.get('Nodes') is not None:
            self.nodes = m.get('Nodes')
        if m.get('Packages') is not None:
            self.packages_shrink = m.get('Packages')
        return self


class UpdateSetupProjectResponseBody(TeaModel):
    def __init__(
        self,
        setup_project_name: str = None,
        setup_project_id: str = None,
        request_id: str = None,
        setup_project_specification: str = None,
    ):
        # 实例的名称
        self.setup_project_name = setup_project_name
        # 资源实例ID，如ECS实例的创建接口CreateInstance应返回InstanceId。
        self.setup_project_id = setup_project_id
        # Id of the request
        self.request_id = request_id
        # 实例的规格。
        self.setup_project_specification = setup_project_specification

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.setup_project_name is not None:
            result['SetupProjectName'] = self.setup_project_name
        if self.setup_project_id is not None:
            result['SetupProjectId'] = self.setup_project_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.setup_project_specification is not None:
            result['SetupProjectSpecification'] = self.setup_project_specification
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SetupProjectName') is not None:
            self.setup_project_name = m.get('SetupProjectName')
        if m.get('SetupProjectId') is not None:
            self.setup_project_id = m.get('SetupProjectId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SetupProjectSpecification') is not None:
            self.setup_project_specification = m.get('SetupProjectSpecification')
        return self


class UpdateSetupProjectResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: UpdateSetupProjectResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = UpdateSetupProjectResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class UpdateSpaceModelRequestSort(TeaModel):
    def __init__(
        self,
        level_name: str = None,
        level: int = None,
    ):
        # 层级名称
        self.level_name = level_name
        # 层级
        self.level = level

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.level_name is not None:
            result['LevelName'] = self.level_name
        if self.level is not None:
            result['Level'] = self.level
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('LevelName') is not None:
            self.level_name = m.get('LevelName')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        return self


class UpdateSpaceModelRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        space_type: str = None,
        space_model_id: str = None,
        sort: List[UpdateSpaceModelRequestSort] = None,
    ):
        # instanceId
        self.instance_id = instance_id
        # 物理空间类型
        self.space_type = space_type
        # 资源uuid
        self.space_model_id = space_model_id
        # 层级
        self.sort = sort

    def validate(self):
        if self.sort:
            for k in self.sort:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.space_type is not None:
            result['SpaceType'] = self.space_type
        if self.space_model_id is not None:
            result['SpaceModelId'] = self.space_model_id
        result['Sort'] = []
        if self.sort is not None:
            for k in self.sort:
                result['Sort'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('SpaceType') is not None:
            self.space_type = m.get('SpaceType')
        if m.get('SpaceModelId') is not None:
            self.space_model_id = m.get('SpaceModelId')
        self.sort = []
        if m.get('Sort') is not None:
            for k in m.get('Sort'):
                temp_model = UpdateSpaceModelRequestSort()
                self.sort.append(temp_model.from_map(k))
        return self


class UpdateSpaceModelShrinkRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        space_type: str = None,
        space_model_id: str = None,
        sort_shrink: str = None,
    ):
        # instanceId
        self.instance_id = instance_id
        # 物理空间类型
        self.space_type = space_type
        # 资源uuid
        self.space_model_id = space_model_id
        # 层级
        self.sort_shrink = sort_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.space_type is not None:
            result['SpaceType'] = self.space_type
        if self.space_model_id is not None:
            result['SpaceModelId'] = self.space_model_id
        if self.sort_shrink is not None:
            result['Sort'] = self.sort_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('SpaceType') is not None:
            self.space_type = m.get('SpaceType')
        if m.get('SpaceModelId') is not None:
            self.space_model_id = m.get('SpaceModelId')
        if m.get('Sort') is not None:
            self.sort_shrink = m.get('Sort')
        return self


class UpdateSpaceModelResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # Id of the request
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class UpdateSpaceModelResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: UpdateSpaceModelResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = UpdateSpaceModelResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListRegionsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        data: str = None,
        success: bool = None,
        message: str = None,
        code: str = None,
    ):
        # Id of the request
        self.request_id = request_id
        self.data = data
        self.success = success
        self.message = message
        self.code = code

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            resul