// Autogenerated file.

// An entry point offset that indicates that nothing needs to be done.
// Used to implement an empty constructor.
const NOP_ENTRY_POINT_OFFSET = -1;

const ENTRY_POINT_TYPE_EXTERNAL = 0;
const ENTRY_POINT_TYPE_L1_HANDLER = 1;
const ENTRY_POINT_TYPE_CONSTRUCTOR = 2;

const L1_HANDLER_VERSION = 0;

const SIERRA_ARRAY_LEN_BOUND = 4294967296;  // 2^32

// get_selector_from_name('constructor').
const CONSTRUCTOR_ENTRY_POINT_SELECTOR = (
    0x28ffe4ff0f226a9107253e17a904099aa4f63a02a5621de0576e5aa71bc5194
);

// get_selector_from_name('__execute__').
const EXECUTE_ENTRY_POINT_SELECTOR = (
    0x15d40a3d6ca2ac30f4031e42be28da9b056fef9bb7357ac5e85627ee876e5ad
);

// get_selector_from_name('__validate__').
const VALIDATE_ENTRY_POINT_SELECTOR = (
    0x162da33a4585851fe8d3af3c2a9c60b557814e221e0d4f30ff0b2189d9c7775
);

// get_selector_from_name('__validate_declare__').
const VALIDATE_DECLARE_ENTRY_POINT_SELECTOR = (
    0x289da278a8dc833409cabfdad1581e8e7d40e42dcaed693fa4008dcdb4963b3
);

// get_selector_from_name('__validate_deploy__').
const VALIDATE_DEPLOY_ENTRY_POINT_SELECTOR = (
    0x36fcbf06cd96843058359e1a75928beacfac10727dab22a3972f0af8aa92895
);

// get_selector_from_name('transfer').
const TRANSFER_ENTRY_POINT_SELECTOR = (
    0x83afd3f4caedc6eebf44246fe54e38c95e3179a5ec9ea81740eca5b482d12e
);

const DEFAULT_ENTRY_POINT_SELECTOR = 0;

// OS reserved contract addresses.

// This contract stores the block number -> block hash mapping.
const BLOCK_HASH_CONTRACT_ADDRESS = 1;
// This contract stores the aliases mapping used for stateful compression.
const ALIAS_CONTRACT_ADDRESS = 2;
// Future reserved contract address.
const RESERVED_CONTRACT_ADDRESS = 3;
// The block number -> block hash mapping is written for the current block number minus this number.
const STORED_BLOCK_HASH_BUFFER = 10;

// Gas constants.
const STEP_GAS_COST = 100;
const RANGE_CHECK_GAS_COST = 70;
const KECCAK_BUILTIN_GAS_COST = 136189;
const PEDERSEN_GAS_COST = 4050;
const BITWISE_BUILTIN_GAS_COST = 583;
const ECOP_GAS_COST = 4085;
const POSEIDON_GAS_COST = 491;
const ADD_MOD_GAS_COST = 230;
const MUL_MOD_GAS_COST = 604;
const ECDSA_GAS_COST = 10561;
const MEMORY_HOLE_GAS_COST = 10;

const DEFAULT_INITIAL_GAS_COST = 100000000 * STEP_GAS_COST;
const VALIDATE_MAX_SIERRA_GAS = 100000000;
const EXECUTE_MAX_SIERRA_GAS = 1000000000;
const DEFAULT_INITIAL_GAS_COST_NO_L2 = VALIDATE_MAX_SIERRA_GAS + EXECUTE_MAX_SIERRA_GAS;

// Compiler gas costs.

// The initial budget at an entry point. This needs to be high enough to cover the initial get_gas.
// The entry point may refund whatever remains from the initial budget.
const ENTRY_POINT_INITIAL_BUDGET = 100 * STEP_GAS_COST;
// The gas cost of each syscall libfunc (this value is hard-coded by the compiler).
// This needs to be high enough to cover OS costs in the case of failure due to out of gas.
const SYSCALL_BASE_GAS_COST = 100 * STEP_GAS_COST;

// Syscall gas costs.
const CALL_CONTRACT_GAS_COST = 15 * RANGE_CHECK_GAS_COST + 866 * STEP_GAS_COST;
const DEPLOY_GAS_COST = 7 * PEDERSEN_GAS_COST + 18 * RANGE_CHECK_GAS_COST + 1132 * STEP_GAS_COST;
const GET_BLOCK_HASH_GAS_COST = 2 * RANGE_CHECK_GAS_COST + 104 * STEP_GAS_COST;
const GET_CLASS_HASH_AT_GAS_COST = 1 * SYSCALL_BASE_GAS_COST;
const GET_EXECUTION_INFO_GAS_COST = 1 * SYSCALL_BASE_GAS_COST;
const LIBRARY_CALL_GAS_COST = 15 * RANGE_CHECK_GAS_COST + 842 * STEP_GAS_COST;
const REPLACE_CLASS_GAS_COST = 1 * RANGE_CHECK_GAS_COST + 104 * STEP_GAS_COST;
const STORAGE_READ_GAS_COST = 1 * SYSCALL_BASE_GAS_COST;
const STORAGE_WRITE_GAS_COST = 1 * SYSCALL_BASE_GAS_COST;
const EMIT_EVENT_GAS_COST = 1 * SYSCALL_BASE_GAS_COST;
const SEND_MESSAGE_TO_L1_GAS_COST = 1 * RANGE_CHECK_GAS_COST + 141 * STEP_GAS_COST;

// Note the the following costs include `SYSCALL_BASE_GAS_COST` implicitly.
const SECP256K1_ADD_GAS_COST = 29 * RANGE_CHECK_GAS_COST + 410 * STEP_GAS_COST;
const SECP256K1_GET_POINT_FROM_X_GAS_COST = 30 * RANGE_CHECK_GAS_COST + 395 * STEP_GAS_COST;
const SECP256K1_GET_XY_GAS_COST = 11 * RANGE_CHECK_GAS_COST + 207 * STEP_GAS_COST;
const SECP256K1_MUL_GAS_COST = 7045 * RANGE_CHECK_GAS_COST + 76505 * STEP_GAS_COST;
const SECP256K1_NEW_GAS_COST = 35 * RANGE_CHECK_GAS_COST + 461 * STEP_GAS_COST;
const SECP256R1_ADD_GAS_COST = 57 * RANGE_CHECK_GAS_COST + 593 * STEP_GAS_COST;
const SECP256R1_GET_POINT_FROM_X_GAS_COST = 44 * RANGE_CHECK_GAS_COST + 514 * STEP_GAS_COST;
const SECP256R1_GET_XY_GAS_COST = 11 * RANGE_CHECK_GAS_COST + 209 * STEP_GAS_COST;
const SECP256R1_MUL_GAS_COST = 13961 * RANGE_CHECK_GAS_COST + 125344 * STEP_GAS_COST;
const SECP256R1_NEW_GAS_COST = 49 * RANGE_CHECK_GAS_COST + 580 * STEP_GAS_COST;

const KECCAK_GAS_COST = 1 * SYSCALL_BASE_GAS_COST;
const KECCAK_ROUND_COST_GAS_COST = 6 * BITWISE_BUILTIN_GAS_COST + 1 * KECCAK_BUILTIN_GAS_COST + 56 *
    RANGE_CHECK_GAS_COST + 281 * STEP_GAS_COST;
const SHA256_PROCESS_BLOCK_GAS_COST = 1115 * BITWISE_BUILTIN_GAS_COST + 65 * RANGE_CHECK_GAS_COST +
    1865 * STEP_GAS_COST;

// Cairo 1.0 error codes.
const ERROR_BLOCK_NUMBER_OUT_OF_RANGE = 'Block number out of range';
const ERROR_OUT_OF_GAS = 'Out of gas';
const ERROR_ENTRY_POINT_FAILED = 'ENTRYPOINT_FAILED';
const ERROR_ENTRY_POINT_NOT_FOUND = 'ENTRYPOINT_NOT_FOUND';
const ERROR_INVALID_INPUT_LEN = 'Invalid input length';
const ERROR_INVALID_ARGUMENT = 'Invalid argument';

// The expected return value of the `__validate*__` functions of a Cairo 1.0 account contract.
const VALIDATED = 'VALID';

// Resources
const L1_GAS = 'L1_GAS';
const L2_GAS = 'L2_GAS';
const L1_DATA_GAS = 'L1_DATA';
const L1_GAS_INDEX = 0;
const L2_GAS_INDEX = 1;
const L1_DATA_GAS_INDEX = 2;

// Round down the block number and timestamp when queried inside `__validate__`.
const VALIDATE_BLOCK_NUMBER_ROUNDING = 100;
const VALIDATE_TIMESTAMP_ROUNDING = 3600;
