## Flow

You can create a simple app with the following code:

```Python 
from tensorpc.flow import mui, three, plus, appctx, mark_create_layout, flowui
class App:
    class Config(plus.AppInMemory.Config):
        is_horizontal = False
        height = "800px"
    @mark_create_layout
    def my_layout(self):
        node_ui_bs = []
        node_ui_cs = []
        for j in range(3):
            node_ui_bs.append(mui.VBox([
                mui.Typography(f"only connectable with handle id prefix PB"),
                flowui.Handle("source", "right", id=f"PB-{j}")
            ]).prop(width=200,  alignItems="center", backgroundColor="white", border="1px solid black"))
        for j in range(2):
            node_ui_cs.append(mui.VBox([
                mui.Typography(f"only connectable with handle id prefix PC"),
                flowui.Handle("source", "right", id=f"PC-{j}")
            ]).prop(width=200,  alignItems="center", backgroundColor="white", border="1px solid black"))
        custom_node_ui_source_a = mui.VBox([
            mui.Typography("only connectable with handle id prefix PA"),
            flowui.Handle("source", "right", id="PA-0")
        ]).prop(width=200,  alignItems="center", backgroundColor="white", border="1px solid black")

        custom_node_ui_tgt_a = mui.VBox([
            mui.Typography("Node handle with PA prefix"),
            flowui.Handle("target", "left", id="PA-wtfnode")
        ]).prop(width=200,  alignItems="center", backgroundColor="white", border="1px solid black")
        custom_node_ui_tgt_b = mui.VBox([
            mui.Typography("Node handle with PB prefix"),
            flowui.Handle("target", "left", id="PB-wtfnode")
        ]).prop(width=200,  alignItems="center", backgroundColor="white", border="1px solid black")
        custom_node_ui_tgt_c = mui.VBox([
            mui.Typography("Node handle with PC prefix"),
            flowui.Handle("target", "left", id="PC-wtfnode")
        ]).prop(width=200,  alignItems="center", backgroundColor="white", border="1px solid black")

        nodes = [
            flowui.Node(id="sa", type="app", data=flowui.NodeData(component=custom_node_ui_source_a), position=flowui.XYPosition(0, 0)),
            flowui.Node(id="sb1", type="app", data=flowui.NodeData(component=node_ui_bs[0]), position=flowui.XYPosition(0, 60)),
            flowui.Node(id="sb2", type="app", data=flowui.NodeData(component=node_ui_bs[1]), position=flowui.XYPosition(0, 120)),
            flowui.Node(id="sb3", type="app", data=flowui.NodeData(component=node_ui_bs[2]), position=flowui.XYPosition(0, 180)),
            flowui.Node(id="sc1", type="app", data=flowui.NodeData(component=node_ui_cs[0]), position=flowui.XYPosition(0, 240)),
            flowui.Node(id="sc2", type="app", data=flowui.NodeData(component=node_ui_cs[1]), position=flowui.XYPosition(0, 300)),

            flowui.Node(id="ta", type="app", data=flowui.NodeData(component=custom_node_ui_tgt_a), position=flowui.XYPosition(300, 0)),
            flowui.Node(id="tb", type="app", data=flowui.NodeData(component=custom_node_ui_tgt_b), position=flowui.XYPosition(300, 100)),
            flowui.Node(id="tc", type="app", data=flowui.NodeData(component=custom_node_ui_tgt_c), position=flowui.XYPosition(300, 200)),
        ]
        # conn map for target handle
        valid_conn_map_target = {
            "PA": {
                "PA": 1, # target PA can connect one source PA
            },
            "PB": {
                "PA": 1, # target PB can connect one source PA
                "PB": 2, # target PB can connect two source PB
            },
            "PC": {
                "PB": 1, # target PC can connect one source PB
                "PC": 2, # target PC can connect two source PB
            },
        }
        return mui.HBox([
            flowui.Flow(nodes, [], [
                flowui.MiniMap(),
                flowui.Controls(),
                flowui.Background(),
            ]).prop(targetValidConnectMap=valid_conn_map_target),
        ]).prop(width="100%", height="100%", overflow="hidden").update_sx_props({
            ".react-flow__handle": {
                "borderRadius": "100%",
                "height": "12px",
                "width": "12px",
                "border": "1px solid red",
                "background": "#eee"
            },
            ".react-flow__handle-left": {
                "left": "-0px",
            },
            ".react-flow__handle-right": {
                "right": "-0px",
            },

        })
```

