## Handles

### Basic Custom Handles

You can use absolute position to control handle position.

```Python 
from tensorpc.flow import mui, three, plus, appctx, mark_create_layout, flowui
class App:
    class Config(plus.AppInMemory.Config):
        is_horizontal = False
        height = "800px"
    @mark_create_layout
    def my_layout(self):
        custom_node_ui = mui.VBox([
            mui.HBox([
                flowui.Handle(type="target", position="left", id="0").prop(position="absolute", top="50%"),
                mui.Typography("large handle"),
            ]).prop(flex=2, position="relative", alignItems="center", border="1px solid black"),
            mui.HBox([
                flowui.Handle(type="target", position="left", id="1").prop(position="relative", alignSelf="flex-start"),
                mui.Typography("small handle"),

            ]).prop(alignItems="center", border="1px solid black"),
            mui.HBox([
                flowui.Handle(type="target", position="left", id="2").prop(position="relative", alignSelf="flex-start"),
                mui.Typography("small handle"),

            ]).prop(alignItems="center", border="1px solid black"),
            mui.HBox([
                flowui.Handle(type="target", position="left", id="3").prop(position="relative", alignSelf="flex-start"),
                mui.Typography("small handle"),
            ]).prop(alignItems="center", border="1px solid black"),
        ]).prop(width=300, height=400, backgroundColor="white", border="1px solid black")
        custom_node_ui.update_sx_props({
            ".react-flow__handle": {
                "background": "#bbb",
                "width": "8px",
                "height": "4px",
                "border": "none",
                "borderRadius": "0",
            },
            ".react-flow__handle-left": {
                "height": "8px",
                "width": "4px",
                "left": "-7px",
                "borderRadius": "2px 0 0 2px",
            },

        })
        nodes = [
            flowui.Node(id="1-1", type="input", data=flowui.NodeData(label="Input Node"), position=flowui.XYPosition(0, 0), sourcePosition="right"),

            flowui.Node(id="a", type="app", data=flowui.NodeData(component=custom_node_ui), position=flowui.XYPosition(300, 0)),
        ]
        return mui.HBox([
            flowui.Flow(nodes, [], [
                flowui.MiniMap(),
                flowui.Controls(),
                flowui.Background(),
            ]),
        ]).prop(width="100%", height="100%", overflow="hidden")
```

### Dynamically Add or Remove Handles

you need to use `update_node_internals` to tell flowui to update the node internals when you dynamically add/delete handle.

```Python 
from tensorpc.flow import mui, three, plus, appctx, mark_create_layout, flowui
class App:
    class Config(plus.AppInMemory.Config):
        is_horizontal = False
        height = "800px"
    @mark_create_layout
    def my_layout(self):
        self.handle_cnt = 1
        handle_container = mui.Fragment([
            mui.HBox([
                flowui.Handle(type="target", position="left", id="0").prop(position="absolute", top="50%"),
                mui.Typography("large handle"),
            ]).prop(flex=1, position="relative", alignItems="center", border="1px solid black"),

        ])
        self.handle_container = handle_container
        node_ui = mui.VBox([
            handle_container,
            mui.Button("add handle", self._add_handle).prop(size="small"),
        ]).prop(width=300, height=400, backgroundColor="white", border="1px solid black")

        nodes = [
            flowui.Node(id="1-1", type="input", data=flowui.NodeData(label="Input Node"), position=flowui.XYPosition(0, 0), sourcePosition="right"),
            flowui.Node(id="a", type="app", data=flowui.NodeData(component=node_ui), position=flowui.XYPosition(300, 0)),
        ]
        edges = [
            flowui.Edge("1-1->a", "1-1", "a"),
        ]
        self.graph = flowui.Flow(nodes, edges, [
                flowui.MiniMap(),
                flowui.Controls(),
                flowui.Background(),
            ])
        return mui.HBox([
            self.graph,
        ]).prop(width="100%", height="100%", overflow="hidden")

    async def _add_handle(self):
        await self.handle_container.update_childs({
            str(self.handle_cnt): mui.HBox([
                flowui.Handle(type="target", position="left", id=str(self.handle_cnt)).prop(position="absolute", top="50%"),
                mui.Typography("large handle"),
            ]).prop(flex=1, position="relative", alignItems="center", border="1px solid black"),
        })
        await self.graph.update_node_internals(["a"])
        self.handle_cnt += 1
```
