## Flow

You can create a simple app with the following code:

```Python 
from tensorpc.flow import mui, three, plus, appctx, mark_create_layout, flowui
class App:
    
    class Config(plus.AppInMemory.Config):
        is_horizontal = False
        height = "800px"

    @mark_create_layout
    def my_layout(self):
        self.node_add_cnt = 0
        graph = flowui.Flow([], [], [
            flowui.MiniMap(),
            flowui.Controls(),
            flowui.Background()
        ])
        self.graph = graph
        return mui.HBox([
            graph,
            mui.HBox([
                mui.Button("addNode", self.add_node),
            ]).prop(position="absolute", top=0, right=0),
        ]).prop(width="100%", height="100%", overflow="hidden", position="relative")

    async def _delay_delete_node(self, node_id: str):
        await self.graph.delete_nodes_by_ids([node_id])

    async def add_node(self):
        node_id = f"n{self.node_add_cnt}"
        node = flowui.Node(id=node_id, type="app", data=flowui.NodeData(component=mui.HBox([
            mui.Button(f"Delete Me {self.node_add_cnt}", lambda: self._delay_delete_node(node_id)),
        ]).prop(minWidth=100, minHeight=100)), position=flowui.XYPosition(0, self.node_add_cnt * 100))
        await self.graph.add_node(node)
        self.node_add_cnt += 1

```

