## Flow

You can create a simple app with the following code:

```Python 
from tensorpc.flow import mui, three, plus, appctx, mark_create_layout, flowui
class App:
    
    class Config(plus.AppInMemory.Config):
        is_horizontal = False
        height = "800px"

    @mark_create_layout
    def my_layout(self):
        nodes = [
            flowui.Node(id="1", type="input", data=flowui.NodeData(label="Input Node"), position=flowui.XYPosition(0, 0)),
            flowui.Node(id="2", data=flowui.NodeData(label="node 2"), position=flowui.XYPosition(0, 100)),
            flowui.Node(id="2a", data=flowui.NodeData(label="node 2a"), position=flowui.XYPosition(0, 200)),
            flowui.Node(id="2b", data=flowui.NodeData(label="node 2b"), position=flowui.XYPosition(0, 300)),
            flowui.Node(id="2c", data=flowui.NodeData(label="node 2c"), position=flowui.XYPosition(0, 400)),
            flowui.Node(id="2d", data=flowui.NodeData(label="node 2d"), position=flowui.XYPosition(0, 500)),
            flowui.Node(id="3", data=flowui.NodeData(label="node 3"), position=flowui.XYPosition(200, 100)),

        ]
        edges = [
            flowui.Edge("e12", source="1", target="2", animated=True),
            flowui.Edge("e13", source="1", target="3", animated=True),
            flowui.Edge("e22a", source="2", target="2a", animated=True),
            flowui.Edge("e22b", source="2", target="2b", animated=True),
            flowui.Edge("e22c", source="2", target="2c", animated=True),
            flowui.Edge("e2c2d", source="2c", target="2d", animated=True),
        ]
        g = flowui.Flow(nodes, edges, [
            flowui.MiniMap(),
            flowui.Controls(),
            flowui.Background()
        ])
        return mui.HBox([
            g,
            mui.HBox([
                mui.Button("LayoutV", lambda: g.do_dagre_layout(g.DagreLayoutOptions(rankdir="TB"))),
                mui.Button("LayoutH", lambda: g.do_dagre_layout(g.DagreLayoutOptions(rankdir="LR"))),
            ]).prop(position="absolute", top=0, right=0),
        ]).prop(width="100%", height="100%", overflow="hidden", position="relative")
```

