## Edges

You can create a simple app with the following code:

```Python 
from tensorpc.flow import mui, three, plus, appctx, mark_create_layout, flowui
class App:
    
    class Config(plus.AppInMemory.Config):
        is_horizontal = False
        height = "800px"

    @mark_create_layout
    def my_layout(self):
        nodedata_with_custom_edge = flowui.NodeData(label="Input Node With Custom Edge", sourceEdgeOverrides={
            "animated": True,
            "style": {
                "stroke": "red",
                "strokeWidth": 2
            }
        })
        nodes = [
            flowui.Node(id="1", type="input", data=nodedata_with_custom_edge, position=flowui.XYPosition(0, 0)),
            flowui.Node(id="2", type="input", data=flowui.NodeData(label="Input Node"), position=flowui.XYPosition(200, 0)),

            flowui.Node(id="3", data=flowui.NodeData(label="node 2"), position=flowui.XYPosition(100, 150)),
        ]
        graph = flowui.Flow(nodes, [], [
            flowui.MiniMap(),
            flowui.Controls(),
            flowui.Background()
        ])
        return mui.HBox([
            graph,
        ]).prop(width="100%", height="100%", overflow="hidden")
```

