## Flow

You can create a simple app with the following code:

```Python 
from tensorpc.flow import mui, three, plus, appctx, mark_create_layout, flowui

flow_css = {
    ".overview *": {
        "box-sizing": "border-box",
    },
    ".overview .react-flow__controls button": {
        "box-sizing": "content-box",
    },
    ".overview .react-flow__node": {
        "font-size": "12px",
    },
    ".edgebutton": {
        "width": "20px",
        "height": "20px",
        "background": "#eee",
        "border": "1px solid #fff",
        "cursor": "pointer",
        "border-radius": "50%",
        "font-size": "12px",
        "line-height": "1",
    },
    ".edgebutton:hover": {
        "box-shadow": "0 0 6px 2px rgba(0, 0, 0, 0.08)",
    },
    ".react-flow__node-tools": {
        "border": "1px solid #333",
        "background": "white",
        "display": "flex",
        "justify-content": "center",
        "align-items": "center",
        "text-align": "center",
    },
    ".react-flow__node-toolbar": {
        "border-radius": "5px",
        "box-shadow": "0 0 6px 1px rgba(0, 0, 0, 0.08)",
    },
    ".react-flow__node-resizer": {
        "background": "white",
        "display": "flex",
        "justify-content": "center",
        "align-items": "center",
        "text-align": "center",
    },
    ".react-flow__node-resizer .react-flow__handle, .react-flow__node-circle .react-flow__handle, .react-flow__node-textinput .react-flow__handle": {
        "background": "#bbb",
        "border-radius": "0",
        "width": "8px",
        "height": "4px",
        "border": "none",
        "min-width": "2px",
        "min-height": "2px",
    },
    ".react-flow__node-resizer .react-flow__handle-bottom, .react-flow__node-circle .react-flow__handle-bottom, .react-flow__node-textinput .react-flow__handle-bottom": {
        "bottom": "-5px",
        "transform": "none",
        "border-radius": "0 0 2px 2px",
    },
    ".react-flow__node-resizer .react-flow__handle-top, .react-flow__node-circle .react-flow__handle-top, .react-flow__node-textinput .react-flow__handle-top": {
        "top": "-5px",
        "transform": "none",
        "border-radius": "2px 2px 0 0",
    },
    ".react-flow__node-resizer .react-flow__handle-left, .react-flow__node-circle .react-flow__handle-left, .react-flow__node-textinput .react-flow__handle-left": {
        "height": "8px",
        "width": "4px",
        "left": "-5px",
        "border-radius": "2px 0 0 2px",
    },
    ".react-flow__node-annotation": {
        "font-size": "16px",
        "width": "200px",
        "color": "rgb(158, 118, 255)",
        "font-family": "monospace",
        "position": "absolute",
    },
    ".react-flow__node-annotation .arrow": {
        "position": "absolute",
        "font-size": "24px",
    },
    ".react-flow__node-circle, .react-flow__node-textinput": {
        "color": "#fff",
        "border-radius": "100%",
        "display": "flex",
        "height": "75px",
        "width": "75px",
        "box-shadow": "6px 2px 15px rgba(42, 138, 246, 0.3), -6px 2px 15px rgba(233, 42, 103, 0.3)",
        "font-family": "monospace",
    },
    ".react-flow__node-circle .wrapper, .react-flow__node-textinput .wrapper": {
        "overflow": "hidden",
        "display": "flex",
        "padding": "2px",
        "position": "relative",
        "border-radius": "100%",
        "flex-grow": "1",
    },
    ".react-flow__node-circle .inner": {
        "background": "rgba(255, 255, 255, 0.5)",
        "border-radius": "100%",
        "display": "flex",
        "flex-direction": "column",
        "justify-content": "center",
        "flex-grow": "1",
        "position": "relative",
        "text-align": "center",
    },
    ".react-flow__node-textinput": {
        "border-radius": "5px",
        "width": "150px",
        "text-align": "left",
        "height": "auto",
    },
    ".react-flow__node-textinput .wrapper": {
        "border-radius": "5px",
        "height": "100%",
    },
    ".react-flow__node-textinput .inner": {
        "background": "rgba(255, 255, 255, 0.5)",
        "flex-grow": "1",
        "position": "relative",
        "padding": "10px",
        "border-radius": "4px",
        "height": "100%",
    },
    ".react-flow__node-textinput input": {
        "width": "100%",
        "font-size": "12px",
        "border": "none",
        "border-radius": "2px",
        "margin-bottom": "10px",
        "margin-top": "2px",
        "padding": "2px 4px",
        "color": "#555",
    },
    ".gradient:before": {
        "content": "''",
        "position": "absolute",
        "padding-bottom": "calc(100% * 1.41421356237)",
        "width": "calc(100% * 1.41421356237)",
        "background": r"conic-gradient(from -160deg at 50% 50%, #e92a67 0deg, #a853ba 120deg, #2a8af6 240deg, #e92a67 360deg)",
        "left": "50%",
        "top": "50%",
        "transform": "translate(-50%, -50%)",
        "border-radius": "100%",
    },
    ".react-flow__minimap .group": {
        "fill-opacity": "0.4",
    },
    ".react-flow__minimap .resizer, .react-flow__minimap .tools, .react-flow__minimap .circle, .react-flow__minimap .textinput": {
        "fill": "rgb(208, 192, 247)",
    },
    ".react-flow__minimap .resizer": {
        "fill": "rgb(208, 192, 247)",
    },
    ".react-flow__minimap .circle": {
        "rx": "100%",
        "ry": "100%",
    },
    ".react-flow__minimap .annotation": {
        "display": "none",
    },

}

class App:
    
    class Config(plus.AppInMemory.Config):
        is_horizontal = False
        height = "800px"

    @mark_create_layout
    def my_layout(self):
        tools_content = mui.Typography("🚀")
        nodes = [
            flowui.Node(id="1-1", type="input", data=flowui.NodeData(label="Input Node"), position=flowui.XYPosition(150, 0)),
            flowui.Node(id="1-2", type="default", data=flowui.NodeData(label="Default Node"), position=flowui.XYPosition(0, 100)),
            flowui.Node(id="1-3", type="output", data=flowui.NodeData(label="Output Node"), position=flowui.XYPosition(300, 100)),
            flowui.Node(id="2-1", type="group", position=flowui.XYPosition(-170, 250), style={
                "width": 380,
                "height": 180,
                "backgroundColor": 'rgba(208, 192, 247, 0.2)',
            }),
            flowui.Node(id="2-2", type="tools", data=flowui.NodeData(component=mui.Fragment([
                flowui.NodeToolbar([
                    mui.ButtonGroup([
                        mui.Button("🚀", lambda: tools_content.write("🚀")).prop(size="small"),
                        mui.Button("🔥", lambda: tools_content.write("🔥")).prop(size="small"),
                        mui.Button("✨", lambda: tools_content.write("✨")).prop(size="small"),
                    ])
                ]).prop(isVisible=True),
                flowui.Handle(type="target", position="left"),
                flowui.Handle(type="source", position="right"),
                tools_content,
            ])), position=flowui.XYPosition(50, 50), style={
                "width": 80,
                "height": 80,
                "backgroundColor": 'rgba(208, 192, 247)',
            }, parentId="2-1", extent="parent"),
            flowui.Node(id="2-3", type="resizer", data=flowui.NodeData(component=mui.Fragment([
                flowui.NodeResizer().prop(minWidth=50, minHeight=50),
                flowui.Handle(type="target", position="left"),
                mui.Typography("resizable node").prop(variant="caption"),
                mui.HBox([
                    flowui.Handle(type="source", position="bottom").prop(style={"position": 'relative', "left": 0, "transform": 'none' }, id="a"),
                    flowui.Handle(type="source", position="bottom").prop(style={"position": 'relative', "left": 0, "transform": 'none' }, id="b"),
                ]).prop(justifyContent="space-evenly", width="100%", bottom=0, position="absolute"),

            ])), position=flowui.XYPosition(250, 50), style={
                "width": 80,
                "height": 80,
                "backgroundColor": 'rgba(208, 192, 247)',
            }, parentId="2-1", extent="parent"),
            flowui.Node(id="3-2", type="textinput", data=flowui.NodeData(component=mui.VBox([
                mui.VBox([
                    mui.VBox([
                        mui.HBox([
                            mui.Typography("drag me!").prop(variant="body1")
                        ]).prop(className="custom-drag-handle"),
                        mui.Divider(),
                        mui.Typography("node width").prop(variant="body1"),
                        mui.BlenderSlider(50, 200, callback=self._update_node_width, init_value=80).prop(showControlButton=True),
                        # mui.TextField("width", self._update_node_width, init="80").prop(type="number"),
                        mui.Typography("node height").prop(variant="body1"),
                        mui.TextField("height", self._update_node_height, init="80").prop(type="number"),
                    ]).prop(className="inner"),
                ]).prop(className="wrapper gradient"),
                flowui.Handle(type="target", position="top"),

            ])), position=flowui.XYPosition(150, 650), dragHandle=".custom-drag-handle"),
            flowui.Node(id="3-1", type="circle", data=flowui.NodeData(component=mui.Fragment([
                mui.HBox([
                    mui.HBox([
                        mui.Typography("circle").prop(variant="body1")
                    ]).prop(className="inner"),
                ]).prop(className="wrapper gradient"),
                flowui.Handle(type="target", position="left"),

            ])), position=flowui.XYPosition(350, 500)),

        ]
        edges = [
            flowui.Edge("e1-2", source="1-1", target="1-2", label="edge", type="smoothstep"),
            flowui.Edge("e1-3", source="1-1", target="1-3", label="animated edge", animated=True),
            flowui.Edge("e2-2", source="1-2", target="2-2", type="smoothstep", markerEnd=flowui.EdgeMarker(type="arrowclosed")),
            flowui.Edge("e2-3", source="2-2", target="2-3", type="smoothstep", markerEnd=flowui.EdgeMarker(type="arrowclosed")),
            flowui.Edge("e3-3", source="2-3", sourceHandle="a", target="3-2", animated=True, style={
                "stroke": 'rgb(158, 118, 255)', "strokeWidth": 2
            }),
            flowui.Edge("e3-4", source="2-3", sourceHandle="b", target="3-1", style={
                "strokeWidth": 2
            }),

        ]
        self.graph = flowui.Flow(nodes, edges, [
                flowui.MiniMap(),
                flowui.Controls(),
                flowui.Background()
            ]).prop(className="overview", nodeTypeMap={
                "tools": "app",
                "resizer": "app",
                "circle": "app",
                "textinput": "app",
            })
        return mui.HBox([
            self.graph,
        ]).prop(width="100%", height="100%", overflow="hidden").update_sx_props(flow_css)

    async def _update_node_width(self, value: int):
        int_value = int(value)
        await self.graph.update_node_style("2-3", {
            "width": int_value
        })

    async def _update_node_height(self, value: str):
        int_value = int(value)
        await self.graph.update_node_style("2-3", {
            "height": int_value
        })

```

