## Image 

a basic image component, support image url or ```np.ndarray```.

### Basic Usage

* from url

```Python


from tensorpc.flow import mui, three, plus, appctx, mark_create_layout
URL = "https://myoctocat.com/assets/images/base-octocat.svg"
class App:
    @mark_create_layout
    def my_layout(self):
        return mui.VBox([
            mui.Image().prop(image=URL),
        ]).prop(flex=1)


```

* from ```np.ndarray```

```Python

import numpy as np 
from tensorpc.flow import mui, three, plus, appctx, mark_create_layout
ARRAY = np.zeros([400, 400, 3], np.uint8)

for i in range(100, 300):
    for j in range(100, 300):
        ARRAY[i, j, 0] = 127
        ARRAY[i, j, 1] = 0
        ARRAY[i, j, 2] = 255

class App:
    @mark_create_layout
    def my_layout(self):
        return mui.VBox([
            mui.Image().prop(image=mui.Image.encode_image_bytes(ARRAY)),
        ]).prop(flex=1)


```


### Events 

```Python

from tensorpc.flow import mui, three, plus, appctx, mark_create_layout
URL = "https://myoctocat.com/assets/images/base-octocat.svg"
class App:
    @mark_create_layout
    def my_layout(self):
        img_with_ev = mui.Image().prop(image=URL)
        img_with_ev.event_pointer_move.on(self._on_pointer_move)
        self.event_content = mui.JsonViewer()
        return mui.VBox([
            img_with_ev,
            self.event_content,
        ])

    async def _on_pointer_move(self, data):
        await self.event_content.send_and_wait(self.event_content.update_event(data=data))

```