## Select

Select components are used for collecting user provided information from a list of options.

Due to limitation of python typing, we split the select component into `Select` and `MultipleSelect`.

### Basic Usage

We need to provide a list of options to the select component. The options must be a list of tuple (name, value).

```Python
from tensorpc.flow import mui, three, plus, appctx, mark_create_layout

class App:
    @mark_create_layout
    def my_layout(self):
        md = mui.Markdown()
        options = [
            ("Option 1", "option1"),
            ("Option 2", "option2"),
            ("Option 3", "option3"),
        ]
        return mui.VBox([
            mui.Select("Select", options, callback=lambda x: md.write(f"Select: :green[{x}]")).prop(muiMargin="dense"),
            md,
        ]).prop(width="100%", justifyContent="space-between")

```

* variant

select use ```TextField``` as the base component. So it support three variants: ```filled```, ```outlined```, ```standard```.

```Python
from tensorpc.flow import mui, three, plus, appctx, mark_create_layout

class App:
    @mark_create_layout
    def my_layout(self):
        md = mui.Markdown()
        options = [
            ("Option 1", "option1"),
            ("Option 2", "option2"),
            ("Option 3", "option3"),
        ]
        return mui.VBox([
            mui.VBox([
                mui.Select("Select", options, callback=lambda x: md.write(f"Select: :green[{x}]")).prop(muiMargin="dense", variant="filled"),
                mui.Select("Select", options, callback=lambda x: md.write(f"Select: :green[{x}]")).prop(muiMargin="dense", variant="outlined"),
                mui.Select("Select", options, callback=lambda x: md.write(f"Select: :green[{x}]")).prop(muiMargin="dense", variant="standard"),
            ]),

            md,
        ]).prop(width="100%", justifyContent="space-between")

```

### MultipleSelect 

MultipleSelect is a select component that support multiple selection.

```Python
from tensorpc.flow import mui, three, plus, appctx, mark_create_layout

class App:
    @mark_create_layout
    def my_layout(self):
        md = mui.Markdown()
        options = [
            ("Option 1", "option1"),
            ("Option 2", "option2"),
            ("Option 3", "option3"),
        ]
        return mui.VBox([
            mui.MultipleSelect("Select", options, callback=lambda x: md.write(f"Select: :green[{x}]")).prop(muiMargin="dense"),
            md,
        ]).prop(width="100%", justifyContent="space-between")

```

* checkbox

```Python
from tensorpc.flow import mui, three, plus, appctx, mark_create_layout

class App:
    @mark_create_layout
    def my_layout(self):
        md = mui.Markdown()
        options = [
            ("Option 1", "option1"),
            ("Option 2", "option2"),
            ("Option 3", "option3"),
        ]
        return mui.VBox([
            mui.MultipleSelect("Select", options, callback=lambda x: md.write(f"Select: :green[{x}]")).prop(muiMargin="dense", itemVariant="checkbox"),
            md,
        ]).prop(width="100%", justifyContent="space-between")

```