## MUIList 

```mui.MUIList``` is a component that can display a list of items with predefined styles.

It should be used to implement navigation drawer, menu, etc.

If you want to display list of data, use ```mui.FlexBox``` or ```mui.DataFlexBox``` instead. 

### Basic Usage

usage of ```mui.MUIList``` is similar to mui in typescript, see [MUI List](https://mui.com/material-ui/react-list/) for more details.


```Python
from tensorpc.flow import mui, three, plus, appctx, mark_create_layout

class App:
    @mark_create_layout
    def my_layout(self):
        return mui.VBox([
            mui.MUIList([
                mui.ListItemButton([
                    mui.ListItemIcon(mui.IconType.Add),
                    mui.ListItemText("button 0"),
                ]),
                mui.ListItemButton([
                    mui.ListItemIcon(mui.IconType.Terminal),
                    mui.ListItemText("button 1"),
                    mui.Icon(mui.IconType.ExpandMore),
                ]),
            ]),
        ]).prop(width="100%")

```

We only support button + icon style of mui List. for other styles, use ```mui.FlexBox``` or ```mui.DataFlexBox``` instead.

* dense 

```Python
from tensorpc.flow import mui, three, plus, appctx, mark_create_layout

class App:
    @mark_create_layout
    def my_layout(self):
        return mui.VBox([
            mui.MUIList([
                mui.ListItemButton([
                    mui.ListItemIcon(mui.IconType.Add),
                    mui.ListItemText("button 0"),
                ]),
                mui.ListItemButton([
                    mui.ListItemIcon(mui.IconType.Terminal),
                    mui.ListItemText("button 1"),
                ]),
            ]).prop(dense=True),
        ]).prop(width="100%")

```

* sub header 

```Python
from tensorpc.flow import mui, three, plus, appctx, mark_create_layout

class App:
    @mark_create_layout
    def my_layout(self):
        return mui.VBox([
            mui.MUIList([
                mui.ListItemButton([
                    mui.ListItemIcon(mui.IconType.Add),
                    mui.ListItemText("button 0"),
                ]),
                mui.ListItemButton([
                    mui.ListItemIcon(mui.IconType.Terminal),
                    mui.ListItemText("button 1"),
                ]),
                mui.ListItemButton([
                    mui.ListItemText("text only"),
                ]),
                mui.ListItemButton([
                    mui.ListItemText("text only + inset").prop(inset=True),
                ]),
            ]).prop(dense=True, disablePadding=True, subheader="group 0"),
        ]).prop(width="100%")

```
