## Markdown 

Markdown is a lightweight markup language with plain text formatting syntax. It is designed so that it can be converted to HTML and many other formats using a tool by the same name. Markdown is often used to format readme files, for writing messages in online discussion forums, and to create rich text using a plain text editor.

Markdown in devflow support gfm (Github Flavored Markdown) natively. it also support latex expression, emoji (utf-8) and colored text. the latex and emoji support must be enabled manually.

**WARNING**: ```mui.Markdown``` vs ```mui.Typography```

```mui.Markdown``` usually greatly slower than ```mui.Typography``` when you use many components. This is because ```mui.Markdown``` is a component that can parse markdown text, while ```mui.Typography``` is a component that can only display text. So if you only want to display simple text, use ```mui.Typography``` instead of ```mui.Markdown```.

### Basic Usage


```Python

from tensorpc.flow import mui, three, plus, appctx, mark_create_layout
class App:
    @mark_create_layout
    def my_layout(self):
        return mui.VBox([
            mui.Markdown("""
# h1 Heading 8-)
## h2 Heading
### h3 Heading
#### h4 Heading
##### h5 Heading
###### h6 Heading

Emphasis, aka italics, with *asterisks* or _underscores_.
Colons can be used to align columns.

| Tables        | Are           | Cool  |
| ------------- |:-------------:| -----:|
| col 3 is      | right-aligned | $1600 |
| col 2 is      | centered      |   $12 |
| zebra stripes | are neat      |    $1 |

            """)
        ])
```

### Features

* latex expression (katex)

```Python
from tensorpc.flow import mui, three, plus, appctx, mark_create_layout
class App:
    @mark_create_layout
    def my_layout(self):
        return mui.VBox([
            mui.Markdown(r"""
* Inline Expression $\sqrt{x^2+y^2}=1$

* Block Expression

$$
\left( \sum_{k=1}^n a_k b_k \right)^2 \leq \left( \sum_{k=1}^n a_k^2 \right) \left( \sum_{k=1}^n b_k^2 \right)
$$
            """).prop(katex=True)
        ])
```

* emoji

```Python
from tensorpc.flow import mui, three, plus, appctx, mark_create_layout
class App:
    @mark_create_layout
    def my_layout(self):
        return mui.VBox([
            mui.Markdown(r"""
:dog: :+1:
            """).prop(emoji=True)
        ])
```

* colored text 

```Python
from tensorpc.flow import mui, three, plus, appctx, mark_create_layout
class App:
    @mark_create_layout
    def my_layout(self):
        return mui.VBox([
            mui.Markdown(r"""
:green[green text]

red expression :+1: :red[$\sqrt{x^2+y^2}=1$]
            """).prop(emoji=True, katex=True)
        ])
```