## Map (leaflet)

[all leaflet providers](https://leaflet-extras.github.io/leaflet-providers/preview/)

```Python
from tensorpc.flow import mui, three, leaflet, appctx, mark_create_layout
class App:
    @mark_create_layout
    def app_create_layout(self):
        esri_url = "https://{s}.tile-cyclosm.openstreetmap.fr/cyclosm/{z}/{x}/{y}.png"
        self.leaflet = leaflet.MapContainer(
            (30, -100), 13, [
                leaflet.TileLayer(esri_url),
            ]).prop(height="100%", flex=3)
        return mui.HBox([
            mui.VBox([
                mui.Button("FlyTo", lambda: self.leaflet.fly_to(
                        (40, -100), zoom=10)),
            ]).prop(minHeight=0, flex=1),
            self.leaflet
        ]).prop(width="100%", height="100%")

```