## Plotly Chart

Plotly is a charting library for Python. It is a wrapper around the JavaScript library plotly.js. It is a very powerful library and can create a wide variety of charts. It is also very easy to use. It is a good choice for creating interactive charts.

### Basic Chart

```Python
from tensorpc.flow import mui, three, plus, appctx, mark_create_layout, plotly
class App:
    @mark_create_layout
    def my_layout(self):
        self.plot = plotly.Plotly().prop(
            data=[
                plotly.Trace(x=[1, 2, 3],
                             y=[2, 7, 3],
                             type="scatter",
                             mode="lines")
            ],
            layout=plotly.Layout(
                # height=240,
                autosize=True,
                margin=plotly.Margin(l=0, r=0, b=0, t=0),
                xaxis=plotly.Axis(automargin=True),
                yaxis=plotly.Axis(automargin=True),
            ))
        return mui.VBox([
            self.plot,
        ]).prop(width=640, height=480)

```

### Chart Event

```Python
from tensorpc.flow import mui, three, plus, appctx, mark_create_layout, plotly
class App:
    @mark_create_layout
    def my_layout(self):
        self.plot = plotly.Plotly().prop(
            data=[
                plotly.Trace(x=[1, 2, 3],
                             y=[2, 7, 3],
                             type="scatter",
                             mode="lines")
            ],
            layout=plotly.Layout(
                # height=240,
                autosize=True,
                margin=plotly.Margin(l=0, r=0, b=0, t=0),
                xaxis=plotly.Axis(automargin=True),
                yaxis=plotly.Axis(automargin=True),
            ))
        self.plot.event_click.on_standard(lambda x: print(x))
        return mui.VBox([
            self.plot,
        ]).prop(width=640, height=480)

```

### Realtime Chart

```Python
from tensorpc.flow import mui, three, plus, appctx, mark_create_layout, plotly, mark_did_mount, mark_will_unmount
import asyncio 
import math 
class App:
    @mark_create_layout
    def my_layout(self):
        self.plot = plotly.Plotly().prop(
            data=[
                plotly.Trace(x=[],
                             y=[],
                             type="scatter",
                             mode="lines")
            ],
            layout=plotly.Layout(
                # height=240,
                autosize=True,
                margin=plotly.Margin(l=0, r=0, b=0, t=0),
                xaxis=plotly.Axis(automargin=True),
                yaxis=plotly.Axis(automargin=True),
            ))
        return mui.VBox([
            self.plot,
        ]).prop(width=640, height=480)

    @mark_did_mount
    async def _on_mount(self):
        self.shutdown_ev = asyncio.Event()

        asyncio.create_task(self._on_update_data(self.shutdown_ev))
        
    @mark_will_unmount
    async def _on_unmount(self):
        self.shutdown_ev.set()

    async def _on_update_data(self, ev: asyncio.Event):
        t = 0.0
        while True:
            await asyncio.sleep(0.05)
            t += 0.05
            y = math.sin(t)
            await self.plot.extend_data([
                plotly.PlotlyTraceDataUpdate(0, dataMaxCount=100, x=[t], y=[y])
            ])
            if ev.is_set():
                break

```