
### DataGrid

```Python
from tensorpc.flow import mui, three, plus, appctx, mark_create_layout
import random
class App:
    class Config(plus.AppInMemory.Config):
        is_horizontal = False
        height = "800px"
    def create_data(self, index: int, name: str, calories: float,
        fat: float,
        carbs: float,
        protein: bool):
        return {
            "id": str(index),
            "name": name,
            "calories": calories,
            "fat": fat,
            "carbs": carbs,
            "protein": protein,
            "nested": [
                {
                    "id": str(i),
                    "iq": random.randint(0, 100),
                } for i in range(random.randint(2, 6))
            ]
        }
    
    
    def create_many_datas(self, count: int):
        for i in range(count):
            yield self.create_data(i, f"n{i}", random.randint(100, 300), random.randint(1, 25), random.randint(22, 44), i % 2 == 0)

    @mark_create_layout
    def my_layout(self):
        rows = list(self.create_many_datas(1000))
        btn = mui.Button("Action").prop(loading=False)
        btn.event_click.on_standard(lambda x: print(x.keys)).configure(True)
        cbox = mui.Checkbox("")
        input_cell = mui.Input("dev")
        fat_cell = mui.Slider(0, 100, 1)

        column_defs = [
            mui.DataGrid.ColumnDef("special", specialType=mui.DataGridColumnSpecialType.MasterDetail),
            mui.DataGrid.ColumnDef("id", accessorKey="id"),
            mui.DataGrid.ColumnDef("name", accessorKey="name", width=120, editCell=input_cell),
            mui.DataGrid.ColumnDef("fat", accessorKey="fat", editCell=fat_cell),
            mui.DataGrid.ColumnDef("protein", accessorKey="protein", align="right", cell=cbox),
            mui.DataGrid.ColumnDef("actions", cell=btn),
        ]
        # nested template component container
        master_detail = mui.VBox([
            mui.Typography("Master Detail").prop(variant="h4"),
            mui.DataGrid([
                # bind column in nested
                mui.DataGrid.ColumnDef("id", accessorKey="id"),
                mui.DataGrid.ColumnDef("iq", accessorKey="iq"),
            ]).prop(idKey="id", rowHover=True, stickyHeader=False, virtualized=False, size="small").set_override_props(dataList="nested")
        ]).prop(width="100%", alignItems="center")
        dgrid = mui.DataGrid(column_defs, rows, master_detail).prop(idKey="id", rowHover=True, virtualized=False)
        dgrid.bind_prop(cbox, "protein")
        dgrid.bind_prop(input_cell, "name")
        dgrid.bind_prop(fat_cell, "fat")

        return mui.VBox([
            dgrid.prop(stickyHeader=False, virtualized=False, size="small"),
        ]).prop(width="100%", height="100%", overflow="auto")


```