### MenuList

we support basic menu list for a flex box.

### Basic Usage

```Python

from tensorpc.flow import mui, three, plus, appctx, mark_create_layout
class App:
    @mark_create_layout
    def my_layout(self):
        items = [
            mui.MenuItem(id="0", label="item 0"),
            mui.MenuItem(id="1", label="item 1"),
            mui.MenuItem(id="2", label="item 2"),
        ]
        return mui.VBox([
            mui.MenuList(items, 
                mui.IconButton(mui.IconType.Add)),
        ])

```

### Event

we only support menu click event.

```Python

from tensorpc.flow import mui, three, plus, appctx, mark_create_layout
class App:
    @mark_create_layout
    def my_layout(self):
        items = [
            mui.MenuItem(id="0", label="item 0"),
            mui.MenuItem(id="1", label="item 1"),
            mui.MenuItem(id="2", label="item 2"),
        ]
        self.md = mui.Markdown()
        return mui.VBox([
            mui.MenuList(items, 
                mui.IconButton(mui.IconType.Add),
                callback=self._on_menu_select),
            self.md,
        ])

    async def _on_menu_select(self, item_id: str):
        await self.md.write(f"you select item `{item_id}`")

```

### Trigger Method

we support enable menu by click or right click (context menu).

```Python

from tensorpc.flow import mui, three, plus, appctx, mark_create_layout
class App:
    @mark_create_layout
    def my_layout(self):
        items = [
            mui.MenuItem(id="0", label="item 0"),
            mui.MenuItem(id="1", label="item 1"),
            mui.MenuItem(id="2", label="item 2"),
        ]
        return mui.VBox([
            mui.Typography("right click (context menu):"),
            mui.MenuList(items, 
            mui.Icon(mui.IconType.Add)).prop(triggerMethod="contextmenu"),
            mui.Typography("left click:"),
            mui.MenuList(items, 
            mui.Icon(mui.IconType.Add)).prop(triggerMethod="click"),

        ])

```

### Divider

due to limitation of mui, divider must be treated as a normal menu item and assign a unique id.

```Python

from tensorpc.flow import mui, three, plus, appctx, mark_create_layout
class App:
    @mark_create_layout
    def my_layout(self):
        items = [
            mui.MenuItem(id="0", label="item 0"),
            mui.MenuItem(id="1", label="item 1"),
            mui.MenuItem(id="2", divider=True),
            mui.MenuItem(id="3", label="item 2"),
        ]
        self.md = mui.Markdown()
        return mui.VBox([
            mui.MenuList(items, 
                mui.IconButton(mui.IconType.Add),
                callback=self._on_menu_select),
            self.md,
        ])

    async def _on_menu_select(self, item_id: str):
        await self.md.write(f"you select item `{item_id}`")

```


### ContextMenu

we support enable menu by click or right click (context menu).

```Python

from tensorpc.flow import mui, three, plus, appctx, mark_create_layout
class App:
    @mark_create_layout
    def my_layout(self):
        items = [
            mui.MenuItem(id="0", label="item 0"),
            mui.MenuItem(id="1", label="item 1"),
            mui.MenuItem(id="2", label="item 2"),
        ]
        return mui.VBox([
            
            mui.MenuList(
                items, 
                mui.Typography("""
Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nullam ipsum purus, bibendum sit amet vulputate eget, porta semper ligula. Donec bibendum vulputate erat, ac fringilla mi finibus nec. Donec ac dolor sed dolor porttitor blandit vel vel purus. Fusce vel malesuada ligula. Nam quis vehicula ante, eu finibus est. Proin ullamcorper fermentum orci, quis finibus massa. Nunc lobortis, massa ut rutrum ultrices, metus metus finibus ex, sit amet facilisis neque enim sed neque. Quisque accumsan metus vel maximus consequat. Suspendisse lacinia tellus a libero volutpat maximus.
                """)
            ).prop(triggerMethod="contextmenu", anchorReference="anchorPosition"),
        ])

```


### Confirm Message

Use confirm message to avoid dangerous operation.

```Python

from tensorpc.flow import mui, three, plus, appctx, mark_create_layout
class App:
    @mark_create_layout
    def my_layout(self):
        items = [
            mui.MenuItem(id="0", label="Launch nuclear missle", confirmTitle="Are You Sure?", confirmMessage="To Do This operation?"),
            mui.MenuItem(id="1", label="item 1"),
        ]
        self.md = mui.Markdown()
        return mui.VBox([
            mui.MenuList(items, 
                mui.IconButton(mui.IconType.Add),
                callback=self._on_menu_select),
            self.md,
        ])

    async def _on_menu_select(self, item_id: str):
        await self.md.write(f"you select item `{item_id}`")

```
