## Progress 

Progress indicators commonly known as spinners, express an unspecified wait time or display the length of a process.

Progress indicators inform users about the status of ongoing processes, such as loading an app, submitting a form, or saving updates.

Determinate indicators display how long an operation will take.
Indeterminate indicators visualize an unspecified wait time.


### Circular Progress

```Python

from tensorpc.flow import mui, three, plus, appctx, mark_create_layout

class App:
    @mark_create_layout
    def my_layout(self):
        return mui.VBox([
            mui.CircularProgress(),
            mui.CircularProgress().prop(muiColor="secondary"),
            mui.CircularProgress().prop(muiColor="success"),
            mui.CircularProgress().prop(muiColor="warning"),
            mui.CircularProgress().prop(muiColor="error"),
        ])


```

### Circular determinate
```Python

from tensorpc.flow import mui, three, plus, appctx, mark_create_layout

class App:
    @mark_create_layout
    def my_layout(self):
        return mui.VBox([
            mui.CircularProgress().prop(value=25, variant="determinate"),
            mui.CircularProgress().prop(value=50, variant="determinate"),
            mui.CircularProgress().prop(value=75, variant="determinate"),
            mui.CircularProgress().prop(value=100, variant="determinate"),
        ])


```

### Circular With Label
```Python

from tensorpc.flow import mui, three, plus, appctx, mark_create_layout

class App:
    @mark_create_layout
    def my_layout(self):
        return mui.VBox([
            mui.CircularProgress().prop(value=25, variant="determinate", withLabel=True),
        ])


```


### Linear Progress

```Python
from tensorpc.flow import mui, three, plus, appctx, mark_create_layout

class App:
    @mark_create_layout
    def my_layout(self):
        return mui.VBox([
            mui.LinearProgress(),
            mui.LinearProgress().prop(muiColor="secondary"),
            mui.LinearProgress().prop(muiColor="success"),
            mui.LinearProgress().prop(muiColor="warning"),
            mui.LinearProgress().prop(muiColor="error"),
        ]).prop(width="100%", height="100%", justifyContent="space-around")


```

### Linear determinate

```Python

from tensorpc.flow import mui, three, plus, appctx, mark_create_layout

class App:
    @mark_create_layout
    def my_layout(self):
        return mui.VBox([
            mui.LinearProgress().prop(value=25, variant="determinate"),
            mui.LinearProgress().prop(value=50, variant="determinate"),
            mui.LinearProgress().prop(value=75, variant="determinate"),
            mui.LinearProgress().prop(value=100, variant="determinate"),
        ]).prop(width="100%", height="100%", justifyContent="space-around")


```


### Linear Buffer

```Python

from tensorpc.flow import mui, three, plus, appctx, mark_create_layout, mark_did_mount, mark_will_unmount
import random
import asyncio 
class App:
    @mark_create_layout
    def my_layout(self):
        prog = mui.LinearProgress().prop(value=25, variant="buffer")
        self.prog = prog

        return mui.VBox([
            prog,
        ]).prop(width="100%", height="100%", justifyContent="space-around")

    @mark_did_mount
    async def _on_mount(self):
        self.shutdown_ev = asyncio.Event()

        asyncio.create_task(self._linear_progress_anime(self.shutdown_ev))
        
    @mark_will_unmount
    async def _on_unmount(self):
        self.shutdown_ev.set()

    async def _linear_progress_anime(self, ev: asyncio.Event):
        prog = self.prog
        prog_value = 0
        while True:
            await asyncio.sleep(0.5)
            diff = random.randint(1, 10)
            diff2 = random.randint(1, 10)
            prog_value += diff 
            buffer_value = prog_value + diff2 + diff
            await prog.send_and_wait(prog.update_event(value=prog_value, valueBuffer=buffer_value))
            if prog_value > 100:
                await prog.send_and_wait(prog.update_event(value=0, valueBuffer=10))
                prog_value = 0

            if ev.is_set():
                break
```

### Linear With Label
```Python

from tensorpc.flow import mui, three, plus, appctx, mark_create_layout

class App:
    @mark_create_layout
    def my_layout(self):
        return mui.VBox([
            mui.LinearProgress().prop(value=25, variant="determinate", withLabel=True),
        ]).prop(width="100%")


```
