## Chip

Chips are compact elements that represent an input, attribute, or action.

### Basic chip


```Python
from tensorpc.flow import mui, three, plus, appctx, mark_create_layout
class App:
    @mark_create_layout
    def my_layout(self):
        return mui.VBox([
            mui.Chip("Chip Filled").prop(variant="filled"),
            mui.Chip("Chip Outlined").prop(variant="outlined"),
        ])

```

### Chip Actions

You can use the following actions.

Chips with the ```clickable=True``` prop defined change appearance on focus, hover, and click.

Chips with the ```deletable=True``` prop defined will display a delete icon which changes appearance on hover.


### Clickable

```Python
from tensorpc.flow import mui, three, plus, appctx, mark_create_layout
class App:
    @mark_create_layout
    def my_layout(self):
        md = mui.Markdown()
        return mui.VBox([
            mui.Chip("Clickable").prop(variant="filled", clickable=True),
            mui.Chip("Clickable", callback=lambda: md.write("chip clicked")).prop(variant="outlined",
            clickable=True),
            md,
        ])

```

### Deletable 

```Python
from tensorpc.flow import mui, three, plus, appctx, mark_create_layout
class App:
    @mark_create_layout
    def my_layout(self):
        md = mui.Markdown()
        return mui.VBox([
            mui.Chip("Deletable").prop(variant="filled", deletable=True),
            mui.Chip("Deletable", callback=lambda: md.write("chip deleted")).prop(variant="outlined",
            deletable=True),
            md,
        ])

```

### Custom Delete Icon

**Note**: due to limitation of mui Chip, we only support pre-defined icon here, svg icon isn't supported.

```Python
from tensorpc.flow import mui, three, plus, appctx, mark_create_layout

class App:
    @mark_create_layout
    def my_layout(self):
        md = mui.Markdown()
        return mui.VBox([
            mui.Chip("Deletable").prop(deletable=True, deleteIcon=mui.IconType.Done),
            mui.Chip("Deletable").prop(
            deletable=True, deleteIcon=mui.IconType.Delete),
            md,

        ])

```

### Color chip


```Python
from tensorpc.flow import mui, three, plus, appctx, mark_create_layout

class App:
    @mark_create_layout
    def my_layout(self):
        return mui.VBox([
            mui.Chip("primary").prop(muiColor="primary"),
            mui.Chip("success").prop(muiColor="success"),
        ])

```

### Sizes chip


```Python
from tensorpc.flow import mui, three, plus, appctx, mark_create_layout

class App:
    @mark_create_layout
    def my_layout(self):
        return mui.VBox([
            mui.Chip("primary").prop(size="small"),
            mui.Chip("success").prop(size="medium"),
        ])

```
