## Collapse 

### Basic Usage 

```Python
from tensorpc.flow import mui, three, plus, appctx, mark_create_layout
class App:
    @mark_create_layout
    def my_layout(self):
        collapse = mui.Collapse([
            mui.Markdown("## Hello Collapse!")
        ]).prop(border="1px solid red")
        callback = lambda x: collapse.send_and_wait(collapse.update_event(triggered=x))
        return mui.VBox([
            mui.ToggleButton("Open", callback=callback).prop(alignSelf="center"),
            collapse,
        ]).prop(height="100%", width="100%")


```

### Horizontal Collapse 

```Python
from tensorpc.flow import mui, three, plus, appctx, mark_create_layout
class App:
    @mark_create_layout
    def my_layout(self):
        collapse = mui.Collapse([
            mui.Markdown("## Hello Collapse!")
        ]).prop(orientation="horizontal", border="1px solid red")
        callback = lambda x: collapse.send_and_wait(collapse.update_event(triggered=x))
        return mui.HBox([
            mui.ToggleButton("Open", callback=callback).prop(alignSelf="center"),
            collapse,
        ]).prop(height="100%", width="100%")


```

### Absolute Collapse 

```Python

from tensorpc.flow import mui, three, plus, appctx, mark_create_layout
class App:
    @mark_create_layout
    def my_layout(self):
        collapse_bottom = mui.Collapse([
            mui.Markdown("## Hello Collapse!")
        ]).prop(position="absolute", bottom=0, left=0, border="1px solid red")
        collapse_right = mui.Collapse([
            mui.Markdown("## Hello Collapse!")
        ]).prop(position="absolute", top=0, right=0, border="1px solid red", orientation="horizontal")

        callback_bottom = lambda x: collapse_bottom.send_and_wait(collapse_bottom.update_event(triggered=x))
        callback_right = lambda x: collapse_right.send_and_wait(collapse_right.update_event(triggered=x))

        return mui.VBox([
            mui.HBox([
                mui.ToggleButton("Bottom", callback=callback_bottom),
                mui.ToggleButton("Right", callback=callback_right),
            ]).prop(alignSelf="center"),

            collapse_bottom,
            collapse_right,
        ]).prop(height="100%", width="100%", justifyContent="center", position="relative")


```

### Disable Animation

```Python
from tensorpc.flow import mui, three, plus, appctx, mark_create_layout
class App:
    @mark_create_layout
    def my_layout(self):
        collapse = mui.Collapse([
            mui.Markdown("## Hello Collapse!")
        ]).prop(border="1px solid red", timeout=0)
        callback = lambda x: collapse.send_and_wait(collapse.update_event(triggered=x))
        return mui.VBox([
            mui.ToggleButton("Open", callback=callback).prop(alignSelf="center"),
            collapse,
        ]).prop(height="100%", width="100%")
```


```Python
from tensorpc.flow import mui, three, plus, appctx, mark_create_layout
class App:
    @mark_create_layout
    def my_layout(self):
        collapse_bottom = mui.Collapse([
            mui.Markdown("## Hello Collapse!")
        ]).prop(position="absolute", bottom=0, left=0, border="1px solid red", timeout=0)
        collapse_right = mui.Collapse([
            mui.Markdown("## Hello Collapse!")
        ]).prop(position="absolute", top=0, right=0, border="1px solid red", orientation="horizontal", timeout=0)

        callback_bottom = lambda x: collapse_bottom.send_and_wait(collapse_bottom.update_event(triggered=x))
        callback_right = lambda x: collapse_right.send_and_wait(collapse_right.update_event(triggered=x))

        return mui.VBox([
            mui.HBox([
                mui.ToggleButton("Bottom", callback=callback_bottom),
                mui.ToggleButton("Right", callback=callback_right),
            ]).prop(alignSelf="center"),

            collapse_bottom,
            collapse_right,
        ]).prop(height="100%", width="100%", justifyContent="center", position="relative")

```
