## Dialog

Dialog  in devflow is simplified. It only contains a title and a content. The content can be any component.

### Basic Usage

```Python

from tensorpc.flow import mui, three, plus, appctx, mark_create_layout

class App:
    @mark_create_layout
    def my_layout(self):
        dialog = mui.Dialog([
            mui.Markdown("## Hello Dialog!")
        ]).prop(title="Dialog Title")
        return mui.VBox([
            dialog,
            mui.Button("Trigger Dialog", lambda: dialog.send_and_wait(dialog.update_event(open=True))),
        ])


```

### Dialog Event

Dialog have a event which trigger when dialog is closed. The python definition of the event is shown below.

```
@dataclass
class DragEvent:
    ok: bool
    userData: Any = None
```

Dialog have a event which trigger when dialog is closed. If you click ```Save``` button, the parameter `ok` of that event will be ```True```, otherwise it will be ```False```.


```Python

from tensorpc.flow import mui, three, plus, appctx, mark_create_layout

class App:
    @mark_create_layout
    def my_layout(self):
        md = mui.Markdown()
        dialog = mui.Dialog([
            mui.Markdown("## Hello Dialog!")
        ], callback=lambda x: md.write(f"Dialog Event Param :green[{x}]")).prop(title="Dialog Title")
        return mui.VBox([
            dialog,
            mui.Button("Trigger Dialog", lambda: dialog.send_and_wait(dialog.update_event(open=True))),
            md,
        ]).prop(width="100%")

```
