## Drawer 

Due to limitation of devflow app, we only support temporary drawer.

### Temporary drawer

Temporary navigation drawers can toggle open or closed. Closed by default, the drawer opens temporarily above all other content until a section is selected.

The Drawer can be cancelled by clicking the overlay or pressing the Esc key. It closes when an item is selected, handled by controlling the open prop.

**WARNING**: since the app is inside a dialog when fullscreen, the drawer's zindex must be higher than the dialog's. another problem is the "resize bar" of devflow use zIndex 100, so the app's zIndex must be higher than 100. this line is only valid for top-level app, the app in tutorial are actually child component of top-level.

```Python
from typing import List 
from typing_extensions import Literal
from tensorpc.flow import mui, three, plus, appctx, mark_create_layout
class App:
    @mark_create_layout
    def my_layout(self):
        layout: List[mui.Drawer] = []
        # currently the app is inside a dialog when fullscreen,
        # so we must ensure the drawer's zindex is higher than the dialog's
        # this line is only valid for top-level app, the app in tutorial are actually child component of top-level.
        # appctx.set_app_z_index(200)
        anchors: List[Literal["left", "right", "top", "bottom"]] = ["left", "right", "top", "bottom"]
        for anchor in anchors:
            layout.append(mui.Drawer([
                mui.Typography("Drawer").prop(variant="h6"),
            ]).prop(anchor=anchor, zIndex=201))
        return mui.HBox([*layout,
            mui.Button("Left", callback=lambda: layout[0].send_and_wait(layout[0].update_event(open=True))),
            mui.Button("Right", callback=lambda: layout[1].send_and_wait(layout[1].update_event(open=True))),
            mui.Button("Top", callback=lambda: layout[2].send_and_wait(layout[2].update_event(open=True))),
            mui.Button("Bottom", callback=lambda: layout[3].send_and_wait(layout[3].update_event(open=True))),
        ]).prop(width="100%")

```
