## Slider 

Sliders allow users to make selections from a range of values.


### Basic Slider

```Python
from tensorpc.flow import mui, three, plus, appctx, mark_create_layout
class App:
    @mark_create_layout
    def my_layout(self):
        return mui.VBox([
            # begin, end, step
            mui.Slider(0, 100, 1),
            mui.Slider(0, 0),
            mui.Slider(0, 100, 1).prop(size="small"),
        ]).prop(width="100%")

```

### Range Slider


```Python
from tensorpc.flow import mui, three, plus, appctx, mark_create_layout
class App:
    @mark_create_layout
    def my_layout(self):
        md = mui.Markdown()
        return mui.VBox([
            # begin, end, step
            mui.RangeSlider(0, 100, 1, init_value=(20, 30), callback=lambda x: md.write(f"RangeSlider: :green[{x}]")),
            md,
        ]).prop(width="100%")

```

### Vertical Slider


```Python
from tensorpc.flow import mui, three, plus, appctx, mark_create_layout
class App:
    @mark_create_layout
    def my_layout(self):
        return mui.VBox([
            # begin, end, step
            mui.Slider(0, 100, 1).prop(vertical=True, flex=1),
        ]).prop(height="100%")

```

### Slider with text input

Double click the text to edit the value.

```Python
from tensorpc.flow import mui, three, plus, appctx, mark_create_layout
class App:
    @mark_create_layout
    def my_layout(self):
        return mui.VBox([
            # begin, end, step
            mui.Slider(0, 100, 1).prop(valueInput=True),
        ]).prop(width="100%")

```
