## Containers 

Containers in devflow is a special component base class that can contain other components, such as ```mui.FlexBox```. Most of containers use simple child (dict of components) to manage childs. some special components use ```dataclass``` to manage complex childs.

### Update Container Childs

there are several methods to update container childs:

* ```set_new_layout```: set a new layout to container. the new layout will replace the old one. the new layout can be a list of components or a dict of components.

* ```update_childs```: update the layout of container. the new layout will be merged with the old one. the new layout can be a list of components or a dict of components.

* ```remove_childs_by_keys```: remove childs by keys.

```Python
from tensorpc.flow import mui, three, plus, appctx, mark_create_layout

class App:
    @mark_create_layout
    def my_layout(self):
        self.flex_items = mui.FlexBox({
            "0": mui.Typography("Item 1").prop(border="1px solid red"),
        }).prop(flexDirection="row")
        return mui.VBox([
            mui.Button("Set New Layout", self._on_set_new_layout),
            mui.Button("Update Childs 0", self._on_update_childs),
            mui.Button("Remove Child 0", self._on_remove_childs),
            self.flex_items.prop(flex=1),
        ]).prop(flex=1)

    async def _on_set_new_layout(self):
        await self.flex_items.set_new_layout({
            "0": mui.Typography("Item 1").prop(border="1px solid red"),
        })

    async def _on_update_childs(self):
        if "0" in self.flex_items:
            await self.flex_items.update_childs({
                "0": mui.Typography("Item 1").prop(border="1px solid blue"),
            })

    async def _on_remove_childs(self):
        if "0" in self.flex_items:
            await self.flex_items.remove_childs_by_keys(["0"])

```