## Inheritance

devflow is class-based, so we support inheritance naturally. You can define the layout function in a base class, then define overrideable callbacks in the derived class.

the only problem is reload system. To make everything simple, we won't support new/delete method of all base classes, only leaf class can new/delete special methods or callbacks.


```Python

from tensorpc.flow import mui, three, plus, appctx, mark_create_layout
class Base:
    @mark_create_layout
    def my_layout(self):
        self.md = mui.Markdown()
        return mui.VBox([
            mui.Typography("Hello Inheritance"),
            mui.Button("Click", self._on_click),
            self.md
        ])

    async def _on_click(self):
        await self.md.write("Click Base")

class App(Base):
    async def _on_click(self):
        await self.md.write("Click Child")

```

Modify layout function in ```Base``` and ```_on_click``` in child to see reload system.