"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Table = exports.TableProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const maxcompute_generated_1 = require("./maxcompute.generated");
Object.defineProperty(exports, "TableProperty", { enumerable: true, get: function () { return maxcompute_generated_1.RosTable; } });
/**
 * A ROS resource type:  `ALIYUN::MaxCompute::Table`
 */
class Table extends ros.Resource {
    /**
     * Create a new `ALIYUN::MaxCompute::Table`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosTable = new maxcompute_generated_1.RosTable(this, id, {
            comment: props.comment,
            project: props.project,
            ifNotExists: props.ifNotExists,
            lifecycle: props.lifecycle,
            schema: props.schema,
            stringSchema: props.stringSchema,
            name: props.name,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosTable;
        this.attrName = rosTable.attrName;
        this.attrProject = rosTable.attrProject;
    }
}
exports.Table = Table;
//# sourceMappingURL=data:application/json;base64,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