# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: onos/uenib/ran.proto, onos/uenib/uenib.proto
# plugin: python-betterproto
from dataclasses import dataclass
from typing import AsyncIterator, Dict, List

import betterproto
import grpclib


class EventType(betterproto.Enum):
    NONE = 0
    ADDED = 1
    UPDATED = 2
    REMOVED = 3


@dataclass(eq=False, repr=False)
class CellConnection(betterproto.Message):
    """CellConnection represents UE cell connection."""

    id: str = betterproto.string_field(1)
    signal_strength: float = betterproto.double_field(2)

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class CellInfo(betterproto.Message):
    """CellInfo provides data on serving cell and candidate cells."""

    serving_cell: "CellConnection" = betterproto.message_field(1)
    candidate_cells: List["CellConnection"] = betterproto.message_field(2)

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class Event(betterproto.Message):
    """CellConnection represents UE cell connection."""

    type: "EventType" = betterproto.enum_field(1)
    ue: "Ue" = betterproto.message_field(2)

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class CreateUeRequest(betterproto.Message):
    """CellInfo provides data on serving cell and candidate cells."""

    ue: "Ue" = betterproto.message_field(1)

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class CreateUeResponse(betterproto.Message):
    pass

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class GetUeRequest(betterproto.Message):
    id: str = betterproto.string_field(1)
    aspect_types: List[str] = betterproto.string_field(2)

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class GetUeResponse(betterproto.Message):
    ue: "Ue" = betterproto.message_field(1)

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class UpdateUeRequest(betterproto.Message):
    ue: "Ue" = betterproto.message_field(1)

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class UpdateUeResponse(betterproto.Message):
    pass

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class DeleteUeRequest(betterproto.Message):
    id: str = betterproto.string_field(1)
    aspect_types: List[str] = betterproto.string_field(2)

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class DeleteUeResponse(betterproto.Message):
    pass

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class ListUeRequest(betterproto.Message):
    aspect_types: List[str] = betterproto.string_field(1)

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class ListUeResponse(betterproto.Message):
    ue: "Ue" = betterproto.message_field(1)

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class WatchUeRequest(betterproto.Message):
    noreplay: bool = betterproto.bool_field(2)
    aspect_types: List[str] = betterproto.string_field(3)

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class WatchUeResponse(betterproto.Message):
    event: "Event" = betterproto.message_field(1)

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class Ue(betterproto.Message):
    id: str = betterproto.string_field(1)
    aspects: Dict[str, "betterproto_lib_google_protobuf.Any"] = betterproto.map_field(
        2, betterproto.TYPE_STRING, betterproto.TYPE_MESSAGE
    )

    def __post_init__(self) -> None:
        super().__post_init__()


class UeServiceStub(betterproto.ServiceStub):
    async def create_ue(self) -> "CreateUeResponse":

        request = CreateUeRequest()

        return await self._unary_unary(
            "/onos.uenib.UEService/CreateUE", request, CreateUeResponse
        )

    async def get_ue(self) -> "GetUeResponse":

        request = GetUeRequest()

        return await self._unary_unary(
            "/onos.uenib.UEService/GetUE", request, GetUeResponse
        )

    async def update_ue(self) -> "UpdateUeResponse":

        request = UpdateUeRequest()

        return await self._unary_unary(
            "/onos.uenib.UEService/UpdateUE", request, UpdateUeResponse
        )

    async def delete_ue(self) -> "DeleteUeResponse":

        request = DeleteUeRequest()

        return await self._unary_unary(
            "/onos.uenib.UEService/DeleteUE", request, DeleteUeResponse
        )

    async def list_u_es(self) -> AsyncIterator["ListUeResponse"]:

        request = ListUeRequest()

        async for response in self._unary_stream(
            "/onos.uenib.UEService/ListUEs",
            request,
            ListUeResponse,
        ):
            yield response

    async def watch_u_es(self) -> AsyncIterator["WatchUeResponse"]:

        request = WatchUeRequest()

        async for response in self._unary_stream(
            "/onos.uenib.UEService/WatchUEs",
            request,
            WatchUeResponse,
        ):
            yield response


import betterproto.lib.google.protobuf as betterproto_lib_google_protobuf
