try:
    from icecream import ic

    ic.configureOutput(includeContext=True)
except ImportError:  # Graceful fallback if IceCream isn't installed.
    ic = lambda *a: None if not a else (a[0] if len(a) == 1 else a)  # noqa

# unary branch composite-label frequencies from 12260086 sentences, from cfg parser
"""
  39937 ADVP-ADVP>ADVP-ADVP_DUR_TIME>NP-NP
   2421 CP-CP_QUOTE>IP-IP>VP-VP
   3274 CP-CP_SOURCE>CP-CP_REL>IP-IP
   4175 IP-IP_INF>CP-CP_QUE>ADVP-ADVP
  10389 IP-IP_INF>CP-CP_QUE>NP-NP
   2004 IP-IP_INF>CP-CP_QUE>PP-PP
 163062 IP-IP>S-S_MAIN>IP-IP
  23142 IP-IP>S-S_MAIN>IP-IP>VP-VP
 988879 IP-IP>S-S_MAIN>VP-VP
8231270 S0-S0>S-S_HEADING>NP-NP
  14094 S0-S0>S-S_HEADING>NP-NP_ADDR
   2271 S0-S0>S-S_HEADING>NP-NP_COMPANY
  26931 S0-S0>S-S_HEADING>NP-NP_MEASURE
  79293 S0-S0>S-S_HEADING>S-S_MAIN
 173059 S0-S0>S-S_HEADING>S-S_MAIN>VP-VP
 979316 S0-S0>S-S_MAIN>IP-IP
  22645 S0-S0>S-S_MAIN>IP-IP_INF
 804731 S0-S0>S-S_MAIN>IP-IP>VP-VP
 689193 S-S_MAIN>IP-IP>VP-VP
"""
NUM_SAMPLES = 12260086
UNARY_BRANCH_FREQUENCIES = {
    "ADVP-ADVP>ADVP-ADVP_DUR_TIME>NP-NP": 39937,
    "CP-CP_QUOTE>IP-IP>VP-VP": 2421,
    "CP-CP_SOURCE>CP-CP_REL>IP-IP": 3274,
    "IP-IP_INF>CP-CP_QUE>ADVP-ADVP": 4175,
    "IP-IP_INF>CP-CP_QUE>NP-NP": 10389,
    "IP-IP_INF>CP-CP_QUE>PP-PP": 2004,
    "IP-IP>S-S_MAIN>IP-IP": 163062,
    "IP-IP>S-S_MAIN>IP-IP>VP-VP": 23142,
    "IP-IP>S-S_MAIN>VP-VP": 988879,
    "S0-S0>S-S_HEADING>NP-NP": 8231270,
    "S0-S0>S-S_HEADING>NP-NP_ADDR": 14094,
    "S0-S0>S-S_HEADING>NP-NP_COMPANY": 2271,
    "S0-S0>S-S_HEADING>NP-NP_MEASURE": 26931,
    "S0-S0>S-S_HEADING>S-S_MAIN": 79293,
    "S0-S0>S-S_HEADING>S-S_MAIN>VP-VP": 173059,
    "S0-S0>S-S_MAIN>IP-IP": 979316,
    "S0-S0>S-S_MAIN>IP-IP_INF": 22645,
    "S0-S0>S-S_MAIN>IP-IP>VP-VP": 804731,
    "S-S_MAIN>IP-IP>VP-VP": 689193,
}


# unary branch composite-label frequencies from gold test set
"""
      2 CP-CP_ADV_CMP>IP-IP>NP-NP
      7 CP-CP_ADV_COND>IP-IP>VP-VP
      3 IP-IP>S-S_MAIN>VP-VP
      4 NP-NP>CP-CP_QUE>IP-IP
      7 NP-NP_OBJ>CP-CP_QUE>IP-IP
      3 NP-NP_OBJ>CP-CP_THT>IP-IP
      2 NP-NP_OBJ>IP-IP_INF>VP-VP
      9 NP-NP_SUBJ>CP-CP_QUE>IP-IP
      1 NP-NP_SUBJ>CP-CP_QUE>IP-IP>VP-VP
      1 NP-NP_SUBJ>IP-IP_INF>VP-VP
      1 NP-NP_SUBJ>NP-NP_PRD>NP-NP_TITLE
     37 S0-S0>S-S_HEADING>IP-IP
      1 S0-S0>S-S_HEADING>IP-IP_INF
     12 S0-S0>S-S_HEADING>IP-IP>NP-NP
      3 S0-S0>S-S_HEADING>IP-IP>NP-NP_SUBJ
      1 S0-S0>S-S_HEADING>IP-IP>PP-PP
     16 S0-S0>S-S_HEADING>IP-IP>VP-VP
      1 S0-S0>S-S_HEADING>NP-NP_SUBJ
      1 S0-S0>S-S_HEADING>S-S_MAIN
     30 S0-S0>S-S_MAIN>IP-IP
      6 S0-S0>S-S_MAIN>IP-IP>VP-VP
      1 S0-S0>S-S_MAIN>S-S_QUE
      6 S0-S0>S-S_QUE>IP-IP
      2 S0-S0_X>S-S_HEADING>IP-IP
      2 S0-S0_X>S-S_MAIN>IP-IP
      1 S-S_HEADING>IP-IP>ADVP-ADVP
      3 S-S_HEADING>IP-IP>NP-NP
      2 S-S_HEADING>IP-IP>NP-NP_SUBJ
      4 S-S_HEADING>IP-IP>VP-VP
      1 S-S_MAIN>IP-IP>CP-CP_ADV_ACK
      1 S-S_MAIN>IP-IP_INF>VP-VP
      1 S-S_MAIN>IP-IP>NP-NP
      1 S-S_MAIN>IP-IP>NP-NP_PRD>VP-VP
      5 S-S_MAIN>IP-IP>NP-NP_SUBJ
    194 S-S_MAIN>IP-IP>VP-VP
      1 S-S_MAIN>IP-IP>VP-VP>VP-VP
      3 S-S_PREFIX>IP-IP>C-C
      1 S-S_PREFIX>IP-IP>NP-NP
      1 S-S_PREFIX>IP-IP>NP-NP_SUBJ
      1 S-S_PREFIX>IP-IP>PP-PP
     13 S-S_QUE>IP-IP>VP-VP
      1 S-S_QUOTE>IP-IP>CP-CP_ADV_CONS
      2 S-S_QUOTE>IP-IP>CP-CP_QUOTE>IP-IP
      1 S-S_QUOTE>IP-IP>CP-CP_QUOTE>IP-IP>NP-NP_SUBJ
      5 S-S_QUOTE>IP-IP>VP-VP
"""

UNARY_BRANCH_FREQUENCIES_GLD = {
    "CP-CP_ADV_CMP>IP-IP>NP-NP": 2,
    "CP-CP_ADV_COND>IP-IP>VP-VP": 7,
    "IP-IP>S-S_MAIN>VP-VP": 3,
    "NP-NP>CP-CP_QUE>IP-IP": 4,
    "NP-NP_OBJ>CP-CP_QUE>IP-IP": 7,
    "NP-NP_OBJ>CP-CP_THT>IP-IP": 3,
    "NP-NP_OBJ>IP-IP_INF>VP-VP": 2,
    "NP-NP_SUBJ>CP-CP_QUE>IP-IP": 9,
    "NP-NP_SUBJ>CP-CP_QUE>IP-IP>VP-VP": 1,
    "NP-NP_SUBJ>IP-IP_INF>VP-VP": 1,
    "NP-NP_SUBJ>NP-NP_PRD>NP-NP_TITLE": 1,
    "S0-S0>S-S_HEADING>IP-IP": 37,
    "S0-S0>S-S_HEADING>IP-IP_INF": 1,
    "S0-S0>S-S_HEADING>IP-IP>NP-NP": 12,
    "S0-S0>S-S_HEADING>IP-IP>NP-NP_SUBJ": 3,
    "S0-S0>S-S_HEADING>IP-IP>PP-PP": 1,
    "S0-S0>S-S_HEADING>IP-IP>VP-VP": 16,
    "S0-S0>S-S_HEADING>NP-NP_SUBJ": 1,
    "S0-S0>S-S_HEADING>S-S_MAIN": 1,
    "S0-S0>S-S_MAIN>IP-IP": 30,
    "S0-S0>S-S_MAIN>IP-IP>VP-VP": 6,
    "S0-S0>S-S_MAIN>S-S_QUE": 1,
    "S0-S0>S-S_QUE>IP-IP": 6,
    "S0-S0_X>S-S_HEADING>IP-IP": 2,
    "S0-S0_X>S-S_MAIN>IP-IP": 2,
    "S-S_HEADING>IP-IP>ADVP-ADVP": 1,
    "S-S_HEADING>IP-IP>NP-NP": 3,
    "S-S_HEADING>IP-IP>NP-NP_SUBJ": 2,
    "S-S_HEADING>IP-IP>VP-VP": 4,
    "S-S_MAIN>IP-IP>CP-CP_ADV_ACK": 1,
    "S-S_MAIN>IP-IP_INF>VP-VP": 1,
    "S-S_MAIN>IP-IP>NP-NP": 1,
    "S-S_MAIN>IP-IP>NP-NP_PRD>VP-VP": 1,
    "S-S_MAIN>IP-IP>NP-NP_SUBJ": 5,
    "S-S_MAIN>IP-IP>VP-VP": 194,
    "S-S_MAIN>IP-IP>VP-VP>VP-VP": 1,
    "S-S_PREFIX>IP-IP>C-C": 3,
    "S-S_PREFIX>IP-IP>NP-NP": 1,
    "S-S_PREFIX>IP-IP>NP-NP_SUBJ": 1,
    "S-S_PREFIX>IP-IP>PP-PP": 1,
    "S-S_QUE>IP-IP>VP-VP": 13,
    "S-S_QUOTE>IP-IP>CP-CP_ADV_CONS": 1,
    "S-S_QUOTE>IP-IP>CP-CP_QUOTE>IP-IP": 2,
    "S-S_QUOTE>IP-IP>CP-CP_QUOTE>IP-IP>NP-NP_SUBJ": 1,
    "S-S_QUOTE>IP-IP>VP-VP": 5,
}

UNARY_BRANCH_FREQUENCIES_NEW = {
    "ADVP-ADVP>ADVP-ADVP_DUR_ABS": 728,
    "ADVP-ADVP>ADVP-ADVP_DUR_TIME": 699,
    "ADVP-ADVP>ADVP-ADVP_DUR_TIME>NP-NP": 1124,
    "ADVP-ADVP_DATE_REL>P-P": 2,
    "ADVP-ADVP_DATE_REL>PP-PP": 8,
    "ADVP-ADVP_DUR_ABS>NP-NP": 1,
    "ADVP-ADVP_DUR_REL>NP-NP": 1,
    "ADVP-ADVP_DUR_REL>PP-PP": 5,
    "ADVP-ADVP_DUR_TIME>NP-NP": 248,
    "ADVP-ADVP_DUR_TIME>PP-PP": 2,
    "ADVP-ADVP>IP-IP_INF": 1,
    "ADVP-ADVP>P-P": 10,
    "ADVP-ADVP_TIMESTAMP_ABS>PP-PP": 1,
    "ADVP-ADVP_TIMESTAMP_REL>NP-NP": 1,
    "ADVP-ADVP_TIMESTAMP_REL>PP-PP": 8,
    "ADVP-ADVP_TMP_SET>NP-NP": 1,
    "ADVP-ADVP_TMP_SET>PP-PP": 1,
    "ADVP-ADVP>VP-VP": 2,
    "C-C>P-P": 298,
    "CP-CP_ADV_CMP>IP-IP": 5,
    "CP-CP_ADV_CMP>IP-IP>NP-NP": 2,
    "CP-CP_ADV_CMP>NP-NP": 1,
    "CP-CP_ADV_CMP>VP-VP": 1,
    "CP-CP_ADV_COND>IP-IP": 2,
    "CP-CP_ADV_COND>IP-IP>VP-VP": 7,
    "CP-CP_ADV_COND>VP-VP": 5765,
    "CP-CP_EXPLAIN>IP-IP": 3,
    "CP-CP>IP-IP": 1,
    "CP-CP_QUE>ADVP-ADVP": 350,
    "CP-CP_QUE>IP-IP": 14,
    "CP-CP_QUE>NP-NP": 705,
    "CP-CP_QUE>PP-PP": 297,
    "CP-CP_QUOTE>IP-IP": 4660,
    "CP-CP_QUOTE>IP-IP_INF": 230,
    "CP-CP_QUOTE>IP-IP>VP-VP": 81,
    "CP-CP_REL>IP-IP": 92,
    "CP-CP_REL>VP-VP": 1,
    "CP-CP_SOURCE>CP-CP_REL": 141,
    "CP-CP_SOURCE>CP-CP_REL>IP-IP": 77,
    "CP-CP_SOURCE>IP-IP": 2,
    "CP-CP_SOURCE>PP-PP": 161,
    "CP-CP_SOURCE>VP-VP": 1,
    "IP-IP>ADVP-ADVP": 1,
    "IP-IP>CP-CP_QUE": 1,
    "IP-IP_INF>CP-CP_QUE": 1758,
    "IP-IP_INF>CP-CP_QUE>ADVP-ADVP": 52,
    "IP-IP_INF>CP-CP_QUE>NP-NP": 286,
    "IP-IP_INF>CP-CP_QUE>PP-PP": 30,
    "IP-IP_INF>VP-VP": 79,
    "IP-IP>IP-IP_INF": 2052,
    "IP-IP>NP-NP": 2,
    "IP-IP>NP-NP_AGE": 1,
    "IP-IP>NP-NP_PRD": 1,
    "IP-IP>NP-NP_SUBJ": 8,
    "IP-IP>S-S_MAIN": 35340,
    "IP-IP>S-S_MAIN>IP-IP": 4246,
    "IP-IP>S-S_MAIN>IP-IP>VP-VP": 574,
    "IP-IP>S-S_MAIN>VP-VP": 26034,
    "IP-IP>VP-VP": 15829,
    "NP-NP_COMPANY>NP-NP_POSS": 1,
    "NP-NP>CP-CP_QUE": 4,
    "NP-NP>CP-CP_QUE>IP-IP": 4,
    "NP-NP>CP-CP_THT": 2,
    "NP-NP>FOREIGN-FOREIGN": 2,
    "NP-NP_IOBJ>CP-CP_QUE": 1,
    "NP-NP_IOBJ>CP-CP_THT": 2174,
    "NP-NP_IOBJ>IP-IP_INF": 2,
    "NP-NP_IOBJ>VP-VP": 2,
    "NP-NP>IP-IP_INF": 1,
    "NP-NP>NP-NP_COMPANY": 3,
    "NP-NP>NP-NP_MEASURE": 1,
    "NP-NP>NP-NP_PERSON": 5,
    "NP-NP>NP-NP_POSS": 1,
    "NP-NP_OBJ>CP-CP": 2,
    "NP-NP_OBJ>CP-CP_QUE": 12,
    "NP-NP_OBJ>CP-CP_QUE>IP-IP": 7,
    "NP-NP_OBJ>CP-CP_THT": 14434,
    "NP-NP_OBJ>CP-CP_THT>IP-IP": 3,
    "NP-NP_OBJ>IP-IP": 2,
    "NP-NP_OBJ>IP-IP_INF": 18,
    "NP-NP_OBJ>IP-IP_INF>VP-VP": 2,
    "NP-NP_OBJ>NP-NP": 1,
    "NP-NP_OBJ>NP-NP_ADDR": 8,
    "NP-NP_OBJ>NP-NP_COMPANY": 7,
    "NP-NP_OBJ>NP-NP_MEASURE": 74,
    "NP-NP_OBJ>VP-VP": 1,
    "NP-NP_POSS>NP-NP": 1,
    "NP-NP_POSS>NP-NP_ADDR": 16,
    "NP-NP_POSS>NP-NP_COMPANY": 133,
    "NP-NP_POSS>NP-NP_MEASURE": 1223,
    "NP-NP_POSS>NP-NP_PERSON": 4,
    "NP-NP>PP-PP": 2,
    "NP-NP_PRD>ADVP-ADVP": 1,
    "NP-NP_PRD>ADVP-ADVP_LOC": 1,
    "NP-NP_PRD>ADVP-ADVP_TIMESTAMP_REL": 1,
    "NP-NP_PRD>CP-CP_ADV_CMP": 3,
    "NP-NP_PRD>CP-CP_QUE": 1,
    "NP-NP_PRD>CP-CP_THT": 1700,
    "NP-NP_PRD>FOREIGN-FOREIGN": 1,
    "NP-NP_PRD>IP-IP": 1,
    "NP-NP_PRD>IP-IP_INF": 4,
    "NP-NP_PRD>NP-NP_ADDR": 2,
    "NP-NP_PRD>NP-NP_AGE": 561,
    "NP-NP_PRD>NP-NP_COMPANY": 4,
    "NP-NP_PRD>NP-NP_MEASURE": 45,
    "NP-NP_PRD>PP-PP": 15,
    "NP-NP_PRD>PP-PP_LOC": 1,
    "NP-NP_PRD>VP-VP": 27486,
    "NP-NP_PREFIX>NP-NP_COMPANY": 7,
    "NP-NP_SOURCE>NP-NP": 3899,
    "NP-NP_SOURCE>NP-NP_PERSON": 1,
    "NP-NP_SUBJ>CP-CP": 1,
    "NP-NP_SUBJ>CP-CP_QUE": 4,
    "NP-NP_SUBJ>CP-CP_QUE>IP-IP": 9,
    "NP-NP_SUBJ>CP-CP_QUE>IP-IP>VP-VP": 1,
    "NP-NP_SUBJ>CP-CP_THT": 3157,
    "NP-NP_SUBJ>IP-IP_INF": 49,
    "NP-NP_SUBJ>IP-IP_INF>VP-VP": 1,
    "NP-NP_SUBJ>NP-NP_ADDR": 6,
    "NP-NP_SUBJ>NP-NP_COMPANY": 42,
    "NP-NP_SUBJ>NP-NP_MEASURE": 40,
    "NP-NP_SUBJ>NP-NP_PERSON": 17,
    "NP-NP_SUBJ>NP-NP_PRD>NP-NP_TITLE": 1,
    "NP-NP_SUBJ>NP-NP_SOURCE": 2,
    "NP-NP_SUBJ>NP-NP_TITLE": 2,
    "NP-NP_SUBJ>VP-VP": 7,
    "NP-NP_TITLE>FOREIGN-FOREIGN": 1,
    "NP-NP_TITLE>NP-NP_PERSON": 2,
    "NP-NP>VP-VP": 2,
    "PP-PP>ADVP-ADVP_DATE_REL": 1,
    "PP-PP>ADVP-ADVP_DUR_REL": 1,
    "PP-PP>CP-CP_ADV_CAUSE": 1,
    "PP-PP_DIR>P-P": 1,
    "PP-PP>P-P": 3,
    "PP-PP>PP-PP": 2,
    "S0-S0>S-S_HEADING": 20941,
    "S0-S0>S-S_HEADING>IP-IP": 37,
    "S0-S0>S-S_HEADING>IP-IP_INF": 1,
    "S0-S0>S-S_HEADING>IP-IP>NP-NP": 12,
    "S0-S0>S-S_HEADING>IP-IP>NP-NP_SUBJ": 3,
    "S0-S0>S-S_HEADING>IP-IP>PP-PP": 1,
    "S0-S0>S-S_HEADING>IP-IP>VP-VP": 16,
    "S0-S0>S-S_HEADING>NP-NP": 31349,
    "S0-S0>S-S_HEADING>NP-NP_ADDR": 50,
    "S0-S0>S-S_HEADING>NP-NP_SUBJ": 1,
    "S0-S0>S-S_HEADING>S-S_MAIN": 1151,
    "S0-S0>S-S_HEADING>S-S_MAIN>VP-VP": 924,
    "S0-S0>S-S_MAIN": 632,
    "S0-S0>S-S_MAIN>IP-IP": 13155,
    "S0-S0>S-S_MAIN>IP-IP_INF": 569,
    "S0-S0>S-S_MAIN>IP-IP>VP-VP": 4337,
    "S0-S0>S-S_MAIN>S-S_QUE": 1,
    "S0-S0>S-S_QUE": 3121,
    "S0-S0>S-S_QUE>IP-IP": 6,
    "S0-S0>S-S_QUOTE": 3899,
    "S0-S0_X>S-S_HEADING>IP-IP": 2,
    "S0-S0_X>S-S_MAIN": 3,
    "S0-S0_X>S-S_MAIN>IP-IP": 2,
    "S-S_EXPLAIN>IP-IP": 2,
    "S-S_EXPLAIN>NP-NP": 1,
    "S-S_HEADING>IP-IP": 21,
    "S-S_HEADING>IP-IP>ADVP-ADVP": 1,
    "S-S_HEADING>IP-IP>NP-NP": 3,
    "S-S_HEADING>IP-IP>NP-NP_SUBJ": 2,
    "S-S_HEADING>IP-IP>VP-VP": 4,
    "S-S_HEADING>NP-NP": 1,
    "S-S_HEADING>NP-NP_OBJ": 1,
    "S-S_HEADING>NP-NP_PRD": 1,
    "S-S_HEADING>NP-NP_SUBJ": 2,
    "S-S_HEADING>NP-NP_TITLE": 1,
    "S-S>IP-IP": 1,
    "S-S_MAIN>IP-IP": 226523,
    "S-S_MAIN>IP-IP>CP-CP_ADV_ACK": 1,
    "S-S_MAIN>IP-IP_INF": 13827,
    "S-S_MAIN>IP-IP_INF>VP-VP": 1,
    "S-S_MAIN>IP-IP>NP-NP": 1,
    "S-S_MAIN>IP-IP>NP-NP_PRD>VP-VP": 1,
    "S-S_MAIN>IP-IP>NP-NP_SUBJ": 5,
    "S-S_MAIN>IP-IP>VP-VP": 17470,
    "S-S_MAIN>IP-IP>VP-VP>VP-VP": 1,
    "S-S_MAIN>VP-VP": 1052,
    "S-S_PREFIX>C-C": 6652,
    "S-S_PREFIX>IP-IP": 6,
    "S-S_PREFIX>IP-IP>C-C": 3,
    "S-S_PREFIX>IP-IP_INF": 1,
    "S-S_PREFIX>IP-IP>NP-NP": 1,
    "S-S_PREFIX>IP-IP>NP-NP_SUBJ": 1,
    "S-S_PREFIX>IP-IP>PP-PP": 1,
    "S-S_PREFIX>NP-NP": 1,
    "S-S_QUE>IP-IP": 7,
    "S-S_QUE>IP-IP>VP-VP": 13,
    "S-S_QUOTE>ADVP-ADVP": 1,
    "S-S_QUOTE>IP-IP": 111,
    "S-S_QUOTE>IP-IP>CP-CP_ADV_CONS": 1,
    "S-S_QUOTE>IP-IP>CP-CP_QUOTE>IP-IP": 2,
    "S-S_QUOTE>IP-IP>CP-CP_QUOTE>IP-IP>NP-NP_SUBJ": 1,
    "S-S_QUOTE>IP-IP_INF": 1,
    "S-S_QUOTE>IP-IP>VP-VP": 5,
    "S-S_QUOTE>NP-NP_OBJ": 1,
    "S-S_QUOTE>VP-VP": 1,
    "VP-VP>IP-IP_INF": 1,
    "VP-VP>VP-VP": 36,
    # these are from previous runs
    "S0-S0>S-S_HEADING>NP-NP_COMPANY": 2271,
    "S0-S0>S-S_HEADING>NP-NP_MEASURE": 26931,
}

UNARY_BRANCHES_SIMPLIFIED = {
    "ADVP>ADVP": 1427,
    "ADVP>ADVP>NP": 1124,
    "ADVP>IP": 1,
    "ADVP>NP": 252,
    "ADVP>P": 12,
    "ADVP>PP": 25,
    "ADVP>VP": 2,
    "C>P": 298,
    "CP>ADVP": 350,
    "CP>CP": 141,
    "CP>CP>IP": 77,
    "CP>IP": 5009,
    "CP>IP>NP": 2,
    "CP>IP>VP": 88,
    "CP>NP": 706,
    "CP>PP": 458,
    "CP>VP": 5768,
    "IP>ADVP": 1,
    "IP>CP": 1759,
    "IP>CP>ADVP": 52,
    "IP>CP>NP": 286,
    "IP>CP>PP": 30,
    "IP>IP": 2052,
    "IP>NP": 12,
    "IP>S": 35340,
    "IP>S>IP": 4246,
    "IP>S>IP>VP": 574,
    "IP>S>VP": 26034,
    "IP>VP": 15908,
    "NP>ADVP": 3,
    "NP>CP": 21495,
    "NP>CP>IP": 23,
    "NP>CP>IP>VP": 1,
    "NP>FOREIGN": 4,
    "NP>IP": 77,
    "NP>IP>VP": 3,
    "NP>NP": 6108,
    "NP>NP>NP": 1,
    "NP>PP": 18,
    "NP>VP": 27498,
    "PP>ADVP": 2,
    "PP>CP": 1,
    "PP>P": 4,
    "PP>PP": 2,
    "S0>S": 28596,
    "S0>S>IP": 13772,
    "S0>S>IP>NP": 15,
    "S0>S>IP>PP": 1,
    "S0>S>IP>VP": 4353,
    "S0>S>NP": 31400,
    "S0>S>S": 1152,
    "S0>S>S>VP": 924,
    "S>ADVP": 1,
    "S>C": 6652,
    "S>IP": 240500,
    "S>IP>ADVP": 1,
    "S>IP>C": 3,
    "S>IP>CP": 2,
    "S>IP>CP>IP": 2,
    "S>IP>CP>IP>NP": 1,
    "S>IP>NP": 13,
    "S>IP>NP>VP": 1,
    "S>IP>PP": 1,
    "S>IP>VP": 17493,
    "S>IP>VP>VP": 1,
    "S>NP": 9,
    "S>VP": 1053,
    "VP>IP": 1,
    "VP>VP": 36,
}

COLLAPSED_UNARY_SIMPLIFIED_V2 = {
    "ADVP>ADVP": 1427,
    "ADVP>ADVP>NP": 1124,
    "ADVP>IP": 1,
    "ADVP>NP": 252,
    "ADVP>P": 12,
    "ADVP>PP": 25,
    "ADVP>VP": 2,
    "C>P": 298,
    "CP>CP-REL": 141,
    "CP>CP-REL>IP": 77,
    "CP>IP": 4896,
    "CP>IP>VP": 81,
    "CP>PP": 161,
    "CP>VP": 1,
    "IP>ADVP": 1,
    "IP>CP-QUE": 1759,
    "IP>CP-QUE>ADVP": 52,
    "IP>CP-QUE>NP": 286,
    "IP>CP-QUE>PP": 30,
    "IP>IP": 2052,
    "IP>NP": 3,
    "IP>NP-PRD": 1,
    "IP>NP-SUBJ": 8,
    "IP>S": 35340,
    "IP>S>IP": 4246,
    "IP>S>IP>VP": 574,
    "IP>S>VP": 26034,
    "IP>VP": 15908,
    "NP>CP-QUE": 4,
    "NP>CP-QUE>IP": 4,
    "NP>CP-THT": 2,
    "NP>FOREIGN": 3,
    "NP>IP": 1,
    "NP>NP": 3918,
    "NP>NP-POSS": 2,
    "NP>PP": 2,
    "NP>VP": 2,
    "PP>ADVP": 2,
    "PP>CP-ADV": 1,
    "PP>P": 4,
    "PP>PP": 2,
    "S0>S": 33345,
    "S0>S>IP": 14246,
    "S0>S>IP>NP": 12,
    "S0>S>IP>NP-SUBJ": 3,
    "S0>S>IP>PP": 1,
    "S0>S>IP>VP": 8350,
    "S0>S>NP": 60639,
    "S0>S>NP-SUBJ": 1,
    "S0>S>S": 1203,
    "S0>S>S>VP": 1884,
    "S>ADVP": 1,
    "S>C": 6662,
    "S>IP": 240500,
    "S>IP>ADVP": 1,
    "S>IP>C": 3,
    "S>IP>CP-ADV": 2,
    "S>IP>CP>IP": 2,
    "S>IP>CP>IP>NP-SUBJ": 1,
    "S>IP>NP": 5,
    "S>IP>NP-PRD>VP": 1,
    "S>IP>NP-SUBJ": 8,
    "S>IP>PP": 1,
    "S>IP>VP": 17564,
    "S>IP>VP>VP": 1,
    "S>NP": 4,
    "S>NP-OBJ": 2,
    "S>NP-PRD": 1,
    "S>NP-SUBJ": 2,
    "S>VP": 1055,
    "VP>IP": 1,
    "VP>VP": 36,
}

# COLLAPSED_UNARY_SIMPLIFIED_V3 = {
#     "ADVP>IP": 1,
#     "CP>VP": 1,
#     "IP>ADVP": 1,
#     "IP>NP-PRD": 1,
#     "NP>IP": 1,
#     "PP>CP-ADV": 1,
#     "S0>S>IP>PP": 1,
#     "S0>S>NP-SUBJ": 1,
#     "S>ADVP": 1,
#     "S>IP>ADVP": 1,
#     "S>IP>CP>IP>NP-SUBJ": 1,
#     "S>IP>NP-PRD>VP": 1,
#     "S>IP>PP": 1,
#     "S>IP>VP>VP": 1,
#     "S>NP-PRD": 1,
#     "VP>IP": 1,
#     "ADVP>VP": 2,
#     "NP>CP-THT": 2,
#     "NP>NP-POSS": 2,
#     "NP>PP": 2,
#     "NP>VP": 2,
#     "PP>ADVP": 2,
#     "PP>PP": 2,
#     "PP>NP": 2,
#     "S>IP>CP-ADV": 2,
#     "S>IP>CP>IP": 2,
#     "S>NP-OBJ": 2,
#     "S>NP-SUBJ": 2,
#     "IP>NP": 3,
#     "IP>S>VP": 3,
#     "NP>FOREIGN": 3,
#     "S0>S>IP>NP-SUBJ": 3,
#     "S>IP>C": 3,
#     "IP>S": 4,
#     "NP>CP-QUE": 4,
#     "NP>CP-QUE>IP": 4,
#     "PP>P": 4,
#     "S>IP>NP": 5,
#     "IP>NP-SUBJ": 8,
#     "S>IP>NP-SUBJ": 8,
#     "S0>S>IP>NP": 12,
#     "ADVP>PP": 25,
#     "VP>VP": 36,
#     "S>NP": 106,
#     "IP>CP-QUE>PP": 1452,
#     "CP>IP>VP>IP>VP": 1766,
#     "CP>IP>VP": 2855,
#     "IP>VP>IP>VP": 2878,
#     "IP>CP-QUE>ADVP": 3357,
#     "ADVP>NP": 4427,
#     "ADVP>P": 4570,
#     "S0>S>IP>VP>IP>VP": 6255,
#     "C>P": 6566,
#     "IP>CP-QUE>NP": 6799,
#     "S0>S>S>VP": 8866,
#     "CP>CP-REL>IP": 9414,
#     "CP>PP": 14001,
#     "S0>S>S": 14638,
#     "CP>CP-REL": 17496,
#     "S>VP": 19986,
#     "ADVP>ADVP": 27405,
#     "ADVP>ADVP>NP": 32254,
#     "IP>CP-QUE": 45713,
#     "IP>IP": 53011,
#     "S0>S>IP>VP": 94098,
#     "S>IP>VP>IP>VP": 121066,
#     "S>C": 136614,
#     "CP>IP": 173452,
#     "S0>S>IP": 227495,
#     "NP>NP": 279615,
#     "S0>S>NP": 314553,
#     "S>IP>VP": 531933,
#     "S0>S": 583489,
# }


COLLAPSED_UNARY_SIMPLIFIED_V3 = {
    "ADVP>ADVP": 1280,
    "ADVP>ADVP>NP": 1442,
    "ADVP>IP": 1,
    "ADVP>NP": 230,
    "ADVP>NP-PRD": 1,
    "ADVP>P": 256,
    "ADVP>PP": 34,
    "ADVP>VP": 2,
    "C>P": 277,
    "CP>CP-REL": 831,
    "CP>CP-REL>IP": 468,
    "CP>IP": 7851,
    "CP>IP>NP": 1,
    "CP>IP>VP": 140,
    "CP>IP>VP>IP>VP": 72,
    "CP>PP": 658,
    "CP>VP": 2,
    "IP>ADVP": 2,
    "IP>CP>IP": 3,
    "IP>CP>IP>VP": 1,
    "IP>CP-QUE": 2041,
    "IP>CP-QUE>ADVP": 129,
    "IP>CP-QUE>NP": 320,
    "IP>CP-QUE>PP": 72,
    "IP>IP": 2324,
    "IP>NP": 4,
    "IP>NP-OBJ": 1,
    "IP>NP-PRD": 1,
    "IP>NP-SUBJ": 9,
    "IP>S": 4,
    "IP>S>VP": 3,
    "IP>VP": 50004,
    "IP>VP>IP>VP": 121,
    "IP>VP>VP": 1,
    "NP>ADVP": 1,
    "NP>CP-QUE": 11,
    "NP>CP-QUE>IP": 4,
    "NP>CP-THT": 27,
    "NP>FOREIGN": 3,
    "NP>IP": 3,
    "NP>IP>CP-QUE": 1,
    "NP>NP": 12824,
    "NP>NP-POSS": 2,
    "NP>NP-SUBJ": 2,
    "NP>PP": 2,
    "NP>VP": 10,
    "PP>ADVP": 7,
    "PP>CP-ADV": 1,
    "PP>CP-THT": 1,
    "PP>NP": 2,
    "PP>P": 9,
    "PP>P>NP": 1,
    "PP>PP": 2,
    "S0>IP>VP": 1,
    "S0>S": 26209,
    "S0>S>IP": 9220,
    "S0>S>IP>NP": 12,
    "S0>S>IP>NP-SUBJ": 3,
    "S0>S>IP>PP": 1,
    "S0>S>IP>VP": 2293,
    "S0>S>IP>VP>IP>VP": 202,
    "S0>S>NP": 12821,
    "S0>S>NP-SUBJ": 3,
    "S0>S>S": 492,
    "S0>S>S>VP": 289,
    "S0>S>VP": 1,
    "S>ADVP": 1,
    "S>C": 6248,
    "S>IP": 297467,
    "S>IP>ADVP": 1,
    "S>IP>C": 3,
    "S>IP>CP-ADV": 2,
    "S>IP>CP>IP": 2,
    "S>IP>CP>IP>NP-SUBJ": 1,
    "S>IP>CP-THT": 2,
    "S>IP>NP": 8,
    "S>IP>NP-PRD": 1,
    "S>IP>NP-PRD>VP": 1,
    "S>IP>NP-SUBJ": 12,
    "S>IP>PP": 3,
    "S>IP>VP": 23743,
    "S>IP>VP>IP>VP": 5334,
    "S>IP>VP>VP": 1,
    "S>NP": 7,
    "S>NP-OBJ": 2,
    "S>NP-PRD": 2,
    "S>NP-SUBJ": 2,
    "S>PP": 2,
    "S>VP": 900,
    "VP>IP": 3,
    "VP>VP": 63,
    "VP>VP-AUX": 1,
}


COLLAPSED_UNARY_FULL = {
    "ADVP>ADVP-DUR-ABS": 3317,
    "ADVP>ADVP-DUR-TIME": 24088,
    "ADVP>ADVP-DUR-TIME>NP": 32254,
    "ADVP-DATE-REL>NP": 2,
    "ADVP-DATE-REL>P": 2,
    "ADVP-DATE-REL>PP": 12,
    "ADVP-DUR-ABS>NP": 1,
    "ADVP-DUR-REL>NP": 1,
    "ADVP-DUR-REL>PP": 8,
    "ADVP-DUR-TIME>NP": 4423,
    "ADVP-DUR-TIME>NP-PRD": 1,
    "ADVP-DUR-TIME>PP": 4,
    "ADVP>IP-INF": 1,
    "ADVP>P": 4568,
    "ADVP-TIMESTAMP-ABS>PP": 1,
    "ADVP-TIMESTAMP-REL>NP": 1,
    "ADVP-TIMESTAMP-REL>PP": 8,
    "ADVP-TMP-SET>NP": 1,
    "ADVP-TMP-SET>PP": 1,
    "ADVP>VP": 2,
    "C>P": 6566,
    "CP-ADV-CAUSE>IP": 1,
    "CP-ADV-CMP>IP": 5,
    "CP-ADV-CMP>IP>NP": 2,
    "CP-ADV-CMP>NP": 1,
    "CP-ADV-CMP>VP": 2,
    "CP-ADV-COND>IP": 2,
    "CP-ADV-COND>IP>VP": 12,
    "CP-ADV-COND>VP": 122199,
    "CP-ADV-TEMP>IP": 1,
    "CP-EXPLAIN>IP": 3,
    "CP>IP": 1,
    "CP-QUE>ADVP": 10020,
    "CP-QUE>IP": 17,
    "CP-QUE>NP": 17482,
    "CP-QUE>PP": 10458,
    "CP-QUOTE>IP": 165627,
    "CP-QUOTE>IP-INF": 7876,
    "CP-QUOTE>IP>NP": 1,
    "CP-QUOTE>IP>VP": 2856,
    "CP-QUOTE>IP>VP>IP>VP": 1766,
    "CP-REL>IP": 443,
    "CP-REL>VP": 1,
    "CP-SOURCE>CP-REL": 17497,
    "CP-SOURCE>CP-REL>IP": 9414,
    "CP-SOURCE>IP": 14,
    "CP-SOURCE>IP>VP": 4,
    "CP-SOURCE>PP": 14004,
    "CP-SOURCE>VP": 2,
    "IP>ADVP": 2,
    "IP>CP-QUE": 1,
    "IP>CP-QUOTE>IP": 1,
    "IP>CP-QUOTE>IP>VP": 1,
    "IP>CP-SOURCE>IP": 2,
    "IP-INF>CP-QUE": 45713,
    "IP-INF>CP-QUE>ADVP": 3357,
    "IP-INF>CP-QUE>NP": 6799,
    "IP-INF>CP-QUE>PP": 1452,
    "IP-INF>VP": 115,
    "IP>IP-INF": 53011,
    "IP>NP": 3,
    "IP>NP-AGE": 1,
    "IP>NP-OBJ": 1,
    "IP>NP-PRD": 1,
    "IP>NP-SUBJ": 9,
    "IP>S-MAIN": 4,
    "IP>S-MAIN>VP": 3,
    "IP>VP": 1126922,
    "IP>VP>IP>VP": 2878,
    "IP>VP>VP": 1,
    "NP-ADP>IP-INF": 2,
    "NP-ADP>NP-ADDR": 1,
    "NP-ADP>NP-COMPANY": 7,
    "NP-ADP>NP-MEASURE": 18,
    "NP-ADP>VP": 5,
    "NP>ADVP-DATE-REL": 1,
    "NP-COMPANY>NP-POSS": 1,
    "NP>CP-QUE": 11,
    "NP>CP-QUE>IP": 4,
    "NP>CP-THT": 27,
    "NP>FOREIGN": 2,
    "NP-IOBJ>CP-QUE": 1,
    "NP-IOBJ>CP-THT": 75067,
    "NP-IOBJ>IP": 1,
    "NP-IOBJ>IP-INF": 2,
    "NP-IOBJ>NP-ADDR": 16,
    "NP-IOBJ>NP-COMPANY": 74,
    "NP-IOBJ>NP-MEASURE": 67,
    "NP-IOBJ>VP": 3,
    "NP>IP-INF": 1,
    "NP>IP-INF>CP-QUE": 1,
    "NP>NP": 1,
    "NP>NP-COMPANY": 3,
    "NP>NP-MEASURE": 1,
    "NP>NP-PERSON": 5,
    "NP>NP-POSS": 1,
    "NP>NP-PREFIX": 1,
    "NP-OBJ>ADVP": 1,
    "NP-OBJ>CP": 3,
    "NP-OBJ>CP-ADV-TEMP": 2,
    "NP-OBJ>CP-QUE": 28,
    "NP-OBJ>CP-QUE>IP": 9,
    "NP-OBJ>CP-QUOTE>IP": 1,
    "NP-OBJ>CP-THT": 464142,
    "NP-OBJ>CP-THT>IP": 3,
    "NP-OBJ>IP": 7,
    "NP-OBJ>IP-INF": 23,
    "NP-OBJ>IP-INF>VP": 2,
    "NP-OBJ>NP": 1,
    "NP-OBJ>NP-ADDR": 212,
    "NP-OBJ>NP-COMPANY": 335,
    "NP-OBJ>NP-MEASURE": 1685,
    "NP-OBJ>VP": 1,
    "NP-POSS>NP": 1,
    "NP-POSS>NP-ADDR": 316,
    "NP-POSS>NP-COMPANY": 3921,
    "NP-POSS>NP-MEASURE": 34872,
    "NP-POSS>NP-PERSON": 4,
    "NP-POSS>NP-SOURCE": 1,
    "NP>PP": 2,
    "NP-PRD>ADVP": 1,
    "NP-PRD>ADVP-LOC": 2,
    "NP-PRD>ADVP-TIMESTAMP-REL": 1,
    "NP-PRD>CP-ADV-CMP": 4,
    "NP-PRD>CP-QUE": 1,
    "NP-PRD>CP-THT": 43072,
    "NP-PRD>FOREIGN": 1,
    "NP-PRD>IP": 1,
    "NP-PRD>IP-INF": 5,
    "NP-PRD>NP-ADDR": 34,
    "NP-PRD>NP-AGE": 13550,
    "NP-PRD>NP-COMPANY": 221,
    "NP-PRD>NP-MEASURE": 1812,
    "NP-PRD>NP-PERSON": 1,
    "NP-PRD>PP": 15,
    "NP-PRD>PP-LOC": 1,
    "NP-PRD>VP": 873564,
    "NP-PREFIX>NP-COMPANY": 333,
    "NP-SOURCE>NP": 279264,
    "NP-SOURCE>NP-PERSON": 1,
    "NP-SOURCE>NP-SUBJ": 2,
    "NP-SUBJ>CP": 1,
    "NP-SUBJ>CP-QUE": 10,
    "NP-SUBJ>CP-QUE>IP": 10,
    "NP-SUBJ>CP-QUE>IP>VP": 1,
    "NP-SUBJ>CP-QUOTE>IP": 1,
    "NP-SUBJ>CP-THT": 102313,
    "NP-SUBJ>IP": 2,
    "NP-SUBJ>IP-INF": 61,
    "NP-SUBJ>IP-INF>VP": 1,
    "NP-SUBJ>NP-ADDR": 180,
    "NP-SUBJ>NP-COMPANY": 1449,
    "NP-SUBJ>NP-MEASURE": 1283,
    "NP-SUBJ>NP-PERSON": 18,
    "NP-SUBJ>NP-PRD>NP-TITLE": 1,
    "NP-SUBJ>NP-SOURCE": 2,
    "NP-SUBJ>NP-TITLE": 2,
    "NP-SUBJ>VP": 12,
    "NP-TITLE>FOREIGN": 1,
    "NP-TITLE>NP-PERSON": 2,
    "NP>VP": 5,
    "PP>ADVP": 2,
    "PP>ADVP-DATE-REL": 2,
    "PP>ADVP-DUR-REL": 3,
    "PP>CP-ADV-CAUSE": 1,
    "PP>CP-THT": 1,
    "PP-DIR>P": 1,
    "PP>NP": 2,
    "PP>P": 8,
    "PP>P>NP": 1,
    "PP>PP": 2,
    "S0>IP>VP": 1,
    "S0>S-HEADING": 231720,
    "S0>S-HEADING>IP": 39,
    "S0>S-HEADING>IP-INF": 1,
    "S0>S-HEADING>IP>NP": 12,
    "S0>S-HEADING>IP>NP-SUBJ": 3,
    "S0>S-HEADING>IP>PP": 1,
    "S0>S-HEADING>IP>VP": 17,
    "S0>S-HEADING>NP": 314367,
    "S0>S-HEADING>NP-ADDR": 1,
    "S0>S-HEADING>NP-COMPANY": 83,
    "S0>S-HEADING>NP-MEASURE": 108,
    "S0>S-HEADING>NP-SUBJ": 3,
    "S0>S-HEADING>S-MAIN": 14637,
    "S0>S-HEADING>S-MAIN>VP": 8867,
    "S0>S-MAIN": 13585,
    "S0>S-MAIN>IP": 218871,
    "S0>S-MAIN>IP-INF": 8597,
    "S0>S-MAIN>IP>VP": 94082,
    "S0>S-MAIN>IP>VP>IP>VP": 6255,
    "S0>S-MAIN>S-QUE": 1,
    "S0>S-MAIN>VP": 1,
    "S0>S-QUE": 58945,
    "S0>S-QUE>IP": 6,
    "S0>S-QUE>IP>VP": 1,
    "S0>S-QUOTE": 279302,
    "S0>S-QUOTE>IP": 2,
    "S0-X>S-HEADING": 2,
    "S0-X>S-HEADING>IP": 2,
    "S0-X>S-MAIN": 11,
    "S0-X>S-MAIN>IP": 3,
    "S0-X>S-MAIN>IP>VP": 1,
    "S0-X>S-QUOTE": 2,
    "S-EXPLAIN>IP": 2,
    "S-EXPLAIN>NP": 1,
    "S-EXPLAIN>PP": 1,
    "S-HEADING>IP": 25,
    "S-HEADING>IP>ADVP": 1,
    "S-HEADING>IP-INF": 2,
    "S-HEADING>IP>NP": 4,
    "S-HEADING>IP>NP-SUBJ": 2,
    "S-HEADING>IP>VP": 7,
    "S-HEADING>NP": 106,
    "S-HEADING>NP-OBJ": 1,
    "S-HEADING>NP-PRD": 2,
    "S-HEADING>NP-SUBJ": 2,
    "S-HEADING>NP-TITLE": 1,
    "S>IP": 3,
    "S-MAIN>IP": 6241981,
    "S-MAIN>IP>CP-ADV-ACK": 1,
    "S-MAIN>IP>CP-THT": 2,
    "S-MAIN>IP-INF": 352906,
    "S-MAIN>IP-INF>VP": 3,
    "S-MAIN>IP>NP": 3,
    "S-MAIN>IP>NP-PRD": 1,
    "S-MAIN>IP>NP-PRD>VP": 1,
    "S-MAIN>IP>NP-SUBJ": 9,
    "S-MAIN>IP>PP": 2,
    "S-MAIN>IP>VP": 532042,
    "S-MAIN>IP>VP>IP>VP": 121066,
    "S-MAIN>IP>VP>VP": 1,
    "S-MAIN>VP": 19991,
    "S-PREFIX>C": 136636,
    "S-PREFIX>IP": 6,
    "S-PREFIX>IP>C": 3,
    "S-PREFIX>IP-INF": 1,
    "S-PREFIX>IP>NP": 1,
    "S-PREFIX>IP>NP-SUBJ": 1,
    "S-PREFIX>IP>PP": 1,
    "S-PREFIX>NP": 1,
    "S-QUE>IP": 10,
    "S-QUE>IP>VP": 20,
    "S-QUOTE>ADVP": 1,
    "S-QUOTE>IP": 159,
    "S-QUOTE>IP>CP-ADV-CONS": 1,
    "S-QUOTE>IP>CP-QUOTE>IP": 2,
    "S-QUOTE>IP>CP-QUOTE>IP>NP-SUBJ": 1,
    "S-QUOTE>IP-INF": 1,
    "S-QUOTE>IP>VP": 7,
    "S-QUOTE>NP-OBJ": 1,
    "S-QUOTE>PP": 1,
    "S-QUOTE>VP": 1,
    "VP>IP-INF": 3,
    "VP>VP": 63,
    "VP>VP-AUX": 1,
}

ALL_COLLAPSED_UNARY = dict(COLLAPSED_UNARY_SIMPLIFIED_V2)
ALL_COLLAPSED_UNARY.update(COLLAPSED_UNARY_SIMPLIFIED_V3)

# s2 = set(COLLAPSED_UNARY_SIMPLIFIED_V2)
# s3 = set(COLLAPSED_UNARY_SIMPLIFIED_V3)
# ic(
#     len(s2),
#     len(s3),
#     len(s2.intersection(s3)),
#     len(s2.union(s3)),
#     s2.difference(s3),
#     s3.difference(s2),
# )

# ic(len(ALL_COLLAPSED_UNARY))
