from __future__ import absolute_import
from unittest import TestCase
from . import img_paste
import numpy as np


class TestBbox_img_past(TestCase):
    def test_happy_flow(self):
        big_img = np.zeros((11, 10), dtype=np.uint8)
        small_img = np.ones((6, 5), dtype=np.uint8) * 255
        small_img[:, -1] = 128

        x = 4
        y = 2
        expected = np.array(
            [
                [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
                [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
                [0.0, 0.0, 0.0, 0.0, 255.0, 255.0, 255.0, 255.0, 128.0, 0.0],
                [0.0, 0.0, 0.0, 0.0, 255.0, 255.0, 255.0, 255.0, 128.0, 0.0],
                [0.0, 0.0, 0.0, 0.0, 255.0, 255.0, 255.0, 255.0, 128.0, 0.0],
                [0.0, 0.0, 0.0, 0.0, 255.0, 255.0, 255.0, 255.0, 128.0, 0.0],
                [0.0, 0.0, 0.0, 0.0, 255.0, 255.0, 255.0, 255.0, 128.0, 0.0],
                [0.0, 0.0, 0.0, 0.0, 255.0, 255.0, 255.0, 255.0, 128.0, 0.0],
                [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
                [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
                [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
            ],
            dtype=np.uint8,
        )

        img_paste(big_img, small_img, x, y)

        np.testing.assert_array_equal(big_img, expected)

    def test_x_overflow(self):
        big_img = np.zeros((11, 10), dtype=np.uint8)
        small_img = np.ones((6, 5), dtype=np.uint8) * 255
        small_img[:, 0] = 128

        x = 6
        y = 2
        expected = np.array(
            [
                [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
                [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
                [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 128.0, 255.0, 255.0, 255.0],
                [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 128.0, 255.0, 255.0, 255.0],
                [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 128.0, 255.0, 255.0, 255.0],
                [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 128.0, 255.0, 255.0, 255.0],
                [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 128.0, 255.0, 255.0, 255.0],
                [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 128.0, 255.0, 255.0, 255.0],
                [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
                [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
                [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
            ],
            dtype=np.uint8,
        )

        img_paste(big_img, small_img, x, y)

        print(big_img)
        np.testing.assert_array_equal(big_img, expected)

    def test_x_y_overflow(self):
        big_img = np.zeros((11, 10), dtype=np.uint8)
        small_img = np.ones((6, 7), dtype=np.uint8) * 255
        small_img[:, 0] = 128

        x = 6
        y = 5
        expected = np.array(
            [
                [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
                [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
                [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
                [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
                [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
                [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 128.0, 255.0, 255.0, 255.0],
                [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 128.0, 255.0, 255.0, 255.0],
                [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 128.0, 255.0, 255.0, 255.0],
                [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 128.0, 255.0, 255.0, 255.0],
                [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 128.0, 255.0, 255.0, 255.0],
                [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 128.0, 255.0, 255.0, 255.0],
            ],
            dtype=np.uint8,
        )

        img_paste(big_img, small_img, x, y)

        print(big_img)
        np.testing.assert_array_equal(big_img, expected)

    def test_x_underflow(self):
        big_img = np.zeros((11, 10), dtype=np.uint8)
        small_img = np.ones((6, 5), dtype=np.uint8) * 255
        small_img[:, -1] = 128
        x = -1
        y = 2
        expected = np.array(
            [
                [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
                [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
                [255.0, 255.0, 255.0, 128.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
                [255.0, 255.0, 255.0, 128.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
                [255.0, 255.0, 255.0, 128.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
                [255.0, 255.0, 255.0, 128.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
                [255.0, 255.0, 255.0, 128.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
                [255.0, 255.0, 255.0, 128.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
                [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
                [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
                [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
            ],
            dtype=np.uint8,
        )

        img_paste(big_img, small_img, x, y)

        np.testing.assert_array_equal(big_img, expected)

    def test_x_y_underflow(self):
        big_img = np.zeros((11, 10), dtype=np.uint8)
        small_img = np.ones((8, 5), dtype=np.uint8) * 255
        small_img[:, -1] = 128
        x = -1
        y = -2
        expected = np.array(
            [
                [255.0, 255.0, 255.0, 128.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
                [255.0, 255.0, 255.0, 128.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
                [255.0, 255.0, 255.0, 128.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
                [255.0, 255.0, 255.0, 128.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
                [255.0, 255.0, 255.0, 128.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
                [255.0, 255.0, 255.0, 128.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
                [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
                [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
                [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
                [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
                [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
            ],
            dtype=np.uint8,
        )

        img_paste(big_img, small_img, x, y)

        np.testing.assert_array_equal(big_img, expected)

    def test_x_out_of_window_left(self):
        big_img = np.zeros((11, 10), dtype=np.uint8)
        small_img = np.ones((6, 5), dtype=np.uint8) * 255

        x = -10
        y = 2
        expected = np.array(
            [
                [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
                [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
                [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
                [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
                [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
                [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
                [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
                [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
                [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
                [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
                [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
            ],
            dtype=np.uint8,
        )

        img_paste(big_img, small_img, x, y)

        np.testing.assert_array_equal(big_img, expected)

    def test_y_out_of_window_up(self):
        big_img = np.zeros((11, 10), dtype=np.uint8)
        small_img = np.ones((6, 5), dtype=np.uint8) * 255

        x = 5
        y = -9
        expected = np.array(
            [
                [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
                [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
                [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
                [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
                [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
                [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
                [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
                [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
                [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
                [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
                [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
            ],
            dtype=np.uint8,
        )

        img_paste(big_img, small_img, x, y)

        np.testing.assert_array_equal(big_img, expected)

    def test_x_out_of_window_right(self):
        big_img = np.zeros((11, 10), dtype=np.uint8)
        small_img = np.ones((6, 5), dtype=np.uint8) * 255

        x = 10
        y = 2
        expected = np.array(
            [
                [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
                [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
                [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
                [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
                [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
                [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
                [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
                [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
                [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
                [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
                [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
            ],
            dtype=np.uint8,
        )

        img_paste(big_img, small_img, x, y)

        np.testing.assert_array_equal(big_img, expected)

    def test_y_out_of_window_down(self):
        big_img = np.zeros((11, 10), dtype=np.uint8)
        small_img = np.ones((6, 5), dtype=np.uint8) * 255

        x = 3
        y = 11
        expected = np.array(
            [
                [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
                [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
                [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
                [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
                [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
                [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
                [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
                [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
                [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
                [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
                [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
            ],
            dtype=np.uint8,
        )

        img_paste(big_img, small_img, x, y)

        np.testing.assert_array_equal(big_img, expected)

    def test_x_to_big(self):
        big_img = np.zeros((11, 10), dtype=np.uint8)
        small_img = np.ones((6, 14), dtype=np.uint8) * 255
        small_img[:, 1] = 128

        x = -1
        y = 2
        expected = np.array(
            [
                [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
                [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
                [128.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [128.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [128.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [128.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [128.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [128.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
                [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
                [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
            ],
            dtype=np.uint8,
        )

        img_paste(big_img, small_img, x, y)
        print(big_img)
        np.testing.assert_array_equal(big_img, expected)

    def test_y_to_big(self):
        big_img = np.zeros((11, 10), dtype=np.uint8)
        small_img = np.ones((14, 6), dtype=np.uint8) * 255
        small_img[0, :] = 128

        x = 3
        y = 1
        expected = np.array(
            [
                [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
                [0.0, 0.0, 0.0, 128.0, 128.0, 128.0, 128.0, 128.0, 128.0, 0.0],
                [0.0, 0.0, 0.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 0.0],
                [0.0, 0.0, 0.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 0.0],
                [0.0, 0.0, 0.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 0.0],
                [0.0, 0.0, 0.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 0.0],
                [0.0, 0.0, 0.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 0.0],
                [0.0, 0.0, 0.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 0.0],
                [0.0, 0.0, 0.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 0.0],
                [0.0, 0.0, 0.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 0.0],
                [0.0, 0.0, 0.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 0.0],
            ],
            dtype=np.uint8,
        )

        img_paste(big_img, small_img, x, y)
        print(big_img)
        np.testing.assert_array_equal(big_img, expected)

    def test_x_y_to_big(self):
        big_img = np.zeros((11, 10), dtype=np.uint8)
        small_img = np.ones((20, 14), dtype=np.uint8) * 255
        small_img[:, 1] = 128
        small_img[2, 2] = 42

        x = -1
        y = -2
        expected = np.array(
            [
                [128.0, 42.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [128.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [128.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [128.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [128.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [128.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [128.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [128.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [128.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [128.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
                [128.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0, 255.0],
            ],
            dtype=np.uint8,
        )

        img_paste(big_img, small_img, x, y)
        print(big_img)
        np.testing.assert_array_equal(big_img, expected)
