/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.visitors;

import com.google.common.collect.Iterables;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.DataType;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.MiningField;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.Model;
import org.dmg.pmml.OutputField;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.ResultFeature;
import org.dmg.pmml.ScoreDistribution;
import org.dmg.pmml.Target;
import org.dmg.pmml.TargetValue;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.general_regression.GeneralRegressionModel;
import org.dmg.pmml.general_regression.PCell;
import org.dmg.pmml.general_regression.PCovCell;
import org.dmg.pmml.general_regression.PPCell;
import org.dmg.pmml.mining.MiningModel;
import org.dmg.pmml.mining.Segmentation;
import org.dmg.pmml.naive_bayes.TargetValueCount;
import org.dmg.pmml.naive_bayes.TargetValueStat;
import org.dmg.pmml.regression.RegressionTable;
import org.dmg.pmml.rule_set.PMMLAttributes;
import org.dmg.pmml.rule_set.RuleSet;
import org.dmg.pmml.rule_set.SimpleRule;
import org.dmg.pmml.support_vector_machine.SupportVectorMachine;
import org.dmg.pmml.support_vector_machine.SupportVectorMachineModel;
import org.dmg.pmml.tree.Node;
import org.dmg.pmml.tree.TreeModel;
import org.jpmml.evaluator.Evaluator;
import org.jpmml.evaluator.MissingAttributeException;
import org.jpmml.evaluator.MissingElementException;
import org.jpmml.evaluator.TypeUtil;
import org.jpmml.evaluator.visitors.AbstractParser;
import org.jpmml.model.XPathUtil;

public class TargetCategoryParser
extends AbstractParser {
    private Deque<Map<FieldName, DataType>> targetDataTypes = new ArrayDeque<Map<FieldName, DataType>>();
    private DataType dataType = null;

    @Override
    public void reset() {
        super.reset();
        this.targetDataTypes.clear();
        this.dataType = null;
    }

    public void pushParent(PMMLObject parent) {
        super.pushParent(parent);
        if (parent instanceof MiningModel) {
            MiningModel miningModel = (MiningModel)parent;
            this.processMiningModel(miningModel);
        } else if (parent instanceof Model) {
            Model model = (Model)parent;
            this.processModel(model);
        }
    }

    @Override
    public PMMLObject popParent() {
        PMMLObject parent = super.popParent();
        if (parent instanceof Model) {
            this.targetDataTypes.pop();
            this.dataType = null;
        }
        return parent;
    }

    public VisitorAction visit(GeneralRegressionModel generalRegressionModel) {
        generalRegressionModel.setTargetReferenceCategory(this.parseTargetValue(generalRegressionModel.getTargetReferenceCategory()));
        return super.visit(generalRegressionModel);
    }

    public VisitorAction visit(Node node) {
        PMMLObject parent = this.getParent();
        if (parent instanceof TreeModel) {
            TreeModel treeModel = (TreeModel)parent;
            MiningFunction miningFunction = treeModel.getMiningFunction();
            switch (miningFunction) {
                case CLASSIFICATION: {
                    break;
                }
                default: {
                    return VisitorAction.SKIP;
                }
            }
        }
        node.setScore(this.parseTargetValue(node.getScore()));
        return super.visit(node);
    }

    public VisitorAction visit(OutputField outputField) {
        ResultFeature resultFeature = outputField.getResultFeature();
        switch (resultFeature) {
            case PROBABILITY: 
            case CONFIDENCE: 
            case AFFINITY: {
                outputField.setValue(this.parseTargetValue(outputField.getTargetField(), outputField.getValue()));
                break;
            }
        }
        return super.visit(outputField);
    }

    public VisitorAction visit(PCell pCell) {
        pCell.setTargetCategory(this.parseTargetValue(pCell.getTargetCategory()));
        return super.visit(pCell);
    }

    public VisitorAction visit(PCovCell pCovCell) {
        pCovCell.setTargetCategory(this.parseTargetValue(pCovCell.getTargetCategory()));
        return super.visit(pCovCell);
    }

    public VisitorAction visit(PPCell ppCell) {
        ppCell.setTargetCategory(this.parseTargetValue(ppCell.getTargetCategory()));
        return super.visit(ppCell);
    }

    public VisitorAction visit(RegressionTable regressionTable) {
        regressionTable.setTargetCategory(this.parseTargetValue(regressionTable.getTargetCategory()));
        return super.visit(regressionTable);
    }

    public VisitorAction visit(RuleSet ruleSet) {
        ruleSet.setDefaultScore(this.parseTargetValue(ruleSet.getDefaultScore()));
        return super.visit(ruleSet);
    }

    public VisitorAction visit(ScoreDistribution scoreDistribution) {
        Object value = scoreDistribution.getValue();
        if (value == null) {
            throw new MissingAttributeException((PMMLObject)scoreDistribution, org.dmg.pmml.PMMLAttributes.SCOREDISTRIBUTION_VALUE);
        }
        scoreDistribution.setValue(this.parseTargetValue(value));
        return super.visit(scoreDistribution);
    }

    public VisitorAction visit(SimpleRule simpleRule) {
        Object score = simpleRule.getScore();
        if (score == null) {
            throw new MissingAttributeException((PMMLObject)simpleRule, PMMLAttributes.SIMPLERULE_SCORE);
        }
        simpleRule.setScore(this.parseTargetValue(simpleRule.getScore()));
        return super.visit(simpleRule);
    }

    public VisitorAction visit(SupportVectorMachine supportVectorMachine) {
        supportVectorMachine.setTargetCategory(this.parseTargetValue(supportVectorMachine.getTargetCategory()));
        supportVectorMachine.setAlternateTargetCategory(this.parseTargetValue(supportVectorMachine.getAlternateTargetCategory()));
        return super.visit(supportVectorMachine);
    }

    public VisitorAction visit(SupportVectorMachineModel supportVectorMachineModel) {
        supportVectorMachineModel.setAlternateBinaryTargetCategory(this.parseTargetValue(supportVectorMachineModel.getAlternateBinaryTargetCategory()));
        return super.visit(supportVectorMachineModel);
    }

    public VisitorAction visit(TargetValue targetValue) {
        Target target = (Target)this.getParent();
        targetValue.setValue(this.parseTargetValue(target.getField(), targetValue.getValue()));
        return super.visit(targetValue);
    }

    public VisitorAction visit(TargetValueCount targetValueCount) {
        Object value = targetValueCount.getValue();
        if (value == null) {
            throw new MissingAttributeException((PMMLObject)targetValueCount, org.dmg.pmml.naive_bayes.PMMLAttributes.TARGETVALUECOUNT_VALUE);
        }
        targetValueCount.setValue(this.parseTargetValue(value));
        return super.visit(targetValueCount);
    }

    public VisitorAction visit(TargetValueStat targetValueStat) {
        Object value = targetValueStat.getValue();
        if (value == null) {
            throw new MissingAttributeException((PMMLObject)targetValueStat, org.dmg.pmml.naive_bayes.PMMLAttributes.TARGETVALUESTAT_VALUE);
        }
        targetValueStat.setValue(this.parseTargetValue(value));
        return super.visit(targetValueStat);
    }

    private void processMiningModel(MiningModel miningModel) {
        Segmentation segmentation = miningModel.getSegmentation();
        if (segmentation != null) {
            Segmentation.MultipleModelMethod multipleModelMethod = segmentation.getMultipleModelMethod();
            switch (multipleModelMethod) {
                case SELECT_FIRST: 
                case SELECT_ALL: 
                case MODEL_CHAIN: {
                    this.targetDataTypes.push(Collections.singletonMap(Evaluator.DEFAULT_TARGET_NAME, null));
                    this.dataType = null;
                    return;
                }
            }
        }
        this.processModel((Model)miningModel);
    }

    private void processModel(Model model) {
        MiningSchema miningSchema = model.getMiningSchema();
        if (miningSchema == null) {
            throw new MissingElementException(MissingElementException.formatMessage(XPathUtil.formatElement(model.getClass()) + "/" + XPathUtil.formatElement(MiningSchema.class)), (PMMLObject)model);
        }
        LinkedHashMap<FieldName, DataType> targetDataTypes = new LinkedHashMap<FieldName, DataType>();
        if (miningSchema.hasMiningFields()) {
            List miningFields = miningSchema.getMiningFields();
            for (MiningField miningField : miningFields) {
                FieldName name = miningField.getName();
                if (name == null) {
                    throw new MissingAttributeException((PMMLObject)miningField, org.dmg.pmml.PMMLAttributes.MININGFIELD_NAME);
                }
                MiningField.UsageType usageType = miningField.getUsageType();
                switch (usageType) {
                    case PREDICTED: 
                    case TARGET: {
                        DataType dataType = this.resolveTargetDataType(name);
                        targetDataTypes.put(name, dataType);
                        break;
                    }
                }
            }
        }
        this.targetDataTypes.push(targetDataTypes);
        this.dataType = this.getDataType();
    }

    private DataType getDataType() {
        for (Map<FieldName, DataType> targetDataTypes : this.targetDataTypes) {
            if (targetDataTypes.isEmpty()) continue;
            HashSet<DataType> dataTypes = new HashSet<DataType>(targetDataTypes.values());
            if (dataTypes.size() == 1) {
                return (DataType)Iterables.getOnlyElement(dataTypes);
            }
            return null;
        }
        return null;
    }

    private Object parseTargetValue(Object value) {
        if (value == null) {
            return value;
        }
        if (this.dataType != null) {
            return TypeUtil.parseOrCast(this.dataType, value);
        }
        return value;
    }

    private Object parseTargetValue(FieldName targetName, Object value) {
        if (targetName == null) {
            return this.parseTargetValue(value);
        }
        if (value == null) {
            return value;
        }
        Map<FieldName, DataType> targetDataTypes = this.targetDataTypes.peekFirst();
        DataType dataType = targetDataTypes.get(targetName);
        if (dataType != null) {
            return TypeUtil.parseOrCast(dataType, value);
        }
        return value;
    }
}

