/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.mining;

import com.google.common.base.Function;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.EmbeddedModel;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.Model;
import org.dmg.pmml.OpType;
import org.dmg.pmml.Output;
import org.dmg.pmml.PMML;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.ResultFeature;
import org.dmg.pmml.True;
import org.dmg.pmml.mining.MiningModel;
import org.dmg.pmml.mining.PMMLAttributes;
import org.dmg.pmml.mining.PMMLElements;
import org.dmg.pmml.mining.Segment;
import org.dmg.pmml.mining.Segmentation;
import org.dmg.pmml.mining.VariableWeight;
import org.jpmml.evaluator.CacheUtil;
import org.jpmml.evaluator.Configuration;
import org.jpmml.evaluator.DefaultTargetField;
import org.jpmml.evaluator.EntityUtil;
import org.jpmml.evaluator.EvaluationContext;
import org.jpmml.evaluator.EvaluationException;
import org.jpmml.evaluator.Evaluator;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.HasEntityRegistry;
import org.jpmml.evaluator.InvalidAttributeException;
import org.jpmml.evaluator.InvalidElementException;
import org.jpmml.evaluator.MissingAttributeException;
import org.jpmml.evaluator.MissingElementException;
import org.jpmml.evaluator.MissingValueException;
import org.jpmml.evaluator.ModelEvaluationContext;
import org.jpmml.evaluator.ModelEvaluator;
import org.jpmml.evaluator.ModelEvaluatorFactory;
import org.jpmml.evaluator.OutputField;
import org.jpmml.evaluator.PMMLException;
import org.jpmml.evaluator.PMMLUtil;
import org.jpmml.evaluator.PredicateUtil;
import org.jpmml.evaluator.TargetField;
import org.jpmml.evaluator.TargetUtil;
import org.jpmml.evaluator.UnsupportedAttributeException;
import org.jpmml.evaluator.UnsupportedElementException;
import org.jpmml.evaluator.Value;
import org.jpmml.evaluator.ValueFactory;
import org.jpmml.evaluator.ValueMap;
import org.jpmml.evaluator.ValueUtil;
import org.jpmml.evaluator.mining.MiningModelEvaluationContext;
import org.jpmml.evaluator.mining.MiningModelUtil;
import org.jpmml.evaluator.mining.MiningProbabilityDistribution;
import org.jpmml.evaluator.mining.MiningScore;
import org.jpmml.evaluator.mining.MiningVoteDistribution;
import org.jpmml.evaluator.mining.SegmentResult;
import org.jpmml.model.XPathUtil;

public class MiningModelEvaluator
extends ModelEvaluator<MiningModel>
implements HasEntityRegistry<Segment> {
    private Map<String, Set<ResultFeature>> segmentResultFeatures = Collections.emptyMap();
    private ConcurrentMap<String, ModelEvaluator<?>> segmentModelEvaluators = new ConcurrentHashMap();
    private BiMap<String, Segment> entityRegistry = null;
    private static final Set<Segmentation.MultipleModelMethod> REGRESSION_METHODS = EnumSet.of(Segmentation.MultipleModelMethod.AVERAGE, new Segmentation.MultipleModelMethod[]{Segmentation.MultipleModelMethod.WEIGHTED_AVERAGE, Segmentation.MultipleModelMethod.MEDIAN, Segmentation.MultipleModelMethod.WEIGHTED_MEDIAN, Segmentation.MultipleModelMethod.SUM, Segmentation.MultipleModelMethod.WEIGHTED_SUM});
    private static final Set<Segmentation.MultipleModelMethod> CLASSIFICATION_METHODS = EnumSet.of(Segmentation.MultipleModelMethod.MAJORITY_VOTE, new Segmentation.MultipleModelMethod[]{Segmentation.MultipleModelMethod.WEIGHTED_MAJORITY_VOTE, Segmentation.MultipleModelMethod.AVERAGE, Segmentation.MultipleModelMethod.WEIGHTED_AVERAGE, Segmentation.MultipleModelMethod.MEDIAN, Segmentation.MultipleModelMethod.MAX});
    private static final Set<Segmentation.MultipleModelMethod> CLUSTERING_METHODS = EnumSet.of(Segmentation.MultipleModelMethod.MAJORITY_VOTE, Segmentation.MultipleModelMethod.WEIGHTED_MAJORITY_VOTE);
    private static final LoadingCache<Output, Map<String, Set<ResultFeature>>> segmentResultFeaturesCache = CacheUtil.buildLoadingCache(new CacheLoader<Output, Map<String, Set<ResultFeature>>>(){

        public Map<String, Set<ResultFeature>> load(Output output) {
            LinkedHashMap<String, Set> result = new LinkedHashMap<String, Set>();
            List pmmlOutputFields = output.getOutputFields();
            for (org.dmg.pmml.OutputField pmmlOutputField : pmmlOutputFields) {
                String segmentId = pmmlOutputField.getSegmentId();
                if (segmentId == null) continue;
                EnumSet<ResultFeature> resultFeatures = (EnumSet<ResultFeature>)result.get(segmentId);
                if (resultFeatures == null) {
                    resultFeatures = EnumSet.noneOf(ResultFeature.class);
                    result.put(segmentId, resultFeatures);
                }
                resultFeatures.add(pmmlOutputField.getResultFeature());
            }
            result.replaceAll((key, value) -> Sets.immutableEnumSet((Iterable)value));
            return ImmutableMap.copyOf(result);
        }
    });
    private static final LoadingCache<MiningModel, BiMap<String, Segment>> entityCache = CacheUtil.buildLoadingCache(new CacheLoader<MiningModel, BiMap<String, Segment>>(){

        public BiMap<String, Segment> load(MiningModel miningModel) {
            Segmentation segmentation = miningModel.getSegmentation();
            return EntityUtil.buildBiMap(segmentation.getSegments());
        }
    });

    private MiningModelEvaluator() {
    }

    public MiningModelEvaluator(PMML pmml) {
        this(pmml, PMMLUtil.findModel(pmml, MiningModel.class));
    }

    public MiningModelEvaluator(PMML pmml, MiningModel miningModel) {
        super(pmml, miningModel);
        if (miningModel.hasEmbeddedModels()) {
            List embeddedModels = miningModel.getEmbeddedModels();
            EmbeddedModel embeddedModel = (EmbeddedModel)Iterables.getFirst((Iterable)embeddedModels, null);
            throw new UnsupportedElementException((PMMLObject)embeddedModel);
        }
        Segmentation segmentation = miningModel.getSegmentation();
        if (segmentation == null) {
            throw new MissingElementException((PMMLObject)miningModel, PMMLElements.MININGMODEL_SEGMENTATION);
        }
        Segmentation.MultipleModelMethod multipleModelMethod = segmentation.getMultipleModelMethod();
        if (multipleModelMethod == null) {
            throw new MissingAttributeException((PMMLObject)segmentation, PMMLAttributes.SEGMENTATION_MULTIPLEMODELMETHOD);
        }
        if (!segmentation.hasSegments()) {
            throw new MissingElementException((PMMLObject)segmentation, PMMLElements.SEGMENTATION_SEGMENTS);
        }
        List segments = segmentation.getSegments();
        for (Segment segment : segments) {
            VariableWeight variableWeight = segment.getVariableWeight();
            if (variableWeight == null) continue;
            throw new UnsupportedElementException((PMMLObject)variableWeight);
        }
        LocalTransformations localTransformations = segmentation.getLocalTransformations();
        if (localTransformations != null) {
            throw new UnsupportedElementException((PMMLObject)localTransformations);
        }
        Output output = miningModel.getOutput();
        if (output != null && output.hasOutputFields()) {
            this.segmentResultFeatures = CacheUtil.getValue(output, segmentResultFeaturesCache);
        }
    }

    protected Set<ResultFeature> getSegmentResultFeatures(String segmentId) {
        return this.segmentResultFeatures.get(segmentId);
    }

    @Override
    public void configure(Configuration configuration) {
        super.configure(configuration);
        this.segmentModelEvaluators.clear();
    }

    @Override
    public String getSummary() {
        return "Ensemble model";
    }

    @Override
    public DataField getDefaultDataField() {
        MiningModel miningModel = (MiningModel)this.getModel();
        Segmentation segmentation = miningModel.getSegmentation();
        Segmentation.MultipleModelMethod multipleModelMethod = segmentation.getMultipleModelMethod();
        switch (multipleModelMethod) {
            case SELECT_FIRST: 
            case SELECT_ALL: 
            case MODEL_CHAIN: {
                return null;
            }
        }
        return super.getDefaultDataField();
    }

    @Override
    public boolean isPure() {
        return false;
    }

    @Override
    public FieldName getTargetName() {
        List<TargetField> targetFields = super.getTargetFields();
        if (targetFields.isEmpty()) {
            return Evaluator.DEFAULT_TARGET_NAME;
        }
        return super.getTargetName();
    }

    @Override
    public BiMap<String, Segment> getEntityRegistry() {
        if (this.entityRegistry == null) {
            this.entityRegistry = this.getValue(entityCache);
        }
        return this.entityRegistry;
    }

    @Override
    protected List<OutputField> createOutputFields() {
        List<OutputField> outputFields = super.createOutputFields();
        List<OutputField> nestedOutputFields = this.createNestedOutputFields();
        if (!nestedOutputFields.isEmpty()) {
            return ImmutableList.copyOf((Iterable)Iterables.concat(nestedOutputFields, outputFields));
        }
        return outputFields;
    }

    @Override
    protected int getNumberOfVisibleFields() {
        return -1;
    }

    @Override
    public ModelEvaluationContext createEvaluationContext() {
        return new MiningModelEvaluationContext(this);
    }

    @Override
    public Map<FieldName, ?> evaluateInternal(ModelEvaluationContext context) {
        return super.evaluateInternal((MiningModelEvaluationContext)context);
    }

    @Override
    protected <V extends Number> Map<FieldName, ?> evaluateRegression(ValueFactory<V> valueFactory, EvaluationContext context) {
        Value<V> value;
        MiningModel miningModel = (MiningModel)this.getModel();
        final List<SegmentResult> segmentResults = this.evaluateSegmentation((MiningModelEvaluationContext)context);
        Map<FieldName, ?> predictions = this.getSegmentationResult(REGRESSION_METHODS, segmentResults);
        if (predictions != null) {
            return predictions;
        }
        TargetField targetField = this.getTargetField();
        Segmentation segmentation = miningModel.getSegmentation();
        Segmentation.MultipleModelMethod multipleModelMethod = segmentation.getMultipleModelMethod();
        Segmentation.MissingPredictionTreatment missingPredictionTreatment = segmentation.getMissingPredictionTreatment();
        Number missingThreshold = segmentation.getMissingThreshold();
        if (missingThreshold.doubleValue() < 0.0 || missingThreshold.doubleValue() > 1.0) {
            throw new InvalidAttributeException((PMMLObject)segmentation, PMMLAttributes.SEGMENTATION_MISSINGTHRESHOLD, missingThreshold);
        }
        switch (multipleModelMethod) {
            case AVERAGE: 
            case WEIGHTED_AVERAGE: 
            case MEDIAN: 
            case WEIGHTED_MEDIAN: 
            case SUM: 
            case WEIGHTED_SUM: {
                value = MiningModelUtil.aggregateValues(valueFactory, multipleModelMethod, missingPredictionTreatment, missingThreshold, segmentResults);
                if (value != null) break;
                return TargetUtil.evaluateRegressionDefault(valueFactory, targetField);
            }
            case SELECT_FIRST: 
            case SELECT_ALL: 
            case MODEL_CHAIN: 
            case MAJORITY_VOTE: 
            case WEIGHTED_MAJORITY_VOTE: 
            case MAX: {
                throw new InvalidAttributeException((PMMLObject)segmentation, (Enum<?>)multipleModelMethod);
            }
            default: {
                throw new UnsupportedAttributeException((PMMLObject)segmentation, (Enum<?>)multipleModelMethod);
            }
        }
        value = TargetUtil.evaluateRegressionInternal(targetField, value);
        MiningScore result = new MiningScore<V>(value){

            @Override
            public Collection<? extends SegmentResult> getSegmentResults() {
                return segmentResults;
            }
        };
        return TargetUtil.evaluateRegression(targetField, result);
    }

    @Override
    protected <V extends Number> Map<FieldName, ?> evaluateClassification(ValueFactory<V> valueFactory, EvaluationContext context) {
        MiningProbabilityDistribution result;
        MiningModel miningModel = (MiningModel)this.getModel();
        final List<SegmentResult> segmentResults = this.evaluateSegmentation((MiningModelEvaluationContext)context);
        Map<FieldName, ?> predictions = this.getSegmentationResult(CLASSIFICATION_METHODS, segmentResults);
        if (predictions != null) {
            return predictions;
        }
        TargetField targetField = this.getTargetField();
        Segmentation segmentation = miningModel.getSegmentation();
        Segmentation.MultipleModelMethod multipleModelMethod = segmentation.getMultipleModelMethod();
        Segmentation.MissingPredictionTreatment missingPredictionTreatment = segmentation.getMissingPredictionTreatment();
        Number missingThreshold = segmentation.getMissingThreshold();
        if (missingThreshold.doubleValue() < 0.0 || missingThreshold.doubleValue() > 1.0) {
            throw new InvalidAttributeException((PMMLObject)segmentation, PMMLAttributes.SEGMENTATION_MISSINGTHRESHOLD, missingThreshold);
        }
        switch (multipleModelMethod) {
            case MAJORITY_VOTE: 
            case WEIGHTED_MAJORITY_VOTE: {
                ValueMap<Object, V> values = MiningModelUtil.aggregateVotes(valueFactory, multipleModelMethod, missingPredictionTreatment, missingThreshold, segmentResults);
                if (values == null) {
                    return TargetUtil.evaluateClassificationDefault(valueFactory, targetField);
                }
                ValueUtil.normalizeSimpleMax(values);
                result = new MiningProbabilityDistribution<V>(values){

                    @Override
                    public Collection<? extends SegmentResult> getSegmentResults() {
                        return segmentResults;
                    }
                };
                break;
            }
            case AVERAGE: 
            case WEIGHTED_AVERAGE: 
            case MEDIAN: 
            case MAX: {
                List<Object> targetCategories = targetField.getCategories();
                if (targetCategories != null && targetCategories.size() < 2) {
                    throw new InvalidElementException((PMMLObject)miningModel);
                }
                ValueMap<Object, V> values = MiningModelUtil.aggregateProbabilities(valueFactory, multipleModelMethod, missingPredictionTreatment, missingThreshold, targetCategories, segmentResults);
                if (values == null) {
                    return TargetUtil.evaluateClassificationDefault(valueFactory, targetField);
                }
                result = new MiningProbabilityDistribution<V>(values){

                    @Override
                    public Collection<? extends SegmentResult> getSegmentResults() {
                        return segmentResults;
                    }
                };
                break;
            }
            case SELECT_FIRST: 
            case SELECT_ALL: 
            case MODEL_CHAIN: 
            case WEIGHTED_MEDIAN: 
            case SUM: 
            case WEIGHTED_SUM: {
                throw new InvalidAttributeException((PMMLObject)segmentation, (Enum<?>)multipleModelMethod);
            }
            default: {
                throw new UnsupportedAttributeException((PMMLObject)segmentation, (Enum<?>)multipleModelMethod);
            }
        }
        return TargetUtil.evaluateClassification(targetField, result);
    }

    @Override
    protected <V extends Number> Map<FieldName, ?> evaluateClustering(ValueFactory<V> valueFactory, EvaluationContext context) {
        MiningVoteDistribution result;
        MiningModel miningModel = (MiningModel)this.getModel();
        final List<SegmentResult> segmentResults = this.evaluateSegmentation((MiningModelEvaluationContext)context);
        Map<FieldName, ?> predictions = this.getSegmentationResult(CLUSTERING_METHODS, segmentResults);
        if (predictions != null) {
            return predictions;
        }
        Segmentation segmentation = miningModel.getSegmentation();
        Segmentation.MultipleModelMethod multipleModelMethod = segmentation.getMultipleModelMethod();
        Segmentation.MissingPredictionTreatment missingPredictionTreatment = segmentation.getMissingPredictionTreatment();
        Number missingThreshold = segmentation.getMissingThreshold();
        if (missingThreshold.doubleValue() < 0.0 || missingThreshold.doubleValue() > 1.0) {
            throw new InvalidAttributeException((PMMLObject)segmentation, PMMLAttributes.SEGMENTATION_MISSINGTHRESHOLD, missingThreshold);
        }
        switch (multipleModelMethod) {
            case MAJORITY_VOTE: 
            case WEIGHTED_MAJORITY_VOTE: {
                ValueMap<Object, V> values = MiningModelUtil.aggregateVotes(valueFactory, multipleModelMethod, missingPredictionTreatment, missingThreshold, segmentResults);
                if (values == null) {
                    return Collections.singletonMap(this.getTargetName(), null);
                }
                result = new MiningVoteDistribution<V>(values){

                    @Override
                    public Collection<? extends SegmentResult> getSegmentResults() {
                        return segmentResults;
                    }
                };
                break;
            }
            case SELECT_FIRST: 
            case SELECT_ALL: 
            case MODEL_CHAIN: 
            case AVERAGE: 
            case WEIGHTED_AVERAGE: 
            case MEDIAN: 
            case WEIGHTED_MEDIAN: 
            case SUM: 
            case WEIGHTED_SUM: 
            case MAX: {
                throw new InvalidAttributeException((PMMLObject)segmentation, (Enum<?>)multipleModelMethod);
            }
            default: {
                throw new UnsupportedAttributeException((PMMLObject)segmentation, (Enum<?>)multipleModelMethod);
            }
        }
        result.computeResult(DataType.STRING);
        return Collections.singletonMap(this.getTargetName(), result);
    }

    @Override
    protected <V extends Number> Map<FieldName, ?> evaluateAssociationRules(ValueFactory<V> valueFactory, EvaluationContext context) {
        return this.evaluateAny(valueFactory, context);
    }

    @Override
    protected <V extends Number> Map<FieldName, ?> evaluateMixed(ValueFactory<V> valueFactory, EvaluationContext context) {
        return this.evaluateAny(valueFactory, context);
    }

    private <V extends Number> Map<FieldName, ?> evaluateAny(ValueFactory<V> valueFactory, EvaluationContext context) {
        List<SegmentResult> segmentResults = this.evaluateSegmentation((MiningModelEvaluationContext)context);
        return this.getSegmentationResult(Collections.emptySet(), segmentResults);
    }

    private List<SegmentResult> evaluateSegmentation(MiningModelEvaluationContext context) {
        MiningModel miningModel = (MiningModel)this.getModel();
        BiMap<String, Segment> entityRegistry = this.getEntityRegistry();
        MiningFunction miningFunction = miningModel.getMiningFunction();
        Segmentation segmentation = miningModel.getSegmentation();
        Segmentation.MultipleModelMethod multipleModelMethod = segmentation.getMultipleModelMethod();
        Model lastModel = null;
        ModelEvaluationContext miningModelContext = null;
        ModelEvaluationContext modelContext = null;
        List segments = segmentation.getSegments();
        ArrayList<SegmentResult> segmentResults = new ArrayList<SegmentResult>(segments.size());
        int max = segments.size();
        for (int i = 0; i < max; ++i) {
            Map<FieldName, ?> results;
            ModelEvaluationContext segmentContext;
            Segment segment = (Segment)segments.get(i);
            Boolean status = PredicateUtil.evaluatePredicateContainer(segment, context);
            if (status == null || !status.booleanValue()) continue;
            Model model = segment.getModel();
            if (model == null) {
                throw new MissingElementException(MissingElementException.formatMessage(XPathUtil.formatElement(segment.getClass()) + "/<Model>"), (PMMLObject)segment);
            }
            switch (multipleModelMethod) {
                case MODEL_CHAIN: {
                    break;
                }
                default: {
                    MiningModelEvaluator.checkMiningFunction(model, miningFunction);
                }
            }
            final String segmentId = EntityUtil.getId(segment, entityRegistry);
            final ModelEvaluator<?> segmentModelEvaluator = this.ensureSegmentModelEvaluator(segmentId, model);
            if (segmentModelEvaluator instanceof MiningModelEvaluator) {
                if (miningModelContext == null) {
                    miningModelContext = (MiningModelEvaluationContext)segmentModelEvaluator.createEvaluationContext();
                    miningModelContext.setParent(context);
                } else {
                    miningModelContext.setModelEvaluator(segmentModelEvaluator);
                }
                segmentContext = miningModelContext;
            } else {
                if (modelContext == null) {
                    modelContext = segmentModelEvaluator.createEvaluationContext();
                    modelContext.setParent(context);
                } else {
                    modelContext.setModelEvaluator(segmentModelEvaluator);
                }
                segmentContext = modelContext;
            }
            try {
                results = segmentModelEvaluator.evaluateInternal(segmentContext);
            }
            catch (PMMLException pe) {
                throw pe.ensureContext((PMMLObject)segment);
            }
            SegmentResult segmentResult = new SegmentResult(segment, results){

                @Override
                public String getEntityId() {
                    return segmentId;
                }

                @Override
                protected ModelEvaluator<?> getModelEvaluator() {
                    return segmentModelEvaluator;
                }
            };
            context.putResult(segmentId, segmentResult);
            switch (multipleModelMethod) {
                case MODEL_CHAIN: {
                    Object segmentModel = segmentModelEvaluator.getModel();
                    Output segmentOutput = segmentModel.getOutput();
                    if (segmentOutput == null || !segmentOutput.hasOutputFields()) break;
                    List pmmlSegmentOutputFields = segmentOutput.getOutputFields();
                    for (org.dmg.pmml.OutputField pmmlSegmentOutputField : pmmlSegmentOutputFields) {
                        FieldValue value;
                        FieldName name = pmmlSegmentOutputField.getName();
                        if (name == null) {
                            throw new MissingAttributeException((PMMLObject)pmmlSegmentOutputField, org.dmg.pmml.PMMLAttributes.OUTPUTFIELD_NAME);
                        }
                        context.putOutputField(name, pmmlSegmentOutputField);
                        try {
                            value = segmentContext.lookup(name);
                        }
                        catch (MissingValueException mve) {
                            throw mve.ensureContext((PMMLObject)segment);
                        }
                        context.declare(name, value);
                    }
                    break;
                }
            }
            List<String> segmentWarnings = segmentContext.getWarnings();
            if (!segmentWarnings.isEmpty()) {
                for (String segmentWarning : segmentWarnings) {
                    context.addWarning(segmentWarning);
                }
            }
            boolean clearValues = !segmentModelEvaluator.isPure();
            segmentContext.reset(clearValues);
            switch (multipleModelMethod) {
                case SELECT_FIRST: {
                    return Collections.singletonList(segmentResult);
                }
                case MODEL_CHAIN: {
                    lastModel = model;
                }
            }
            segmentResults.add(segmentResult);
        }
        switch (multipleModelMethod) {
            case MODEL_CHAIN: {
                if (lastModel == null) break;
                MiningModelEvaluator.checkMiningFunction(lastModel, miningFunction);
                break;
            }
        }
        return segmentResults;
    }

    private Map<FieldName, ?> getSegmentationResult(Set<Segmentation.MultipleModelMethod> multipleModelMethods, List<SegmentResult> segmentResults) {
        MiningModel miningModel = (MiningModel)this.getModel();
        Segmentation segmentation = miningModel.getSegmentation();
        Segmentation.MultipleModelMethod multipleModelMethod = segmentation.getMultipleModelMethod();
        switch (multipleModelMethod) {
            case SELECT_FIRST: {
                if (segmentResults.isEmpty()) break;
                return (Map)((Object)segmentResults.get(0));
            }
            case SELECT_ALL: {
                return MiningModelEvaluator.selectAll(segmentResults);
            }
            case MODEL_CHAIN: {
                if (segmentResults.isEmpty()) break;
                return (Map)((Object)segmentResults.get(segmentResults.size() - 1));
            }
            default: {
                if (multipleModelMethods.contains(multipleModelMethod)) break;
                throw new UnsupportedAttributeException((PMMLObject)segmentation, (Enum<?>)multipleModelMethod);
            }
        }
        if (segmentResults.isEmpty()) {
            return Collections.singletonMap(this.getTargetName(), null);
        }
        return null;
    }

    private List<Segment> getActiveHead(List<Segment> segments) {
        int max = segments.size();
        for (int i = 0; i < max; ++i) {
            Segment segment = segments.get(i);
            Predicate predicate = PredicateUtil.ensurePredicate(segment);
            if (!(predicate instanceof True)) continue;
            return segments.subList(0, i + 1);
        }
        return segments;
    }

    private List<Segment> getActiveTail(List<Segment> segments) {
        return Lists.reverse(this.getActiveHead(Lists.reverse(segments)));
    }

    private List<OutputField> createNestedOutputFields() {
        MiningModel miningModel = (MiningModel)this.getModel();
        Segmentation segmentation = miningModel.getSegmentation();
        List segments = segmentation.getSegments();
        Segmentation.MultipleModelMethod multipleModelMethod = segmentation.getMultipleModelMethod();
        switch (multipleModelMethod) {
            case SELECT_FIRST: {
                return this.createNestedOutputFields(this.getActiveHead(segments));
            }
            case SELECT_ALL: {
                break;
            }
            case MODEL_CHAIN: {
                return this.createNestedOutputFields(this.getActiveTail(segments));
            }
        }
        return Collections.emptyList();
    }

    private List<OutputField> createNestedOutputFields(List<Segment> segments) {
        ArrayList<OutputField> result = new ArrayList<OutputField>();
        BiMap<String, Segment> entityRegistry = this.getEntityRegistry();
        int max = segments.size();
        for (int i = 0; i < max; ++i) {
            Segment segment = segments.get(i);
            Model model = segment.getModel();
            if (model == null) {
                throw new MissingElementException(MissingElementException.formatMessage(XPathUtil.formatElement(segment.getClass()) + "/<Model>"), (PMMLObject)segment);
            }
            String segmentId = EntityUtil.getId(segment, entityRegistry);
            ModelEvaluator<?> segmentModelEvaluator = this.ensureSegmentModelEvaluator(segmentId, model);
            List<OutputField> outputFields = segmentModelEvaluator.getOutputFields();
            for (OutputField outputField : outputFields) {
                OutputField nestedOutputField = new OutputField(outputField.getField(), outputField.getDepth() + 1);
                result.add(nestedOutputField);
            }
        }
        return ImmutableList.copyOf(result);
    }

    private ModelEvaluator<?> ensureSegmentModelEvaluator(String segmentId, Model model) {
        ModelEvaluator<?> segmentModelEvaluator = (ModelEvaluator<?>)this.segmentModelEvaluators.get(segmentId);
        if (segmentModelEvaluator == null) {
            segmentModelEvaluator = this.createSegmentModelEvaluator(segmentId, model);
            this.segmentModelEvaluators.putIfAbsent(segmentId, segmentModelEvaluator);
        }
        return segmentModelEvaluator;
    }

    private ModelEvaluator<?> createSegmentModelEvaluator(String segmentId, Model model) {
        MiningModel miningModel = (MiningModel)this.getModel();
        MiningFunction miningFunction = miningModel.getMiningFunction();
        Segmentation segmentation = miningModel.getSegmentation();
        EnumSet<ResultFeature> extraResultFeatures = EnumSet.noneOf(ResultFeature.class);
        Segmentation.MultipleModelMethod multipleModelMethod = segmentation.getMultipleModelMethod();
        block0 : switch (multipleModelMethod) {
            case SELECT_FIRST: 
            case SELECT_ALL: 
            case MODEL_CHAIN: {
                Set<ResultFeature> resultFeatures = this.getResultFeatures();
                if (resultFeatures.isEmpty()) break;
                extraResultFeatures.addAll(resultFeatures);
                break;
            }
            case AVERAGE: 
            case WEIGHTED_AVERAGE: 
            case MEDIAN: 
            case MAX: {
                switch (miningFunction) {
                    case CLASSIFICATION: {
                        extraResultFeatures.add(ResultFeature.PROBABILITY);
                        break block0;
                    }
                }
                break;
            }
        }
        Set<ResultFeature> segmentResultFeatures = this.getSegmentResultFeatures(segmentId);
        if (segmentResultFeatures != null && !segmentResultFeatures.isEmpty()) {
            extraResultFeatures.addAll(segmentResultFeatures);
        }
        Configuration configuration = this.ensureConfiguration();
        ModelEvaluatorFactory modelEvaluatorFactory = configuration.getModelEvaluatorFactory();
        ModelEvaluator<?> modelEvaluator = modelEvaluatorFactory.newModelEvaluator(this.getPMML(), model, extraResultFeatures);
        MiningFunction segmentMiningFunction = model.getMiningFunction();
        if (MiningFunction.CLASSIFICATION.equals((Object)miningFunction) && MiningFunction.CLASSIFICATION.equals((Object)segmentMiningFunction)) {
            List<TargetField> targetFields = this.getTargetFields();
            List<TargetField> segmentTargetFields = modelEvaluator.getTargetFields();
            if (targetFields.size() == 1 && segmentTargetFields.size() == 1) {
                TargetField targetField = targetFields.get(0);
                TargetField segmentTargetField = segmentTargetFields.get(0);
                if (segmentTargetField instanceof DefaultTargetField) {
                    DefaultTargetField defaultTargetField = (DefaultTargetField)segmentTargetField;
                    modelEvaluator.setDefaultDataField(new DataField(Evaluator.DEFAULT_TARGET_NAME, OpType.CATEGORICAL, targetField.getDataType()));
                }
            }
        }
        modelEvaluator.configure(configuration);
        return modelEvaluator;
    }

    private static Map<FieldName, ?> selectAll(List<SegmentResult> segmentResults) {
        ArrayListMultimap result = ArrayListMultimap.create();
        LinkedHashSet keys = null;
        for (SegmentResult segmentResult : segmentResults) {
            if (keys == null) {
                keys = new LinkedHashSet(segmentResult.keySet());
            }
            if (!keys.equals(segmentResult.keySet())) {
                Function<Object, String> function = new Function<Object, String>(){

                    public String apply(Object object) {
                        return PMMLException.formatKey(object);
                    }
                };
                throw new EvaluationException("Field sets " + Iterables.transform(keys, (Function)function) + " and " + Iterables.transform((Iterable)segmentResult.keySet(), (Function)function) + " do not match");
            }
            for (FieldName key : keys) {
                result.put((Object)key, segmentResult.get(key));
            }
        }
        return Multimaps.asMap((ListMultimap)result);
    }

    private static void checkMiningFunction(Model model, MiningFunction parentMiningFunction) {
        MiningFunction miningFunction = model.getMiningFunction();
        if (miningFunction == null) {
            throw new MissingAttributeException(MissingAttributeException.formatMessage(XPathUtil.formatElement(model.getClass()) + "@functionName"), (PMMLObject)model);
        }
        if (!miningFunction.equals((Object)parentMiningFunction)) {
            throw new InvalidAttributeException(InvalidAttributeException.formatMessage(XPathUtil.formatElement(model.getClass()) + "@functionName=" + miningFunction.value()), (PMMLObject)model);
        }
    }
}

