/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import org.dmg.pmml.DataType;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.Numbers;
import org.jpmml.evaluator.TypeUtil;

public abstract class ScalarValue
extends FieldValue
implements Comparable<ScalarValue> {
    private boolean valid = true;

    ScalarValue() {
    }

    ScalarValue(DataType dataType, Object value) {
        super(dataType, ScalarValue.filterValue(TypeUtil.parseOrCast(dataType, value)));
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    void setValid(boolean valid) {
        this.valid = valid;
    }

    @Override
    public int compareToValue(Object value) {
        value = TypeUtil.parseOrCast(this.getDataType(), value);
        return ((Comparable)this.getValue()).compareTo(value);
    }

    @Override
    public int compareToValue(FieldValue value) {
        if (value instanceof ScalarValue) {
            ScalarValue that = (ScalarValue)value;
            if (this.getDataType().equals((Object)that.getDataType())) {
                return ((Comparable)this.getValue()).compareTo(that.getValue());
            }
        }
        return this.compareToValue(value.getValue());
    }

    @Override
    public boolean equalsValue(FieldValue value) {
        if (value instanceof ScalarValue) {
            ScalarValue that = (ScalarValue)value;
            if (this.getDataType().equals((Object)that.getDataType())) {
                return this.getValue().equals(that.getValue());
            }
        }
        return super.equalsValue(value);
    }

    @Override
    public int compareTo(ScalarValue that) {
        if (!this.getOpType().equals((Object)that.getOpType()) || !this.getDataType().equals((Object)that.getDataType())) {
            throw new ClassCastException();
        }
        return this.compareToValue(that);
    }

    private static Object filterValue(Object value) {
        if (value instanceof Float) {
            return ScalarValue.filterValue((Float)value);
        }
        if (value instanceof Double) {
            return ScalarValue.filterValue((Double)value);
        }
        return value;
    }

    private static Float filterValue(Float value) {
        if (value.doubleValue() == 0.0) {
            return Numbers.FLOAT_ZERO;
        }
        return value;
    }

    private static Double filterValue(Double value) {
        if (value == 0.0) {
            return Numbers.DOUBLE_ZERO;
        }
        return value;
    }
}

