/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.dmg.pmml.Model;
import org.dmg.pmml.PMML;
import org.dmg.pmml.PMMLObject;
import org.jpmml.evaluator.MissingElementException;
import org.jpmml.model.XPathUtil;

public class PMMLUtil {
    private PMMLUtil() {
    }

    public static Model findModel(PMML pmml, String modelName) {
        Model model = modelName != null ? PMMLUtil.findModel(pmml, object -> Objects.equals(object.getModelName(), modelName), "<Model>@modelName=" + modelName) : PMMLUtil.findModel(pmml, object -> object.isScorable(), "<Model>@isScorable=true");
        return model;
    }

    public static <M extends Model> M findModel(PMML pmml, Class<? extends M> clazz) {
        Model model = PMMLUtil.findModel(pmml, object -> clazz.isInstance(object) && object.isScorable(), XPathUtil.formatElement(clazz) + "@isScorable=true");
        return (M)((Model)clazz.cast(model));
    }

    public static Model findModel(PMML pmml, Predicate<Model> predicate, String predicateXPath) {
        if (!pmml.hasModels()) {
            throw new MissingElementException(MissingElementException.formatMessage(XPathUtil.formatElement(pmml.getClass()) + "/" + predicateXPath), (PMMLObject)pmml);
        }
        List models = pmml.getModels();
        Optional<Model> result = models.stream().filter(predicate).findAny();
        if (!result.isPresent()) {
            throw new MissingElementException(MissingElementException.formatMessage(XPathUtil.formatElement(pmml.getClass()) + "/" + predicateXPath), (PMMLObject)pmml);
        }
        return result.get();
    }
}

