/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import org.dmg.pmml.DataDictionary;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DefineFunction;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Field;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.MathContext;
import org.dmg.pmml.MiningField;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.Model;
import org.dmg.pmml.OpType;
import org.dmg.pmml.Output;
import org.dmg.pmml.PMML;
import org.dmg.pmml.PMMLAttributes;
import org.dmg.pmml.PMMLElements;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.ResultFeature;
import org.dmg.pmml.Target;
import org.dmg.pmml.Targets;
import org.dmg.pmml.TransformationDictionary;
import org.dmg.pmml.Visitable;
import org.jpmml.evaluator.CacheUtil;
import org.jpmml.evaluator.DefaultTargetField;
import org.jpmml.evaluator.DuplicateFieldException;
import org.jpmml.evaluator.EvaluationException;
import org.jpmml.evaluator.Evaluator;
import org.jpmml.evaluator.HasModel;
import org.jpmml.evaluator.IndexableUtil;
import org.jpmml.evaluator.InputField;
import org.jpmml.evaluator.InvisibleFieldException;
import org.jpmml.evaluator.MissingAttributeException;
import org.jpmml.evaluator.MissingElementException;
import org.jpmml.evaluator.MissingFieldException;
import org.jpmml.evaluator.OutputField;
import org.jpmml.evaluator.ResidualInputField;
import org.jpmml.evaluator.TargetField;
import org.jpmml.evaluator.UnsupportedElementException;
import org.jpmml.evaluator.VariableField;
import org.jpmml.model.XPathUtil;
import org.jpmml.model.visitors.FieldResolver;

public abstract class ModelManager<M extends Model>
implements HasModel<M>,
Serializable {
    private PMML pmml = null;
    private M model = null;
    private DataField defaultDataField = null;
    private Map<FieldName, DataField> dataFields = Collections.emptyMap();
    private Map<FieldName, DerivedField> derivedFields = Collections.emptyMap();
    private Map<String, DefineFunction> defineFunctions = Collections.emptyMap();
    private Map<FieldName, MiningField> miningFields = Collections.emptyMap();
    private Map<FieldName, DerivedField> localDerivedFields = Collections.emptyMap();
    private Map<FieldName, Target> targets = Collections.emptyMap();
    private Map<FieldName, org.dmg.pmml.OutputField> outputFields = Collections.emptyMap();
    private Set<ResultFeature> resultFeatures = Collections.emptySet();
    private List<InputField> inputFields = null;
    private List<InputField> activeInputFields = null;
    private List<TargetField> targetResultFields = null;
    private List<OutputField> outputResultFields = null;
    private ListMultimap<FieldName, Field<?>> visibleFields = null;
    private static final DataField DEFAULT_TARGET_CONTINUOUS_FLOAT = new DataField(Evaluator.DEFAULT_TARGET_NAME, OpType.CONTINUOUS, DataType.FLOAT);
    private static final DataField DEFAULT_TARGET_CONTINUOUS_DOUBLE = new DataField(Evaluator.DEFAULT_TARGET_NAME, OpType.CONTINUOUS, DataType.DOUBLE);
    private static final DataField DEFAULT_TARGET_CATEGORICAL_STRING = new DataField(Evaluator.DEFAULT_TARGET_NAME, OpType.CATEGORICAL, DataType.STRING);
    private static final LoadingCache<DataDictionary, Map<FieldName, DataField>> dataFieldCache = CacheUtil.buildLoadingCache(new CacheLoader<DataDictionary, Map<FieldName, DataField>>(){

        public Map<FieldName, DataField> load(DataDictionary dataDictionary) {
            return ImmutableMap.copyOf(IndexableUtil.buildMap(dataDictionary.getDataFields()));
        }
    });
    private static final LoadingCache<TransformationDictionary, Map<FieldName, DerivedField>> derivedFieldCache = CacheUtil.buildLoadingCache(new CacheLoader<TransformationDictionary, Map<FieldName, DerivedField>>(){

        public Map<FieldName, DerivedField> load(TransformationDictionary transformationDictionary) {
            return ImmutableMap.copyOf(IndexableUtil.buildMap(transformationDictionary.getDerivedFields()));
        }
    });
    private static final LoadingCache<TransformationDictionary, Map<String, DefineFunction>> defineFunctionCache = CacheUtil.buildLoadingCache(new CacheLoader<TransformationDictionary, Map<String, DefineFunction>>(){

        public Map<String, DefineFunction> load(TransformationDictionary transformationDictionary) {
            return ImmutableMap.copyOf(IndexableUtil.buildMap(transformationDictionary.getDefineFunctions()));
        }
    });
    private static final LoadingCache<MiningSchema, Map<FieldName, MiningField>> miningFieldCache = CacheUtil.buildLoadingCache(new CacheLoader<MiningSchema, Map<FieldName, MiningField>>(){

        public Map<FieldName, MiningField> load(MiningSchema miningSchema) {
            return ImmutableMap.copyOf(IndexableUtil.buildMap(miningSchema.getMiningFields()));
        }
    });
    private static final LoadingCache<LocalTransformations, Map<FieldName, DerivedField>> localDerivedFieldCache = CacheUtil.buildLoadingCache(new CacheLoader<LocalTransformations, Map<FieldName, DerivedField>>(){

        public Map<FieldName, DerivedField> load(LocalTransformations localTransformations) {
            return ImmutableMap.copyOf(IndexableUtil.buildMap(localTransformations.getDerivedFields()));
        }
    });
    private static final LoadingCache<Targets, Map<FieldName, Target>> targetCache = CacheUtil.buildLoadingCache(new CacheLoader<Targets, Map<FieldName, Target>>(){

        public Map<FieldName, Target> load(Targets targets) {
            return Collections.unmodifiableMap(IndexableUtil.buildMap(targets.getTargets(), true));
        }
    });
    private static final LoadingCache<Output, Map<FieldName, org.dmg.pmml.OutputField>> outputFieldCache = CacheUtil.buildLoadingCache(new CacheLoader<Output, Map<FieldName, org.dmg.pmml.OutputField>>(){

        public Map<FieldName, org.dmg.pmml.OutputField> load(Output output) {
            return ImmutableMap.copyOf(IndexableUtil.buildMap(output.getOutputFields()));
        }
    });
    static final LoadingCache<Output, Set<ResultFeature>> resultFeaturesCache = CacheUtil.buildLoadingCache(new CacheLoader<Output, Set<ResultFeature>>(){

        public Set<ResultFeature> load(Output output) {
            EnumSet<ResultFeature> result = EnumSet.noneOf(ResultFeature.class);
            List pmmlOutputFields = output.getOutputFields();
            for (org.dmg.pmml.OutputField pmmlOutputField : pmmlOutputFields) {
                String segmentId = pmmlOutputField.getSegmentId();
                if (segmentId != null) continue;
                result.add(pmmlOutputField.getResultFeature());
            }
            return Sets.immutableEnumSet(result);
        }
    });

    protected ModelManager() {
    }

    protected ModelManager(PMML pmml, M model) {
        Output output;
        Targets targets;
        LocalTransformations localTransformations;
        MiningFunction miningFunction;
        TransformationDictionary transformationDictionary;
        this.setPMML(Objects.requireNonNull(pmml));
        this.setModel((Model)Objects.requireNonNull(model));
        DataDictionary dataDictionary = pmml.getDataDictionary();
        if (dataDictionary == null) {
            throw new MissingElementException((PMMLObject)pmml, PMMLElements.PMML_DATADICTIONARY);
        }
        if (dataDictionary.hasDataFields()) {
            this.dataFields = CacheUtil.getValue(dataDictionary, dataFieldCache);
        }
        if ((transformationDictionary = pmml.getTransformationDictionary()) != null && transformationDictionary.hasDerivedFields()) {
            this.derivedFields = CacheUtil.getValue(transformationDictionary, derivedFieldCache);
        }
        if (transformationDictionary != null && transformationDictionary.hasDefineFunctions()) {
            this.defineFunctions = CacheUtil.getValue(transformationDictionary, defineFunctionCache);
        }
        if ((miningFunction = model.getMiningFunction()) == null) {
            throw new MissingAttributeException(MissingAttributeException.formatMessage(XPathUtil.formatElement(model.getClass()) + "@functionName"), (PMMLObject)model);
        }
        MiningSchema miningSchema = model.getMiningSchema();
        if (miningSchema == null) {
            throw new MissingElementException(MissingElementException.formatMessage(XPathUtil.formatElement(model.getClass()) + "/" + XPathUtil.formatElement(MiningSchema.class)), (PMMLObject)model);
        }
        if (miningSchema.hasMiningFields()) {
            List miningFields = miningSchema.getMiningFields();
            for (MiningField miningField : miningFields) {
                FieldName name = miningField.getName();
                if (name != null) continue;
                throw new MissingAttributeException((PMMLObject)miningField, PMMLAttributes.MININGFIELD_NAME);
            }
            this.miningFields = CacheUtil.getValue(miningSchema, miningFieldCache);
        }
        if ((localTransformations = model.getLocalTransformations()) != null && localTransformations.hasDerivedFields()) {
            this.localDerivedFields = CacheUtil.getValue(localTransformations, localDerivedFieldCache);
        }
        if ((targets = model.getTargets()) != null && targets.hasTargets()) {
            this.targets = CacheUtil.getValue(targets, targetCache);
        }
        if ((output = model.getOutput()) != null && output.hasOutputFields()) {
            this.outputFields = CacheUtil.getValue(output, outputFieldCache);
            this.resultFeatures = CacheUtil.getValue(output, resultFeaturesCache);
        }
    }

    public MiningFunction getMiningFunction() {
        M model = this.getModel();
        return model.getMiningFunction();
    }

    public MathContext getMathContext() {
        M model = this.getModel();
        return model.getMathContext();
    }

    public DataField getDataField(FieldName name) {
        if (Objects.equals(Evaluator.DEFAULT_TARGET_NAME, name)) {
            return this.getDefaultDataField();
        }
        return this.dataFields.get(name);
    }

    public DataField getDefaultDataField() {
        if (this.defaultDataField != null) {
            return this.defaultDataField;
        }
        MiningFunction miningFunction = this.getMiningFunction();
        switch (miningFunction) {
            case REGRESSION: {
                MathContext mathContext = this.getMathContext();
                switch (mathContext) {
                    case FLOAT: {
                        return DEFAULT_TARGET_CONTINUOUS_FLOAT;
                    }
                }
                return DEFAULT_TARGET_CONTINUOUS_DOUBLE;
            }
            case CLASSIFICATION: 
            case CLUSTERING: {
                return DEFAULT_TARGET_CATEGORICAL_STRING;
            }
        }
        return null;
    }

    public void setDefaultDataField(DataField defaultDataField) {
        this.defaultDataField = defaultDataField;
    }

    public DerivedField getDerivedField(FieldName name) {
        return this.derivedFields.get(name);
    }

    public DefineFunction getDefineFunction(String name) {
        return this.defineFunctions.get(name);
    }

    public MiningField getMiningField(FieldName name) {
        if (Objects.equals(Evaluator.DEFAULT_TARGET_NAME, name)) {
            return null;
        }
        return this.miningFields.get(name);
    }

    protected boolean hasLocalDerivedFields() {
        return !this.localDerivedFields.isEmpty();
    }

    public DerivedField getLocalDerivedField(FieldName name) {
        return this.localDerivedFields.get(name);
    }

    public Target getTarget(FieldName name) {
        return this.targets.get(name);
    }

    protected boolean hasOutputFields() {
        return !this.outputFields.isEmpty();
    }

    public org.dmg.pmml.OutputField getOutputField(FieldName name) {
        return this.outputFields.get(name);
    }

    public boolean hasResultFeature(ResultFeature resultFeature) {
        Set<ResultFeature> resultFeatures = this.getResultFeatures();
        return resultFeatures.contains(resultFeature);
    }

    public void addResultFeatures(Set<ResultFeature> resultFeatures) {
        this.resultFeatures = Sets.immutableEnumSet((Iterable)Iterables.concat(this.resultFeatures, resultFeatures));
    }

    protected Set<ResultFeature> getResultFeatures() {
        return this.resultFeatures;
    }

    public List<InputField> getInputFields() {
        if (this.inputFields == null) {
            this.inputFields = this.createInputFields();
        }
        return this.inputFields;
    }

    public List<InputField> getActiveFields() {
        if (this.activeInputFields == null) {
            this.activeInputFields = this.createInputFields(MiningField.UsageType.ACTIVE);
        }
        return this.activeInputFields;
    }

    public List<TargetField> getTargetFields() {
        if (this.targetResultFields == null) {
            this.targetResultFields = this.createTargetFields();
        }
        return this.targetResultFields;
    }

    public TargetField getTargetField() {
        List<TargetField> targetFields = this.getTargetFields();
        if (targetFields.size() != 1) {
            throw this.createMiningSchemaException("Expected 1 target field, got " + targetFields.size() + " target fields");
        }
        TargetField targetField = targetFields.get(0);
        return targetField;
    }

    public FieldName getTargetName() {
        TargetField targetField = this.getTargetField();
        return targetField.getFieldName();
    }

    TargetField findTargetField(FieldName name) {
        List<TargetField> targetFields = this.getTargetFields();
        for (TargetField targetField : targetFields) {
            if (!Objects.equals(targetField.getFieldName(), name)) continue;
            return targetField;
        }
        return null;
    }

    public List<OutputField> getOutputFields() {
        if (this.outputResultFields == null) {
            this.outputResultFields = this.createOutputFields();
        }
        return this.outputResultFields;
    }

    protected void resetInputFields() {
        this.inputFields = null;
        this.activeInputFields = null;
    }

    protected void resetResultFields() {
        this.targetResultFields = null;
        this.outputResultFields = null;
    }

    protected Field<?> resolveField(FieldName name) {
        ListMultimap<FieldName, Field<?>> visibleFields = this.getVisibleFields();
        List fields = visibleFields.get((Object)name);
        if (fields.isEmpty()) {
            return null;
        }
        if (fields.size() == 1) {
            return (Field)fields.get(0);
        }
        throw new DuplicateFieldException(name);
    }

    protected ListMultimap<FieldName, Field<?>> getVisibleFields() {
        if (this.visibleFields == null) {
            this.visibleFields = this.collectVisibleFields();
        }
        return this.visibleFields;
    }

    protected EvaluationException createMiningSchemaException(String message) {
        M model = this.getModel();
        MiningSchema miningSchema = model.getMiningSchema();
        return new EvaluationException(message, (PMMLObject)miningSchema);
    }

    protected List<InputField> createInputFields() {
        ImmutableList inputFields = this.getActiveFields();
        List<OutputField> outputFields = this.getOutputFields();
        if (!outputFields.isEmpty()) {
            ArrayList<ResidualInputField> residualInputFields = null;
            for (OutputField outputField : outputFields) {
                DataField dataField;
                org.dmg.pmml.OutputField pmmlOutputField = outputField.getField();
                if (!ResultFeature.RESIDUAL.equals((Object)pmmlOutputField.getResultFeature())) continue;
                int depth = outputField.getDepth();
                if (depth > 0) {
                    throw new UnsupportedElementException((PMMLObject)pmmlOutputField);
                }
                FieldName targetName = pmmlOutputField.getTargetField();
                if (targetName == null) {
                    targetName = this.getTargetName();
                }
                if ((dataField = this.getDataField(targetName)) == null) {
                    throw new MissingFieldException(targetName, (PMMLObject)pmmlOutputField);
                }
                MiningField miningField = this.getMiningField(targetName);
                if (miningField == null) {
                    throw new InvisibleFieldException(targetName, (PMMLObject)pmmlOutputField);
                }
                ResidualInputField residualInputField = new ResidualInputField(dataField, miningField);
                if (residualInputFields == null) {
                    residualInputFields = new ArrayList<ResidualInputField>();
                }
                residualInputFields.add(residualInputField);
            }
            if (residualInputFields != null && !residualInputFields.isEmpty()) {
                inputFields = ImmutableList.copyOf((Iterable)Iterables.concat(inputFields, (Iterable)residualInputFields));
            }
        }
        return inputFields;
    }

    protected List<InputField> createInputFields(MiningField.UsageType usageType) {
        M model = this.getModel();
        MiningSchema miningSchema = model.getMiningSchema();
        ArrayList<InputField> inputFields = new ArrayList<InputField>();
        if (miningSchema.hasMiningFields()) {
            List miningFields = miningSchema.getMiningFields();
            for (MiningField miningField : miningFields) {
                FieldName name = miningField.getName();
                if (!miningField.getUsageType().equals((Object)usageType)) continue;
                Object field = this.getDataField(name);
                if (field == null) {
                    field = new VariableField(name);
                }
                InputField inputField = new InputField((Field<?>)field, miningField);
                inputFields.add(inputField);
            }
        }
        return ImmutableList.copyOf(inputFields);
    }

    protected List<TargetField> createTargetFields() {
        DataField dataField;
        M model = this.getModel();
        MiningSchema miningSchema = model.getMiningSchema();
        ArrayList<TargetField> targetFields = new ArrayList<TargetField>();
        if (miningSchema.hasMiningFields()) {
            List miningFields = miningSchema.getMiningFields();
            block3: for (MiningField miningField : miningFields) {
                FieldName name = miningField.getName();
                MiningField.UsageType usageType = miningField.getUsageType();
                switch (usageType) {
                    case PREDICTED: 
                    case TARGET: {
                        break;
                    }
                    default: {
                        continue block3;
                    }
                }
                DataField dataField2 = this.getDataField(name);
                if (dataField2 == null) {
                    throw new MissingFieldException(name, (PMMLObject)miningField);
                }
                Target target = this.getTarget(name);
                TargetField targetField = new TargetField(dataField2, miningField, target);
                targetFields.add(targetField);
            }
        }
        if (targetFields.isEmpty() && (dataField = this.getDefaultDataField()) != null) {
            Target target = this.getTarget(dataField.getName());
            DefaultTargetField targetField = new DefaultTargetField(dataField, target);
            targetFields.add(targetField);
        }
        return ImmutableList.copyOf(targetFields);
    }

    protected List<OutputField> createOutputFields() {
        M model = this.getModel();
        Output output = model.getOutput();
        ArrayList<OutputField> outputFields = new ArrayList<OutputField>();
        if (output != null && output.hasOutputFields()) {
            List pmmlOutputFields = output.getOutputFields();
            for (org.dmg.pmml.OutputField pmmlOutputField : pmmlOutputFields) {
                OutputField outputField = new OutputField(pmmlOutputField);
                outputFields.add(outputField);
            }
        }
        return ImmutableList.copyOf(outputFields);
    }

    private ListMultimap<FieldName, Field<?>> collectVisibleFields() {
        PMML pmml = this.getPMML();
        M model = this.getModel();
        ArrayListMultimap visibleFields = ArrayListMultimap.create();
        FieldResolver fieldResolver = new FieldResolver((Model)model, (ListMultimap)visibleFields){
            final /* synthetic */ Model val$model;
            final /* synthetic */ ListMultimap val$visibleFields;
            {
                this.val$model = model;
                this.val$visibleFields = listMultimap;
            }

            public PMMLObject popParent() {
                PMMLObject parent = super.popParent();
                if (Objects.equals(this.val$model, parent)) {
                    Model model = (Model)parent;
                    Collection fields = this.getFields(new PMMLObject[]{model});
                    for (Field field : fields) {
                        this.val$visibleFields.put((Object)field.getName(), (Object)field);
                    }
                }
                return parent;
            }
        };
        fieldResolver.applyTo((Visitable)pmml);
        return ImmutableListMultimap.copyOf((Multimap)visibleFields);
    }

    public <V> V getValue(LoadingCache<M, V> cache) {
        M model = this.getModel();
        return CacheUtil.getValue(model, cache);
    }

    public <V> V getValue(Cache<M, V> cache, Callable<? extends V> loader) {
        M model = this.getModel();
        return CacheUtil.getValue(model, cache, loader);
    }

    @Override
    public PMML getPMML() {
        return this.pmml;
    }

    private void setPMML(PMML pmml) {
        this.pmml = pmml;
    }

    @Override
    public M getModel() {
        return this.model;
    }

    private void setModel(M model) {
        this.model = model;
    }
}

