/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.collect.RangeSet;
import java.util.List;
import java.util.Objects;
import org.dmg.pmml.Field;
import org.dmg.pmml.HasContinuousDomain;
import org.dmg.pmml.HasDiscreteDomain;
import org.dmg.pmml.MiningField;
import org.dmg.pmml.OpType;
import org.jpmml.evaluator.FieldUtil;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.InputFieldUtil;
import org.jpmml.evaluator.ModelField;

public class InputField
extends ModelField {
    private MiningField miningField = null;

    InputField() {
    }

    public InputField(Field<?> field, MiningField miningField) {
        super(field);
        this.setMiningField(Objects.requireNonNull(miningField));
        if (!Objects.equals(field.getName(), miningField.getName())) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public OpType getOpType() {
        return FieldUtil.getOpType(this.getField(), this.getMiningField());
    }

    public FieldValue prepare(Object value) {
        return InputFieldUtil.prepareInputValue(this.getField(), this.getMiningField(), value);
    }

    public RangeSet<Double> getContinuousDomain() {
        RangeSet<Double> validRanges;
        Field<?> field = this.getField();
        if (field instanceof HasContinuousDomain && (validRanges = FieldUtil.getValidRanges((Field)((HasContinuousDomain)field))) != null && !validRanges.isEmpty()) {
            return validRanges;
        }
        return null;
    }

    public List<?> getDiscreteDomain() {
        List<?> validValues;
        Field<?> field = this.getField();
        if (field instanceof HasDiscreteDomain && (validValues = FieldUtil.getValidValues((Field)((HasDiscreteDomain)field))) != null && !validValues.isEmpty()) {
            return validValues;
        }
        return null;
    }

    public MiningField getMiningField() {
        return this.miningField;
    }

    private void setMiningField(MiningField miningField) {
        this.miningField = miningField;
    }
}

