from enum import Enum


class CapRegexApha2(Enum):
    IT = ("Italia", "^[0-9]{5}$")
    DZ = ("Algeria", "^[0-9]{5}$")
    BA = ("Bosnia-Erzegovina", "^[0-9]{5}$")
    BR = ("Brasile", "^[0-9]{5}$")
    CR = ("Costa Rica", "^[0-9]{5}$", "^[0-9]{5}-[0-9]{4}$")
    HR = ("Croazia", "^[0-9]{5}$")
    CU = ("Cuba", "^[0-9]{5}$")
    DO = ("Repubblica Dominicana", "^[0-9]{5}$")
    EG = ("Egitto", "^[0-9]{5}$")
    EE = ("Estonia", "^[0-9]{5}$")
    FI = ("Finlandia", "^[0-9]{5}$")
    FR = ("Francia", "^[0-9]{5}$")
    GT = ("Guatemala", "^[0-9]{5}$")
    ID = ("Indonesia", "^[0-9]{5}$")
    IQ = ("Iraq", "^[0-9]{5}$")
    JO = ("Giordania", "^[0-9]{5}$")
    KE = ("Kenya", "^[0-9]{5}$")
    KR = ("Corea del Sud", "^[0-9]{5}$")
    XK = ("Kosovo", "^[0-9]{5}$")
    KW = ("Kuwait", "^[0-9]{5}$")
    LA = ("Laos", "^[0-9]{5}$")
    LB = ("Libano", "^[0-9]{5}$")
    MY = ("Malaysia", "^[0-9]{5}$")
    MV = ("Maldive", "^[0-9]{5}$")
    MH = ("Isole Marshall", "^[0-9]{5}$", "^[0-9]{5}-[0-9]{4}$")
    MU = ("Maurizio", "^[0-9]{5}$")
    MX = ("Messico", "^[0-9]{5}$")
    MN = ("Mongolia", "^[0-9]{5}$")
    ME = ("Montenegro", "^[0-9]{5}$")
    MA = ("Marocco", "^[0-9]{5}$")
    MM = ("Myanmar/Birmania", "^[0-9]{5}$")
    NP = ("Nepal", "^[0-9]{5}$")
    NI = ("Nicaragua", "^[0-9]{5}$")
    PK = ("Pakistan", "^[0-9]{5}$")
    PW = ("Palau", "^[0-9]{5}$", "^[0-9]{5}-[0-9]{4}$")
    PE = ("Perù", "^[0-9]{5}$", "^[A-Z]{2} [0-9]{4}$")
    SA = ("Arabia Saudita", "^[0-9]{5}$", "^[0-9]{5}-[0-9]{4}$")
    SN = ("Senegal", "^[0-9]{5}$")
    RS = ("Serbia", "^[0-9]{5}$")
    ES = ("Spagna", "^[0-9]{5}$")
    LK = ("Sri Lanka", "^[0-9]{5}$")
    SD = ("Sudan", "^[0-9]{5}$")
    TZ = ("Tanzania", "^[0-9]{5}$")
    TH = ("Thailandia", "^[0-9]{5}$")
    TR = ("Turchia", "^[0-9]{5}$")
    UA = ("Ucraina", "^[0-9]{5}$")
    US = ("Stati Uniti d'America", "^[0-9]{5}$", "^[0-9]{5}-[0-9]{4}$")
    UY = ("Uruguay", "^[0-9]{5}$")
    ZM = ("Zambia", "^[0-9]{5}$")
    BH = ("Bahrein", "^[0-9]{3}$", "^[0-9]{4}$")
    GN = ("Guinea", "^[0-9]{3}$")
    IS = ("Islanda", "^[0-9]{3}$")
    JM = ("Giamaica", "^[0-9]{2}$")
    LS = ("Lesotho", "^[0-9]{3}$")
    MG = ("Madagascar", "^[0-9]{3}$")
    OM = ("Oman", "^[0-9]{3}$")
    PS = ("Palestina", "^[0-9]{3}$")
    PG = ("Papua Nuova Guinea", "^[0-9]{3}$")
    AF = ("Afghanistan", "^[0-9]{4}$")
    AR = ("Argentina", "^[0-9]{4}$")
    AM = ("Armenia", "^[0-9]{4}$")
    AU = ("Australia", "^[0-9]{4}$")
    AT = ("Austria", "^[0-9]{4}$")
    BD = ("Bangladesh", "^[0-9]{4}$")
    BE = ("Belgio", "^[0-9]{4}$")
    BG = ("Bulgaria", "^[0-9]{4}$")
    CV = ("Capo Verde", "^[0-9]{4}$")
    CY = ("Cipro", "^[0-9]{4}$")
    DK = ("Danimarca", "^[0-9]{4}$")
    ET = ("Etiopia", "^[0-9]{4}$")
    GE = ("Georgia", "^[0-9]{4}$")
    DE = ("Germania", "^[0-9]{4}$", "^[0-9]{2}$", "^[0-9]{5}$")
    GW = ("Guinea-Bissau", "^[0-9]{4}$")
    HT = ("Haiti", "^[0-9]{4}$")
    HU = ("Ungheria", "^[0-9]{4}$")
    LR = ("Liberia", "^[0-9]{4}$")
    LI = ("Liechtenstein", "^[0-9]{4}$")
    LU = ("Lussemburgo", "^[0-9]{4}$")
    MZ = ("Mozambico", "^[0-9]{4}$")
    NZ = ("Nuova Zelanda", "^[0-9]{4}$")
    MK = ("Macedonia del Nord", "^[0-9]{4}$")
    NO = ("Norvegia", "^[0-9]{4}$")
    PA = ("Panama", "^[0-9]{4}$")
    PY = ("Paraguay", "^[0-9]{4}$")
    PT = ("Portogallo", "^[0-9]{4}$", "^[0-9]{4}-[0-9]{3}$")
    SG = ("Singapore", "^[0-9]{4}$", "^[0-9]{2}$")
    SI = ("Slovenia", "^[0-9]{4}$", "^[A-Z]{2}-[0-9]{4}$")
    ZA = ("Sudafrica", "^[0-9]{4}$")
    CH = ("Svizzera", "^[0-9]{4}$")
    TN = ("Tunisia", "^[0-9]{4}$")
    VE = ("Venezuela", "^[0-9]{4}$")
    BY = ("Bielorussia", "^[0-9]{6}$")
    CN = ("Cina", "^[0-9]{6}$")
    CO = ("Colombia", "^[0-9]{6}$")
    EC = ("Ecuador", "^[0-9]{6}$")
    IN = ("India", "^[0-9]{6}$")
    KZ = ("Kazakhstan", "^[0-9]{6}$")
    KG = ("Kirghizistan", "^[0-9]{6}$")
    NG = ("Nigeria", "^[0-9]{6}$", "^[0-9]{4}$")
    CL = ("Cile", "^[0-9]{7}$", "^[0-9]{3}-[0-9]{4}$")
    IL = ("Israele", "^[0-9]{7}$")
    WS = ("Samoa", "^[0-9]{5}-[0-9]{4}$")
    JP = ("Giappone", "^[0-9]{3}-[0-9]{4}$")
    BN = ("Brunei Darussalam", "^[a-zA-Z]{2}[0-9]{4}$")
    HN = ("Honduras", "^[a-zA-Z]{2}[0-9]{4}$", "^[a-zA-Z]{2}[0-9]{4}$", "^[0-9]{5}$")
    KH = ("Cambogia", "^[0-9]{6}$", "^[1]{1}[2]{1}[0]{4}$")
    CA = ("Canada", "^[a-zA-Z]{1}[0-9]{1}[a-zA-Z]{1} [0-9]{1}[a-zA-Z]{1}[0-9]{1}$")
    GH = ("Ghana", "^[a-zA-Z]{2}-[0-9]{4}-[0-9]{4}$")
    MT = ("Malta", "^[a-zA-Z]{3} [0-9]{4}$")
    LV = ("Lettonia", "^[A-Z]{2}-[0-9]{4}$", "^[A-Z]{2}-[0-9]{4}$")
    MD = ("Moldova", "^[A-Z]{2}-[0-9]{4}$")
    AD = ("Andorra", "^[A-Z]{2}[0-9]{3}$")
    VG = ("Isole Vergini britanniche", "^[A-Z]{2}[0-9]{4}$", "^[A-Z]{2}[0-9]{4}$")
    VC = ("Saint Vincent e Grenadine", "^[A-Z]{2}[0-9]{4}$", "^[A-Z]{2}[0-9]{4}$")
    BB = ("Barbados", "^[A-Z]{2}[0-9]{5}$")
    KY = ("Isole Cayman", "^[A-Z]{2}[0-9]{1}-[0-9]{4}$")
    SZ = ("Eswatini", "^[a-zA-Z]{1}[0-9]{3}$")
    FO = ("Isole Fær Øer", "^[A-Z]{2}-[0-9]{3}$")
    GG = ("Guernsey", "^[a-zA-Z]{2}[0-9]{1} [0-9]{1}[a-zA-Z]{2}$", "^[a-zA-Z]{2}[0-9]{2} [0-9]{1}[a-zA-Z]{2}$")
    IE = ("Irlanda", "^[a-zA-Z]{1}[0-9]{2}$")
    IM = ("Isola di Man", "^[A-Z]{2}[0-9]{1} [0-9]{1}[a-zA-Z]{2}$", "^[A-Z]{2}[0-9]{2} [0-9]{1}[a-zA-Z]{2}$")
    JE = ("Jersey", "^[A-Z]{2}[0-9]{1} [0-9]{1}[a-zA-Z]{2}$", "^[A-Z]{2}[0-9]{2} [0-9]{1}[a-zA-Z]{2}$")
    LT = ("Lituania", "^[A-Z]{2}-[0-9]{5}$")
    LC = ("Santa Lucia", "^[A-Z]{2}[0-9]{2} [0-9]{3}$")
    AI = ("Anguilla", "^[A-Z]{2}-[2]{1}[6]{1}[4]{1}[0]{1}$")
    FK = ("Isole Falkland (Malvine)", "^[F]{1}[I]{1}[Q]{2} [1]{1}[Z]{2}$")
    GF = ("French Guiana", "^[9]{1}[7]{1}[3]{1}[N]{2}$")
    PF = ("Polinesia francese", "^[9]{1}[8]{1}[7]{1}[N]{2}$")
    MC = ("Monaco", "^[9]{1}[8]{1}[0]{1}[N]{2}$")
    NC = ("Nuova Caledonia", "^[9]{1}[8]{1}[8]{1}[N]{2}$")
    BL = ("Saint-Barthélemy", "^[9]{1}[7]{1}[1]{1}[3]{2}$")
    SH = ("Sant'Elena", "^[a-zA-Z]{4} [1]{1}[Z]{2}$")
    MF = ("Saint-Martin (FR)", "^[9]{1}[7]{1}[1]{1}[5]{1}[0]{1}$")
    PM = ("Saint Pierre e Miquelon", "^[9]{1}[7]{1}[5]{1}[0]{1}[0]{1}$")
    SM = ("San Marino", "^[4]{1}[7]{1}[8]{1}[9]{1}[a-zA-Z]{1}$")
    TC = ("Isole Turks e Caicos", "^[T]{1}[K]{1}[C]{1}[A]{1} [1]{1}[Z]{2}$")
    VA = ("Stato della Città del Vaticano", "^[0]{1}[0]{1}[1]{1}[2]{1}[0]{1}$")
    WF = ("Wallis e Futuna", "^[9]{1}[8]{1}[6]{1}[0-9]{2}$")
    GI = ("Gibilterra", "^[G]{1}[X]{1}[1]{2} [1]{1}[A]{2}$")
    MS = ("Montserrat", "^[M]{1}[S]{1}[R]{1} [0-9]{4}$")
    UK = ("Regno Unito", "^[A-Z]{1,2}[0-9][A-Z0-9]? ?[0-9][A-Z]{2}$")
    AO = ("Angola", "^$")
    AG = ("Antigua e Barbuda", "^$")
    AW = ("Aruba", "^$")
    BS = ("Bahamas", "^$")
    BZ = ("Belize", "^$")
    BJ = ("Benin", "^$")
    BM = ("Bermuda", "^$")
    BO = ("Bolivia", "^$")
    BW = ("Botswana", "^$")
    BF = ("Burkina Faso", "^$")
    BI = ("Burundi", "^$")
    CM = ("Camerun", "^$")
    CF = ("Repubblica Centrafricana", "^$")
    KM = ("Comore", "^$")
    CG = ("Congo", "^$")
    CD = ("Repubblica Democratica del Congo", "^$")
    CI = ("Costa d'Avorio", "^$")
    CW = ("Curaçao", "^$")
    DM = ("Dominica", "^$")
    TL = ("Timor Leste", "^$")
    GQ = ("Guinea equatoriale", "^$")
    ER = ("Eritrea", "^$")
    FJ = ("Figi", "^$")
    GA = ("Gabon", "^$")
    GM = ("Cambia", "^$")
    GD = ("Grenada", "^$")
    GY = ("Guyana", "^$")
    HK = ("Hong Kong", "^$")
    KI = ("Kiribati", "^$")
    KP = ("Corea del nord", "^$")
    LY = ("Libya", "^$")
    MO = ("Macau", "^$")
    ML = ("Mali", "^$")
    MW = ("Malawi", "^$")
    MR = ("Mauritania", "^$")
    NA = ("Namibia", "^$")
    NR = ("Nauru", "^$")
    NL = ("Netherlands", "^$")
    QA = ("Qatar", "^$")
    ST = ("Sao Tome and Principe", "^$")
    SC = ("Seychelles", "^$")
    SL = ("Sierra Leone", "^$")
    SX = ("Sint Maarten", "^$")
    SB = ("Solomon Islands", "^$")
    SS = ("South Sudan", "^$")
    SR = ("Suriname", "^$")
    SY = ("Syria", "^$")
    TG = ("Togo", "^$")
    TK = ("Tokelau", "^$")
    TO = ("Tonga", "^$")
    TV = ("Tuvalu", "^$")
    UG = ("Uganda", "^$")
    AE = ("United Arab Emirates", "^$")
    VU = ("Vanuatu", "^$")
    YE = ("Yemen", "^$")
    ZW = ("Zimbabwe", "^$")


class CapRegexApha3(Enum):
    ITA = ("Italia", "^[0-9]{5}$")
    DZA = ("Algeria", "^[0-9]{5}$")
    BIH = ("Bosnia-Erzegovina", "^[0-9]{5}$")
    BRA = ("Brasile", "^[0-9]{5}$")
    CRI = ("CostaRica", "^[0-9]{5}$", "^[0-9]{5}-[0-9]{4}$")
    HRV = ("Croazia", "^[0-9]{5}$")
    CUB = ("Cuba", "^[0-9]{5}$")
    DOM = ("RepubblicaDominicana", "^[0-9]{5}$")
    EGY = ("Egitto", "^[0-9]{5}$")
    EST = ("Estonia", "^[0-9]{5}$")
    FIN = ("Finlandia", "^[0-9]{5}$")
    FRA = ("Francia", "^[0-9]{5}$")
    GTM = ("Guatemala", "^[0-9]{5}$")
    IDN = ("Indonesia", "^[0-9]{5}$")
    IRQ = ("Iraq", "^[0-9]{5}$")
    JOR = ("Giordania", "^[0-9]{5}$")
    KEN = ("Kenya", "^[0-9]{5}$")
    KOR = ("CoreadelSud", "^[0-9]{5}$")
    KWT = ("Kuwait", "^[0-9]{5}$")
    LAO = ("Laos", "^[0-9]{5}$")
    LBN = ("Libano", "^[0-9]{5}$")
    MYS = ("Malaysia", "^[0-9]{5}$")
    MDV = ("Maldive", "^[0-9]{5}$")
    MHL = ("IsoleMarshall", "^[0-9]{5}$", "^[0-9]{5}-[0-9]{4}$")
    MUS = ("Maurizio", "^[0-9]{5}$")
    MEX = ("Messico", "^[0-9]{5}$")
    MNG = ("Mongolia", "^[0-9]{5}$")
    MNE = ("Montenegro", "^[0-9]{5}$")
    MAR = ("Marocco", "^[0-9]{5}$")
    MMR = ("Myanmar/Birmania", "^[0-9]{5}$")
    NPL = ("Nepal", "^[0-9]{5}$")
    NIC = ("Nicaragua", "^[0-9]{5}$")
    PAK = ("Pakistan", "^[0-9]{5}$")
    PLW = ("Palau", "^[0-9]{5}$", "^[0-9]{5}-[0-9]{4}$")
    PER = ("Perù", "^[0-9]{5}$", "^[A-Z]{2}[0-9]{4}$")
    SAU = ("ArabiaSaudita", "^[0-9]{5}$", "^[0-9]{5}-[0-9]{4}$")
    SEN = ("Senegal", "^[0-9]{5}$")
    SRB = ("Serbia", "^[0-9]{5}$")
    ESP = ("Spagna", "^[0-9]{5}$")
    LKA = ("SriLanka", "^[0-9]{5}$")
    SDN = ("Sudan", "^[0-9]{5}$")
    TZA = ("Tanzania", "^[0-9]{5}$")
    THA = ("Thailandia", "^[0-9]{5}$")
    TUR = ("Turchia", "^[0-9]{5}$")
    UKR = ("Ucraina", "^[0-9]{5}$")
    USA = ("StatiUnitid'America", "^[0-9]{5}$", "^[0-9]{5}-[0-9]{4}$")
    URY = ("Uruguay", "^[0-9]{5}$")
    ZMB = ("Zambia", "^[0-9]{5}$")
    BHR = ("Bahrein", "^[0-9]{3}$", "^[0-9]{4}$")
    GIN = ("Guinea", "^[0-9]{3}$")
    ISL = ("Islanda", "^[0-9]{3}$")
    JAM = ("Giamaica", "^[0-9]{2}$")
    LSO = ("Lesotho", "^[0-9]{3}$")
    MDG = ("Madagascar", "^[0-9]{3}$")
    OMN = ("Oman", "^[0-9]{3}$")
    PSE = ("Palestina", "^[0-9]{3}$")
    PNG = ("PapuaNuovaGuinea", "^[0-9]{3}$")
    AFG = ("Afghanistan", "^[0-9]{4}$")
    ARG = ("Argentina", "^[0-9]{4}$")
    ARM = ("Armenia", "^[0-9]{4}$")
    AUS = ("Australia", "^[0-9]{4}$")
    AUT = ("Austria", "^[0-9]{4}$")
    BGD = ("Bangladesh", "^[0-9]{4}$")
    BEL = ("Belgio", "^[0-9]{4}$")
    BGR = ("Bulgaria", "^[0-9]{4}$")
    CPV = ("CapoVerde", "^[0-9]{4}$")
    CYP = ("Cipro", "^[0-9]{4}$")
    DNK = ("Danimarca", "^[0-9]{4}$")
    ETH = ("Etiopia", "^[0-9]{4}$")
    GEO = ("Georgia", "^[0-9]{4}$")
    DEU = ("Germania", "^[0-9]{4}$", "^[0-9]{2}$", "^[0-9]{5}$")
    GNB = ("Guinea-Bissau", "^[0-9]{4}$")
    HTI = ("Haiti", "^[0-9]{4}$")
    HUN = ("Ungheria", "^[0-9]{4}$")
    LBR = ("Liberia", "^[0-9]{4}$")
    LIE = ("Liechtenstein", "^[0-9]{4}$")
    LUX = ("Lussemburgo", "^[0-9]{4}$")
    MOZ = ("Mozambico", "^[0-9]{4}$")
    NZL = ("NuovaZelanda", "^[0-9]{4}$")
    MKD = ("MacedoniadelNord", "^[0-9]{4}$")
    NOR = ("Norvegia", "^[0-9]{4}$")
    PAN = ("Panama", "^[0-9]{4}$")
    PRY = ("Paraguay", "^[0-9]{4}$")
    PRT = ("Portogallo", "^[0-9]{4}$", "^[0-9]{4}-[0-9]{3}$")
    SGP = ("Singapore", "^[0-9]{4}$", "^[0-9]{2}$")
    SVN = ("Slovenia", "^[0-9]{4}$", "^[A-Z]{2}-[0-9]{4}$")
    ZAF = ("Sudafrica", "^[0-9]{4}$")
    CHE = ("Svizzera", "^[0-9]{4}$")
    TUN = ("Tunisia", "^[0-9]{4}$")
    VEN = ("Venezuela", "^[0-9]{4}$")
    BLR = ("Bielorussia", "^[0-9]{6}$")
    CHN = ("Cina", "^[0-9]{6}$")
    COL = ("Colombia", "^[0-9]{6}$")
    ECU = ("Ecuador", "^[0-9]{6}$")
    IND = ("India", "^[0-9]{6}$")
    KAZ = ("Kazakhstan", "^[0-9]{6}$")
    KGZ = ("Kirghizistan", "^[0-9]{6}$")
    NGA = ("Nigeria", "^[0-9]{6}$", "^[0-9]{4}$")
    CHL = ("Cile", "^[0-9]{7}$", "^[0-9]{3}-[0-9]{4}$")
    ISR = ("Israele", "^[0-9]{7}$")
    WSM = ("Samoa", "^[0-9]{5}-[0-9]{4}$")
    JPN = ("Giappone", "^[0-9]{3}-[0-9]{4}$")
    BRN = ("BruneiDarussalam", "^[a-zA-Z]{2}[0-9]{4}$")
    HND = ("Honduras", "^[a-zA-Z]{2}[0-9]{4}$", "^[a-zA-Z]{2}[0-9]{4}$", "^[0-9]{5}$")
    KHM = ("Cambogia", "^[0-9]{6}$", "^[1]{1}[2]{1}[0]{4}$")
    CAN = ("Canada", "^[a-zA-Z]{1}[0-9]{1}[a-zA-Z]{1}[0-9]{1}[a-zA-Z]{1}[0-9]{1}$")
    GHA = ("Ghana", "^[a-zA-Z]{2}-[0-9]{4}-[0-9]{4}$")
    MLT = ("Malta", "^[a-zA-Z]{3}[0-9]{4}$")
    LVA = ("Lettonia", "^[A-Z]{2}-[0-9]{4}$", "^[A-Z]{2}-[0-9]{4}$")
    MDA = ("Moldova", "^[A-Z]{2}-[0-9]{4}$")
    AND = ("Andorra", "^[A-Z]{2}[0-9]{3}$")
    VGB = ("IsoleVerginibritanniche", "^[A-Z]{2}[0-9]{4}$", "^[A-Z]{2}[0-9]{4}$")
    VCT = ("SaintVincenteGrenadine", "^[A-Z]{2}[0-9]{4}$", "^[A-Z]{2}[0-9]{4}$")
    BRB = ("Barbados", "^[A-Z]{2}[0-9]{5}$")
    CYM = ("IsoleCayman", "^[A-Z]{2}[0-9]{1}-[0-9]{4}$")
    SWZ = ("Eswatini", "^[a-zA-Z]{1}[0-9]{3}$")
    FRO = ("IsoleFærØer", "^[A-Z]{2}-[0-9]{3}$")
    GGY = ("Guernsey", "^[a-zA-Z]{2}[0-9]{1}[0-9]{1}[a-zA-Z]{2}$", "^[a-zA-Z]{2}[0-9]{2}[0-9]{1}[a-zA-Z]{2}$")
    IRL = ("Irlanda", "^[a-zA-Z]{1}[0-9]{2}$")
    IMN = ("IsoladiMan", "^[A-Z]{2}[0-9]{1}[0-9]{1}[a-zA-Z]{2}$", "^[A-Z]{2}[0-9]{2}[0-9]{1}[a-zA-Z]{2}$")
    JEY = ("Jersey", "^[A-Z]{2}[0-9]{1}[0-9]{1}[a-zA-Z]{2}$", "^[A-Z]{2}[0-9]{2}[0-9]{1}[a-zA-Z]{2}$")
    LTU = ("Lituania", "^[A-Z]{2}-[0-9]{5}$")
    LCA = ("SantaLucia", "^[A-Z]{2}[0-9]{2}[0-9]{3}$")
    AIA = ("Anguilla", "^[A-Z]{2}-[2]{1}[6]{1}[4]{1}[0]{1}$")
    FLK = ("IsoleFalkland(Malvine)", "^[F]{1}[I]{1}[Q]{2}[1]{1}[Z]{2}$")
    PYF = ("Polinesiafrancese", "^[9]{1}[8]{1}[7]{1}[N]{2}$")
    MCO = ("Monaco", "^[9]{1}[8]{1}[0]{1}[N]{2}$")
    NCL = ("NuovaCaledonia", "^[9]{1}[8]{1}[8]{1}[N]{2}$")
    BLM = ("Saint-Barthélemy", "^[9]{1}[7]{1}[1]{1}[3]{2}$")
    SHN = ("Sant'Elena", "^[a-zA-Z]{4}[1]{1}[Z]{2}$")
    MAF = ("Saint-Martin(FR)", "^[9]{1}[7]{1}[1]{1}[5]{1}[0]{1}$")
    SPM = ("SaintPierreeMiquelon", "^[9]{1}[7]{1}[5]{1}[0]{1}[0]{1}$")
    SMR = ("SanMarino", "^[4]{1}[7]{1}[8]{1}[9]{1}[a-zA-Z]{1}$")
    TCA = ("IsoleTurkseCaicos", "^[T]{1}[K]{1}[C]{1}[A]{1}[1]{1}[Z]{2}$")
    VAT = ("StatodellaCittàdelVaticano", "^[0]{1}[0]{1}[1]{1}[2]{1}[0]{1}$")
    WLF = ("WalliseFutuna", "^[9]{1}[8]{1}[6]{1}[0-9]{2}$")
    GIB = ("Gibilterra", "^[G]{1}[X]{1}[1]{2}[1]{1}[A]{2}$")
    MSR = ("Montserrat", "^[M]{1}[S]{1}[R]{1}[0-9]{4}$")
    GBR = ("RegnoUnito", "^[A-Z]{1,2}[0-9][A-Z0-9]? ?[0-9][A-Z]{2}$")
    AGO = ("Angola", "^$")
    ATG = ("AntiguaeBarbuda", "^$")
    ABW = ("Aruba", "^$")
    BHS = ("Bahamas", "^$")
    BLZ = ("Belize", "^$")
    BEN = ("Benin", "^$")
    BMU = ("Bermuda", "^$")
    BOL = ("Bolivia", "^$")
    BWA = ("Botswana", "^$")
    BFA = ("BurkinaFaso", "^$")
    BDI = ("Burundi", "^$")
    CMR = ("Camerun", "^$")
    CAF = ("RepubblicaCentrafricana", "^$")
    COM = ("Comore", "^$")
    COG = ("Congo", "^$")
    COD = ("RepubblicaDemocraticadelCongo", "^$")
    CIV = ("Costad'Avorio", "^$")
    CUW = ("Curaçao", "^$")
    DMA = ("Dominica", "^$")
    TLS = ("TimorLeste", "^$")
    GNQ = ("Guineaequatoriale", "^$")
    ERI = ("Eritrea", "^$")
    FJI = ("Figi", "^$")
    GAB = ("Gabon", "^$")
    GMB = ("Cambia", "^$")
    GRD = ("Grenada", "^$")
    GUY = ("Guyana", "^$")
    KIR = ("Kiribati", "^$")
    PRK = ("Coreadelnord", "^$")
    LBY = ("Libya", "^$")
    MLI = ("Mali", "^$")
    MWI = ("Malawi", "^$")
    MRT = ("Mauritania", "^$")
    NAM = ("Namibia", "^$")
    NRU = ("Nauru", "^$")
    NLD = ("Netherlands", "^$")
    QAT = ("Qatar", "^$")
    STP = ("SaoTomeandPrincipe", "^$")
    SYC = ("Seychelles", "^$")
    SLE = ("SierraLeone", "^$")
    SXM = ("SintMaarten", "^$")
    SLB = ("SolomonIslands", "^$")
    SSD = ("SouthSudan", "^$")
    SUR = ("Suriname", "^$")
    SYR = ("Syria", "^$")
    TGO = ("Togo", "^$")
    TON = ("Tonga", "^$")
    TUV = ("Tuvalu", "^$")
    UGA = ("Uganda", "^$")
    ARE = ("UnitedArabEmirates", "^$")
    VUT = ("Vanuatu", "^$")
    YEM = ("Yemen", "^$")
    ZWE = ("Zimbabwe", "^$")

class StatusCAP(Enum):
    NOT_FOUND = (404, "Not Found")
    EXCEPTION = (-1, "Exception")
    VALID = (200, "Match")
    NOT_VALID = (403, "Not Match")
