# -*- coding: utf-8 -*-
# Copyright 2021, CS GROUP - France, http://www.c-s.fr
#
# This file is part of EODAG project
#     https://www.github.com/CS-SI/EODAG
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
# Generated by the gRPC Python protocol compiler plugin. DO NOT EDIT!
import grpc
from google.protobuf import empty_pb2 as google_dot_protobuf_dot_empty__pb2

from eodag_cube.rpc.protocol import eodag_pb2 as eodag__pb2


class EOProductTypeStub(object):
    """EOProductTypeStub"""

    # missing associated documentation comment in .proto file
    pass

    def __init__(self, channel):
        """Constructor.

        Args:
          channel: A grpc.Channel.
        """
        self.ListProductTypes = channel.unary_stream(
            "/eodag.EOProductType/ListProductTypes",
            request_serializer=google_dot_protobuf_dot_empty__pb2.Empty.SerializeToString,
            response_deserializer=eodag__pb2.EOProductTypeSchema.FromString,
        )
        self.SearchProductType = channel.unary_stream(
            "/eodag.EOProductType/SearchProductType",
            request_serializer=eodag__pb2.EOProductTypeSearchRequest.SerializeToString,
            response_deserializer=eodag__pb2.EOProductTypeSchema.FromString,
        )


class EOProductTypeServicer(object):
    """EOProductTypeServicer"""

    # missing associated documentation comment in .proto file
    pass

    def ListProductTypes(self, request, context):
        """ListProductTypes"""
        # missing associated documentation comment in .proto file
        pass
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def SearchProductType(self, request, context):
        """SearchProductType"""
        # missing associated documentation comment in .proto file
        pass
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")


def add_EOProductTypeServicer_to_server(servicer, server):
    """add_EOProductTypeServicer_to_server"""
    rpc_method_handlers = {
        "ListProductTypes": grpc.unary_stream_rpc_method_handler(
            servicer.ListProductTypes,
            request_deserializer=google_dot_protobuf_dot_empty__pb2.Empty.FromString,
            response_serializer=eodag__pb2.EOProductTypeSchema.SerializeToString,
        ),
        "SearchProductType": grpc.unary_stream_rpc_method_handler(
            servicer.SearchProductType,
            request_deserializer=eodag__pb2.EOProductTypeSearchRequest.FromString,
            response_serializer=eodag__pb2.EOProductTypeSchema.SerializeToString,
        ),
    }
    generic_handler = grpc.method_handlers_generic_handler(
        "eodag.EOProductType", rpc_method_handlers
    )
    server.add_generic_rpc_handlers((generic_handler,))


class EOProductStub(object):
    """EOProductStub"""

    # missing associated documentation comment in .proto file
    pass

    def __init__(self, channel):
        """Constructor.

        Args:
          channel: A grpc.Channel.
        """
        self.SearchProduct = channel.unary_stream(
            "/eodag.EOProduct/SearchProduct",
            request_serializer=eodag__pb2.EOProductSearchRequest.SerializeToString,
            response_deserializer=eodag__pb2.EOProductInfo.FromString,
        )
        self.DownloadProduct = channel.unary_stream(
            "/eodag.EOProduct/DownloadProduct",
            request_serializer=eodag__pb2.EOProductDownloadRequest.SerializeToString,
            response_deserializer=eodag__pb2.NetCDFBuffer.FromString,
        )


class EOProductServicer(object):
    """EOProductServicer"""

    # missing associated documentation comment in .proto file
    pass

    def SearchProduct(self, request, context):
        """SearchProduct"""
        # missing associated documentation comment in .proto file
        pass
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def DownloadProduct(self, request, context):
        """DownloadProduct"""
        # missing associated documentation comment in .proto file
        pass
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")


def add_EOProductServicer_to_server(servicer, server):
    """add_EOProductServicer_to_server"""
    rpc_method_handlers = {
        "SearchProduct": grpc.unary_stream_rpc_method_handler(
            servicer.SearchProduct,
            request_deserializer=eodag__pb2.EOProductSearchRequest.FromString,
            response_serializer=eodag__pb2.EOProductInfo.SerializeToString,
        ),
        "DownloadProduct": grpc.unary_stream_rpc_method_handler(
            servicer.DownloadProduct,
            request_deserializer=eodag__pb2.EOProductDownloadRequest.FromString,
            response_serializer=eodag__pb2.NetCDFBuffer.SerializeToString,
        ),
    }
    generic_handler = grpc.method_handlers_generic_handler(
        "eodag.EOProduct", rpc_method_handlers
    )
    server.add_generic_rpc_handlers((generic_handler,))
