# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from odahuflow.sdk.models.base_model_ import Model
from odahuflow.sdk.models import util


class TrainingResult(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    def __init__(self, artifact_name: str=None, commit_id: str=None, run_id: str=None):  # noqa: E501
        """TrainingResult - a model defined in Swagger

        :param artifact_name: The artifact_name of this TrainingResult.  # noqa: E501
        :type artifact_name: str
        :param commit_id: The commit_id of this TrainingResult.  # noqa: E501
        :type commit_id: str
        :param run_id: The run_id of this TrainingResult.  # noqa: E501
        :type run_id: str
        """
        self.swagger_types = {
            'artifact_name': str,
            'commit_id': str,
            'run_id': str
        }

        self.attribute_map = {
            'artifact_name': 'artifactName',
            'commit_id': 'commitID',
            'run_id': 'runId'
        }

        self._artifact_name = artifact_name
        self._commit_id = commit_id
        self._run_id = run_id

    @classmethod
    def from_dict(cls, dikt) -> 'TrainingResult':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The TrainingResult of this TrainingResult.  # noqa: E501
        :rtype: TrainingResult
        """
        return util.deserialize_model(dikt, cls)

    @property
    def artifact_name(self) -> str:
        """Gets the artifact_name of this TrainingResult.

        Trained artifact name  # noqa: E501

        :return: The artifact_name of this TrainingResult.
        :rtype: str
        """
        return self._artifact_name

    @artifact_name.setter
    def artifact_name(self, artifact_name: str):
        """Sets the artifact_name of this TrainingResult.

        Trained artifact name  # noqa: E501

        :param artifact_name: The artifact_name of this TrainingResult.
        :type artifact_name: str
        """

        self._artifact_name = artifact_name

    @property
    def commit_id(self) -> str:
        """Gets the commit_id of this TrainingResult.

        VCS commit  # noqa: E501

        :return: The commit_id of this TrainingResult.
        :rtype: str
        """
        return self._commit_id

    @commit_id.setter
    def commit_id(self, commit_id: str):
        """Sets the commit_id of this TrainingResult.

        VCS commit  # noqa: E501

        :param commit_id: The commit_id of this TrainingResult.
        :type commit_id: str
        """

        self._commit_id = commit_id

    @property
    def run_id(self) -> str:
        """Gets the run_id of this TrainingResult.

        Mlflow run ID  # noqa: E501

        :return: The run_id of this TrainingResult.
        :rtype: str
        """
        return self._run_id

    @run_id.setter
    def run_id(self, run_id: str):
        """Sets the run_id of this TrainingResult.

        Mlflow run ID  # noqa: E501

        :param run_id: The run_id of this TrainingResult.
        :type run_id: str
        """

        self._run_id = run_id
