
# DO NOT EDIT THIS FILE -- AUTOGENERATED BY PANTS
# Target: src/ai/backend/web:dist

from setuptools import setup

setup(**{
    'author': 'Lablup Inc. and contributors',
    'classifiers': [
        'Intended Audience :: Developers',
        'Operating System :: MacOS :: MacOS X',
        'Operating System :: POSIX :: Linux',
        'Programming Language :: Python',
        'Programming Language :: Python :: 3',
        'Environment :: No Input/Output (Daemon)',
        'Topic :: Scientific/Engineering',
        'Topic :: Software Development',
        'Development Status :: 4 - Beta',
        'Programming Language :: Python :: 3.12',
        'License :: OSI Approved :: GNU Lesser General Public License v3 or later (LGPLv3+)',
    ],
    'description': 'Backend.AI WebUI Host',
    'entry_points': {
        'backendai_cli_v10': [
            'web = ai.backend.web.cli:main',
            'web.start-server = ai.backend.web.server:main',
        ],
    },
    'install_requires': (
        'Jinja2~=3.1.4',
        'PyJWT~=2.0',
        'aiohttp_cors~=0.7',
        'aiohttp~=3.10.8',
        'aiotools~=1.7.0',
        """backend.ai-cli==24.09.3rc1
""",
        """backend.ai-client==24.09.3rc1
""",
        """backend.ai-common==24.09.3rc1
""",
        """backend.ai-logging==24.09.3rc1
""",
        """backend.ai-plugin==24.09.3rc1
""",
        'click~=8.1.7',
        'coloredlogs~=15.0',
        'pycryptodome>=3.20.0',
        'setproctitle~=1.3.2',
        'setuptools~=75.1.0',
        'tomli~=2.0.1',
        'trafaret~=2.1',
        'types-Jinja2',
        'types-setuptools',
        'uvloop~=0.20.0; sys_platform != "Windows"',
        'yarl~=1.13.1',
    ),
    'license': 'LGPLv3',
    'long_description': """# Backend.AI Web Server

[![GitHub version](https://badge.fury.io/gh/lablup%2Fbackend.ai-webserver.svg)](https://badge.fury.io/gh/lablup%2Fbackend.ai-webserver) [![PyPI version](https://badge.fury.io/py/backend.ai-webserver.svg)](https://badge.fury.io/py/backend.ai-webserver)

A webapp hosting daemon which serves our `webui` as a SPA and proxies API requests


## Installation

Prepare a Python virtualenv (Python 3.9 or higher) and a Redis server (6.2 or higher).

```console
$ git clone https://github.com/lablup/backend.ai-webserver webserver
$ cd webserver
$ pip install -U -e .
$ cp webserver.sample.conf webserver.conf
```

## Mode

If `service.mode` is set "webui" (the default), the webserver handles
PWA-style fallbacks (e.g., serving `index.html` when there are no matching
files for the requested URL path).
The PWA must exclude `/server` and `/func` URL prefixes from its own routing
to work with the webserver's web sessions and the API proxy.

If it is set "static", the webserver serves the static files as-is,
without any fallbacks or hooking, while preserving the `/server` and `/func`
prefixed URLs and their functionalities.

If you want to serve web UI in webserver with "webui" mode, prepare static web UI source by choosing one of the followings.

### Option 1: Build web UI from source

Build **[backend.ai-webui](https://github.com/lablup/backend.ai-webui)** and copy all files under `build/bundle`
into the `src/ai/backend/web/static` directory.

### Option 2: Use pre-built web UI

To download and deploy web UI from pre-built source, do the following:

```console
cd src/ai/backend/web
curl --fail -sL https://github.com/lablup/backend.ai-webui/releases/download/v$TARGET_VERSION/backend.ai-webui-bundle-$TARGET_VERSION.zip > /tmp/bai-webui.zip
rm -rf static
mkdir static
cd static
unzip /tmp/bai-webui.zip
```
### Setup configuration for webserver

You don't have to write `config.toml` for the web UI as this webserver auto-generates it on-the-fly.

Edit `webserver.conf` to match with your environment.


## Usage

To execute web server, run command below. (for debugging, append a `--debug` flag)


```console
$ python -m ai.backend.web.server
```
""",
    'long_description_content_type': 'text/markdown',
    'name': 'backend.ai-webserver',
    'namespace_packages': (
    ),
    'package_data': {
        'ai.backend.web': (
            'VERSION',
            'py.typed',
            'static/asset-manifest.json',
            'static/config.toml',
            'static/dist/components/backend-ai-change-forgot-password-view-DFkSk5pz.js',
            'static/dist/components/backend-ai-credential-view-CA1F0UC9.js',
            'static/dist/components/backend-ai-data-view-CGgdPCNQ.js',
            'static/dist/components/backend-ai-edu-applauncher-DKWg_QJ6.js',
            'static/dist/components/backend-ai-email-verification-view-BFbO31QM.js',
            'static/dist/components/backend-ai-environment-view-C01Owuao.js',
            'static/dist/components/backend-ai-error-view-sSVo2VML.js',
            'static/dist/components/backend-ai-import-view-D-037deN.js',
            'static/dist/components/backend-ai-list-status-VzkKIACa.js',
            'static/dist/components/backend-ai-maintenance-view-NCfnJVwY.js',
            'static/dist/components/backend-ai-multi-select-COe_fzx4.js',
            'static/dist/components/backend-ai-permission-denied-view-BXY0xgnF.js',
            'static/dist/components/backend-ai-resource-group-list-CYBvVWnP.js',
            'static/dist/components/backend-ai-resource-monitor-CAelG_Ci.js',
            'static/dist/components/backend-ai-serving-view-iDs-Da25.js',
            'static/dist/components/backend-ai-session-launcher-a-8syaHw.js',
            'static/dist/components/backend-ai-session-view-3bqsabc4.js',
            'static/dist/components/backend-ai-session-view-next-CWDTMTSG.js',
            'static/dist/components/backend-ai-settings-view-BTL-dg4O.js',
            'static/dist/components/backend-ai-statistics-view-BBgXyx7s.js',
            'static/dist/components/backend-ai-storage-host-settings-view-5UmIo9xy.js',
            'static/dist/components/backend-ai-storage-proxy-list-DqqQSoG3.js',
            'static/dist/components/backend-ai-summary-view-4bqrRZbq.js',
            'static/dist/components/backend-ai-webui-CLYyD6h8.js',
            'static/dist/components/backend-ai-webui.js',
            'static/dist/components/lablup-activity-panel-Dyi59ndz.js',
            'static/dist/components/lablup-grid-sort-filter-column-BoyPy8Ui.js',
            'static/dist/components/lablup-loading-spinner-D5g7bc50.js',
            'static/dist/components/lablup-progress-bar-EYqurZQb.js',
            'static/dist/components/mwc-check-list-item-RNdnDTVG.js',
            'static/dist/components/mwc-formfield-CMq1HQsz.js',
            'static/dist/components/mwc-switch-DxvjLBGN.js',
            'static/dist/components/mwc-tab-bar-DiSjtInI.js',
            'static/dist/components/slider-DA5MYMl2.js',
            'static/dist/components/vaadin-grid-filter-column-Chtr67lZ.js',
            'static/dist/components/vaadin-iconset-CKFaIPdS.js',
            'static/dist/components/vaadin-item-B2L2KM9f.js',
            'static/dist/components/vaadin-item-mixin-Bo0fel8L.js',
            'static/index.html',
            'static/manifest.json',
            'static/manifest/app.js',
            'static/manifest/backend-ai.icns',
            'static/manifest/backend-ai.ico',
            'static/manifest/backend-ai.iconset/icon_128x128@1x.png',
            'static/manifest/backend-ai.iconset/icon_128x128@2x.png',
            'static/manifest/backend-ai.iconset/icon_16x16@1x.png',
            'static/manifest/backend-ai.iconset/icon_16x16@2x.png',
            'static/manifest/backend-ai.iconset/icon_256x256@1x.png',
            'static/manifest/backend-ai.iconset/icon_256x256@2x.png',
            'static/manifest/backend-ai.iconset/icon_32x32@1x.png',
            'static/manifest/backend-ai.iconset/icon_32x32@2x.png',
            'static/manifest/backend-ai.iconset/icon_512x512@1x.png',
            'static/manifest/backend-ai.iconset/icon_512x512@2x.png',
            'static/manifest/backend.ai-brand-simple-bgdark.svg',
            'static/manifest/backend.ai-brand-simple-black.svg',
            'static/manifest/backend.ai-brand-simple-white.svg',
            'static/manifest/backend.ai-brand-simple.svg',
            'static/manifest/backend.ai-text-bgdark.svg',
            'static/manifest/backend.ai-text.svg',
            'static/manifest/backend.ai-webui-black.svg',
            'static/manifest/backend.ai-webui-white.svg',
            'static/manifest/favicon.ico',
            'static/resources/antdThemeConfig.schema.json',
            'static/resources/app_template.json',
            'static/resources/badge-dark.svg',
            'static/resources/badge.svg',
            'static/resources/custom.css',
            'static/resources/device_metadata.json',
            'static/resources/device_metadata.schema.json',
            'static/resources/documents/privacy-policy.en.html',
            'static/resources/documents/privacy-policy.ko.html',
            'static/resources/documents/terms-of-service.en.html',
            'static/resources/documents/terms-of-service.ko.html',
            'static/resources/fonts/fa-brands-400.woff',
            'static/resources/fonts/fa-brands-400.woff2',
            'static/resources/fonts/fa-regular-400.woff',
            'static/resources/fonts/fa-regular-400.woff2',
            'static/resources/fonts/fa-solid-900.woff',
            'static/resources/fonts/fa-solid-900.woff2',
            'static/resources/fonts/font-awesome-all.min.css',
            'static/resources/fonts/font-awesome.css',
            'static/resources/fonts/fonts.css',
            'static/resources/fonts/material-icons-outlined.woff2',
            'static/resources/fonts/material-icons-round.woff2',
            'static/resources/fonts/material-icons-sharp.woff2',
            'static/resources/fonts/material-icons-two-tone.woff2',
            'static/resources/fonts/material-icons.woff2',
            'static/resources/fonts/roboto-v19-latin-100.woff',
            'static/resources/fonts/roboto-v19-latin-100.woff2',
            'static/resources/fonts/roboto-v19-latin-100italic.woff',
            'static/resources/fonts/roboto-v19-latin-100italic.woff2',
            'static/resources/fonts/roboto-v19-latin-300.woff',
            'static/resources/fonts/roboto-v19-latin-300.woff2',
            'static/resources/fonts/roboto-v19-latin-300italic.woff',
            'static/resources/fonts/roboto-v19-latin-300italic.woff2',
            'static/resources/fonts/roboto-v19-latin-900.woff',
            'static/resources/fonts/roboto-v19-latin-900.woff2',
            'static/resources/fonts/roboto-v19-latin-900italic.woff',
            'static/resources/fonts/roboto-v19-latin-900italic.woff2',
            'static/resources/fonts/roboto-v19-latin-italic.woff',
            'static/resources/fonts/roboto-v19-latin-italic.woff2',
            'static/resources/fonts/roboto-v19-latin-regular.woff',
            'static/resources/fonts/roboto-v19-latin-regular.woff2',
            'static/resources/fonts/ubuntu-mono-v15-bold.woff2',
            'static/resources/fonts/ubuntu-mono-v15-bolditalic.woff2',
            'static/resources/fonts/ubuntu-mono-v15-italic.woff2',
            'static/resources/fonts/ubuntu-mono-v15-regular.woff2',
            'static/resources/fonts/ubuntu-v14-latin-300.woff',
            'static/resources/fonts/ubuntu-v14-latin-300.woff2',
            'static/resources/fonts/ubuntu-v14-latin-300italic.woff',
            'static/resources/fonts/ubuntu-v14-latin-300italic.woff2',
            'static/resources/fonts/ubuntu-v14-latin-500.woff',
            'static/resources/fonts/ubuntu-v14-latin-500.woff2',
            'static/resources/fonts/ubuntu-v14-latin-500italic.woff',
            'static/resources/fonts/ubuntu-v14-latin-500italic.woff2',
            'static/resources/fonts/ubuntu-v14-latin-700.woff',
            'static/resources/fonts/ubuntu-v14-latin-700.woff2',
            'static/resources/fonts/ubuntu-v14-latin-700italic.woff',
            'static/resources/fonts/ubuntu-v14-latin-700italic.woff2',
            'static/resources/fonts/ubuntu-v14-latin-italic.woff',
            'static/resources/fonts/ubuntu-v14-latin-italic.woff2',
            'static/resources/fonts/ubuntu-v14-latin-regular.woff',
            'static/resources/fonts/ubuntu-v14-latin-regular.woff2',
            'static/resources/i18n/de.json',
            'static/resources/i18n/el.json',
            'static/resources/i18n/en.json',
            'static/resources/i18n/es.json',
            'static/resources/i18n/fi.json',
            'static/resources/i18n/fr.json',
            'static/resources/i18n/id.json',
            'static/resources/i18n/it.json',
            'static/resources/i18n/ja.json',
            'static/resources/i18n/ko.json',
            'static/resources/i18n/mn.json',
            'static/resources/i18n/ms.json',
            'static/resources/i18n/pl.json',
            'static/resources/i18n/pt-BR.json',
            'static/resources/i18n/pt.json',
            'static/resources/i18n/ru.json',
            'static/resources/i18n/th.json',
            'static/resources/i18n/tr.json',
            'static/resources/i18n/vi.json',
            'static/resources/i18n/zh-CN.json',
            'static/resources/i18n/zh-TW.json',
            'static/resources/icons/LICENSE.md',
            'static/resources/icons/anaconda.svg',
            'static/resources/icons/apache-spark.svg',
            'static/resources/icons/aws.png',
            'static/resources/icons/azure.png',
            'static/resources/icons/c.svg',
            'static/resources/icons/caffe.png',
            'static/resources/icons/caffe2.svg',
            'static/resources/icons/ceph.png',
            'static/resources/icons/check-list.svg',
            'static/resources/icons/classification.svg',
            'static/resources/icons/cpp.svg',
            'static/resources/icons/default.png',
            'static/resources/icons/default_app.svg',
            'static/resources/icons/file_type_cuda.svg',
            'static/resources/icons/file_type_python.svg',
            'static/resources/icons/filebrowser.svg',
            'static/resources/icons/flux.png',
            'static/resources/icons/furiosa.svg',
            'static/resources/icons/gaudi.svg',
            'static/resources/icons/gcc.png',
            'static/resources/icons/gcp.png',
            'static/resources/icons/gdrive.png',
            'static/resources/icons/h2o.png',
            'static/resources/icons/haskell.png',
            'static/resources/icons/javascript.png',
            'static/resources/icons/julia.png',
            'static/resources/icons/jupyter.png',
            'static/resources/icons/jupyterlab.png',
            'static/resources/icons/kitty.png',
            'static/resources/icons/lablup.png',
            'static/resources/icons/local.png',
            'static/resources/icons/lua.png',
            'static/resources/icons/matlab.png',
            'static/resources/icons/mlflow.png',
            'static/resources/icons/mxnet.svg',
            'static/resources/icons/nbp.png',
            'static/resources/icons/nni.png',
            'static/resources/icons/nni.svg',
            'static/resources/icons/nodejs.png',
            'static/resources/icons/novnc.svg',
            'static/resources/icons/npu_generic.svg',
            'static/resources/icons/nvidia.svg',
            'static/resources/icons/octave.png',
            'static/resources/icons/openstack.png',
            'static/resources/icons/orbit.svg',
            'static/resources/icons/php.png',
            'static/resources/icons/purestorage.png',
            'static/resources/icons/python.png',
            'static/resources/icons/pytorch.svg',
            'static/resources/icons/r-lang.svg',
            'static/resources/icons/rebel.svg',
            'static/resources/icons/rocm.svg',
            'static/resources/icons/rust.svg',
            'static/resources/icons/sftp.png',
            'static/resources/icons/sftp2.png',
            'static/resources/icons/swift-tensorflow.png',
            'static/resources/icons/swift.svg',
            'static/resources/icons/tensorflow.png',
            'static/resources/icons/terminal.svg',
            'static/resources/icons/texlive.png',
            'static/resources/icons/tpu.svg',
            'static/resources/icons/ubuntu.svg',
            'static/resources/icons/vscode.svg',
            'static/resources/icons/xfce.png',
            'static/resources/icons/xrdp.svg',
            'static/resources/image_metadata.json',
            'static/resources/images/401_unauthorized_access.svg',
            'static/resources/images/404_not_found.svg',
            'static/resources/images/launcher-background.png',
            'static/resources/images/loading-background-large.jpg',
            'static/resources/images/loading-background.jpg',
            'static/resources/images/web-terminal-guide-1.png',
            'static/resources/images/web-terminal-guide-2.png',
            'static/resources/images/web-terminal-guide-3.png',
            'static/resources/images/web-terminal-guide-4.png',
            'static/resources/menu_icons/icon_create_a_key_pair.svg',
            'static/resources/menu_icons/icon_keypair_management.svg',
            'static/resources/menu_icons/icon_upload_files.svg',
            'static/resources/storage_metadata.json',
            'static/resources/templates/under_construction.html',
            'static/resources/theme.json',
            'static/resources/theme.schema.json',
            'static/resources/webui.css',
            'static/src/lib/bundles/webcomponents-ce.js',
            'static/src/lib/bundles/webcomponents-ce.js.map',
            'static/src/lib/bundles/webcomponents-pf_dom.js',
            'static/src/lib/bundles/webcomponents-pf_dom.js.map',
            'static/src/lib/bundles/webcomponents-pf_js.js',
            'static/src/lib/bundles/webcomponents-pf_js.js.map',
            'static/src/lib/bundles/webcomponents-sd-ce-pf.js',
            'static/src/lib/bundles/webcomponents-sd-ce-pf.js.map',
            'static/src/lib/bundles/webcomponents-sd-ce.js',
            'static/src/lib/bundles/webcomponents-sd-ce.js.map',
            'static/src/lib/bundles/webcomponents-sd.js',
            'static/src/lib/bundles/webcomponents-sd.js.map',
            'static/src/lib/web-animations-js/web-animations-next-lite.min.js',
            'static/src/lib/webcomponents-loader.js',
            'static/static/js/166.bd4e6bfc.chunk.js',
            'static/static/js/166.bd4e6bfc.chunk.js.LICENSE.txt',
            'static/static/js/166.bd4e6bfc.chunk.js.map',
            'static/static/js/1670.f974670e.chunk.js',
            'static/static/js/1670.f974670e.chunk.js.map',
            'static/static/js/1799.e213db27.chunk.js',
            'static/static/js/1799.e213db27.chunk.js.map',
            'static/static/js/1817.8be73472.chunk.js',
            'static/static/js/1817.8be73472.chunk.js.LICENSE.txt',
            'static/static/js/1817.8be73472.chunk.js.map',
            'static/static/js/1913.a69b1f5d.chunk.js',
            'static/static/js/1913.a69b1f5d.chunk.js.map',
            'static/static/js/2449.7a29d71e.chunk.js',
            'static/static/js/2449.7a29d71e.chunk.js.map',
            'static/static/js/2599.635f9e4b.chunk.js',
            'static/static/js/2599.635f9e4b.chunk.js.LICENSE.txt',
            'static/static/js/2599.635f9e4b.chunk.js.map',
            'static/static/js/2624.e49d39f1.chunk.js',
            'static/static/js/2624.e49d39f1.chunk.js.map',
            'static/static/js/2640.f480532e.chunk.js',
            'static/static/js/2640.f480532e.chunk.js.LICENSE.txt',
            'static/static/js/2640.f480532e.chunk.js.map',
            'static/static/js/2757.9deae60c.chunk.js',
            'static/static/js/2757.9deae60c.chunk.js.map',
            'static/static/js/2983.2fcb5582.chunk.js',
            'static/static/js/2983.2fcb5582.chunk.js.map',
            'static/static/js/3032.9bf6b80f.chunk.js',
            'static/static/js/3032.9bf6b80f.chunk.js.LICENSE.txt',
            'static/static/js/3032.9bf6b80f.chunk.js.map',
            'static/static/js/3110.3194e1fc.chunk.js',
            'static/static/js/3110.3194e1fc.chunk.js.LICENSE.txt',
            'static/static/js/3110.3194e1fc.chunk.js.map',
            'static/static/js/3420.2a657ba0.chunk.js',
            'static/static/js/3420.2a657ba0.chunk.js.LICENSE.txt',
            'static/static/js/3420.2a657ba0.chunk.js.map',
            'static/static/js/3582.a8814348.chunk.js',
            'static/static/js/3582.a8814348.chunk.js.map',
            'static/static/js/3760.ac86a50d.chunk.js',
            'static/static/js/3760.ac86a50d.chunk.js.LICENSE.txt',
            'static/static/js/3760.ac86a50d.chunk.js.map',
            'static/static/js/3835.4818d916.chunk.js',
            'static/static/js/3835.4818d916.chunk.js.map',
            'static/static/js/3951.5394c7bb.chunk.js',
            'static/static/js/3951.5394c7bb.chunk.js.map',
            'static/static/js/4152.98a8aa4f.chunk.js',
            'static/static/js/4152.98a8aa4f.chunk.js.map',
            'static/static/js/4244.d9ed2173.chunk.js',
            'static/static/js/4244.d9ed2173.chunk.js.map',
            'static/static/js/4462.c2f81456.chunk.js',
            'static/static/js/4462.c2f81456.chunk.js.LICENSE.txt',
            'static/static/js/4462.c2f81456.chunk.js.map',
            'static/static/js/4475.8d9c63d3.chunk.js',
            'static/static/js/4475.8d9c63d3.chunk.js.LICENSE.txt',
            'static/static/js/4475.8d9c63d3.chunk.js.map',
            'static/static/js/4623.e5c9e3aa.chunk.js',
            'static/static/js/4623.e5c9e3aa.chunk.js.map',
            'static/static/js/4871.c48411f7.chunk.js',
            'static/static/js/4871.c48411f7.chunk.js.map',
            'static/static/js/4894.d4d603f8.chunk.js',
            'static/static/js/4894.d4d603f8.chunk.js.map',
            'static/static/js/4911.c078c555.chunk.js',
            'static/static/js/4911.c078c555.chunk.js.map',
            'static/static/js/5019.14379dd8.chunk.js',
            'static/static/js/5019.14379dd8.chunk.js.map',
            'static/static/js/5329.44d1f5be.chunk.js',
            'static/static/js/5329.44d1f5be.chunk.js.map',
            'static/static/js/5405.7f2e6eeb.chunk.js',
            'static/static/js/5405.7f2e6eeb.chunk.js.map',
            'static/static/js/5431.e3697078.chunk.js',
            'static/static/js/5431.e3697078.chunk.js.map',
            'static/static/js/5639.88a78d82.chunk.js',
            'static/static/js/5639.88a78d82.chunk.js.map',
            'static/static/js/5835.97e349fb.chunk.js',
            'static/static/js/5835.97e349fb.chunk.js.map',
            'static/static/js/5863.8d8202fe.chunk.js',
            'static/static/js/5863.8d8202fe.chunk.js.map',
            'static/static/js/5869.676e9f0e.chunk.js',
            'static/static/js/5869.676e9f0e.chunk.js.map',
            'static/static/js/5895.e7368bef.chunk.js',
            'static/static/js/5895.e7368bef.chunk.js.LICENSE.txt',
            'static/static/js/5895.e7368bef.chunk.js.map',
            'static/static/js/590.a1d7510c.chunk.js',
            'static/static/js/590.a1d7510c.chunk.js.map',
            'static/static/js/5946.502f147d.chunk.js',
            'static/static/js/5946.502f147d.chunk.js.map',
            'static/static/js/6020.8a54607d.chunk.js',
            'static/static/js/6020.8a54607d.chunk.js.map',
            'static/static/js/6061.d11273be.chunk.js',
            'static/static/js/6061.d11273be.chunk.js.map',
            'static/static/js/6119.6f3ad768.chunk.js',
            'static/static/js/6119.6f3ad768.chunk.js.map',
            'static/static/js/6161.38399bfa.chunk.js',
            'static/static/js/6161.38399bfa.chunk.js.map',
            'static/static/js/6214.f683f379.chunk.js',
            'static/static/js/6214.f683f379.chunk.js.map',
            'static/static/js/6416.f5f4e378.chunk.js',
            'static/static/js/6416.f5f4e378.chunk.js.LICENSE.txt',
            'static/static/js/6416.f5f4e378.chunk.js.map',
            'static/static/js/6868.7d51fcc2.chunk.js',
            'static/static/js/6868.7d51fcc2.chunk.js.LICENSE.txt',
            'static/static/js/6868.7d51fcc2.chunk.js.map',
            'static/static/js/6949.15e9bedc.chunk.js',
            'static/static/js/6949.15e9bedc.chunk.js.map',
            'static/static/js/6996.ea5d3666.chunk.js',
            'static/static/js/6996.ea5d3666.chunk.js.map',
            'static/static/js/6999.ac8d2745.chunk.js',
            'static/static/js/6999.ac8d2745.chunk.js.map',
            'static/static/js/7357.3d539dd2.chunk.js',
            'static/static/js/7357.3d539dd2.chunk.js.map',
            'static/static/js/7472.99728d45.chunk.js',
            'static/static/js/7472.99728d45.chunk.js.map',
            'static/static/js/7474.55ce7a8a.chunk.js',
            'static/static/js/7474.55ce7a8a.chunk.js.map',
            'static/static/js/7668.a7d4afc3.chunk.js',
            'static/static/js/7668.a7d4afc3.chunk.js.map',
            'static/static/js/7736.817e29f5.chunk.js',
            'static/static/js/7736.817e29f5.chunk.js.LICENSE.txt',
            'static/static/js/7736.817e29f5.chunk.js.map',
            'static/static/js/7853.e0edf320.chunk.js',
            'static/static/js/7853.e0edf320.chunk.js.map',
            'static/static/js/8182.ac083632.chunk.js',
            'static/static/js/8182.ac083632.chunk.js.map',
            'static/static/js/8372.51f405e6.chunk.js',
            'static/static/js/8372.51f405e6.chunk.js.map',
            'static/static/js/8694.3dc44ba6.chunk.js',
            'static/static/js/8694.3dc44ba6.chunk.js.map',
            'static/static/js/8922.426ab509.chunk.js',
            'static/static/js/8922.426ab509.chunk.js.map',
            'static/static/js/899.b722b0ad.chunk.js',
            'static/static/js/899.b722b0ad.chunk.js.LICENSE.txt',
            'static/static/js/899.b722b0ad.chunk.js.map',
            'static/static/js/9242.fe3728e8.chunk.js',
            'static/static/js/9242.fe3728e8.chunk.js.map',
            'static/static/js/944.b076172c.chunk.js',
            'static/static/js/944.b076172c.chunk.js.map',
            'static/static/js/9449.5e0183fe.chunk.js',
            'static/static/js/9449.5e0183fe.chunk.js.map',
            'static/static/js/9491.446eea21.chunk.js',
            'static/static/js/9491.446eea21.chunk.js.map',
            'static/static/js/9539.235ac431.chunk.js',
            'static/static/js/9539.235ac431.chunk.js.map',
            'static/static/js/9920.c01cdf77.chunk.js',
            'static/static/js/9920.c01cdf77.chunk.js.map',
            'static/static/js/main.7f5376e8.js',
            'static/static/js/main.7f5376e8.js.LICENSE.txt',
            'static/static/js/main.7f5376e8.js.map',
            'static/static/media/Endpoints.c580a536457ec4d9573e73e25cc140c1.svg',
            'static/static/media/MyEnvironments.722665aa4e41f56bd36ef808274d4b93.svg',
            'static/static/media/Sessions.6d700a0755b615ae677ca2ef8bfaf289.svg',
            'static/sw.js',
            'static/sw.js.map',
            'static/version.json',
            'static/workbox-9a84fccb.js',
            'static/workbox-9a84fccb.js.map',
            'templates/config.toml.j2',
            'templates/config_ini.toml.j2',
        ),
    },
    'packages': (
        'ai.backend.web',
    ),
    'project_urls': {
        'Documentation': 'https://docs.backend.ai/',
        'Source': 'https://github.com/lablup/backend.ai',
    },
    'python_requires': '>=3.12,<3.13',
    'url': 'https://github.com/lablup/backend.ai',
    'version': """24.09.3rc1
""",
    'zip_safe': False,
})
