from setuptools import setup, find_packages
from pathlib import Path
this_directory = Path(__file__).parent
long_description = (this_directory / "README.md").read_text()

setup(
	name='deeprtalign',
	version="1.0.4",
	packages=find_packages(),
	python_requires='>=3',
	install_requires=[
						'xlrd==1.2.0',
						'pandas>=0.24',
		],

	package_data={
		'deeprtalign': ['data/base.npy','data/params.pt']
		},

	author='Yi Liu',
	author_email='leoicarus@163.com',
	description='retention time alignment tool for large cohort LC-MS data analysis',
	long_description=long_description,
	long_description_content_type='text/markdown',
	url='https://github.com/FineLiu/deeprtalign',
	license='GPLv3'
)