"""
    ICA Rest API

    This API can be used to interact with Illumina Connected Analytics.<br> <p> Authentication to the  API can be done in multiple ways:<br> <ul><li>For the entire API, except for the POST /tokens endpoint: API-key + JWT</li> <li>Only for the POST /tokens endpoint: API-key + Basic Authentication</li></ul> </p> <p> <b>API-key</b><br> API keys are managed within the Illumina portal where you can manage your profile after you have logged on. The API-key has to be provided in the X-API-Key header parameter when executing API calls to ICA. In the background, a JWT will be requested at the IDP of Illumina to create a session. A good practice is to not use the API-key for every API call, but to first generate a JWT and to use that for authentication in subsequent calls.<br> </p> <p> <b>JWT</b><br> To avoid using an API-key for each call, we recommend to request a JWT via the POST /tokens endpoint  using this API-key. The JWT will expire after a pre-configured period specified by a tenant administrator through the IAM console in the Illumina portal. The JWT is the preferred way for authentication.<br>A not yet expired, still valid JWT could be refreshed using the POST /tokens:refresh endpoint.<br> </p> <p> <b>Basic Authentication</b><br> Basic authentication is only supported by the POST /tokens endpoint for generating a JWT. Use \"Basic base64encoded(emailaddress:password)\" in the \"Authorization\" header parameter for this authentication method. In case having access to multiple tenants using the same email-address, also provide the \"tenant\" request parameter to indicate what tenant you would like to request a JWT for. </p>   # noqa: E501

    The version of the OpenAPI document: 3
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from libica.openapi.v2.api_client import ApiClient, Endpoint as _Endpoint
from libica.openapi.v2.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from libica.openapi.v2.model.complete_folder_upload_session import CompleteFolderUploadSession
from libica.openapi.v2.model.create_data import CreateData
from libica.openapi.v2.model.create_temporary_credentials import CreateTemporaryCredentials
from libica.openapi.v2.model.data_id_or_path_list import DataIdOrPathList
from libica.openapi.v2.model.data_list import DataList
from libica.openapi.v2.model.data_paged_list import DataPagedList
from libica.openapi.v2.model.data_transfer import DataTransfer
from libica.openapi.v2.model.data_url_with_path_list import DataUrlWithPathList
from libica.openapi.v2.model.download import Download
from libica.openapi.v2.model.folder_upload_session import FolderUploadSession
from libica.openapi.v2.model.inline_view import InlineView
from libica.openapi.v2.model.problem import Problem
from libica.openapi.v2.model.project_data import ProjectData
from libica.openapi.v2.model.project_data_paged_list import ProjectDataPagedList
from libica.openapi.v2.model.project_list import ProjectList
from libica.openapi.v2.model.schedule_download import ScheduleDownload
from libica.openapi.v2.model.temp_credentials import TempCredentials
from libica.openapi.v2.model.upload import Upload


class ProjectDataApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.add_secondary_data_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'ApiKeyAuth',
                    'JwtAuth'
                ],
                'endpoint_path': '/api/projects/{projectId}/data/{dataId}/secondaryData/{secondaryDataId}',
                'operation_id': 'add_secondary_data',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'project_id',
                    'data_id',
                    'secondary_data_id',
                ],
                'required': [
                    'project_id',
                    'data_id',
                    'secondary_data_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'project_id':
                        (str,),
                    'data_id':
                        (str,),
                    'secondary_data_id':
                        (str,),
                },
                'attribute_map': {
                    'project_id': 'projectId',
                    'data_id': 'dataId',
                    'secondary_data_id': 'secondaryDataId',
                },
                'location_map': {
                    'project_id': 'path',
                    'data_id': 'path',
                    'secondary_data_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/problem+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.archive_data_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'ApiKeyAuth',
                    'JwtAuth'
                ],
                'endpoint_path': '/api/projects/{projectId}/data/{dataId}:archive',
                'operation_id': 'archive_data',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'project_id',
                    'data_id',
                ],
                'required': [
                    'project_id',
                    'data_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'project_id':
                        (str,),
                    'data_id':
                        (str,),
                },
                'attribute_map': {
                    'project_id': 'projectId',
                    'data_id': 'dataId',
                },
                'location_map': {
                    'project_id': 'path',
                    'data_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/problem+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.complete_folder_upload_session_endpoint = _Endpoint(
            settings={
                'response_type': (FolderUploadSession,),
                'auth': [
                    'ApiKeyAuth',
                    'JwtAuth'
                ],
                'endpoint_path': '/api/projects/{projectId}/data/{dataId}/folderUploadSessions/{folderUploadSessionId}:complete',
                'operation_id': 'complete_folder_upload_session',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'project_id',
                    'data_id',
                    'folder_upload_session_id',
                    'complete_folder_upload_session',
                ],
                'required': [
                    'project_id',
                    'data_id',
                    'folder_upload_session_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'project_id':
                        (str,),
                    'data_id':
                        (str,),
                    'folder_upload_session_id':
                        (str,),
                    'complete_folder_upload_session':
                        (CompleteFolderUploadSession,),
                },
                'attribute_map': {
                    'project_id': 'projectId',
                    'data_id': 'dataId',
                    'folder_upload_session_id': 'folderUploadSessionId',
                },
                'location_map': {
                    'project_id': 'path',
                    'data_id': 'path',
                    'folder_upload_session_id': 'path',
                    'complete_folder_upload_session': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/problem+json',
                    'application/vnd.illumina.v3+json'
                ],
                'content_type': [
                    'application/vnd.illumina.v3+json',
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.create_data_in_project_endpoint = _Endpoint(
            settings={
                'response_type': (ProjectData,),
                'auth': [
                    'ApiKeyAuth',
                    'JwtAuth'
                ],
                'endpoint_path': '/api/projects/{projectId}/data',
                'operation_id': 'create_data_in_project',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'project_id',
                    'create_data',
                ],
                'required': [
                    'project_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'project_id':
                        (str,),
                    'create_data':
                        (CreateData,),
                },
                'attribute_map': {
                    'project_id': 'projectId',
                },
                'location_map': {
                    'project_id': 'path',
                    'create_data': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/problem+json',
                    'application/vnd.illumina.v3+json'
                ],
                'content_type': [
                    'application/vnd.illumina.v3+json',
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.create_download_url_for_data_endpoint = _Endpoint(
            settings={
                'response_type': (Download,),
                'auth': [
                    'ApiKeyAuth',
                    'JwtAuth'
                ],
                'endpoint_path': '/api/projects/{projectId}/data/{dataId}:createDownloadUrl',
                'operation_id': 'create_download_url_for_data',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'project_id',
                    'data_id',
                ],
                'required': [
                    'project_id',
                    'data_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'project_id':
                        (str,),
                    'data_id':
                        (str,),
                },
                'attribute_map': {
                    'project_id': 'projectId',
                    'data_id': 'dataId',
                },
                'location_map': {
                    'project_id': 'path',
                    'data_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/problem+json',
                    'application/vnd.illumina.v3+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.create_download_urls_for_data_endpoint = _Endpoint(
            settings={
                'response_type': (DataUrlWithPathList,),
                'auth': [
                    'ApiKeyAuth',
                    'JwtAuth'
                ],
                'endpoint_path': '/api/projects/{projectId}/data:createDownloadUrls',
                'operation_id': 'create_download_urls_for_data',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'project_id',
                    'data_id_or_path_list',
                ],
                'required': [
                    'project_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'project_id':
                        (str,),
                    'data_id_or_path_list':
                        (DataIdOrPathList,),
                },
                'attribute_map': {
                    'project_id': 'projectId',
                },
                'location_map': {
                    'project_id': 'path',
                    'data_id_or_path_list': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/problem+json',
                    'application/vnd.illumina.v3+json'
                ],
                'content_type': [
                    'application/vnd.illumina.v3+json'
                ]
            },
            api_client=api_client
        )
        self.create_folder_upload_session_endpoint = _Endpoint(
            settings={
                'response_type': (FolderUploadSession,),
                'auth': [
                    'ApiKeyAuth',
                    'JwtAuth'
                ],
                'endpoint_path': '/api/projects/{projectId}/data/{dataId}/folderUploadSessions',
                'operation_id': 'create_folder_upload_session',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'project_id',
                    'data_id',
                    'create_temporary_credentials',
                ],
                'required': [
                    'project_id',
                    'data_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'project_id':
                        (str,),
                    'data_id':
                        (str,),
                    'create_temporary_credentials':
                        (CreateTemporaryCredentials,),
                },
                'attribute_map': {
                    'project_id': 'projectId',
                    'data_id': 'dataId',
                },
                'location_map': {
                    'project_id': 'path',
                    'data_id': 'path',
                    'create_temporary_credentials': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/problem+json',
                    'application/vnd.illumina.v3+json'
                ],
                'content_type': [
                    'application/vnd.illumina.v3+json',
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.create_inline_view_url_for_data_endpoint = _Endpoint(
            settings={
                'response_type': (InlineView,),
                'auth': [
                    'ApiKeyAuth',
                    'JwtAuth'
                ],
                'endpoint_path': '/api/projects/{projectId}/data/{dataId}:createInlineViewUrl',
                'operation_id': 'create_inline_view_url_for_data',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'project_id',
                    'data_id',
                ],
                'required': [
                    'project_id',
                    'data_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'project_id':
                        (str,),
                    'data_id':
                        (str,),
                },
                'attribute_map': {
                    'project_id': 'projectId',
                    'data_id': 'dataId',
                },
                'location_map': {
                    'project_id': 'path',
                    'data_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/problem+json',
                    'application/vnd.illumina.v3+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.create_temporary_credentials_for_data_endpoint = _Endpoint(
            settings={
                'response_type': (TempCredentials,),
                'auth': [
                    'ApiKeyAuth',
                    'JwtAuth'
                ],
                'endpoint_path': '/api/projects/{projectId}/data/{dataId}:createTemporaryCredentials',
                'operation_id': 'create_temporary_credentials_for_data',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'project_id',
                    'data_id',
                    'create_temporary_credentials',
                ],
                'required': [
                    'project_id',
                    'data_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'project_id':
                        (str,),
                    'data_id':
                        (str,),
                    'create_temporary_credentials':
                        (CreateTemporaryCredentials,),
                },
                'attribute_map': {
                    'project_id': 'projectId',
                    'data_id': 'dataId',
                },
                'location_map': {
                    'project_id': 'path',
                    'data_id': 'path',
                    'create_temporary_credentials': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/problem+json',
                    'application/vnd.illumina.v3+json'
                ],
                'content_type': [
                    'application/vnd.illumina.v3+json',
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.create_upload_url_for_data_endpoint = _Endpoint(
            settings={
                'response_type': (Upload,),
                'auth': [
                    'ApiKeyAuth',
                    'JwtAuth'
                ],
                'endpoint_path': '/api/projects/{projectId}/data/{dataId}:createUploadUrl',
                'operation_id': 'create_upload_url_for_data',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'project_id',
                    'data_id',
                    'file_type',
                    'hash',
                ],
                'required': [
                    'project_id',
                    'data_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'project_id':
                        (str,),
                    'data_id':
                        (str,),
                    'file_type':
                        (str,),
                    'hash':
                        (str,),
                },
                'attribute_map': {
                    'project_id': 'projectId',
                    'data_id': 'dataId',
                    'file_type': 'fileType',
                    'hash': 'hash',
                },
                'location_map': {
                    'project_id': 'path',
                    'data_id': 'path',
                    'file_type': 'query',
                    'hash': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/problem+json',
                    'application/vnd.illumina.v3+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.delete_data_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'ApiKeyAuth',
                    'JwtAuth'
                ],
                'endpoint_path': '/api/projects/{projectId}/data/{dataId}:delete',
                'operation_id': 'delete_data',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'project_id',
                    'data_id',
                ],
                'required': [
                    'project_id',
                    'data_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'project_id':
                        (str,),
                    'data_id':
                        (str,),
                },
                'attribute_map': {
                    'project_id': 'projectId',
                    'data_id': 'dataId',
                },
                'location_map': {
                    'project_id': 'path',
                    'data_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/problem+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_data_eligible_for_linking_endpoint = _Endpoint(
            settings={
                'response_type': (DataPagedList,),
                'auth': [
                    'ApiKeyAuth',
                    'JwtAuth'
                ],
                'endpoint_path': '/api/projects/{projectId}/data/eligibleForLinking',
                'operation_id': 'get_data_eligible_for_linking',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'project_id',
                    'full_text',
                    'id',
                    'filename',
                    'filename_match_mode',
                    'file_path',
                    'file_path_match_mode',
                    'status',
                    'format_id',
                    'format_code',
                    'type',
                    'parent_folder_id',
                    'parent_folder_path',
                    'creation_date_after',
                    'creation_date_before',
                    'status_date_after',
                    'status_date_before',
                    'user_tag',
                    'user_tag_match_mode',
                    'run_input_tag',
                    'run_input_tag_match_mode',
                    'run_output_tag',
                    'run_output_tag_match_mode',
                    'connector_tag',
                    'connector_tag_match_mode',
                    'technical_tag',
                    'technical_tag_match_mode',
                    'not_in_run',
                    'not_linked_to_sample',
                    'instrument_run_id',
                    'page_offset',
                    'page_token',
                    'page_size',
                    'sort',
                ],
                'required': [
                    'project_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'filename_match_mode',
                    'file_path_match_mode',
                    'status',
                    'type',
                    'user_tag_match_mode',
                    'run_input_tag_match_mode',
                    'run_output_tag_match_mode',
                    'connector_tag_match_mode',
                    'technical_tag_match_mode',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('filename_match_mode',): {

                        "EXACT": "EXACT",
                        "EXCLUDE": "EXCLUDE",
                        "FUZZY": "FUZZY"
                    },
                    ('file_path_match_mode',): {

                        "STARTS_WITH_CASE_INSENSITIVE": "STARTS_WITH_CASE_INSENSITIVE",
                        "FULL_CASE_INSENSITIVE": "FULL_CASE_INSENSITIVE"
                    },
                    ('status',): {

                        "PARTIAL": "PARTIAL",
                        "AVAILABLE": "AVAILABLE",
                        "ARCHIVING": "ARCHIVING",
                        "ARCHIVED": "ARCHIVED",
                        "UNARCHIVING": "UNARCHIVING",
                        "DELETING": "DELETING"
                    },
                    ('type',): {

                        "FILE": "FILE",
                        "FOLDER": "FOLDER"
                    },
                    ('user_tag_match_mode',): {

                        "EXACT": "EXACT",
                        "EXCLUDE": "EXCLUDE",
                        "FUZZY": "FUZZY"
                    },
                    ('run_input_tag_match_mode',): {

                        "EXACT": "EXACT",
                        "EXCLUDE": "EXCLUDE",
                        "FUZZY": "FUZZY"
                    },
                    ('run_output_tag_match_mode',): {

                        "EXACT": "EXACT",
                        "EXCLUDE": "EXCLUDE",
                        "FUZZY": "FUZZY"
                    },
                    ('connector_tag_match_mode',): {

                        "EXACT": "EXACT",
                        "EXCLUDE": "EXCLUDE",
                        "FUZZY": "FUZZY"
                    },
                    ('technical_tag_match_mode',): {

                        "EXACT": "EXACT",
                        "EXCLUDE": "EXCLUDE",
                        "FUZZY": "FUZZY"
                    },
                },
                'openapi_types': {
                    'project_id':
                        (str,),
                    'full_text':
                        (str,),
                    'id':
                        ([str],),
                    'filename':
                        ([str],),
                    'filename_match_mode':
                        (str,),
                    'file_path':
                        ([str],),
                    'file_path_match_mode':
                        (str,),
                    'status':
                        ([str],),
                    'format_id':
                        ([str],),
                    'format_code':
                        ([str],),
                    'type':
                        (str,),
                    'parent_folder_id':
                        ([str],),
                    'parent_folder_path':
                        (str,),
                    'creation_date_after':
                        (datetime,),
                    'creation_date_before':
                        (datetime,),
                    'status_date_after':
                        (datetime,),
                    'status_date_before':
                        (datetime,),
                    'user_tag':
                        ([str],),
                    'user_tag_match_mode':
                        (str,),
                    'run_input_tag':
                        ([str],),
                    'run_input_tag_match_mode':
                        (str,),
                    'run_output_tag':
                        ([str],),
                    'run_output_tag_match_mode':
                        (str,),
                    'connector_tag':
                        ([str],),
                    'connector_tag_match_mode':
                        (str,),
                    'technical_tag':
                        ([str],),
                    'technical_tag_match_mode':
                        (str,),
                    'not_in_run':
                        (bool,),
                    'not_linked_to_sample':
                        (bool,),
                    'instrument_run_id':
                        ([str],),
                    'page_offset':
                        (str,),
                    'page_token':
                        (str,),
                    'page_size':
                        (str,),
                    'sort':
                        (str,),
                },
                'attribute_map': {
                    'project_id': 'projectId',
                    'full_text': 'fullText',
                    'id': 'id',
                    'filename': 'filename',
                    'filename_match_mode': 'filenameMatchMode',
                    'file_path': 'filePath',
                    'file_path_match_mode': 'filePathMatchMode',
                    'status': 'status',
                    'format_id': 'formatId',
                    'format_code': 'formatCode',
                    'type': 'type',
                    'parent_folder_id': 'parentFolderId',
                    'parent_folder_path': 'parentFolderPath',
                    'creation_date_after': 'creationDateAfter',
                    'creation_date_before': 'creationDateBefore',
                    'status_date_after': 'statusDateAfter',
                    'status_date_before': 'statusDateBefore',
                    'user_tag': 'userTag',
                    'user_tag_match_mode': 'userTagMatchMode',
                    'run_input_tag': 'runInputTag',
                    'run_input_tag_match_mode': 'runInputTagMatchMode',
                    'run_output_tag': 'runOutputTag',
                    'run_output_tag_match_mode': 'runOutputTagMatchMode',
                    'connector_tag': 'connectorTag',
                    'connector_tag_match_mode': 'connectorTagMatchMode',
                    'technical_tag': 'technicalTag',
                    'technical_tag_match_mode': 'technicalTagMatchMode',
                    'not_in_run': 'notInRun',
                    'not_linked_to_sample': 'notLinkedToSample',
                    'instrument_run_id': 'instrumentRunId',
                    'page_offset': 'pageOffset',
                    'page_token': 'pageToken',
                    'page_size': 'pageSize',
                    'sort': 'sort',
                },
                'location_map': {
                    'project_id': 'path',
                    'full_text': 'query',
                    'id': 'query',
                    'filename': 'query',
                    'filename_match_mode': 'query',
                    'file_path': 'query',
                    'file_path_match_mode': 'query',
                    'status': 'query',
                    'format_id': 'query',
                    'format_code': 'query',
                    'type': 'query',
                    'parent_folder_id': 'query',
                    'parent_folder_path': 'query',
                    'creation_date_after': 'query',
                    'creation_date_before': 'query',
                    'status_date_after': 'query',
                    'status_date_before': 'query',
                    'user_tag': 'query',
                    'user_tag_match_mode': 'query',
                    'run_input_tag': 'query',
                    'run_input_tag_match_mode': 'query',
                    'run_output_tag': 'query',
                    'run_output_tag_match_mode': 'query',
                    'connector_tag': 'query',
                    'connector_tag_match_mode': 'query',
                    'technical_tag': 'query',
                    'technical_tag_match_mode': 'query',
                    'not_in_run': 'query',
                    'not_linked_to_sample': 'query',
                    'instrument_run_id': 'query',
                    'page_offset': 'query',
                    'page_token': 'query',
                    'page_size': 'query',
                    'sort': 'query',
                },
                'collection_format_map': {
                    'id': 'multi',
                    'filename': 'multi',
                    'file_path': 'multi',
                    'status': 'multi',
                    'format_id': 'multi',
                    'format_code': 'multi',
                    'parent_folder_id': 'multi',
                    'user_tag': 'multi',
                    'run_input_tag': 'multi',
                    'run_output_tag': 'multi',
                    'connector_tag': 'multi',
                    'technical_tag': 'multi',
                    'instrument_run_id': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/problem+json',
                    'application/vnd.illumina.v3+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_folder_upload_session_endpoint = _Endpoint(
            settings={
                'response_type': (FolderUploadSession,),
                'auth': [
                    'ApiKeyAuth',
                    'JwtAuth'
                ],
                'endpoint_path': '/api/projects/{projectId}/data/{dataId}/folderUploadSessions/{folderUploadSessionId}',
                'operation_id': 'get_folder_upload_session',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'project_id',
                    'data_id',
                    'folder_upload_session_id',
                ],
                'required': [
                    'project_id',
                    'data_id',
                    'folder_upload_session_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'project_id':
                        (str,),
                    'data_id':
                        (str,),
                    'folder_upload_session_id':
                        (str,),
                },
                'attribute_map': {
                    'project_id': 'projectId',
                    'data_id': 'dataId',
                    'folder_upload_session_id': 'folderUploadSessionId',
                },
                'location_map': {
                    'project_id': 'path',
                    'data_id': 'path',
                    'folder_upload_session_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/problem+json',
                    'application/vnd.illumina.v3+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_non_sample_project_data_endpoint = _Endpoint(
            settings={
                'response_type': (ProjectDataPagedList,),
                'auth': [
                    'ApiKeyAuth',
                    'JwtAuth'
                ],
                'endpoint_path': '/api/projects/{projectId}/data/nonSampleData',
                'operation_id': 'get_non_sample_project_data',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'project_id',
                    'page_offset',
                    'page_token',
                    'page_size',
                ],
                'required': [
                    'project_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'project_id':
                        (str,),
                    'page_offset':
                        (str,),
                    'page_token':
                        (str,),
                    'page_size':
                        (str,),
                },
                'attribute_map': {
                    'project_id': 'projectId',
                    'page_offset': 'pageOffset',
                    'page_token': 'pageToken',
                    'page_size': 'pageSize',
                },
                'location_map': {
                    'project_id': 'path',
                    'page_offset': 'query',
                    'page_token': 'query',
                    'page_size': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/problem+json',
                    'application/vnd.illumina.v3+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_project_data_endpoint = _Endpoint(
            settings={
                'response_type': (ProjectData,),
                'auth': [
                    'ApiKeyAuth',
                    'JwtAuth'
                ],
                'endpoint_path': '/api/projects/{projectId}/data/{dataId}',
                'operation_id': 'get_project_data',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'project_id',
                    'data_id',
                ],
                'required': [
                    'project_id',
                    'data_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'project_id':
                        (str,),
                    'data_id':
                        (str,),
                },
                'attribute_map': {
                    'project_id': 'projectId',
                    'data_id': 'dataId',
                },
                'location_map': {
                    'project_id': 'path',
                    'data_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/problem+json',
                    'application/vnd.illumina.v3+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_project_data_children_endpoint = _Endpoint(
            settings={
                'response_type': (ProjectDataPagedList,),
                'auth': [
                    'ApiKeyAuth',
                    'JwtAuth'
                ],
                'endpoint_path': '/api/projects/{projectId}/data/{dataId}/children',
                'operation_id': 'get_project_data_children',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'project_id',
                    'data_id',
                    'page_offset',
                    'page_token',
                    'page_size',
                ],
                'required': [
                    'project_id',
                    'data_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'project_id':
                        (str,),
                    'data_id':
                        (str,),
                    'page_offset':
                        (str,),
                    'page_token':
                        (str,),
                    'page_size':
                        (str,),
                },
                'attribute_map': {
                    'project_id': 'projectId',
                    'data_id': 'dataId',
                    'page_offset': 'pageOffset',
                    'page_token': 'pageToken',
                    'page_size': 'pageSize',
                },
                'location_map': {
                    'project_id': 'path',
                    'data_id': 'path',
                    'page_offset': 'query',
                    'page_token': 'query',
                    'page_size': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/problem+json',
                    'application/vnd.illumina.v4+json',
                    'application/vnd.illumina.v3+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_project_data_list_endpoint = _Endpoint(
            settings={
                'response_type': (ProjectDataPagedList,),
                'auth': [
                    'ApiKeyAuth',
                    'JwtAuth'
                ],
                'endpoint_path': '/api/projects/{projectId}/data',
                'operation_id': 'get_project_data_list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'project_id',
                    'full_text',
                    'id',
                    'filename',
                    'filename_match_mode',
                    'file_path',
                    'file_path_match_mode',
                    'status',
                    'format_id',
                    'format_code',
                    'type',
                    'parent_folder_id',
                    'parent_folder_path',
                    'creation_date_after',
                    'creation_date_before',
                    'status_date_after',
                    'status_date_before',
                    'user_tag',
                    'user_tag_match_mode',
                    'run_input_tag',
                    'run_input_tag_match_mode',
                    'run_output_tag',
                    'run_output_tag_match_mode',
                    'connector_tag',
                    'connector_tag_match_mode',
                    'technical_tag',
                    'technical_tag_match_mode',
                    'not_in_run',
                    'not_linked_to_sample',
                    'instrument_run_id',
                    'page_offset',
                    'page_token',
                    'page_size',
                    'sort',
                ],
                'required': [
                    'project_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'filename_match_mode',
                    'file_path_match_mode',
                    'status',
                    'type',
                    'user_tag_match_mode',
                    'run_input_tag_match_mode',
                    'run_output_tag_match_mode',
                    'connector_tag_match_mode',
                    'technical_tag_match_mode',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('filename_match_mode',): {

                        "EXACT": "EXACT",
                        "EXCLUDE": "EXCLUDE",
                        "FUZZY": "FUZZY"
                    },
                    ('file_path_match_mode',): {

                        "STARTS_WITH_CASE_INSENSITIVE": "STARTS_WITH_CASE_INSENSITIVE",
                        "FULL_CASE_INSENSITIVE": "FULL_CASE_INSENSITIVE"
                    },
                    ('status',): {

                        "PARTIAL": "PARTIAL",
                        "AVAILABLE": "AVAILABLE",
                        "ARCHIVING": "ARCHIVING",
                        "ARCHIVED": "ARCHIVED",
                        "UNARCHIVING": "UNARCHIVING",
                        "DELETING": "DELETING"
                    },
                    ('type',): {

                        "FILE": "FILE",
                        "FOLDER": "FOLDER"
                    },
                    ('user_tag_match_mode',): {

                        "EXACT": "EXACT",
                        "EXCLUDE": "EXCLUDE",
                        "FUZZY": "FUZZY"
                    },
                    ('run_input_tag_match_mode',): {

                        "EXACT": "EXACT",
                        "EXCLUDE": "EXCLUDE",
                        "FUZZY": "FUZZY"
                    },
                    ('run_output_tag_match_mode',): {

                        "EXACT": "EXACT",
                        "EXCLUDE": "EXCLUDE",
                        "FUZZY": "FUZZY"
                    },
                    ('connector_tag_match_mode',): {

                        "EXACT": "EXACT",
                        "EXCLUDE": "EXCLUDE",
                        "FUZZY": "FUZZY"
                    },
                    ('technical_tag_match_mode',): {

                        "EXACT": "EXACT",
                        "EXCLUDE": "EXCLUDE",
                        "FUZZY": "FUZZY"
                    },
                },
                'openapi_types': {
                    'project_id':
                        (str,),
                    'full_text':
                        (str,),
                    'id':
                        ([str],),
                    'filename':
                        ([str],),
                    'filename_match_mode':
                        (str,),
                    'file_path':
                        ([str],),
                    'file_path_match_mode':
                        (str,),
                    'status':
                        ([str],),
                    'format_id':
                        ([str],),
                    'format_code':
                        ([str],),
                    'type':
                        (str,),
                    'parent_folder_id':
                        ([str],),
                    'parent_folder_path':
                        (str,),
                    'creation_date_after':
                        (datetime,),
                    'creation_date_before':
                        (datetime,),
                    'status_date_after':
                        (datetime,),
                    'status_date_before':
                        (datetime,),
                    'user_tag':
                        ([str],),
                    'user_tag_match_mode':
                        (str,),
                    'run_input_tag':
                        ([str],),
                    'run_input_tag_match_mode':
                        (str,),
                    'run_output_tag':
                        ([str],),
                    'run_output_tag_match_mode':
                        (str,),
                    'connector_tag':
                        ([str],),
                    'connector_tag_match_mode':
                        (str,),
                    'technical_tag':
                        ([str],),
                    'technical_tag_match_mode':
                        (str,),
                    'not_in_run':
                        (bool,),
                    'not_linked_to_sample':
                        (bool,),
                    'instrument_run_id':
                        ([str],),
                    'page_offset':
                        (str,),
                    'page_token':
                        (str,),
                    'page_size':
                        (str,),
                    'sort':
                        (str,),
                },
                'attribute_map': {
                    'project_id': 'projectId',
                    'full_text': 'fullText',
                    'id': 'id',
                    'filename': 'filename',
                    'filename_match_mode': 'filenameMatchMode',
                    'file_path': 'filePath',
                    'file_path_match_mode': 'filePathMatchMode',
                    'status': 'status',
                    'format_id': 'formatId',
                    'format_code': 'formatCode',
                    'type': 'type',
                    'parent_folder_id': 'parentFolderId',
                    'parent_folder_path': 'parentFolderPath',
                    'creation_date_after': 'creationDateAfter',
                    'creation_date_before': 'creationDateBefore',
                    'status_date_after': 'statusDateAfter',
                    'status_date_before': 'statusDateBefore',
                    'user_tag': 'userTag',
                    'user_tag_match_mode': 'userTagMatchMode',
                    'run_input_tag': 'runInputTag',
                    'run_input_tag_match_mode': 'runInputTagMatchMode',
                    'run_output_tag': 'runOutputTag',
                    'run_output_tag_match_mode': 'runOutputTagMatchMode',
                    'connector_tag': 'connectorTag',
                    'connector_tag_match_mode': 'connectorTagMatchMode',
                    'technical_tag': 'technicalTag',
                    'technical_tag_match_mode': 'technicalTagMatchMode',
                    'not_in_run': 'notInRun',
                    'not_linked_to_sample': 'notLinkedToSample',
                    'instrument_run_id': 'instrumentRunId',
                    'page_offset': 'pageOffset',
                    'page_token': 'pageToken',
                    'page_size': 'pageSize',
                    'sort': 'sort',
                },
                'location_map': {
                    'project_id': 'path',
                    'full_text': 'query',
                    'id': 'query',
                    'filename': 'query',
                    'filename_match_mode': 'query',
                    'file_path': 'query',
                    'file_path_match_mode': 'query',
                    'status': 'query',
                    'format_id': 'query',
                    'format_code': 'query',
                    'type': 'query',
                    'parent_folder_id': 'query',
                    'parent_folder_path': 'query',
                    'creation_date_after': 'query',
                    'creation_date_before': 'query',
                    'status_date_after': 'query',
                    'status_date_before': 'query',
                    'user_tag': 'query',
                    'user_tag_match_mode': 'query',
                    'run_input_tag': 'query',
                    'run_input_tag_match_mode': 'query',
                    'run_output_tag': 'query',
                    'run_output_tag_match_mode': 'query',
                    'connector_tag': 'query',
                    'connector_tag_match_mode': 'query',
                    'technical_tag': 'query',
                    'technical_tag_match_mode': 'query',
                    'not_in_run': 'query',
                    'not_linked_to_sample': 'query',
                    'instrument_run_id': 'query',
                    'page_offset': 'query',
                    'page_token': 'query',
                    'page_size': 'query',
                    'sort': 'query',
                },
                'collection_format_map': {
                    'id': 'multi',
                    'filename': 'multi',
                    'file_path': 'multi',
                    'status': 'multi',
                    'format_id': 'multi',
                    'format_code': 'multi',
                    'parent_folder_id': 'multi',
                    'user_tag': 'multi',
                    'run_input_tag': 'multi',
                    'run_output_tag': 'multi',
                    'connector_tag': 'multi',
                    'technical_tag': 'multi',
                    'instrument_run_id': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/problem+json',
                    'application/vnd.illumina.v3+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_projects_linked_to_data_endpoint = _Endpoint(
            settings={
                'response_type': (ProjectList,),
                'auth': [
                    'ApiKeyAuth',
                    'JwtAuth'
                ],
                'endpoint_path': '/api/projects/{projectId}/data/{dataId}/linkedProjects',
                'operation_id': 'get_projects_linked_to_data',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'project_id',
                    'data_id',
                ],
                'required': [
                    'project_id',
                    'data_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'project_id':
                        (str,),
                    'data_id':
                        (str,),
                },
                'attribute_map': {
                    'project_id': 'projectId',
                    'data_id': 'dataId',
                },
                'location_map': {
                    'project_id': 'path',
                    'data_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/problem+json',
                    'application/vnd.illumina.v3+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_secondary_data_endpoint = _Endpoint(
            settings={
                'response_type': (DataList,),
                'auth': [
                    'ApiKeyAuth',
                    'JwtAuth'
                ],
                'endpoint_path': '/api/projects/{projectId}/data/{dataId}/secondaryData',
                'operation_id': 'get_secondary_data',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'project_id',
                    'data_id',
                ],
                'required': [
                    'project_id',
                    'data_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'project_id':
                        (str,),
                    'data_id':
                        (str,),
                },
                'attribute_map': {
                    'project_id': 'projectId',
                    'data_id': 'dataId',
                },
                'location_map': {
                    'project_id': 'path',
                    'data_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/problem+json',
                    'application/vnd.illumina.v3+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.link_data_to_project_endpoint = _Endpoint(
            settings={
                'response_type': (ProjectData,),
                'auth': [
                    'ApiKeyAuth',
                    'JwtAuth'
                ],
                'endpoint_path': '/api/projects/{projectId}/data/{dataId}',
                'operation_id': 'link_data_to_project',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'project_id',
                    'data_id',
                ],
                'required': [
                    'project_id',
                    'data_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'project_id':
                        (str,),
                    'data_id':
                        (str,),
                },
                'attribute_map': {
                    'project_id': 'projectId',
                    'data_id': 'dataId',
                },
                'location_map': {
                    'project_id': 'path',
                    'data_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/problem+json',
                    'application/vnd.illumina.v3+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.remove_secondary_data_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'ApiKeyAuth',
                    'JwtAuth'
                ],
                'endpoint_path': '/api/projects/{projectId}/data/{dataId}/secondaryData/{secondaryDataId}',
                'operation_id': 'remove_secondary_data',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'project_id',
                    'data_id',
                    'secondary_data_id',
                ],
                'required': [
                    'project_id',
                    'data_id',
                    'secondary_data_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'project_id':
                        (str,),
                    'data_id':
                        (str,),
                    'secondary_data_id':
                        (str,),
                },
                'attribute_map': {
                    'project_id': 'projectId',
                    'data_id': 'dataId',
                    'secondary_data_id': 'secondaryDataId',
                },
                'location_map': {
                    'project_id': 'path',
                    'data_id': 'path',
                    'secondary_data_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/problem+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.schedule_download_for_data_endpoint = _Endpoint(
            settings={
                'response_type': (DataTransfer,),
                'auth': [
                    'ApiKeyAuth',
                    'JwtAuth'
                ],
                'endpoint_path': '/api/projects/{projectId}/data/{dataId}:scheduleDownload',
                'operation_id': 'schedule_download_for_data',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'project_id',
                    'data_id',
                    'schedule_download',
                ],
                'required': [
                    'project_id',
                    'data_id',
                    'schedule_download',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'project_id':
                        (str,),
                    'data_id':
                        (str,),
                    'schedule_download':
                        (ScheduleDownload,),
                },
                'attribute_map': {
                    'project_id': 'projectId',
                    'data_id': 'dataId',
                },
                'location_map': {
                    'project_id': 'path',
                    'data_id': 'path',
                    'schedule_download': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.illumina.v3+json'
                ],
                'content_type': [
                    'application/vnd.illumina.v3+json',
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.unarchive_data_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'ApiKeyAuth',
                    'JwtAuth'
                ],
                'endpoint_path': '/api/projects/{projectId}/data/{dataId}:unarchive',
                'operation_id': 'unarchive_data',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'project_id',
                    'data_id',
                ],
                'required': [
                    'project_id',
                    'data_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'project_id':
                        (str,),
                    'data_id':
                        (str,),
                },
                'attribute_map': {
                    'project_id': 'projectId',
                    'data_id': 'dataId',
                },
                'location_map': {
                    'project_id': 'path',
                    'data_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/problem+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.unlink_data_from_project_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'ApiKeyAuth',
                    'JwtAuth'
                ],
                'endpoint_path': '/api/projects/{projectId}/data/{dataId}:unlink',
                'operation_id': 'unlink_data_from_project',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'project_id',
                    'data_id',
                ],
                'required': [
                    'project_id',
                    'data_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'project_id':
                        (str,),
                    'data_id':
                        (str,),
                },
                'attribute_map': {
                    'project_id': 'projectId',
                    'data_id': 'dataId',
                },
                'location_map': {
                    'project_id': 'path',
                    'data_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/problem+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.update_project_data_endpoint = _Endpoint(
            settings={
                'response_type': (ProjectData,),
                'auth': [
                    'ApiKeyAuth',
                    'JwtAuth'
                ],
                'endpoint_path': '/api/projects/{projectId}/data/{dataId}',
                'operation_id': 'update_project_data',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'project_id',
                    'data_id',
                    'project_data',
                ],
                'required': [
                    'project_id',
                    'data_id',
                ],
                'nullable': [
                    'project_data',
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'project_id':
                        (str,),
                    'data_id':
                        (str,),
                    'project_data':
                        (ProjectData,),
                },
                'attribute_map': {
                    'project_id': 'projectId',
                    'data_id': 'dataId',
                },
                'location_map': {
                    'project_id': 'path',
                    'data_id': 'path',
                    'project_data': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/problem+json',
                    'application/vnd.illumina.v3+json'
                ],
                'content_type': [
                    'application/vnd.illumina.v3+json',
                    'application/json'
                ]
            },
            api_client=api_client
        )

    def add_secondary_data(
        self,
        project_id,
        data_id,
        secondary_data_id,
        **kwargs
    ):
        """Add secondary data to data.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_secondary_data(project_id, data_id, secondary_data_id, async_req=True)
        >>> result = thread.get()

        Args:
            project_id (str):
            data_id (str):
            secondary_data_id (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['project_id'] = \
            project_id
        kwargs['data_id'] = \
            data_id
        kwargs['secondary_data_id'] = \
            secondary_data_id
        return self.add_secondary_data_endpoint.call_with_http_info(**kwargs)

    def archive_data(
        self,
        project_id,
        data_id,
        **kwargs
    ):
        """Schedule this data for archival.  # noqa: E501

        Endpoint for scheduling this data for archival. This will also archive all files and directories below that data.This is a non-RESTful endpoint, as the path of this endpoint is not representing a REST resource.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.archive_data(project_id, data_id, async_req=True)
        >>> result = thread.get()

        Args:
            project_id (str):
            data_id (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['project_id'] = \
            project_id
        kwargs['data_id'] = \
            data_id
        return self.archive_data_endpoint.call_with_http_info(**kwargs)

    def complete_folder_upload_session(
        self,
        project_id,
        data_id,
        folder_upload_session_id,
        **kwargs
    ):
        """Complete a trackable folder upload session.  # noqa: E501

        Complete a trackable folder upload session. By completing the folder upload session, and specifying how many files you have uploaded, ICA can ensure that all uploaded files are accounted for.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.complete_folder_upload_session(project_id, data_id, folder_upload_session_id, async_req=True)
        >>> result = thread.get()

        Args:
            project_id (str):
            data_id (str):
            folder_upload_session_id (str):

        Keyword Args:
            complete_folder_upload_session (CompleteFolderUploadSession): The info required to complete the folder upload session.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            FolderUploadSession
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['project_id'] = \
            project_id
        kwargs['data_id'] = \
            data_id
        kwargs['folder_upload_session_id'] = \
            folder_upload_session_id
        return self.complete_folder_upload_session_endpoint.call_with_http_info(**kwargs)

    def create_data_in_project(
        self,
        project_id,
        **kwargs
    ):
        """Create data in this project.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_data_in_project(project_id, async_req=True)
        >>> result = thread.get()

        Args:
            project_id (str):

        Keyword Args:
            create_data (CreateData): The data to create.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            ProjectData
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['project_id'] = \
            project_id
        return self.create_data_in_project_endpoint.call_with_http_info(**kwargs)

    def create_download_url_for_data(
        self,
        project_id,
        data_id,
        **kwargs
    ):
        """Retrieve a download URL for this data.  # noqa: E501

        Can be used to download a file directly from the region where it is located, no connector is needed. Not applicable for Folder.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_download_url_for_data(project_id, data_id, async_req=True)
        >>> result = thread.get()

        Args:
            project_id (str):
            data_id (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Download
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['project_id'] = \
            project_id
        kwargs['data_id'] = \
            data_id
        return self.create_download_url_for_data_endpoint.call_with_http_info(**kwargs)

    def create_download_urls_for_data(
        self,
        project_id,
        **kwargs
    ):
        """Retrieve download URLs for the data.  # noqa: E501

        Can be used to download files directly from the region where it is located, no connector is needed. Not applicable for Folders.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_download_urls_for_data(project_id, async_req=True)
        >>> result = thread.get()

        Args:
            project_id (str):

        Keyword Args:
            data_id_or_path_list (DataIdOrPathList): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            DataUrlWithPathList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['project_id'] = \
            project_id
        return self.create_download_urls_for_data_endpoint.call_with_http_info(**kwargs)

    def create_folder_upload_session(
        self,
        project_id,
        data_id,
        **kwargs
    ):
        """Create a trackable folder upload session.  # noqa: E501

        This endpoint can be used to ensure that all uploaded files within the requested session are accounted for. This call has to be used together with the :complete endpoint once upload is done.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_folder_upload_session(project_id, data_id, async_req=True)
        >>> result = thread.get()

        Args:
            project_id (str):
            data_id (str):

        Keyword Args:
            create_temporary_credentials (CreateTemporaryCredentials): Temporary credentials request options.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            FolderUploadSession
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['project_id'] = \
            project_id
        kwargs['data_id'] = \
            data_id
        return self.create_folder_upload_session_endpoint.call_with_http_info(**kwargs)

    def create_inline_view_url_for_data(
        self,
        project_id,
        data_id,
        **kwargs
    ):
        """Retrieve an URL for this data to use for inline view in a browser.  # noqa: E501

        Can be used to view a file directly from the region where it is located, no connector is needed.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_inline_view_url_for_data(project_id, data_id, async_req=True)
        >>> result = thread.get()

        Args:
            project_id (str):
            data_id (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            InlineView
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['project_id'] = \
            project_id
        kwargs['data_id'] = \
            data_id
        return self.create_inline_view_url_for_data_endpoint.call_with_http_info(**kwargs)

    def create_temporary_credentials_for_data(
        self,
        project_id,
        data_id,
        **kwargs
    ):
        """Retrieve temporary credentials for this data.  # noqa: E501

        Can be used to upload or download a file directly from the region where it is located, no connector is needed.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_temporary_credentials_for_data(project_id, data_id, async_req=True)
        >>> result = thread.get()

        Args:
            project_id (str):
            data_id (str):

        Keyword Args:
            create_temporary_credentials (CreateTemporaryCredentials): Temporary credentials request options.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            TempCredentials
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['project_id'] = \
            project_id
        kwargs['data_id'] = \
            data_id
        return self.create_temporary_credentials_for_data_endpoint.call_with_http_info(**kwargs)

    def create_upload_url_for_data(
        self,
        project_id,
        data_id,
        **kwargs
    ):
        """Retrieve an upload URL for this data.  # noqa: E501

        Can be used to upload a file directly from the region where it is located, no connector is needed.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_upload_url_for_data(project_id, data_id, async_req=True)
        >>> result = thread.get()

        Args:
            project_id (str):
            data_id (str):

        Keyword Args:
            file_type (str): [optional]
            hash (str): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Upload
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['project_id'] = \
            project_id
        kwargs['data_id'] = \
            data_id
        return self.create_upload_url_for_data_endpoint.call_with_http_info(**kwargs)

    def delete_data(
        self,
        project_id,
        data_id,
        **kwargs
    ):
        """Schedule this data for deletion.  # noqa: E501

        Endpoint for scheduling this data for deletion. This will also delete all files and directories below that data.This is a non-RESTful endpoint, as the path of this endpoint is not representing a REST resource.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_data(project_id, data_id, async_req=True)
        >>> result = thread.get()

        Args:
            project_id (str):
            data_id (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['project_id'] = \
            project_id
        kwargs['data_id'] = \
            data_id
        return self.delete_data_endpoint.call_with_http_info(**kwargs)

    def get_data_eligible_for_linking(
        self,
        project_id,
        **kwargs
    ):
        """Retrieve a list of data eligible for linking to the current project.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_data_eligible_for_linking(project_id, async_req=True)
        >>> result = thread.get()

        Args:
            project_id (str):

        Keyword Args:
            full_text (str): To search through multiple fields of data.. [optional]
            id ([str]): The ids to filter on. This will always match exact.. [optional]
            filename ([str]): The filenames to filter on. The filenameMatchMode-parameter determines how the filtering is done.. [optional]
            filename_match_mode (str): How the filenames are filtered. . [optional]
            file_path ([str]): The paths of the files to filter on.. [optional]
            file_path_match_mode (str): How the file paths are filtered:   - STARTS_WITH_CASE_INSENSITIVE: Filters the file path to start with the value of the 'filePath' parameter, regardless of upper/lower casing. This allows e.g. listing all data in a folder and all it's sub-folders (recursively).  - FULL_CASE_INSENSITIVE: Filters the file path to fully match the value of the 'filePath' parameter, regardless of upper/lower casing. Note that this can result in multiple results if e.g. two files exist with the same filename but different casing (abc.txt and ABC.txt).. [optional] if omitted the server will use the default value of "STARTS_WITH_CASE_INSENSITIVE"
            status ([str]): The statuses to filter on.. [optional]
            format_id ([str]): The IDs of the formats to filter on.. [optional]
            format_code ([str]): The codes of the formats to filter on.. [optional]
            type (str): The type to filter on.. [optional]
            parent_folder_id ([str]): The IDs of parents folders to filter on. Lists all files and folders within the folder for the given ID, non-recursively.. [optional]
            parent_folder_path (str): The full path of the parent folder. Should start and end with a '/'. Lists all files and folders within the folder for the given path, non-recursively. This can be used to browse through the hierarchical tree of folders, e.g. traversing one level up can be done by removing the last part of the path.. [optional]
            creation_date_after (datetime): The date after which the data is created. Format: yyyy-MM-dd'T'HH:mm:ss'Z' eg: 2021-01-30T08:30:00Z. [optional]
            creation_date_before (datetime): The date before which the data is created. Format: yyyy-MM-dd'T'HH:mm:ss'Z' eg: 2021-01-30T08:30:00Z. [optional]
            status_date_after (datetime): The date after which the status has been updated. Format: yyyy-MM-dd'T'HH:mm:ss'Z' eg: 2021-01-30T08:30:00Z. [optional]
            status_date_before (datetime): The date before which the status has been updated. Format: yyyy-MM-dd'T'HH:mm:ss'Z' eg: 2021-01-30T08:30:00Z. [optional]
            user_tag ([str]): The usertags to filter on. The userTagMatchMode-parameter determines how the filtering is done.. [optional]
            user_tag_match_mode (str): How the usertags are filtered. . [optional]
            run_input_tag ([str]): The runInputTags to filter on. The runInputTagMatchMode-parameter determines how the filtering is done.. [optional]
            run_input_tag_match_mode (str): How the runInputTags are filtered. . [optional]
            run_output_tag ([str]): The runOutputTags to filter on. The runOutputTagMatchMode-parameter determines how the filtering is done.. [optional]
            run_output_tag_match_mode (str): How the runOutputTags are filtered. . [optional]
            connector_tag ([str]): The connectorTags to filter on. The connectorTagMatchMode-parameter determines how the filtering is done.. [optional]
            connector_tag_match_mode (str): How the connectorTags are filtered. . [optional]
            technical_tag ([str]): The technicalTags to filter on. The techTagMatchMode-parameter determines how the filtering is done.. [optional]
            technical_tag_match_mode (str): How the technicalTags are filtered. . [optional]
            not_in_run (bool): When set to true, the data will be filtered on data which is not used in a run.. [optional]
            not_linked_to_sample (bool): When set to true only data that is unlinked to a sample will be returned. This filter implies a filter of type File.. [optional]
            instrument_run_id ([str]): The instrument run IDs of the sequencing runs to filter on.. [optional]
            page_offset (str): The amount of rows to skip in the result. Ideally this is a multiple of the size parameter. Offset-based pagination has a result limit of 200K rows and does not guarantee unique results across pages. [optional]
            page_token (str): The cursor to get subsequent results. The value to use is returned in the result when using cursor-based pagination. Cursor-based pagination guarantees complete and unique results across all pages.. [optional]
            page_size (str): The amount of rows to return. Use in combination with the offset or cursor parameter to get subsequent results.. [optional]
            sort (str): Which field to order the results by. The default order is ascending, suffix with ' desc' to sort descending (suffix ' asc' also works for ascending). Multiple values should be separated with commas. An example: \"?sort=dateCreated, lastName desc\"  The attributes for which sorting is supported: - timeCreated - timeModified - name - path - fileSizeInBytes - status - format - dataType - willBeArchivedAt - willBeDeletedAt. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            DataPagedList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['project_id'] = \
            project_id
        return self.get_data_eligible_for_linking_endpoint.call_with_http_info(**kwargs)

    def get_folder_upload_session(
        self,
        project_id,
        data_id,
        folder_upload_session_id,
        **kwargs
    ):
        """Retrieve folder upload session details.  # noqa: E501

        Retrieve folder upload session details, including the current status of your upload session.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_folder_upload_session(project_id, data_id, folder_upload_session_id, async_req=True)
        >>> result = thread.get()

        Args:
            project_id (str):
            data_id (str):
            folder_upload_session_id (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            FolderUploadSession
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['project_id'] = \
            project_id
        kwargs['data_id'] = \
            data_id
        kwargs['folder_upload_session_id'] = \
            folder_upload_session_id
        return self.get_folder_upload_session_endpoint.call_with_http_info(**kwargs)

    def get_non_sample_project_data(
        self,
        project_id,
        **kwargs
    ):
        """Retrieve a list of project data not linked to a sample.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_non_sample_project_data(project_id, async_req=True)
        >>> result = thread.get()

        Args:
            project_id (str):

        Keyword Args:
            page_offset (str): The amount of rows to skip in the result. Ideally this is a multiple of the size parameter. Offset-based pagination has a result limit of 200K rows and does not guarantee unique results across pages. [optional]
            page_token (str): The cursor to get subsequent results. The value to use is returned in the result when using cursor-based pagination. Cursor-based pagination guarantees complete and unique results across all pages.. [optional]
            page_size (str): The amount of rows to return. Use in combination with the offset or cursor parameter to get subsequent results.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            ProjectDataPagedList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['project_id'] = \
            project_id
        return self.get_non_sample_project_data_endpoint.call_with_http_info(**kwargs)

    def get_project_data(
        self,
        project_id,
        data_id,
        **kwargs
    ):
        """Retrieve a project data.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_project_data(project_id, data_id, async_req=True)
        >>> result = thread.get()

        Args:
            project_id (str):
            data_id (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            ProjectData
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['project_id'] = \
            project_id
        kwargs['data_id'] = \
            data_id
        return self.get_project_data_endpoint.call_with_http_info(**kwargs)

    def get_project_data_children(
        self,
        project_id,
        data_id,
        **kwargs
    ):
        """Retrieve the children of this data.  # noqa: E501

        # Changelog For this endpoint multiple versions exist. Note that the values for request headers 'Content-Type' and 'Accept' must contain a matching version.  ## [V3] Initial version ## [V4] Added pagination   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_project_data_children(project_id, data_id, async_req=True)
        >>> result = thread.get()

        Args:
            project_id (str):
            data_id (str):

        Keyword Args:
            page_offset (str): The amount of rows to skip in the result. Ideally this is a multiple of the size parameter. Offset-based pagination has a result limit of 200K rows and does not guarantee unique results across pages. [optional]
            page_token (str): The cursor to get subsequent results. The value to use is returned in the result when using cursor-based pagination. Cursor-based pagination guarantees complete and unique results across all pages.. [optional]
            page_size (str): The amount of rows to return. Use in combination with the offset or cursor parameter to get subsequent results.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            ProjectDataPagedList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['project_id'] = \
            project_id
        kwargs['data_id'] = \
            data_id
        return self.get_project_data_children_endpoint.call_with_http_info(**kwargs)

    def get_project_data_list(
        self,
        project_id,
        **kwargs
    ):
        """Retrieve the list of project data.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_project_data_list(project_id, async_req=True)
        >>> result = thread.get()

        Args:
            project_id (str):

        Keyword Args:
            full_text (str): To search through multiple fields of data.. [optional]
            id ([str]): The ids to filter on. This will always match exact.. [optional]
            filename ([str]): The filenames to filter on. The filenameMatchMode-parameter determines how the filtering is done.. [optional]
            filename_match_mode (str): How the filenames are filtered. . [optional]
            file_path ([str]): The paths of the files to filter on.. [optional]
            file_path_match_mode (str): How the file paths are filtered:   - STARTS_WITH_CASE_INSENSITIVE: Filters the file path to start with the value of the 'filePath' parameter, regardless of upper/lower casing. This allows e.g. listing all data in a folder and all it's sub-folders (recursively).  - FULL_CASE_INSENSITIVE: Filters the file path to fully match the value of the 'filePath' parameter, regardless of upper/lower casing. Note that this can result in multiple results if e.g. two files exist with the same filename but different casing (abc.txt and ABC.txt).. [optional] if omitted the server will use the default value of "STARTS_WITH_CASE_INSENSITIVE"
            status ([str]): The statuses to filter on.. [optional]
            format_id ([str]): The IDs of the formats to filter on.. [optional]
            format_code ([str]): The codes of the formats to filter on.. [optional]
            type (str): The type to filter on.. [optional]
            parent_folder_id ([str]): The IDs of parents folders to filter on. Lists all files and folders within the folder for the given ID, non-recursively.. [optional]
            parent_folder_path (str): The full path of the parent folder. Should start and end with a '/'. Lists all files and folders within the folder for the given path, non-recursively. This can be used to browse through the hierarchical tree of folders, e.g. traversing one level up can be done by removing the last part of the path.. [optional]
            creation_date_after (datetime): The date after which the data is created. Format: yyyy-MM-dd'T'HH:mm:ss'Z' eg: 2021-01-30T08:30:00Z. [optional]
            creation_date_before (datetime): The date before which the data is created. Format: yyyy-MM-dd'T'HH:mm:ss'Z' eg: 2021-01-30T08:30:00Z. [optional]
            status_date_after (datetime): The date after which the status has been updated. Format: yyyy-MM-dd'T'HH:mm:ss'Z' eg: 2021-01-30T08:30:00Z. [optional]
            status_date_before (datetime): The date before which the status has been updated. Format: yyyy-MM-dd'T'HH:mm:ss'Z' eg: 2021-01-30T08:30:00Z. [optional]
            user_tag ([str]): The usertags to filter on. The userTagMatchMode-parameter determines how the filtering is done.. [optional]
            user_tag_match_mode (str): How the usertags are filtered. . [optional]
            run_input_tag ([str]): The runInputTags to filter on. The runInputTagMatchMode-parameter determines how the filtering is done.. [optional]
            run_input_tag_match_mode (str): How the runInputTags are filtered. . [optional]
            run_output_tag ([str]): The runOutputTags to filter on. The runOutputTagMatchMode-parameter determines how the filtering is done.. [optional]
            run_output_tag_match_mode (str): How the runOutputTags are filtered. . [optional]
            connector_tag ([str]): The connectorTags to filter on. The connectorTagMatchMode-parameter determines how the filtering is done.. [optional]
            connector_tag_match_mode (str): How the connectorTags are filtered. . [optional]
            technical_tag ([str]): The technicalTags to filter on. The techTagMatchMode-parameter determines how the filtering is done.. [optional]
            technical_tag_match_mode (str): How the technicalTags are filtered. . [optional]
            not_in_run (bool): When set to true, the data will be filtered on data which is not used in a run.. [optional]
            not_linked_to_sample (bool): When set to true only data that is unlinked to a sample will be returned.  This filter implies a filter of type File.. [optional]
            instrument_run_id ([str]): The instrument run IDs of the sequencing runs to filter on.. [optional]
            page_offset (str): The amount of rows to skip in the result. Ideally this is a multiple of the size parameter. Offset-based pagination has a result limit of 200K rows and does not guarantee unique results across pages. [optional]
            page_token (str): The cursor to get subsequent results. The value to use is returned in the result when using cursor-based pagination. Cursor-based pagination guarantees complete and unique results across all pages.. [optional]
            page_size (str): The amount of rows to return. Use in combination with the offset or cursor parameter to get subsequent results.. [optional]
            sort (str): Which field to order the results by. The default order is ascending, suffix with ' desc' to sort descending (suffix ' asc' also works for ascending). Multiple values should be separated with commas. An example: \"?sort=dateCreated, lastName desc\"  The attributes for which sorting is supported: - timeCreated - timeModified - name - path - fileSizeInBytes - status - format - dataType - willBeArchivedAt - willBeDeletedAt. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            ProjectDataPagedList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['project_id'] = \
            project_id
        return self.get_project_data_list_endpoint.call_with_http_info(**kwargs)

    def get_projects_linked_to_data(
        self,
        project_id,
        data_id,
        **kwargs
    ):
        """Retrieve a list of projects to which this data is linked.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_projects_linked_to_data(project_id, data_id, async_req=True)
        >>> result = thread.get()

        Args:
            project_id (str):
            data_id (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            ProjectList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['project_id'] = \
            project_id
        kwargs['data_id'] = \
            data_id
        return self.get_projects_linked_to_data_endpoint.call_with_http_info(**kwargs)

    def get_secondary_data(
        self,
        project_id,
        data_id,
        **kwargs
    ):
        """Retrieve a list of secondary data for data.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_secondary_data(project_id, data_id, async_req=True)
        >>> result = thread.get()

        Args:
            project_id (str):
            data_id (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            DataList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['project_id'] = \
            project_id
        kwargs['data_id'] = \
            data_id
        return self.get_secondary_data_endpoint.call_with_http_info(**kwargs)

    def link_data_to_project(
        self,
        project_id,
        data_id,
        **kwargs
    ):
        """Link data to this project.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.link_data_to_project(project_id, data_id, async_req=True)
        >>> result = thread.get()

        Args:
            project_id (str):
            data_id (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            ProjectData
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['project_id'] = \
            project_id
        kwargs['data_id'] = \
            data_id
        return self.link_data_to_project_endpoint.call_with_http_info(**kwargs)

    def remove_secondary_data(
        self,
        project_id,
        data_id,
        secondary_data_id,
        **kwargs
    ):
        """Remove secondary data from data.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.remove_secondary_data(project_id, data_id, secondary_data_id, async_req=True)
        >>> result = thread.get()

        Args:
            project_id (str):
            data_id (str):
            secondary_data_id (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['project_id'] = \
            project_id
        kwargs['data_id'] = \
            data_id
        kwargs['secondary_data_id'] = \
            secondary_data_id
        return self.remove_secondary_data_endpoint.call_with_http_info(**kwargs)

    def schedule_download_for_data(
        self,
        project_id,
        data_id,
        schedule_download,
        **kwargs
    ):
        """Schedule a download.  # noqa: E501

        Endpoint for scheduling a download for the data specified by the ID to a connector. This download will only start when the connector is running. This is a non-RESTful endpoint, as the path of this endpoint is not representing a REST resource.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.schedule_download_for_data(project_id, data_id, schedule_download, async_req=True)
        >>> result = thread.get()

        Args:
            project_id (str):
            data_id (str):
            schedule_download (ScheduleDownload):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            DataTransfer
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['project_id'] = \
            project_id
        kwargs['data_id'] = \
            data_id
        kwargs['schedule_download'] = \
            schedule_download
        return self.schedule_download_for_data_endpoint.call_with_http_info(**kwargs)

    def unarchive_data(
        self,
        project_id,
        data_id,
        **kwargs
    ):
        """Schedule this data for unarchival.  # noqa: E501

        Endpoint for scheduling this data for unarchival. This will also unarchive all files and directories below that data. This is a non-RESTful endpoint, as the path of this endpoint is not representing a REST resource.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.unarchive_data(project_id, data_id, async_req=True)
        >>> result = thread.get()

        Args:
            project_id (str):
            data_id (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['project_id'] = \
            project_id
        kwargs['data_id'] = \
            data_id
        return self.unarchive_data_endpoint.call_with_http_info(**kwargs)

    def unlink_data_from_project(
        self,
        project_id,
        data_id,
        **kwargs
    ):
        """Unlink data from this project.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.unlink_data_from_project(project_id, data_id, async_req=True)
        >>> result = thread.get()

        Args:
            project_id (str):
            data_id (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['project_id'] = \
            project_id
        kwargs['data_id'] = \
            data_id
        return self.unlink_data_from_project_endpoint.call_with_http_info(**kwargs)

    def update_project_data(
        self,
        project_id,
        data_id,
        **kwargs
    ):
        """Update this project data.  # noqa: E501

        Fields which can be updated for files:  - data.willBeArchivedAt  - data.willBeDeletedAt  - data.format  - data.tags  Fields which can be updated for folders:  - data.tags    # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_project_data(project_id, data_id, async_req=True)
        >>> result = thread.get()

        Args:
            project_id (str):
            data_id (str):

        Keyword Args:
            project_data (ProjectData): The updated project data.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            ProjectData
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['project_id'] = \
            project_id
        kwargs['data_id'] = \
            data_id
        return self.update_project_data_endpoint.call_with_http_info(**kwargs)

