"""
    ICA Rest API

    This API can be used to interact with Illumina Connected Analytics.<br> <p> Authentication to the  API can be done in multiple ways:<br> <ul><li>For the entire API, except for the POST /tokens endpoint: API-key + JWT</li> <li>Only for the POST /tokens endpoint: API-key + Basic Authentication</li></ul> </p> <p> <b>API-key</b><br> API keys are managed within the Illumina portal where you can manage your profile after you have logged on. The API-key has to be provided in the X-API-Key header parameter when executing API calls to ICA. In the background, a JWT will be requested at the IDP of Illumina to create a session. A good practice is to not use the API-key for every API call, but to first generate a JWT and to use that for authentication in subsequent calls.<br> </p> <p> <b>JWT</b><br> To avoid using an API-key for each call, we recommend to request a JWT via the POST /tokens endpoint  using this API-key. The JWT will expire after a pre-configured period specified by a tenant administrator through the IAM console in the Illumina portal. The JWT is the preferred way for authentication.<br>A not yet expired, still valid JWT could be refreshed using the POST /tokens:refresh endpoint.<br> </p> <p> <b>Basic Authentication</b><br> Basic authentication is only supported by the POST /tokens endpoint for generating a JWT. Use \"Basic base64encoded(emailaddress:password)\" in the \"Authorization\" header parameter for this authentication method. In case having access to multiple tenants using the same email-address, also provide the \"tenant\" request parameter to indicate what tenant you would like to request a JWT for. </p>   # noqa: E501

    The version of the OpenAPI document: 3
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from libica.openapi.v2.api_client import ApiClient, Endpoint as _Endpoint
from libica.openapi.v2.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from libica.openapi.v2.model.bundle_data_paged_list import BundleDataPagedList
from libica.openapi.v2.model.problem import Problem


class BundleDataApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.get_bundle_data_endpoint = _Endpoint(
            settings={
                'response_type': (BundleDataPagedList,),
                'auth': [
                    'ApiKeyAuth',
                    'JwtAuth'
                ],
                'endpoint_path': '/api/bundles/{bundleId}/data',
                'operation_id': 'get_bundle_data',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'bundle_id',
                    'full_text',
                    'id',
                    'filename',
                    'filename_match_mode',
                    'file_path',
                    'file_path_match_mode',
                    'status',
                    'format_id',
                    'format_code',
                    'type',
                    'parent_folder_id',
                    'parent_folder_path',
                    'creation_date_after',
                    'creation_date_before',
                    'status_date_after',
                    'status_date_before',
                    'user_tag',
                    'user_tag_match_mode',
                    'run_input_tag',
                    'run_input_tag_match_mode',
                    'run_output_tag',
                    'run_output_tag_match_mode',
                    'connector_tag',
                    'connector_tag_match_mode',
                    'technical_tag',
                    'technical_tag_match_mode',
                    'not_in_run',
                    'not_linked_to_sample',
                    'instrument_run_id',
                    'page_offset',
                    'page_token',
                    'page_size',
                    'sort',
                ],
                'required': [
                    'bundle_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'filename_match_mode',
                    'file_path_match_mode',
                    'status',
                    'type',
                    'user_tag_match_mode',
                    'run_input_tag_match_mode',
                    'run_output_tag_match_mode',
                    'connector_tag_match_mode',
                    'technical_tag_match_mode',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('filename_match_mode',): {

                        "EXACT": "EXACT",
                        "EXCLUDE": "EXCLUDE",
                        "FUZZY": "FUZZY"
                    },
                    ('file_path_match_mode',): {

                        "STARTS_WITH_CASE_INSENSITIVE": "STARTS_WITH_CASE_INSENSITIVE",
                        "FULL_CASE_INSENSITIVE": "FULL_CASE_INSENSITIVE"
                    },
                    ('status',): {

                        "PARTIAL": "PARTIAL",
                        "AVAILABLE": "AVAILABLE",
                        "ARCHIVING": "ARCHIVING",
                        "ARCHIVED": "ARCHIVED",
                        "UNARCHIVING": "UNARCHIVING",
                        "DELETING": "DELETING"
                    },
                    ('type',): {

                        "FILE": "FILE",
                        "FOLDER": "FOLDER"
                    },
                    ('user_tag_match_mode',): {

                        "EXACT": "EXACT",
                        "EXCLUDE": "EXCLUDE",
                        "FUZZY": "FUZZY"
                    },
                    ('run_input_tag_match_mode',): {

                        "EXACT": "EXACT",
                        "EXCLUDE": "EXCLUDE",
                        "FUZZY": "FUZZY"
                    },
                    ('run_output_tag_match_mode',): {

                        "EXACT": "EXACT",
                        "EXCLUDE": "EXCLUDE",
                        "FUZZY": "FUZZY"
                    },
                    ('connector_tag_match_mode',): {

                        "EXACT": "EXACT",
                        "EXCLUDE": "EXCLUDE",
                        "FUZZY": "FUZZY"
                    },
                    ('technical_tag_match_mode',): {

                        "EXACT": "EXACT",
                        "EXCLUDE": "EXCLUDE",
                        "FUZZY": "FUZZY"
                    },
                },
                'openapi_types': {
                    'bundle_id':
                        (str,),
                    'full_text':
                        (str,),
                    'id':
                        (str,),
                    'filename':
                        (str,),
                    'filename_match_mode':
                        (str,),
                    'file_path':
                        (str,),
                    'file_path_match_mode':
                        (str,),
                    'status':
                        (str,),
                    'format_id':
                        (str,),
                    'format_code':
                        (str,),
                    'type':
                        (str,),
                    'parent_folder_id':
                        (str,),
                    'parent_folder_path':
                        (str,),
                    'creation_date_after':
                        (str,),
                    'creation_date_before':
                        (str,),
                    'status_date_after':
                        (str,),
                    'status_date_before':
                        (str,),
                    'user_tag':
                        (str,),
                    'user_tag_match_mode':
                        (str,),
                    'run_input_tag':
                        (str,),
                    'run_input_tag_match_mode':
                        (str,),
                    'run_output_tag':
                        (str,),
                    'run_output_tag_match_mode':
                        (str,),
                    'connector_tag':
                        (str,),
                    'connector_tag_match_mode':
                        (str,),
                    'technical_tag':
                        (str,),
                    'technical_tag_match_mode':
                        (str,),
                    'not_in_run':
                        (str,),
                    'not_linked_to_sample':
                        (str,),
                    'instrument_run_id':
                        ([str],),
                    'page_offset':
                        (str,),
                    'page_token':
                        (str,),
                    'page_size':
                        (str,),
                    'sort':
                        (str,),
                },
                'attribute_map': {
                    'bundle_id': 'bundleId',
                    'full_text': 'fullText',
                    'id': 'id',
                    'filename': 'filename',
                    'filename_match_mode': 'filenameMatchMode',
                    'file_path': 'filePath',
                    'file_path_match_mode': 'filePathMatchMode',
                    'status': 'status',
                    'format_id': 'formatId',
                    'format_code': 'formatCode',
                    'type': 'type',
                    'parent_folder_id': 'parentFolderId',
                    'parent_folder_path': 'parentFolderPath',
                    'creation_date_after': 'creationDateAfter',
                    'creation_date_before': 'creationDateBefore',
                    'status_date_after': 'statusDateAfter',
                    'status_date_before': 'statusDateBefore',
                    'user_tag': 'userTag',
                    'user_tag_match_mode': 'userTagMatchMode',
                    'run_input_tag': 'runInputTag',
                    'run_input_tag_match_mode': 'runInputTagMatchMode',
                    'run_output_tag': 'runOutputTag',
                    'run_output_tag_match_mode': 'runOutputTagMatchMode',
                    'connector_tag': 'connectorTag',
                    'connector_tag_match_mode': 'connectorTagMatchMode',
                    'technical_tag': 'technicalTag',
                    'technical_tag_match_mode': 'technicalTagMatchMode',
                    'not_in_run': 'notInRun',
                    'not_linked_to_sample': 'notLinkedToSample',
                    'instrument_run_id': 'instrumentRunId',
                    'page_offset': 'pageOffset',
                    'page_token': 'pageToken',
                    'page_size': 'pageSize',
                    'sort': 'sort',
                },
                'location_map': {
                    'bundle_id': 'path',
                    'full_text': 'query',
                    'id': 'query',
                    'filename': 'query',
                    'filename_match_mode': 'query',
                    'file_path': 'query',
                    'file_path_match_mode': 'query',
                    'status': 'query',
                    'format_id': 'query',
                    'format_code': 'query',
                    'type': 'query',
                    'parent_folder_id': 'query',
                    'parent_folder_path': 'query',
                    'creation_date_after': 'query',
                    'creation_date_before': 'query',
                    'status_date_after': 'query',
                    'status_date_before': 'query',
                    'user_tag': 'query',
                    'user_tag_match_mode': 'query',
                    'run_input_tag': 'query',
                    'run_input_tag_match_mode': 'query',
                    'run_output_tag': 'query',
                    'run_output_tag_match_mode': 'query',
                    'connector_tag': 'query',
                    'connector_tag_match_mode': 'query',
                    'technical_tag': 'query',
                    'technical_tag_match_mode': 'query',
                    'not_in_run': 'query',
                    'not_linked_to_sample': 'query',
                    'instrument_run_id': 'query',
                    'page_offset': 'query',
                    'page_token': 'query',
                    'page_size': 'query',
                    'sort': 'query',
                },
                'collection_format_map': {
                    'instrument_run_id': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/problem+json',
                    'application/vnd.illumina.v3+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.link_data_to_bundle_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'ApiKeyAuth',
                    'JwtAuth'
                ],
                'endpoint_path': '/api/bundles/{bundleId}/data/{dataId}',
                'operation_id': 'link_data_to_bundle',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'bundle_id',
                    'data_id',
                ],
                'required': [
                    'bundle_id',
                    'data_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'bundle_id':
                        (str,),
                    'data_id':
                        (str,),
                },
                'attribute_map': {
                    'bundle_id': 'bundleId',
                    'data_id': 'dataId',
                },
                'location_map': {
                    'bundle_id': 'path',
                    'data_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/problem+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.unlink_data_from_bundle_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'ApiKeyAuth',
                    'JwtAuth'
                ],
                'endpoint_path': '/api/bundles/{bundleId}/data/{dataId}',
                'operation_id': 'unlink_data_from_bundle',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'bundle_id',
                    'data_id',
                ],
                'required': [
                    'bundle_id',
                    'data_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'bundle_id':
                        (str,),
                    'data_id':
                        (str,),
                },
                'attribute_map': {
                    'bundle_id': 'bundleId',
                    'data_id': 'dataId',
                },
                'location_map': {
                    'bundle_id': 'path',
                    'data_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/problem+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

    def get_bundle_data(
        self,
        bundle_id,
        **kwargs
    ):
        """Retrieve the list of bundle data.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_bundle_data(bundle_id, async_req=True)
        >>> result = thread.get()

        Args:
            bundle_id (str):

        Keyword Args:
            full_text (str): To search through multiple fields of data.. [optional]
            id (str): The ids to filter on. This will always match exact.. [optional]
            filename (str): The filenames to filter on. The filenameMatchMode-parameter determines how the filtering is done.. [optional]
            filename_match_mode (str): How the filenames are filtered.. [optional]
            file_path (str): The paths of the files to filter on.. [optional]
            file_path_match_mode (str): How the file paths are filtered:   - STARTS_WITH_CASE_INSENSITIVE: Filters the file path to start with the value of the 'filePath' parameter, regardless of upper/lower casing. This allows e.g. listing all data in a folder and all it's sub-folders (recursively).  - FULL_CASE_INSENSITIVE: Filters the file path to fully match the value of the 'filePath' parameter, regardless of upper/lower casing. Note that this can result in multiple results if e.g. two files exist with the same filename but different casing (abc.txt and ABC.txt).. [optional] if omitted the server will use the default value of "STARTS_WITH_CASE_INSENSITIVE"
            status (str): The statuses to filter on.. [optional]
            format_id (str): The IDs of the formats to filter on.. [optional]
            format_code (str): The codes of the formats to filter on.. [optional]
            type (str): The type to filter on.. [optional]
            parent_folder_id (str): The IDs of parents folders to filter on. Lists all files and folders within the folder for the given ID, non-recursively.. [optional]
            parent_folder_path (str): The full path of the parent folder. Should start and end with a '/'. Lists all files and folders within the folder for the given path, non-recursively. This can be used to browse through the hierarchical tree of folders, e.g. traversing one level up can be done by removing the last part of the path.. [optional]
            creation_date_after (str): The date after which the data is created. Format: yyyy-MM-dd'T'HH:mm:ss'Z' eg: 2021-01-30T08:30:00Z. [optional]
            creation_date_before (str): The date before which the data is created. Format: yyyy-MM-dd'T'HH:mm:ss'Z' eg: 2021-01-30T08:30:00Z. [optional]
            status_date_after (str): The date after which the status has been updated. Format: yyyy-MM-dd'T'HH:mm:ss'Z' eg: 2021-01-30T08:30:00Z. [optional]
            status_date_before (str): The date before which the status has been updated Format: yyyy-MM-dd'T'HH:mm:ss'Z' eg: 2021-01-30T08:30:00Z. [optional]
            user_tag (str): The usertags to filter on. The userTagMatchMode-parameter determines how the filtering is done.. [optional]
            user_tag_match_mode (str): How the usertags are filtered.. [optional]
            run_input_tag (str): The runInputTags to filter on. The runInputTagMatchMode-parameter determines how the filtering is done.. [optional]
            run_input_tag_match_mode (str): How the runInputTags are filtered.. [optional]
            run_output_tag (str): The runOutputTags to filter on. The runOutputTagMatchMode-parameter determines how the filtering is done.. [optional]
            run_output_tag_match_mode (str): How the runOutputTags are filtered.. [optional]
            connector_tag (str): The connectorTags to filter on. The connectorTagMatchMode-parameter determines how the filtering is done.. [optional]
            connector_tag_match_mode (str): How the connectorTags are filtered.. [optional]
            technical_tag (str): The technicalTags to filter on. The techTagMatchMode-parameter determines how the filtering is done.. [optional]
            technical_tag_match_mode (str): How the technicalTags are filtered.. [optional]
            not_in_run (str): When set to true, the data will be filtered on data which is not used in a run.. [optional]
            not_linked_to_sample (str): When set to true only date that is unlinked to a sample will be returned.  This filter implies a filter of type File.. [optional]
            instrument_run_id ([str]): The instrument run IDs of the sequencing runs to filter on.. [optional]
            page_offset (str): The amount of rows to skip in the result. Ideally this is a multiple of the size parameter. Offset-based pagination has a result limit of 200K rows and does not guarantee unique results across pages. [optional]
            page_token (str): The cursor to get subsequent results. The value to use is returned in the result when using cursor-based pagination. Cursor-based pagination guarantees complete and unique results across all pages.. [optional]
            page_size (str): The amount of rows to return. Use in combination with the offset or cursor parameter to get subsequent results.. [optional]
            sort (str): Which field to order the results by. The default order is ascending, suffix with ' desc' to sort descending (suffix ' asc' also works for ascending). Multiple values should be separated with commas. An example: \"?sort=dateCreated, lastName desc\"  The attributes for which sorting is supported: - timeCreated - timeModified - name - path - fileSizeInBytes - status - format - dataType - willBeArchivedAt - willBeDeletedAt. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            BundleDataPagedList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['bundle_id'] = \
            bundle_id
        return self.get_bundle_data_endpoint.call_with_http_info(**kwargs)

    def link_data_to_bundle(
        self,
        bundle_id,
        data_id,
        **kwargs
    ):
        """Link data to this bundle.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.link_data_to_bundle(bundle_id, data_id, async_req=True)
        >>> result = thread.get()

        Args:
            bundle_id (str):
            data_id (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['bundle_id'] = \
            bundle_id
        kwargs['data_id'] = \
            data_id
        return self.link_data_to_bundle_endpoint.call_with_http_info(**kwargs)

    def unlink_data_from_bundle(
        self,
        bundle_id,
        data_id,
        **kwargs
    ):
        """Unlink data from this bundle.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.unlink_data_from_bundle(bundle_id, data_id, async_req=True)
        >>> result = thread.get()

        Args:
            bundle_id (str):
            data_id (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['bundle_id'] = \
            bundle_id
        kwargs['data_id'] = \
            data_id
        return self.unlink_data_from_bundle_endpoint.call_with_http_info(**kwargs)

