"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpLambdaAuthorizer = exports.HttpLambdaResponseType = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_apigatewayv2_alpha_1 = require("@aws-cdk/aws-apigatewayv2-alpha");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const aws_cdk_lib_1 = require("aws-cdk-lib");
/**
 * Specifies the type responses the lambda returns
 */
var HttpLambdaResponseType;
(function (HttpLambdaResponseType) {
    /** Returns simple boolean response */
    HttpLambdaResponseType[HttpLambdaResponseType["SIMPLE"] = 0] = "SIMPLE";
    /** Returns an IAM Policy */
    HttpLambdaResponseType[HttpLambdaResponseType["IAM"] = 1] = "IAM";
})(HttpLambdaResponseType = exports.HttpLambdaResponseType || (exports.HttpLambdaResponseType = {}));
/**
 * Authorize Http Api routes via a lambda function
 */
class HttpLambdaAuthorizer {
    /**
     * Initialize a lambda authorizer to be bound with HTTP route.
     * @param id The id of the underlying construct
     * @param pool The lambda function handler to use for authorization
     * @param props Properties to configure the authorizer
     */
    constructor(id, handler, props = {}) {
        this.id = id;
        this.handler = handler;
        this.props = props;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_authorizers_alpha_HttpLambdaAuthorizerProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, HttpLambdaAuthorizer);
            }
            throw error;
        }
    }
    bind(options) {
        if (this.httpApi && (this.httpApi.apiId !== options.route.httpApi.apiId)) {
            throw new Error('Cannot attach the same authorizer to multiple Apis');
        }
        if (!this.authorizer) {
            const responseTypes = this.props.responseTypes ?? [HttpLambdaResponseType.IAM];
            const enableSimpleResponses = responseTypes.includes(HttpLambdaResponseType.SIMPLE) || undefined;
            this.httpApi = options.route.httpApi;
            this.authorizer = new aws_apigatewayv2_alpha_1.HttpAuthorizer(options.scope, this.id, {
                httpApi: options.route.httpApi,
                identitySource: this.props.identitySource ?? [
                    '$request.header.Authorization',
                ],
                type: aws_apigatewayv2_alpha_1.HttpAuthorizerType.LAMBDA,
                authorizerName: this.props.authorizerName ?? this.id,
                enableSimpleResponses,
                payloadFormatVersion: enableSimpleResponses ? aws_apigatewayv2_alpha_1.AuthorizerPayloadVersion.VERSION_2_0 : aws_apigatewayv2_alpha_1.AuthorizerPayloadVersion.VERSION_1_0,
                authorizerUri: lambdaAuthorizerArn(this.handler),
                resultsCacheTtl: this.props.resultsCacheTtl ?? aws_cdk_lib_1.Duration.minutes(5),
            });
            this.handler.addPermission(`${aws_cdk_lib_1.Names.nodeUniqueId(this.authorizer.node)}-Permission`, {
                scope: options.scope,
                principal: new aws_iam_1.ServicePrincipal('apigateway.amazonaws.com'),
                sourceArn: aws_cdk_lib_1.Stack.of(options.route).formatArn({
                    service: 'execute-api',
                    resource: options.route.httpApi.apiId,
                    resourceName: `authorizers/${this.authorizer.authorizerId}`,
                }),
            });
        }
        return {
            authorizerId: this.authorizer.authorizerId,
            authorizationType: 'CUSTOM',
        };
    }
}
exports.HttpLambdaAuthorizer = HttpLambdaAuthorizer;
_a = JSII_RTTI_SYMBOL_1;
HttpLambdaAuthorizer[_a] = { fqn: "@aws-cdk/aws-apigatewayv2-authorizers-alpha.HttpLambdaAuthorizer", version: "2.57.0-alpha.0" };
/**
 * constructs the authorizerURIArn.
 */
function lambdaAuthorizerArn(handler) {
    return `arn:${aws_cdk_lib_1.Stack.of(handler).partition}:apigateway:${aws_cdk_lib_1.Stack.of(handler).region}:lambda:path/2015-03-31/functions/${handler.functionArn}/invocations`;
}
//# sourceMappingURL=data:application/json;base64,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