# coding: utf-8

"""
    Robot API

    Robot REST API  # noqa: E501

    OpenAPI spec version: 2.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from pdhttp.api_client import ApiClient


class RobotApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def add_to_environment(self, body, **kwargs):  # noqa: E501
        """Add obstacle to robot environment.  # noqa: E501

        Add obstacle to robot environment. Obstacle it is an object that is taken into account in the calculation of collisions. Must be one of the following types: BOX, CAPSULE, PLANE. Example shows possible obstacle definitions. **Note:** Only one obstacle at a time should be passed as request body even though example shows array of items  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_to_environment(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Obstacle body: Request Body (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_to_environment_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.add_to_environment_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def add_to_environment_with_http_info(self, body, **kwargs):  # noqa: E501
        """Add obstacle to robot environment.  # noqa: E501

        Add obstacle to robot environment. Obstacle it is an object that is taken into account in the calculation of collisions. Must be one of the following types: BOX, CAPSULE, PLANE. Example shows possible obstacle definitions. **Note:** Only one obstacle at a time should be passed as request body even though example shows array of items  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_to_environment_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Obstacle body: Request Body (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_to_environment" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `add_to_environment`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/environment', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def change_base(self, body, **kwargs):  # noqa: E501
        """Setting a new zero point position  # noqa: E501

        The function enables setting a new zero point position of the robotic arm as required for the current user environment (e.g., considering the surrounding equipment). The new zero point position is described as a set of x, y, and z coordinates, as well as _roll_, _pitch_, and _yaw_ rotation angles. The coordinates define the desired offset (in meters) from the physical centerpoint of the arm base (original zero point) along the x, y, and z axes accordingly. _Roll_ stands for the rotation angle around the x axis; _pitch_ - the rotation angle around the y axis; _yaw_ - the rotation angle around the z axis. All rotation angles are in radians and relative to the physical centerpoint of the arm base.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.change_base(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Position body: Request Body (required)
        :return: Position
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.change_base_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.change_base_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def change_base_with_http_info(self, body, **kwargs):  # noqa: E501
        """Setting a new zero point position  # noqa: E501

        The function enables setting a new zero point position of the robotic arm as required for the current user environment (e.g., considering the surrounding equipment). The new zero point position is described as a set of x, y, and z coordinates, as well as _roll_, _pitch_, and _yaw_ rotation angles. The coordinates define the desired offset (in meters) from the physical centerpoint of the arm base (original zero point) along the x, y, and z axes accordingly. _Roll_ stands for the rotation angle around the x axis; _pitch_ - the rotation angle around the y axis; _yaw_ - the rotation angle around the z axis. All rotation angles are in radians and relative to the physical centerpoint of the arm base.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.change_base_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Position body: Request Body (required)
        :return: Position
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method change_base" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `change_base`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/base', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Position',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def change_tool_info(self, body, **kwargs):  # noqa: E501
        """Setting tool properties  # noqa: E501

        The function enables setting new TCP to account for the properties of an attached or changed work tool. The tool properties define the following:  - _name_ - any random name of the work tool defined by the user (e.g., \\\"gripper\\\")  - _position_ - a set of x, y, and z coordinates and rotation angles - _roll_, _pitch_, and _yaw_. The coordinates define the actual distance (in meters) from the arm's zero point to the new TCP along the x, y, and z axes accordingly. _Roll_ stands for the rotation angle of the new TCP around the x axis; _pitch_ - the rotation angle around the y axis; _yaw_ - the rotation angle of the new TCP around the z axis. All rotation angles are in radians.  - _radius_ - radius of the work tool (in meters) measured from its physical center point.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.change_tool_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ToolInfo body: Request Body (required)
        :return: ToolInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.change_tool_info_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.change_tool_info_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def change_tool_info_with_http_info(self, body, **kwargs):  # noqa: E501
        """Setting tool properties  # noqa: E501

        The function enables setting new TCP to account for the properties of an attached or changed work tool. The tool properties define the following:  - _name_ - any random name of the work tool defined by the user (e.g., \\\"gripper\\\")  - _position_ - a set of x, y, and z coordinates and rotation angles - _roll_, _pitch_, and _yaw_. The coordinates define the actual distance (in meters) from the arm's zero point to the new TCP along the x, y, and z axes accordingly. _Roll_ stands for the rotation angle of the new TCP around the x axis; _pitch_ - the rotation angle around the y axis; _yaw_ - the rotation angle of the new TCP around the z axis. All rotation angles are in radians.  - _radius_ - radius of the work tool (in meters) measured from its physical center point.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.change_tool_info_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ToolInfo body: Request Body (required)
        :return: ToolInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method change_tool_info" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `change_tool_info`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/tool/info', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ToolInfo',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def change_tool_shape(self, body, **kwargs):  # noqa: E501
        """Setting tool shape  # noqa: E501

        The function sets new form of the working tool of the robot, which participates in the calculation of collisions.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.change_tool_shape(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ToolShape body: Request Body (required)
        :return: ToolShape
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.change_tool_shape_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.change_tool_shape_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def change_tool_shape_with_http_info(self, body, **kwargs):  # noqa: E501
        """Setting tool shape  # noqa: E501

        The function sets new form of the working tool of the robot, which participates in the calculation of collisions.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.change_tool_shape_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ToolShape body: Request Body (required)
        :return: ToolShape
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method change_tool_shape" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `change_tool_shape`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/tool/shape', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ToolShape',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def close_gripper(self, **kwargs):  # noqa: E501
        """Asking the arm to close the gripper  # noqa: E501

        The function commands the robot to close the gripper. It has no request body, but the user can optionally set how long (in milliseconds) the arm should remain idle, waiting for the gripper to close. The default manufacturer-preset value is 500 ms.  ### Note:  Setting the parameter, it is recommended to use values above 0 ms.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.close_gripper(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param float timeout: Time in milliseconds to wait for gripper closing
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.close_gripper_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.close_gripper_with_http_info(**kwargs)  # noqa: E501
            return data

    def close_gripper_with_http_info(self, **kwargs):  # noqa: E501
        """Asking the arm to close the gripper  # noqa: E501

        The function commands the robot to close the gripper. It has no request body, but the user can optionally set how long (in milliseconds) the arm should remain idle, waiting for the gripper to close. The default manufacturer-preset value is 500 ms.  ### Note:  Setting the parameter, it is recommended to use values above 0 ms.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.close_gripper_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param float timeout: Time in milliseconds to wait for gripper closing
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['timeout']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method close_gripper" % key
                )
            params[key] = val
        del params['kwargs']

        if 'timeout' in params and params['timeout'] <= 0:  # noqa: E501
            raise ValueError("Invalid value for parameter `timeout` when calling `close_gripper`, must be a value greater than `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'timeout' in params:
            query_params.append(('timeout', params['timeout']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/gripper/close', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def freeze(self, **kwargs):  # noqa: E501
        """Asking the arm to go to the freeze state  # noqa: E501

        The function sets the arm in the \\\"freeze\\\" state. The arm stops moving, retaining its last position.  ### Note:  In the state, it is not advisable to move the arm by hand as this can cause damage to its components.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.freeze(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.freeze_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.freeze_with_http_info(**kwargs)  # noqa: E501
            return data

    def freeze_with_http_info(self, **kwargs):  # noqa: E501
        """Asking the arm to go to the freeze state  # noqa: E501

        The function sets the arm in the \\\"freeze\\\" state. The arm stops moving, retaining its last position.  ### Note:  In the state, it is not advisable to move the arm by hand as this can cause damage to its components.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.freeze_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method freeze" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/freeze', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_all_from_environment(self, **kwargs):  # noqa: E501
        """Getting robot environment.  # noqa: E501

        Return all obstacles from environment. Obstacle it is an object that is taken into account in the calculation of collisions.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_from_environment(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: list[Obstacle]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_all_from_environment_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_all_from_environment_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_all_from_environment_with_http_info(self, **kwargs):  # noqa: E501
        """Getting robot environment.  # noqa: E501

        Return all obstacles from environment. Obstacle it is an object that is taken into account in the calculation of collisions.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_from_environment_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: list[Obstacle]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all_from_environment" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/environment', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Obstacle]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_base(self, **kwargs):  # noqa: E501
        """Getting the actual position of the arm base  # noqa: E501

        The function returns the actual position of the arm's zero point in the user environment. The actual zero point position is described as a set of x, y, and z coordinates, as well as _roll_, _pitch_, and _yaw_ rotation angles. The coordinates define the offset (in meters) from the physical centerpoint of the arm base (original zero point) to the actual zero point position along the x, y, and z axes accordingly. _Roll_ stands for the rotation angle around the x axis; _pitch_ - the rotation angle around the y axis; _yaw_ - the rotation angle around the z axis. All rotation angles are in radians and relative to the physical centerpoint of the arm base.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_base(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: Position
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_base_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_base_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_base_with_http_info(self, **kwargs):  # noqa: E501
        """Getting the actual position of the arm base  # noqa: E501

        The function returns the actual position of the arm's zero point in the user environment. The actual zero point position is described as a set of x, y, and z coordinates, as well as _roll_, _pitch_, and _yaw_ rotation angles. The coordinates define the offset (in meters) from the physical centerpoint of the arm base (original zero point) to the actual zero point position along the x, y, and z axes accordingly. _Roll_ stands for the rotation angle around the x axis; _pitch_ - the rotation angle around the y axis; _yaw_ - the rotation angle around the z axis. All rotation angles are in radians and relative to the physical centerpoint of the arm base.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_base_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: Position
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_base" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/base', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Position',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_digital_input(self, port, **kwargs):  # noqa: E501
        """Get level of digital input signal  # noqa: E501

        The function returns the actual signal level on the digital input specified in the {port} parameter of the request path.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_digital_input(port, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int port: The parameter indicates the number of a digital input is a physical port on the back panel of the control box. Since the control box has four digital inputs (DI), the parameter can have any integral value between 1 (corresponds to DI1) and 4 (corresponds to DI4). (required)
        :return: Signal
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_digital_input_with_http_info(port, **kwargs)  # noqa: E501
        else:
            (data) = self.get_digital_input_with_http_info(port, **kwargs)  # noqa: E501
            return data

    def get_digital_input_with_http_info(self, port, **kwargs):  # noqa: E501
        """Get level of digital input signal  # noqa: E501

        The function returns the actual signal level on the digital input specified in the {port} parameter of the request path.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_digital_input_with_http_info(port, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int port: The parameter indicates the number of a digital input is a physical port on the back panel of the control box. Since the control box has four digital inputs (DI), the parameter can have any integral value between 1 (corresponds to DI1) and 4 (corresponds to DI4). (required)
        :return: Signal
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['port']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_digital_input" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'port' is set
        if ('port' not in params or
                params['port'] is None):
            raise ValueError("Missing the required parameter `port` when calling `get_digital_input`")  # noqa: E501

        if 'port' in params and params['port'] > 4:  # noqa: E501
            raise ValueError("Invalid value for parameter `port` when calling `get_digital_input`, must be a value less than or equal to `4`")  # noqa: E501
        if 'port' in params and params['port'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `port` when calling `get_digital_input`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'port' in params:
            path_params['port'] = params['port']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/signal/input/{port}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Signal',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_digital_output(self, port, **kwargs):  # noqa: E501
        """Get level of digital output signal  # noqa: E501

        The function returns the actual signal level on the digital output specified in the {port} parameter of the request path.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_digital_output(port, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int port: The parameter indicates the number of a digital output is a physical port on the back panel of the control box. Since the control box has two digital outputs, the parameter value can be either 1 (corresponds to Relay output 1) or 2 (corresponds to Relay output 2). (required)
        :return: Signal
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_digital_output_with_http_info(port, **kwargs)  # noqa: E501
        else:
            (data) = self.get_digital_output_with_http_info(port, **kwargs)  # noqa: E501
            return data

    def get_digital_output_with_http_info(self, port, **kwargs):  # noqa: E501
        """Get level of digital output signal  # noqa: E501

        The function returns the actual signal level on the digital output specified in the {port} parameter of the request path.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_digital_output_with_http_info(port, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int port: The parameter indicates the number of a digital output is a physical port on the back panel of the control box. Since the control box has two digital outputs, the parameter value can be either 1 (corresponds to Relay output 1) or 2 (corresponds to Relay output 2). (required)
        :return: Signal
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['port']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_digital_output" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'port' is set
        if ('port' not in params or
                params['port'] is None):
            raise ValueError("Missing the required parameter `port` when calling `get_digital_output`")  # noqa: E501

        if 'port' in params and params['port'] > 2:  # noqa: E501
            raise ValueError("Invalid value for parameter `port` when calling `get_digital_output`, must be a value less than or equal to `2`")  # noqa: E501
        if 'port' in params and params['port'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `port` when calling `get_digital_output`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'port' in params:
            path_params['port'] = params['port']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/signal/output/{port}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Signal',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_from_environment_by_name(self, obstacle, **kwargs):  # noqa: E501
        """Getting obstacle from robot environment by name.  # noqa: E501

        Return obstacle from environment by name. Obstacle it is an object that is taken into account in the calculation of collisions. Response example shows possible obstacle definitions. **Note:** Only one obstacle at a time is returned in response body even though example shows array of items  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_from_environment_by_name(obstacle, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str obstacle: The parameter is the name of element from environment that you want to get. (required)
        :return: Obstacle
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_from_environment_by_name_with_http_info(obstacle, **kwargs)  # noqa: E501
        else:
            (data) = self.get_from_environment_by_name_with_http_info(obstacle, **kwargs)  # noqa: E501
            return data

    def get_from_environment_by_name_with_http_info(self, obstacle, **kwargs):  # noqa: E501
        """Getting obstacle from robot environment by name.  # noqa: E501

        Return obstacle from environment by name. Obstacle it is an object that is taken into account in the calculation of collisions. Response example shows possible obstacle definitions. **Note:** Only one obstacle at a time is returned in response body even though example shows array of items  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_from_environment_by_name_with_http_info(obstacle, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str obstacle: The parameter is the name of element from environment that you want to get. (required)
        :return: Obstacle
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['obstacle']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_from_environment_by_name" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'obstacle' is set
        if ('obstacle' not in params or
                params['obstacle'] is None):
            raise ValueError("Missing the required parameter `obstacle` when calling `get_from_environment_by_name`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'obstacle' in params:
            path_params['obstacle'] = params['obstacle']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/environment/{obstacle}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Obstacle',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_pose(self, **kwargs):  # noqa: E501
        """Getting the actual arm pose  # noqa: E501

        The function returns the actual pose of the robotic arm. The pose is described as a set of output flange angles (in degrees) of all the six servos in the arm joints.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_pose(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: Pose
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_pose_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_pose_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_pose_with_http_info(self, **kwargs):  # noqa: E501
        """Getting the actual arm pose  # noqa: E501

        The function returns the actual pose of the robotic arm. The pose is described as a set of output flange angles (in degrees) of all the six servos in the arm joints.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_pose_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: Pose
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_pose" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/pose', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Pose',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_position(self, **kwargs):  # noqa: E501
        """Getting the actual arm position  # noqa: E501

        The function returns the actual position of the PULSE robotic arm, which is described as a set of x, y, and z coordinates, as well as _roll_, _pitch_, and _yaw_ rotation angles. The coordinates define the actual distance (in meters) from the zero point of the robotic arm to the tool center point (TCP) along the x, y, and z axes accordingly. _Roll_ stands for the TCP rotation angle around the x axis; _pitch_ - the TCP rotation angle around the y axis; _yaw_ - the TCP rotation angle around the z axis. All rotation angles are in radians and relative to the zero point.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_position(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: Position
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_position_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_position_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_position_with_http_info(self, **kwargs):  # noqa: E501
        """Getting the actual arm position  # noqa: E501

        The function returns the actual position of the PULSE robotic arm, which is described as a set of x, y, and z coordinates, as well as _roll_, _pitch_, and _yaw_ rotation angles. The coordinates define the actual distance (in meters) from the zero point of the robotic arm to the tool center point (TCP) along the x, y, and z axes accordingly. _Roll_ stands for the TCP rotation angle around the x axis; _pitch_ - the TCP rotation angle around the y axis; _yaw_ - the TCP rotation angle around the z axis. All rotation angles are in radians and relative to the zero point.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_position_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: Position
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_position" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/position', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Position',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_tool_info(self, **kwargs):  # noqa: E501
        """Getting actual tool properties  # noqa: E501

        The function returns the actual TCP position that accounts for the offset from the original TCP due to attaching/changing the work tool. The actual TCP position is described as a set of the following properties:  - _name_ - any random name of the work tool defined by the user (e.g., \\\"gripper\\\")  - _position_ - x, y, and z coordinates, as well as _roll_, _pitch_, and _yaw_ rotation angles.   The coordinates define the distance (in meters) from the arm's zero point   to the actual TCP along the x, y, and z axes accordingly.   _Roll_ stands for the actual TCP rotation angle around the x axis;   _pitch_ - the actual TCP rotation angle around the y axis;   _yaw_ - the actual TCP rotation angle around the z axis. All rotation angles are in radians.    - _radius_ - radius of the work tool (in meters) measured from its center point.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tool_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: ToolInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_tool_info_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_tool_info_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_tool_info_with_http_info(self, **kwargs):  # noqa: E501
        """Getting actual tool properties  # noqa: E501

        The function returns the actual TCP position that accounts for the offset from the original TCP due to attaching/changing the work tool. The actual TCP position is described as a set of the following properties:  - _name_ - any random name of the work tool defined by the user (e.g., \\\"gripper\\\")  - _position_ - x, y, and z coordinates, as well as _roll_, _pitch_, and _yaw_ rotation angles.   The coordinates define the distance (in meters) from the arm's zero point   to the actual TCP along the x, y, and z axes accordingly.   _Roll_ stands for the actual TCP rotation angle around the x axis;   _pitch_ - the actual TCP rotation angle around the y axis;   _yaw_ - the actual TCP rotation angle around the z axis. All rotation angles are in radians.    - _radius_ - radius of the work tool (in meters) measured from its center point.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tool_info_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: ToolInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_tool_info" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/tool/info', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ToolInfo',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_tool_shape(self, **kwargs):  # noqa: E501
        """Getting tool shape  # noqa: E501

        The function returns the form of the working tool of the robot,  which participates in the calculation of collisions.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tool_shape(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: ToolShape
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_tool_shape_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_tool_shape_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_tool_shape_with_http_info(self, **kwargs):  # noqa: E501
        """Getting tool shape  # noqa: E501

        The function returns the form of the working tool of the robot,  which participates in the calculation of collisions.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tool_shape_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: ToolShape
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_tool_shape" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/tool/shape', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ToolShape',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def identifier(self, **kwargs):  # noqa: E501
        """Getting the arm ID  # noqa: E501

        The function returns the unique identifier (ID) of the robotic arm. The ID is an alphanumeric designation that consists of individual servo motor identifications.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.identifier(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.identifier_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.identifier_with_http_info(**kwargs)  # noqa: E501
            return data

    def identifier_with_http_info(self, **kwargs):  # noqa: E501
        """Getting the arm ID  # noqa: E501

        The function returns the unique identifier (ID) of the robotic arm. The ID is an alphanumeric designation that consists of individual servo motor identifications.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.identifier_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method identifier" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/robot/id', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def information(self, **kwargs):  # noqa: E501
        """Getting the information about robot  # noqa: E501

        The function returns the unique serial number of the robotic arm, model and model version. If some of the properties are unknown then should be returned \"Unknown\"  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.information(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: RobotInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.information_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.information_with_http_info(**kwargs)  # noqa: E501
            return data

    def information_with_http_info(self, **kwargs):  # noqa: E501
        """Getting the information about robot  # noqa: E501

        The function returns the unique serial number of the robotic arm, model and model version. If some of the properties are unknown then should be returned \"Unknown\"  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.information_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: RobotInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method information" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/robot/info', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RobotInfo',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def jogging(self, body, **kwargs):  # noqa: E501
        """Controls the robotic arm in 'jogging' mode.  # noqa: E501

        The function commands the arm to enter the 'jogging' mode. If the robotic arm already in the 'jogging' mode, use this function to control the direction of the movement. To disable the mode, user should pass acceleration object, where all components are zeros. To learn about acceleration components, see JoggingAcceleration documentation.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.jogging(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param JoggingAcceleration body: Request Body (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.jogging_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.jogging_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def jogging_with_http_info(self, body, **kwargs):  # noqa: E501
        """Controls the robotic arm in 'jogging' mode.  # noqa: E501

        The function commands the arm to enter the 'jogging' mode. If the robotic arm already in the 'jogging' mode, use this function to control the direction of the movement. To disable the mode, user should pass acceleration object, where all components are zeros. To learn about acceleration components, see JoggingAcceleration documentation.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.jogging_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param JoggingAcceleration body: Request Body (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method jogging" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `jogging`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/jogging', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def open_gripper(self, **kwargs):  # noqa: E501
        """Asking the arm to open the gripper  # noqa: E501

        The function commands the robot to open the gripper. It has no request body, but the user can optionally set how long (in milliseconds) the arm should remain idle, waiting for the gripper to open. The default manufacturer-preset value is 500 ms.  ### Note:  Setting the parameter, it is recommended to use values above 0 ms.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.open_gripper(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param float timeout: Time in milliseconds to wait for gripper opening
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.open_gripper_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.open_gripper_with_http_info(**kwargs)  # noqa: E501
            return data

    def open_gripper_with_http_info(self, **kwargs):  # noqa: E501
        """Asking the arm to open the gripper  # noqa: E501

        The function commands the robot to open the gripper. It has no request body, but the user can optionally set how long (in milliseconds) the arm should remain idle, waiting for the gripper to open. The default manufacturer-preset value is 500 ms.  ### Note:  Setting the parameter, it is recommended to use values above 0 ms.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.open_gripper_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param float timeout: Time in milliseconds to wait for gripper opening
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['timeout']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method open_gripper" % key
                )
            params[key] = val
        del params['kwargs']

        if 'timeout' in params and params['timeout'] <= 0:  # noqa: E501
            raise ValueError("Invalid value for parameter `timeout` when calling `open_gripper`, must be a value greater than `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'timeout' in params:
            query_params.append(('timeout', params['timeout']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/gripper/open', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def pack(self, **kwargs):  # noqa: E501
        """Asking the arm to reach a compact pose for transportation  # noqa: E501

        The function sets the arm into a preset pose for transportation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pack(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.pack_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.pack_with_http_info(**kwargs)  # noqa: E501
            return data

    def pack_with_http_info(self, **kwargs):  # noqa: E501
        """Asking the arm to reach a compact pose for transportation  # noqa: E501

        The function sets the arm into a preset pose for transportation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pack_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method pack" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/pack', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def recover(self, **kwargs):  # noqa: E501
        """Recover robot after emergency if it is possible.  # noqa: E501

        The function recovers the arm after an emergency, setting its motion status to IDLE. Recovery is possible only after an emergency that is not fatal—corresponding to the ERROR status.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.recover(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: RecoverState
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.recover_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.recover_with_http_info(**kwargs)  # noqa: E501
            return data

    def recover_with_http_info(self, **kwargs):  # noqa: E501
        """Recover robot after emergency if it is possible.  # noqa: E501

        The function recovers the arm after an emergency, setting its motion status to IDLE. Recovery is possible only after an emergency that is not fatal—corresponding to the ERROR status.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.recover_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: RecoverState
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method recover" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/recover', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RecoverState',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def relax(self, **kwargs):  # noqa: E501
        """Asking the arm to relax  # noqa: E501

        The function sets the arm in the \"relaxed\" state. The arm stops moving without retaining its last position. In this state, the user can move the robotic arm by hand (e.g., to verify/test a motion trajectory).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.relax(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.relax_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.relax_with_http_info(**kwargs)  # noqa: E501
            return data

    def relax_with_http_info(self, **kwargs):  # noqa: E501
        """Asking the arm to relax  # noqa: E501

        The function sets the arm in the \"relaxed\" state. The arm stops moving without retaining its last position. In this state, the user can move the robotic arm by hand (e.g., to verify/test a motion trajectory).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.relax_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method relax" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/relax', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def remove_all_from_environment(self, **kwargs):  # noqa: E501
        """Remove all obstacles from robot environment.  # noqa: E501

        Remove all obstacles from robot environment. Obstacle it is an object that is taken into account in the calculation of collisions.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_all_from_environment(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.remove_all_from_environment_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.remove_all_from_environment_with_http_info(**kwargs)  # noqa: E501
            return data

    def remove_all_from_environment_with_http_info(self, **kwargs):  # noqa: E501
        """Remove all obstacles from robot environment.  # noqa: E501

        Remove all obstacles from robot environment. Obstacle it is an object that is taken into account in the calculation of collisions.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_all_from_environment_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_all_from_environment" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/environment', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def remove_from_environment_by_name(self, obstacle, **kwargs):  # noqa: E501
        """Remove obstacle from robot environment by name.  # noqa: E501

        Remove obstacle from robot environment by name. Obstacle it is an object that is taken into account in the calculation of collisions.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_from_environment_by_name(obstacle, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str obstacle: The parameter is the name of element from environment that you want to remove. (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.remove_from_environment_by_name_with_http_info(obstacle, **kwargs)  # noqa: E501
        else:
            (data) = self.remove_from_environment_by_name_with_http_info(obstacle, **kwargs)  # noqa: E501
            return data

    def remove_from_environment_by_name_with_http_info(self, obstacle, **kwargs):  # noqa: E501
        """Remove obstacle from robot environment by name.  # noqa: E501

        Remove obstacle from robot environment by name. Obstacle it is an object that is taken into account in the calculation of collisions.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_from_environment_by_name_with_http_info(obstacle, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str obstacle: The parameter is the name of element from environment that you want to remove. (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['obstacle']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_from_environment_by_name" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'obstacle' is set
        if ('obstacle' not in params or
                params['obstacle'] is None):
            raise ValueError("Missing the required parameter `obstacle` when calling `remove_from_environment_by_name`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'obstacle' in params:
            path_params['obstacle'] = params['obstacle']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/environment/{obstacle}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def run_poses(self, body, **kwargs):  # noqa: E501
        """Asking the arm to move to a pose  # noqa: E501

        The function allows for setting a trajectory of one or more waypoints to move the robotic arm smoothly from one pose to another. In the trajectory, each waypoint is a set of output flange angles (in degrees) of the six servos in the arm joints.  Two motion types supported: linear and joint. Default: joint  ### Note:  Similarly, you can move the arm from one pose to another through one or more waypoints using the PUT/pose function. When the arm is executing a trajectory of PUT/pose waypoints, it stops for a short moment at each preset waypoint. With the PUT/poses/run function, however, the arm moves smoothly though all waypoints without stopping, which reduces the overall time of going from one pose to another.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.run_poses(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[Pose] body: Request Body (required)
        :param int speed: Speed of Robot. Controls acceleration and velocity at the same time.
        :param int velocity: Velocity of Robot. MUST be used together with acceleration.
        :param int acceleration: Acceleration of Robot. MUST be used together with velocity. **Note:** Use values greater than 100 with caution: the robotic arm could reject or fail operation execution. Values greater than 100 are acceptable when the robotic arm moves with a relatively light load or without one.
        :param str motion_type: Motion type of robot. MUST be either JOINT (default) or LINEAR
        :param float tcp_max_velocity: The parameter defines the limit velocity in meters per second that an end effector can reach at its TCP while moving. It is not mandatory. When the user specifies no value for it, it is set to default. The default setting is 2 m/s.
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.run_poses_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.run_poses_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def run_poses_with_http_info(self, body, **kwargs):  # noqa: E501
        """Asking the arm to move to a pose  # noqa: E501

        The function allows for setting a trajectory of one or more waypoints to move the robotic arm smoothly from one pose to another. In the trajectory, each waypoint is a set of output flange angles (in degrees) of the six servos in the arm joints.  Two motion types supported: linear and joint. Default: joint  ### Note:  Similarly, you can move the arm from one pose to another through one or more waypoints using the PUT/pose function. When the arm is executing a trajectory of PUT/pose waypoints, it stops for a short moment at each preset waypoint. With the PUT/poses/run function, however, the arm moves smoothly though all waypoints without stopping, which reduces the overall time of going from one pose to another.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.run_poses_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[Pose] body: Request Body (required)
        :param int speed: Speed of Robot. Controls acceleration and velocity at the same time.
        :param int velocity: Velocity of Robot. MUST be used together with acceleration.
        :param int acceleration: Acceleration of Robot. MUST be used together with velocity. **Note:** Use values greater than 100 with caution: the robotic arm could reject or fail operation execution. Values greater than 100 are acceptable when the robotic arm moves with a relatively light load or without one.
        :param str motion_type: Motion type of robot. MUST be either JOINT (default) or LINEAR
        :param float tcp_max_velocity: The parameter defines the limit velocity in meters per second that an end effector can reach at its TCP while moving. It is not mandatory. When the user specifies no value for it, it is set to default. The default setting is 2 m/s.
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'speed', 'velocity', 'acceleration', 'motion_type', 'tcp_max_velocity']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method run_poses" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `run_poses`")  # noqa: E501

        if 'speed' in params and params['speed'] > 100:  # noqa: E501
            raise ValueError("Invalid value for parameter `speed` when calling `run_poses`, must be a value less than or equal to `100`")  # noqa: E501
        if 'speed' in params and params['speed'] <= 0:  # noqa: E501
            raise ValueError("Invalid value for parameter `speed` when calling `run_poses`, must be a value greater than `0`")  # noqa: E501
        if 'velocity' in params and params['velocity'] > 100:  # noqa: E501
            raise ValueError("Invalid value for parameter `velocity` when calling `run_poses`, must be a value less than or equal to `100`")  # noqa: E501
        if 'velocity' in params and params['velocity'] <= 0:  # noqa: E501
            raise ValueError("Invalid value for parameter `velocity` when calling `run_poses`, must be a value greater than `0`")  # noqa: E501
        if 'acceleration' in params and params['acceleration'] > 200:  # noqa: E501
            raise ValueError("Invalid value for parameter `acceleration` when calling `run_poses`, must be a value less than or equal to `200`")  # noqa: E501
        if 'acceleration' in params and params['acceleration'] <= 0:  # noqa: E501
            raise ValueError("Invalid value for parameter `acceleration` when calling `run_poses`, must be a value greater than `0`")  # noqa: E501
        if 'tcp_max_velocity' in params and params['tcp_max_velocity'] > 2:  # noqa: E501
            raise ValueError("Invalid value for parameter `tcp_max_velocity` when calling `run_poses`, must be a value less than or equal to `2`")  # noqa: E501
        if 'tcp_max_velocity' in params and params['tcp_max_velocity'] <= 0:  # noqa: E501
            raise ValueError("Invalid value for parameter `tcp_max_velocity` when calling `run_poses`, must be a value greater than `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'speed' in params:
            query_params.append(('speed', params['speed']))  # noqa: E501
        if 'velocity' in params:
            query_params.append(('velocity', params['velocity']))  # noqa: E501
        if 'acceleration' in params:
            query_params.append(('acceleration', params['acceleration']))  # noqa: E501
        if 'motion_type' in params:
            query_params.append(('motionType', params['motion_type']))  # noqa: E501
        if 'tcp_max_velocity' in params:
            query_params.append(('tcp_max_velocity', params['tcp_max_velocity']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/poses/run', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def run_positions(self, body, **kwargs):  # noqa: E501
        """Asking the arm to move to a position  # noqa: E501

        The function allows for setting a trajectory of one or more waypoints to move the robotic arm smoothly from one position to another.  Two motion types supported: linear and joint. Default: joint  In the trajectory, each waypoint is described as a set of x, y, and z coordinates, as well as _roll_, _pitch_, and _yaw_ rotation angles. The coordinates define the distance (in meters) from the zero point to the desired TCP along the x, y, and z axes accordingly. _Roll_ stands for the desired TCP rotation angle around the x axis; _pitch_ - the desired TCP rotation angle around the y axis; _yaw_ - the desired TCP rotation angle around the z axis. All rotation angles are in radians.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.run_positions(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[Position] body: Request Body (required)
        :param int speed: Speed of Robot. Controls acceleration and velocity at the same time.
        :param int velocity: Velocity of Robot. MUST be used together with acceleration.
        :param int acceleration: Acceleration of Robot. MUST be used together with velocity. **Note:** Use values greater than 100 with caution: the robotic arm could reject or fail operation execution. Values greater than 100 are acceptable when the robotic arm moves with a relatively light load or without one.
        :param str motion_type: Motion type of robot. MUST be either JOINT (default) or LINEAR
        :param float tcp_max_velocity: The parameter defines the limit velocity in meters per second that an end effector can reach at its TCP while moving. It is not mandatory. When the user specifies no value for it, it is set to default. The default setting is 2 m/s.
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.run_positions_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.run_positions_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def run_positions_with_http_info(self, body, **kwargs):  # noqa: E501
        """Asking the arm to move to a position  # noqa: E501

        The function allows for setting a trajectory of one or more waypoints to move the robotic arm smoothly from one position to another.  Two motion types supported: linear and joint. Default: joint  In the trajectory, each waypoint is described as a set of x, y, and z coordinates, as well as _roll_, _pitch_, and _yaw_ rotation angles. The coordinates define the distance (in meters) from the zero point to the desired TCP along the x, y, and z axes accordingly. _Roll_ stands for the desired TCP rotation angle around the x axis; _pitch_ - the desired TCP rotation angle around the y axis; _yaw_ - the desired TCP rotation angle around the z axis. All rotation angles are in radians.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.run_positions_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[Position] body: Request Body (required)
        :param int speed: Speed of Robot. Controls acceleration and velocity at the same time.
        :param int velocity: Velocity of Robot. MUST be used together with acceleration.
        :param int acceleration: Acceleration of Robot. MUST be used together with velocity. **Note:** Use values greater than 100 with caution: the robotic arm could reject or fail operation execution. Values greater than 100 are acceptable when the robotic arm moves with a relatively light load or without one.
        :param str motion_type: Motion type of robot. MUST be either JOINT (default) or LINEAR
        :param float tcp_max_velocity: The parameter defines the limit velocity in meters per second that an end effector can reach at its TCP while moving. It is not mandatory. When the user specifies no value for it, it is set to default. The default setting is 2 m/s.
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'speed', 'velocity', 'acceleration', 'motion_type', 'tcp_max_velocity']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method run_positions" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `run_positions`")  # noqa: E501

        if 'speed' in params and params['speed'] > 100:  # noqa: E501
            raise ValueError("Invalid value for parameter `speed` when calling `run_positions`, must be a value less than or equal to `100`")  # noqa: E501
        if 'speed' in params and params['speed'] <= 0:  # noqa: E501
            raise ValueError("Invalid value for parameter `speed` when calling `run_positions`, must be a value greater than `0`")  # noqa: E501
        if 'velocity' in params and params['velocity'] > 100:  # noqa: E501
            raise ValueError("Invalid value for parameter `velocity` when calling `run_positions`, must be a value less than or equal to `100`")  # noqa: E501
        if 'velocity' in params and params['velocity'] <= 0:  # noqa: E501
            raise ValueError("Invalid value for parameter `velocity` when calling `run_positions`, must be a value greater than `0`")  # noqa: E501
        if 'acceleration' in params and params['acceleration'] > 200:  # noqa: E501
            raise ValueError("Invalid value for parameter `acceleration` when calling `run_positions`, must be a value less than or equal to `200`")  # noqa: E501
        if 'acceleration' in params and params['acceleration'] <= 0:  # noqa: E501
            raise ValueError("Invalid value for parameter `acceleration` when calling `run_positions`, must be a value greater than `0`")  # noqa: E501
        if 'tcp_max_velocity' in params and params['tcp_max_velocity'] > 2:  # noqa: E501
            raise ValueError("Invalid value for parameter `tcp_max_velocity` when calling `run_positions`, must be a value less than or equal to `2`")  # noqa: E501
        if 'tcp_max_velocity' in params and params['tcp_max_velocity'] <= 0:  # noqa: E501
            raise ValueError("Invalid value for parameter `tcp_max_velocity` when calling `run_positions`, must be a value greater than `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'speed' in params:
            query_params.append(('speed', params['speed']))  # noqa: E501
        if 'velocity' in params:
            query_params.append(('velocity', params['velocity']))  # noqa: E501
        if 'acceleration' in params:
            query_params.append(('acceleration', params['acceleration']))  # noqa: E501
        if 'motion_type' in params:
            query_params.append(('motionType', params['motion_type']))  # noqa: E501
        if 'tcp_max_velocity' in params:
            query_params.append(('tcp_max_velocity', params['tcp_max_velocity']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/positions/run', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def set_digital_output_high(self, port, **kwargs):  # noqa: E501
        """Set high level of digital output signal  # noqa: E501

        The function sets the digital output specified in the {port} parameter of the request path to the HIGH signal level.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_digital_output_high(port, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int port: The parameter indicates the number of a digital output is a physical port on the back panel of the control box. Since the control box has two digital outputs, the parameter value can be either 1 (corresponds to Relay output 1) or 2 (corresponds to Relay output 2). (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.set_digital_output_high_with_http_info(port, **kwargs)  # noqa: E501
        else:
            (data) = self.set_digital_output_high_with_http_info(port, **kwargs)  # noqa: E501
            return data

    def set_digital_output_high_with_http_info(self, port, **kwargs):  # noqa: E501
        """Set high level of digital output signal  # noqa: E501

        The function sets the digital output specified in the {port} parameter of the request path to the HIGH signal level.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_digital_output_high_with_http_info(port, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int port: The parameter indicates the number of a digital output is a physical port on the back panel of the control box. Since the control box has two digital outputs, the parameter value can be either 1 (corresponds to Relay output 1) or 2 (corresponds to Relay output 2). (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['port']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_digital_output_high" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'port' is set
        if ('port' not in params or
                params['port'] is None):
            raise ValueError("Missing the required parameter `port` when calling `set_digital_output_high`")  # noqa: E501

        if 'port' in params and params['port'] > 2:  # noqa: E501
            raise ValueError("Invalid value for parameter `port` when calling `set_digital_output_high`, must be a value less than or equal to `2`")  # noqa: E501
        if 'port' in params and params['port'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `port` when calling `set_digital_output_high`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'port' in params:
            path_params['port'] = params['port']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/signal/output/{port}/high', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def set_digital_output_low(self, port, **kwargs):  # noqa: E501
        """Set low level of digital output signal  # noqa: E501

        The function sets the digital output specified in the Port parameter to the LOW signal level. A digital output is a physical port on the back panel of the control box that controls the robotic arm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_digital_output_low(port, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int port: The parameter indicates the number of the digital output on the back of the control box that you want to set to the LOW signal level. Since the control box has two digital outputs, the parameter value can be either 1 (corresponds to Relay output 1 on the control box) or 2 (corresponds to Relay output 2 on the control box). (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.set_digital_output_low_with_http_info(port, **kwargs)  # noqa: E501
        else:
            (data) = self.set_digital_output_low_with_http_info(port, **kwargs)  # noqa: E501
            return data

    def set_digital_output_low_with_http_info(self, port, **kwargs):  # noqa: E501
        """Set low level of digital output signal  # noqa: E501

        The function sets the digital output specified in the Port parameter to the LOW signal level. A digital output is a physical port on the back panel of the control box that controls the robotic arm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_digital_output_low_with_http_info(port, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int port: The parameter indicates the number of the digital output on the back of the control box that you want to set to the LOW signal level. Since the control box has two digital outputs, the parameter value can be either 1 (corresponds to Relay output 1 on the control box) or 2 (corresponds to Relay output 2 on the control box). (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['port']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_digital_output_low" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'port' is set
        if ('port' not in params or
                params['port'] is None):
            raise ValueError("Missing the required parameter `port` when calling `set_digital_output_low`")  # noqa: E501

        if 'port' in params and params['port'] > 2:  # noqa: E501
            raise ValueError("Invalid value for parameter `port` when calling `set_digital_output_low`, must be a value less than or equal to `2`")  # noqa: E501
        if 'port' in params and params['port'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `port` when calling `set_digital_output_low`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'port' in params:
            path_params['port'] = params['port']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/signal/output/{port}/low', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def set_pose(self, body, **kwargs):  # noqa: E501
        """Setting a new arm pose  # noqa: E501

        The function commands the arm to move to a new pose. A pose is described as a set of output flange angles (in degrees) of the six servos integrated into the robot joints.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_pose(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Pose body: Request Body (required)
        :param int speed: Speed of Robot. Controls acceleration and velocity at the same time.
        :param int velocity: Velocity of Robot. MUST be used together with acceleration.
        :param int acceleration: Acceleration of Robot. MUST be used together with velocity. **Note:** Use values greater than 100 with caution: the robotic arm could reject or fail operation execution. Values greater than 100 are acceptable when the robotic arm moves with a relatively light load or without one.
        :param str motion_type: Motion type of robot. MUST be either JOINT (default) or LINEAR
        :param float tcp_max_velocity: The parameter defines the limit velocity in meters per second that an end effector can reach at its TCP while moving. It is not mandatory. When the user specifies no value for it, it is set to default. The default setting is 2 m/s.
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.set_pose_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.set_pose_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def set_pose_with_http_info(self, body, **kwargs):  # noqa: E501
        """Setting a new arm pose  # noqa: E501

        The function commands the arm to move to a new pose. A pose is described as a set of output flange angles (in degrees) of the six servos integrated into the robot joints.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_pose_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Pose body: Request Body (required)
        :param int speed: Speed of Robot. Controls acceleration and velocity at the same time.
        :param int velocity: Velocity of Robot. MUST be used together with acceleration.
        :param int acceleration: Acceleration of Robot. MUST be used together with velocity. **Note:** Use values greater than 100 with caution: the robotic arm could reject or fail operation execution. Values greater than 100 are acceptable when the robotic arm moves with a relatively light load or without one.
        :param str motion_type: Motion type of robot. MUST be either JOINT (default) or LINEAR
        :param float tcp_max_velocity: The parameter defines the limit velocity in meters per second that an end effector can reach at its TCP while moving. It is not mandatory. When the user specifies no value for it, it is set to default. The default setting is 2 m/s.
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'speed', 'velocity', 'acceleration', 'motion_type', 'tcp_max_velocity']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_pose" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `set_pose`")  # noqa: E501

        if 'speed' in params and params['speed'] > 100:  # noqa: E501
            raise ValueError("Invalid value for parameter `speed` when calling `set_pose`, must be a value less than or equal to `100`")  # noqa: E501
        if 'speed' in params and params['speed'] <= 0:  # noqa: E501
            raise ValueError("Invalid value for parameter `speed` when calling `set_pose`, must be a value greater than `0`")  # noqa: E501
        if 'velocity' in params and params['velocity'] > 100:  # noqa: E501
            raise ValueError("Invalid value for parameter `velocity` when calling `set_pose`, must be a value less than or equal to `100`")  # noqa: E501
        if 'velocity' in params and params['velocity'] <= 0:  # noqa: E501
            raise ValueError("Invalid value for parameter `velocity` when calling `set_pose`, must be a value greater than `0`")  # noqa: E501
        if 'acceleration' in params and params['acceleration'] > 200:  # noqa: E501
            raise ValueError("Invalid value for parameter `acceleration` when calling `set_pose`, must be a value less than or equal to `200`")  # noqa: E501
        if 'acceleration' in params and params['acceleration'] <= 0:  # noqa: E501
            raise ValueError("Invalid value for parameter `acceleration` when calling `set_pose`, must be a value greater than `0`")  # noqa: E501
        if 'tcp_max_velocity' in params and params['tcp_max_velocity'] > 2:  # noqa: E501
            raise ValueError("Invalid value for parameter `tcp_max_velocity` when calling `set_pose`, must be a value less than or equal to `2`")  # noqa: E501
        if 'tcp_max_velocity' in params and params['tcp_max_velocity'] <= 0:  # noqa: E501
            raise ValueError("Invalid value for parameter `tcp_max_velocity` when calling `set_pose`, must be a value greater than `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'speed' in params:
            query_params.append(('speed', params['speed']))  # noqa: E501
        if 'velocity' in params:
            query_params.append(('velocity', params['velocity']))  # noqa: E501
        if 'acceleration' in params:
            query_params.append(('acceleration', params['acceleration']))  # noqa: E501
        if 'motion_type' in params:
            query_params.append(('motionType', params['motion_type']))  # noqa: E501
        if 'tcp_max_velocity' in params:
            query_params.append(('tcp_max_velocity', params['tcp_max_velocity']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/pose', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def set_position(self, body, **kwargs):  # noqa: E501
        """Setting a new arm position  # noqa: E501

        The function commands the arm to move to a new position. The position is described as a set of x, y, and z coordinates, as well as _roll_, _pitch_, and _yaw_ rotation angles. The coordinates define the desired distance (in meters) from the zero point to the TCP along the x, y, and z axes accordingly. _Roll_ stands for the desired TCP rotation angle around the x axis; _pitch_ - the desired TCP rotation angle around the y axis; _yaw_ - the desired TCP rotation angle around the z axis. All rotation angles are in radians.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_position(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Position body: Request Body (required)
        :param int speed: Speed of Robot. Controls acceleration and velocity at the same time.
        :param int velocity: Velocity of Robot. MUST be used together with acceleration.
        :param int acceleration: Acceleration of Robot. MUST be used together with velocity. **Note:** Use values greater than 100 with caution: the robotic arm could reject or fail operation execution. Values greater than 100 are acceptable when the robotic arm moves with a relatively light load or without one.
        :param str motion_type: Motion type of robot. MUST be either JOINT (default) or LINEAR
        :param float tcp_max_velocity: The parameter defines the limit velocity in meters per second that an end effector can reach at its TCP while moving. It is not mandatory. When the user specifies no value for it, it is set to default. The default setting is 2 m/s.
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.set_position_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.set_position_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def set_position_with_http_info(self, body, **kwargs):  # noqa: E501
        """Setting a new arm position  # noqa: E501

        The function commands the arm to move to a new position. The position is described as a set of x, y, and z coordinates, as well as _roll_, _pitch_, and _yaw_ rotation angles. The coordinates define the desired distance (in meters) from the zero point to the TCP along the x, y, and z axes accordingly. _Roll_ stands for the desired TCP rotation angle around the x axis; _pitch_ - the desired TCP rotation angle around the y axis; _yaw_ - the desired TCP rotation angle around the z axis. All rotation angles are in radians.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_position_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Position body: Request Body (required)
        :param int speed: Speed of Robot. Controls acceleration and velocity at the same time.
        :param int velocity: Velocity of Robot. MUST be used together with acceleration.
        :param int acceleration: Acceleration of Robot. MUST be used together with velocity. **Note:** Use values greater than 100 with caution: the robotic arm could reject or fail operation execution. Values greater than 100 are acceptable when the robotic arm moves with a relatively light load or without one.
        :param str motion_type: Motion type of robot. MUST be either JOINT (default) or LINEAR
        :param float tcp_max_velocity: The parameter defines the limit velocity in meters per second that an end effector can reach at its TCP while moving. It is not mandatory. When the user specifies no value for it, it is set to default. The default setting is 2 m/s.
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'speed', 'velocity', 'acceleration', 'motion_type', 'tcp_max_velocity']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_position" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `set_position`")  # noqa: E501

        if 'speed' in params and params['speed'] > 100:  # noqa: E501
            raise ValueError("Invalid value for parameter `speed` when calling `set_position`, must be a value less than or equal to `100`")  # noqa: E501
        if 'speed' in params and params['speed'] <= 0:  # noqa: E501
            raise ValueError("Invalid value for parameter `speed` when calling `set_position`, must be a value greater than `0`")  # noqa: E501
        if 'velocity' in params and params['velocity'] > 100:  # noqa: E501
            raise ValueError("Invalid value for parameter `velocity` when calling `set_position`, must be a value less than or equal to `100`")  # noqa: E501
        if 'velocity' in params and params['velocity'] <= 0:  # noqa: E501
            raise ValueError("Invalid value for parameter `velocity` when calling `set_position`, must be a value greater than `0`")  # noqa: E501
        if 'acceleration' in params and params['acceleration'] > 200:  # noqa: E501
            raise ValueError("Invalid value for parameter `acceleration` when calling `set_position`, must be a value less than or equal to `200`")  # noqa: E501
        if 'acceleration' in params and params['acceleration'] <= 0:  # noqa: E501
            raise ValueError("Invalid value for parameter `acceleration` when calling `set_position`, must be a value greater than `0`")  # noqa: E501
        if 'tcp_max_velocity' in params and params['tcp_max_velocity'] > 2:  # noqa: E501
            raise ValueError("Invalid value for parameter `tcp_max_velocity` when calling `set_position`, must be a value less than or equal to `2`")  # noqa: E501
        if 'tcp_max_velocity' in params and params['tcp_max_velocity'] <= 0:  # noqa: E501
            raise ValueError("Invalid value for parameter `tcp_max_velocity` when calling `set_position`, must be a value greater than `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'speed' in params:
            query_params.append(('speed', params['speed']))  # noqa: E501
        if 'velocity' in params:
            query_params.append(('velocity', params['velocity']))  # noqa: E501
        if 'acceleration' in params:
            query_params.append(('acceleration', params['acceleration']))  # noqa: E501
        if 'motion_type' in params:
            query_params.append(('motionType', params['motion_type']))  # noqa: E501
        if 'tcp_max_velocity' in params:
            query_params.append(('tcp_max_velocity', params['tcp_max_velocity']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/position', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def status(self, **kwargs):  # noqa: E501
        """Getting the actual robot status  # noqa: E501

        The function returns the actual state of the robotic arm - whether it is initializing, or twisted, or running (in motion), or active (not in motion), or in the zero gravity mode, or failed (broken, failed initializing or in emergency).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.status(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: SystemStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.status_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.status_with_http_info(**kwargs)  # noqa: E501
            return data

    def status_with_http_info(self, **kwargs):  # noqa: E501
        """Getting the actual robot status  # noqa: E501

        The function returns the actual state of the robotic arm - whether it is initializing, or twisted, or running (in motion), or active (not in motion), or in the zero gravity mode, or failed (broken, failed initializing or in emergency).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.status_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: SystemStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method status" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/status', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SystemStatus',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def status_motion(self, **kwargs):  # noqa: E501
        """Getting the actual motion status  # noqa: E501

        The function returns the actual state of the robotic arm motion - whether it is running (in motion), or idle (not in motion), or in the zero gravity mode.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.status_motion(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: MotionStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.status_motion_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.status_motion_with_http_info(**kwargs)  # noqa: E501
            return data

    def status_motion_with_http_info(self, **kwargs):  # noqa: E501
        """Getting the actual motion status  # noqa: E501

        The function returns the actual state of the robotic arm motion - whether it is running (in motion), or idle (not in motion), or in the zero gravity mode.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.status_motion_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: MotionStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method status_motion" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/status/motion', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MotionStatus',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def status_motors(self, **kwargs):  # noqa: E501
        """Getting the actual status of servo motors  # noqa: E501

        The function returns the actual states of the six servo motors integrated into the joints of the robotic arm. The states are described as arrays of values for the following properties:  - _Angle_ - the actual angular position (in degrees) of the servo's output flange  - _Rotor velocity_ - the actual rotor velocity (in RPM)  - _RMS current_ - the actual input current (in Amperes)  - _Phase current_ - the actual magnitude of alternating current (in Amperes)  - _Supply voltage_ - the actual supply voltage (in Volts)  - _Stator temperature_  - the actual temperature (in degrees C) as measured on the stator winding  - _Servo temperature_ - the actual temperature (in degrees C) as measured on the MCU PCB  - _Velocity setpoint_ - the user-preset rotor velocity (in RPM)  - _Velocity output_ - the motor control current (in Amperes) based on the preset velocity  - _Velocity feedback_ - the actual rotor velocity (in RPM)  - _Velocity error_ - the difference between the preset and the actual rotor velocities (in RPM)  - _Position setpoint_ - the user-preset position of the servo flange in degrees  - _Position output_ - rotor velocity (in RPM) based on the position setpoint  - _Position feedback_ - the actual position of the servo flange (in degrees) based on   the encoder feedback  - _Position error_ - the difference (in degrees) between the preset and the actual positions   of the servo flange   Each property in an array has six values - one for each of the six servos in the arm joints.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.status_motors(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: list[MotorStatus]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.status_motors_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.status_motors_with_http_info(**kwargs)  # noqa: E501
            return data

    def status_motors_with_http_info(self, **kwargs):  # noqa: E501
        """Getting the actual status of servo motors  # noqa: E501

        The function returns the actual states of the six servo motors integrated into the joints of the robotic arm. The states are described as arrays of values for the following properties:  - _Angle_ - the actual angular position (in degrees) of the servo's output flange  - _Rotor velocity_ - the actual rotor velocity (in RPM)  - _RMS current_ - the actual input current (in Amperes)  - _Phase current_ - the actual magnitude of alternating current (in Amperes)  - _Supply voltage_ - the actual supply voltage (in Volts)  - _Stator temperature_  - the actual temperature (in degrees C) as measured on the stator winding  - _Servo temperature_ - the actual temperature (in degrees C) as measured on the MCU PCB  - _Velocity setpoint_ - the user-preset rotor velocity (in RPM)  - _Velocity output_ - the motor control current (in Amperes) based on the preset velocity  - _Velocity feedback_ - the actual rotor velocity (in RPM)  - _Velocity error_ - the difference between the preset and the actual rotor velocities (in RPM)  - _Position setpoint_ - the user-preset position of the servo flange in degrees  - _Position output_ - rotor velocity (in RPM) based on the position setpoint  - _Position feedback_ - the actual position of the servo flange (in degrees) based on   the encoder feedback  - _Position error_ - the difference (in degrees) between the preset and the actual positions   of the servo flange   Each property in an array has six values - one for each of the six servos in the arm joints.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.status_motors_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: list[MotorStatus]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method status_motors" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/status/motors', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[MotorStatus]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def stop_untwisting(self, **kwargs):  # noqa: E501
        """Try to exit from twisted mode  # noqa: E501

        Try to exit from twisted mode. Return success message if it is possible or instruction what you need to do to untwist robot.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.stop_untwisting(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.stop_untwisting_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.stop_untwisting_with_http_info(**kwargs)  # noqa: E501
            return data

    def stop_untwisting_with_http_info(self, **kwargs):  # noqa: E501
        """Try to exit from twisted mode  # noqa: E501

        Try to exit from twisted mode. Return success message if it is possible or instruction what you need to do to untwist robot.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.stop_untwisting_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method stop_untwisting" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/untwisting/finish', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
