# altf1be_sca_tork_easycube_api

Helpers for SCA Tork Easycube API facilitating the collection of data generated by the dispensers Built by http://www.alt-f1.be.

See <https://bitbucket.org/altf1be/com_torkglobal_easycube_fm>

* https://easycube.sca-tork.com/en/Plan/Index 
* https://fm.easycube.torkglobal.com/en
* https://easycube-external-api-web-c2m2jq5zkw6rc.azurewebsites.net/swagger

Author: Abdelkrim BOUJRAF, http://www.alt-f1.be

## Screenshot

* `cd web; ./run_web.sh`
* open a browser `http://0.0.0.0:8000/api/dispensers/sca_tork_easycube/`

Display actions required per dispenser: 
![alt text](./doc/static/img/actions.html.png "Display actions required per dispenser")

## Usage

1. Create a .env including this parameter COM_GOOGLE_ANALYTICS_TRACKING_ID

``` sh

export SCA_TORK_EASYCUBE_CLIENT_ID=xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx
export SCA_TORK_EASYCUBE_CLIENT_SECRET=aaaaaaaa-aaaa-aaaa-aaaa-aaaaaaaaaaaa
export SCA_TORK_EASYCUBE_GRANT_TYPE=client_credentials
export SCA_TORK_EASYCUBE_SCOPE=EasyCube.External.Api
export SCA_TORK_EASYCUBE_BASE_URL=https://easycube-external-api-web-c2m2jq5zkw6rc.azurewebsites.net

```

2. Install the pyhton packages

``` sh
pip install -r requirements.txt
```

3. load the .env in your entry point (app.py, main.py, test.py)


``` sh
from dotenv import load_dotenv

load_dotenv()

```

4. Run the code and check if the you can access to the REST API


``` python
python

import altf1be_sca_tork_easycube_api
print(dir(altf1be_sca_tork_easycube_api))

# ['AltF1BeHelpers', 'AltF1BeJSONHelpers', 'DISPENSER_TYPE_NOT_FOUND', 'Dispensers', 'DispensersModel', 'ERROR_UNKNOWN', 'SCATorkEasyCubeAPI', 'SCATorkEasyCubeAPIAuthentication', 'SCATorkEasyCubeAPIHelpers', 'STATUS_UNKNOWN', '__all__', '__builtins__', '__cached__', '__doc__', '__file__', '__loader__', '__name__', '__package__', '__path__', '__spec__', 'credentials_filename', 'datetime', 'dispensers', 'dispensers_model', 'glob', 'json', 'load_dotenv', 'log_filename', 'logger', 'logging', 'np', 'os', 'pd', 'requests', 'sca_tork_easycube_api', 'sca_tork_easycube_api_authentication', 'sca_tork_easycube_api_helpers', 'sys', 'time', 'timezone']

```

## installation

* install the package on **pypi.org** : 
    * install : `pip install altf1be_sca_tork_easycube_api`
    * upgrade : `pip install altf1be_sca_tork_easycube_api --upgrade`


* install the package on **test.pypi.org** : 
    * install : `pip install -i https://test.pypi.org/simple/altf1be_sca_tork_easycube_api`
    * upgrade : `pip install -i https://test.pypi.org/simple/altf1be_sca_tork_easycube_api --upgrade`

## dependencies

* See [requirements.txt](requirements.txt)

## Build this package 

* build the setup.py
    * `python3 setup.py sdist bdist_wheel`
    * `python3 -m pip install --user --upgrade twine --use-feature=2020-resolver`

* upload the library on TEST **pypi.org** 
    * `python -m twine upload --repository-url https://test.pypi.org/legacy/ dist/*` 
    * Source : [https://test.pypi.org/project/altf1be_helpers](https://test.pypi.org/project/altf1be_helpers)

* upload the library on PROD **pypi.org** 
    * `python -m twine upload dist/*` 
    * Source : [https://pypi.org/project/altf1be_helpers](https://pypi.org/project/altf1be_helpers)

## Documentation to build a Python package

* Packaging Python Projects <https://packaging.python.org/tutorials/packaging-projects/>
* Managing Application Dependencies <https://packaging.python.org/tutorials/managing-dependencies/#managing-dependencies>
* Packaging and distributing projects <https://packaging.python.org/guides/distributing-packages-using-setuptools/#distributing-packages>

## License

Copyright (c) ALT-F1 SPRL, Abdelkrim BOUJRAF. All rights reserved.

This project IS NOT open sourced BUT the source code is freely available

See LICENSE in the project root for license information.
