"""Vanilla types."""

from enum import IntEnum


class GameType(IntEnum):  # noqa: D101
    GAME_NONE = -1
    GAME_SP_NEW = 0
    GAME_SP_SCENARIO = 1
    GAME_SP_LOAD = 2
    GAME_MP_NEW = 3
    GAME_MP_SCENARIO = 4
    GAME_MP_LOAD = 5
    GAME_HOTSEAT_NEW = 6
    GAME_HOTSEAT_SCENARIO = 7
    GAME_HOTSEAT_LOAD = 8
    GAME_PBEM_NEW = 9
    GAME_PBEM_SCENARIO = 10
    GAME_PBEM_LOAD = 11
    GAME_REPLAY = 12


class GameStateType(IntEnum):  # noqa: D101
    GAMESTATE_ON = 0
    GAMESTATE_OVER = 1
    GAMESTATE_EXTENDED = 2


class TradeableItem(IntEnum):  # noqa: D101
    TRADE_ITEM_NONE = -1
    TRADE_GOLD = 0
    TRADE_GOLD_PER_TURN = 1
    TRADE_MAPS = 2
    TRADE_VASSAL = 3
    TRADE_SURRENDER = 4
    TRADE_OPEN_BORDERS = 5
    TRADE_DEFENSIVE_PACT = 6
    TRADE_PERMANENT_ALLIANCE = 7
    TRADE_PEACE_TREATY = 8
    TRADE_TECHNOLOGIES = 9
    TRADE_RESOURCES = 10
    TRADE_CITIES = 11
    TRADE_PEACE = 12
    TRADE_WAR = 13
    TRADE_EMBARGO = 14
    TRADE_CIVIC = 15
    TRADE_RELIGION = 16


class ReplayMessageType(IntEnum):  # noqa: D101
    MAJOR_EVENT = 0
    CITY_FOUNDED = 1
    PLOT_OWNER_CHANGE = 2


class PlotType(IntEnum):  # noqa: D101
    NO_PLOT = -1
    PLOT_PEAK = 0
    PLOT_HILLS = 1
    PLOT_LAND = 2
    PLOT_OCEAN = 3


class ArtDefinesBonusType(IntEnum):  # noqa: D101
    NO_ART_DEFINES_BONUS = -1
    ART_DEF_BONUS_ALUMINUM = 0
    ART_DEF_BONUS_COAL = 1
    ART_DEF_BONUS_COPPER = 2
    ART_DEF_BONUS_HORSE = 3
    ART_DEF_BONUS_IRON = 4
    ART_DEF_BONUS_MARBLE = 5
    ART_DEF_BONUS_OIL = 6
    ART_DEF_BONUS_STONE = 7
    ART_DEF_BONUS_URANIUM = 8
    ART_DEF_BONUS_DYE = 9
    ART_DEF_BONUS_FUR = 10
    ART_DEF_BONUS_GEMS = 11
    ART_DEF_BONUS_GOLD = 12
    ART_DEF_BONUS_INCENSE = 13
    ART_DEF_BONUS_IVORY = 14
    ART_DEF_BONUS_SILK = 15
    ART_DEF_BONUS_SILVER = 16
    ART_DEF_BONUS_SPICES = 17
    ART_DEF_BONUS_SUGAR = 18
    ART_DEF_BONUS_WINE = 19
    ART_DEF_BONUS_WHALE = 20
    ART_DEF_BONUS_BANANA = 21
    ART_DEF_BONUS_CLAM = 22
    ART_DEF_BONUS_CORN = 23
    ART_DEF_BONUS_COW = 24
    ART_DEF_BONUS_CRAB = 25
    ART_DEF_BONUS_DEER = 26
    ART_DEF_BONUS_FISH = 27
    ART_DEF_BONUS_PIG = 28
    ART_DEF_BONUS_RICE = 29
    ART_DEF_BONUS_SHEEP = 30
    ART_DEF_BONUS_WHEAT = 31
    ART_DEF_BONUS_DRAMA = 32
    ART_DEF_BONUS_MUSIC = 33
    ART_DEF_BONUS_MOVIES = 34
    ART_DEF_BONUS_COTTON = 35
    ART_DEF_BONUS_TOBACCO = 36
    ART_DEF_BONUS_OLIVES = 37
    ART_DEF_BONUS_VICTORY_BLUE = 38
    ART_DEF_BONUS_VICTORY_PURPLE = 39
    ART_DEF_BONUS_VICTORY_RED = 40
    ART_DEF_BONUS_VICTORY_YELLOW = 41
    ART_DEF_BONUS_VICTORY_GREEN = 42


class ArtDefinesBuildingType(IntEnum):  # noqa: D101
    NO_ART_DEFINES_BUILDING = -1
    ART_DEF_BUILDING_PALACE = 0
    ART_DEF_BUILDING_GREAT_PALACE = 1
    ART_DEF_BUILDING_VERSAILLES = 2
    ART_DEF_BUILDING_WALLS = 3
    ART_DEF_BUILDING_CELTIC_DUN = 4
    ART_DEF_BUILDING_CASTLE = 5
    ART_DEF_BUILDING_SPANISH_CITADEL = 6
    ART_DEF_BUILDING_BARRACKS = 7
    ART_DEF_BUILDING_ZULU_IKHANDA = 8
    ART_DEF_BUILDING_STABLE = 9
    ART_DEF_BUILDING_MONGOL_GER = 10
    ART_DEF_BUILDING_BUNKER = 11
    ART_DEF_BUILDING_BOMB_SHELTER = 12
    ART_DEF_BUILDING_GRANARY = 13
    ART_DEF_BUILDING_INCAN_TERRACE = 14
    ART_DEF_BUILDING_AQUEDUCT = 15
    ART_DEF_BUILDING_OTTOMAN_HAMMAM = 16
    ART_DEF_BUILDING_KHMER_BARAY = 17
    ART_DEF_BUILDING_HOSPITAL = 18
    ART_DEF_BUILDING_RECYCLING_CENTER = 19
    ART_DEF_BUILDING_LIGHTHOUSE = 20
    ART_DEF_BUILDING_VIKING_TRADING_POST = 21
    ART_DEF_BUILDING_HARBOR = 22
    ART_DEF_BUILDING_CARTHAGE_COTHON = 23
    ART_DEF_BUILDING_CUSTOM_HOUSE = 24
    ART_DEF_BUILDING_DRYDOCK = 25
    ART_DEF_BUILDING_AIRPORT = 26
    ART_DEF_BUILDING_FORGE = 27
    ART_DEF_BUILDING_MALI_MINT = 28
    ART_DEF_BUILDING_FACTORY = 29
    ART_DEF_BUILDING_GERMAN_ASSEMBLY_PLANT = 30
    ART_DEF_BUILDING_COAL_PLANT = 31
    ART_DEF_BUILDING_JAPANESE_SHALE_PLANT = 32
    ART_DEF_BUILDING_HYDRO_PLANT = 33
    ART_DEF_BUILDING_NUCLEAR_PLANT = 34
    ART_DEF_BUILDING_INDUSTRIAL_PARK = 35
    ART_DEF_BUILDING_OBELISK = 36
    ART_DEF_BUILDING_EGYPTIAN_OBELISK = 37
    ART_DEF_BUILDING_ACADEMY = 38
    ART_DEF_BUILDING_LIBRARY = 39
    ART_DEF_BUILDING_ARABIAN_MADRASSA = 40
    ART_DEF_BUILDING_UNIVERSITY = 41
    ART_DEF_BUILDING_KOREAN_SEOWON = 42
    ART_DEF_BUILDING_OBSERVATORY = 43
    ART_DEF_BUILDING_FRENCH_SALON = 44
    ART_DEF_BUILDING_LABORATORY = 45
    ART_DEF_BUILDING_RUSSIAN_RESEARCH_INSTITUTE = 46
    ART_DEF_BUILDING_THEATRE = 47
    ART_DEF_BUILDING_CHINESE_PAVILLION = 48
    ART_DEF_BUILDING_BYZANTINE_HIPPODROME = 49
    ART_DEF_BUILDING_COLOSSEUM = 50
    ART_DEF_BUILDING_GREEK_ODEON = 51
    ART_DEF_BUILDING_MAYA_BALL_COURT = 52
    ART_DEF_BUILDING_BABYLON_GARDEN = 53
    ART_DEF_BUILDING_BROADCAST_TOWER = 54
    ART_DEF_BUILDING_AMERICAN_MALL = 55
    ART_DEF_BUILDING_MARKET = 56
    ART_DEF_BUILDING_ROMAN_FORUM = 57
    ART_DEF_BUILDING_PORTUGAL_FEITORIA = 58
    ART_DEF_BUILDING_GROCER = 59
    ART_DEF_BUILDING_PERSIAN_APOTHECARY = 60
    ART_DEF_BUILDING_BANK = 61
    ART_DEF_BUILDING_ENGLISH_STOCK_EXCHANGE = 62
    ART_DEF_BUILDING_SUPERMARKET = 63
    ART_DEF_BUILDING_COURTHOUSE = 64
    ART_DEF_BUILDING_AZTEC_SACRIFICIAL_ALTAR = 65
    ART_DEF_BUILDING_HOLY_ROMAN_RATHAUS = 66
    ART_DEF_BUILDING_SUMERIAN_ZIGGURAT = 67
    ART_DEF_BUILDING_JAIL = 68
    ART_DEF_BUILDING_INTELLIGENCE_AGENCY = 69
    ART_DEF_BUILDING_NATIONAL_SECURITY = 70
    ART_DEF_BUILDING_INDIAN_MAUSOLEUM = 71
    ART_DEF_BUILDING_LEVEE = 72
    ART_DEF_BUILDING_NETHERLANDS_DIKE = 73
    ART_DEF_BUILDING_JEWISH_TEMPLE = 74
    ART_DEF_BUILDING_JEWISH_CATHEDRAL = 75
    ART_DEF_BUILDING_JEWISH_MONASTERY = 76
    ART_DEF_BUILDING_JEWISH_SHRINE = 77
    ART_DEF_BUILDING_CHRISTIAN_TEMPLE = 78
    ART_DEF_BUILDING_CHRISTIAN_CATHEDRAL = 79
    ART_DEF_BUILDING_CHRISTIAN_MONASTERY = 80
    ART_DEF_BUILDING_CHRISTIAN_SHRINE = 81
    ART_DEF_BUILDING_ISLAMIC_TEMPLE = 82
    ART_DEF_BUILDING_ISLAMIC_CATHEDRAL = 83
    ART_DEF_BUILDING_ISLAMIC_MONASTERY = 84
    ART_DEF_BUILDING_ISLAMIC_SHRINE = 85
    ART_DEF_BUILDING_HINDU_TEMPLE = 86
    ART_DEF_BUILDING_HINDU_CATHEDRAL = 87
    ART_DEF_BUILDING_HINDU_MONASTERY = 88
    ART_DEF_BUILDING_HINDU_SHRINE = 89
    ART_DEF_BUILDING_BUDDHIST_TEMPLE = 90
    ART_DEF_BUILDING_BUDDHIST_CATHEDRAL = 91
    ART_DEF_BUILDING_BUDDHIST_MONASTERY = 92
    ART_DEF_BUILDING_BUDDHIST_SHRINE = 93
    ART_DEF_BUILDING_CONFUCIAN_TEMPLE = 94
    ART_DEF_BUILDING_CONFUCIAN_CATHEDRAL = 95
    ART_DEF_BUILDING_CONFUCIAN_MONASTERY = 96
    ART_DEF_BUILDING_CONFUCIAN_SHRINE = 97
    ART_DEF_BUILDING_TAOIST_TEMPLE = 98
    ART_DEF_BUILDING_TAOIST_CATHEDRAL = 99
    ART_DEF_BUILDING_TAOIST_MONASTERY = 100
    ART_DEF_BUILDING_TAOIST_SHRINE = 101
    ART_DEF_BUILDING_HEROIC_EPIC = 102
    ART_DEF_BUILDING_NATIONAL_EPIC = 103
    ART_DEF_BUILDING_GLOBE_THEATRE = 104
    ART_DEF_BUILDING_HERMITAGE = 105
    ART_DEF_BUILDING_OXFORD_UNIVERSITY = 106
    ART_DEF_BUILDING_WALL_STREET = 107
    ART_DEF_BUILDING_IRON_WORKS = 108
    ART_DEF_BUILDING_WEST_POINT = 109
    ART_DEF_BUILDING_MT_RUSHMORE = 110
    ART_DEF_BUILDING_RED_CROSS = 111
    ART_DEF_BUILDING_SCOTLAND_YARD = 112
    ART_DEF_BUILDING_PYRAMID = 113
    ART_DEF_BUILDING_STONEHENGE = 114
    ART_DEF_BUILDING_GREAT_LIBRARY = 115
    ART_DEF_BUILDING_GREAT_LIGHTHOUSE = 116
    ART_DEF_BUILDING_HANGING_GARDEN = 117
    ART_DEF_BUILDING_COLOSSUS = 118
    ART_DEF_BUILDING_ORACLE = 119
    ART_DEF_BUILDING_PARTHENON = 120
    ART_DEF_BUILDING_ANGKOR_WAT = 121
    ART_DEF_BUILDING_HAGIA_SOPHIA = 122
    ART_DEF_BUILDING_CHICHEN_ITZA = 123
    ART_DEF_BUILDING_SISTINE_CHAPEL = 124
    ART_DEF_BUILDING_SPIRAL_MINARET = 125
    ART_DEF_BUILDING_NOTRE_DAME = 126
    ART_DEF_BUILDING_TAJ_MAHAL = 127
    ART_DEF_BUILDING_KREMLIN = 128
    ART_DEF_BUILDING_EIFFEL_TOWER = 129
    ART_DEF_BUILDING_STATUE_OF_LIBERTY = 130
    ART_DEF_BUILDING_BROADWAY = 131
    ART_DEF_BUILDING_ROCKNROLL = 132
    ART_DEF_BUILDING_HOLLYWOOD = 133
    ART_DEF_BUILDING_GREAT_DAM = 134
    ART_DEF_BUILDING_PENTAGON = 135
    ART_DEF_BUILDING_UNITED_NATIONS = 136
    ART_DEF_BUILDING_SPACE_ELEVATOR = 137
    ART_DEF_BUILDING_ARTEMIS = 138
    ART_DEF_BUILDING_GREAT_WALL = 139
    ART_DEF_BUILDING_SANKORE = 140
    ART_DEF_BUILDING_MILITARY_ACADEMY = 141
    ART_DEF_BUILDING_MONUMENT = 142
    ART_DEF_BUILDING_ETHIOPIAN_STELE = 143
    ART_DEF_BUILDING_NATIVE_AMERICA_TOTEM = 144
    ART_DEF_BUILDING_PUBLIC_TRANSPORTATION = 145
    ART_DEF_BUILDING_NATIONAL_PARK = 146
    ART_DEF_BUILDING_MOAI_STATUES = 147
    ART_DEF_BUILDING_SHWEDAGON_PAYA = 148
    ART_DEF_BUILDING_MAUSOLEUM_OF_MAUSSOLLOS = 149
    ART_DEF_BUILDING_STATUE_OF_ZEUS = 150
    ART_DEF_BUILDING_CRISTO_REDENTOR = 151
    ART_DEF_BUILDING_CORPORATION_1 = 152
    ART_DEF_BUILDING_CORPORATION_2 = 153
    ART_DEF_BUILDING_CORPORATION_3 = 154
    ART_DEF_BUILDING_CORPORATION_4 = 155
    ART_DEF_BUILDING_CORPORATION_5 = 156
    ART_DEF_BUILDING_CORPORATION_6 = 157
    ART_DEF_BUILDING_CORPORATION_7 = 158
    ART_DEF_BUILDING_APOSTOLIC_PALACE = 159


class ArtDefinesCivilizationType(IntEnum):  # noqa: D101
    NO_ART_DEFINES_CIVILIZATION = -1
    ART_DEF_CIVILIZATION_AMERICA = 0
    ART_DEF_CIVILIZATION_ARABIA = 1
    ART_DEF_CIVILIZATION_AZTEC = 2
    ART_DEF_CIVILIZATION_BABYLON = 3
    ART_DEF_CIVILIZATION_BYZANTIUM = 4
    ART_DEF_CIVILIZATION_CARTHAGE = 5
    ART_DEF_CIVILIZATION_CELTS = 6
    ART_DEF_CIVILIZATION_CHINA = 7
    ART_DEF_CIVILIZATION_EGYPT = 8
    ART_DEF_CIVILIZATION_ENGLAND = 9
    ART_DEF_CIVILIZATION_ETHIOPIA = 10
    ART_DEF_CIVILIZATION_FRANCE = 11
    ART_DEF_CIVILIZATION_GERMANY = 12
    ART_DEF_CIVILIZATION_GREECE = 13
    ART_DEF_CIVILIZATION_HOLY_ROMAN = 14
    ART_DEF_CIVILIZATION_INCA = 15
    ART_DEF_CIVILIZATION_INDIA = 16
    ART_DEF_CIVILIZATION_JAPAN = 17
    ART_DEF_CIVILIZATION_KHMER = 18
    ART_DEF_CIVILIZATION_KOREA = 19
    ART_DEF_CIVILIZATION_MALI = 20
    ART_DEF_CIVILIZATION_MAYA = 21
    ART_DEF_CIVILIZATION_MONGOL = 22
    ART_DEF_CIVILIZATION_NATIVE_AMERICA = 23
    ART_DEF_CIVILIZATION_NETHERLANDS = 24
    ART_DEF_CIVILIZATION_OTTOMANS = 25
    ART_DEF_CIVILIZATION_PORTUGAL = 26
    ART_DEF_CIVILIZATION_PERSIA = 27
    ART_DEF_CIVILIZATION_ROME = 28
    ART_DEF_CIVILIZATION_RUSSIA = 29
    ART_DEF_CIVILIZATION_SPAIN = 30
    ART_DEF_CIVILIZATION_SUMERIA = 31
    ART_DEF_CIVILIZATION_VIKINGS = 32
    ART_DEF_CIVILIZATION_ZULU = 33
    ART_DEF_CIVILIZATION_MINOR = 34
    ART_DEF_CIVILIZATION_BARBARIAN = 35


class ArtDefinesFeatureType(IntEnum):  # noqa: D101
    NO_ART_DEFINES_FEATURE = -1
    ART_DEF_FEATURE_ICE = 0
    ART_DEF_FEATURE_JUNGLE = 1
    ART_DEF_FEATURE_OASIS = 2
    ART_DEF_FEATURE_FLOOD_PLAINS = 3
    ART_DEF_FEATURE_FOREST = 4
    ART_DEF_FEATURE_FALLOUT = 5


class ArtDefinesImprovementType(IntEnum):  # noqa: D101
    NO_ART_DEFINES_IMPROVEMENT = -1
    ART_DEF_IMPROVEMENT_LAND_WORKED = 0
    ART_DEF_IMPROVEMENT_WATER_WORKED = 1
    ART_DEF_IMPROVEMENT_CITY_RUINS = 2
    ART_DEF_IMPROVEMENT_GOODY_HUT = 3
    ART_DEF_IMPROVEMENT_FARM = 4
    ART_DEF_IMPROVEMENT_FISHING_BOATS = 5
    ART_DEF_IMPROVEMENT_WHALING_BOATS = 6
    ART_DEF_IMPROVEMENT_MINE = 7
    ART_DEF_IMPROVEMENT_WORKSHOP = 8
    ART_DEF_IMPROVEMENT_LUMBERMILL = 9
    ART_DEF_IMPROVEMENT_WINDMILL = 10
    ART_DEF_IMPROVEMENT_WATERMILL = 11
    ART_DEF_IMPROVEMENT_PLANTATION = 12
    ART_DEF_IMPROVEMENT_QUARRY = 13
    ART_DEF_IMPROVEMENT_PASTURE = 14
    ART_DEF_IMPROVEMENT_CAMP = 15
    ART_DEF_IMPROVEMENT_WELL = 16
    ART_DEF_IMPROVEMENT_OFFSHORE_PLATFORM = 17
    ART_DEF_IMPROVEMENT_WINERY = 18
    ART_DEF_IMPROVEMENT_COTTAGE = 19
    ART_DEF_IMPROVEMENT_HAMLET = 20
    ART_DEF_IMPROVEMENT_VILLAGE = 21
    ART_DEF_IMPROVEMENT_TOWN = 22
    ART_DEF_IMPROVEMENT_FORT = 23
    ART_DEF_IMPROVEMENT_FOREST_PRESERVE = 24


class ArtDefinesInterfaceType(IntEnum):  # noqa: D101
    NO_ART_DEFINES_INTERFACE = -1
    ARROW_HEAD = 0
    ARROW_MXMY = 1
    INTERFACE_CITY_TAB = 2
    INTERFACE_CITY_TAB_DOWN = 3
    INTERFACE_BUTTON_BACKGROUND = 4
    ARROW_MXY = 5
    ARROW_X = 6
    ARROW_XMY = 7
    ARROW_XY = 8
    ARROW_Y = 9
    BUTTON_HILITE_SMALLCIRCLE = 10
    BUTTON_HILITE_SQUARE = 11
    CIVICS_BACKGROUND = 12
    CIVICS_CANCEL = 13
    CIVICS_TOGGLE = 14
    CIVILOPEDIA_ANCIENT_BATTLEGROUND = 15
    CIVILOPEDIA_SKY_ENVIRONMENT = 16
    CIVILOPEDIA_WATER_ENVIRONMENT = 17
    CIVILOPEDIA_AMPHIB_ENVIRONMENT = 18
    DAWNOFMAN = 19
    DIPLOMACY_BACKGROUND = 20
    DIPLOMACY_CLEARTABLE = 21
    DIPLOMACY_INVENTORY = 22
    DIPLOMACY_INVENTORY_BUTTON = 23
    DIPLOMACY_NEW_BACKGROUND = 24
    DIPLOMACY_OFFER = 25
    DIPLOMACY_RESPONSE_1LINE = 26
    DIPLOMACY_RESPONSE_2LINE = 27
    DIPLOMACY_RETRACT = 28
    DIPLOMACY_TEXTENTRY = 29
    DIPLOMACY_TRADETABLE = 30
    DOMESTIC_BG = 31
    DOMESTIC_EXIT = 32
    CURSORS_SELECTION_UNIT = 33
    FONTS_GAMEFONT = 34
    FONTS_MONOCONSOLE = 35
    FONTS_NUMBERFONT = 36
    FONTS_SMALLFONT = 37
    INTERFACE_POPUPBUTTON_CIVICS = 38
    INTERFACE_POPUPBUTTON_WARNING = 39
    INTERFACE_POPUPBUTTON_PRODUCTION = 40
    INTERFACE_POPUPBUTTON_RELIGION = 41
    INTERFACE_POPUPBUTTON_TECH = 42
    INTERFACE_ANGRYCITIZEN_TEXTURE = 43
    INTERFACE_AUTOMATION_FRAME = 44
    INTERFACE_BACK = 45
    INTERFACE_BOTTOM_CENTER = 46
    INTERFACE_BOTTOM_LEFT = 47
    INTERFACE_BOTTOM_RIGHT = 48
    INTERFACE_BTN_CIVICS = 49
    INTERFACE_BTN_DEMOGRAPHICS = 50
    INTERFACE_BTN_DOMESTIC = 51
    INTERFACE_BTN_EVENT_LOG = 52
    INTERFACE_BTN_FINANCE = 53
    INTERFACE_BTN_FOREIGN = 54
    INTERFACE_BTN_MILITARY = 55
    INTERFACE_BTN_RELIGIOUS = 56
    INTERFACE_BTN_TECH = 57
    INTERFACE_BTN_VICTORY = 58
    INTERFACE_BUTTONS_16 = 59
    INTERFACE_BUTTONS_24 = 60
    INTERFACE_BUTTONS_32 = 61
    INTERFACE_BUTTONS_46 = 62
    INTERFACE_BUTTONS_CANCEL = 63
    INTERFACE_BUTTONS_CITYSELECTION = 64
    INTERFACE_BUTTONS_CONSCRIPT = 65
    INTERFACE_BUTTONS_CREATEGROUP = 66
    INTERFACE_BUTTONS_EMPTY = 67
    INTERFACE_BUTTONS_EMPTYBROWN = 68
    INTERFACE_BUTTONS_GOVERNOR = 69
    INTERFACE_BUTTONS_GOVERNOR_PRODUCTION = 70
    INTERFACE_BUTTONS_LEFT = 71
    INTERFACE_BUTTONS_MINUS = 72
    INTERFACE_BUTTONS_NOPRODUCTION = 73
    INTERFACE_BUTTONS_PLUS = 74
    INTERFACE_BUTTONS_RED_X = 75
    INTERFACE_BUTTONS_CHECK = 76
    INTERFACE_BUTTONS_RIGHT = 77
    INTERFACE_BUTTONS_SPLITGROUP = 78
    INTERFACE_CITY_BAR_CAPITAL_GLOW = 79
    INTERFACE_CITY_BAR_CAPITAL_TEXTURE = 80
    INTERFACE_CITY_BAR_MODEL = 81
    INTERFACE_CITY_BAR_PRODUCTION_ICON_BEVEL = 82
    INTERFACE_CITY_BAR_PRODUCTION_ICON_MASK = 83
    INTERFACE_CITY_BAR_REGULAR_GLOW = 84
    INTERFACE_CITY_BAR_REGULAR_TEXTURE = 85
    INTERFACE_CITY_PANEL = 86
    INTERFACE_STRATEGY_BAR_MODEL = 87
    INTERFACE_EMPTY = 88
    INTERFACE_GAMEDATABACK = 89
    INTERFACE_GENERAL_CIVICS = 90
    INTERFACE_GENERAL_CONVERTRELIGION = 91
    INTERFACE_GENERAL_DOWNARROW = 92
    INTERFACE_GENERAL_ENDTURN_GREENON = 93
    INTERFACE_GENERAL_ENDTURN_REDOFF = 94
    INTERFACE_GENERAL_ENDTURN_REDON = 95
    INTERFACE_GENERAL_QUESTIONMARK = 96
    INTERFACE_GENERAL_CIVILOPEDIA_ICON = 97
    INTERFACE_GENERAL_MENU_ICON = 98
    INTERFACE_GENERAL_TOGGLEYIELDS = 99
    INTERFACE_GENERAL_UPARROW = 100
    INTERFACE_HEADING_BACKGROUND = 101
    INTERFACE_HOLYCITY_OVERLAY = 102
    INTERFACE_ICON_ACTION = 103
    INTERFACE_ICON_COMBAT = 104
    INTERFACE_ICON_INFO = 105
    INTERFACE_ICON_WARNING = 106
    INTERFACE_ITEM_BACKGROUND = 107
    INTERFACE_MAIN = 108
    INTERFACE_MINIMAP_BARE = 109
    INTERFACE_MINIMAP_GLOBEVIEW = 110
    INTERFACE_MINIMAP_GRID = 111
    INTERFACE_MINIMAP_PING = 112
    INTERFACE_HAPPY_PERSON = 113
    INTERFACE_RESISTANCE = 114
    INTERFACE_UNHEALTHY_PERSON = 115
    INTERFACE_MINIMAP_RESOURCE = 116
    INTERFACE_MINIMAP_YIELDS = 117
    INTERFACE_MINIMAPCURSOR = 118
    INTERFACE_ORNAMENT_LEFT_HIGH = 119
    INTERFACE_ORNAMENT_LEFT_LOW = 120
    INTERFACE_ORNAMENT_RIGHT_HIGH = 121
    INTERFACE_ORNAMENT_RIGHT_LOW = 122
    INTERFACE_PLOTPICKER_ARROW = 123
    INTERFACE_PLOTPICKER_BASE = 124
    INTERFACE_PLOTPICKER_BORDER_BEVEL32 = 125
    INTERFACE_PLOTPICKER_OVERLAY = 126
    INTERFACE_PLOTPICKER_ALPHAOVERLAY = 127
    INTERFACE_PLOTPICKER_BORDER_BEVEL64 = 128
    INTERFACE_PLOTPICKER_BORDER_MASK32 = 129
    INTERFACE_PLOTPICKER_BORDER_MASK64 = 130
    INTERFACE_SELECTED = 131
    INTERFACE_TECH_BRIDGEBUILDING = 132
    INTERFACE_TECH_CULTURE = 133
    INTERFACE_TECH_ESPIONAGE = 134
    INTERFACE_TECH_DEFENSIVEPACT = 135
    INTERFACE_TECH_FREETECH = 136
    INTERFACE_TECH_GOLDTRADING = 137
    INTERFACE_TECH_HAPPINESS = 138
    INTERFACE_TECH_HEALTH = 139
    INTERFACE_TECH_IRRIGATION = 140
    INTERFACE_TECH_LOS = 141
    INTERFACE_TECH_MAPCENTER = 142
    INTERFACE_TECH_MAPREVEAL = 143
    INTERFACE_TECH_MAPTRADING = 144
    INTERFACE_TECH_MOVE_BONUS = 145
    INTERFACE_TECH_NOIRRIGATION = 146
    INTERFACE_TECH_OPENBORDERS = 147
    INTERFACE_TECH_PERMALLIANCE = 148
    INTERFACE_TECH_VASSAL = 149
    INTERFACE_TECH_TECHTRADING = 150
    INTERFACE_TECH_TRADE_ROUTES = 151
    INTERFACE_TECH_WATERMOVES = 152
    INTERFACE_TECH_WATERTRADE = 153
    INTERFACE_TECH_RIVERTRADE = 154
    INTERFACE_TECH_WATERWORK = 155
    INTERFACE_TECH_FEATURE_PRODUCTION = 156
    INTERFACE_TECH_WORKER_SPEED = 157
    INTERFACE_TOP = 158
    INTERFACE_TOP_BAR = 159
    INTERFACE_TOP_CITY = 160
    INTERFACE_TOP_LEFT = 161
    INTERFACE_TOP_RIGHT = 162
    LEADERHEAD_HIGHLIGHT = 163
    LEADERHEAD_UNKNOWN = 164
    LIGHTING_MECHLIGHT = 165
    LIGHTING_SUNLIGHT = 166
    LIGHTING_TERRAINLIGHT = 167
    LIGHTING_UNITS = 168
    MAINMENU_AGREE = 169
    MAINMENU_BTN_ADVANCED = 170
    MAINMENU_BTN_CREATE = 171
    MAINMENU_BTN_GAMESPY = 172
    MAINMENU_BTN_LAN = 173
    MAINMENU_BTN_REFRESH = 174
    MAINMENU_CANCEL = 175
    MAINMENU_CHANGEPASSWORD = 176
    MAINMENU_CREATEACCOUNT = 177
    MAINMENU_EXIT = 178
    MAINMENU_LOAD = 179
    MAINMENU_SLIDESHOW_LOAD = 180
    MAINMENU_LOAD_WARLORDS = 181
    MAINMENU_SLIDESHOW_LOAD_WARLORDS = 182
    MAINMENU_LOAD_BTS = 183
    MAINMENU_SLIDESHOW_LOAD_CLASSICAL = 184
    MAINMENU_LOAD_CLASSICAL = 185
    MAINMENU_SLIDESHOW_LOAD_BTS = 186
    INTRO_LOGOS = 187
    MAINMENU_LOADGAME = 188
    MAINMENU_LOGIN = 189
    MAINMENU_MP = 190
    MAINMENU_MP_HOST = 191
    MAINMENU_MP_JOIN = 192
    MAINMENU_NEWGAME = 193
    MAINMENU_PLAY = 194
    MAINMENU_REPLAY = 195
    MAINMENU_SCENE = 196
    MAINMENU_SCENE_CLASSICAL = 197
    MAINMENU_SCENE_NO_SHADER = 198
    MAINMENU_SCENE_WARLORDS = 199
    MAINMENU_SCENE_VANILLA = 200
    MAINMENU_SP = 201
    MAINMENU_STARTGAME = 202
    OVERLAY_FORTIFY = 203
    OVERLAY_HASMOVED = 204
    OVERLAY_MOVE = 205
    OVERLAY_NOMOVE = 206
    POPUP_MINIMIZE = 207
    POPUPS_BACKGROUND = 208
    POPUPS_BACKGROUND_DDS = 209
    POPUPS_BACKGROUND_TRANSPARENT = 210
    POPUPS_CHECKBOX_16 = 211
    POPUPS_CHECKBOX_24 = 212
    POPUPS_CHECKBOX_32 = 213
    POPUPS_CHECKBOXTOGGLE = 214
    POPUPS_EDITBOX = 215
    POPUPS_EDITBOX_875 = 216
    POPUPS_EDITBOX_CARET = 217
    POPUPS_EDITBOX_DDS = 218
    POPUPS_LIGHTS = 219
    POPUPS_OKBUTTON = 220
    POPUPS_RADIOBUTTON = 221
    PROGRESS_BAR = 222
    REWARD_BG = 223
    REWARD_EXIT = 224
    SCREEN_BG = 225
    TECH_HIGHLIGHT = 226
    SCREEN_BG_OPAQUE = 227
    SHADOW_UNITS = 228
    SPACESHIP_PROGRESS_BG = 229
    TECH_ARROWS_BROKEN_IN = 230
    TECH_ARROWS_BROKEN_OUT = 231
    TECH_BG = 232
    TECH_PANEL_BLUE = 233
    TECH_PANEL_CYAN = 234
    TECH_PANEL_GREEN = 235
    TECH_PANEL_HILITE = 236
    TECH_PANEL_RED = 237
    TECH_SPLASH = 238
    TECH_SPLASH_EXIT = 239
    TECH_TREE_BUTTON_BORDER = 240
    TEMP_BG = 241
    VOTING_BACKGROUND = 242
    WIDGET_DROPDOWN_ARROWBUTTON = 243
    WIDGET_DROPDOWN_ARROWBUTTON_SM = 244
    WIDGET_DROPDOWN_BG_SM = 245
    WIDGET_DROPDOWN_DOWN_SM = 246
    WIDGET_DROPDOWN_LOWERLISTBOX = 247
    WIDGET_DROPDOWN_LOWERLISTBOX350 = 248
    WIDGET_DROPDOWN_LOWERLISTBOX_SM = 249
    WIDGET_DROPDOWN_LOWERLISTBOXBIG = 250
    WIDGET_DROPDOWN_LOWERLISTBOXBIG350 = 251
    WIDGET_DROPDOWN_THUMB_SM = 252
    WIDGET_DROPDOWN_UP_SM = 253
    WIDGET_DROPDOWN_UPPERLISTBOX = 254
    WIDGET_DROPDOWN_UPPERLISTBOX_SM = 255
    WIDGET_EMPTY = 256
    WIDGET_LISTBOX_CHATLISTBOX = 257
    WIDGET_LISTBOX_STRINGBOX = 258
    WIDGET_LISTCONTROL_TAB = 259
    WIDGET_LISTCONTROL_TABBOX = 260
    WIDGET_LISTCONTROL_TABBOX_HIGHLIGHTED = 261
    WIDGET_SCROLLBAR_DOWN_CTR = 262
    WIDGET_SCROLLBAR_LEFT = 263
    WIDGET_SCROLLBAR_RIGHT = 264
    WIDGET_SCROLLBAR_THUMB_HORZ = 265
    WIDGET_SCROLLBAR_THUMB_VERT = 266
    WIDGET_SCROLLBAR_TILE_HORIZ = 267
    WIDGET_SCROLLBAR_TILE_VERT = 268
    WIDGET_SCROLLBAR_UP_CTR = 269
    WORLDBUILDER_CITY_EDIT = 270
    WORLDBUILDER_PLOT_TYPE_MOUNTAIN = 271
    WORLDBUILDER_PLOT_TYPE_HILL = 272
    WORLDBUILDER_PLOT_TYPE_PLAINS = 273
    WORLDBUILDER_PLOT_TYPE_OCEAN = 274
    WORLDBUILDER_RIVER_PLACEMENT = 275
    WORLDBUILDER_EDITBACKGROUND = 276
    WORLDBUILDER_LOAD = 277
    WORLDBUILDER_MOUNTAIN_SMALL = 278
    WORLDBUILDER_NORMAL_TAB_MODE = 279
    WORLDBUILDER_SAVE = 280
    WORLDBUILDER_EXIT = 281
    WORLDBUILDER_ERASE = 282
    WORLDBUILDER_CHANGE_ALL_PLOTS = 283
    WORLDBUILDER_LANDMARK_MODE = 284
    WORLDBUILDER_TERRAINMASK_LARGE = 285
    WORLDBUILDER_TERRAINMASK_MEDIUM = 286
    WORLDBUILDER_TERRAINMASK_SMALL = 287
    WORLDBUILDER_UNIT_EDIT = 288
    WORLDBUILDER_NORMAL_MAP_MODE = 289
    WORLDBUILDER_NORMAL_UNIT_MODE = 290
    WORLDBUILDER_TOGGLE_CITY_EDIT_MODE = 291
    WORLDBUILDER_TOGGLE_UNIT_EDIT_MODE = 292
    WORLDBUILDER_REVEAL_TILE_MODE = 293
    WORLDBUILDER_REVEAL_ALL_TILES = 294
    WORLDBUILDER_UNREVEAL_ALL_TILES = 295
    WORLDBUILDER_DIPLOMACY_MODE = 296
    INTERFACE_GLOBE_TOGGLE = 297
    INTERFACE_GLOBE_TOGGLE_HILIGHT = 298
    INTERFACE_GLOBELAYER_BUTTON_HILIGHT = 299
    INTERFACE_GLOBELAYER_RESOURCES = 300
    INTERFACE_GLOBELAYER_CULTURE = 301
    INTERFACE_GLOBELAYER_TRADE = 302
    INTERFACE_GLOBELAYER_UNITS = 303
    INTERFACE_GLOBELAYER_RELIGION = 304
    INTERFACE_GLOBELAYER_PLOTDEBUG = 305
    INTERFACE_GLOBELAYER_STRATEGY = 306
    INTERFACE_TUTORIAL_HIGHLIGHT = 307
    INTERFACE_TUTORIAL_HIGHLIGHT_LARGE = 308
    SCREEN_UN_BG = 309
    SCROLL_UP_ARROW = 310
    SCROLL_DOWN_ARROW = 311
    WHITE_CIRCLE_20 = 312
    WHITE_CIRCLE_40 = 313
    WHITE_CIRCLE_50 = 314
    ESPIONAGE_BUTTON = 315
    CULTURE_BUTTON = 316
    INTERFACE_STARS = 317
    INTERFACE_BLACK = 318
    INTERFACE_EVENT_BULLET = 319
    INTERFACE_EVENT_UNAVAILABLE_BULLET = 320
    INTERFACE_AUTOMATE = 321


class ArtDefinesLeaderheadType(IntEnum):  # noqa: D101
    NO_ART_DEFINES_LEADERHEAD = -1
    ART_DEF_LEADER_BARBARIAN = 0
    ART_DEF_LEADER_ALEXANDER = 1
    ART_DEF_LEADER_ASOKA = 2
    ART_DEF_LEADER_BISMARCK = 3
    ART_DEF_LEADER_CATHERINE = 4
    ART_DEF_LEADER_CYRUS = 5
    ART_DEF_LEADER_ELIZABETH = 6
    ART_DEF_LEADER_FRANKLIN_ROOSEVELT = 7
    ART_DEF_LEADER_FREDERICK = 8
    ART_DEF_LEADER_GANDHI = 9
    ART_DEF_LEADER_GENGHIS_KHAN = 10
    ART_DEF_LEADER_HATSHEPSUT = 11
    ART_DEF_LEADER_HUAYNA_CAPAC = 12
    ART_DEF_LEADER_ISABELLA = 13
    ART_DEF_LEADER_JULIUS_CAESAR = 14
    ART_DEF_LEADER_KUBLAI_KHAN = 15
    ART_DEF_LEADER_LOUIS_XIV = 16
    ART_DEF_LEADER_MANSA_MUSA = 17
    ART_DEF_LEADER_CHINESE_LEADER = 18
    ART_DEF_LEADER_MONTEZUMA = 19
    ART_DEF_LEADER_NAPOLEON = 20
    ART_DEF_LEADER_PETER = 21
    ART_DEF_LEADER_QIN_SHI_HUANG = 22
    ART_DEF_LEADER_SALADIN = 23
    ART_DEF_LEADER_TOKUGAWA = 24
    ART_DEF_LEADER_VICTORIA = 25
    ART_DEF_LEADER_WASHINGTON = 26
    ART_DEF_LEADER_CHURCHILL = 27
    ART_DEF_LEADER_AUGUSTUS = 28
    ART_DEF_LEADER_STALIN = 29
    ART_DEF_LEADER_SHAKA = 30
    ART_DEF_LEADER_BRENNUS = 31
    ART_DEF_LEADER_HANNIBAL = 32
    ART_DEF_LEADER_RAMESSES = 33
    ART_DEF_LEADER_RAGNAR = 34
    ART_DEF_LEADER_WANGKON = 35
    ART_DEF_LEADER_MEHMED = 36
    ART_DEF_LEADER_LINCOLN = 37
    ART_DEF_LEADER_CHARLEMAGNE = 38
    ART_DEF_LEADER_DE_GAULLE = 39
    ART_DEF_LEADER_DARIUS = 40
    ART_DEF_LEADER_GILGAMESH = 41
    ART_DEF_LEADER_HAMMURABI = 42
    ART_DEF_LEADER_JOAO = 43
    ART_DEF_LEADER_JUSTINIAN = 44
    ART_DEF_LEADER_PACAL = 45
    ART_DEF_LEADER_PERICLES = 46
    ART_DEF_LEADER_SITTING_BULL = 47
    ART_DEF_LEADER_SULEIMAN = 48
    ART_DEF_LEADER_SURYAVARMAN = 49
    ART_DEF_LEADER_BOUDICA = 50
    ART_DEF_LEADER_WILLEM_VAN_ORANJE = 51
    ART_DEF_LEADER_ZARA_YAQOB = 52


class ArtDefinesMiscType(IntEnum):  # noqa: D101
    NO_ART_DEFINES_MISC = -1
    ART_GREAT_WALL_POST = 0
    ART_GREAT_WALL_SEGMENT = 1
    ART_GREAT_WALL_SHADOW_TEXTURE = 2
    ART_AQUEDUCT_ENDPIECE = 3
    ART_AQUEDUCT_SEGMENT = 4
    ART_AQUEDUCT_WELL = 5
    ART_DEFAULT_MAP_THUMBNAIL = 6
    ART_GLOBEVIEW_CLOUD_SHADOWS = 7
    ART_GLOBEVIEW_CLOUDS = 8
    ART_GLOBEVIEW_ICECAP_EAST = 9
    ART_GLOBEVIEW_ICECAP_NORTH = 10
    ART_GLOBEVIEW_ICECAP_SOUTH = 11
    ART_GLOBEVIEW_ICECAP_WEST = 12
    ART_GLOBEVIEW_NIGHTSKY = 13
    ART_GLOBEVIEW_WORLD_CAP = 14
    ART_HILL_DECAL = 15
    ART_MOTION_BLUR_ALPHA_TEXTURE = 16
    ART_PEAK_DECAL = 17
    ART_POST_MASK = 18
    ART_UNITGROUP_ABOVESELECTION = 19
    ART_UNITGROUP_COIN = 20
    ART_UNITGROUP_FLAG_ANCIENT = 21
    ART_UNITGROUP_FLAG_MEDIEVAL = 22
    ART_UNITGROUP_FLAG_MODERN = 23
    ART_UNITGROUP_FLAG_GLOW = 24
    ART_UNITGROUP_GROUNDSELECTION = 25
    ART_UNITGROUP_WAYPOINTSELECTION = 26
    ART_WALL_MASK = 27
    ART_WATER = 28
    GENERIC_BUILDING_DIR = 29
    PLOT_TEXTURE = 30
    AREA_BORDER_TEXTURE = 31
    RAILROAD_NORMAL_MAP_TEXTURE = 32
    RIVER_BASE_TEXTURE = 33
    RIVER_FLOOD_PLAIN_MASK_TEXTURE = 34
    RIVER_FLOOD_PLAIN_TEXTURE = 35
    RIVER_NORMAL_MAP_TEXTURE = 36
    RIVER_NORMAL_MAP_MED_TEXTURE = 37
    ROUTE_BRIDGE = 38
    RAILROAD_BRIDGE = 39
    ROUTE_DOCK = 40
    WAYPOINT_BEAM_TEXTURE = 41
    CITY_BILLBOARDS = 42
    SPACE_SHIP_BUTTON = 43
    REPLACE_LEADER_BACKGROUND = 44
    REPLACE_LEADER_FORGROUND = 45
    DEFAULT_THEME_NAME = 46
    SOUND_BLASTER_LOGO = 47


class ArtDefinesMovieType(IntEnum):  # noqa: D101
    NO_ART_DEFINES_MOVIE = -1
    ART_DEF_MOVIE_INTRO = 0
    ART_DEF_MOVIE_2K_INTRO = 1
    ART_DEF_MOVIE_NVIDIA_INTRO = 2
    ART_DEF_MOVIE_PLACEHOLDER = 3
    ART_DEF_MOVIE_ANGKOR_WAT = 4
    ART_DEF_MOVIE_BROADWAY = 5
    ART_DEF_MOVIE_CHICHEN_ITZA = 6
    ART_DEF_MOVIE_COLOSSUS = 7
    ART_DEF_MOVIE_EIFFEL_TOWER = 8
    ART_DEF_MOVIE_GREAT_LIBRARY = 9
    ART_DEF_MOVIE_GREAT_LIGHTHOUSE = 10
    ART_DEF_MOVIE_HAGIA_SOPHIA = 11
    ART_DEF_MOVIE_HANGING_GARDENS = 12
    ART_DEF_MOVIE_HOLLYWOOD = 13
    ART_DEF_MOVIE_INTERNET = 14
    ART_DEF_MOVIE_KREMLIN = 15
    ART_DEF_MOVIE_MANHATTAN_PROJECT = 16
    ART_DEF_MOVIE_NOTRE_DAME = 17
    ART_DEF_MOVIE_ORACLE = 18
    ART_DEF_MOVIE_PARTHENON = 19
    ART_DEF_MOVIE_PENTAGON = 20
    ART_DEF_MOVIE_PYRAMIDS = 21
    ART_DEF_MOVIE_ROCK_AND_ROLL = 22
    ART_DEF_MOVIE_SISTINE_CHAPEL = 23
    ART_DEF_MOVIE_SPACE_ELEVATOR = 24
    ART_DEF_MOVIE_SPIRAL_MINARET = 25
    ART_DEF_MOVIE_STATUE_OF_LIBERTY = 26
    ART_DEF_MOVIE_STONEHENGE = 27
    ART_DEF_MOVIE_TAJ_MAHAL = 28
    ART_DEF_MOVIE_THREE_GORGES_DAM = 29
    ART_DEF_MOVIE_UNITED_NATIONS = 30
    ART_DEF_MOVIE_VERSAILLES = 31
    ART_DEF_MOVIE_ARTEMIS = 32
    ART_DEF_MOVIE_GREAT_WALL = 33
    ART_DEF_MOVIE_UNIVERSITY_SANKORE = 34
    ART_DEF_MOVIE_VICTORY_CONQUEST = 35
    ART_DEF_MOVIE_VICTORY_DOMINATION = 36
    ART_DEF_MOVIE_VICTORY_SPACE_RACE = 37
    ART_DEF_MOVIE_VICTORY_CULTURAL = 38
    ART_DEF_MOVIE_SHRINE_JEWISH = 39
    ART_DEF_MOVIE_SHRINE_CHRISTIAN = 40
    ART_DEF_MOVIE_SHRINE_ISLAMIC = 41
    ART_DEF_MOVIE_SHRINE_HINDU = 42
    ART_DEF_MOVIE_SHRINE_BUDDHIST = 43
    ART_DEF_MOVIE_SHRINE_CONFUCIAN = 44
    ART_DEF_MOVIE_SHRINE_TAOIST = 45
    ART_DEF_MOVIE_APOSTOLIC_PALACE = 46
    ART_DEF_MOVIE_MAUSOLEUM_OF_MAUSSOLLOS = 47
    ART_DEF_MOVIE_STATUE_OF_ZEUS = 48
    ART_DEF_MOVIE_SHWEDAGON_PAYA = 49
    ART_DEF_MOVIE_CHRIST_THE_REDEEMER = 50


class ArtDefinesTerrainType(IntEnum):  # noqa: D101
    NO_ART_DEFINES_TERRAIN = -1
    ART_DEF_TERRAIN_GRASS = 0
    ART_DEF_TERRAIN_PLAINS = 1
    ART_DEF_TERRAIN_DESERT = 2
    ART_DEF_TERRAIN_TUNDRA = 3
    ART_DEF_TERRAIN_SNOW = 4
    ART_DEF_TERRAIN_COAST = 5
    ART_DEF_TERRAIN_OCEAN = 6
    ART_DEF_TERRAIN_PEAK = 7
    ART_DEF_TERRAIN_HILL = 8


class ArtDefinesUnitType(IntEnum):  # noqa: D101
    NO_ART_DEFINES_UNIT = -1
    ART_DEF_UNIT_LION = 0
    ART_DEF_UNIT_BEAR = 1
    ART_DEF_UNIT_PANTHER = 2
    ART_DEF_UNIT_WOLF = 3
    ART_DEF_UNIT_WORKER = 4
    ART_DEF_UNIT_WORKERMODERN = 5
    ART_DEF_UNIT_INDIAN_FAST_WORKER = 6
    ART_DEF_UNIT_SCOUT = 7
    ART_DEF_UNIT_EXPLORER = 8
    ART_DEF_UNIT_ANCIENT_SPY = 9
    ART_DEF_UNIT_SPY = 10
    ART_DEF_UNIT_JEWISH_MISSIONARY = 11
    ART_DEF_UNIT_CHRISTIAN_MISSIONARY = 12
    ART_DEF_UNIT_ISLAMIC_MISSIONARY = 13
    ART_DEF_UNIT_HINDU_MISSIONARY = 14
    ART_DEF_UNIT_BUDDHIST_MISSIONARY = 15
    ART_DEF_UNIT_CONFUCIAN_MISSIONARY = 16
    ART_DEF_UNIT_TAOIST_MISSIONARY = 17
    ART_DEF_UNIT_WARRIOR = 18
    ART_DEF_UNIT_INCAN_QUECHUA = 19
    ART_DEF_UNIT_SWORDSMAN = 20
    ART_DEF_UNIT_AZTEC_JAGUAR = 21
    ART_DEF_UNIT_ROME_PRAETORIAN = 22
    ART_DEF_UNIT_AXEMAN = 23
    ART_DEF_UNIT_SUMERIAN_VULTURE = 24
    ART_DEF_UNIT_NATIVE_AMERICA_DOG_SOLDIER = 25
    ART_DEF_UNIT_MACEMAN = 26
    ART_DEF_UNIT_JAPAN_SAMURAI = 27
    ART_DEF_UNIT_GREEK_PHALANX = 28
    ART_DEF_UNIT_SPEARMAN = 29
    ART_DEF_UNIT_MAYA_HOLKAN = 30
    ART_DEF_UNIT_PIKEMAN = 31
    ART_DEF_UNIT_HOLY_ROMAN_LANDSKNECHT = 32
    ART_DEF_UNIT_MUSKETMAN = 33
    ART_DEF_UNIT_FRENCH_MUSKETEER = 34
    ART_DEF_UNIT_ETHIOPIAN_OROMO_WARRIOR_ORANGE = 35
    ART_DEF_UNIT_ETHIOPIAN_OROMO_WARRIOR_BLUE = 36
    ART_DEF_UNIT_ETHIOPIAN_OROMO_WARRIOR_GREEN = 37
    ART_DEF_UNIT_RIFLEMAN = 38
    ART_DEF_UNIT_ENGLISH_REDCOAT = 39
    ART_DEF_UNIT_GRENADIER = 40
    ART_DEF_UNIT_AT_INFANTRY = 41
    ART_DEF_UNIT_INFANTRY = 42
    ART_DEF_UNIT_SAM_INFANTRY = 43
    ART_DEF_UNIT_MARINE = 44
    ART_DEF_UNIT_AMERICAN_NAVY_SEAL = 45
    ART_DEF_UNIT_PARATROOPER = 46
    ART_DEF_UNIT_MECHANIZED_INFANTRY = 47
    ART_DEF_UNIT_ARCHER = 48
    ART_DEF_UNIT_MALI_SKIRMISHER = 49
    ART_DEF_UNIT_BABYLON_BOWMAN = 50
    ART_DEF_UNIT_LONGBOWMAN = 51
    ART_DEF_UNIT_CROSSBOWMAN = 52
    ART_DEF_UNIT_CHINA_CHOKONU = 53
    ART_DEF_UNIT_CHARIOT = 54
    ART_DEF_UNIT_EGYPT_WARCHARIOT = 55
    ART_DEF_UNIT_PERSIA_IMMORTAL = 56
    ART_DEF_UNIT_HORSE_ARCHER = 57
    ART_DEF_UNIT_MONGOL_KESHIK = 58
    ART_DEF_UNIT_KNIGHT = 59
    ART_DEF_UNIT_BYZANTINE_CATAPHRACT = 60
    ART_DEF_UNIT_ARABIA_CAMELARCHER = 61
    ART_DEF_UNIT_SPANISH_CONQUISTADOR = 62
    ART_DEF_UNIT_CUIRASSIER = 63
    ART_DEF_UNIT_CAVALRY = 64
    ART_DEF_UNIT_RUSSIA_COSSACK = 65
    ART_DEF_UNIT_WAR_ELEPHANT = 66
    ART_DEF_UNIT_KHMER_BALLISTA_ELEPHANT = 67
    ART_DEF_UNIT_TANK = 68
    ART_DEF_UNIT_GERMAN_PANZER = 69
    ART_DEF_UNIT_MODERN_ARMOR = 70
    ART_DEF_UNIT_GUNSHIP = 71
    ART_DEF_UNIT_CATAPULT = 72
    ART_DEF_UNIT_CANNON = 73
    ART_DEF_UNIT_MACHINE_GUN = 74
    ART_DEF_UNIT_ARTILLERY = 75
    ART_DEF_UNIT_WORKBOAT = 76
    ART_DEF_UNIT_WORKBOAT_MODERN = 77
    ART_DEF_UNIT_GALLEY = 78
    ART_DEF_UNIT_CARAVEL = 79
    ART_DEF_UNIT_PORTUGAL_CARRACK = 80
    ART_DEF_UNIT_GALLEON = 81
    ART_DEF_UNIT_NETHERLANDS_OOSTINDIEVAARDER = 82
    ART_DEF_UNIT_PRIVATEER = 83
    ART_DEF_UNIT_FRIGATE = 84
    ART_DEF_UNIT_SHIP_OF_THE_LINE = 85
    ART_DEF_UNIT_IRONCLAD = 86
    ART_DEF_UNIT_TRANSPORT = 87
    ART_DEF_UNIT_DESTROYER = 88
    ART_DEF_UNIT_STEALTH_DESTROYER = 89
    ART_DEF_UNIT_BATTLESHIP = 90
    ART_DEF_UNIT_SUBMARINE = 91
    ART_DEF_UNIT_ATTACK_SUBMARINE = 92
    ART_DEF_UNIT_CARRIER = 93
    ART_DEF_UNIT_AIRSHIP = 94
    ART_DEF_UNIT_FIGHTER = 95
    ART_DEF_UNIT_JET_FIGHTER = 96
    ART_DEF_UNIT_BOMBER = 97
    ART_DEF_UNIT_STEALTH_BOMBER = 98
    ART_DEF_UNIT_GUIDED_MISSILE = 99
    ART_DEF_UNIT_TACTICAL_NUKE = 100
    ART_DEF_UNIT_ICBM = 101
    ART_DEF_UNIT_PROPHET = 102
    ART_DEF_UNIT_ARTIST = 103
    ART_DEF_UNIT_ARTIST_MODERN = 104
    ART_DEF_UNIT_SCIENTIST = 105
    ART_DEF_UNIT_SCIENTIST_MODERN = 106
    ART_DEF_UNIT_MERCHANT = 107
    ART_DEF_UNIT_MERCHANT_MODERN = 108
    ART_DEF_UNIT_CEO_1 = 109
    ART_DEF_UNIT_CEO_2 = 110
    ART_DEF_UNIT_CEO_3 = 111
    ART_DEF_UNIT_CEO_4 = 112
    ART_DEF_UNIT_CEO_5 = 113
    ART_DEF_UNIT_CEO_6 = 114
    ART_DEF_UNIT_CEO_7 = 115
    ART_DEF_UNIT_ENGINEER = 116
    ART_DEF_UNIT_ENGINEER_MODERN = 117
    ART_DEF_UNIT_ANCIENT_GREAT_SPY = 118
    ART_DEF_UNIT_GREAT_SPY = 119
    ART_DEF_UNIT_SETTLER_MALE = 120
    ART_DEF_UNIT_SETTLER_FEMALE = 121
    ART_DEF_UNIT_SETTLER_CHILD = 122
    ART_DEF_UNIT_WARLORD_ANCIENT = 123
    ART_DEF_UNIT_WARLORD_MEDIEVAL = 124
    ART_DEF_UNIT_WARLORD_MODERN = 125
    ART_DEF_UNIT_ZULU_SPEARMAN = 126
    ART_DEF_UNIT_CELTIC_BARBARIAN = 127
    ART_DEF_UNIT_VIKING_BESERKER = 128
    ART_DEF_UNIT_CARTHAGE_NUMIDIAN_CAVALRY = 129
    ART_DEF_UNIT_OTTOMAN_JANISSARY = 130
    ART_DEF_UNIT_TREBUCHET = 131
    ART_DEF_UNIT_KOREAN_HWACHA = 132
    ART_DEF_UNIT_TRIREME = 133
    ART_DEF_UNIT_SIEGE_TOWER = 134
    ART_DEF_UNIT_MOBILE_ARTILLERY = 135
    ART_DEF_UNIT_MOBILE_SAM = 136
    ART_DEF_UNIT_MISSILE_CRUISER = 137
    ART_DEF_UNIT_ARCHER_EGYPTIAN = 138
    ART_DEF_UNIT_AXEMAN_EGYPTIAN = 139
    ART_DEF_UNIT_HORSE_ARCHER_EGYPTIAN = 140
    ART_DEF_UNIT_ARCHER_CHINESE = 141
    ART_DEF_UNIT_SPEARMAN_CHINESE = 142
    ART_DEF_UNIT_SWORDSMAN_CHINESE = 143
    ART_DEF_UNIT_CHARIOT_CHINESE = 144
    ART_DEF_UNIT_MONGOL_MOUNTED_SWORDSMAN = 145
    ART_DEF_UNIT_ASIAN_WAR_GALLEY = 146
    ART_DEF_UNIT_ARCHER_EURASIAN = 147
    ART_DEF_UNIT_SPEARMAN_EURASIAN = 148
    ART_DEF_UNIT_HORSEMAN_EURASIAN = 149
    ART_DEF_UNIT_CHARIOT_CELTIC = 150
    ART_DEF_UNIT_PRODOMOI = 151
    ART_DEF_UNIT_PELTAST = 152
    ART_DEF_UNIT_HORSE_ARCHER_ROMAN = 153
    ART_DEF_UNIT_CARTHAGE_WAR_ELEPHANT = 154
    ART_DEF_UNIT_ARCHER_ASIAN = 155
    ART_DEF_UNIT_AXEMAN_ASIAN = 156
    ART_DEF_UNIT_CROSSBOWMAN_ASIAN = 157
    ART_DEF_UNIT_KNIGHT_ASIAN = 158
    ART_DEF_UNIT_MACEMAN_ASIAN = 159
    ART_DEF_UNIT_PIKEMAN_ASIAN = 160
    ART_DEF_UNIT_SCOUT_ASIAN = 161
    ART_DEF_UNIT_SETTLER_CHILD_ASIAN = 162
    ART_DEF_UNIT_SETTLER_ELDER_ASIAN = 163
    ART_DEF_UNIT_SETTLER_FEMALE_ASIAN = 164
    ART_DEF_UNIT_WAR_ELEPHANT_ASIAN = 165
    ART_DEF_UNIT_WARRIOR_ASIAN = 166
    ART_DEF_UNIT_WORKER_ASIAN = 167
    ART_DEF_UNIT_ARCHER_EUROPEAN = 168
    ART_DEF_UNIT_AXEMAN_EUROPEAN = 169
    ART_DEF_UNIT_CHARIOT_EUROPEAN = 170
    ART_DEF_UNIT_HORSE_ARCHER_EUROPEAN = 171
    ART_DEF_UNIT_KNIGHT_EUROPEAN = 172
    ART_DEF_UNIT_MACEMAN_EUROPEAN = 173
    ART_DEF_UNIT_PIKEMAN_EUROPEAN = 174
    ART_DEF_UNIT_SCOUT_EUROPEAN = 175
    ART_DEF_UNIT_SETTLER_EUROPEAN = 176
    ART_DEF_UNIT_SETTLER_FEMALE_EUROPEAN = 177
    ART_DEF_UNIT_SETTLER_CHILD_EUROPEAN = 178
    ART_DEF_UNIT_SPEARMAN_EUROPEAN = 179
    ART_DEF_UNIT_SWORDSMAN_EUROPEAN = 180
    ART_DEF_UNIT_WAR_ELEPHANT_EUROPEAN = 181
    ART_DEF_UNIT_WORKER_EUROPEAN = 182
    ART_DEF_UNIT_CROSSBOWMAN_GRECO_ROMAN = 183
    ART_DEF_UNIT_LONGBOWMAN_GRECO_ROMAN = 184
    ART_DEF_UNIT_SCOUT_GRECO_ROMAN = 185
    ART_DEF_UNIT_SPEARMAN_GRECO_ROMAN = 186
    ART_DEF_UNIT_WAR_ELEPHANT_GRECO_ROMAN = 187
    ART_DEF_UNIT_WARRIOR_GRECO_ROMAN = 188
    ART_DEF_UNIT_ARCHER_MIDDLE_EAST = 189
    ART_DEF_UNIT_AXEMAN_MIDDLE_EAST = 190
    ART_DEF_UNIT_CHARIOT_MIDDLE_EAST = 191
    ART_DEF_UNIT_CROSSBOWMAN_MIDDLE_EAST = 192
    ART_DEF_UNIT_HORSE_ARCHER_MIDDLE_EAST = 193
    ART_DEF_UNIT_LONGBOWMAN_MIDDLE_EAST = 194
    ART_DEF_UNIT_KNIGHT_MIDDLE_EAST = 195
    ART_DEF_UNIT_MACEMAN_MIDDLE_EAST = 196
    ART_DEF_UNIT_PIKEMAN_MIDDLE_EAST = 197
    ART_DEF_UNIT_SCOUT_MIDDLE_EAST = 198
    ART_DEF_UNIT_SETTLER_CHILD_MIDDLE_EAST = 199
    ART_DEF_UNIT_SETTLER_FEMALE_MIDDLE_EAST = 200
    ART_DEF_UNIT_SETTLER_MIDDLE_EAST = 201
    ART_DEF_UNIT_SPEARMAN_MIDDLE_EAST = 202
    ART_DEF_UNIT_SWORDSMAN_MIDDLE_EAST = 203
    ART_DEF_UNIT_WAR_ELEPHANT_MIDDLE_EAST = 204
    ART_DEF_UNIT_WARRIOR_MIDDLE_EAST = 205
    ART_DEF_UNIT_WORKER_MIDDLE_EAST = 206
    ART_DEF_UNIT_ARCHER_SOUTH_AMERICA = 207
    ART_DEF_UNIT_AXEMAN_SOUTH_AMERICA = 208
    ART_DEF_UNIT_CHARIOT_SOUTH_AMERICA = 209
    ART_DEF_UNIT_CROSSBOWMAN_SOUTH_AMERICA = 210
    ART_DEF_UNIT_HORSE_ARCHER_SOUTH_AMERICA = 211
    ART_DEF_UNIT_KNIGHT_SOUTH_AMERICA = 212
    ART_DEF_UNIT_LONGBOWMAN_SOUTH_AMERICA = 213
    ART_DEF_UNIT_MACEMAN_SOUTH_AMERICA = 214
    ART_DEF_UNIT_PIKEMAN_SOUTH_AMERICA = 215
    ART_DEF_UNIT_SETTLER_CHILD_SOUTH_AMERICA = 216
    ART_DEF_UNIT_SETTLER_SOUTH_AMERICA = 217
    ART_DEF_UNIT_SETTLER_FEMALE_SOUTH_AMERICA = 218
    ART_DEF_UNIT_SPEARMAN_SOUTH_AMERICA = 219
    ART_DEF_UNIT_SWORDSMAN_SOUTH_AMERICA = 220
    ART_DEF_UNIT_WAR_ELEPHANT_SOUTH_AMERICA = 221
    ART_DEF_UNIT_WARRIOR_SOUTH_AMERICA = 222
    ART_DEF_UNIT_WORKER_SOUTH_AMERICA = 223


class MainMenusType(IntEnum):  # noqa: D101
    NO_MAIN_MENUS = -1
    MAIN_MENU_CLASSICAL = 0
    MAIN_MENU_VANILLA = 1
    MAIN_MENU_WARLORDS = 2
    MAIN_MENU_BEYOND_SWORD = 3


class AttitudeType(IntEnum):  # noqa: D101
    NO_ATTITUDE = -1
    ATTITUDE_FURIOUS = 0
    ATTITUDE_ANNOYED = 1
    ATTITUDE_CAUTIOUS = 2
    ATTITUDE_PLEASED = 3
    ATTITUDE_FRIENDLY = 4


class BasicType(IntEnum):  # noqa: D101
    NO_BASIC = -1
    CONCEPT_ANIMALS = 0
    CONCEPT_AIR_UNITS = 1
    CONCEPT_BARBARIANS = 2
    CONCEPT_BORDERS = 3
    CONCEPT_BUILDINGS = 4
    CONCEPT_CITIES = 5
    CONCEPT_CITY_NETWORK = 6
    CONCEPT_CIVICS = 7
    CONCEPT_COMBAT = 8
    CONCEPT_COMMERCE = 9
    CONCEPT_CULTURE = 10
    CONCEPT_DIPLOMACY = 11
    CONCEPT_DRAFT = 12
    CONCEPT_EXPLORATION = 13
    CONCEPT_FOOD = 14
    CONCEPT_GOLDEN_AGE = 15
    CONCEPT_GREAT_PEOPLE = 16
    CONCEPT_HAPPINESS = 17
    CONCEPT_HEALTH = 18
    CONCEPT_HURRY_PRODUCTION = 19
    CONCEPT_IMPROVEMENTS = 20
    CONCEPT_LEADERS = 21
    CONCEPT_MAINTENANCE = 22
    CONCEPT_MAPS = 23
    CONCEPT_MOVEMENT = 24
    CONCEPT_NUKES = 25
    CONCEPT_PRODUCTION = 26
    CONCEPT_PROMOTIONS = 27
    CONCEPT_RELIGION = 28
    CONCEPT_RESEARCH = 29
    CONCEPT_RESISTANCE = 30
    CONCEPT_RESOURCES = 31
    CONCEPT_REVOLUTION = 32
    CONCEPT_SPACESHIP = 33
    CONCEPT_SPECIALISTS = 34
    CONCEPT_TECHNOLOGY = 35
    CONCEPT_TERRAIN = 36
    CONCEPT_TRADE = 37
    CONCEPT_TRANSPORT = 38
    CONCEPT_TREASURY = 39
    CONCEPT_UNITS = 40
    CONCEPT_UNITED_NATIONS = 41
    CONCEPT_VICTORY = 42
    CONCEPT_WAR = 43
    CONCEPT_WAR_WEARINESS = 44
    CONCEPT_WEALTH = 45
    CONCEPT_WONDERS = 46
    CONCEPT_GREAT_GENERALS = 47
    CONCEPT_VASSAL_STATES = 48
    CONCEPT_IRRIGATION = 49


class CalendarType(IntEnum):  # noqa: D101
    NO_CALENDAR = -1
    CALENDAR_DEFAULT = 0
    CALENDAR_BI_YEARLY = 1
    CALENDAR_YEARS = 2
    CALENDAR_TURNS = 3
    CALENDAR_SEASONS = 4
    CALENDAR_MONTHS = 5
    CALENDAR_WEEKS = 6


class CityTabType(IntEnum):  # noqa: D101
    NO_CITY_TAB = -1
    CITYTAB_UNITS = 0
    CITYTAB_BUILDINGS = 1
    CITYTAB_WONDERS = 2


class DenialType(IntEnum):  # noqa: D101
    NO_DENIAL = -1
    DENIAL_UNKNOWN = 0
    DENIAL_NEVER = 1
    DENIAL_TOO_MUCH = 2
    DENIAL_MYSTERY = 3
    DENIAL_JOKING = 4
    DENIAL_ANGER_CIVIC = 5
    DENIAL_FAVORITE_CIVIC = 6
    DENIAL_MINORITY_RELIGION = 7
    DENIAL_CONTACT_THEM = 8
    DENIAL_VICTORY = 9
    DENIAL_ATTITUDE = 10
    DENIAL_ATTITUDE_THEM = 11
    DENIAL_TECH_WHORE = 12
    DENIAL_TECH_MONOPOLY = 13
    DENIAL_POWER_US = 14
    DENIAL_POWER_YOU = 15
    DENIAL_POWER_THEM = 16
    DENIAL_TOO_MANY_WARS = 17
    DENIAL_NO_GAIN = 18
    DENIAL_NOT_ALLIED = 19
    DENIAL_RECENT_CANCEL = 20
    DENIAL_WORST_ENEMY = 21
    DENIAL_POWER_YOUR_ENEMIES = 22
    DENIAL_TOO_FAR = 23
    DENIAL_VASSAL = 24
    DENIAL_WAR_NOT_POSSIBLE_US = 25
    DENIAL_WAR_NOT_POSSIBLE_YOU = 26
    DENIAL_PEACE_NOT_POSSIBLE_US = 27
    DENIAL_PEACE_NOT_POSSIBLE_YOU = 28


class DomainType(IntEnum):  # noqa: D101
    NO_DOMAIN = -1
    DOMAIN_SEA = 0
    DOMAIN_AIR = 1
    DOMAIN_LAND = 2
    DOMAIN_IMMOBILE = 3


class InvisibleType(IntEnum):  # noqa: D101
    NO_INVISIBLE = -1
    INVISIBLE_SUBMARINE = 0
    INVISIBLE_STEALTH = 1


class MemoryType(IntEnum):  # noqa: D101
    NO_MEMORY = -1
    MEMORY_DECLARED_WAR = 0
    MEMORY_DECLARED_WAR_ON_FRIEND = 1
    MEMORY_HIRED_WAR_ALLY = 2
    MEMORY_NUKED_US = 3
    MEMORY_NUKED_FRIEND = 4
    MEMORY_RAZED_CITY = 5
    MEMORY_RAZED_HOLY_CITY = 6
    MEMORY_SPY_CAUGHT = 7
    MEMORY_GIVE_HELP = 8
    MEMORY_REFUSED_HELP = 9
    MEMORY_ACCEPT_DEMAND = 10
    MEMORY_REJECTED_DEMAND = 11
    MEMORY_ACCEPTED_RELIGION = 12
    MEMORY_DENIED_RELIGION = 13
    MEMORY_ACCEPTED_CIVIC = 14
    MEMORY_DENIED_CIVIC = 15
    MEMORY_ACCEPTED_JOIN_WAR = 16
    MEMORY_DENIED_JOIN_WAR = 17
    MEMORY_ACCEPTED_STOP_TRADING = 18
    MEMORY_DENIED_STOP_TRADING = 19
    MEMORY_STOPPED_TRADING = 20
    MEMORY_STOPPED_TRADING_RECENT = 21
    MEMORY_HIRED_TRADE_EMBARGO = 22
    MEMORY_MADE_DEMAND = 23
    MEMORY_MADE_DEMAND_RECENT = 24
    MEMORY_CANCELLED_OPEN_BORDERS = 25
    MEMORY_TRADED_TECH_TO_US = 26
    MEMORY_RECEIVED_TECH_FROM_ANY = 27
    MEMORY_VOTED_AGAINST_US = 28
    MEMORY_VOTED_FOR_US = 29
    MEMORY_EVENT_GOOD_TO_US = 30
    MEMORY_EVENT_BAD_TO_US = 31
    MEMORY_LIBERATED_CITIES = 32


class MonthType(IntEnum):  # noqa: D101
    NO_MONTH = -1
    MONTH_JANUARY = 0
    MONTH_FEBRUARY = 1
    MONTH_MARCH = 2
    MONTH_APRIL = 3
    MONTH_MAY = 4
    MONTH_JUNE = 5
    MONTH_JULY = 6
    MONTH_AUGUST = 7
    MONTH_SEPTEMBER = 8
    MONTH_OCTOBER = 9
    MONTH_NOVEMBER = 10
    MONTH_DECEMBER = 11


class NewConceptType(IntEnum):  # noqa: D101
    NO_NEW_CONCEPT = -1
    CONCEPT_ESPIONAGE = 0
    CONCEPT_COLONIES = 1
    CONCEPT_CORPORATIONS = 2
    CONCEPT_SEA_TRADE = 3
    CONCEPT_FLANK_ATTACK = 4
    CONCEPT_GREAT_SPY = 5
    CONCEPT_LATE_START = 6
    CONCEPT_EVENTS = 7
    CONCEPT_AIR_COMBAT = 8
    CONCEPT_AIR_PROMOTIONS = 9
    CONCEPT_BTS_BUILDINGS = 10
    CONCEPT_BTS_CIVS = 11
    CONCEPT_BTS_UNITS = 12
    CONCEPT_BTS_LEADERS = 13
    CONCEPT_BTS_WONDERS = 14
    CONCEPT_BTS_TECHS = 15
    CONCEPT_BTS_RULES_CHANGES = 16
    CONCEPT_BTS_FOREST_PRESERVE = 17
    CONCEPT_APOSTOLIC_PALACE = 18
    CONCEPT_FORT = 19
    CONCEPT_LIBERATION = 20


class SeasonType(IntEnum):  # noqa: D101
    NO_SEASON = -1
    SEASON_WINTER = 0
    SEASON_SPRING = 1
    SEASON_SUMMER = 2
    SEASON_FALL = 3


class UnitAIType(IntEnum):  # noqa: D101
    NO_UNIT_A_I = -1
    UNITAI_UNKNOWN = 0
    UNITAI_ANIMAL = 1
    UNITAI_SETTLE = 2
    UNITAI_WORKER = 3
    UNITAI_ATTACK = 4
    UNITAI_ATTACK_CITY = 5
    UNITAI_COLLATERAL = 6
    UNITAI_PILLAGE = 7
    UNITAI_RESERVE = 8
    UNITAI_COUNTER = 9
    UNITAI_CITY_DEFENSE = 10
    UNITAI_CITY_COUNTER = 11
    UNITAI_CITY_SPECIAL = 12
    UNITAI_EXPLORE = 13
    UNITAI_MISSIONARY = 14
    UNITAI_PROPHET = 15
    UNITAI_ARTIST = 16
    UNITAI_SCIENTIST = 17
    UNITAI_GENERAL = 18
    UNITAI_MERCHANT = 19
    UNITAI_ENGINEER = 20
    UNITAI_SPY = 21
    UNITAI_ICBM = 22
    UNITAI_WORKER_SEA = 23
    UNITAI_ATTACK_SEA = 24
    UNITAI_RESERVE_SEA = 25
    UNITAI_ESCORT_SEA = 26
    UNITAI_EXPLORE_SEA = 27
    UNITAI_ASSAULT_SEA = 28
    UNITAI_SETTLER_SEA = 29
    UNITAI_MISSIONARY_SEA = 30
    UNITAI_SPY_SEA = 31
    UNITAI_CARRIER_SEA = 32
    UNITAI_MISSILE_CARRIER_SEA = 33
    UNITAI_PIRATE_SEA = 34
    UNITAI_ATTACK_AIR = 35
    UNITAI_DEFENSE_AIR = 36
    UNITAI_CARRIER_AIR = 37
    UNITAI_MISSILE_AIR = 38
    UNITAI_PARADROP = 39
    UNITAI_ATTACK_CITY_LEMMING = 40


class UnitCombatType(IntEnum):  # noqa: D101
    NO_UNIT_COMBAT = -1
    UNITCOMBAT_RECON = 0
    UNITCOMBAT_ARCHER = 1
    UNITCOMBAT_MOUNTED = 2
    UNITCOMBAT_MELEE = 3
    UNITCOMBAT_SIEGE = 4
    UNITCOMBAT_GUN = 5
    UNITCOMBAT_ARMOR = 6
    UNITCOMBAT_HELICOPTER = 7
    UNITCOMBAT_NAVAL = 8
    UNITCOMBAT_AIR = 9


class BuildingClassType(IntEnum):  # noqa: D101
    NO_BUILDING_CLASS = -1
    BUILDINGCLASS_PALACE = 0
    BUILDINGCLASS_GREAT_PALACE = 1
    BUILDINGCLASS_VERSAILLES = 2
    BUILDINGCLASS_WALLS = 3
    BUILDINGCLASS_CASTLE = 4
    BUILDINGCLASS_BARRACKS = 5
    BUILDINGCLASS_STABLE = 6
    BUILDINGCLASS_BUNKER = 7
    BUILDINGCLASS_BOMB_SHELTER = 8
    BUILDINGCLASS_GRANARY = 9
    BUILDINGCLASS_AQUEDUCT = 10
    BUILDINGCLASS_HOSPITAL = 11
    BUILDINGCLASS_RECYCLING_CENTER = 12
    BUILDINGCLASS_LIGHTHOUSE = 13
    BUILDINGCLASS_HARBOR = 14
    BUILDINGCLASS_CUSTOM_HOUSE = 15
    BUILDINGCLASS_DRYDOCK = 16
    BUILDINGCLASS_AIRPORT = 17
    BUILDINGCLASS_FORGE = 18
    BUILDINGCLASS_FACTORY = 19
    BUILDINGCLASS_COAL_PLANT = 20
    BUILDINGCLASS_HYDRO_PLANT = 21
    BUILDINGCLASS_NUCLEAR_PLANT = 22
    BUILDINGCLASS_INDUSTRIAL_PARK = 23
    BUILDINGCLASS_OBELISK = 24
    BUILDINGCLASS_PUBLIC_TRANSPORTATION = 25
    BUILDINGCLASS_ACADEMY = 26
    BUILDINGCLASS_LIBRARY = 27
    BUILDINGCLASS_UNIVERSITY = 28
    BUILDINGCLASS_OBSERVATORY = 29
    BUILDINGCLASS_LABORATORY = 30
    BUILDINGCLASS_THEATRE = 31
    BUILDINGCLASS_COLOSSEUM = 32
    BUILDINGCLASS_BROADCAST_TOWER = 33
    BUILDINGCLASS_MARKET = 34
    BUILDINGCLASS_GROCER = 35
    BUILDINGCLASS_BANK = 36
    BUILDINGCLASS_SUPERMARKET = 37
    BUILDINGCLASS_COURTHOUSE = 38
    BUILDINGCLASS_JAIL = 39
    BUILDINGCLASS_LEVEE = 40
    BUILDINGCLASS_INTELLIGENCE_AGENCY = 41
    BUILDINGCLASS_NATIONAL_SECURITY = 42
    BUILDINGCLASS_JEWISH_TEMPLE = 43
    BUILDINGCLASS_JEWISH_CATHEDRAL = 44
    BUILDINGCLASS_JEWISH_MONASTERY = 45
    BUILDINGCLASS_JEWISH_SHRINE = 46
    BUILDINGCLASS_CHRISTIAN_TEMPLE = 47
    BUILDINGCLASS_CHRISTIAN_CATHEDRAL = 48
    BUILDINGCLASS_CHRISTIAN_MONASTERY = 49
    BUILDINGCLASS_CHRISTIAN_SHRINE = 50
    BUILDINGCLASS_ISLAMIC_TEMPLE = 51
    BUILDINGCLASS_ISLAMIC_CATHEDRAL = 52
    BUILDINGCLASS_ISLAMIC_MONASTERY = 53
    BUILDINGCLASS_ISLAMIC_SHRINE = 54
    BUILDINGCLASS_HINDU_TEMPLE = 55
    BUILDINGCLASS_HINDU_CATHEDRAL = 56
    BUILDINGCLASS_HINDU_MONASTERY = 57
    BUILDINGCLASS_HINDU_SHRINE = 58
    BUILDINGCLASS_BUDDHIST_TEMPLE = 59
    BUILDINGCLASS_BUDDHIST_CATHEDRAL = 60
    BUILDINGCLASS_BUDDHIST_MONASTERY = 61
    BUILDINGCLASS_BUDDHIST_SHRINE = 62
    BUILDINGCLASS_CONFUCIAN_TEMPLE = 63
    BUILDINGCLASS_CONFUCIAN_CATHEDRAL = 64
    BUILDINGCLASS_CONFUCIAN_MONASTERY = 65
    BUILDINGCLASS_CONFUCIAN_SHRINE = 66
    BUILDINGCLASS_TAOIST_TEMPLE = 67
    BUILDINGCLASS_TAOIST_CATHEDRAL = 68
    BUILDINGCLASS_TAOIST_MONASTERY = 69
    BUILDINGCLASS_TAOIST_SHRINE = 70
    BUILDINGCLASS_HEROIC_EPIC = 71
    BUILDINGCLASS_NATIONAL_EPIC = 72
    BUILDINGCLASS_GLOBE_THEATRE = 73
    BUILDINGCLASS_NATIONAL_PARK = 74
    BUILDINGCLASS_HERMITAGE = 75
    BUILDINGCLASS_OXFORD_UNIVERSITY = 76
    BUILDINGCLASS_WALL_STREET = 77
    BUILDINGCLASS_IRON_WORKS = 78
    BUILDINGCLASS_WEST_POINT = 79
    BUILDINGCLASS_MT_RUSHMORE = 80
    BUILDINGCLASS_RED_CROSS = 81
    BUILDINGCLASS_SCOTLAND_YARD = 82
    BUILDINGCLASS_PYRAMID = 83
    BUILDINGCLASS_STONEHENGE = 84
    BUILDINGCLASS_GREAT_LIBRARY = 85
    BUILDINGCLASS_GREAT_LIGHTHOUSE = 86
    BUILDINGCLASS_HANGING_GARDEN = 87
    BUILDINGCLASS_COLOSSUS = 88
    BUILDINGCLASS_ORACLE = 89
    BUILDINGCLASS_PARTHENON = 90
    BUILDINGCLASS_ANGKOR_WAT = 91
    BUILDINGCLASS_HAGIA_SOPHIA = 92
    BUILDINGCLASS_CHICHEN_ITZA = 93
    BUILDINGCLASS_SISTINE_CHAPEL = 94
    BUILDINGCLASS_NOTRE_DAME = 95
    BUILDINGCLASS_SPIRAL_MINARET = 96
    BUILDINGCLASS_TAJ_MAHAL = 97
    BUILDINGCLASS_KREMLIN = 98
    BUILDINGCLASS_EIFFEL_TOWER = 99
    BUILDINGCLASS_STATUE_OF_LIBERTY = 100
    BUILDINGCLASS_BROADWAY = 101
    BUILDINGCLASS_ROCKNROLL = 102
    BUILDINGCLASS_HOLLYWOOD = 103
    BUILDINGCLASS_GREAT_DAM = 104
    BUILDINGCLASS_PENTAGON = 105
    BUILDINGCLASS_UNITED_NATIONS = 106
    BUILDINGCLASS_SPACE_ELEVATOR = 107
    BUILDINGCLASS_MILITARY_ACADEMY = 108
    BUILDINGCLASS_ARTEMIS = 109
    BUILDINGCLASS_SANKORE = 110
    BUILDINGCLASS_GREAT_WALL = 111
    BUILDINGCLASS_STATUE_OF_ZEUS = 112
    BUILDINGCLASS_MAUSOLEUM_OF_MAUSSOLLOS = 113
    BUILDINGCLASS_CRISTO_REDENTOR = 114
    BUILDINGCLASS_SHWEDAGON_PAYA = 115
    BUILDINGCLASS_MOAI_STATUES = 116
    BUILDINGCLASS_CORPORATION_1 = 117
    BUILDINGCLASS_CORPORATION_2 = 118
    BUILDINGCLASS_CORPORATION_3 = 119
    BUILDINGCLASS_CORPORATION_4 = 120
    BUILDINGCLASS_CORPORATION_5 = 121
    BUILDINGCLASS_CORPORATION_6 = 122
    BUILDINGCLASS_CORPORATION_7 = 123
    BUILDINGCLASS_APOSTOLIC_PALACE = 124


class BuildingType(IntEnum):  # noqa: D101
    NO_BUILDING = -1
    BUILDING_PALACE = 0
    BUILDING_GREAT_PALACE = 1
    BUILDING_VERSAILLES = 2
    BUILDING_WALLS = 3
    BUILDING_CELTIC_DUN = 4
    BUILDING_CASTLE = 5
    BUILDING_SPANISH_CITADEL = 6
    BUILDING_BARRACKS = 7
    BUILDING_ZULU_IKHANDA = 8
    BUILDING_STABLE = 9
    BUILDING_MONGOL_GER = 10
    BUILDING_BUNKER = 11
    BUILDING_BOMB_SHELTER = 12
    BUILDING_GRANARY = 13
    BUILDING_INCAN_TERRACE = 14
    BUILDING_AQUEDUCT = 15
    BUILDING_OTTOMAN_HAMMAM = 16
    BUILDING_KHMER_BARAY = 17
    BUILDING_HOSPITAL = 18
    BUILDING_RECYCLING_CENTER = 19
    BUILDING_LIGHTHOUSE = 20
    BUILDING_VIKING_TRADING_POST = 21
    BUILDING_HARBOR = 22
    BUILDING_CARTHAGE_COTHON = 23
    BUILDING_CUSTOM_HOUSE = 24
    BUILDING_PORTUGAL_FEITORIA = 25
    BUILDING_DRYDOCK = 26
    BUILDING_AIRPORT = 27
    BUILDING_FORGE = 28
    BUILDING_MALI_MINT = 29
    BUILDING_FACTORY = 30
    BUILDING_GERMAN_ASSEMBLY_PLANT = 31
    BUILDING_COAL_PLANT = 32
    BUILDING_JAPANESE_SHALE_PLANT = 33
    BUILDING_HYDRO_PLANT = 34
    BUILDING_NUCLEAR_PLANT = 35
    BUILDING_INDUSTRIAL_PARK = 36
    BUILDING_OBELISK = 37
    BUILDING_EGYPTIAN_OBELISK = 38
    BUILDING_ETHIOPIAN_STELE = 39
    BUILDING_NATIVE_AMERICA_TOTEM = 40
    BUILDING_PUBLIC_TRANSPORTATION = 41
    BUILDING_ACADEMY = 42
    BUILDING_LIBRARY = 43
    BUILDING_ARABIAN_MADRASSA = 44
    BUILDING_UNIVERSITY = 45
    BUILDING_KOREAN_SEOWON = 46
    BUILDING_OBSERVATORY = 47
    BUILDING_FRENCH_SALON = 48
    BUILDING_LABORATORY = 49
    BUILDING_RUSSIAN_RESEARCH_INSTITUTE = 50
    BUILDING_THEATRE = 51
    BUILDING_CHINESE_PAVILLION = 52
    BUILDING_BYZANTINE_HIPPODROME = 53
    BUILDING_COLOSSEUM = 54
    BUILDING_GREEK_ODEON = 55
    BUILDING_MAYA_BALL_COURT = 56
    BUILDING_BABYLON_GARDEN = 57
    BUILDING_BROADCAST_TOWER = 58
    BUILDING_MARKET = 59
    BUILDING_ROMAN_FORUM = 60
    BUILDING_GROCER = 61
    BUILDING_PERSIAN_APOTHECARY = 62
    BUILDING_BANK = 63
    BUILDING_ENGLISH_STOCK_EXCHANGE = 64
    BUILDING_SUPERMARKET = 65
    BUILDING_AMERICAN_MALL = 66
    BUILDING_COURTHOUSE = 67
    BUILDING_AZTEC_SACRIFICIAL_ALTAR = 68
    BUILDING_HOLY_ROMAN_RATHAUS = 69
    BUILDING_SUMERIAN_ZIGGURAT = 70
    BUILDING_JAIL = 71
    BUILDING_INDIAN_MAUSOLEUM = 72
    BUILDING_LEVEE = 73
    BUILDING_NETHERLANDS_DIKE = 74
    BUILDING_INTELLIGENCE_AGENCY = 75
    BUILDING_NATIONAL_SECURITY = 76
    BUILDING_JEWISH_TEMPLE = 77
    BUILDING_JEWISH_CATHEDRAL = 78
    BUILDING_JEWISH_MONASTERY = 79
    BUILDING_JEWISH_SHRINE = 80
    BUILDING_CHRISTIAN_TEMPLE = 81
    BUILDING_CHRISTIAN_CATHEDRAL = 82
    BUILDING_CHRISTIAN_MONASTERY = 83
    BUILDING_CHRISTIAN_SHRINE = 84
    BUILDING_ISLAMIC_TEMPLE = 85
    BUILDING_ISLAMIC_CATHEDRAL = 86
    BUILDING_ISLAMIC_MONASTERY = 87
    BUILDING_ISLAMIC_SHRINE = 88
    BUILDING_HINDU_TEMPLE = 89
    BUILDING_HINDU_CATHEDRAL = 90
    BUILDING_HINDU_MONASTERY = 91
    BUILDING_HINDU_SHRINE = 92
    BUILDING_BUDDHIST_TEMPLE = 93
    BUILDING_BUDDHIST_CATHEDRAL = 94
    BUILDING_BUDDHIST_MONASTERY = 95
    BUILDING_BUDDHIST_SHRINE = 96
    BUILDING_CONFUCIAN_TEMPLE = 97
    BUILDING_CONFUCIAN_CATHEDRAL = 98
    BUILDING_CONFUCIAN_MONASTERY = 99
    BUILDING_CONFUCIAN_SHRINE = 100
    BUILDING_TAOIST_TEMPLE = 101
    BUILDING_TAOIST_CATHEDRAL = 102
    BUILDING_TAOIST_MONASTERY = 103
    BUILDING_TAOIST_SHRINE = 104
    BUILDING_HEROIC_EPIC = 105
    BUILDING_NATIONAL_EPIC = 106
    BUILDING_GLOBE_THEATRE = 107
    BUILDING_NATIONAL_PARK = 108
    BUILDING_HERMITAGE = 109
    BUILDING_OXFORD_UNIVERSITY = 110
    BUILDING_WALL_STREET = 111
    BUILDING_IRON_WORKS = 112
    BUILDING_WEST_POINT = 113
    BUILDING_MT_RUSHMORE = 114
    BUILDING_RED_CROSS = 115
    BUILDING_SCOTLAND_YARD = 116
    BUILDING_PYRAMID = 117
    BUILDING_STONEHENGE = 118
    BUILDING_GREAT_LIBRARY = 119
    BUILDING_GREAT_LIGHTHOUSE = 120
    BUILDING_HANGING_GARDEN = 121
    BUILDING_COLOSSUS = 122
    BUILDING_ORACLE = 123
    BUILDING_PARTHENON = 124
    BUILDING_ANGKOR_WAT = 125
    BUILDING_HAGIA_SOPHIA = 126
    BUILDING_CHICHEN_ITZA = 127
    BUILDING_SISTINE_CHAPEL = 128
    BUILDING_SPIRAL_MINARET = 129
    BUILDING_NOTRE_DAME = 130
    BUILDING_TAJ_MAHAL = 131
    BUILDING_KREMLIN = 132
    BUILDING_EIFFEL_TOWER = 133
    BUILDING_STATUE_OF_LIBERTY = 134
    BUILDING_BROADWAY = 135
    BUILDING_ROCKNROLL = 136
    BUILDING_HOLLYWOOD = 137
    BUILDING_GREAT_DAM = 138
    BUILDING_PENTAGON = 139
    BUILDING_UNITED_NATIONS = 140
    BUILDING_SPACE_ELEVATOR = 141
    BUILDING_MILITARY_ACADEMY = 142
    BUILDING_ARTEMIS = 143
    BUILDING_SANKORE = 144
    BUILDING_GREAT_WALL = 145
    BUILDING_STATUE_OF_ZEUS = 146
    BUILDING_MAUSOLEUM_OF_MAUSSOLLOS = 147
    BUILDING_CRISTO_REDENTOR = 148
    BUILDING_SHWEDAGON_PAYA = 149
    BUILDING_MOAI_STATUES = 150
    BUILDING_CORPORATION_1 = 151
    BUILDING_CORPORATION_2 = 152
    BUILDING_CORPORATION_3 = 153
    BUILDING_CORPORATION_4 = 154
    BUILDING_CORPORATION_5 = 155
    BUILDING_CORPORATION_6 = 156
    BUILDING_CORPORATION_7 = 157
    BUILDING_APOSTOLIC_PALACE = 158


class SpecialBuildingType(IntEnum):  # noqa: D101
    NO_SPECIAL_BUILDING = -1
    SPECIALBUILDING_BOMB_SHELTER = 0
    SPECIALBUILDING_TEMPLE = 1
    SPECIALBUILDING_CATHEDRAL = 2
    SPECIALBUILDING_MONASTERY = 3


class CivilizationType(IntEnum):  # noqa: D101
    NO_CIVILIZATION = -1
    CIVILIZATION_AMERICA = 0
    CIVILIZATION_ARABIA = 1
    CIVILIZATION_AZTEC = 2
    CIVILIZATION_BABYLON = 3
    CIVILIZATION_BYZANTIUM = 4
    CIVILIZATION_CARTHAGE = 5
    CIVILIZATION_CELT = 6
    CIVILIZATION_CHINA = 7
    CIVILIZATION_EGYPT = 8
    CIVILIZATION_ENGLAND = 9
    CIVILIZATION_ETHIOPIA = 10
    CIVILIZATION_FRANCE = 11
    CIVILIZATION_GERMANY = 12
    CIVILIZATION_GREECE = 13
    CIVILIZATION_HOLY_ROMAN = 14
    CIVILIZATION_INCA = 15
    CIVILIZATION_INDIA = 16
    CIVILIZATION_JAPAN = 17
    CIVILIZATION_KHMER = 18
    CIVILIZATION_KOREA = 19
    CIVILIZATION_MALI = 20
    CIVILIZATION_MAYA = 21
    CIVILIZATION_MONGOL = 22
    CIVILIZATION_NATIVE_AMERICA = 23
    CIVILIZATION_NETHERLANDS = 24
    CIVILIZATION_OTTOMAN = 25
    CIVILIZATION_PERSIA = 26
    CIVILIZATION_PORTUGAL = 27
    CIVILIZATION_ROME = 28
    CIVILIZATION_RUSSIA = 29
    CIVILIZATION_SPAIN = 30
    CIVILIZATION_SUMERIA = 31
    CIVILIZATION_VIKING = 32
    CIVILIZATION_ZULU = 33
    CIVILIZATION_MINOR = 34
    CIVILIZATION_BARBARIAN = 35


class LeaderHeadType(IntEnum):  # noqa: D101
    NO_LEADER_HEAD = -1
    LEADER_BARBARIAN = 0
    LEADER_ALEXANDER = 1
    LEADER_ASOKA = 2
    LEADER_AUGUSTUS = 3
    LEADER_BISMARCK = 4
    LEADER_BOUDICA = 5
    LEADER_BRENNUS = 6
    LEADER_CATHERINE = 7
    LEADER_CHARLEMAGNE = 8
    LEADER_CHURCHILL = 9
    LEADER_CYRUS = 10
    LEADER_DARIUS = 11
    LEADER_DE_GAULLE = 12
    LEADER_ELIZABETH = 13
    LEADER_FREDERICK = 14
    LEADER_GANDHI = 15
    LEADER_GENGHIS_KHAN = 16
    LEADER_GILGAMESH = 17
    LEADER_HAMMURABI = 18
    LEADER_HANNIBAL = 19
    LEADER_HATSHEPSUT = 20
    LEADER_HUAYNA_CAPAC = 21
    LEADER_ISABELLA = 22
    LEADER_JOAO = 23
    LEADER_JULIUS_CAESAR = 24
    LEADER_JUSTINIAN = 25
    LEADER_KUBLAI_KHAN = 26
    LEADER_LINCOLN = 27
    LEADER_LOUIS_XIV = 28
    LEADER_MANSA_MUSA = 29
    LEADER_CHINESE_LEADER = 30
    LEADER_MEHMED = 31
    LEADER_MONTEZUMA = 32
    LEADER_NAPOLEON = 33
    LEADER_PACAL = 34
    LEADER_PERICLES = 35
    LEADER_PETER = 36
    LEADER_QIN_SHI_HUANG = 37
    LEADER_RAMESSES = 38
    LEADER_RAGNAR = 39
    LEADER_FRANKLIN_ROOSEVELT = 40
    LEADER_SALADIN = 41
    LEADER_SHAKA = 42
    LEADER_SITTING_BULL = 43
    LEADER_STALIN = 44
    LEADER_SULEIMAN = 45
    LEADER_SURYAVARMAN = 46
    LEADER_TOKUGAWA = 47
    LEADER_VICTORIA = 48
    LEADER_WANGKON = 49
    LEADER_WASHINGTON = 50
    LEADER_WILLEM_VAN_ORANJE = 51
    LEADER_ZARA_YAQOB = 52


class UnitArtStyleType(IntEnum):  # noqa: D101
    NO_UNIT_ART_STYLE = -1
    UNIT_ARTSTYLE_ASIAN = 0
    UNIT_ARTSTYLE_EUROPEAN = 1
    UNIT_ARTSTYLE_GRECO_ROMAN = 2
    UNIT_ARTSTYLE_MIDDLE_EAST = 3
    UNIT_ARTSTYLE_SOUTH_AMERICA = 4


class EventType(IntEnum):  # noqa: D101
    NO_EVENT = -1
    EVENT_FOREST_FIRE_1 = 0
    EVENT_FOREST_FIRE_2 = 1
    EVENT_FOREST_FIRE_3 = 2
    EVENT_CITY_RUINS_1 = 3
    EVENT_CITY_RUINS_2 = 4
    EVENT_CITY_RUINS_3 = 5
    EVENT_HAPPY_HUNTING_1 = 6
    EVENT_MOTHER_LODE_1 = 7
    EVENT_WASHED_OUT_1 = 8
    EVENT_WASHED_OUT_2 = 9
    EVENT_AT_THE_SWORD_1 = 10
    EVENT_MAN_NAMED_JED_1 = 11
    EVENT_MAN_NAMED_JED_2 = 12
    EVENT_INSPIRED_MISSION_1 = 13
    EVENT_INSPIRED_MISSION_2 = 14
    EVENT_INSPIRED_MISSION_3 = 15
    EVENT_HYMNS_AND_SCULPTURES_1 = 16
    EVENT_CARELESS_APPRENTICE_1 = 17
    EVENT_CARELESS_APPRENTICE_2 = 18
    EVENT_CARELESS_APPRENTICE_3 = 19
    EVENT_FAMINE_1 = 20
    EVENT_FAMINE_2 = 21
    EVENT_FAMINE_3 = 22
    EVENT_SLAVE_REVOLT_1 = 23
    EVENT_SLAVE_REVOLT_2 = 24
    EVENT_SLAVE_REVOLT_3 = 25
    EVENT_BLESSED_SEA_1 = 26
    EVENT_BLESSED_SEA_DONE_1 = 27
    EVENT_BLESSED_SEA_DONE_2 = 28
    EVENT_BLESSED_SEA_DONE_3 = 29
    EVENT_AIRLINER_CRASH_1 = 30
    EVENT_AIRLINER_CRASH_2 = 31
    EVENT_AIRLINER_CRASH_3 = 32
    EVENT_AIRLINER_CRASH_4 = 33
    EVENT_FARM_BANDITS_1 = 34
    EVENT_FARM_BANDITS_2 = 35
    EVENT_FARM_BANDITS_3 = 36
    EVENT_HOLY_MOUNTAIN_1 = 37
    EVENT_HOLY_MOUNTAIN_DONE_1 = 38
    EVENT_HOLY_MOUNTAIN_REVEALED_1 = 39
    EVENT_HORTICULTURE_1 = 40
    EVENT_HORTICULTURE_2 = 41
    EVENT_HORTICULTURE_3 = 42
    EVENT_FUGITIVE_1 = 43
    EVENT_FUGITIVE_2 = 44
    EVENT_FUGITIVE_3 = 45
    EVENT_FUGITIVE_4 = 46
    EVENT_FUGITIVE_5 = 47
    EVENT_PESTILENCE_1 = 48
    EVENT_MARATHON_1 = 49
    EVENT_FAUX_PAS_1 = 50
    EVENT_JOYOUS_WEDDING_1 = 51
    EVENT_JOYOUS_WEDDING_2 = 52
    EVENT_JOYOUS_WEDDING_3 = 53
    EVENT_WEDDING_FEUD_1 = 54
    EVENT_WEDDING_FEUD_2 = 55
    EVENT_WEDDING_FEUD_3 = 56
    EVENT_LEFT_AT_ALTAR_1 = 57
    EVENT_SPICY_1 = 58
    EVENT_SPICY_2 = 59
    EVENT_TORNADO_1 = 60
    EVENT_BABY_BOOM_1 = 61
    EVENT_BARDS_TALE_1 = 62
    EVENT_BARDS_TALE_2 = 63
    EVENT_BARDS_TALE_3 = 64
    EVENT_LOOTERS_1 = 65
    EVENT_LOOTERS_2 = 66
    EVENT_LOOTERS_3 = 67
    EVENT_LOOTERS_4 = 68
    EVENT_BROTHERS_IN_NEED_1 = 69
    EVENT_BROTHERS_IN_NEED_2 = 70
    EVENT_BROTHERS_IN_NEED_3 = 71
    EVENT_BROTHERS_IN_NEED_4 = 72
    EVENT_BROTHERS_IN_NEED_5 = 73
    EVENT_BROTHERS_IN_NEED_6 = 74
    EVENT_BROTHERS_IN_NEED_7 = 75
    EVENT_HURRICANE_1 = 76
    EVENT_HURRICANE_2 = 77
    EVENT_CYCLONE_1 = 78
    EVENT_CYCLONE_2 = 79
    EVENT_TSUNAMI_1 = 80
    EVENT_TSUNAMI_2 = 81
    EVENT_MONSOON_1 = 82
    EVENT_MONSOON_2 = 83
    EVENT_BLIZZARD_1 = 84
    EVENT_BLIZZARD_2 = 85
    EVENT_VOLCANO_1 = 86
    EVENT_DUSTBOWL_1 = 87
    EVENT_DUSTBOWL_2 = 88
    EVENT_PARROTS_1 = 89
    EVENT_JADE_1 = 90
    EVENT_BLACK_PEARLS_1 = 91
    EVENT_SALTPETER_1 = 92
    EVENT_CLUNKER_COAL_1 = 93
    EVENT_SOUR_CRUDE_1 = 94
    EVENT_TRUFFLES_1 = 95
    EVENT_SEA_TURTLES_1 = 96
    EVENT_TIN_1 = 97
    EVENT_PRAIRIE_DOGS_1 = 98
    EVENT_ICE_SCULPTURE_1 = 99
    EVENT_ICE_SCULPTURE_2 = 100
    EVENT_APPLESEED_1 = 101
    EVENT_MINING_ACCIDENT_1 = 102
    EVENT_MINING_ACCIDENT_2 = 103
    EVENT_MINING_ACCIDENT_3 = 104
    EVENT_BREAKTHROUGH_1 = 105
    EVENT_SETBACK_1 = 106
    EVENT_RUNNING_BULLS_1 = 107
    EVENT_RUNNING_BULLS_2 = 108
    EVENT_GREAT_DEPRESSION_1 = 109
    EVENT_BERMUDA_TRIANGLE_1 = 110
    EVENT_PATRON_OF_KNOWLEDGE_1 = 111
    EVENT_PATRON_OF_KNOWLEDGE_2 = 112
    EVENT_MASTER_SMITH_1 = 113
    EVENT_RURAL_FARMERS_1 = 114
    EVENT_MONEY_CHANGERS_1 = 115
    EVENT_BOWYER_1 = 116
    EVENT_HORSESHOE_1 = 117
    EVENT_CHAMPION_1 = 118
    EVENT_MOTOR_OIL_1 = 119
    EVENT_MOTOR_OIL_2 = 120
    EVENT_FEDERAL_RESERVE_1 = 121
    EVENT_FEDERAL_RESERVE_2 = 122
    EVENT_ELECTRIC_COMPANY_1 = 123
    EVENT_HINDENBERG_1 = 124
    EVENT_HINDENBERG_2 = 125
    EVENT_COMET_FRAGMENT_1 = 126
    EVENT_SUBWAY_1 = 127
    EVENT_GOLD_RUSH_1 = 128
    EVENT_GOLD_RUSH_2 = 129
    EVENT_INFLUENZA_1 = 130
    EVENT_INFLUENZA_2 = 131
    EVENT_SOLO_FLIGHT_1 = 132
    EVENT_ANTELOPE_1 = 133
    EVENT_ANTELOPE_2 = 134
    EVENT_WHALEOFATHING_1 = 135
    EVENT_HIYOSILVER_1 = 136
    EVENT_HIYOSILVER_2 = 137
    EVENT_WININGMONKS_1 = 138
    EVENT_WININGMONKS_2 = 139
    EVENT_INDEPENDENTFILMS_1 = 140
    EVENT_ANCIENTOLYMPICS_1 = 141
    EVENT_ANCIENTOLYMPICS_2 = 142
    EVENT_MODERNOLYMPICS_1 = 143
    EVENT_INTERSTATE_1 = 144
    EVENT_EARTHDAY_1 = 145
    EVENT_EARTHDAY_2 = 146
    EVENT_FREEDOMCONCERT_1 = 147
    EVENT_FREEDOMCONCERT_2 = 148
    EVENT_AXE_HAFT_1 = 149
    EVENT_TOWER_SHIELD_1 = 150
    EVENT_SMOKELESS_POWDER_1 = 151
    EVENT_STRONGER_FITTINGS_1 = 152
    EVENT_FIRING_PINS_1 = 153
    EVENT_RIFLED_CANNON_1 = 154
    EVENT_METAL_DECKS_1 = 155
    EVENT_LONG_RANGE_FIGHTERS_1 = 156
    EVENT_HALBERD_1 = 157
    EVENT_REINFORCED_HULL_1 = 158
    EVENT_CIGARETTE_SMOKER_1 = 159
    EVENT_CIGARETTE_SMOKER_2 = 160
    EVENT_CIGARETTE_SMOKER_3 = 161
    EVENT_HEROIC_GESTURE_1 = 162
    EVENT_HEROIC_GESTURE_2 = 163
    EVENT_GREAT_MEDIATOR_1 = 164
    EVENT_GREAT_MEDIATOR_2 = 165
    EVENT_FORTY_THIEVES_1 = 166
    EVENT_ANCIENT_TEXTS_1 = 167
    EVENT_ANCIENT_TEXTS_2 = 168
    EVENT_WATERS_OF_LIFE_1 = 169
    EVENT_IMPACT_CRATER_1 = 170
    EVENT_IMPACT_CRATER_2 = 171
    EVENT_THE_HUNS_1 = 172
    EVENT_THE_VANDALS_1 = 173
    EVENT_THE_GOTHS_1 = 174
    EVENT_THE_PHILISTINES_1 = 175
    EVENT_THE_VEDIC_ARYANS_1 = 176
    EVENT_HOLY_RITUAL_1 = 177
    EVENT_SECURITY_TAX_1 = 178
    EVENT_LITERACY_1 = 179
    EVENT_FARM_PLOWS_1 = 180
    EVENT_STAINED_GLASS_1 = 181
    EVENT_MARBLE_STATUES_1 = 182
    EVENT_CRAB_CAKES_1 = 183
    EVENT_BOILERS_1 = 184
    EVENT_PERSONAL_COMPUTERS_1 = 185
    EVENT_FUEL_ADDITIVES_1 = 186
    EVENT_HAMBURGER_JOINT_1 = 187
    EVENT_TEA_1 = 188
    EVENT_FASHION_1 = 189
    EVENT_THOROUGHBRED_1 = 190
    EVENT_GIRLS_BEST_FRIEND_1 = 191
    EVENT_BANANA_SPLIT_1 = 192
    EVENT_HORSE_WHISPERING_1 = 193
    EVENT_HORSE_WHISPERING_DONE_1 = 194
    EVENT_HORSE_WHISPERING_DONE_2 = 195
    EVENT_HORSE_WHISPERING_DONE_3 = 196
    EVENT_HARBORMASTER_1 = 197
    EVENT_HARBORMASTER_DONE_1 = 198
    EVENT_HARBORMASTER_DONE_2 = 199
    EVENT_HARBORMASTER_DONE_3 = 200
    EVENT_CLASSIC_LITERATURE_1 = 201
    EVENT_CLASSIC_LITERATURE_DONE_1 = 202
    EVENT_CLASSIC_LITERATURE_DONE_2 = 203
    EVENT_CLASSIC_LITERATURE_DONE_3 = 204
    EVENT_MASTER_BLACKSMITH_1 = 205
    EVENT_MASTER_BLACKSMITH_DONE_1 = 206
    EVENT_MASTER_BLACKSMITH_DONE_2 = 207
    EVENT_MASTER_BLACKSMITH_DONE_3 = 208
    EVENT_BEST_DEFENSE_1 = 209
    EVENT_BEST_DEFENSE_DONE_1 = 210
    EVENT_BEST_DEFENSE_DONE_2 = 211
    EVENT_BEST_DEFENSE_DONE_3 = 212
    EVENT_SPORTS_LEAGUE_1 = 213
    EVENT_SPORTS_LEAGUE_DONE_1 = 214
    EVENT_SPORTS_LEAGUE_DONE_2 = 215
    EVENT_SPORTS_LEAGUE_DONE_3 = 216
    EVENT_CRUSADE_1 = 217
    EVENT_CRUSADE_DONE_1 = 218
    EVENT_CRUSADE_DONE_2 = 219
    EVENT_CRUSADE_DONE_3 = 220
    EVENT_MIRACLE_1 = 221
    EVENT_MIRACLE_2 = 222
    EVENT_ESTEEMED_PLAYWRIGHT_1 = 223
    EVENT_ESTEEMED_PLAYWRIGHT_2 = 224
    EVENT_FAVORITE_SON_1 = 225
    EVENT_FAVORITE_SON_2 = 226
    EVENT_SECRET_KNOWLEDGE_1 = 227
    EVENT_SECRET_KNOWLEDGE_2 = 228
    EVENT_HIGH_WARLORD_1 = 229
    EVENT_HIGH_WARLORD_2 = 230
    EVENT_HIGH_WARLORD_3 = 231
    EVENT_SPOILED_GRAIN_1 = 232
    EVENT_SPOILED_GRAIN_2 = 233
    EVENT_ANGEL_OF_MERCY_1 = 234
    EVENT_ANGEL_OF_MERCY_2 = 235
    EVENT_CHILLY_FLIGHT_1 = 236
    EVENT_INDUSTRIAL_FIRE_1 = 237
    EVENT_INDUSTRIAL_FIRE_2 = 238
    EVENT_LABORATORY_1 = 239
    EVENT_EXPERIENCED_CAPTAIN_1 = 240
    EVENT_EXPERIENCED_CAPTAIN_2 = 241
    EVENT_HERESY_1 = 242
    EVENT_HERESY_2 = 243
    EVENT_HERESY_3 = 244
    EVENT_PARTISANS_1 = 245
    EVENT_PARTISANS_2 = 246
    EVENT_NEW_DYNASTY_1 = 247
    EVENT_NEW_DYNASTY_2 = 248
    EVENT_NEW_DYNASTY_3 = 249
    EVENT_CRISIS_IN_THE_SENATE_1 = 250
    EVENT_CRISIS_IN_THE_SENATE_2 = 251
    EVENT_CRISIS_IN_THE_SENATE_3 = 252
    EVENT_TOO_CLOSE_TO_CALL_1 = 253
    EVENT_TOO_CLOSE_TO_CALL_2 = 254
    EVENT_CHARISMATIC_1 = 255
    EVENT_CHARISMATIC_2 = 256
    EVENT_FRIENDLY_LOCALS_1 = 257
    EVENT_GREED_1 = 258
    EVENT_GREED_DONE_1 = 259
    EVENT_WAR_CHARIOTS_1 = 260
    EVENT_WAR_CHARIOTS_DONE_1 = 261
    EVENT_WAR_CHARIOTS_DONE_2 = 262
    EVENT_ELITE_SWORDS_1 = 263
    EVENT_ELITE_SWORDS_DONE_1 = 264
    EVENT_ELITE_SWORDS_DONE_2 = 265
    EVENT_WARSHIPS_1 = 266
    EVENT_WARSHIPS_DONE_1 = 267
    EVENT_WARSHIPS_DONE_2 = 268
    EVENT_GUNS_BUTTER_1 = 269
    EVENT_GUNS_BUTTER_DONE_1 = 270
    EVENT_GUNS_BUTTER_DONE_2 = 271
    EVENT_GUNS_BUTTER_DONE_3 = 272
    EVENT_NOBLE_KNIGHTS_1 = 273
    EVENT_NOBLE_KNIGHTS_DONE_1 = 274
    EVENT_NOBLE_KNIGHTS_DONE_2 = 275
    EVENT_NOBLE_KNIGHTS_DONE_3 = 276
    EVENT_OVERWHELM_1 = 277
    EVENT_OVERWHELM_DONE_1 = 278
    EVENT_OVERWHELM_DONE_2 = 279
    EVENT_OVERWHELM_DONE_3 = 280
    EVENT_CORPORATE_EXPANSION_1 = 281
    EVENT_CORPORATE_EXPANSION_DONE_1 = 282
    EVENT_HOSTILE_TAKEOVER_1 = 283
    EVENT_HOSTILE_TAKEOVER_DONE_1 = 284
    EVENT_CIV_GAME_1 = 285
    EVENT_CIV_GAME_2 = 286
    EVENT_CIV_GAME_3 = 287
    EVENT_SLAVE_REVOLT_WARNING = 288
    EVENT_IMMIGRANTS_1 = 289
    EVENT_HEALING_PLANT_1 = 290
    EVENT_HEALING_PLANT_2 = 291
    EVENT_HEALING_PLANT_3 = 292
    EVENT_HEALING_PLANT_4 = 293
    EVENT_HEALING_PLANT_5 = 294
    EVENT_HEALING_PLANT_6 = 295
    EVENT_GREAT_BEAST_1 = 296
    EVENT_GREAT_BEAST_2 = 297
    EVENT_GREAT_BEAST_3 = 298
    EVENT_CONTROVERSIAL_PHILOSOPHER_1 = 299
    EVENT_CONTROVERSIAL_PHILOSOPHER_2 = 300
    EVENT_CONTROVERSIAL_PHILOSOPHER_3 = 301
    EVENT_DEFECTING_AGENT_1 = 302
    EVENT_DEFECTING_AGENT_2 = 303
    EVENT_DEFECTING_AGENT_3 = 304
    EVENT_JAIL_1 = 305
    EVENT_JAIL_2 = 306
    EVENT_SPY_DISCOVERED_1 = 307
    EVENT_SPY_DISCOVERED_2 = 308
    EVENT_SPY_DISCOVERED_3 = 309
    EVENT_NUCLEAR_PROTEST_1 = 310
    EVENT_NUCLEAR_PROTEST_2 = 311
    EVENT_NUCLEAR_PROTEST_3 = 312
    EVENT_BETTER_COAL_1 = 313
    EVENT_BETTER_COAL_2 = 314
    EVENT_BROKEN_DAM_1 = 315
    EVENT_BROKEN_DAM_2 = 316
    EVENT_BROKEN_DAM_3 = 317
    EVENT_RABBI_1 = 318
    EVENT_RABBI_2 = 319
    EVENT_RABBI_3 = 320
    EVENT_GOLDEN_BUDDHA_1 = 321
    EVENT_GOLDEN_BUDDHA_2 = 322
    EVENT_GOLDEN_BUDDHA_3 = 323
    EVENT_PREACHING_RESEARCHER_1 = 324
    EVENT_PREACHING_RESEARCHER_2 = 325
    EVENT_TOXCATL_1 = 326
    EVENT_TOXCATL_2 = 327
    EVENT_DISSIDENT_PRIEST_1 = 328
    EVENT_DISSIDENT_PRIEST_2 = 329
    EVENT_DISSIDENT_PRIEST_3 = 330
    EVENT_PASTURE_BUILT_1 = 331
    EVENT_ROGUE_STATION_1 = 332
    EVENT_ROGUE_STATION_2 = 333
    EVENT_ROGUE_STATION_3 = 334
    EVENT_ANTIMONARCHISTS_1 = 335
    EVENT_ANTIMONARCHISTS_2 = 336
    EVENT_IMPEACHMENT_1 = 337
    EVENT_IMPEACHMENT_2 = 338


class EventTriggerType(IntEnum):  # noqa: D101
    NO_EVENT_TRIGGER = -1
    EVENTTRIGGER_FOREST_FIRE = 0
    EVENTTRIGGER_CITY_RUINS_ANCIENT = 1
    EVENTTRIGGER_HAPPY_HUNTING = 2
    EVENTTRIGGER_MOTHER_LODE = 3
    EVENTTRIGGER_WASHED_OUT = 4
    EVENTTRIGGER_AT_THE_SWORD = 5
    EVENTTRIGGER_MAN_NAMED_JED = 6
    EVENTTRIGGER_INSPIRED_MISSION = 7
    EVENTTRIGGER_HYMNS_AND_SCULPTURES = 8
    EVENTTRIGGER_CARELESS_APPRENTICE = 9
    EVENTTRIGGER_FAMINE = 10
    EVENTTRIGGER_SLAVE_REVOLT = 11
    EVENTTRIGGER_SLAVE_REVOLT_AGAIN = 12
    EVENTTRIGGER_BLESSED_SEA = 13
    EVENTTRIGGER_BLESSED_SEA_DONE = 14
    EVENTTRIGGER_AIRLINER_CRASH = 15
    EVENTTRIGGER_FARM_BANDITS = 16
    EVENTTRIGGER_FARM_BANDITS_AGAIN = 17
    EVENTTRIGGER_HOLY_MOUNTAIN = 18
    EVENTTRIGGER_HOLY_MOUNTAIN_DONE = 19
    EVENTTRIGGER_HOLY_MOUNTAIN_REVEALED = 20
    EVENTTRIGGER_HORTICULTURE = 21
    EVENTTRIGGER_FUGITIVE = 22
    EVENTTRIGGER_PESTILENCE = 23
    EVENTTRIGGER_PESTILENCE_2 = 24
    EVENTTRIGGER_MARATHON = 25
    EVENTTRIGGER_FAUX_PAS = 26
    EVENTTRIGGER_JOYOUS_WEDDING = 27
    EVENTTRIGGER_WEDDING_FEUD = 28
    EVENTTRIGGER_LEFT_AT_ALTAR = 29
    EVENTTRIGGER_SPICY = 30
    EVENTTRIGGER_TORNADO = 31
    EVENTTRIGGER_BABY_BOOM = 32
    EVENTTRIGGER_BARDS_TALE = 33
    EVENTTRIGGER_LOOTERS = 34
    EVENTTRIGGER_BROTHERS_IN_NEED = 35
    EVENTTRIGGER_HURRICANE = 36
    EVENTTRIGGER_CYCLONE = 37
    EVENTTRIGGER_TSUNAMI = 38
    EVENTTRIGGER_MONSOON = 39
    EVENTTRIGGER_BLIZZARD = 40
    EVENTTRIGGER_VOLCANO = 41
    EVENTTRIGGER_DUSTBOWL = 42
    EVENTTRIGGER_DUSTBOWL_CONT = 43
    EVENTTRIGGER_PARROTS = 44
    EVENTTRIGGER_JADE = 45
    EVENTTRIGGER_BLACK_PEARLS = 46
    EVENTTRIGGER_SALTPETER = 47
    EVENTTRIGGER_CLUNKER_COAL = 48
    EVENTTRIGGER_SOUR_CRUDE = 49
    EVENTTRIGGER_TRUFFLES = 50
    EVENTTRIGGER_SEA_TURTLES = 51
    EVENTTRIGGER_TIN = 52
    EVENTTRIGGER_PRAIRIE_DOGS = 53
    EVENTTRIGGER_ICE_SCULPTURE = 54
    EVENTTRIGGER_APPLESEED = 55
    EVENTTRIGGER_MINING_ACCIDENT = 56
    EVENTTRIGGER_BREAKTHROUGH = 57
    EVENTTRIGGER_SETBACK = 58
    EVENTTRIGGER_RUNNING_BULLS = 59
    EVENTTRIGGER_GREAT_DEPRESSION = 60
    EVENTTRIGGER_BERMUDA_TRIANGLE = 61
    EVENTTRIGGER_PATRON_OF_KNOWLEDGE = 62
    EVENTTRIGGER_MASTER_SMITH = 63
    EVENTTRIGGER_RURAL_FARMERS = 64
    EVENTTRIGGER_MONEY_CHANGERS = 65
    EVENTTRIGGER_BOWYER = 66
    EVENTTRIGGER_HORSESHOE = 67
    EVENTTRIGGER_CHAMPION = 68
    EVENTTRIGGER_MOTOR_OIL = 69
    EVENTTRIGGER_FEDERAL_RESERVE = 70
    EVENTTRIGGER_ELECTRIC_COMPANY = 71
    EVENTTRIGGER_HINDENBERG = 72
    EVENTTRIGGER_COMET_FRAGMENT = 73
    EVENTTRIGGER_SUBWAY = 74
    EVENTTRIGGER_GOLD_RUSH = 75
    EVENTTRIGGER_INFLUENZA = 76
    EVENTTRIGGER_SOLO_FLIGHT = 77
    EVENTTRIGGER_ANTELOPE = 78
    EVENTTRIGGER_WHALEOFATHING = 79
    EVENTTRIGGER_HIYOSILVER = 80
    EVENTTRIGGER_WININGMONKS = 81
    EVENTTRIGGER_INDEPENDENTFILMS = 82
    EVENTTRIGGER_ANCIENTOLYMPICS = 83
    EVENTTRIGGER_MODERNOLYMPICS = 84
    EVENTTRIGGER_INTERSTATE = 85
    EVENTTRIGGER_EARTHDAY = 86
    EVENTTRIGGER_FREEDOMCONCERT = 87
    EVENTTRIGGER_AXE_HAFT = 88
    EVENTTRIGGER_TOWER_SHIELD = 89
    EVENTTRIGGER_SMOKELESS_POWDER = 90
    EVENTTRIGGER_STRONGER_FITTINGS = 91
    EVENTTRIGGER_FIRING_PINS = 92
    EVENTTRIGGER_RIFLED_CANNON = 93
    EVENTTRIGGER_METAL_DECKS = 94
    EVENTTRIGGER_LONG_RANGE_FIGHTERS = 95
    EVENTTRIGGER_HALBERD = 96
    EVENTTRIGGER_REINFORCED_HULL = 97
    EVENTTRIGGER_CIGARETTE_SMOKER = 98
    EVENTTRIGGER_HEROIC_GESTURE = 99
    EVENTTRIGGER_GREAT_MEDIATOR = 100
    EVENTTRIGGER_FORTY_THIEVES = 101
    EVENTTRIGGER_ANCIENT_TEXTS = 102
    EVENTTRIGGER_WATERS_OF_LIFE = 103
    EVENTTRIGGER_IMPACT_CRATER = 104
    EVENTTRIGGER_THE_HUNS = 105
    EVENTTRIGGER_THE_VANDALS = 106
    EVENTTRIGGER_THE_GOTHS = 107
    EVENTTRIGGER_THE_PHILISTINES = 108
    EVENTTRIGGER_THE_VEDIC_ARYANS = 109
    EVENTTRIGGER_HOLY_RITUAL = 110
    EVENTTRIGGER_SECURITY_TAX = 111
    EVENTTRIGGER_LITERACY = 112
    EVENTTRIGGER_FARM_PLOWS = 113
    EVENTTRIGGER_STAINED_GLASS = 114
    EVENTTRIGGER_MARBLE_STATUES = 115
    EVENTTRIGGER_CRAB_CAKES = 116
    EVENTTRIGGER_BOILERS = 117
    EVENTTRIGGER_PERSONAL_COMPUTERS = 118
    EVENTTRIGGER_FUEL_ADDITIVES = 119
    EVENTTRIGGER_HAMBURGER_JOINT = 120
    EVENTTRIGGER_TEA = 121
    EVENTTRIGGER_FASHION = 122
    EVENTTRIGGER_THOROUGHBRED = 123
    EVENTTRIGGER_GIRLS_BEST_FRIEND = 124
    EVENTTRIGGER_BANANA_SPLIT = 125
    EVENTTRIGGER_HORSE_WHISPERING = 126
    EVENTTRIGGER_HORSE_WHISPERING_DONE = 127
    EVENTTRIGGER_HARBORMASTER = 128
    EVENTTRIGGER_HARBORMASTER_DONE = 129
    EVENTTRIGGER_CLASSIC_LITERATURE = 130
    EVENTTRIGGER_CLASSIC_LITERATURE_DONE = 131
    EVENTTRIGGER_MASTER_BLACKSMITH = 132
    EVENTTRIGGER_MASTER_BLACKSMITH_DONE = 133
    EVENTTRIGGER_BEST_DEFENSE = 134
    EVENTTRIGGER_BEST_DEFENSE_DONE = 135
    EVENTTRIGGER_SPORTS_LEAGUE = 136
    EVENTTRIGGER_SPORTS_LEAGUE_DONE = 137
    EVENTTRIGGER_CRUSADE = 138
    EVENTTRIGGER_CRUSADE_DONE = 139
    EVENTTRIGGER_MIRACLE = 140
    EVENTTRIGGER_ESTEEMED_PLAYWRIGHT = 141
    EVENTTRIGGER_FAVORITE_SON = 142
    EVENTTRIGGER_SECRET_KNOWLEDGE = 143
    EVENTTRIGGER_HIGH_WARLORD = 144
    EVENTTRIGGER_SPOILED_GRAIN = 145
    EVENTTRIGGER_ANGEL_OF_MERCY = 146
    EVENTTRIGGER_CHILLY_FLIGHT = 147
    EVENTTRIGGER_INDUSTRIAL_FIRE = 148
    EVENTTRIGGER_LABORATORY = 149
    EVENTTRIGGER_EXPERIENCED_CAPTAIN = 150
    EVENTTRIGGER_HERESY = 151
    EVENTTRIGGER_PARTISANS = 152
    EVENTTRIGGER_NEW_DYNASTY = 153
    EVENTTRIGGER_CRISIS_IN_THE_SENATE = 154
    EVENTTRIGGER_TOO_CLOSE_TO_CALL = 155
    EVENTTRIGGER_CHARISMATIC = 156
    EVENTTRIGGER_FRIENDLY_LOCALS = 157
    EVENTTRIGGER_GREED = 158
    EVENTTRIGGER_GREED_DONE = 159
    EVENTTRIGGER_WAR_CHARIOTS = 160
    EVENTTRIGGER_WAR_CHARIOTS_DONE = 161
    EVENTTRIGGER_ELITE_SWORDS = 162
    EVENTTRIGGER_ELITE_SWORDS_DONE = 163
    EVENTTRIGGER_WARSHIPS = 164
    EVENTTRIGGER_WARSHIPS_DONE = 165
    EVENTTRIGGER_GUNS_BUTTER = 166
    EVENTTRIGGER_GUNS_BUTTER_DONE = 167
    EVENTTRIGGER_NOBLE_KNIGHTS = 168
    EVENTTRIGGER_NOBLE_KNIGHTS_DONE = 169
    EVENTTRIGGER_OVERWHELM = 170
    EVENTTRIGGER_OVERWHELM_DONE = 171
    EVENTTRIGGER_CORPORATE_EXPANSION = 172
    EVENTTRIGGER_CORPORATE_EXPANSION_DONE = 173
    EVENTTRIGGER_HOSTILE_TAKEOVER = 174
    EVENTTRIGGER_HOSTILE_TAKEOVER_DONE = 175
    EVENTTRIGGER_CIV_GAME = 176
    EVENTTRIGGER_SLAVE_REVOLT_WARNING = 177
    EVENTTRIGGER_IMMIGRANTS = 178
    EVENTTRIGGER_HEALING_PLANT = 179
    EVENTTRIGGER_GREAT_BEAST = 180
    EVENTTRIGGER_CONTROVERSIAL_PHILOSOPHER = 181
    EVENTTRIGGER_DEFECTING_AGENT = 182
    EVENTTRIGGER_JAIL = 183
    EVENTTRIGGER_SPY_DISCOVERED = 184
    EVENTTRIGGER_NUCLEAR_PROTEST = 185
    EVENTTRIGGER_BETTER_COAL = 186
    EVENTTRIGGER_BROKEN_DAM = 187
    EVENTTRIGGER_RABBI = 188
    EVENTTRIGGER_GOLDEN_BUDDHA = 189
    EVENTTRIGGER_PREACHING_RESEARCHER = 190
    EVENTTRIGGER_TOXCATL = 191
    EVENTTRIGGER_DISSIDENT_PRIEST = 192
    EVENTTRIGGER_PASTURE_BUILT = 193
    EVENTTRIGGER_ROGUE_STATION = 194
    EVENTTRIGGER_ANTIMONARCHISTS = 195
    EVENTTRIGGER_IMPEACHMENT = 196


class CivicType(IntEnum):  # noqa: D101
    NO_CIVIC = -1
    CIVIC_DESPOTISM = 0
    CIVIC_HEREDITARY_RULE = 1
    CIVIC_REPRESENTATION = 2
    CIVIC_POLICE_STATE = 3
    CIVIC_UNIVERSAL_SUFFRAGE = 4
    CIVIC_BARBARISM = 5
    CIVIC_VASSALAGE = 6
    CIVIC_BUREAUCRACY = 7
    CIVIC_NATIONHOOD = 8
    CIVIC_FREE_SPEECH = 9
    CIVIC_TRIBALISM = 10
    CIVIC_SLAVERY = 11
    CIVIC_SERFDOM = 12
    CIVIC_CASTE_SYSTEM = 13
    CIVIC_EMANCIPATION = 14
    CIVIC_DECENTRALIZATION = 15
    CIVIC_MERCANTILISM = 16
    CIVIC_FREE_MARKET = 17
    CIVIC_STATE_PROPERTY = 18
    CIVIC_ENVIRONMENTALISM = 19
    CIVIC_PAGANISM = 20
    CIVIC_ORGANIZED_RELIGION = 21
    CIVIC_THEOCRACY = 22
    CIVIC_PACIFISM = 23
    CIVIC_FREE_RELIGION = 24


class CommerceType(IntEnum):  # noqa: D101
    NO_COMMERCE = -1
    COMMERCE_GOLD = 0
    COMMERCE_RESEARCH = 1
    COMMERCE_CULTURE = 2
    COMMERCE_ESPIONAGE = 3


class CorporationType(IntEnum):  # noqa: D101
    NO_CORPORATION = -1
    CORPORATION_1 = 0
    CORPORATION_2 = 1
    CORPORATION_3 = 2
    CORPORATION_4 = 3
    CORPORATION_5 = 4
    CORPORATION_6 = 5
    CORPORATION_7 = 6


class CursorType(IntEnum):  # noqa: D101
    NO_CURSOR = -1
    CURSOR_DEFAULT = 0
    CURSOR_PING = 1
    CURSOR_GO_TO = 2
    CURSOR_ROUTE_TO = 3
    CURSOR_AIRLIFT = 4
    CURSOR_NUKE = 5
    CURSOR_AIRSTRIKE = 6
    CURSOR_RECON = 7
    CURSOR_PARADROP = 8
    CURSOR_AIRBOMB = 9
    CURSOR_REBASE = 10
    CURSOR_BUSY = 11
    CURSOR_MOVE = 12
    CURSOR_SPLITV = 13
    CURSOR_SPLITH = 14
    CURSOR_SIZEV = 15
    CURSOR_SIZEH = 16
    CURSOR_SIZENE = 17
    CURSOR_SIZENW = 18
    CURSOR_SIZEALL = 19
    CURSOR_LINK = 20
    CURSOR_GRIP = 21
    CURSOR_EDIT = 22


class DiplomacyType(IntEnum):  # noqa: D101
    NO_DIPLOMACY = -1
    AI_DIPLOCOMMENT_DECLARE_WAR = 0
    AI_DIPLOCOMMENT_NO_VASSAL = 1
    AI_DIPLOCOMMENT_OFFER_VASSAL = 2
    AI_DIPLOCOMMENT_FIRST_CONTACT = 3
    AI_DIPLOCOMMENT_REFUSE_TO_TALK = 4
    AI_DIPLOCOMMENT_PEACE = 5
    AI_DIPLOCOMMENT_NO_PEACE = 6
    AI_DIPLOCOMMENT_GREETINGS = 7
    AI_DIPLOCOMMENT_TRADING = 8
    AI_DIPLOCOMMENT_ACCEPT = 9
    AI_DIPLOCOMMENT_REJECT = 10
    AI_DIPLOCOMMENT_GLAD = 11
    AI_DIPLOCOMMENT_SORRY = 12
    AI_DIPLOCOMMENT_TRY_THIS_DEAL = 13
    AI_DIPLOCOMMENT_NO_DEAL = 14
    AI_DIPLOCOMMENT_OFFER_PEACE = 15
    AI_DIPLOCOMMENT_OFFER_CITY = 16
    AI_DIPLOCOMMENT_OFFER_DEAL = 17
    AI_DIPLOCOMMENT_CANCEL_DEAL = 18
    AI_DIPLOCOMMENT_THANKS = 19
    AI_DIPLOCOMMENT_CURRENT_DEALS = 20
    AI_DIPLOCOMMENT_ACCEPT_ASK = 21
    AI_DIPLOCOMMENT_REJECT_ASK = 22
    AI_DIPLOCOMMENT_ACCEPT_DEMAND = 23
    AI_DIPLOCOMMENT_REJECT_DEMAND = 24
    AI_DIPLOCOMMENT_ACCEPT_DEMAND_TEAM = 25
    AI_DIPLOCOMMENT_GIVE_HELP = 26
    AI_DIPLOCOMMENT_ASK_FOR_HELP = 27
    AI_DIPLOCOMMENT_HELP_REFUSED = 28
    AI_DIPLOCOMMENT_DEMAND_TRIBUTE = 29
    AI_DIPLOCOMMENT_DEMAND_REJECTED = 30
    AI_DIPLOCOMMENT_RELIGION_PRESSURE = 31
    AI_DIPLOCOMMENT_RELIGION_DENIED = 32
    AI_DIPLOCOMMENT_CIVIC_PRESSURE = 33
    AI_DIPLOCOMMENT_CIVIC_DENIED = 34
    AI_DIPLOCOMMENT_JOIN_WAR = 35
    AI_DIPLOCOMMENT_JOIN_DENIED = 36
    AI_DIPLOCOMMENT_STOP_TRADING = 37
    AI_DIPLOCOMMENT_STOP_DENIED = 38
    AI_DIPLOCOMMENT_UNIT_BRAG = 39
    AI_DIPLOCOMMENT_NUKES = 40
    AI_DIPLOCOMMENT_WORST_ENEMY = 41
    AI_DIPLOCOMMENT_WORST_ENEMY_TRADING = 42
    AI_DIPLOCOMMENT_SOMETHING_ELSE = 43
    AI_DIPLOCOMMENT_RESEARCH = 44
    AI_DIPLOCOMMENT_RESEARCH_TECH = 45
    AI_DIPLOCOMMENT_ATTITUDE = 46
    AI_DIPLOCOMMENT_ATTITUDE_PLAYER_FURIOUS = 47
    AI_DIPLOCOMMENT_ATTITUDE_PLAYER_ANNOYED = 48
    AI_DIPLOCOMMENT_ATTITUDE_PLAYER_CAUTIOUS = 49
    AI_DIPLOCOMMENT_ATTITUDE_PLAYER_PLEASED = 50
    AI_DIPLOCOMMENT_ATTITUDE_PLAYER_FRIENDLY = 51
    AI_DIPLOCOMMENT_TARGET = 52
    AI_DIPLOCOMMENT_TARGET_CITY = 53
    AI_DIPLOCOMMENT_WELL = 54
    USER_DIPLOCOMMENT_WAR_RESPONSE = 55
    USER_DIPLOCOMMENT_PEACE = 56
    USER_DIPLOCOMMENT_WAR = 57
    USER_DIPLOCOMMENT_PROPOSE = 58
    USER_DIPLOCOMMENT_ACCEPT = 59
    USER_DIPLOCOMMENT_REJECT = 60
    USER_DIPLOCOMMENT_OFFER = 61
    USER_DIPLOCOMMENT_GIFT = 62
    USER_DIPLOCOMMENT_NEVERMIND = 63
    USER_DIPLOCOMMENT_PROPOSAL = 64
    USER_DIPLOCOMMENT_COMPLETE_DEAL = 65
    USER_DIPLOCOMMENT_FISH_FOR_DEAL = 66
    USER_DIPLOCOMMENT_SUGGEST_PEACE = 67
    USER_DIPLOCOMMENT_OFFER_PEACE = 68
    USER_DIPLOCOMMENT_CURRENT_DEALS = 69
    USER_DIPLOCOMMENT_ASK = 70
    USER_DIPLOCOMMENT_DEMAND = 71
    USER_DIPLOCOMMENT_VASSAL_TRIBUTE = 72
    USER_DIPLOCOMMENT_DEMAND_TEAM = 73
    USER_DIPLOCOMMENT_ACCEPT_OFFER = 74
    USER_DIPLOCOMMENT_REJECT_OFFER = 75
    USER_DIPLOCOMMENT_RENEGOTIATE = 76
    USER_DIPLOCOMMENT_NO_RENEGOTIATE = 77
    USER_DIPLOCOMMENT_GIVE_HELP = 78
    USER_DIPLOCOMMENT_REFUSE_HELP = 79
    USER_DIPLOCOMMENT_ACCEPT_DEMAND = 80
    USER_DIPLOCOMMENT_REJECT_DEMAND = 81
    USER_DIPLOCOMMENT_CONVERT = 82
    USER_DIPLOCOMMENT_NO_CONVERT = 83
    USER_DIPLOCOMMENT_REVOLUTION = 84
    USER_DIPLOCOMMENT_NO_REVOLUTION = 85
    USER_DIPLOCOMMENT_JOIN_WAR = 86
    USER_DIPLOCOMMENT_NO_JOIN_WAR = 87
    USER_DIPLOCOMMENT_STOP_TRADING = 88
    USER_DIPLOCOMMENT_NO_STOP_TRADING = 89
    USER_DIPLOCOMMENT_SOMETHING_ELSE = 90
    USER_DIPLOCOMMENT_RESEARCH = 91
    USER_DIPLOCOMMENT_RESEARCH_TECH = 92
    USER_DIPLOCOMMENT_ATTITUDE = 93
    USER_DIPLOCOMMENT_ATTITUDE_PLAYER = 94
    USER_DIPLOCOMMENT_TARGET = 95
    USER_DIPLOCOMMENT_TARGET_CITY = 96
    USER_DIPLOCOMMENT_EXIT = 97


class EraType(IntEnum):  # noqa: D101
    NO_ERA = -1
    ERA_ANCIENT = 0
    ERA_CLASSICAL = 1
    ERA_MEDIEVAL = 2
    ERA_RENAISSANCE = 3
    ERA_INDUSTRIAL = 4
    ERA_MODERN = 5
    ERA_FUTURE = 6


class EspionageMissionType(IntEnum):  # noqa: D101
    NO_ESPIONAGE_MISSION = -1
    ESPIONAGEMISSION_SEE_DEMOGRAPHICS = 0
    ESPIONAGEMISSION_CITY_VISIBILITY = 1
    ESPIONAGEMISSION_INVESTIGATE_CITY = 2
    ESPIONAGEMISSION_SEE_RESEARCH = 3
    ESPIONAGEMISSION_NO_ACTIVE_MISSIONS = 4
    ESPIONAGEMISSION_DESTROY_IMPROVEMENT = 5
    ESPIONAGEMISSION_DESTROY_BUILDING = 6
    ESPIONAGEMISSION_DESTROY_PROJECT = 7
    ESPIONAGEMISSION_DESTROY_PRODUCTION = 8
    ESPIONAGEMISSION_STEAL_TREASURY = 9
    ESPIONAGEMISSION_CITY_INSERT_CULTURE = 10
    ESPIONAGEMISSION_CITY_POISON_WATER = 11
    ESPIONAGEMISSION_CITY_UNHAPPINESS = 12
    ESPIONAGEMISSION_CITY_REVOLT = 13
    ESPIONAGEMISSION_BUY_TECH = 14
    ESPIONAGEMISSION_SWITCH_CIVIC = 15
    ESPIONAGEMISSION_SWITCH_RELIGION = 16
    ESPIONAGEMISSION_COUNTERESPIONAGE = 17


class ForceControlType(IntEnum):  # noqa: D101
    NO_FORCE_CONTROL = -1
    FORCECONTROL_SPEED = 0
    FORCECONTROL_HANDICAP = 1
    FORCECONTROL_OPTIONS = 2
    FORCECONTROL_VICTORIES = 3
    FORCECONTROL_MAX_TURNS = 4
    FORCECONTROL_MAX_CITY_ELIMINATION = 5
    FORCECONTROL_ADVANCED_START = 6


class GameOptionType(IntEnum):  # noqa: D101
    NO_GAME_OPTION = -1
    GAMEOPTION_ADVANCED_START = 0
    GAMEOPTION_NO_CITY_RAZING = 1
    GAMEOPTION_NO_CITY_FLIPPING = 2
    GAMEOPTION_FLIPPING_AFTER_CONQUEST = 3
    GAMEOPTION_NO_BARBARIANS = 4
    GAMEOPTION_RAGING_BARBARIANS = 5
    GAMEOPTION_AGGRESSIVE_AI = 6
    GAMEOPTION_LEAD_ANY_CIV = 7
    GAMEOPTION_RANDOM_PERSONALITIES = 8
    GAMEOPTION_PICK_RELIGION = 9
    GAMEOPTION_NO_TECH_TRADING = 10
    GAMEOPTION_NO_TECH_BROKERING = 11
    GAMEOPTION_PERMANENT_ALLIANCES = 12
    GAMEOPTION_ALWAYS_WAR = 13
    GAMEOPTION_ALWAYS_PEACE = 14
    GAMEOPTION_ONE_CITY_CHALLENGE = 15
    GAMEOPTION_NO_CHANGING_WAR_PEACE = 16
    GAMEOPTION_NEW_RANDOM_SEED = 17
    GAMEOPTION_LOCK_MODS = 18
    GAMEOPTION_COMPLETE_KILLS = 19
    GAMEOPTION_NO_VASSAL_STATES = 20
    GAMEOPTION_NO_GOODY_HUTS = 21
    GAMEOPTION_NO_EVENTS = 22
    GAMEOPTION_NO_ESPIONAGE = 23


class MultiplayerOptionType(IntEnum):  # noqa: D101
    NO_MPOPTION = -1
    MPOPTION_SIMULTANEOUS_TURNS = 0
    MPOPTION_TAKEOVER_AI = 1
    MPOPTION_SHUFFLE_TEAMS = 2
    MPOPTION_ANONYMOUS = 3
    MPOPTION_TURN_TIMER = 4


class GameSpeedType(IntEnum):  # noqa: D101
    NO_GAME_SPEED = -1
    GAMESPEED_MARATHON = 0
    GAMESPEED_EPIC = 1
    GAMESPEED_NORMAL = 2
    GAMESPEED_QUICK = 3


class GraphicOptionType(IntEnum):  # noqa: D101
    NO_GRAPHIC_OPTION = -1
    GRAPHICOPTION_SINGLE_UNIT_GRAPHICS = 0
    GRAPHICOPTION_HEALTH_BARS = 1
    GRAPHICOPTION_NO_COMBAT_ZOOM = 2
    GRAPHICOPTION_NO_ENEMY_GLOW = 3
    GRAPHICOPTION_FROZEN_ANIMATIONS = 4
    GRAPHICOPTION_EFFECTS_DISABLED = 5
    GRAPHICOPTION_GLOBE_VIEW_BUILDINGS_DISABLED = 6
    GRAPHICOPTION_FULLSCREEN = 7
    GRAPHICOPTION_LOWRES_TEXTURES = 8
    GRAPHICOPTION_HIRES_TERRAIN = 9
    GRAPHICOPTION_NO_MOVIES = 10
    GRAPHICOPTION_CITY_RADIUS = 11


class HandicapType(IntEnum):  # noqa: D101
    NO_HANDICAP = -1
    HANDICAP_SETTLER = 0
    HANDICAP_CHIEFTAIN = 1
    HANDICAP_WARLORD = 2
    HANDICAP_NOBLE = 3
    HANDICAP_PRINCE = 4
    HANDICAP_MONARCH = 5
    HANDICAP_EMPEROR = 6
    HANDICAP_IMMORTAL = 7
    HANDICAP_DEITY = 8


class MPOptionType(IntEnum):  # noqa: D101
    NO_M_P_OPTION = -1
    MPOPTION_SIMULTANEOUS_TURNS = 0
    MPOPTION_TAKEOVER_AI = 1
    MPOPTION_SHUFFLE_TEAMS = 2
    MPOPTION_ANONYMOUS = 3
    MPOPTION_TURN_TIMER = 4


class PlayerOptionType(IntEnum):  # noqa: D101
    NO_PLAYER_OPTION = -1
    PLAYEROPTION_ADVISOR_POPUPS = 0
    PLAYEROPTION_ADVISOR_HELP = 1
    PLAYEROPTION_WAIT_END_TURN = 2
    PLAYEROPTION_MINIMIZE_POP_UPS = 3
    PLAYEROPTION_SHOW_FRIENDLY_MOVES = 4
    PLAYEROPTION_SHOW_ENEMY_MOVES = 5
    PLAYEROPTION_QUICK_MOVES = 6
    PLAYEROPTION_QUICK_ATTACK = 7
    PLAYEROPTION_QUICK_DEFENSE = 8
    PLAYEROPTION_STACK_ATTACK = 9
    PLAYEROPTION_AUTO_PROMOTION = 10
    PLAYEROPTION_START_AUTOMATED = 11
    PLAYEROPTION_SAFE_AUTOMATION = 12
    PLAYEROPTION_NUMPAD_HELP = 13
    PLAYEROPTION_NO_UNIT_CYCLING = 14
    PLAYEROPTION_NO_UNIT_RECOMMENDATIONS = 15
    PLAYEROPTION_RIGHT_CLICK_MENU = 16
    PLAYEROPTION_LEAVE_FORESTS = 17
    PLAYEROPTION_MISSIONARIES_AUTOMATED = 18
    PLAYEROPTION_MODDER_1 = 19
    PLAYEROPTION_MODDER_2 = 20
    PLAYEROPTION_MODDER_3 = 21


class ProjectType(IntEnum):  # noqa: D101
    NO_PROJECT = -1
    PROJECT_MANHATTAN_PROJECT = 0
    PROJECT_THE_INTERNET = 1
    PROJECT_SDI = 2
    PROJECT_APOLLO_PROGRAM = 3
    PROJECT_SS_COCKPIT = 4
    PROJECT_SS_LIFE_SUPPORT = 5
    PROJECT_SS_STASIS_CHAMBER = 6
    PROJECT_SS_DOCKING_BAY = 7
    PROJECT_SS_ENGINE = 8
    PROJECT_SS_CASING = 9
    PROJECT_SS_THRUSTERS = 10


class ReligionType(IntEnum):  # noqa: D101
    NO_RELIGION = -1
    RELIGION_JUDAISM = 0
    RELIGION_CHRISTIANITY = 1
    RELIGION_ISLAM = 2
    RELIGION_HINDUISM = 3
    RELIGION_BUDDHISM = 4
    RELIGION_CONFUCIANISM = 5
    RELIGION_TAOISM = 6


class SpecialistType(IntEnum):  # noqa: D101
    NO_SPECIALIST = -1
    SPECIALIST_CITIZEN = 0
    SPECIALIST_PRIEST = 1
    SPECIALIST_ARTIST = 2
    SPECIALIST_SCIENTIST = 3
    SPECIALIST_MERCHANT = 4
    SPECIALIST_ENGINEER = 5
    SPECIALIST_SPY = 6
    SPECIALIST_GREAT_PRIEST = 7
    SPECIALIST_GREAT_ARTIST = 8
    SPECIALIST_GREAT_SCIENTIST = 9
    SPECIALIST_GREAT_MERCHANT = 10
    SPECIALIST_GREAT_ENGINEER = 11
    SPECIALIST_GREAT_GENERAL = 12
    SPECIALIST_GREAT_SPY = 13


class VictoryType(IntEnum):  # noqa: D101
    NO_VICTORY = -1
    VICTORY_SCORE = 0
    VICTORY_TIME = 1
    VICTORY_CONQUEST = 2
    VICTORY_DOMINATION = 3
    VICTORY_CULTURAL = 4
    VICTORY_SPACE_RACE = 5
    VICTORY_DIPLOMATIC = 6


class VoteType(IntEnum):  # noqa: D101
    NO_VOTE = -1
    VOTE_SECRETARY_GENERAL = 0
    VOTE_VICTORY = 1
    VOTE_SINGLE_CURRENCY = 2
    VOTE_FREE_TRADE = 3
    VOTE_NO_NUKES = 4
    VOTE_UNIVERSAL_SUFFRAGE = 5
    VOTE_FREE_SPEECH = 6
    VOTE_EMANCIPATION = 7
    VOTE_ENVIRONMENTALISM = 8
    VOTE_FREE_RELIGION = 9
    VOTE_UN_FORCE_PEACE = 10
    VOTE_UN_FORCE_NO_TRADE = 11
    VOTE_UN_FORCE_WAR = 12
    VOTE_UN_ASSIGN_CITY = 13
    VOTE_POPE = 14
    VOTE_RELIGIOUS_VICTORY = 15
    VOTE_OPEN_BORDERS = 16
    VOTE_DEFENSIVE_PACT = 17
    VOTE_FORCE_PEACE = 18
    VOTE_FORCE_NO_TRADE = 19
    VOTE_FORCE_WAR = 20
    VOTE_ASSIGN_CITY = 21


class VoteSourceType(IntEnum):  # noqa: D101
    NO_VOTE_SOURCE = -1
    DIPLOVOTE_UN = 0
    DIPLOVOTE_POPE = 1


class PlayerVoteType(IntEnum):  # noqa: D101
    NO_PLAYER_VOTE_CHECKED = -6
    PLAYER_VOTE_NEVER = -5
    PLAYER_VOTE_ABSTAIN = -4
    PLAYER_VOTE_NO = -3
    PLAYER_VOTE_YES = -2
    NO_PLAYER_VOTE = -1


class WorldType(IntEnum):  # noqa: D101
    NO_WORLD = -1
    WORLDSIZE_DUEL = 0
    WORLDSIZE_TINY = 1
    WORLDSIZE_SMALL = 2
    WORLDSIZE_STANDARD = 3
    WORLDSIZE_LARGE = 4
    WORLDSIZE_HUGE = 5


class ColorValsType(IntEnum):  # noqa: D101
    NO_COLOR_VALS = -1
    COLOR_CLEAR = 0
    COLOR_ALPHA_GREY = 1
    COLOR_WHITE = 2
    COLOR_BLACK = 3
    COLOR_DARK_GREY = 4
    COLOR_GREY = 5
    COLOR_LIGHT_GREY = 6
    COLOR_RED = 7
    COLOR_GREEN = 8
    COLOR_BLUE = 9
    COLOR_CYAN = 10
    COLOR_YELLOW = 11
    COLOR_MAGENTA = 12
    COLOR_YIELD_FOOD = 13
    COLOR_YIELD_PRODUCTION = 14
    COLOR_YIELD_COMMERCE = 15
    COLOR_CITY_BLUE = 16
    COLOR_CITY_GREY = 17
    COLOR_CITY_BROWN = 18
    COLOR_CITY_GREEN = 19
    COLOR_FONT_RED = 20
    COLOR_FONT_GREEN = 21
    COLOR_RESEARCH_STORED = 22
    COLOR_RESEARCH_RATE = 23
    COLOR_CULTURE_STORED = 24
    COLOR_CULTURE_RATE = 25
    COLOR_GREAT_PEOPLE_STORED = 26
    COLOR_GREAT_PEOPLE_RATE = 27
    COLOR_NEGATIVE_RATE = 28
    COLOR_EMPTY = 29
    COLOR_POPUP_TEXT = 30
    COLOR_POPUP_SELECTED = 31
    COLOR_TECH_TEXT = 32
    COLOR_UNIT_TEXT = 33
    COLOR_BUILDING_TEXT = 34
    COLOR_PROJECT_TEXT = 35
    COLOR_HIGHLIGHT_TEXT = 36
    COLOR_ALT_HIGHLIGHT_TEXT = 37
    COLOR_WARNING_TEXT = 38
    COLOR_POSITIVE_TEXT = 39
    COLOR_NEGATIVE_TEXT = 40
    COLOR_BROWN_TEXT = 41
    COLOR_SELECTED_TEXT = 42
    COLOR_WATER_TEXT = 43
    COLOR_MENU_BLUE = 44
    COLOR_DAWN_OF_MAN_TEXT = 45
    COLOR_TECH_GREEN = 46
    COLOR_TECH_BLUE = 47
    COLOR_TECH_WORKING = 48
    COLOR_TECH_BLACK = 49
    COLOR_TECH_RED = 50
    COLOR_PLAYER_BLACK = 51
    COLOR_PLAYER_BLACK_TEXT = 52
    COLOR_PLAYER_BLUE = 53
    COLOR_PLAYER_LIGHT_BLUE_TEXT = 54
    COLOR_PLAYER_BROWN = 55
    COLOR_PLAYER_BROWN_TEXT = 56
    COLOR_PLAYER_CYAN = 57
    COLOR_PLAYER_CYAN_TEXT = 58
    COLOR_PLAYER_DARK_BLUE = 59
    COLOR_PLAYER_DARK_BLUE_TEXT = 60
    COLOR_PLAYER_DARK_CYAN = 61
    COLOR_PLAYER_DARK_CYAN_TEXT = 62
    COLOR_PLAYER_DARK_GREEN = 63
    COLOR_PLAYER_DARK_DARK_GREEN = 64
    COLOR_PLAYER_DARK_GREEN_TEXT = 65
    COLOR_PLAYER_DARK_PINK = 66
    COLOR_PLAYER_DARK_PINK_TEXT = 67
    COLOR_PLAYER_DARK_PURPLE = 68
    COLOR_PLAYER_DARK_PURPLE_TEXT = 69
    COLOR_PLAYER_DARK_RED = 70
    COLOR_PLAYER_DARK_RED_TEXT = 71
    COLOR_PLAYER_DARK_YELLOW = 72
    COLOR_PLAYER_DARK_YELLOW_TEXT = 73
    COLOR_PLAYER_GRAY = 74
    COLOR_PLAYER_GRAY_TEXT = 75
    COLOR_PLAYER_GREEN = 76
    COLOR_PLAYER_GREEN_TEXT = 77
    COLOR_PLAYER_ORANGE = 78
    COLOR_PLAYER_ORANGE_TEXT = 79
    COLOR_PLAYER_PEACH = 80
    COLOR_PLAYER_PEACH_TEXT = 81
    COLOR_PLAYER_PINK = 82
    COLOR_PLAYER_PINK_TEXT = 83
    COLOR_PLAYER_PURPLE = 84
    COLOR_PLAYER_PURPLE_TEXT = 85
    COLOR_PLAYER_RED = 86
    COLOR_PLAYER_RED_TEXT = 87
    COLOR_PLAYER_WHITE = 88
    COLOR_PLAYER_WHITE_TEXT = 89
    COLOR_PLAYER_YELLOW = 90
    COLOR_PLAYER_YELLOW_TEXT = 91
    COLOR_PLAYER_LIGHT_GREEN = 92
    COLOR_PLAYER_LIGHT_GREEN_TEXT = 93
    COLOR_PLAYER_LIGHT_BLUE = 94
    COLOR_PLAYER_BLUE_TEXT = 95
    COLOR_PLAYER_LIGHT_YELLOW = 96
    COLOR_PLAYER_LIGHT_YELLOW_TEXT = 97
    COLOR_PLAYER_LIGHT_PURPLE = 98
    COLOR_PLAYER_LIGHT_PURPLE_TEXT = 99
    COLOR_PLAYER_LIGHT_ORANGE = 100
    COLOR_PLAYER_LIGHT_ORANGE_TEXT = 101
    COLOR_PLAYER_MIDDLE_PURPLE = 102
    COLOR_PLAYER_MIDDLE_PURPLE_TEXT = 103
    COLOR_PLAYER_GOLDENROD = 104
    COLOR_PLAYER_DARK_GRAY = 105
    COLOR_PLAYER_DARK_GRAY_TEXT = 106
    COLOR_PLAYER_MIDDLE_GREEN = 107
    COLOR_PLAYER_MIDDLE_GREEN_TEXT = 108
    COLOR_PLAYER_DARK_LEMON = 109
    COLOR_PLAYER_DARK_LEMON_TEXT = 110
    COLOR_PLAYER_MIDDLE_BLUE = 111
    COLOR_PLAYER_MIDDLE_BLUE_TEXT = 112
    COLOR_PLAYER_MIDDLE_CYAN = 113
    COLOR_PLAYER_MIDDLE_CYAN_TEXT = 114
    COLOR_PLAYER_MAROON = 115
    COLOR_PLAYER_LIGHT_BROWN = 116
    COLOR_PLAYER_LIGHT_BROWN_TEXT = 117
    COLOR_PLAYER_DARK_ORANGE = 118
    COLOR_PLAYER_DARK_ORANGE_TEXT = 119
    COLOR_PLAYER_DARK_DARK_GREEN_TEXT = 120
    COLOR_PLAYER_PALE_RED = 121
    COLOR_PLAYER_DARK_INDIGO = 122
    COLOR_PLAYER_DARK_INDIGO_TEXT = 123
    COLOR_PLAYER_PALE_ORANGE = 124
    COLOR_PLAYER_LIGHT_BLACK = 125
    COLOR_PLAYER_LIGHT_BLACK_TEXT = 126


class InterfaceModeType(IntEnum):  # noqa: D101
    NO_INTERFACE_MODE = -1
    INTERFACEMODE_SELECTION = 0
    INTERFACEMODE_PING = 1
    INTERFACEMODE_SIGN = 2
    INTERFACEMODE_GRIP = 3
    INTERFACEMODE_GLOBELAYER_INPUT = 4
    INTERFACEMODE_GO_TO = 5
    INTERFACEMODE_GO_TO_TYPE = 6
    INTERFACEMODE_GO_TO_ALL = 7
    INTERFACEMODE_ROUTE_TO = 8
    INTERFACEMODE_AIRLIFT = 9
    INTERFACEMODE_NUKE = 10
    INTERFACEMODE_RECON = 11
    INTERFACEMODE_PARADROP = 12
    INTERFACEMODE_AIRBOMB = 13
    INTERFACEMODE_RANGE_ATTACK = 14
    INTERFACEMODE_AIRSTRIKE = 15
    INTERFACEMODE_REBASE = 16
    INTERFACEMODE_PYTHON_PICK_PLOT = 17
    INTERFACEMODE_SAVE_PLOT_NIFS = 18


class PlayerColorType(IntEnum):  # noqa: D101
    NO_PLAYER_COLOR = -1
    PLAYERCOLOR_BLACK = 0
    PLAYERCOLOR_BLUE = 1
    PLAYERCOLOR_BROWN = 2
    PLAYERCOLOR_CYAN = 3
    PLAYERCOLOR_DARK_BLUE = 4
    PLAYERCOLOR_DARK_CYAN = 5
    PLAYERCOLOR_DARK_GREEN = 6
    PLAYERCOLOR_DARK_PINK = 7
    PLAYERCOLOR_DARK_PURPLE = 8
    PLAYERCOLOR_DARK_RED = 9
    PLAYERCOLOR_DARK_YELLOW = 10
    PLAYERCOLOR_GRAY = 11
    PLAYERCOLOR_GREEN = 12
    PLAYERCOLOR_ORANGE = 13
    PLAYERCOLOR_PEACH = 14
    PLAYERCOLOR_PINK = 15
    PLAYERCOLOR_PURPLE = 16
    PLAYERCOLOR_RED = 17
    PLAYERCOLOR_WHITE = 18
    PLAYERCOLOR_YELLOW = 19
    PLAYERCOLOR_LIGHT_GREEN = 20
    PLAYERCOLOR_LIGHT_BLUE = 21
    PLAYERCOLOR_LIGHT_YELLOW = 22
    PLAYERCOLOR_LIGHT_PURPLE = 23
    PLAYERCOLOR_LIGHT_ORANGE = 24
    PLAYERCOLOR_MIDDLE_PURPLE = 25
    PLAYERCOLOR_DARK_GRAY = 26
    PLAYERCOLOR_MIDDLE_GREEN = 27
    PLAYERCOLOR_DARK_LEMON = 28
    PLAYERCOLOR_MIDDLE_BLUE = 29
    PLAYERCOLOR_MIDDLE_CYAN = 30
    PLAYERCOLOR_LIGHT_BROWN = 31
    PLAYERCOLOR_DARK_ORANGE = 32
    PLAYERCOLOR_DARK_DARK_GREEN = 33
    PLAYERCOLOR_DARK_INDIGO = 34
    PLAYERCOLOR_RED_AND_GOLD = 35
    PLAYERCOLOR_GOLD_AND_BLACK = 36
    PLAYERCOLOR_GREEN_AND_BLACK = 37
    PLAYERCOLOR_DARK_CYAN_AND_LEMON = 38
    PLAYERCOLOR_BLACK_AND_GREEN = 39
    PLAYERCOLOR_GREEN_AND_WHITE = 40
    PLAYERCOLOR_CYAN_AND_GRAY = 41
    PLAYERCOLOR_DARK_INDIGO_AND_WHITE = 42
    PLAYERCOLOR_ORANGE_AND_GREEN = 43


class AttachableType(IntEnum):  # noqa: D101
    NO_ATTACHABLE = -1
    ATTACHABLE_SMOKE = 0
    ATTACHABLE_AIRDEBRIS = 1
    ATTACHABLE_TANK_DAMAGE_SMOKE = 2
    ATTACHABLE_ARTILLERY_DAMAGE_SMOKE = 3
    ATTACHABLE_CANNON_DAMAGE_SMOKE = 4
    ATTACHABLE_MACHINEGUNNER_DAMAGE_SMOKE = 5
    ATTACHABLE_GUNSHIP_DAMAGE_SMOKE = 6
    ATTACHABLE_CATAPULT_DAMAGE_SMOKE = 7
    ATTACHABLE_CARAVEL_DAMAGE_SMOKE = 8
    ATTACHABLE_FRIGATE_DAMAGE_SMOKE = 9
    ATTACHABLE_IRONCLAD_DAMAGE_SMOKE = 10
    ATTACHABLE_GALLEON_DAMAGE_SMOKE = 11
    ATTACHABLE_GALLEY_DAMAGE_SMOKE = 12
    ATTACHABLE_TRANSPORT_DAMAGE_SMOKE = 13
    ATTACHABLE_DESTROYER_DAMAGE_SMOKE = 14
    ATTACHABLE_BATTLESHIP_DAMAGE_SMOKE = 15
    ATTACHABLE_CARRIER_DAMAGE_SMOKE01 = 16
    ATTACHABLE_CARRIER_DAMAGE_SMOKE02 = 17
    ATTACHABLE_PLANE_DAMAGE_SMOKE = 18
    ATTACHABLE_JETFIGHTER_DAMAGE_SMOKE = 19
    ATTACHABLE_BOMBER_DAMAGE_SMOKE = 20
    ATTACHABLE_STEALTHBOMBER_DAMAGE_SMOKE = 21
    ATTACHABLE_IRONCLAD_SMOKESTACK_SMOKE = 22
    ATTACHABLE_JETFIGHTERBOMB_CONTRAIL = 23
    ATTACHABLE_JETFIGHTERMISSILE_CONTRAIL = 24
    ATTACHABLE_JETFIGHTER_AFTERBURN = 25
    ATTACHABLE_STEALTHBOMBERBOMB_CONTRAIL = 26
    ATTACHABLE_ICBM_AFTERBURN = 27
    ATTACHABLE_TORPEDO_BUBBLES = 28
    ATTACHABLE_SUBMARINE_BUBBLES = 29
    ATTACHABLE_SUBMARINE_SIDE_FROTH = 30
    ATTACHABLE_SUBMARINE_DAMAGE_SMOKE = 31
    ATTACHABLE_BATTLESHIP_BOW_FROTH = 32
    ATTACHABLE_BATTLESHIP_SIDE_FROTH = 33
    ATTACHABLE_CARRIER_BOW_FROTH = 34
    ATTACHABLE_CARRIER_SIDE_FROTH = 35
    ATTACHABLE_CARAVEL_BOW_FROTH = 36
    ATTACHABLE_CARAVEL_SIDE_FROTH = 37
    ATTACHABLE_DESTROYER_BOW_FROTH = 38
    ATTACHABLE_DESTROYER_SIDE_FROTH = 39
    ATTACHABLE_FRIGATE_BOW_FROTH = 40
    ATTACHABLE_FRIGATE_SIDE_FROTH = 41
    ATTACHABLE_GALLEON_BOW_FROTH = 42
    ATTACHABLE_GALLEON_SIDE_FROTH = 43
    ATTACHABLE_GALLEY_BOW_FROTH = 44
    ATTACHABLE_GALLEY_SIDE_FROTH = 45
    ATTACHABLE_IRONCLAD_BOW_FROTH = 46
    ATTACHABLE_IRONCLAD_SIDE_FROTH = 47
    ATTACHABLE_TRANSPORT_BOW_FROTH = 48
    ATTACHABLE_TRANSPORT_SIDE_FROTH = 49
    ATTACHABLE_WORKBOAT_BOW_FROTH = 50
    ATTACHABLE_WORKBOAT_SIDE_FROTH = 51
    ATTACHABLE_HIGHLIGHT_PROPHET = 52
    ATTACHABLE_HIGHLIGHT_SCIENTIST = 53
    ATTACHABLE_HIGHLIGHT_MERCHANT = 54
    ATTACHABLE_HIGHLIGHT_GREATARTIST = 55
    ATTACHABLE_HIGHLIGHT_ENGINEER = 56
    ATTACHABLE_HIGHLIGHT_WARLORD = 57
    ATTACHABLE_OMEN_SMOKE = 58
    ATTACHABLE_OMEN_SICK = 59
    ATTACHABLE_GOODYPOP = 60
    ATTACHABLE_IMPCAMPFIRE = 61
    ATTACHABLE_IMPCHIMNEYSMOKE_01 = 62
    ATTACHABLE_IMPFIREPLACEFIRE = 63
    ATTACHABLE_IMPSTEAM = 64
    ATTACHABLE_ICBM_GREENGLOW = 65
    ATTACHABLE_IMPFIREPLACEFIRE_BIG = 66
    ATTACHABLE_INVASIONSHIP_GLOW = 67
    ATTACHABLE_INVASIONSHIP_THRUST = 68
    ATTACHABLE_INVASIONSHIP_FORCEFIELD = 69
    ATTACHABLE_INVASIONSHIP_GLOW_BIG = 70


class EffectType(IntEnum):  # noqa: D101
    NO_EFFECT = -1
    EFFECT_FOOTSTEP_ON = 0
    EFFECT_FOOTSTEP = 1
    EFFECT_PING = 2
    EFFECT_RES_BOMB = 3
    EFFECT_STASIS = 4
    EFFECT_WAYPOINT = 5
    EFFECT_LASER_HIT = 6
    EFFECT_MINE = 7
    EFFECT_MUTINY = 8
    EFFECT_CANDLE_FLAME_FOR_RELIGION_POPUP = 9
    EFFECT_CANDLE_HWLIGHT_FOR_RELIGION_POPUP = 10
    EFFECT_FOOTPRINT = 11
    EFFECT_FOOTPRINT_80 = 12
    EFFECT_FOOTPRINT_60 = 13
    EFFECT_HORSEPRINT = 14
    EFFECT_BIGHORSEPRINT = 15
    EFFECT_PAWPRINT = 16
    EFFECT_MECHPRINT = 17
    FOOTPRINT = 18
    EFFECT_LONGBOWARROW = 19
    EFFECT_CROSSBOWBOLT = 20
    EFFECT_ARCHERARROW = 21
    EFFECT_CHINESEARROW = 22
    EFFECT_EGYPTIANARROW = 23
    EFFECT_EURASIANARROW = 24
    EFFECT_GALLEY_FIREARROW = 25
    EFFECT_CAMELARCHERARROW = 26
    EFFECT_HORSEARCHERARROW = 27
    EFFECT_MALISPEAR = 28
    EFFECT_CATAPULT_ROCK = 29
    EFFECT_GRENADE_THROW = 30
    EFFECT_HWACHA_ROCKET = 31
    EFFECT_SAM_ANTI_AIR_MISSLE = 32
    EFFECT_STONE_THROW = 33
    EFFECT_MONGOL_JAV = 34
    EFFECT_TREBUCHET_ROCK = 35
    EFFECT_SETTLERSMOKE = 36
    EFFECT_PACK_UP = 37
    EFFECT_MININGSPARK = 38
    EFFECT_DIGDIRT = 39
    EFFECT_THROWDIRT = 40
    EFFECT_FLINTSPARK = 41
    EFFECT_SPY_SABOTAGE = 42
    EFFECT_OMEN_HORSEMAN = 43
    EFFECT_SIEGE_TOWER_DIE = 44
    EFFECT_B52_BOMB_EXPLODE = 45
    EFFECT_JETFIGHTER_MISSILE = 46
    EFFECT_JETFIGHTER_BOMB = 47
    EFFECT_BOMBER_BOMB = 48
    EFFECT_STEALTHBOMBER_BOMB = 49
    EFFECT_JETFIGHTER_BOMB_EXPLODE = 50
    EFFECT_STEALTHBOMBER_BOMB_EXPLODE = 51
    EFFECT_BOMBER_BOMB_EXPLODE = 52
    EFFECT_STEALTH_BOMB_EXPLODE = 53
    EFFECT_STEALTH_BOMB_EXPLODE_2 = 54
    EFFECT_JET_MISSILE_EXPLODE = 55
    EFFECT_ICBM_NUCLEAR_EXPLOSION = 56
    EFFECT_ICBM_FIREBALL_SMALL = 57
    EFFECT_ICBM_FIREBALL_LARGE = 58
    EFFECT_ICBM_SW_LASER = 59
    EFFECT_BOULDER_IMPACT = 60
    EFFECT_CATAPULT_HIT_SMALL = 61
    EFFECT_CATAPULT_HIT_LARGE = 62
    EFFECT_ARTILLERY_SHELL_EXPLODE = 63
    EFFECT_CANNON_DEATH_FIRE = 64
    EFFECT_AIRPLANE_FIREBALL_LARGE = 65
    EFFECT_AIRPLANE_FIREBALL_SMALL = 66
    EFFECT_FIGHTER_FIREBALL_SMALL = 67
    EFFECT_FIGHTER_FIREBALL_LARGE = 68
    EFFECT_BOMBER_FIREBALL_SMALL = 69
    EFFECT_BOMBER_FIREBALL_LARGE = 70
    EFFECT_JETFIGHTER_FIREBALL_SMALL = 71
    EFFECT_JETFIGHTER_FIREBALL_LARGE = 72
    EFFECT_STEALTHBOMBER_FIREBALL_SMALL = 73
    EFFECT_STEALTHBOMBER_FIREBALL_LARGE = 74
    EFFECT_GUNSHIPSMALLEXPLODE01 = 75
    EFFECT_GUNSHIPSMALLEXPLODE02 = 76
    EFFECT_GUNSHIP_DEATH_EXPLOSION = 77
    EFFECT_GRENADIER_EXPLOSION = 78
    EFFECT_OILY_HIT = 79
    EFFECT_TRANSPORT_HIT01 = 80
    EFFECT_TRANSPORT_HIT02 = 81
    EFFECT_DESTROYER_HIT01 = 82
    EFFECT_DESTROYER_HIT02 = 83
    EFFECT_BATTLESHIP_HIT01 = 84
    EFFECT_BATTLESHIP_HIT02 = 85
    EFFECT_CARRIER_HIT01 = 86
    EFFECT_CARRIER_HIT02 = 87
    EFFECT_UNIT_DESTRUCTION_OILY_SMOKE = 88
    EFFECT_UNIT_DESTRUCTION_OILY_FIRE = 89
    EFFECT_LARGE_OILY_DEATH = 90
    EFFECT_LARGE_GUNPOWDER_DEATH = 91
    EFFECT_EXPLOSION_SHOCKWAVE = 92
    EFFECT_SHIP_GUNPOWDER_DEATH = 93
    EFFECT_SHIP_CARAVEL_DEATH = 94
    EFFECT_SHIP_GALLEON_DEATH = 95
    EFFECT_SHIP_FRIGATE_DEATH = 96
    EFFECT_SHIP_IRONCLAD_DEATH = 97
    EFFECT_SHIP_WORKBOATMODERN_DEATH = 98
    EFFECT_SHIP_TRANSPORT_DEATH = 99
    EFFECT_SHIP_DESTROYER_DEATH = 100
    EFFECT_SHIP_BATTLESHIP_DEATH = 101
    EFFECT_SHIP_CARRIER_DEATH01 = 102
    EFFECT_SHIP_CARRIER_DEATH02 = 103
    EFFECT_SHIP_OIL_DEATH = 104
    EFFECT_EXPLOSION_DIRT = 105
    EFFECT_EXPLOSION_ON_VEHICLE = 106
    EFFECT_TANKSMALLEXPLODE01 = 107
    EFFECT_TANKSMALLEXPLODE02 = 108
    EFFECT_TANKSMALLEXPLODE03 = 109
    EFFECT_PANZER_DEATH_EXPLOSION = 110
    EFFECT_ARTILLERY_HIT_SMALL01 = 111
    EFFECT_ARTILLERY_HIT_SMALL02 = 112
    EFFECT_ARTILLERY_DEATH_EXPLOSION = 113
    EFFECT_MACHINEGUNNER_HIT_SMALL01 = 114
    EFFECT_MACHINEGUNNER_HIT_SMALL02 = 115
    EFFECT_MACHINEGUNNER_DEATH_EXPLOSION = 116
    EFFECT_EXPLOSION_ON_PLANE = 117
    EFFECT_SMALL_PLANE_DEATH = 118
    EFFECT_LARGE_PLANE_DEATH = 119
    EFFECT_MACHINEGUN_VEHICLE_HIT = 120
    EFFECT_MACHINEGUN_DIRT_HIT = 121
    EFFECT_AIRCRAFT_MACHINE_GUN_IMPACT = 122
    EFFECT_CANNONBALL_IMPACT = 123
    EFFECT_SHIP_GUNPOWDER_HIT = 124
    EFFECT_CARAVEL_HIT01 = 125
    EFFECT_CARAVEL_HIT02 = 126
    EFFECT_GALLEON_HIT01 = 127
    EFFECT_GALLEON_HIT02 = 128
    EFFECT_FRIGATE_HIT01 = 129
    EFFECT_FRIGATE_HIT02 = 130
    EFFECT_IRONCLAD_HIT01 = 131
    EFFECT_IRONCLAD_HIT02 = 132
    EFFECT_WORKBOATMODERN_HIT01 = 133
    EFFECT_WORKBOATMODERN_HIT02 = 134
    EFFECT_SHIP_OIL_HIT = 135
    EFFECT_IMPACT_FLASH = 136
    EFFECT_SHIP_SUBMARINE_HIT = 137
    EFFECT_SUBMARINE_HIT_SPLASH = 138
    EFFECT_SUBMARINE_HIT_EXPLODE = 139
    EFFECT_SUBMARINE_DEATH = 140
    EFFECT_EXPLOSION_LARGE_001 = 141
    EFFECT_EXPLOSION_CITY = 142
    EFFECT_BOMBARD = 143
    EFFECT_EXPLOSION_02 = 144
    EFFECT_EXPLOSION_01 = 145
    EFFECT_CANNON_HIT_SMALL01 = 146
    EFFECT_CANNON_HIT_SMALL02 = 147
    EFFECT_CANNON_DEATH_EXPLOSION = 148
    EFFECT_WIND_SWIRL = 149
    EFFECT_SMOKE_JET_CONTRAIL = 150
    EFFECT_SMOKE_PROJECTILE_CONTRAIL = 151
    EFFECT_JET_AFTERBURN = 152
    EFFECT_MISSILE_AFTERBURN = 153
    EFFECT_BOMBER_BOMB_WIND = 154
    EFFECT_SMOKETRAIL = 155
    EFFECT_BOULDER_SMOKETRAIL = 156
    EFFECT_SMOKESTACK_SMOKE = 157
    EFFECT_HORSEHOOFDUST = 158
    EFFECT_TANK_EXHAUST = 159
    EFFECT_SHIP_DAMAGE_GUNPOWDER_SMOKE = 160
    EFFECT_SHIP_DAMAGE_FIREY_GUNPOWDER_SMOKE = 161
    EFFECT_SHIP_DAMAGE_OILY_SMOKE = 162
    EFFECT_SHIP_DAMAGE_FIREY_OILY_SMOKE = 163
    EFFECT_UNIT_DESTRUCTION_SMOKEY = 164
    EFFECT_UNIT_DESTRUCTION_FIRE = 165
    LOOPINGEFFECT_SMOKE = 166
    EFFECT_AIRCRAFT_MACHINE_GUN = 167
    EFFECT_GUNSHIP_MACHINE_GUN = 168
    EFFECT_CATAPULT_ROCK_EXPLODE = 169
    EFFECT_MACHINEGUNFIRE_AIR = 170
    EFFECT_FIGHTER_MACHINE_GUN_BOMB = 171
    EFFECT_RIFLEBLAST = 172
    EFFECT_RIFLEBLAST_MUSKETEER = 173
    EFFECT_RIFLEBLAST_OLD_POWERFUL = 174
    EFFECT_RIFLEBLAST_MODERN = 175
    EFFECT_TRANSPORT_MACHINEGUN = 176
    EFFECT_SAM_FRONT = 177
    EFFECT_SAM_EXHAUST = 178
    EFFECT_WEAPON_CANNONFIRE = 179
    EFFECT_WEAPON_CANNONFIRE_2 = 180
    EFFECT_WEAPON_CANNONFIRE_3 = 181
    EFFECT_WEAPON_CARAVEL_CANNON_01 = 182
    EFFECT_WEAPON_CARAVEL_CANNON_02 = 183
    EFFECT_WEAPON_GALLEON_CANNON_01 = 184
    EFFECT_WEAPON_GALLEON_CANNON_02 = 185
    EFFECT_WEAPON_GALLEON_CANNON_03 = 186
    EFFECT_WEAPON_FRIGATE_CANNON_01 = 187
    EFFECT_WEAPON_FRIGATE_CANNON_02 = 188
    EFFECT_WEAPON_FRIGATE_CANNON_03 = 189
    EFFECT_WEAPON_IRONCLAD_CANNON_01 = 190
    EFFECT_WEAPON_IRONCLAD_CANNON_02 = 191
    EFFECT_WEAPON_IRONCLAD_CANNON_03 = 192
    EFFECT_WEAPON_CANNONFIRE_MODERN_TANKS = 193
    EFFECT_WEAPON_CANNONFIRE_MODERN_SHIPS = 194
    EFFECT_WEAPON_DESTROYER01 = 195
    EFFECT_WEAPON_DESTROYER02 = 196
    EFFECT_WEAPON_BATTLESHIP01 = 197
    EFFECT_WEAPON_BATTLESHIP02 = 198
    EFFECT_WEAPON_CARRIER_BLAST = 199
    EFFECT_WEAPON_TORPEDO = 200
    EFFECT_WEAPON_PANZER_FIRE = 201
    EFFECT_WEAPON_CANNON_FIRE = 202
    EFFECT_WEAPON_ARTILLERY = 203
    EFFECT_WEAPON_MACHINEGUNNERY_FIRE = 204
    EFFECT_WEAPON_CANNONFIRE_MODERN_HOWITZER = 205
    EFFECT_WEAPON_MECHANIZED_INFANTRY_BLAST = 206
    EFFECT_HEALSPARKLE = 207
    EFFECT_LOTUS_BLOOM = 208
    EFFECT_PROMOTION_UNIT = 209
    EFFECT_ENEMY_GLOW_UNIT = 210
    EFFECT_PROMOTION_INTERFACE = 211
    EFFECT_CREATION = 212
    EFFECT_CREATION_BIG = 213
    EFFECT_CREATION_BIG_FAST = 214
    EFFECT_MISSIONARY_ACTIVE_BUDDHISM = 215
    EFFECT_MISSIONARY_ACTIVE_CONFUSCIAN = 216
    EFFECT_MISSIONARY_ACTIVE_CHRISTIANITY = 217
    EFFECT_MISSIONARY_ACTIVE_HINDUISM = 218
    EFFECT_MISSIONARY_ACTIVE_ISLAM = 219
    EFFECT_MISSIONARY_ACTIVE_JEWISH = 220
    EFFECT_MISSIONARY_ACTIVE_TAOISM = 221
    EFFECT_GREATPEOPLE_ACTIVE_ARTIST = 222
    EFFECT_GREATPEOPLE_BIRTH_ARTIST = 223
    EFFECT_GREATPEOPLE_HIGHLIGHT_ARTIST = 224
    EFFECT_GREATPEOPLE_ACTIVE_ENGINEER = 225
    EFFECT_GREATPEOPLE_BIRTH_ENGINEER = 226
    EFFECT_GREATPEOPLE_HIGHLIGHT_ENGINEER = 227
    EFFECT_ENGINEER_GEARS = 228
    EFFECT_GREATPEOPLE_ACTIVE_PROPHET = 229
    EFFECT_GREATPEOPLE_BIRTH_PROPHET = 230
    EFFECT_GREATPEOPLE_HIGHLIGHT_PROPHET = 231
    EFFECT_GREATPEOPLE_ACTIVE_SCIENTIST = 232
    EFFECT_GREATPEOPLE_BIRTH_SCIENTIST = 233
    EFFECT_GREATPEOPLE_HIGHLIGHT_SCIENTIST = 234
    EFFECT_GREATPEOPLE_ACTIVE_MERCHANT = 235
    EFFECT_GREATPEOPLE_BIRTH_MERCHANT = 236
    EFFECT_GREATPEOPLE_HIGHLIGHT_MERCHANT = 237
    EFFECT_GREATPEOPLE_ACTIVE_WARLORD = 238
    EFFECT_GREATPEOPLE_BIRTH_WARLORD = 239
    EFFECT_GREATPEOPLE_HIGHLIGHT_WARLORD = 240
    EFFECT_WATER_SUBMARINE_DEATH = 241
    EFFECT_SHIP_BOW_FROTH = 242
    EFFECT_SHIP_SIDE_FROTH = 243
    EFFECT_SHIP_SINKING_FROTH = 244
    EFFECT_GALLEY_SINKING_FROTH = 245
    EFFECT_GALLEY_SPLASH_PLUME_LRG = 246
    EFFECT_CARAVEL_SINKING_FROTH = 247
    EFFECT_GALLEON_SINKING_FROTH = 248
    EFFECT_IRONCLAD_SINKING_FROTH = 249
    EFFECT_TRANSPORT_SINKING_FROTH = 250
    EFFECT_FRIGATE_SINKING_FROTH = 251
    EFFECT_DESTROYER_SINKING_FROTH = 252
    EFFECT_BATTLESHIP_SINKING_FROTH = 253
    EFFECT_CARRIER_SINKING_FROTH = 254
    EFFECT_WORKBOAT_SINKING_FROTH = 255
    EFFECT_WORKBOAT_SPLASH_PLUME = 256
    EFFECT_SPLASH_PLUME_SML = 257
    EFFECT_SPLASH_PLUME_LRG = 258
    EFFECT_PROPELLER_BUBBLES = 259
    EFFECT_FOG_EMITER = 260
    EFFECT_BIRDSCATTER = 261
    FIREWORKS_RED_LARGE_SLOW = 262
    FIREWORKS_RED_SMALL_FAST = 263
    FIREWORKS_GREEN_LARGE_SLOW = 264
    FIREWORKS_GREEN_SMALL_FAST = 265
    FIREWORKS_PURPLE_LARGE_SLOW = 266
    FIREWORKS_PURPLE_SMALL_FAST = 267
    FIREWORKS_YELLOW_LARGE_SLOW = 268
    FIREWORKS_YELLOW_SMALL_FAST = 269
    FIREWORKS_BLUE_LARGE_SLOW = 270
    FIREWORKS_BLUE_SMALL_FAST = 271
    EFFECT_IMPROVEMENT_GOODYHUT_POP = 272
    EFFECT_IMPROVEMENT_CAMPFIRE = 273
    EFFECT_IMPROVEMENT_FIRE_FOOMP = 274
    EFFECT_IMPROVEMENT_STEAM = 275
    EFFECT_IMPROVEMENT_CHIMNEY_SMOKE_03 = 276
    EFFECT_IMPROVEMENT_FIREPLACE = 277
    EFFECT_FIRE_TORCH = 278
    EFFECT_FAKE_EVENT = 279
    EFFECT_SHRINE_FLAMES = 280
    EFFECT_CHIMNEY_SMOKE_01 = 281
    EFFECT_CHIMNEY_SMOKE_02 = 282
    EFFECT_CHIMNEY_SMOKE_03 = 283
    EFFECT_CITY_SMOKING_01 = 284
    EFFECT_CITY_SMOKING_02 = 285
    EFFECT_CITY_BURNING_SMOKE = 286
    EFFECT_CITY_BIG_BURNING_SMOKE = 287
    EFFECT_CITY_FIRE = 288
    EFFECT_CITY_DISEASED = 289
    EFFECT_CITY_IRRADIATED = 290
    EFFECT_MACHINEGUNFIRE_GROUND = 291
    EFFECT_MACHINEGUNFIRE_AIR___UNNEEDED = 292
    EFFECT_STEALTHBOMB = 293
    EFFECT_GALLEY_ARROWS = 294
    EFFECT_MISSILE_LARGE_HIT = 295
    EFFECT_INVASIONSHIP_SMALL_HIT = 296
    EFFECT_INVASIONSHIP_LARGE_HIT = 297
    EFFECT_INVASIONSHIP_LASER = 298
    EFFECT_INVASIONSHIP_FLAK = 299
    EFFECT_INVASIONSHIP_LASERBEAM = 300
    EFFECT_INVASIONSHIP_TORPEDO = 301
    EFFECT_INVASIONSHIP_LASERFIRE = 302
    EFFECT_INVASIONSHIP_LASERFIRESMALL = 303
    EFFECT_INVASIONSHIP_LASERFIRE_BIG = 304
    EFFECT_RED_EYELASER = 305
    EFFECT_FRONTIER_SIGNAL = 306
    EFFECT_FF_TRANSPORT = 307


class RouteType(IntEnum):  # noqa: D101
    NO_ROUTE = -1
    ROUTE_ROAD = 0
    ROUTE_RAILROAD = 1


class TechType(IntEnum):  # noqa: D101
    NO_TECH = -1
    TECH_MYSTICISM = 0
    TECH_MEDITATION = 1
    TECH_POLYTHEISM = 2
    TECH_PRIESTHOOD = 3
    TECH_MONOTHEISM = 4
    TECH_MONARCHY = 5
    TECH_LITERATURE = 6
    TECH_CODE_OF_LAWS = 7
    TECH_DRAMA = 8
    TECH_FEUDALISM = 9
    TECH_THEOLOGY = 10
    TECH_MUSIC = 11
    TECH_CIVIL_SERVICE = 12
    TECH_GUILDS = 13
    TECH_DIVINE_RIGHT = 14
    TECH_NATIONALISM = 15
    TECH_MILITARY_TRADITION = 16
    TECH_CONSTITUTION = 17
    TECH_LIBERALISM = 18
    TECH_DEMOCRACY = 19
    TECH_CORPORATION = 20
    TECH_FASCISM = 21
    TECH_UTOPIA = 22
    TECH_MASS_MEDIA = 23
    TECH_ECOLOGY = 24
    TECH_FISHING = 25
    TECH_THE_WHEEL = 26
    TECH_AGRICULTURE = 27
    TECH_POTTERY = 28
    TECH_AESTHETICS = 29
    TECH_SAILING = 30
    TECH_WRITING = 31
    TECH_MATHEMATICS = 32
    TECH_ALPHABET = 33
    TECH_CALENDAR = 34
    TECH_CURRENCY = 35
    TECH_PHILOSOPHY = 36
    TECH_PAPER = 37
    TECH_BANKING = 38
    TECH_EDUCATION = 39
    TECH_PRINTING_PRESS = 40
    TECH_ECONOMICS = 41
    TECH_ASTRONOMY = 42
    TECH_CHEMISTRY = 43
    TECH_SCIENTIFIC_METHOD = 44
    TECH_PHYSICS = 45
    TECH_BIOLOGY = 46
    TECH_MEDICINE = 47
    TECH_ELECTRICITY = 48
    TECH_COMBUSTION = 49
    TECH_FISSION = 50
    TECH_FLIGHT = 51
    TECH_ADVANCED_FLIGHT = 52
    TECH_PLASTICS = 53
    TECH_COMPOSITES = 54
    TECH_STEALTH = 55
    TECH_GENETICS = 56
    TECH_FIBER_OPTICS = 57
    TECH_FUSION = 58
    TECH_HUNTING = 59
    TECH_MINING = 60
    TECH_ARCHERY = 61
    TECH_MASONRY = 62
    TECH_ANIMAL_HUSBANDRY = 63
    TECH_BRONZE_WORKING = 64
    TECH_HORSEBACK_RIDING = 65
    TECH_IRON_WORKING = 66
    TECH_METAL_CASTING = 67
    TECH_COMPASS = 68
    TECH_CONSTRUCTION = 69
    TECH_MACHINERY = 70
    TECH_ENGINEERING = 71
    TECH_OPTICS = 72
    TECH_GUNPOWDER = 73
    TECH_REPLACEABLE_PARTS = 74
    TECH_MILITARY_SCIENCE = 75
    TECH_RIFLING = 76
    TECH_STEAM_POWER = 77
    TECH_STEEL = 78
    TECH_ASSEMBLY_LINE = 79
    TECH_RAILROAD = 80
    TECH_ARTILLERY = 81
    TECH_INDUSTRIALISM = 82
    TECH_RADIO = 83
    TECH_REFRIGERATION = 84
    TECH_SUPERCONDUCTORS = 85
    TECH_COMPUTERS = 86
    TECH_LASER = 87
    TECH_ROCKETRY = 88
    TECH_SATELLITES = 89
    TECH_ROBOTICS = 90
    TECH_FUTURE_TECH = 91


class FeatureType(IntEnum):  # noqa: D101
    NO_FEATURE = -1
    FEATURE_ICE = 0
    FEATURE_JUNGLE = 1
    FEATURE_OASIS = 2
    FEATURE_FLOOD_PLAINS = 3
    FEATURE_FOREST = 4
    FEATURE_FALLOUT = 5


class ImprovementType(IntEnum):  # noqa: D101
    NO_IMPROVEMENT = -1
    IMPROVEMENT_LAND_WORKED = 0
    IMPROVEMENT_WATER_WORKED = 1
    IMPROVEMENT_CITY_RUINS = 2
    IMPROVEMENT_GOODY_HUT = 3
    IMPROVEMENT_FARM = 4
    IMPROVEMENT_FISHING_BOATS = 5
    IMPROVEMENT_WHALING_BOATS = 6
    IMPROVEMENT_MINE = 7
    IMPROVEMENT_WORKSHOP = 8
    IMPROVEMENT_LUMBERMILL = 9
    IMPROVEMENT_WINDMILL = 10
    IMPROVEMENT_WATERMILL = 11
    IMPROVEMENT_PLANTATION = 12
    IMPROVEMENT_QUARRY = 13
    IMPROVEMENT_PASTURE = 14
    IMPROVEMENT_CAMP = 15
    IMPROVEMENT_WELL = 16
    IMPROVEMENT_OFFSHORE_PLATFORM = 17
    IMPROVEMENT_WINERY = 18
    IMPROVEMENT_COTTAGE = 19
    IMPROVEMENT_HAMLET = 20
    IMPROVEMENT_VILLAGE = 21
    IMPROVEMENT_TOWN = 22
    IMPROVEMENT_FORT = 23
    IMPROVEMENT_FOREST_PRESERVE = 24


class TerrainType(IntEnum):  # noqa: D101
    NO_TERRAIN = -1
    TERRAIN_GRASS = 0
    TERRAIN_PLAINS = 1
    TERRAIN_DESERT = 2
    TERRAIN_TUNDRA = 3
    TERRAIN_SNOW = 4
    TERRAIN_COAST = 5
    TERRAIN_OCEAN = 6
    TERRAIN_PEAK = 7
    TERRAIN_HILL = 8


class Civ4AnimationPathType(IntEnum):  # noqa: D101
    NO_CIV4_ANIMATION_PATH = -1
    ANIMATIONPATH_IDLE = 0
    ANIMATIONPATH_MOVE = 1
    ANIMATIONPATH_DAMAGE = 2
    ANIMATIONPATH_RANDOMIZE_ANIMATION_SET = 3
    ANIMATIONPATH_NUKE_STRIKE = 4
    ANIMATIONPATH_MELEE_STRIKE = 5
    ANIMATIONPATH_MELEE_HURT = 6
    ANIMATIONPATH_MELEE_DIE = 7
    ANIMATIONPATH_MELEE_FORTIFIED = 8
    ANIMATIONPATH_MELEE_DIE_FADE = 9
    ANIMATIONPATH_MELEE_FLEE = 10
    ANIMATIONPATH_RANGED_STRIKE = 11
    ANIMATIONPATH_RANGED_DIE = 12
    ANIMATIONPATH_RANGED_FORTIFIED = 13
    ANIMATIONPATH_RANGED_RUNHIT = 14
    ANIMATIONPATH_RANGED_RUNDIE = 15
    ANIMATIONPATH_RANGED_DIE_FADE = 16
    ANIMATIONPATH_LEADER_COMMAND = 17
    ANIMATIONPATH_AIRFADEIN = 18
    ANIMATIONPATH_AIRFADEOUT = 19
    ANIMATIONPATH_AIRSTRIKE = 20
    ANIMATIONPATH_AIRBOMB = 21
    ANIMATIONPATH_HEAL = 22
    ANIMATIONPATH_SLEEP = 23
    ANIMATIONPATH_FORTIFY = 24
    ANIMATIONPATH_MELEE_FORTIFY = 25
    ANIMATIONPATH_PILLAGE = 26
    ANIMATIONPATH_SENTRY = 27
    ANIMATIONPATH_FOUND = 28
    ANIMATIONPATH_IRRIGATE = 29
    ANIMATIONPATH_BUILD = 30
    ANIMATIONPATH_MINE = 31
    ANIMATIONPATH_CHOP = 32
    ANIMATIONPATH_SHOVEL = 33
    ANIMATIONPATH_RAILROAD = 34
    ANIMATIONPATH_SABOTAGE = 35
    ANIMATIONPATH_DESTROY = 36
    ANIMATIONPATH_STEAL_PLANS = 37
    ANIMATIONPATH_GREAT_EVENT = 38
    ANIMATIONPATH_SURRENDER = 39
    ANIMATIONPATH_AIRPATROL = 40


class BuildType(IntEnum):  # noqa: D101
    NO_BUILD = -1
    BUILD_ROAD = 0
    BUILD_RAILROAD = 1
    BUILD_FARM = 2
    BUILD_FISHING_BOATS = 3
    BUILD_WHALING_BOATS = 4
    BUILD_MINE = 5
    BUILD_WORKSHOP = 6
    BUILD_LUMBERMILL = 7
    BUILD_WINDMILL = 8
    BUILD_WATERMILL = 9
    BUILD_PLANTATION = 10
    BUILD_QUARRY = 11
    BUILD_PASTURE = 12
    BUILD_CAMP = 13
    BUILD_WELL = 14
    BUILD_OFFSHORE_PLATFORM = 15
    BUILD_WINERY = 16
    BUILD_COTTAGE = 17
    BUILD_FORT = 18
    BUILD_REMOVE_JUNGLE = 19
    BUILD_REMOVE_FOREST = 20
    BUILD_SCRUB_FALLOUT = 21
    BUILD_FOREST_PRESERVE = 22


class ControlType(IntEnum):  # noqa: D101
    NO_CONTROL = -1
    CONTROL_CENTERONSELECTION = 0
    CONTROL_SELECTYUNITTYPE = 1
    CONTROL_SELECTYUNITALL = 2
    CONTROL_SELECTCITY = 3
    CONTROL_SELECTCAPITAL = 4
    CONTROL_NEXTCITY = 5
    CONTROL_PREVCITY = 6
    CONTROL_NEXTUNIT = 7
    CONTROL_PREVUNIT = 8
    CONTROL_CYCLEUNIT = 9
    CONTROL_CYCLEUNIT_ALT = 10
    CONTROL_CYCLEWORKER = 11
    CONTROL_LASTUNIT = 12
    CONTROL_ENDTURN = 13
    CONTROL_ENDTURN_ALT = 14
    CONTROL_FORCEENDTURN = 15
    CONTROL_AUTOMOVES = 16
    CONTROL_PING = 17
    CONTROL_SIGN = 18
    CONTROL_GRID = 19
    CONTROL_BARE_MAP = 20
    CONTROL_YIELDS = 21
    CONTROL_RESOURCE_ALL = 22
    CONTROL_UNIT_ICONS = 23
    CONTROL_GLOBELAYER = 24
    CONTROL_SCORES = 25
    CONTROL_LOAD_GAME = 26
    CONTROL_OPTIONS_SCREEN = 27
    CONTROL_RETIRE = 28
    CONTROL_SAVE_GROUP = 29
    CONTROL_SAVE_NORMAL = 30
    CONTROL_QUICK_SAVE = 31
    CONTROL_QUICK_LOAD = 32
    CONTROL_ORTHO_CAMERA = 33
    CONTROL_CYCLE_CAMERA_FLYING_MODES = 34
    CONTROL_ISOMETRIC_CAMERA_LEFT = 35
    CONTROL_ISOMETRIC_CAMERA_RIGHT = 36
    CONTROL_FLYING_CAMERA = 37
    CONTROL_MOUSE_FLYING_CAMERA = 38
    CONTROL_TOP_DOWN_CAMERA = 39
    CONTROL_CIVILOPEDIA = 40
    CONTROL_RELIGION_SCREEN = 41
    CONTROL_CORPORATION_SCREEN = 42
    CONTROL_CIVICS_SCREEN = 43
    CONTROL_FOREIGN_SCREEN = 44
    CONTROL_FINANCIAL_SCREEN = 45
    CONTROL_MILITARY_SCREEN = 46
    CONTROL_TECH_CHOOSER = 47
    CONTROL_TURN_LOG = 48
    CONTROL_CHAT_ALL = 49
    CONTROL_CHAT_TEAM = 50
    CONTROL_DOMESTIC_SCREEN = 51
    CONTROL_VICTORY_SCREEN = 52
    CONTROL_INFO = 53
    CONTROL_GLOBE_VIEW = 54
    CONTROL_DETAILS = 55
    CONTROL_ADMIN_DETAILS = 56
    CONTROL_HALL_OF_FAME = 57
    CONTROL_WORLD_BUILDER = 58
    CONTROL_DIPLOMACY = 59
    CONTROL_SELECT_HEALTHY = 60
    CONTROL_ESPIONAGE_SCREEN = 61
    CONTROL_FREE_COLONY = 62


class Civ4EntityEventType(IntEnum):  # noqa: D101
    NO_CIV4_ENTITY_EVENT = -1
    ENTITY_EVENT_IDLE = 0
    ENTITY_EVENT_DIE = 1
    ENTITY_EVENT_DAMAGE = 2
    ENTITY_EVENT_BEGIN_COMBAT = 3
    ENTITY_EVENT_END_COMBAT = 4
    ENTITY_EVENT_SURRENDER = 5
    ENTITY_EVENT_CAPTURED = 6
    ENTITY_EVENT_AIRPATROL = 7
    ENTITY_EVENT_AIRINTERCEPTION = 8
    ENTITY_EVENT_AIRBOMB = 9
    ENTITY_EVENT_PARADROP = 10
    ENTITY_EVENT_AIRSTRIKE = 11
    ENTITY_EVENT_AIRRECON = 12
    ENTITY_EVENT_NUKE = 13
    ENTITY_EVENT_MULTI_SELECT = 14
    ENTITY_EVENT_MULTI_DESELECT = 15
    ENTITY_EVENT_GREAT_EVENT = 16
    ENTITY_EVENT_PILLAGE = 17
    ENTITY_EVENT_SABOTAGE = 18
    ENTITY_EVENT_DESTROY = 19
    ENTITY_EVENT_STEAL_PLANS = 20
    ENTITY_EVENT_BOMBARD = 21
    ENTITY_EVENT_DIE_ANIMATION = 22
    ENTITY_EVENT_FOUND = 23
    ENTITY_EVENT_FORTIFY = 24
    ENTITY_EVENT_SENTRY = 25
    ENTITY_EVENT_HEAL = 26
    ENTITY_EVENT_SLEEP = 27
    ENTITY_EVENT_SHOVEL = 28
    ENTITY_EVENT_BUILD = 29
    ENTITY_EVENT_IRRIGATE = 30
    ENTITY_EVENT_MINE = 31
    ENTITY_EVENT_CHOP = 32
    ENTITY_EVENT_RAILROAD = 33


class MissionType(IntEnum):  # noqa: D101
    NO_MISSION = -1
    MISSION_MOVE_TO = 0
    MISSION_ROUTE_TO = 1
    MISSION_MOVE_TO_UNIT = 2
    MISSION_SKIP = 3
    MISSION_SLEEP = 4
    MISSION_FORTIFY = 5
    MISSION_PLUNDER = 6
    MISSION_AIRPATROL = 7
    MISSION_SEAPATROL = 8
    MISSION_HEAL = 9
    MISSION_SENTRY = 10
    MISSION_AIRLIFT = 11
    MISSION_NUKE = 12
    MISSION_RECON = 13
    MISSION_PARADROP = 14
    MISSION_AIRBOMB = 15
    MISSION_RANGE_ATTACK = 16
    MISSION_BOMBARD = 17
    MISSION_PILLAGE = 18
    MISSION_SABOTAGE = 19
    MISSION_DESTROY = 20
    MISSION_STEAL_PLANS = 21
    MISSION_FOUND = 22
    MISSION_SPREAD = 23
    MISSION_SPREAD_CORPORATION = 24
    MISSION_JOIN = 25
    MISSION_CONSTRUCT = 26
    MISSION_DISCOVER = 27
    MISSION_HURRY = 28
    MISSION_TRADE = 29
    MISSION_GREAT_WORK = 30
    MISSION_INFILTRATE = 31
    MISSION_GOLDEN_AGE = 32
    MISSION_BUILD = 33
    MISSION_LEAD = 34
    MISSION_ESPIONAGE = 35
    MISSION_DIE_ANIMATION = 36
    MISSION_BEGIN_COMBAT = 37
    MISSION_END_COMBAT = 38
    MISSION_AIRSTRIKE = 39
    MISSION_SURRENDER = 40
    MISSION_CAPTURED = 41
    MISSION_IDLE = 42
    MISSION_DIE = 43
    MISSION_DAMAGE = 44
    MISSION_MULTI_SELECT = 45
    MISSION_MULTI_DESELECT = 46


class PromotionType(IntEnum):  # noqa: D101
    NO_PROMOTION = -1
    PROMOTION_COMBAT1 = 0
    PROMOTION_COMBAT2 = 1
    PROMOTION_COMBAT3 = 2
    PROMOTION_COMBAT4 = 3
    PROMOTION_COMBAT5 = 4
    PROMOTION_COVER = 5
    PROMOTION_SHOCK = 6
    PROMOTION_PINCH = 7
    PROMOTION_FORMATION = 8
    PROMOTION_CHARGE = 9
    PROMOTION_AMBUSH = 10
    PROMOTION_AMPHIBIOUS = 11
    PROMOTION_MARCH = 12
    PROMOTION_BLITZ = 13
    PROMOTION_COMMANDO = 14
    PROMOTION_MEDIC1 = 15
    PROMOTION_MEDIC2 = 16
    PROMOTION_GUERILLA1 = 17
    PROMOTION_GUERILLA2 = 18
    PROMOTION_GUERILLA3 = 19
    PROMOTION_WOODSMAN1 = 20
    PROMOTION_WOODSMAN2 = 21
    PROMOTION_WOODSMAN3 = 22
    PROMOTION_CITY_RAIDER1 = 23
    PROMOTION_CITY_RAIDER2 = 24
    PROMOTION_CITY_RAIDER3 = 25
    PROMOTION_CITY_GARRISON1 = 26
    PROMOTION_CITY_GARRISON2 = 27
    PROMOTION_CITY_GARRISON3 = 28
    PROMOTION_DRILL1 = 29
    PROMOTION_DRILL2 = 30
    PROMOTION_DRILL3 = 31
    PROMOTION_DRILL4 = 32
    PROMOTION_BARRAGE1 = 33
    PROMOTION_BARRAGE2 = 34
    PROMOTION_BARRAGE3 = 35
    PROMOTION_ACCURACY = 36
    PROMOTION_FLANKING1 = 37
    PROMOTION_FLANKING2 = 38
    PROMOTION_SENTRY = 39
    PROMOTION_MOBILITY = 40
    PROMOTION_NAVIGATION1 = 41
    PROMOTION_NAVIGATION2 = 42
    PROMOTION_LEADER = 43
    PROMOTION_LEADERSHIP = 44
    PROMOTION_TACTICS = 45
    PROMOTION_COMBAT6 = 46
    PROMOTION_MORALE = 47
    PROMOTION_MEDIC3 = 48
    PROMOTION_RANGE1 = 49
    PROMOTION_RANGE2 = 50
    PROMOTION_INTERCEPTION1 = 51
    PROMOTION_INTERCEPTION2 = 52
    PROMOTION_ACE = 53


class SpecialUnitType(IntEnum):  # noqa: D101
    NO_SPECIAL_UNIT = -1
    SPECIALUNIT_FIGHTER = 0
    SPECIALUNIT_PEOPLE = 1
    SPECIALUNIT_MISSILE = 2


class UnitClassType(IntEnum):  # noqa: D101
    NO_UNIT_CLASS = -1
    UNITCLASS_LION = 0
    UNITCLASS_BEAR = 1
    UNITCLASS_PANTHER = 2
    UNITCLASS_WOLF = 3
    UNITCLASS_SETTLER = 4
    UNITCLASS_WORKER = 5
    UNITCLASS_SCOUT = 6
    UNITCLASS_EXPLORER = 7
    UNITCLASS_SPY = 8
    UNITCLASS_EXECUTIVE_1 = 9
    UNITCLASS_EXECUTIVE_2 = 10
    UNITCLASS_EXECUTIVE_3 = 11
    UNITCLASS_EXECUTIVE_4 = 12
    UNITCLASS_EXECUTIVE_5 = 13
    UNITCLASS_EXECUTIVE_6 = 14
    UNITCLASS_EXECUTIVE_7 = 15
    UNITCLASS_JEWISH_MISSIONARY = 16
    UNITCLASS_CHRISTIAN_MISSIONARY = 17
    UNITCLASS_ISLAMIC_MISSIONARY = 18
    UNITCLASS_HINDU_MISSIONARY = 19
    UNITCLASS_BUDDHIST_MISSIONARY = 20
    UNITCLASS_CONFUCIAN_MISSIONARY = 21
    UNITCLASS_TAOIST_MISSIONARY = 22
    UNITCLASS_WARRIOR = 23
    UNITCLASS_SWORDSMAN = 24
    UNITCLASS_AXEMAN = 25
    UNITCLASS_MACEMAN = 26
    UNITCLASS_SPEARMAN = 27
    UNITCLASS_PIKEMAN = 28
    UNITCLASS_MUSKETMAN = 29
    UNITCLASS_RIFLEMAN = 30
    UNITCLASS_GRENADIER = 31
    UNITCLASS_INFANTRY = 32
    UNITCLASS_AT_INFANTRY = 33
    UNITCLASS_SAM_INFANTRY = 34
    UNITCLASS_MOBILE_SAM = 35
    UNITCLASS_MARINE = 36
    UNITCLASS_PARATROOPER = 37
    UNITCLASS_MECHANIZED_INFANTRY = 38
    UNITCLASS_ARCHER = 39
    UNITCLASS_LONGBOWMAN = 40
    UNITCLASS_CROSSBOWMAN = 41
    UNITCLASS_CHARIOT = 42
    UNITCLASS_HORSE_ARCHER = 43
    UNITCLASS_KNIGHT = 44
    UNITCLASS_CUIRASSIER = 45
    UNITCLASS_CAVALRY = 46
    UNITCLASS_WAR_ELEPHANT = 47
    UNITCLASS_TANK = 48
    UNITCLASS_MODERN_ARMOR = 49
    UNITCLASS_GUNSHIP = 50
    UNITCLASS_CATAPULT = 51
    UNITCLASS_TREBUCHET = 52
    UNITCLASS_CANNON = 53
    UNITCLASS_MACHINE_GUN = 54
    UNITCLASS_ARTILLERY = 55
    UNITCLASS_MOBILE_ARTILLERY = 56
    UNITCLASS_WORKBOAT = 57
    UNITCLASS_GALLEY = 58
    UNITCLASS_TRIREME = 59
    UNITCLASS_CARAVEL = 60
    UNITCLASS_GALLEON = 61
    UNITCLASS_PRIVATEER = 62
    UNITCLASS_FRIGATE = 63
    UNITCLASS_SHIP_OF_THE_LINE = 64
    UNITCLASS_IRONCLAD = 65
    UNITCLASS_TRANSPORT = 66
    UNITCLASS_DESTROYER = 67
    UNITCLASS_STEALTH_DESTROYER = 68
    UNITCLASS_BATTLESHIP = 69
    UNITCLASS_MISSILE_CRUISER = 70
    UNITCLASS_SUBMARINE = 71
    UNITCLASS_ATTACK_SUBMARINE = 72
    UNITCLASS_CARRIER = 73
    UNITCLASS_AIRSHIP = 74
    UNITCLASS_FIGHTER = 75
    UNITCLASS_JET_FIGHTER = 76
    UNITCLASS_BOMBER = 77
    UNITCLASS_STEALTH_BOMBER = 78
    UNITCLASS_GUIDED_MISSILE = 79
    UNITCLASS_ICBM = 80
    UNITCLASS_TACTICAL_NUKE = 81
    UNITCLASS_PROPHET = 82
    UNITCLASS_ARTIST = 83
    UNITCLASS_SCIENTIST = 84
    UNITCLASS_MERCHANT = 85
    UNITCLASS_ENGINEER = 86
    UNITCLASS_GREAT_GENERAL = 87
    UNITCLASS_GREAT_SPY = 88


class UnitType(IntEnum):  # noqa: D101
    NO_UNIT = -1
    UNIT_LION = 0
    UNIT_BEAR = 1
    UNIT_PANTHER = 2
    UNIT_WOLF = 3
    UNIT_SETTLER = 4
    UNIT_WORKER = 5
    UNIT_INDIAN_FAST_WORKER = 6
    UNIT_SCOUT = 7
    UNIT_EXPLORER = 8
    UNIT_SPY = 9
    UNIT_EXECUTIVE_1 = 10
    UNIT_EXECUTIVE_2 = 11
    UNIT_EXECUTIVE_3 = 12
    UNIT_EXECUTIVE_4 = 13
    UNIT_EXECUTIVE_5 = 14
    UNIT_EXECUTIVE_6 = 15
    UNIT_EXECUTIVE_7 = 16
    UNIT_JEWISH_MISSIONARY = 17
    UNIT_CHRISTIAN_MISSIONARY = 18
    UNIT_ISLAMIC_MISSIONARY = 19
    UNIT_HINDU_MISSIONARY = 20
    UNIT_BUDDHIST_MISSIONARY = 21
    UNIT_CONFUCIAN_MISSIONARY = 22
    UNIT_TAOIST_MISSIONARY = 23
    UNIT_WARRIOR = 24
    UNIT_INCAN_QUECHUA = 25
    UNIT_SWORDSMAN = 26
    UNIT_AZTEC_JAGUAR = 27
    UNIT_CELTIC_GALLIC_WARRIOR = 28
    UNIT_ROME_PRAETORIAN = 29
    UNIT_AXEMAN = 30
    UNIT_GREEK_PHALANX = 31
    UNIT_SUMERIAN_VULTURE = 32
    UNIT_NATIVE_AMERICA_DOG_SOLDIER = 33
    UNIT_MACEMAN = 34
    UNIT_JAPAN_SAMURAI = 35
    UNIT_VIKING_BESERKER = 36
    UNIT_SPEARMAN = 37
    UNIT_ZULU_IMPI = 38
    UNIT_MAYA_HOLKAN = 39
    UNIT_PIKEMAN = 40
    UNIT_HOLY_ROMAN_LANDSKNECHT = 41
    UNIT_MUSKETMAN = 42
    UNIT_FRENCH_MUSKETEER = 43
    UNIT_OTTOMAN_JANISSARY = 44
    UNIT_ETHIOPIAN_OROMO_WARRIOR = 45
    UNIT_RIFLEMAN = 46
    UNIT_ENGLISH_REDCOAT = 47
    UNIT_GRENADIER = 48
    UNIT_AT_INFANTRY = 49
    UNIT_INFANTRY = 50
    UNIT_SAM_INFANTRY = 51
    UNIT_MOBILE_SAM = 52
    UNIT_MARINE = 53
    UNIT_AMERICAN_NAVY_SEAL = 54
    UNIT_PARATROOPER = 55
    UNIT_MECHANIZED_INFANTRY = 56
    UNIT_ARCHER = 57
    UNIT_MALI_SKIRMISHER = 58
    UNIT_BABYLON_BOWMAN = 59
    UNIT_LONGBOWMAN = 60
    UNIT_CROSSBOWMAN = 61
    UNIT_CHINA_CHOKONU = 62
    UNIT_CHARIOT = 63
    UNIT_EGYPT_WARCHARIOT = 64
    UNIT_PERSIA_IMMORTAL = 65
    UNIT_HORSE_ARCHER = 66
    UNIT_CARTHAGE_NUMIDIAN_CAVALRY = 67
    UNIT_MONGOL_KESHIK = 68
    UNIT_KNIGHT = 69
    UNIT_ARABIA_CAMELARCHER = 70
    UNIT_BYZANTINE_CATAPHRACT = 71
    UNIT_SPANISH_CONQUISTADOR = 72
    UNIT_CUIRASSIER = 73
    UNIT_CAVALRY = 74
    UNIT_RUSSIA_COSSACK = 75
    UNIT_WAR_ELEPHANT = 76
    UNIT_KHMER_BALLISTA_ELEPHANT = 77
    UNIT_TANK = 78
    UNIT_GERMAN_PANZER = 79
    UNIT_MODERN_ARMOR = 80
    UNIT_GUNSHIP = 81
    UNIT_CATAPULT = 82
    UNIT_KOREAN_HWACHA = 83
    UNIT_TREBUCHET = 84
    UNIT_CANNON = 85
    UNIT_MACHINE_GUN = 86
    UNIT_ARTILLERY = 87
    UNIT_MOBILE_ARTILLERY = 88
    UNIT_WORKBOAT = 89
    UNIT_GALLEY = 90
    UNIT_TRIREME = 91
    UNIT_CARAVEL = 92
    UNIT_PORTUGAL_CARRACK = 93
    UNIT_GALLEON = 94
    UNIT_NETHERLANDS_OOSTINDIEVAARDER = 95
    UNIT_PRIVATEER = 96
    UNIT_FRIGATE = 97
    UNIT_SHIP_OF_THE_LINE = 98
    UNIT_IRONCLAD = 99
    UNIT_TRANSPORT = 100
    UNIT_DESTROYER = 101
    UNIT_BATTLESHIP = 102
    UNIT_MISSILE_CRUISER = 103
    UNIT_STEALTH_DESTROYER = 104
    UNIT_SUBMARINE = 105
    UNIT_ATTACK_SUBMARINE = 106
    UNIT_CARRIER = 107
    UNIT_AIRSHIP = 108
    UNIT_FIGHTER = 109
    UNIT_JET_FIGHTER = 110
    UNIT_BOMBER = 111
    UNIT_STEALTH_BOMBER = 112
    UNIT_GUIDED_MISSILE = 113
    UNIT_TACTICAL_NUKE = 114
    UNIT_ICBM = 115
    UNIT_PROPHET = 116
    UNIT_ARTIST = 117
    UNIT_SCIENTIST = 118
    UNIT_MERCHANT = 119
    UNIT_ENGINEER = 120
    UNIT_GREAT_GENERAL = 121
    UNIT_GREAT_SPY = 122


class TraitType(IntEnum):  # noqa: D101
    NO_TRAIT = -1
    TRAIT_PHILOSOPHICAL = 0
    TRAIT_AGGRESSIVE = 1
    TRAIT_SPIRITUAL = 2
    TRAIT_EXPANSIVE = 3
    TRAIT_INDUSTRIOUS = 4
    TRAIT_CREATIVE = 5
    TRAIT_FINANCIAL = 6
    TRAIT_ORGANIZED = 7
    TRAIT_CHARISMATIC = 8
    TRAIT_PROTECTIVE = 9
    TRAIT_IMPERIALIST = 10


class ProcessType(IntEnum):  # noqa: D101
    NO_PROCESS = -1
    PROCESS_WEALTH = 0
    PROCESS_RESEARCH = 1
    PROCESS_CULTURE = 2


class BonusType(IntEnum):  # noqa: D101
    NO_BONUS = -1
    BONUS_ALUMINUM = 0
    BONUS_COAL = 1
    BONUS_COPPER = 2
    BONUS_HORSE = 3
    BONUS_IRON = 4
    BONUS_MARBLE = 5
    BONUS_OIL = 6
    BONUS_STONE = 7
    BONUS_URANIUM = 8
    BONUS_BANANA = 9
    BONUS_CLAM = 10
    BONUS_CORN = 11
    BONUS_COW = 12
    BONUS_CRAB = 13
    BONUS_DEER = 14
    BONUS_FISH = 15
    BONUS_PIG = 16
    BONUS_RICE = 17
    BONUS_SHEEP = 18
    BONUS_WHEAT = 19
    BONUS_DYE = 20
    BONUS_FUR = 21
    BONUS_GEMS = 22
    BONUS_GOLD = 23
    BONUS_INCENSE = 24
    BONUS_IVORY = 25
    BONUS_SILK = 26
    BONUS_SILVER = 27
    BONUS_SPICES = 28
    BONUS_SUGAR = 29
    BONUS_WINE = 30
    BONUS_WHALE = 31
    BONUS_DRAMA = 32
    BONUS_MUSIC = 33
    BONUS_MOVIES = 34


class CivicOptionType(IntEnum):  # noqa: D101
    NO_CIVIC_OPTION = -1
    CIVICOPTION_GOVERNMENT = 0
    CIVICOPTION_LEGAL = 1
    CIVICOPTION_LABOR = 2
    CIVICOPTION_ECONOMY = 3
    CIVICOPTION_RELIGION = 4


class ClimateType(IntEnum):  # noqa: D101
    NO_CLIMATE = -1
    CLIMATE_TEMPERATE = 0
    CLIMATE_TROPICAL = 1
    CLIMATE_ARID = 2
    CLIMATE_ROCKY = 3
    CLIMATE_COLD = 4


class CultureLevelType(IntEnum):  # noqa: D101
    NO_CULTURE_LEVEL = -1
    CULTURELEVEL_NONE = 0
    CULTURELEVEL_POOR = 1
    CULTURELEVEL_FLEDGLING = 2
    CULTURELEVEL_DEVELOPING = 3
    CULTURELEVEL_REFINED = 4
    CULTURELEVEL_INFLUENTIAL = 5
    CULTURELEVEL_LEGENDARY = 6


class EmphasizeType(IntEnum):  # noqa: D101
    NO_EMPHASIZE = -1
    EMPHASIZE_FOOD = 0
    EMPHASIZE_PRODUCTION = 1
    EMPHASIZE_COMMERCE = 2
    EMPHASIZE_RESEARCH = 3
    EMPHASIZE_GREAT_PEOPLE = 4
    EMPHASIZE_AVOID_GROWTH = 5


class GoodyType(IntEnum):  # noqa: D101
    NO_GOODY = -1
    GOODY_LOW_GOLD = 0
    GOODY_HIGH_GOLD = 1
    GOODY_MAP = 2
    GOODY_SETTLER = 3
    GOODY_WARRIOR = 4
    GOODY_SCOUT = 5
    GOODY_WORKER = 6
    GOODY_EXPERIENCE = 7
    GOODY_HEALING = 8
    GOODY_TECH = 9
    GOODY_BARBARIANS_WEAK = 10
    GOODY_BARBARIANS_STRONG = 11


class HurryType(IntEnum):  # noqa: D101
    NO_HURRY = -1
    HURRY_POPULATION = 0
    HURRY_GOLD = 1


class SeaLevelType(IntEnum):  # noqa: D101
    NO_SEA_LEVEL = -1
    SEALEVEL_LOW = 0
    SEALEVEL_MEDIUM = 1
    SEALEVEL_HIGH = 2


class TurnTimerType(IntEnum):  # noqa: D101
    NO_TURN_TIMER = -1
    TURNTIMER_STATIC = 0
    TURNTIMER_SNAIL = 1
    TURNTIMER_SLOW = 2
    TURNTIMER_MEDIUM = 3
    TURNTIMER_FAST = 4
    TURNTIMER_BLAZING = 5


class UpKeepType(IntEnum):  # noqa: D101
    NO_UP_KEEP = -1
    UPKEEP_LOW = 0
    UPKEEP_MEDIUM = 1
    UPKEEP_HIGH = 2


class AdvisorType(IntEnum):  # noqa: D101
    NO_ADVISOR = -1
    ADVISOR_MILITARY = 0
    ADVISOR_RELIGION = 1
    ADVISOR_ECONOMY = 2
    ADVISOR_SCIENCE = 3
    ADVISOR_CULTURE = 4
    ADVISOR_GROWTH = 5


class BonusClassType(IntEnum):  # noqa: D101
    NO_BONUS_CLASS = -1
    BONUSCLASS_GENERAL = 0
    BONUSCLASS_GRAIN = 1
    BONUSCLASS_LIVESTOCK = 2
    BONUSCLASS_RUSH = 3
    BONUSCLASS_MODERN = 4
    BONUSCLASS_WONDER = 5


class YieldType(IntEnum):  # noqa: D101
    NO_YIELD = -1
    YIELD_FOOD = 0
    YIELD_PRODUCTION = 1
    YIELD_COMMERCE = 2


class CommandType(IntEnum):  # noqa: D101
    NO_COMMAND = -1
    COMMAND_PROMOTION = 0
    COMMAND_UPGRADE = 1
    COMMAND_AUTOMATE = 2
    COMMAND_WAKE = 3
    COMMAND_CANCEL = 4
    COMMAND_CANCEL_ALL = 5
    COMMAND_STOP_AUTOMATION = 6
    COMMAND_DELETE = 7
    COMMAND_GIFT = 8
    COMMAND_LOAD = 9
    COMMAND_LOAD_UNIT = 10
    COMMAND_UNLOAD = 11
    COMMAND_UNLOAD_ALL = 12
    COMMAND_HOTKEY = 13


class AreaAIType(IntEnum):  # noqa: D101
    NO_AREAAI = -1
    AREAAI_OFFENSIVE = 0
    AREAAI_DEFENSIVE = 1
    AREAAI_MASSING = 2
    AREAAI_ASSAULT = 3
    AREAAI_ASSAULT_MASSING = 4
    AREAAI_ASSAULT_ASSIST = 5
    AREAAI_NEUTRAL = 6
