# coding: utf-8

"""
    Neuronpedia - Inference Server

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1.1.0
    Contact: johnny@neuronpedia.org
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from neuronpedia_inference_client.models.np_feature import NPFeature
from typing import Optional, Set
from typing_extensions import Self

class UtilSaeTopkByDecoderCossimPostRequest(BaseModel):
    """
    UtilSaeTopkByDecoderCossimPostRequest
    """ # noqa: E501
    feature: Optional[NPFeature] = None
    vector: Optional[List[Union[StrictFloat, StrictInt]]] = Field(default=None, description="Custom vector to find the top features by cossim for.")
    model: StrictStr = Field(description="Model to compare the vector or feature against.")
    source: StrictStr = Field(description="Source/SAE ID to compare the vector or feature against.")
    num_results: StrictInt
    __properties: ClassVar[List[str]] = ["feature", "vector", "model", "source", "num_results"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UtilSaeTopkByDecoderCossimPostRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of feature
        if self.feature:
            _dict['feature'] = self.feature.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UtilSaeTopkByDecoderCossimPostRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "feature": NPFeature.from_dict(obj["feature"]) if obj.get("feature") is not None else None,
            "vector": obj.get("vector"),
            "model": obj.get("model"),
            "source": obj.get("source"),
            "num_results": obj.get("num_results")
        })
        return _obj


